var __create = Object.create;
var __getProtoOf = Object.getPrototypeOf;
var __defProp = Object.defineProperty;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __toESM = (mod, isNodeMode, target) => {
  target = mod != null ? __create(__getProtoOf(mod)) : {};
  const to = isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target;
  for (let key of __getOwnPropNames(mod))
    if (!__hasOwnProp.call(to, key))
      __defProp(to, key, {
        get: () => mod[key],
        enumerable: true
      });
  return to;
};
var __moduleCache = /* @__PURE__ */ new WeakMap;
var __toCommonJS = (from) => {
  var entry = __moduleCache.get(from), desc;
  if (entry)
    return entry;
  entry = __defProp({}, "__esModule", { value: true });
  if (from && typeof from === "object" || typeof from === "function")
    __getOwnPropNames(from).map((key) => !__hasOwnProp.call(entry, key) && __defProp(entry, key, {
      get: () => from[key],
      enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
    }));
  __moduleCache.set(from, entry);
  return entry;
};
var __commonJS = (cb, mod) => () => (mod || cb((mod = { exports: {} }).exports, mod), mod.exports);
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, {
      get: all[name],
      enumerable: true,
      configurable: true,
      set: (newValue) => all[name] = () => newValue
    });
};
var __esm = (fn, res) => () => (fn && (res = fn(fn = 0)), res);

// src/prospector/config/config.json
var require_config = __commonJS((exports, module) => {
  module.exports = {
    configUserDefault: {
      locale: "en-us",
      prices: {
        listMode: "sectioned-by-venue",
        internet: "visible",
        brickAndMortar: "visible",
        used: "visible",
        internetOutOfStock: "hidden",
        marketplace: "visible",
        unverifiedPrices: "hidden",
        unverifiedRetailers: "visible",
        auctions: "hidden"
      }
    },
    maxCachedOffersToVerify: 100,
    maxDefaultMinerOffersToVerifyFromFallbacks: 5,
    timeoutExpeditionsMilliseconds: 41000,
    timeoutExpeditionsMillisecondsBun: 62000,
    timeoutExpeditionsMillisecondsBackground: 41000,
    timeoutExpeditionsInDevelopmentMilliseconds: 600000,
    timeoutExpeditionsInStagingMilliseconds: 600000,
    timeoutVerifyIndividualCachedOfferInMilliseconds: 15000,
    timeoutRequestsInMilliseconds: 8000,
    timeoutFetchFinalURLInMillisecondsDefault: 5000,
    progressExtraAmounts: [
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      2,
      2,
      2,
      2,
      4,
      4,
      4,
      5
    ],
    progressStepRotationIntervalMilliseconds: 400,
    linksUnprovenIgnoreMatching: [
      "ebay.",
      "shopping/ratings/account/metrics"
    ],
    potentialIdentificationMineralsInvalidTitlesMatching: [
      "no title available"
    ],
    reportMaxCachedOffers: 500,
    reportDealSubheadlineTruncateAfterCharacters: 140,
    reportIgnoreRetailersMatching: [
      "cozycomfortso",
      "aliexpress",
      "dealscout"
    ],
    retailerRatingQualityThreshold: 0.2,
    retailerIdentifiersCrucial: [
      "amazon",
      "walmart",
      "bestbuy",
      "target"
    ],
    reportRetailersHideMatchingSearch: [
      "university of",
      " university",
      " bookstore",
      "youtube",
      "greentoe",
      "portal",
      "hibid",
      "offerup",
      "dealscout",
      "zola",
      "healthymeliving",
      "froothie",
      "desertcart.bo",
      "3gorillas",
      "facebook",
      "dexterclearance",
      "tiktok",
      "twitter",
      "pinterest",
      "craigslist",
      "letgo",
      "mercari",
      "nextdoor",
      "5miles",
      "vinted",
      "poshmark",
      "instagram",
      "reddit",
      "snapchat",
      "linkedin",
      "tumblr",
      "college bookstore",
      ".edu",
      "campus store",
      "school bookstore",
      "aliexpress",
      "alibaba",
      "wish.com",
      "dhgate",
      "banggood",
      "gearbest",
      "joom",
      "shopgoodwill",
      "propertyroom",
      "govdeals",
      "proxibid",
      "liveauctioneers",
      "classifieds",
      "auction",
      ".wiki",
      "forum",
      "discussion",
      "blog",
      "desertcart.",
      "global.shopping",
      "chinabrands",
      "etsy",
      "shopify",
      "bigcartel",
      "storenvy",
      "howardcomputers",
      "howardhughes",
      "grooves-inc",
      "anthropologie",
      "quill",
      "sierra",
      "dungarees",
      "buya",
      "very.co.uk",
      "istyle.ae",
      "threads.net",
      "twitter.com",
      "facebook.com",
      "instagram.com",
      "pinterest.com",
      "linkedin.com",
      "tiktok.com",
      "snapchat.com",
      "support.apple.com",
      "cpubenchmark",
      "ca.insight.com",
      "cdw.ca",
      "cityshop.com.pk",
      "tomshardware.com",
      "atharcomputer.com",
      "govgroup.com",
      "webcortex",
      "blazinglydiscounts",
      "university-of",
      "swingcomputers",
      "soundcityavu",
      "K-Mart ->",
      "slickdeals",
      "deals",
      "dealnews",
      "shopping.yahoo.com",
      "nothingbutsavings",
      "sell2bbnovelties",
      "babyquip",
      "mynavyexchange",
      "neobits",
      "edealinfo",
      "888lots",
      "made-in-china",
      "provantage",
      "made appliance",
      "tbnym",
      "branzoe",
      "networkhardwares.com",
      "electricset.",
      "myshopify",
      "nascoonline",
      "editorialist",
      "shipt",
      "dolby.com",
      ".shop",
      " Store",
      " Shop",
      "My Store",
      "foticut",
      "josephmyrtl",
      "virtualbox",
      "valueelectronics",
      "financemycart",
      "a.co",
      "tomsguide",
      "layaway",
      "wave-electronics",
      "kingsgreatbuys",
      "grandappliances",
      "donstv",
      "spencerstv",
      "billsmith",
      "distribution",
      ".us",
      "sargentappliance",
      "stewartappliance",
      "jefflynch",
      "extremeelectronics",
      "schaeferstv.com",
      "dshomeappliances.com",
      "AztecC.com",
      "jonesapplianceandtv.com",
      "whathifi",
      "adiglobaldistribution",
      "The HDTV Spot",
      "thehdtvspot",
      "senzigs",
      "brickseek",
      ".africa",
      "amazingbargains",
      "stockx",
      "reebelo",
      "Reebelo",
      "Reebelo USA",
      "pricehistory",
      "pricehistory.app",
      "specialized1",
      "flyingbaguette",
      "Casacaete",
      "body essentials",
      "mapappdigital",
      "taotravel365",
      "margaretvillebarn",
      "solisdepot",
      "Everythingsmart",
      "casacaeta",
      "uismartsolutions",
      "beyondcheap",
      "3aservices",
      "camelcamelcamel",
      "camelcamel",
      "B&Q",
      "nytimes",
      "galaxyaerospace",
      "hexacademy",
      "certappl",
      "androidpolice"
    ],
    reportURLsHideMatchingSearching: [
      "apple.com/lae",
      "/lae/",
      "/config/",
      "/specs/",
      "/c/kp/",
      "joesge.com",
      "paymore",
      "dealsgridays.shop",
      "business.walmart.com",
      "/videos/",
      "rcwilley.com/Sony/Electronics/TVs/OLED/Search",
      "pricehistory.app",
      "otf.ro",
      ".tour",
      "galaxyaerospace",
      "hexacademy.in",
      "certappl.com"
    ],
    reportOffersConsiderUnverifiedAfterDays: 7,
    reportOffersConsiderUnverifiedAfterDaysForPopularRetailers: 64,
    reportRetailerRatingHighIfGreaterThan: 0.8,
    reportRetailerRatingLowIfLowerThan: 0.6,
    reportMarketplaceSellerRatingHighIfGreaterThan: 0.8,
    reportMarketplaceSellerRatingLowIfLowerThan: 0.6,
    reportDetailsHideMatchingSearch: [
      "quality",
      "clarity",
      "good",
      "vivid colors",
      "easy",
      "convienent",
      "attractive",
      "doesn't",
      "quiet",
      "sale"
    ],
    domainsIgnoreFromAggregatorsExceptForIdentification: [
      "amazon.",
      "ebay."
    ],
    domainsOfferURLWrappers: [
      "klarna.",
      "google."
    ],
    domainsOfferWrappers: [
      "picclick.at",
      "picclick.be",
      "picclick.be",
      "picclick.ca",
      "picclick.ch",
      "picclick.co.uk",
      "picclick.com.au",
      "picclick.com.hk",
      "picclick.com.my",
      "picclick.com.sg",
      "picclick.com",
      "picclick.de",
      "picclick.es",
      "picclick.fr",
      "picclick.ie",
      "picclick.it",
      "picclick.nl",
      "picclick.ph",
      "picclick.pl",
      "bkstr.com",
      "hometheaterreview.com"
    ],
    domainsIgnoredForAdvancedAggregatorMining: [
      "bkstr.com",
      "hometheaterreview.com"
    ],
    domainsIgnoredForComparisonExpeditions: [
      "google",
      "legalzoom",
      "localhost:",
      "shopsavvy.com"
    ],
    shouldSendToRefineryForSources: [
      "ios",
      "android",
      "shopsavvy",
      "refinery",
      "development",
      "definition-sampler",
      "default-sample"
    ],
    limitMaxSearchResultsToConsiderFromAggregators: 10,
    limitMaxDirectThirdPartySearchResultsToConsiderFromAggregators: 10,
    limitMinPercentWordsSharedForConsideringSearchResultFromAggregator: 0.2,
    limitMinPercentWordsSharedForConsideringSearchResultFromDirectScouts: 0.2
  };
});

// src/prospector/verb-miner-definitions-get-all-generated.ts
function verbMinerDefinitionsGetAll() {
  return [
    {
      id: "4wd",
      name: "4wd",
      category_tags: [
        "automotive"
      ],
      base: "4wd.com",
      paths: [
        "\\/p\\/[^-]+-(?<identifier>[^_]+)"
      ],
      ore: {
        availability: "//li[contains(text(), 'Availability')]/text()",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        mpn: "//meta[@itemprop='mpn']/@content",
        sku: "//input[@name='skuDetailsTab_wd-testSkuID']/@value"
      }
    },
    {
      id: "6ave",
      name: "6th Ave Electronics",
      category_tags: [
        "electronics"
      ],
      base: "6ave.com",
      paths: [],
      ore: {
        url: "link[rel='canonical']||||href"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "abcwarehouse",
      name: "abcwarehouse",
      category_tags: [
        "electronics",
        "appliances"
      ],
      base: "abcwarehouse.com",
      paths: [],
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//div[contains(@class, 'sku')]//span[@class='value']"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "abt",
      name: "abt",
      category_tags: [
        "electronics",
        "appliances"
      ],
      base: "abt.com",
      paths: [
        "\\/(?<identifier>\\d+)\\.html"
      ],
      ore: {
        availability: "json||||#productschema||||offers.availability",
        barcode: "json||||#productschema||||gtin13",
        cost: "json||||#productschema||||offers.price",
        currency: "json||||#productschema||||offers.priceCurrency",
        model: "json||||#productschema||||model",
        mpn: "json||||#productschema||||mpn",
        sku: "json||||#productschema||||sku"
      }
    },
    {
      id: "academy",
      name: "academy",
      category_tags: [
        "sports-outdoors"
      ],
      base: "www.academy.com",
      paths: [
        "\\/pdp\\/.*\\/(?<identifier>[^\\/\\?\\&]+)",
        "\\/p/"
      ],
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          "//div[contains(@class, 'e1of6vr50')]/div/div[@class='sr-only']/text()"
        ],
        mpn: "json||||script:nth-of-type(39)||||api.product-info.productinfo.partNumber",
        sku: "json||||script:nth-of-type(39)||||api.productItem.skuId"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "acehardware",
      base: "acehardware.com",
      name: "ACE Hardware",
      category_tags: [
        "home-garden"
      ],
      paths: [
        "/(.+)/([^/]+?)/(?<identifier>[0-9]+).html",
        "/p/(?<identifier>\\d+)"
      ],
      ore: {
        brand: [
          "substring-before(//h1[@itemprop='name'],' ')"
        ],
        cost: [
          "//span[@class='redtext totAmt']/text()",
          "//span[@itemprop='price']/text()",
          "//span[@class='custom-price mz-price']",
          "normalize-space(//span[@class='mz-price'])"
        ],
        delivery: "//div[@class='shipping-text']",
        mpn: [
          "//dd[@class='mz-productcodes-upc' and @itemprop='mpn']/text()",
          "//span[@itemprop='mpn']/text()",
          "//dt[contains(text(), 'Mfr #')]/following-sibling::dd/text()",
          "//span[@itemprop='mpn']"
        ],
        rating: "//span[@class='pr-rating pr-rounded average']",
        ratings: "(//a[starts-with(@id,'pr-snippet-read-link')]/span)[1]",
        title: [
          "//h1[@class='mz-pagetitle']",
          "//h1[@itemprop='name']"
        ],
        model: "//dd[@class='mz-productcodes-upc']/text()",
        barcode: "json||||#data-mz-preload-product||||upc",
        availability: [
          ".add-to-cart-btn:not([disabled])",
          ".pickup-option, .delivery-option, .ship-option",
          "json||||#data-mz-preload-product||||supportsInStorePickup"
        ]
      },
      scout: {
        path: "/search?query={{query}}",
        items: [
          "//li[contains(@class,'mz-productlist-item')]",
          "li.mz-productlist-item"
        ],
        ore: {
          cost: [
            "//span[@class='custom-price mz-price']",
            ".mz-price"
          ],
          image: [
            "//img[@class='prim-img']/@src",
            ".mz-productlisting-image img||||src"
          ],
          title: "//a[@class='mz-productlisting-title']/text()",
          url: [
            "//a[@class='mz-productlisting-title']/@href",
            ".mz-productlisting-title||||href"
          ]
        }
      }
    },
    {
      id: "adidas",
      name: "Adidas",
      category_tags: [
        "clothing"
      ],
      base: "adidas.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[A-Z0-9]+)\\.html"
      ],
      scout: {
        path: "/us/search?q={{query}}&sitePath=us",
        items: "div[data-grid-id]",
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: ".gl-price-item--small",
          image: ".gl-product-card__image||||src",
          title: ".gl-product-card__name",
          url: ".gl-product-card__details-link||||href"
        }
      },
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        brand: "substring-after('Adidas','')",
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//div[@class='gl-price-item notranslate']/text()",
          "//div[contains(@class, 'product-price')]/descendant::div[@class='gl-price-item gl-price-item--sale notranslate']/text()",
          "//div[@data-auto-id='product-information']//span[@class='gl-price__value gl-price__value--sale']",
          "//div[@data-auto-id='product-information']//span[@class='gl-price__value'])"
        ],
        mpn: "substring-after(//li[contains(text(),'Product code:')],'Product code: ')",
        title: "//h1[@data-auto-id='product-title']",
        availability: 'json||||script[type="application/ld+json"]||||offers.availability'
      }
    },
    {
      id: "adorama",
      name: "Adorama",
      category_tags: [
        "electronics"
      ],
      base: "www.adorama.com",
      paths: [
        "\\/(?<identifier>[A-Za-z0-9]+)\\.html"
      ],
      ore: {
        asin: "normalize-space(//th[contains(text(),'ASIN:')]/following-sibling::*)",
        availibility: '//*[contains(@class,"item-availability")]//*[contains(@class,"stock")]//text()',
        brand: "substring-after(//a[@class='col2 product-brand trackEvent']/@data-track-data,'logo, ')",
        cost: [
          ".cartButton div div section div div div span",
          "verb-miner-function-adorama-ore-cost",
          "//strong[@class='your-price']/text()",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          '//*[contains(@class,"your-price-savings-wrap")]//*[contains(@class,"your-price")]/text()',
          "//strong[@class='your-price']"
        ],
        mpn: [
          "//i[contains(text(), 'MFR:')]/span/text()",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
          "substring-before(substring-after(id('product-container'),'MFR: '),' ')"
        ],
        rating: "//a[@class='productReviewCount']//span",
        ratings: "translate(substring-after((//div[contains(@class,'review-stars')])[1]/@class,'stars-'),'_','.')",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          '//*[contains(@id,"product-container")]//*[contains(@class,"main-product-section")]/@data-sku',
          "substring-before(substring-after(//link[@rel='canonical']/@href,'.com/'),'.html')"
        ],
        title: [
          '//*[contains(@class,"product-info-container")]//h1//text()',
          "//meta[@property='og:title']/@content"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.priceCurrency'
        ],
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//span[contains(@class, 'stock-in')]/text()"
        ]
      },
      scout: {
        "path-disabled": "/l/?searchinfo={{query}}&sel=Item-Condition_New-Items",
        items: [
          ".item-list .item",
          '//*[contains(@class,"impression-tracked")]'
        ],
        required: false,
        url: "//link[@rel='canonical']/@href",
        ore: {
          cost: [
            '//*[contains(@class,"your-price")]//text()',
            ".your-price"
          ],
          image: [
            '//*[contains(@class,"productImage")]//@src',
            ".item-img img||||src"
          ],
          title: [
            '//*[contains(@data-trackdata,"title")]//text()',
            ".item-details h2 a"
          ],
          url: [
            '//a[contains(@data-trackdata,"title")]/@href',
            ".item-details h2 a||||href"
          ]
        },
        filter: "verb-miner-function-adorama-scout-filter"
      }
    },
    {
      id: "ajmadison",
      base: "www.ajmadison.com",
      name: "AJ Madison",
      category_tags: [
        "appliances"
      ],
      paths: [],
      ore: {
        cost: [
          "*[itemprop='price']||||content"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "ajretails",
      name: "ajretails",
      paths: [
        "/product/(?<identifier>\\d+)"
      ],
      base: "ajretails.in",
      ore: {
        availability: [
          "//*[property='schema:availability']/@content",
          "json||||#__NEXT_DATA__||||props.pageProps.product.available"
        ],
        cost: [
          "//*[property='schema:price']/text()",
          "json||||#__NEXT_DATA__||||props.pageProps.product.discounted_price",
          "json||||#__NEXT_DATA__||||props.pageProps.product.price"
        ],
        currency: "//*[property='schema:priceCurrency']/@content",
        sku: "json||||#__NEXT_DATA__||||props.pageProps.product.id"
      }
    },
    {
      id: "albertsons",
      name: "Albertsons Companies",
      category_tags: [
        "grocery-food"
      ],
      domains: [
        "albertsons.com",
        "safeway.com",
        "vons.com",
        "jewelosco.com",
        "shaws.com",
        "starmarket.com",
        "acmemarkets.com",
        "pavilions.com",
        "tomthumb.com",
        "randalls.com",
        "unitedsuper.com",
        "haggen.com",
        "carrsqc.com",
        "kingsfoodmarkets.com",
        "balduccis.com"
      ],
      base: {
        "*-us": "albertsons.com"
      },
      paths: [
        "\\/pd\\/(?<identifier>[^\\/]+)$",
        "\\/product\\/(?<identifier>[^\\/]+)$",
        "\\/p\\/(?<identifier>[^\\/\\?]+)",
        "\\/shop\\/pd\\/(?<identifier>[^\\/]+)",
        "\\/groceries\\/(?<identifier>[^\\/]+)"
      ],
      "skip-normal-mining": true,
      mine: "verb-miner-function-albertsons-mine",
      "brick-and-mortar": "verb-miner-function-albertsons-brick-and-mortar",
      scout: {
        path: "https://{{domain}}/shop/search-results.html?q={{query}}&tab=products",
        before: "verb-miner-function-albertsons-scout-before",
        items: ".product-tile, .search-result, [data-testid='product-item'], .product-card",
        ore: {
          title: [
            ".product-title",
            ".item-title",
            "h3",
            "[data-testid='product-title']",
            ".product-name"
          ],
          cost: [
            ".price",
            ".current-price",
            "[data-testid='price']",
            ".product-price",
            ".price-display"
          ],
          url: [
            "a||||href",
            ".product-link||||href"
          ],
          image: [
            "img||||src",
            ".product-image img||||src",
            "[data-testid='product-image']||||src"
          ],
          availability: [
            ".availability",
            ".stock-status",
            "[data-testid='availability']",
            ".in-stock",
            ".out-of-stock"
          ]
        }
      },
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: ".price, .current-price",
              at: "afterend"
            }
          ]
        }
      ]
    },
    {
      id: "aldi",
      name: "Aldi",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/store/aldi/products/(?<identifier>\\d+-[\\w-]+)",
        "/p-(?<identifier>[^/]+)/\\d+",
        "/products/(?<identifier>[^/]+)",
        "/groceries/(?<identifier>[^/]+)",
        "/detail/ps/p/(?<identifier>[^/]+)/"
      ],
      base: {
        "*-us-shop": "shop.aldi.us",
        "*-us-www": "www.aldi.us",
        "*-uk": "groceries.aldi.co.uk",
        "*-ie": "groceries.aldi.ie"
      },
      domains: [
        "shop.aldi.us",
        "www.aldi.us",
        "groceries.aldi.co.uk",
        "groceries.aldi.ie"
      ],
      scout: {
        path: "https://{{domain}}/search?q={{query}}",
        items: [
          ".product-tile",
          ".product-card",
          ".search-result",
          ".product-item",
          "[data-testid='product']",
          ".product-listing",
          ".item-card"
        ],
        ore: {
          title: [
            ".product-name",
            ".product-title",
            "h3",
            ".item-title",
            "[data-testid='product-name']"
          ],
          cost: [
            ".price",
            ".product-price",
            ".cost",
            ".price-current",
            "[data-testid='price']"
          ],
          url: [
            "a||||href",
            ".product-link||||href"
          ],
          image: [
            ".product-image img||||src",
            "img||||src",
            "[data-testid='product-image']||||src"
          ],
          availability: [
            ".availability",
            ".in-stock",
            ".special-buy",
            "[data-testid='availability']"
          ]
        }
      },
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          'json||||script[type="application/ld+json"]||||@graph[0].offers.availability',
          ".availability-status",
          ".stock-status"
        ],
        barcode: [
          'json||||script[type="application/ld+json"]||||gtin13',
          'json||||script[type="application/ld+json"]||||@graph[0].gtin13',
          "//meta[@property='product:retailer_item_id']/@content"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          'json||||script[type="application/ld+json"]||||@graph[0].offers.price',
          ".price-current",
          ".product-price",
          "[data-testid='price']"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          'json||||script[type="application/ld+json"]||||@graph[0].offers.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ],
        title: [
          'json||||script[type="application/ld+json"]||||name',
          'json||||script[type="application/ld+json"]||||@graph[0].name',
          "h1",
          ".product-name",
          "[data-testid='product-name']"
        ],
        description: [
          'json||||script[type="application/ld+json"]||||description',
          'json||||script[type="application/ld+json"]||||@graph[0].description',
          ".product-description",
          ".product-details"
        ],
        images: [
          'json||||script[type="application/ld+json"]||||image',
          'json||||script[type="application/ld+json"]||||@graph[0].image',
          ".product-images img||||src",
          ".product-gallery img||||src"
        ],
        brand: [
          'json||||script[type="application/ld+json"]||||brand.name',
          'json||||script[type="application/ld+json"]||||@graph[0].brand.name',
          ".brand-name"
        ],
        category: [
          'json||||script[type="application/ld+json"]||||category',
          'json||||script[type="application/ld+json"]||||@graph[0].category',
          ".breadcrumb",
          ".category-path"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          'json||||script[type="application/ld+json"]||||@graph[0].sku',
          "//meta[@property='product:retailer_item_id']/@content"
        ],
        size: [
          'json||||script[type="application/ld+json"]||||size',
          'json||||script[type="application/ld+json"]||||@graph[0].size',
          ".product-size"
        ]
      },
      mine: "verb-miner-function-aldi-mine",
      "brick-and-mortar": "verb-miner-function-aldi-brick-and-mortar",
      userAgent: {
        ios: " ",
        android: "ShopSavvy/Android-{{VERSION}}-WebView"
      },
      notes: [
        "Supports US shop.aldi.us (Instacart platform) and www.aldi.us (corporate site)",
        "Also supports UK/IE operations (groceries.aldi.co.uk, groceries.aldi.ie)",
        "US shop.aldi.us uses rich JSON-LD structured data (Tier 1)",
        "US www.aldi.us is client-side rendered (Tier 3 - may need custom functions)",
        "URL patterns updated to match actual database URLs",
        "Scout functionality enhanced for search capability"
      ]
    },
    {
      id: "aldoshoes",
      name: "aldoshoes",
      category_tags: [
        "clothing"
      ],
      paths: [
        "/p/(?<identifier>\\d+)"
      ],
      base: "www.aldoshoes.com",
      ore: {
        cost: "//div[contains(@class, 'c-buy-module__formatted-price')]/span[@class='c-product-price__formatted-price']/text()"
      }
    },
    {
      id: "alibris",
      name: "Alibris",
      category_tags: [
        "books"
      ],
      base: "alibris.com",
      paths: [
        "\\/(.+)\\/(.+)\\/isbn\\/(?<identifier>\\d+)",
        "\\/(.+)\\/(.+)\\/(?<identifier>\\d+)"
      ],
      scout: {
        "path-disabled": "/allsearch?mtype=A&keyword={{query}}&hs.x=0&hs.y=0&hs=Submit",
        items: "#works li",
        ore: {
          cost: [
            "substring-after(//li[@class='price-row first'], 'from ')",
            ".price"
          ],
          image: ".synopsis .left img||||src",
          title: ".right > h2 > strong > a",
          url: ".left > a||||href"
        }
      },
      ore: {
        barcode: [
          "substring-after(//span[@class='isbn-link'], ': ')",
          "substring-after(//p[./a[contains(@href, 'upc/') or contains(@href, 'isbn/')]]//a/@href, 'upc/')"
        ],
        cost: "substring-after(//a[@id='tabNew']//span, 'from ')",
        title: "//h1[@itemprop='name']"
      }
    },
    {
      id: "aliexpress",
      name: "AliExpress",
      category_tags: [
        "sells-everything"
      ],
      base: "aliexpress.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[\\w+]+)\\.html",
        "\\/item\\/(?<identifier>[0-9]+)\\.html"
      ],
      mine: "verb-miner-function-aliexpress-mine",
      scout: {
        path: "/wholesale?SearchText={{query}}",
        items: './/div[@class="JIIxO"]/a',
        ore: {
          cost: './/span[@data-selenium="mGXnE _37W_B"]//text()',
          image: './/img[contains(@class,"product-img")]/@src',
          title: './/h1[@class="_18_85"]/text()',
          url: './/a[@role="store"]/@href'
        }
      }
    },
    {
      id: "alternate",
      name: "alternate",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>\\d+)$"
      ],
      base: "www.alternate.de",
      ore: {
        barcode: "//tr[td[contains(text(), 'EAN')]]/td[@class='c4']/text()",
        cost: "//span[@class='price ']/text()",
        mpn: "//td[contains(text(), 'Hersteller-Nr.')]/following-sibling::td[1]",
        sku: "substring-after(//span[contains(@class, 'font-weight-bold') and contains(text(), 'Art.-Nr.:')]/text(), ': ')"
      }
    },
    {
      id: "alza",
      name: "alza",
      category_tags: [
        "electronics"
      ],
      paths: [],
      base: "www.alza.de",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//span[contains(@class, 'avlVal')]/text()"
        ],
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin13',
          "//span[@data-testid='more-info-product-number']/span[@data-testid='value']/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//span[@class='price']/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(6)||||currency',
          "//span[contains(@class, 'price-detail__without-vat-value')]/text()"
        ],
        mpn: "//span[@data-testid='value' and preceding-sibling::span[contains(text(), 'Artikelnummer')] and not(ancestor::div[contains(@class, 'hidden')])]/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//span[contains(@data-testid, 'more-info-product-code')]/span[@data-testid='value']/text()"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "amazon",
      name: "Amazon",
      category_tags: [
        "sells-everything"
      ],
      base: {
        "*-ae": "www.amazon.ae",
        "*-au": "www.amazon.com.au",
        "*-br": "www.amazon.com.br",
        "*-ca": "www.amazon.ca",
        "*-cn": "www.amazon.cn",
        "*-de": "www.amazon.de",
        "*-es": "www.amazon.es",
        "*-fr": "www.amazon.fr",
        "*-gb": "www.amazon.co.uk",
        "*-in": "www.amazon.in",
        "*-it": "www.amazon.it",
        "*-jp": "www.amazon.co.jp",
        "*-mx": "www.amazon.com.mx",
        "*-nl": "www.amazon.nl",
        "*-sg": "www.amazon.com.sg",
        "*-tr": "www.amazon.com.tr",
        "*-us": "www.amazon.com"
      },
      paths: [
        "^(?:\\/([^\\/]+?))?\\/dp\\/(?<identifier>[^\\/]+?)$",
        "^(?:\\/([^\\/]+?))?\\/gp\\/offer-listing\\/(?<identifier>[^\\/]+)",
        "(?:[\\w\\-\\%]+\\/)?(?:dp|gp\\/product)\\/(?:\\w+\\/)?(?<identifier>\\w{10})",
        "\\/(dp|gp)\\/product\\/(?<identifier>\\w{10})",
        "/(?:\\/(dp|gp)\\/(product|offer-listing)?\\/?)?(?<identifier>\\w{10})/"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: "#ppd #centerCol #corePriceDisplay_desktop_feature_div",
              at: "afterend"
            },
            {
              selector: "#centerCol .a-price.priceToPay",
              at: "afterend"
            },
            {
              selector: ".a-price.priceToPay",
              at: "afterend"
            },
            {
              selector: "#title.a-size-large.a-spacing-none",
              at: "afterend"
            }
          ]
        }
      ],
      observe: [
        {
          selector: "#titleSection"
        }
      ],
      "skip-normal-mining": true,
      ore: {
        request: {
          headers: {}
        },
        availability: [
          "verb-miner-function-amazon-ore-availability",
          "#availability",
          "#almOutOfStockAvailability_feature_div"
        ],
        barcode: [
          "substring-after((//li[contains(.,'ISBN-1')])[last()],': ')",
          "//div[@class='content']/ul/li[contains(.,'UPC:')]/text() | id('prodDetails')//td[contains(text(),'UPC')]/following-sibling::td",
          "//tr[contains(normalize-space(),'UPC')]/td/text()",
          "//tr[contains(normalize-space(),'ISBN-1')]/td/text()",
          "//li[contains(normalize-space(),'UPC')]/span//span[2]/text()",
          "//li[contains(normalize-space(),'ISBN-1')]/span//span[2]/text()",
          "verb-miner-function-amazon-ore-barcode"
        ],
        brand: [
          "a#bylineInfo",
          "div#olpProductByline"
        ],
        cost: [
          "json||||.a-section.aok-hidden.twister-plus-buying-options-price-data||||desktop_buybox_group_1.0.priceAmount",
          "span.a-offscreen",
          ".a-price .a-offscreen",
          "span#priceblock_pospromoprice",
          "span#actualPriceValue b",
          "substring-before(concat((//td[contains(., 'Price after rebate')]/following-sibling::td//span[@class='a-size-base a-color-price'] | id('priceblock_dealprice') | //span[@id='priceblock_ourprice']//span[@class='buyingPrice'] | //span[@id='priceblock_ourprice'])[last()], ' -'), ' -')",
          "normalize-space(translate(//span[@class='a-button a-button-selected a-spacing-mini a-button-toggle format']//span[@class='a-color-base'], ' from', ''))",
          "span#priceblock_saleprice",
          "#olp-new",
          "*[id*='olp-upd-new']",
          "span.a-size-medium.a-color-price.header-price",
          "#price",
          "#unqualified-buybox-olp",
          "#mediaTab_content_landing",
          "#almDetailPagePrice_price *[data-asin-price]||||data-asin-price"
        ],
        currency: [
          "meta[property='product:price:currency']||||content",
          "json||||.a-section.aok-hidden.twister-plus-buying-options-price-data||||desktop_buybox_group_1.0.currencySymbol",
          "span.a-price-symbol"
        ],
        delivery: "#ourprice_shippingmessage span",
        image: [
          "#landingImage||||data-old-hires",
          "#landingImage||||src"
        ],
        images: [
          ".imgTagWrapper img||||src",
          "#imgTagWrapperId img||||src"
        ],
        model: [
          ".po-model_name td.a-span9",
          "//tr[contains(td/span/text(), 'Model Adı')]/td[2]/span/text()",
          "normalize-space(//li[contains(., 'Item model number')]/text())",
          "normalize-space(//tr[contains(.,'Item model number')]/td/following-sibling::td)",
          "normalize-space(//th[contains(.,'Item model number')]/following-sibling::td/text())"
        ],
        mpn: "//tr[contains(.,'Part Number')]/td",
        sku: [
          "substring(//input[@id='ASIN']/@value,1,10)",
          "substring(//div[@class='content']//li[contains(.,'ASIN')]/text(),1,10)",
          "substring-before(substring-after(//div[@id='olpProductImage']/a/@href,'dp/'),'/')",
          "#averageCustomerReviews *[data-asin]||||data-asin"
        ],
        title: [
          "#productTitle",
          "#btAsinTitle",
          "#title",
          "#product-title"
        ],
        rating: "substring-before(//div[@id='averageCustomerReviews']//span[@class='a-icon-alt'],' ')",
        ratings: "substring-before(id('acrCustomerReviewText'),' ratings')",
        buyBoxSellerLink: "#sellerProfileTriggerId||||href",
        description: "#productDescription",
        fromTheManufacturer: "verb-miner-function-amazon-ore-from-the-manufacturer",
        whatsInTheBox: "verb-miner-function-amazon-ore-whats-in-the-box",
        attributes: "verb-miner-function-amazon-ore-attributes",
        comparisons: "verb-miner-function-amazon-ore-comparisons",
        associateds: "verb-miner-function-amazon-ore-associateds"
      },
      scout: {
        before: "verb-miner-function-amazon-scout-before",
        path: "/s?k={{query}}&ref=nb_sb_noss_2",
        filter: "verb-miner-function-amazon-scout-filter",
        items: ".s-result-list .s-result-item:not(.AdHolder)[data-component-type='s-search-result']",
        ore: {
          request: {
            headers: {
              accept: "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9",
              "accept-language": "en-US,en;q=0.9",
              "user-agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.2.1 Safari/605.1.15"
            }
          },
          cost: ".a-price .a-offscreen",
          image: ".a-section img||||src",
          title: "verb-miner-function-amazon-scout-ore-title",
          url: [
            ".a-link-normal.s-underline-text.s-underline-link-text.s-link-style.a-text-normal||||href",
            "div.a-section h2 .a-link-normal||||href",
            "verb-miner-function-amazon-scout-ore-url"
          ]
        }
      },
      mine: "verb-miner-function-amazon-mine"
    },
    {
      id: "amerchant",
      name: "amerchant",
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "amerchant.com.au",
      ore: {
        availability: [
          "json||||.yoast-schema-graph.yoast-schema-graph--woo.yoast-schema-graph--footer||||@graph.0.offers.0.availability",
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          "json||||.yoast-schema-graph.yoast-schema-graph--woo.yoast-schema-graph--footer||||@graph.0.offers.0.priceSpecification.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "//meta[@property='product:price:currency']/@content"
        ]
      }
    },
    {
      id: "anker",
      name: "Anker",
      category_tags: [
        "electronics"
      ],
      base: "www.anker.com",
      paths: [
        "\\/(.+)\\/(.+)\\/(.+)\\/(?<identifier>[A-Z0-9]+)",
        "\\/products\\/(?<identifier>[^?]+)"
      ],
      scout: {
        "path-disabled": "/Search?keyword={{query}}",
        items: "div[data-productsku]",
        ore: {
          cost: "//span[@itemprop='price']",
          image: "div > img||||src",
          title: "a > div:nth-child(2) > div:nth-child(2)",
          url: "a||||href"
        }
      },
      ore: {
        barcode: [
          "json||||#__NEXT_DATA__||||props.pageProps.product.variants.0.barcode",
          "substring(//p[contains(text(),'UPC')],5,14)"
        ],
        brand: "substring-after('Anker','')",
        cost: [
          "//div[contains(@class, 'ProductTag_productPrice')]/span/text()",
          "//span[@itemprop='price']"
        ],
        mpn: "substring-before(substring-after(//meta[@name='twitter:image']/@content,'mini/'),'_')",
        title: "h1[@itemprop='name']",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||sku',
          "json||||#__NEXT_DATA__||||props.pageProps.product.variants.0.sku",
          "//div[contains(@class, 'ProductSidebar_primeButton')]/div/@data-sku"
        ],
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.availability',
          "string(//button[@id='netlify_dtctest_add_to_cart']/text())",
          "json||||#__NEXT_DATA__||||props.pageProps.product.availableForSale"
        ],
        currency: "json||||#__NEXT_DATA__||||props.pageProps.product.price.currencyCode"
      }
    },
    {
      id: "apple",
      category_tags: [
        "electronics"
      ],
      base: "www.apple.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[\\w+]+)",
        "\\/shop\\/product\\/(?<identifier>[0-9A-Z\\/]+)\\/",
        "/buy-[\\w+]+/[\\w+]+/(?<identifier>[^/]+)"
      ],
      "brick-and-mortar": "verb-miner-function-apple-mine-brick-and-mortar",
      ore: {
        availability: "//div[@class='stockStatus']/text()",
        barcode: [
          "substring-before(substring-after(id('productInfoSection'),'UPC or EAN No.: '),' ')",
          "substring-before(substring-after(//div[@class='rc-pdsection-panel ManufacturerInfo-panel row'],'UPC or EAN No.: '),' ')",
          "substring-after(//div[@data-selenium='overviewUpcText'],'UPC: ')"
        ],
        brand: [
          "substring(concat(//meta[@itemprop='name']/@content, 'apple'), 1, string-length(concat(//meta[@itemprop='name']/@content, 'apple'))-5 * number((string-length(//meta[@itemprop='name']/@content)>0)))"
        ],
        cost: [
          "verb-miner-function-apple-ore-cost",
          "//span[contains(@data-product-template,'price.display')]/text()",
          "//span[@class='current_price']",
          ".current_price span"
        ],
        delivery: "//div[@class='shipInfoLayer']//text()",
        identifier: "*[data-part]||||data-part",
        images: "verb-miner-function-apple-ore-images",
        mpn: [
          "//input[@id='productPartNumber']/@value|//input[@name='product']/@value"
        ],
        sku: [
          "substring(concat(substring-before(//input[@name='product']/@value,'/'),substring-after(//meta[@itemprop='url']/@content, '/product/')),1,7)"
        ],
        title: [
          "concat(normalize-space(//h1[@data-autom='productTitle']),//span[@data-autom='summaryHeaderTitle'])",
          "//title/text()"
        ],
        currency: [
          "json||||#metrics||||data.properties.currencyCode"
        ]
      },
      scout: {
        path: "verb-miner-function-apple-scout-path",
        items: [
          ".as-producttile",
          './/div[@role="listitem"]'
        ],
        ore: {
          image: './/div[@class="rf-serp-productimage"]/img/@src',
          images: "verb-miner-function-apple-scout-ore-images",
          title: [
            ".as-producttile-name span",
            './/div[@class="rf-serp-product-description"]/p[@class="rf-serp-description"]/text()'
          ],
          url: [
            ".as-producttile-name a||||href",
            './/div[@class="rf-serp-product-description"]/p[@class="rf-serp-explore-link"]/a/@href'
          ]
        }
      }
    },
    {
      id: "argos",
      name: "argos",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/product/(?<identifier>\\d+)"
      ],
      base: "www.argos.co.uk",
      ore: {
        barcode: "substring-before(substring-after(//li[contains(text(), 'EAN:')]/text(), 'EAN:'), '.')",
        condition: [
          "//*[itemProp='itemCondition'/@content"
        ],
        cost: [
          "//*[itemprop='price']/@content",
          "//*[itemprop='price']/text()",
          "//li[contains(@class, 'Pricestyles__')]/h2/text()"
        ],
        currency: "//span[@itemprop='priceCurrency']/@content",
        sku: "//span[@data-test='product-name-catNumber']/@content",
        title: "//*[itemprop='name']/text()"
      }
    },
    {
      id: "att",
      name: "att",
      category_tags: [
        "electronics"
      ],
      base: "www.att.com",
      paths: [
        "/\\w+/\\w+/(?<identifier>[^?]+)"
      ],
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
        barcode: [
          "//td[contains(text(), 'UPC')]/following-sibling::td/text()"
        ],
        currency: "//strong[@class='type-lg font-bold line-h-sm color-ui-black']/text()",
        model: "json||||#__NEXT_DATA__||||props.pageProps.productField.details.selectedSku.model",
        sku: [
          "//td[contains(text(), 'SKU')]/following-sibling::td[1]/text()"
        ]
      }
    },
    {
      id: "backmarket",
      name: "backmarket",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/p/[^/]+/(?<identifier>[a-z0-9\\-]+)"
      ],
      base: "www.backmarket.co.jp",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//div[@class='mb-3 flex flex-row items-center']/span/span[contains(text(), '全国送料無料・翌営業日出荷')]"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//div[@class='text-primary' and contains(text(), '￥')]/text()"
        ],
        model: "//*[contains(text(), 'メーカー型番')]/following-sibling::span/text()",
        mpn: [
          "//span[normalize-space(.)='メーカー型番 :']/following-sibling::span/text()"
        ]
      }
    },
    {
      id: "barnesandnoble",
      name: "Barnes and Noble",
      category_tags: [
        "books",
        "toys-games"
      ],
      base: "barnesandnoble.com",
      paths: [
        "\\/(.+)\\/(.+)\\/(?<identifier>[A-Z0-9]+)"
      ],
      scout: {
        path: "/s/{{query}}"
      },
      ore: {
        barcode: [
          "//table//tr[th[contains(text(), 'ISBN-13:')]]/td/text()",
          "//table//th[contains(text(), 'UPC:')]/following-sibling::td/text()",
          "substring-before(normalize-space(substring-after(id('additionalProductInfo'),'ISBN-13:')),'Publisher:')",
          "substring-after(//meta[@property='og:url']/@content,'ean=')"
        ],
        cost: [
          "//span[@id='pdp-cur-price']/text()",
          "//div[contains(@class, 'price')]/span/text()",
          "//span[@itemprop='price']/text()",
          "//span[@id='pdp-cur-price']"
        ],
        sku: [
          "//input[@id='productSkuIdPdp']/@value",
          "//input[@id='productSkuId']/@value",
          "//input[@name='skuId']/@value"
        ],
        title: "//h1",
        availability: [
          "//span[@class='in-store-available']/text()",
          "//link[@itemprop='availability']/@href"
        ],
        mpn: [
          "//th[contains(text(), 'Manufacturer')]/following-sibling::td/text()",
          "//tr[th[contains(text(), 'Manufacturer:')]]/td/text()"
        ],
        currency: "//meta[@itemprop='priceCurrency']/@content"
      }
    },
    {
      id: "basspro",
      category_tags: [
        "sports-outdoors"
      ],
      base: "basspro.com",
      paths: [
        "(P?<name>/shop/en/([a-z0-9-]+))",
        "\\/(?<identifier>[\\w-]+)$"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "json||||div:nth-of-type(28)||||buyable",
          "//div//span[@itemprop='ItemAvailability']/@content"
        ],
        cost: "//span[@class='price ']",
        costDelivery: "//p[contains(text(),'Shipping on Orders')]",
        delivery: "//div[@id='deliveryMessage']",
        mpn: [
          "json||||div:nth-of-type(28)||||partNumber",
          "//meta[@name='pageIdentifier']/@content"
        ],
        title: "//h1",
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//input[contains(@id,'analyticsId_')]/@value"
        ]
      },
      scout: {
        path: "/r/shop/en/SearchDisplay#q={{query}}",
        items: "//div[contains(@class,'ResultItem_ResultItem')]",
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: "//div[contains(@class,'ResultItem_ResultItem')]//div[contains(@class,'ResultPrice_PriceContainer')]",
          image: "//div[contains(@class,'ResultItem_ResultItem')]//img[@data-nimg]/@src",
          title: "//div[contains(@class,'ResultItem_ResultItem')]//div[contains(@class,'ResultTitleLink_ResultItemTitleLink')]",
          url: "//div[contains(@class,'ResultItem_ResultItem')]//div[contains(@class,'ResultTitleLink_ResultItemTitleLink')]/a/@href"
        }
      }
    },
    {
      id: "beachcamera",
      name: "Beach Camera",
      category_tags: [
        "electronics"
      ],
      base: "beachcamera.com",
      paths: [
        "/products/(?<identifier>[\\w-]+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//button[@data-product-atc]/span[contains(text(), 'Add to cart')]"
        ],
        barcode: "//td[contains(text(), 'Barcode')]/following-sibling::td/text()",
        mpn: [
          "//td[text()='PartNumber']/following-sibling::td/text()",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
          "//td[contains(text(), 'PartNumber')]/following-sibling::td/text()"
        ],
        cost: [
          "//span[@class='money ']/text()",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price'
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(23)||||currency',
          "//span[contains(@class, 'money') and contains(text(),'$')]/text()",
          'json||||script[type="text/javascript"]:nth-of-type(22)||||currency'
        ],
        model: [
          "//td[contains(text(), 'PartNumber')]/following-sibling::td/text()",
          "json||||script:nth-of-type(73)||||product.variants.0.sku"
        ],
        sku: [
          "json||||script:nth-of-type(74)||||product.variants.0.sku",
          "//div[contains(@class, 'product-sku')]/span/text()",
          "json||||script:nth-of-type(73)||||product.variants.0.sku"
        ]
      }
    },
    {
      id: "bedbathandbeyond",
      name: "Bed Bath & Beyond",
      category_tags: [
        "home-garden"
      ],
      base: "bedbathandbeyond.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)",
        ".*/product/.*/(?<identifier>[0-9]+).*",
        ".*sku=(?<identifier>[0-9]+).*",
        ".*WSKU=(?<identifier>[0-9A-Z]+).*",
        "\\/store\\/product\\/[^\\/]+\\/(?<identifier>\\w+)",
        "\\?featuredproduct=(?<identifier>\\d+)",
        "&featuredproduct=(?<identifier>\\d+)"
      ],
      "brick-and-mortar": "verb-miner-function-bedbathandbeyond-mine-brick-and-mortar",
      ore: {
        brand: "//a[@itemprop='brand']",
        cost: [
          "//span[@data-locator='pdp-pricetext']",
          "//div[@class='inlineBlock txtMed price trackIsPrice skuRollup']/text()"
        ],
        delivery: "//div[@class='i-amphtml-fill-content i-amphtml-replaced-content']//text()",
        image: "div[itemref='reviews productDetails'] img||||src",
        mpn: "substring-after(//li[contains(text(),'Model')],' ')",
        rating: "//span[@itemprop='ratingValue']",
        ratings: "//meta[@itemprop='reviewCount']/@content",
        sku: [
          "json||||#__NEXT_DATA__||||props.pageProps.initialReduxState.pageData.featuredProduct.sku",
          "substring-after(//li[contains(text(),'skuId')],' : ')"
        ],
        title: [
          "//h1[@itemprop='name']",
          "//span[@class='skuRollup']/text()"
        ],
        barcode: "json||||#__NEXT_DATA__||||props.pageProps.initialReduxState.pageData.featuredProduct.similarItems.1.upc"
      },
      scout: {
        "path-disabled": "/store/s/{{query}}?ta=typeahead",
        items: [
          "section.productSearch > div > div > div > div",
          './/div[@role="list"]'
        ],
        ore: {
          cost: './/span[@class="inlineBlock plpPrice trackPrice"]/text()',
          image: [
            "div.relative.tealium-product-tile > a > div > img||||src",
            './/div[@class="prodCardL parent"]'
          ],
          title: [
            ".tealium-product-title > a",
            './/div[@class="prodTitle trackName"]/text()'
          ],
          url: [
            ".tealium-product-title > a||||src",
            './/div[@class="prodCardL parent"]/a/@href'
          ]
        }
      }
    },
    {
      id: "belk",
      name: "Belk",
      category_tags: [
        "sells-everything"
      ],
      base: "belk.com",
      paths: [
        "\\/p\\/(.+)\\/(?<identifier>\\d+)\\.html"
      ],
      scout: {
        path: "/search/?q={{query}}"
      },
      ore: {
        barcode: [
          "json||||script:nth-of-type(68)||||upc",
          "normalize-space(substring-after(//span[@class='product-UPC'],'UPC:'))"
        ],
        cost: [
          "json||||script:nth-of-type(71)||||price.original.min",
          "//span[@itemprop='price']"
        ],
        sku: [
          "json||||script:nth-of-type(71)||||defaultSku.id",
          "//belk-pdp-info/@product-id",
          "normalize-space(//span[@itemprop='productID'])"
        ],
        title: "normalize-space(//div[@itemprop='name'])",
        availability: "json||||script:nth-of-type(71)||||availability",
        currency: "json||||script:nth-of-type(71)||||price.currency.symbol"
      }
    },
    {
      id: "belkin",
      name: "Belkin",
      category_tags: [
        "sells-everything"
      ],
      base: "belkin.com",
      paths: [
        "\\/(.+)\\/p\\/(?<identifier>[A-Za-z0-9]+)",
        "\\/([^\\/]+?)\\/(?<identifier>[\\w+]+)\\.html"
      ],
      scout: {
        "path-disabled": "/us/search?text={{query}}",
        items: ".product-item",
        ore: {
          cost: [
            "span.sale-price",
            "span.original-price"
          ],
          image: ".product-image img||||src",
          title: "a||||title",
          url: "a||||href"
        }
      },
      ore: {
        brand: "substring-after('belkin','')",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//meta[@property='og:price:amount']/@content",
          "//span[@class='value']/text()",
          "//*[@itemprop='price' or @id='product-info-price']"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||mpn',
          "//p[@id='product-part-number']"
        ],
        title: "//h1[@itemprop='name']",
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//span[contains(@class, 'status') and contains(text(), 'In Stock')]",
          "//span[contains(@class, 'status')]/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(11)||||currency',
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku',
          "substring-after(//span[contains(@class, 'product-id')]/text(), 'SKU: ')"
        ]
      }
    },
    {
      id: "bellacor",
      name: "Bellacor",
      category_tags: [
        "home-garden"
      ],
      base: "bellacor.com",
      paths: [
        "\\/productdetail\\/(?<identifier>.+)\\.htm"
      ],
      scout: {
        "path-disabled": "/results.cfm?Ntt={{query}}&Hs=1",
        items: ".resultCell",
        ore: {
          cost: ".resultCellPriceValue",
          image: "img.product||||src",
          title: "//div[@class='resultCellTitle']",
          url: ".resultCellTitle a||||href "
        }
      },
      ore: {
        barcode: [
          "//li[./strong[contains(.,'UPC:')]]/text()"
        ],
        brand: "//li/strong[contains(.,'Brand:')]/following-sibling::a",
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//span[@class='price__sales sales']/span[@class='value']/text()",
          "translate((//span[@class='red'])[1], '*', '')"
        ],
        mpn: "//li[./strong[contains(.,'Brand SKU:')]]/text()",
        sku: "substring-before(substring-after(//link[@rel='canonical']/@href,'productdetail/'),'.htm')",
        title: "//div[@id='productTitle']/h1",
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "normalize-space(//span[@class='product-availability__allocation-value'])"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          "//meta[@itemprop='priceCurrency']/@content"
        ]
      }
    },
    {
      id: "bestbuy",
      name: "Best Buy",
      category_tags: [
        "electronics",
        "appliances"
      ],
      base: "bestbuy.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[\\w+]+)\\.p",
        ".*\\/(?<identifier>[0-9]+).p.*/",
        ".*/product/(?<identifier>[0-9]+)\\/.*",
        ".*skuId=(?<identifier>[0-9]+).*",
        ".*[?]type=product&id=(?<identifier>[0-9]+).*",
        ".*[Ss]ku[Ii]d=(?<identifier>[0-9]+).*",
        "p\\?id=(?<identifier>\\d+)",
        "\\/site\\/[a-z0-9\\-]+\\/(?<identifier>[0-9]+)\\.p"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          "verb-miner-function-bestbuy-ore-apollo-availability",
          'json||||script[type="application/ld+json"]:first||||offers.availability',
          'json||||script[type="application/ld+json"]||||product.offers.availability',
          '//meta[@property="product:availability"]/@content',
          '//meta[@property="product:stock_status"]/@content'
        ],
        barcode: [
          `json||||script[type="application/ld+json"]:nth-of-type(1)||||additionalProperty[?(@.name=='UPC')].value`,
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin13',
          "substring(substring-after(//script[contains(text(),'gtin13')],'gtin13'),4,13)",
          "(//div[@class='item_detail even upc clearfix']//div)[2] | (//div[@class='item_detail even ean clearfix']//div)[2]",
          "//span[@class='product-data-label body-copy']/text()"
        ],
        brand: "substring-before(//title/text(), ' ')",
        cost: [
          ".customer-price",
          "json||||//script[contains(text(), 'skuDataAnalytics')]||||app.data.skuDataAnalytics.customerPrice",
          "//div[@class='pricing-price']//span[starts-with(text(),'$')]",
          "//div[@class='upgrade-plus-price']/div/div/div/span[1]/text()",
          "//div[@data-selenium='pricingPrice']/text()",
          "json||||//script[contains(@id, 'pricing-price-')]||||app.priceDomain.currentPrice",
          "normalize-space(//div[@data-layout='large']//div[@class='priceView-hero-price priceView-customer-price']/span)",
          ".priceView-layout-large .priceView-customer-price span:nth-child(1)",
          ".priceView-layout-large > div > div:nth-child(2) > div > div > div"
        ],
        currency: [
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.priceCurrency"
        ],
        delivery: "//div[@class='fulfillment-fulfillment-summary']//text()",
        images: "verb-miner-function-bestbuy-ore-images",
        mpn: [
          `json||||script[type="application/ld+json"]:nth-of-type(1)||||additionalProperty[?(@.name=='Model Number')].value`,
          "normalize-space(//span[@class='product-data-value body-copy']/text())"
        ],
        rating: "translate(concat(translate(substring-before(substring-after(//div[@class='rating']//img/@src,'star_'),'.gif'),'_','.'),substring-before(substring-after(//div[@class='bbystars-small-yellow']/div/@style,': '),'%') div 20), 'Na','')",
        ratings: "//span[@itemprop='reviewCount']",
        sku: [
          'json||||meta[name="analytics-metadata"]||||product.skuId',
          "substring-after(//meta[@property='og:url']/@content,'skuId=')",
          'json||||script[type="application/json"]:nth-of-type(5)||||app.productDetails.sku',
          "json||||//script[contains(@id, 'pricing-price-')]||||app.params.skuId",
          "//div[@class='sku product-data']/span[@class='product-data-value body-copy']/text()",
          "json||||//script[contains(text(), 'skuDataAnalytics')]||||app.data.skuDataAnalytics.skuId"
        ],
        title: [
          "verb-miner-function-bestbuy-ore-title-cleanup",
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||name'
        ],
        url: "//meta[@property='og:url']/@content",
        model: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||model',
          "//div[@class='model product-data']/span[contains(@class, 'product-data-value')]/text()",
          "//div[contains(@class, 'property')][contains(text(), 'Model Number')]/following-sibling::div[@class='description']/text()"
        ],
        reviews: "verb-miner-function-bestbuy-ore-reviews"
      },
      scout: {
        path: "/site/searchpage.jsp?st={{query}}",
        items: ".product-list-item",
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: '[data-testid="medium-customer-price"]',
          image: "img||||src",
          title: ".product-title",
          url: ".product-title||||href",
          availability: [
            '[data-testid="medium-customer-price"]||||textContent',
            ".fulfillment-add-to-cart-button:not([disabled])",
            ".fulfillment",
            ".c-ratings-reviews"
          ]
        }
      },
      "brick-and-mortar": "verb-miner-function-bestbuy-mine-brick-and-mortar",
      config: {
        "brick-and-mortar-max-radius-in-miles": 25
      }
    },
    {
      id: "bestchoiceproducts",
      name: "Best Choice Products",
      category_tags: [
        "home-garden"
      ],
      base: "bestchoiceproducts.com",
      paths: [
        "variant=(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]||||offers.0.gtin12',
          "substring(substring-after(//script[contains(text(),'barcode')],'barcode'),4,12)"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.0.price',
          "normalize-space(//span[@itemprop='price'])"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "substring(substring-after(//meta[@property='og:image']/@content,'/products/'),1,7)"
        ],
        title: "//h1[@itemprop='name']"
      }
    },
    {
      id: "betterworldbooks",
      name: "BetterWorldBooks",
      category_tags: [
        "books"
      ],
      base: "betterworldbooks.com",
      paths: [
        "\\/product\\/detail\\/(?<identifier>[A-Za-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(5)||||offers.0.gtin13',
          "//div[@class='col-sm-6'][label[text()='ISBN-13']]/span[@itemprop='isbn']/text()",
          "substring-before(substring-after(//link[@id='cphHead_CanonicalLink']/@href,'id-'),'.')"
        ],
        cost: "(//div[@id='MainContentPlaceHolder_SideBar_RightRailItemPriceDisplay_NewPriceBox']//em)[2]",
        title: "//div[@class='info-text']/h2"
      }
    },
    {
      id: "beveragewarehousemi",
      name: "beveragewarehousemi",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "beveragewarehousemi.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability',
          "normalize-space(//button[contains(@class, 'ProductForm__AddToCart')]/span/text())"
        ],
        barcode: "//input[@name='product-id']/@value",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||sku',
          "//option[@data-sku='151170']/@data-sku"
        ]
      }
    },
    {
      id: "bhphotovideo",
      base: "bhphotovideo.com",
      name: "B&H",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[\\w+]+)\\.html",
        "/\\/c\\/product\\/(?<identifier>\\d+)-/"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          "//span[@data-selenium='stockStatus']/text()",
          'json||||script[type="application/ld+json"]||||offers.availability',
          "verb-miner-function-bhphotovideo-ore-json:offers.0.availability",
          "//div[@class='stockStatus']/text()"
        ],
        barcode: [
          "substring-after(//div[contains(@class, 'upc_')]/div[@data-selenium='overviewUpcText']/text(), 'UPC:')",
          "substring-after(//div[@data-selenium='overviewUpcText'],'UPC: ')",
          "substring(substring-after(//script[contains(text(),'upc')],'upc'),4,12)"
        ],
        brand: [
          "verb-miner-function-bhphotovideo-ore-json:brand.name",
          "//img[@data-selenium='authorizeDealerBrandImage']/@alt"
        ],
        condition: "verb-miner-function-bhphotovideo-ore-json:offers.0.itemCondition",
        cost: [
          "div[data-selenium='pricingPrice']||||text",
          "//div[@class='price__9gLfjPSjp']/text()",
          'json||||script[type="application/ld+json"]||||offers.price',
          "//div[contains(@class, 'pricesContainer')]/div[contains(@class, 'price')]/text()",
          "verb-miner-function-bhphotovideo-ore-json:offers.0.price",
          "//div[@data-selenium='pricingPrice']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          "verb-miner-function-bhphotovideo-ore-json:offers.0.priceCurrency"
        ],
        delivery: "//div[@class='shipInfoLayer']//text()",
        image: "verb-miner-function-bhphotovideo-ore-json:image",
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn',
          "verb-miner-function-bhphotovideo-ore-json:mpn",
          "substring-after(//div[@data-selenium='codeCrumb'],' • MFR #')"
        ],
        title: [
          "verb-miner-function-bhphotovideo-ore-json:title",
          "//h1[@data-selenium='productTitle']/text()"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "verb-miner-function-bhphotovideo-ore-json:sku"
        ],
        url: [
          "verb-miner-function-bhphotovideo-ore-json:url",
          "verb-miner-function-bhphotovideo-ore-json:offers.0.url"
        ]
      },
      scout: {
        path: "/c/search?q={{query}}&N=0&InitialSearch=yes&sts=ma",
        items: [
          './/div[@data-selenium="miniProductPage"]',
          ".search-result-listview-item",
          "ul.search-result-gridview-items li"
        ],
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: './/span[@data-selenium="uppedDecimalPriceFirst"]',
          image: './/img[@data-selenium="miniProductPageImg"]/@src',
          title: './/span[@data-selenium="miniProductPageProductName"]',
          url: './/a[@data-selenium="miniProductPageProductNameLink"]/@href'
        }
      }
    },
    {
      id: "biblio",
      name: "Biblio",
      category_tags: [
        "books"
      ],
      base: "biblio.com",
      paths: [
        "\\/(.+)\\/(.+)\\/(.+)\\/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]||||isbn',
          'json||||script[type="application/ld+json"]||||offers.gtin13',
          "//span[@itemprop='gtin13']/@content"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//span[contains(@class, 'price') and contains(text(), '$')]/text()",
          "//span[@class='item-price']"
        ],
        title: [
          'json||||script[type="application/ld+json"]||||name',
          "//h1"
        ],
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//meta[@property='og:availability']/@content"
        ]
      }
    },
    {
      id: "bigapplebuddy",
      name: "bigapplebuddy",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/product\\/8\\/(?<identifier>[^\\/]+)/"
      ],
      base: "www.bigapplebuddy.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//div[contains(@class, 'P-available')]/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin12',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          "//span[@id='P-sale_price']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.priceCurrency'
        ],
        model: "//span[@class='P-model_number']/text()",
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ]
      }
    },
    {
      id: "bigsandysuperstore",
      name: "Big Sandy",
      category_tags: [
        "home-garden"
      ],
      base: "bigsandysuperstore.com",
      paths: [
        "\\/(?<identifier>[\\w-]+)$"
      ],
      ore: {
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.3.offers.price',
          "//div[@class='ca-promotional-widget jss233']/@data-widget-item-price"
        ],
        model: [
          "json||||#__NEXT_DATA__||||props.pageProps.initialState.statusSlice.fetchProduct.payload.model_number",
          "//meta[@name='keywords']/@content",
          "substring-after(//div[contains(@id, 'videoly-product-id')]/text(), 'Model #: ')"
        ],
        sku: "//div[@id='videoly-product-sku']/text()",
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.3.offers.availability',
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.object.gtin12',
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ]
      }
    },
    {
      id: "bigw",
      name: "bigw",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\/product\\/[^\\/]+\\/(?<identifier>\\w+)"
      ],
      base: "www.bigw.com.au",
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
        ],
        cost: [
          "//span[@class='Price variant-huge']/span[@class='dollars']/text()"
        ],
        currency: [
          "//sup[@data-testid='price-symbol']/@content",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
        ],
        sku: [
          "//div[contains(@class, 'ProductSpecification')]/dd[contains(text(), 'Article Number')]/following-sibling::dt/text()",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ]
      }
    },
    {
      id: "bing",
      name: "Base",
      "is-aggregator": true,
      paths: [],
      base: "bing.com",
      scout: "verb-miner-function-bing-scout"
    },
    {
      id: "biotherm",
      name: "biotherm",
      category_tags: [
        "beauty"
      ],
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "www.biotherm.ca",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.availability',
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||sku',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.price',
          "//span[@data-js-saleprice]/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||sku'
        ]
      }
    },
    {
      id: "bjs",
      base: "www.bjs.com",
      name: "BJ's Wholesale Club",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\/product\\/(?<identifier>[a-zA-Z\\-0-9\\/]+)-"
      ],
      ore: {
        availability: [
          `json||||script[type="application/ld+json"][contains(text(), '"offers"')]||||offers[0].availability`,
          'button[class*="AddToCart"]'
        ],
        barcode: [
          "json||||script:nth-of-type(27)||||productDetailsData.descriptiveAttributes.13.name",
          "verb-miner-function-bjs-ore-barcode"
        ],
        cost: [
          "json||||script:nth-of-type(26)||||productDetailsData.maxItemPrice",
          "verb-miner-function-bjs-ore-json:minItemPrice"
        ],
        title: "verb-miner-function-bjs-ore-json:entitledItems.0.description.name",
        image: "verb-miner-function-bjs-ore-json:productImages.fullImage",
        mpn: "json||||script:nth-of-type(26)||||productDetailsData.bjsitems.0.partNumber"
      },
      scout: false
    },
    {
      id: "blnts",
      base: "blnts.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)"
      ],
      ore: {
        cost: "//span[@class='product__price2']//text()",
        delivery: "//div[@class='shipping-store-returns desktop_']//text()",
        discount_cost: "//span[@class='discounted']//text()",
        title: ".//h1[@class='product-single__title']//text()"
      },
      scout: {
        path: "/search?q={{query}}",
        items: './/div[@class="plp-spot-products"]/@data-variants-json',
        ore: {
          availability: "true",
          barcode: "product_id",
          cost: "price",
          image: "featured_image.src",
          mpn: "featured_image.product_id",
          title: "name"
        }
      }
    },
    {
      id: "bodeliquors",
      name: "bodeliquors",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/product/[^/]+/(?<identifier>[a-f0-9]{24})"
      ],
      base: "bodeliquors.com",
      ore: {
        availability: [
          "json||||#product-metadata||||offers.availability",
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          "json||||#product-metadata||||offers.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#product-metadata||||offers.priceCurrency",
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: "//meta[@property='ch:product:id']/@content"
      }
    },
    {
      id: "boip",
      name: "boip",
      paths: [
        "/home/(?<identifier>[^/]+)"
      ],
      base: "boip.in",
      ore: {
        availability: "//span[@id='availability_value']/text()",
        cost: "//span[@id='our_price_display']/text()",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        model: "//td[contains(text(), 'Model No')]/following-sibling::td/text()"
      }
    },
    {
      id: "bonanza",
      name: "Bonanza",
      category_tags: [
        "sells-everything"
      ],
      base: "bonanza.com",
      paths: [
        "\\/.*\\/(?<identifier>[0-9]+)"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        asin: "normalize-space(//th[contains(text(),'ASIN:')]/following-sibling::*)",
        availability: [
          "//meta[@property='product:availability']/@content",
          "json||||script[type='application/ld+json']||||offers.availability",
          "normalize-space(//div[contains(@class,'availability') or contains(@class,'stock')])",
          "normalize-space(//span[contains(@class,'inventory') or contains(@class,'stock')])",
          "normalize-space(//div[contains(text(),'Stock') or contains(text(),'Available')])"
        ],
        barcode: [
          "normalize-space(//th[contains(text(),'UPC:')]/following-sibling::*)",
          "normalize-space(//th[contains(text(),'EAN:')]/following-sibling::*)",
          "normalize-space(//th[contains(text(),'ISBN')]/following-sibling::*)"
        ],
        brand: "normalize-space(//th[contains(text(),'Brand:')]/following-sibling::*)",
        cost: "//div[@class='item_price']",
        marketplaceSellerName: "//meta[@property='wanelo:store:name']/@content",
        mpn: "normalize-space(//th[contains(text(),'MPN:')]/following-sibling::*)",
        sku: "substring-after(substring-after(//link[@rel='canonical']/@href,'/listings/'),'/')",
        title: "//meta[@property='og:title']/@content"
      },
      scout: {
        path: "/items/search?q[catalog_id]=&q[country_to_filter]=US&q[filter_category_id]=&q[in_booth_id]=&q[ship_country]=1&q[shipping_in_price]=0&q[sort_by]=relevancy&q[translate_term]=true&q[search_term]={{query}}",
        items: ".search_result_list_wrapper .list_style_row",
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: ".results_price1",
          image: ".column_item_picture img||||src",
          title: ".results_title",
          url: ".results_title a||||href"
        }
      }
    },
    {
      id: "bookdepository",
      name: "The Book Depository",
      category_tags: [
        "books"
      ],
      base: "bookdepository.com",
      paths: [],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        barcode: "//li/label[contains(text(), 'ISBN13')]/following-sibling::span",
        cost: "normalize-space((//p[@class='price'])[1]/text())",
        sku: "//li/label[contains(text(), 'ISBN13')]/following-sibling::span",
        title: "//div[@class='item-info']/h1"
      }
    },
    {
      id: "bookoutlet",
      name: "Book Outlet",
      category_tags: [
        "books"
      ],
      base: "bookoutlet.com",
      paths: [
        "\\/Store\\/Details\\/(?<identifier>[0-9A-Z]+)",
        "/products/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "json||||#__NEXT_DATA__||||props.pageProps.details.isbn13_1",
          "//meta[@property='book:isbn']/@content",
          "//span[@itemprop='isbn']"
        ],
        cost: "//span[@itemprop='price']",
        title: "//h4[@itemprop='name']",
        availability: "//p[contains(text(), 'Available:')]"
      }
    },
    {
      id: "booksamillion",
      name: "BooksAMillion",
      category_tags: [
        "books"
      ],
      base: "booksamillion.com",
      paths: [
        "\\/p\\/(.+)\\/(.+)\\/(?<identifier>[A-Z0-9]+)"
      ],
      scout: {
        path: "https://www.booksamillion.com/search?query={{query}}",
        items: ".search-result-item",
        ore: {
          title: ".search-item-title a",
          cost: ".our-price",
          url: ".search-item-title a||||href",
          image: "img||||src",
          availability: ".stockGreen, .stockRed"
        }
      },
      ore: {
        barcode: [
          "//meta[@property='product:retailer_item_id']/@content",
          "substring-after((//*[contains(.,'ISBN-13')])[last()-1],': ')",
          "substring-after((//*[contains(.,'EAN')])[last()-1],': ')",
          "substring-after((//*[contains(.,'UPC') or contains(.,'PID')])[last()-1],': ')"
        ],
        brand: "(//div[@id='key' and ./strong[contains(text(),'Brand Name')]]/following-sibling::div)[1]",
        cost: [
          "json||||#product_description_json||||price_data.online_price",
          "//meta[@property='product:price:amount']/@content",
          "(//span[@style='color:#003366; font-size: 28px' or @class='details-title-text']/strong)[last()]"
        ],
        mpn: [
          "(//div[@id='key' and ./strong[contains(text(),'Manufacturer Part Number')]]/following-sibling::div)[1]"
        ],
        title: "(//span[@class='details-title-text'])[1]",
        availability: "//meta[@property='product:availability']/@content"
      },
      __urls_regulator: [
        {
          url: "https://www.booksamillion.com/p/Camp/Kayla-Miller/9781328530820",
          availability: "in",
          description: "In Stock Book - Graphic Novel"
        },
        {
          url: "https://www.booksamillion.com/p/Best-Friends/Shannon-Hale/9781250317469",
          availability: "in",
          description: "In Stock Book - Graphic Novel"
        },
        {
          url: "https://www.booksamillion.com/p/Adventure-Time-Complete-Series/John-Dimaggio/K883929664016",
          availability: "in",
          description: "In Stock Media - DVD"
        },
        {
          url: "https://www.booksamillion.com/p/STAR-WARS-OUTLAWS/alliance-entertainment/F887256115920",
          availability: "in",
          description: "In Stock Game"
        },
        {
          url: "https://www.booksamillion.com/p/PRG-DNS-COMBINING-ZORDS-MOSA/alliance-entertainment/F5010993933655",
          availability: "pre-order",
          description: "Pre-order Toy"
        },
        {
          url: "https://www.booksamillion.com/p/Life-Lazy-Susan-Sht-Sandwiches/Jennifer-Welch/9781335550989",
          availability: "pre-order",
          description: "Pre-order Book"
        },
        {
          url: "https://www.booksamillion.com/p/Oh-Places-Youll-Go/Dr-Seuss/9780679805274",
          availability: "unknown",
          description: "Unknown Availability Book"
        },
        {
          url: "https://www.booksamillion.com/p/LEGO-Architecture-New-York-City/LEGO/F673419247160",
          availability: "unknown",
          description: "Unknown Availability LEGO"
        }
      ]
    },
    {
      id: "boomstore",
      name: "boomstore",
      paths: [],
      base: "www.boomstore.de",
      ore: {
        availability: "//div[contains(@class, 'c-takeaway__status--unavailable')]/span[@class='c-takeaway__text']/text()",
        barcode: "//meta[@itemprop='gtin13']/@content",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "box",
      name: "box",
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "www.box.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//p[contains(@class, 'p-stock')]/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]||||gtin13',
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//span[@class='pq-price']/text()"
        ],
        currency: [
          "json||||script:nth-of-type(33)||||currency"
        ],
        mpn: 'json||||script[type="application/ld+json"]||||mpn',
        sku: [
          "json||||script:nth-of-type(37)||||sku"
        ]
      }
    },
    {
      id: "broadscopeit",
      name: "broadscopeit",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "broadscopeit.com.au",
      ore: {
        availability: [
          "json||||#ProductJson-product-template||||available",
          "//link[@itemprop='availability']/@href"
        ],
        barcode: [
          "json||||#ProductJson-product-template||||variants.0.barcode"
        ],
        cost: [
          "json||||#ProductJson-product-template||||price",
          "//meta[@itemprop='price']/@content"
        ],
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: [
          "json||||script:nth-of-type(27)||||product.variants.0.sku",
          "//select[@id='productSelect-product-template']/option/@data-sku"
        ]
      }
    },
    {
      id: "brownells",
      name: "brownells",
      category_tags: [
        "sports-outdoors"
      ],
      base: "www.brownells.com",
      paths: [
        "\\/\\?sku=(?<identifier>\\d+)"
      ],
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
        barcode: "//div[contains(@class, 'pdp-info__attr-upc')]/div[@class='pdp-info__attr-value']/text()",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//span[contains(@v-text, 'variant?.formattedProductCurrentPrice ??')]//text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency',
          "//html/@currency-code"
        ],
        mpn: "//div[contains(@class, 'pdp-info__attr-item') and contains(.//div[@class='pdp-info__attr-title'], 'MFR #')]/div[@class='pdp-info__attr-value']/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.sku'
        ]
      }
    },
    {
      id: "brownthomas",
      name: "brownthomas",
      paths: [
        "\\/(?<identifier>\\d+)\\.html$"
      ],
      base: "brownthomas.com",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        model: "//span[@class='product-collection']/text()"
      }
    },
    {
      id: "bueromarkt-ag",
      name: "bueromarkt-ag",
      category_tags: [
        "office-supplies"
      ],
      paths: [],
      base: "www.bueromarkt-ag.de",
      ore: {
        availability: "//div[contains(@class, 'product-delivery-information')]/text()",
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin',
        cost: [
          'json||||script[type="text/plain"]:nth-of-type(2)||||items.0.price',
          "//span[@class='product_price mainPrice']/text()"
        ],
        currency: [
          'json||||script[type="text/plain"]:nth-of-type(2)||||currency'
        ],
        model: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku'
        ],
        mpn: "//input[@name='product'][@value='mhje3zm']/@value"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "bunnings",
      name: "bunnings",
      category_tags: [
        "home-garden"
      ],
      paths: [],
      base: "www.bunnings.com.au",
      ore: {
        availability: "json||||#__NEXT_DATA__||||props.pageProps.initialState.global.sitecoreData.sitecore.route.placeholders.retail-main.2.fields.allInventoryData.fields.singleItemOOSInfo.value",
        currency: "json||||#__NEXT_DATA__||||runtimeConfig.env.CURRENCY_SYMBOL",
        model: [
          "//div[@data-locator='Model_Number']/following-sibling::div/text()"
        ],
        sku: [
          "json||||#productdescription-schema||||sku"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "buydeal",
      name: "buydeal",
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "buydeal.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability',
          "//button[@type='submit' and @data-action='add-to-cart']"
        ],
        barcode: 'json||||script[type="application/json"]:nth-of-type(3)||||product.variants.0.barcode',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          "json||||script:nth-of-type(45)||||product.variants.0.sku",
          "//span[contains(@class, 'product-meta__sku-number')]/text()"
        ]
      }
    },
    {
      id: "cabelas",
      name: "cabelas",
      category_tags: [
        "sports-outdoors"
      ],
      base: "www.cabelas.com",
      paths: [
        "/en/(?<identifier>[\\w-]+)\\?"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//span[@id='InventoryStatus_OnlineStatus_29837']/@content"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency',
          "//input[@name='currency']/@value"
        ],
        mpn: [
          "json||||div:nth-of-type(24)||||partNumber"
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku'
      }
    },
    {
      id: "campsaver",
      name: "CampSaver",
      category_tags: [
        "sports-outdoors"
      ],
      base: "campsaver.com",
      paths: [
        "(?<identifier>.+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="application/json"]:nth-of-type(18)||||variantSelector.variants.0.upc',
          "//span[contains(text(), 'UPC:')]//following-sibling::text()",
          "substring-after(//p[@class='_1qOHIuFe']//following-sibling::*[2],'UPC: ')"
        ],
        brand: "//img[@id='page-header-logo-img']/@alt",
        cost: [
          "//meta[@property='product:price:amount']/@content",
          "//span[@class='_2gqTMeEs']"
        ],
        mpn: [
          "//p[contains(@class, 'nBUOJt')]/span[text()='MPN: ']/following-sibling::text()",
          "substring-after(//p[@class='_1qOHIuFe']//following-sibling::*,'MPN: ')"
        ],
        title: "//h1",
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||sku'
      }
    },
    {
      id: "carid",
      name: "CARiD",
      category_tags: [
        "automotive"
      ],
      base: "carid.com",
      paths: [
        "\\/(.+)\\/(?<identifier>.+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          "//div[contains(text(), 'UPC:')]/following-sibling::div[1]/text()",
          "//div[contains(text(),'UPC:')]/following-sibling::*"
        ],
        brand: "substring-before(//h1[@itemprop='name'],'Â®')",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[@class='prod-price-h']//span[contains(text(), '$')]"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
          "//div[@id='prod-mpn-holder']/@data-id",
          "//div[contains(@class, 'prod-offer-item') and .//*[contains(text(), 'Part Number')]]/div[@class='prod-offer-content']/text()",
          "//div[@class='prod-offer-title'][contains(text(),'Part Number:')]/following-sibling::*/a"
        ],
        sku: "//span[@itemprop='sku']",
        title: "//h1[@itemprop='name']",
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//div[contains(@class, 'prod-avail')]/span[@class='js-deliver-text']/text()"
        ],
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
      }
    },
    {
      id: "carparts",
      category_tags: [
        "automotive"
      ],
      base: "carparts.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)"
      ],
      ore: {
        cost: "//span[@class='StyledText-sc-1sadyjn-0 fAsTit']//text()",
        delivery: "//div[@class='StyledBox-sc-13pk1d4-0 fOgupB']//text()",
        mpn: [
          "//span[contains(text(), 'Manufacturer #')]//text()[normalize-space()]/following-sibling::text()"
        ],
        title: ".//div[@id='skuTitle']//text()",
        availability: "//button[contains(@class, 'StyledButton')]/span[@class='StyledText-sc-1sadyjn-0 gifylv']/text()"
      },
      scout: {
        path: "/search?q={{query}}",
        items: './/div[@id="MainSectionGrid"]/div',
        ore: {
          cost: './/span[@class="StyledText-sc-1sadyjn-0 ggPidu"]/text()',
          image: './/div[contains(@class,"StyledBox-sc")]/img/@src',
          title: './/span[contains(@id,"productTitle")]//text()',
          url: './/div[@class="StyledBox-sc-13pk1d4-0 bwuCQW"]/a/@href'
        }
      }
    },
    {
      id: "castlemaineofficesupplies",
      name: "castlemaineofficesupplies",
      category_tags: [
        "office-supplies"
      ],
      paths: [
        "/products/(?<identifier>[^/]+)$"
      ],
      base: "castlemaineofficesupplies.com.au",
      ore: {
        availability: [
          'json||||script[type="text/javascript"]:nth-of-type(3)||||available',
          "//p[contains(@class, 'items_left')]/text()"
        ],
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(12)||||barcode',
        cost: [
          "//meta[@property='og:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(12)||||sku'
        ]
      }
    },
    {
      id: "cellbuddy",
      name: "cellbuddy",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/store/(?<identifier>[^/]+)/"
      ],
      base: "cellbuddy.in",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.0.availability',
          "//button[contains(text(), 'Add to cart')]"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.0.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.0.priceSpecification.priceCurrency'
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku'
        ]
      }
    },
    {
      id: "centralwinemerchants",
      name: "centralwinemerchants",
      category_tags: [
        "grocery-food"
      ],
      paths: [],
      base: "www.centralwinemerchants.com",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        barcode: "//meta[@itemprop='gtin8']/@content",
        cost: "//div[@class='price']/text()",
        currency: "//meta[@property='og:price:currency']/@content",
        sku: "//td[contains(@class, 'prodata_cat') and contains(text(), 'Sku')]/following-sibling::td[@itemprop='sku']/text()"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "chegg",
      name: "Chegg",
      category_tags: [
        "books"
      ],
      base: "chegg.com",
      paths: [
        "\\/(.+)\\/(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "json||||#__NEXT_DATA__||||props.pageProps.purchaseOptions.1.ean",
          "//span[@data-test='pdp-quick-info-ean']/text()",
          "//div[@class='txt-2 book-biblio-label' and contains(text(), 'ISBN-13')]/following-sibling::h2"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//p[contains(@class, 'styles__TotalPrice')]/span/text()",
          "//div[@class='purchase-option C-common-form']//div[@class='purchase-option-price']"
        ],
        title: "//span[@itemprop='name']",
        availability: "//button[@id='addToCartButton-rent']/span/span[1]/text()",
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
      }
    },
    {
      id: "chemistwarehouse",
      name: "chemistwarehouse",
      category_tags: [
        "health-pharmacy"
      ],
      paths: [
        "/buy/(?<identifier>\\d+)"
      ],
      base: "www.chemistwarehouse.com.au",
      ore: {
        availability: "//div[@itemprop='availability']/@content",
        cost: "//span[@class='product__price']/text()",
        currency: "//meta[@itemprop='Currency']/@content",
        sku: [
          "json||||script:nth-of-type(19)||||ecomm_prodid",
          "//input[@id='skuId']/@value"
        ]
      }
    },
    {
      id: "chewy",
      name: "Chewy",
      category_tags: [
        "pet-supplies"
      ],
      base: "chewy.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)",
        ".*\\/(?<identifier>.+)\\/",
        "\\/dp\\/(?<identifier>\\d+)",
        "\\/dp\\/(?<identifier>\\d+)"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          "//div[@data-testid='inventory-status']//text()",
          "//div[@data-testid='availability-message']//text()",
          "//div[contains(@class, 'inventory-status')]//text()",
          "//span[contains(@class, 'availability')]//text()",
          "json||||#__NEXT_DATA__||||props.pageProps.pageData.pdpAvailability",
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability'
        ],
        brand: "//span[@data-testid='manufacture-name']/a//text()",
        cost: [
          "//div[@data-testid='advertised-price']//text()",
          "p.price > span.ga-eec__price"
        ],
        delivery: "//div[@data-testid='shipping-message']//text()",
        title: [
          "//div[@data-testid='product-title']/text()",
          "#product-title h1"
        ],
        mpn: "json||||#__NEXT_DATA__||||props.pageProps.pageData.pdpProductPartNumber",
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin12'
      },
      scout: {
        path: "/s?query={{query}}",
        items: './/div[contains(@class,"ProductListing")]/div',
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          availability: [
            ".//div[contains(@class, 'inventory-status')]//text()",
            ".//span[contains(@class, 'availability')]//text()",
            ".//div[@data-testid='product-availability']//text()"
          ],
          cost: './/div[@class="priceView-hero-price priceView-customer-price"]/span[1]/text()',
          image: './/a[@class="kib-product-image product-card-image"]/img/@src',
          title: './/div[@class="kib-product-title__text"]//text()',
          url: './/div[@class="kib-product-card__content"]//a/@href'
        }
      }
    },
    {
      id: "choicethediscountstore",
      name: "choicethediscountstore",
      paths: [],
      base: "www.choicethediscountstore.com.au",
      ore: {
        availability: "//span[@itemprop='availability' and contains(@class, 'sold-out')]/text()",
        barcode: "substring-after(//div[@class='tabless']/text(),'EAN/UPC: ')",
        cost: "//div[contains(@aria-label, 'Store Price')]/text()",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "ciceksepeti",
      name: "ciceksepeti",
      category_tags: [
        "home-garden"
      ],
      paths: [],
      base: "www.ciceksepeti.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//input[@id='productCode']/@value"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "coles",
      name: "coles",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "-(?<identifier>\\d+)$"
      ],
      base: "www.coles.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.0.availability'
        ],
        cost: [
          "//section[@data-testid='product_price']//span[@class='price__value']/text()",
          'json||||script[type="application/ld+json"]||||offers.0.price',
          "//span[@class='price__value']/text()"
        ],
        currency: 'json||||script[type="application/ld+json"]||||offers.0.priceCurrency',
        sku: [
          "//p[contains(., 'Code:')]/text()",
          'json||||script[type="application/ld+json"]||||sku'
        ],
        barcode: 'json||||script[type="application/ld+json"]||||sku'
      }
    },
    {
      id: "comet",
      name: "comet",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\?currency=GBP&variant=(?<identifier>\\d+)"
      ],
      base: "comet.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//div[contains(@class, 'in-stock')]/text()"
        ],
        barcode: "json||||script:nth-of-type(59)||||barcode",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          "//meta[@property='og:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        mpn: "substring-after(//div[contains(@class, 'product-part-number')]/text(), 'Part number: ')",
        sku: [
          "//button[@data-sku]/@data-sku"
        ]
      }
    },
    {
      id: "comkex",
      name: "comkex",
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "comkex.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.0.availability'
        ],
        barcode: 'json||||script[type="application/ld+json"]||||@graph.1.gtin12',
        cost: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.0.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.0.priceSpecification.priceCurrency'
        ],
        mpn: "//tr[contains(@class, 'woocommerce-product-attributes-item--attribute_pa_mpn')]/td/p/text()",
        sku: [
          'json||||script[type="application/ld+json"]||||@graph.1.sku',
          "//span[@class='sku']"
        ]
      }
    },
    {
      id: "compsource",
      name: "CompSource",
      category_tags: [
        "electronics"
      ],
      base: "compsource.com",
      paths: [
        "newtechnote.asp?part_no=(?<identifier>[A-Z0-9]+)"
      ],
      scout: null,
      ore: {
        barcode: "//td[contains(.,'Product UPC')]/following-sibling::td",
        brand: "//td[contains(.,'Brand Name')]/following-sibling::td",
        cost: "//div[@class='product-details']/p/b[@class='red' or @class='black']",
        mpn: "//td[contains(.,'Manufacturer Part Number')]/following-sibling::td",
        sku: "//form[@name='product']/input[@name='sku']/@value",
        title: "//div[@id='product-details-container2']/h1"
      }
    },
    {
      id: "computechstore",
      name: "computechstore",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "computechstore.in",
      ore: {
        availability: [
          "json||||.rank-math-schema-pro||||@graph.4.offers.availability",
          "//meta[@property='product:availability']/@content"
        ],
        barcode: "//a[contains(@href, 'ean-upc-code')]/text()",
        cost: [
          "json||||.rank-math-schema-pro||||@graph.4.offers.price",
          "//p[contains(@class, 'price')]/span[@class='woocommerce-Price-amount amount']/bdi/text()"
        ],
        currency: [
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: "//div[contains(@class, 'product-item')]/a[@data-product_sku='XBXS-CNTRLR-RD']/@data-product_sku"
      }
    },
    {
      id: "comspot",
      name: "comspot",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/product\\/(?<identifier>\\d+)"
      ],
      base: "www.comspot.de",
      ore: {
        barcode: "//meta[@itemprop='gtin12']/@content",
        cost: [
          "json||||script:nth-of-type(5)||||ecommerce.detail.products.0.price",
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          "json||||script:nth-of-type(5)||||ecommerce.currencyCode",
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        sku: [
          "json||||#footer--js-inline||||sku"
        ]
      }
    },
    {
      id: "conns",
      name: "Conn's",
      category_tags: [
        "electronics",
        "appliances"
      ],
      base: "conns.com",
      paths: [
        "(?<identifier>.+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(20)||||product_attributes.upc',
          "//td[@class='upc-label td-title']/following-sibling::td[contains(@class, 'tb_title_pdp')]/text()",
          "//th[contains(text(), 'UPC')]/following-sibling::td"
        ],
        brand: "//th[contains(text(), 'Brand')]/following-sibling::td",
        cost: [
          "//h3[@class='atp-main-product pt-16']/text()",
          "(//span[@class='price'])[last()]"
        ],
        mpn: [
          "//meta[@itemprop='mpn']/@content",
          "//th[contains(text(), 'Manufacture SKU')]/following-sibling::td"
        ],
        sku: "//th[contains(text(), 'Conn')]/following-sibling::td",
        title: "//div[@class='product-name']",
        availability: "//meta[@property='og:availability']/@content"
      }
    },
    {
      id: "cosrx",
      name: "cosrx",
      category_tags: [
        "beauty"
      ],
      base: "www.cosrx.com",
      paths: [
        "/products/(?<identifier>[^?]+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//*[contains(@class, 'quantity-submit-row__submit')]//button/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          "//span[contains(@class, 'current-price')]/text()"
        ],
        currency: [
          "json||||script:nth-of-type(59)||||currency",
          "//meta[@property='og:price:currency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ]
      }
    },
    {
      id: "costco",
      name: "Costco",
      category_tags: [
        "sells-everything"
      ],
      base: {
        "*-us": "costco.com",
        keyCountry: "www.costco.com.au"
      },
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)\\.html",
        ".*\\/(?<identifier>.+)\\.html",
        "\\/p\\/(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          "json||||#schemaorg_product||||offers.availability",
          "//button[contains(text(), 'Add to cart')]/text()",
          'json||||script[type="text/javascript"]:nth-of-type(26)||||inventory',
          "//p[contains(@class, 'comingsoon-alert')]/text()"
        ],
        brand: "//div[@itemprop='brand']/text()",
        cost: [
          "json||||#schemaorg_product||||offers.price",
          "//meta[@property='product:price:amount']/@content",
          "//span[@class='value']/text()",
          "verb-miner-function-costco-ore-cost",
          "//span[@automation-id='onlinePriceOutput']/text()"
        ],
        delivery: "//div[contains(@class,'new-edd-expected-date']//text()",
        mpn: [
          'json||||script[type="text/javascript"]:nth-of-type(26)||||manufacturerPartNumber',
          "//input[@name='productPartnumber']/@value",
          "//div[@data-bv-show='rating_summary']/text()"
        ],
        title: "//h1[@automation-id='productName']/text()",
        itemId: "#catEntryId||||value",
        catalogId: "#catalogId||||value",
        productId: "input[name='productBeanId']||||value",
        model: [
          "//div[@id='product-body-model-number']/span/@data-model-number"
        ],
        sku: [
          "json||||#schemaorg_product||||sku",
          'json||||script[type="text/javascript"]:nth-of-type(26)||||partNumber'
        ],
        currency: [
          "json||||#schemaorg_product||||offers.priceCurrency",
          "//meta[@property='product:price:currency']/@content"
        ]
      },
      "brick-and-mortar": "verb-miner-function-costco-brick-and-mortar",
      scout: {
        path: "/CatalogSearch?dept=All&keyword={{query}}",
        items: [
          './/div[@automation-id="productList"]/div[contains(@class,"product")]',
          ".product"
        ],
        ore: {
          cost: [
            './/div[contains(@automation-id,"itemPriceOutput")]/text()',
            ".price"
          ],
          image: [
            './/a[@class="product-image-url"]/img/@src',
            ".img-responsive||||src"
          ],
          title: [
            './/span[@class="description"]/a/text()',
            ".description"
          ],
          url: [
            './/span[@class="description"]/a/@href',
            ".product-image-url||||href"
          ]
        }
      }
    },
    {
      id: "craftedwinebeerspirits",
      name: "craftedwinebeerspirits",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/product/[^/]+/(?<identifier>[a-f0-9]{24})"
      ],
      base: "shop.craftedwinebeerspirits.com",
      ore: {
        availability: [
          "json||||#product-metadata||||offers.availability",
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          "json||||#product-metadata||||offers.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#product-metadata||||offers.priceCurrency",
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          "json||||#product-metadata||||sku"
        ]
      }
    },
    {
      id: "crooze",
      name: "crooze",
      paths: [
        "/products/(?<identifier>[^/]+)"
      ],
      base: "crooze.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.0.availability',
          "//div[@class='o-product-availability c-product-template__availability']/span[contains(text(), ' In Stock')]"
        ],
        barcode: 'json||||script[type="application/json"]:nth-of-type(3)||||variants.0.barcode',
        cost: [
          'json||||script[type="application/ld+json"]||||offers.0.price',
          "//div[contains(@class, 'o-product-pricing__price')]/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: "json||||script:nth-of-type(44)||||product.variants.0.sku"
      }
    },
    {
      id: "crutchfield",
      name: "Crutchfield",
      category_tags: [
        "electronics"
      ],
      base: "crutchfield.com",
      paths: [
        "\\/(?<identifier>[A-Za-z0-9\\-_\\/]+)\\/(.+)\\.html"
      ],
      scout: null,
      ore: {
        availability: "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.availability",
        condition: "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.itemCondition",
        cost: [
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.price",
          "*[data-cf-price]||||data-cf-price",
          "//div[@class='col-12 pricing-wrapper']//div[@class='price js-price']"
        ],
        currency: "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.priceCurrency",
        sku: [
          "verb-miner-function-default-ore-schemadotorg-product-json:sku",
          "normalize-space(substring-after(//p[@class='item-number d-none d-md-block'], 'Item #'))"
        ],
        title: [
          "verb-miner-function-default-ore-schemadotorg-product-json:name",
          "//h1[@class='prod-title']"
        ],
        mpn: "verb-miner-function-default-ore-schemadotorg-product-json:mpn"
      }
    },
    {
      id: "csmobiles",
      name: "csmobiles",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>\\d+)-[^\\/]+\\.html$"
      ],
      base: "csmobiles.com",
      ore: {
        availability: [
          'json||||script[type="text/javascript"]:nth-of-type(3)||||page.body_classes.product-available-for-order',
          "//meta[@property='product:availability']/@content"
        ],
        cost: "//span[@itemprop='price']/text()",
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(3)||||currency.sign',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        sku: "//span[@itemprop='sku']/text()"
      }
    },
    {
      id: "curated",
      name: "curated",
      base: "www.curated.com",
      paths: [
        "/products/(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability'
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.priceCurrency'
        ]
      }
    },
    {
      id: "cyberport",
      name: "cyberport",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\?DEEP=(?<identifier>[\\w-]+)"
      ],
      base: "www.cyberport.de",
      ore: {
        availability: "//div[@id='tooltipAvailabilityStoreTabStore-immediately-abholtheke']//span[contains(@data-tooltip-content-id, 'abholbereit_2_stunden')]/text()",
        cost: "//div[@class='price lh-1 fs-36 ff-rob fw-700 delivery-price ']/text()",
        mpn: "substring-after(//span[contains(@class, 'manufacturerNumber')]/text(), 'Herstellernummer: ')",
        sku: "substring-after(//div[@class='productID'][contains(text(), 'Artikelnummer')]/text(), 'Artikelnummer:')"
      }
    },
    {
      id: "datavision",
      name: "DataVision",
      category_tags: [
        "electronics"
      ],
      base: "datavision.com",
      paths: [
        "\\/products\\/(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//meta[@itemprop='gtin12']/@content",
          "//td[b/text() = 'UPC:']/following-sibling::td"
        ],
        brand: "//td[b/text() = 'Brand:']/following-sibling::td",
        cost: [
          "//meta[@itemprop='price']/@content",
          "//td[b/text() = 'Price:']/following-sibling::td/font/b/font/b"
        ],
        mpn: [
          "//li[contains(., 'MFR:')]/span[@class='specs2']/text()",
          "//span[contains(@class, 'specs2')][preceding-sibling::span[starts-with(text(), 'MFR') and normalize-space()!='']]/text()",
          "//li[contains(@class, 'specs') and contains(text(), 'MFR:')]/span[@class='specs2']/text()",
          "//td[b/text() = 'SKU:']/following-sibling::td"
        ],
        sku: [
          "json||||script:nth-of-type(61)||||sku",
          "//meta[@itemprop='productID']/@content",
          "//span[@itemprop='sku' and contains(@class, 'specs2')]/text()",
          "//input[@type='hidden' and @name='add']/@value"
        ],
        title: "//td[@class='page_title']",
        availability: [
          "json||||#back-in-stock-helper||||available",
          "//link[@itemprop='availability']/@href"
        ],
        model: [
          "//li[contains(@class, 'specs') and contains(text(), 'MFR:')]/span[@class='specs2']/text()",
          "//meta[@itemprop='productID']/@content"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(21)||||currency',
          "//meta[@itemprop='priceCurrency']/@content",
          'json||||script[type="text/javascript"]:nth-of-type(22)||||currency'
        ]
      }
    },
    {
      id: "davidjones",
      name: "davidjones",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/Product/(?<identifier>\\d+)"
      ],
      base: "www.davidjones.com",
      ore: {
        availability: [
          'json||||script[type="text/javascript"]:nth-of-type(20)||||items.0.availability',
          "//link[@itemprop='availability']/@href"
        ],
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(20)||||items.0.pricing.0.amount',
          "//span[@class='price-display']/text()"
        ],
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: 'json||||script[type="text/javascript"]:nth-of-type(20)||||items.0.piID'
      }
    },
    {
      id: "deal4",
      name: "deal4",
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "www.deal4.ca",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.gtin12',
        cost: [
          "//span[contains(@class, 'price-item--sale')]/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode"
        ]
      }
    },
    {
      id: "dealmonday",
      name: "dealmonday",
      paths: [],
      base: "dealmonday.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability'
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[@class='product-price-new']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
        ],
        model: 'json||||script[type="application/ld+json"]:nth-of-type(6)||||model',
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(6)||||sku'
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "dealsplant",
      name: "dealsplant",
      paths: [
        "\\?currency=INR&variant=(?<identifier>\\d+)"
      ],
      base: "www.dealsplant.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.price',
          "//span[contains(@class, 'price--highlight')]/text()"
        ],
        currency: "//meta[@property='product:price:currency']/@content",
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku'
      }
    },
    {
      id: "deepdiscount",
      name: "DeepDiscount",
      category_tags: [
        "toys-games"
      ],
      base: "deepdiscount.com",
      paths: [
        "\\/(.+)\\/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "json||||.ProductPageStrData||||gtin12",
          "normalize-space(//strong[text()='ISBN:']/following-sibling::text())",
          "substring-after(//li[contains(., 'UPC')],'UPC:')"
        ],
        cost: [
          "json||||.ProductPageStrData||||offers.price",
          "substring-after(//div[@class='aec-custprice'],'$')"
        ],
        sku: [
          "json||||.ProductPageStrData||||sku",
          "//li[contains(., 'Item #')]/text()"
        ],
        title: "//li[@class='aec-main-title']//h1",
        availability: "json||||.ProductPageStrData||||offers.availability",
        currency: "json||||.ProductPageStrData||||offers.priceCurrency"
      }
    },
    {
      id: "default",
      paths: [],
      ore: {
        availability: [
          "*[name='wanelo:product:availability']||||content",
          "*[property='wanelo:product:availability']||||content",
          "*[itemprop='wanelo:product:availability']||||content",
          "*[name='og:availability']||||content",
          "*[property='og:availability']||||content",
          "*[itemprop='og:availability']||||content",
          "*[name='og:price:availability']||||content",
          "*[property='og:price:availability']||||content",
          "*[itemprop='og:price:availability']||||content",
          "*[name='product:availability']||||content",
          "*[property='product:availability']||||content",
          "*[itemprop='product:availability']||||content",
          "*[name='availability']||||content",
          "*[property='availability']||||content",
          "*[itemprop='availability']||||content",
          "verb-miner-function-default-ore-schemadotorg-product-json:availability",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.availability",
          "verb-miner-function-default-ore-schemadotorg-offer-json:availability",
          "verb-miner-function-default-ore-oembed-json:offers.0.in_stock",
          "*[data-stock-status]||||data-stock-status",
          "*[data-inventory-status]||||data-inventory-status",
          ".stock-status",
          ".inventory-status",
          "*[class*='stock-status']",
          "*[class*='inventory']",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.inStock",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.stock",
          "substring-after(*[contains(text(), 'Stock Status:')]/text(), 'Stock Status:')",
          "substring-after(*[contains(text(), 'Availability:')]/text(), 'Availability:')",
          "*[data-availability-status]||||data-availability-status",
          "*[data-product-inventory]||||data-product-inventory",
          ".product-availability",
          "#availability-status",
          "*[name='stockStatus']||||content",
          "*[property='stockStatus']||||content",
          "*[data-qa='availability']||||data-qa"
        ],
        barcode: [
          "*[name='og:upc']||||content",
          "*[property='og:upc']||||content",
          "*[itemprop='og:upc']||||content",
          "*[name='book:isbn']||||content",
          "*[property='book:isbn']||||content",
          "*[itemprop='book:isbn']||||content",
          "*[name='product:upc']||||content",
          "*[property='product:upc']||||content",
          "*[itemprop='product:upc']||||content",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin8",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin12",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin13",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin14",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin15",
          "[itemtype='http://schema.org/Product'] *[itemprop='gtin14']",
          "[itemtype='http://schema.org/Product'] *[itemprop='gtin13']",
          "[itemtype='http://schema.org/Product'] *[itemprop='gtin12']",
          "[itemtype='http://schema.org/Product'] *[itemprop='gtin8']",
          "[itemtype='http://schema.org/Product'] *[itemprop='gtin']",
          "*[itemprop='gtin14']",
          "*[itemprop='gtin13']",
          "*[itemprop='gtin12']",
          "*[itemprop='gtin8']",
          "*[itemprop='gtin']",
          "//*[@itemprop='gtin8']/@content",
          "//*[@itemprop='gtin13']/@content",
          "//*[@itemprop='gtin14']/@content",
          "//*[@itemprop='isbn']/@content",
          "*[data-product-upc]||||product-upc",
          "*[data-isbn]||||data-isbn",
          "//*[@itemtype='http://schema.org/Product' or @itemtype='https://schema.org/Product' or @itemtype='http://schema.org/Offer' or @itemtype='https://schema.org/Offer' or @itemtype = 'http://data-vocabulary.org/Product' or @itemtype = 'https://data-vocabulary.org/Product']//*[@itemprop='gtin14' or @itemprop='gtin13' or @itemprop='gtin12' or @itemprop='gtin8' or @itemprop='isbn' or @itemprop='identifier']/@content",
          "//*[@itemtype='http://schema.org/Product' or @itemtype = 'http://data-vocabulary.org/Product']//*[@itemprop='gtin14' or @itemprop='gtin13' or @itemprop='gtin12' or @itemprop='gtin8' or @itemprop='isbn' or @itemprop='identifier']/text()",
          "//div[@data-loadbee-manufacturer='EAN']/@data-loadbee-product",
          "substring-after(*[contains(text(), 'UPC/EAN:')]/text(), 'UPC/EAN:')",
          "substring-after(*[contains(text(), 'UPC:')]/text(), 'UPC:')",
          "substring-after(*[contains(text(), 'EAN:')]/text(), 'EAN:')",
          "substring-after(*[contains(text(), 'GTIN:')]/text(), 'GTIN:')",
          "substring-after(*[contains(text(), 'Barcode:')]/text(), 'Barcode:')",
          "substring-after(*[contains(text(), 'barcode:')]/text(), 'barcode:')",
          "*[data-product-barcode]||||data-product-barcode",
          "*[data-barcode]||||data-barcode",
          ".product-barcode",
          "#product-barcode",
          "*[name='product:isbn']||||content",
          "*[property='product:isbn']||||content",
          "substring-after(*[contains(text(), 'ISBN-13:')]/text(), 'ISBN-13:')",
          "substring-after(*[contains(text(), 'ISBN-10:')]/text(), 'ISBN-10:')",
          "*[data-isbn-13]||||data-isbn-13",
          "*[data-isbn-10]||||data-isbn-10",
          "*[data-ean]||||data-ean",
          "*[data-jan]||||data-jan",
          "verb-miner-function-default-ore-schemadotorg-product-json:isbn",
          "verb-miner-function-default-ore-schemadotorg-product-json:isbn13",
          "verb-miner-function-default-ore-barcode"
        ],
        brand: [
          "verb-miner-function-default-ore-schemadotorg-product-json:manufacturer",
          "verb-miner-function-default-ore-schemadotorg-product-json:brand.name",
          "//*[@itemtype='http://schema.org/Product' or @itemtype = 'http://data-vocabulary.org/Product']//*[@itemprop='brand' or @itemprop='manufacturer']",
          "*[name='product:brand']||||content",
          "*[property='product:brand']||||content",
          "*[itemprop='product:brand']||||content",
          "//*[@itemprop='brand']/@content",
          "*[name='manufacturer']||||content",
          "*[property='manufacturer']||||content",
          "*[itemprop='manufacturer']||||content",
          "*[data-brand]||||data-brand",
          "*[data-product-brand]||||data-product-brand",
          ".brand-name",
          "#brand-name",
          "*[name='brand']||||content",
          "*[property='brand']||||content",
          "verb-miner-function-default-ore-schemadotorg-product-json:brand",
          "substring-after(*[contains(text(), 'Brand:')]/text(), 'Brand:')",
          "*[data-qa='brand']||||data-qa",
          "*[class*='brand-title']",
          "*[class*='product-brand']",
          "verb-miner-function-default-ore-schemadotorg-organization-json:name",
          "*[data-testid='brand']||||data-testid"
        ],
        condition: [
          "verb-miner-function-default-ore-schemadotorg-product-json:itemCondition",
          "verb-miner-function-default-ore-schemadotorg-offer-json:itemCondition",
          "*itemprop='itemCondition'||||content",
          "*[name='product:condition']||||content",
          "*[property='product:condition']||||content",
          "*[itemprop='product:condition']||||content",
          "*[data-product-condition]||||data-product-condition",
          "*[data-condition]||||data-condition",
          ".product-condition",
          "#condition-status",
          "substring-after(*[contains(text(), 'Condition:')]/text(), 'Condition:')",
          "*[class*='condition-status']",
          "*[class*='condition-value']",
          "*[class*='item-condition']",
          "*[data-qa='condition']||||data-qa",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.itemCondition",
          "*[name='condition']||||content",
          "*[property='condition']||||content",
          "*[data-testid='condition']||||data-testid",
          "*[class*='badge'][class*='used']",
          "*[class*='badge'][class*='refurb']",
          "*[class*='badge'][class*='renewed']",
          "*[class*='tag'][class*='condition']",
          "verb-miner-function-default-ore-condition-fullpage-scan"
        ],
        cost: [
          "verb-miner-function-default-ore-schemadotorg-product-json:price",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.price",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.price",
          "verb-miner-function-default-ore-oembed-json:offers.0.price",
          "*[itemtype='http://schema.org/Offer'] *[itemprop='price']",
          "*[itemtype='http://schema.org/Product'] *[itemprop='price']",
          "*[itemtype='http://data-vocabulary.org/Product'] *[itemprop='price']",
          "*[itemprop='price']||||content",
          "*[itemprop='price']",
          "*[name='product:price:amount']||||content",
          "*[property='product:price:amount']||||content",
          "*[itemprop='product:price:amount']||||content",
          ".price-current",
          "*[name='wanelo:product:price']||||content",
          "*[property='wanelo:product:price']||||content",
          "*[itemprop='wanelo:product:price']||||content",
          "*[name='og:price:amount']||||content",
          "*[property='og:price:amount']||||content",
          "*[itemprop='og:price:amount']||||content",
          "*[name='product:price:amount']||||content",
          "*[property='product:price:amount']||||content",
          "*[itemprop='product:price:amount']||||content",
          "*[name='eb:price']||||content",
          "*[property='eb:price']||||content",
          "*[itemprop='eb:price']||||content",
          "*[data-product-price]||||data-product-price",
          "*[data-price]||||data-price",
          ".product-price",
          "#product-price",
          "*[class*='current-price']",
          "*[class*='sale-price']",
          "*[class*='regular-price']",
          "*[data-qa='price']||||data-qa",
          "*[data-testid='price']||||data-testid",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.salePrice",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.regularPrice",
          "*[name='price']||||content",
          "*[property='price']||||content",
          "*[data-automation='product-price']||||data-automation",
          "substring-after(*[contains(text(), 'Price:')]/text(), 'Price:')",
          "*[data-price-amount]||||data-price-amount",
          "*[data-final-price]||||data-final-price",
          "*[data-current-price]||||data-current-price",
          "*[data-price]||||data-price",
          "*[data-product-price]||||data-product-price",
          "*[itemprop='price']||||content",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.price",
          "*[data-shopify-price]||||data-shopify-price",
          ".woocommerce-Price-amount:not(.price-del)",
          "*[data-magento-final-price]||||data-magento-final-price",
          "*[data-bigcommerce-price]||||data-bigcommerce-price",
          ".a-price .a-offscreen",
          "*[data-automation='product-price']||||data-automation",
          "*[data-testid='product-price']||||data-testid",
          ".current-price:not(.old-price)",
          ".price-current",
          ".product-price:not(.was-price)",
          "#product-price-amount",
          ".price:not(.price--compare)",
          "*[property='product:price:amount']||||content",
          "*[name='product:price:amount']||||content",
          "*[property='og:price:amount']||||content",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.price",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.salePrice",
          "verb-miner-function-default-ore-schemadotorg-offer-json:price",
          "*[data-sale-price]||||data-sale-price",
          "*[data-special-price]||||data-special-price",
          ".your-price",
          ".price-sales",
          "substring-after(*[contains(text(), 'Price:')]/text(), 'Price:')",
          "substring-after(*[contains(text(), 'Your Price:')]/text(), 'Your Price:')"
        ],
        currency: [
          "verb-miner-function-default-ore-schemadotorg-product-json:priceCurrency",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.priceCurrency",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.priceCurrency",
          "verb-miner-function-default-ore-oembed-json:offers.0.currency_code",
          "*[name='priceCurrency']||||content",
          "*[property='priceCurrency']||||content",
          "*[itemprop='priceCurrency']||||content",
          "*[name='currency']||||content",
          "*[property='currency']||||content",
          "*[itemprop='currency']||||content",
          "*[name='product:price:currency']||||content",
          "*[property='product:price:currency']||||content",
          "*[itemprop='product:price:currency']||||content",
          "*[data-currency-code]||||data-currency-code",
          "*[data-price-currency]||||data-price-currency",
          ".currency-code",
          "#currency-code",
          "*[class*='currency-symbol']",
          "*[data-qa='currency']||||data-qa",
          "*[data-testid='currency']||||data-testid",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.0.currencyCode",
          "*[name='currencyCode']||||content",
          "*[property='currencyCode']||||content",
          "*[data-automation='currency-code']||||data-automation"
        ],
        images: [
          "verb-miner-function-default-ore-schemadotorg-product-json:image",
          "verb-miner-function-default-ore-oembed-json:thumbnail_url",
          "*[itemtype='http://schema.org/Product'] *[itemprop='image']",
          "*[itemtype='http://data-vocabulary.org/Product'] *[itemprop='image']",
          "*[itemprop='image']||||src",
          "*[itemprop='image']",
          "*[name='og:image:secure_url']||||content",
          "*[property='og:image:secure_url']||||content",
          "*[itemprop='og:image:secure_url']||||content",
          "*[name='og:image:url']||||content",
          "*[property='og:image:url']||||content",
          "*[itemprop='og:image:url']||||content",
          "*[name='og:image']||||content",
          "*[property='og:image']||||content",
          "*[itemprop='og:image']||||content",
          "*[name='twitter:image:src']||||content",
          "*[property='twitter:image:src']||||content",
          "*[itemprop='twitter:image:src']||||content",
          "*[name='twitter:image']||||content",
          "*[property='twitter:image']||||content",
          "*[itemprop='twitter:image']||||content",
          "*[name='image']||||content",
          "*[property='image']||||content",
          "*[itemprop='image']||||content",
          ".media-object.item_image||||src",
          ".product-carousel .slide img||||src",
          "foreignObject img||||src",
          ".product-image-details picture img||||src",
          "*[data-product-image]||||data-product-image",
          "*[data-main-image]||||data-main-image",
          ".product-main-image",
          "#main-product-image",
          "*[class*='primary-image']",
          "*[data-qa='product-image']||||data-qa",
          "*[data-testid='product-image']||||data-testid",
          "verb-miner-function-default-ore-schemadotorg-product-json:image.0.url",
          "verb-miner-function-default-ore-schemadotorg-product-json:images",
          "*[property='og:image:width']||||content",
          "*[property='og:image:height']||||content",
          "*[data-zoom-image]||||data-zoom-image",
          "*[data-high-res-image]||||data-high-res-image",
          "*[data-large-image]||||data-large-image",
          "*[data-original]||||data-original",
          ".gallery-image img||||src",
          "#product-gallery img||||src"
        ],
        model: [
          "verb-miner-function-default-ore-schemadotorg-product-json:model",
          "substring-after(*[contains(text(), 'Model:')]/text(), 'Model:')",
          "substring-after(*[contains(text(), 'model:')]/text(), 'model:')",
          "substring-after(*[contains(text(), 'Model #:')]/text(), 'Model #:')",
          "substring-after(*[contains(text(), 'Model Number:')]/text(), 'Model Number:')",
          "substring-after(*[contains(text(), 'model #:')]/text(), 'model #:')",
          "substring-after(*[contains(text(), 'model number:')]/text(), 'model number:')",
          "*[data-product-model]||||data-product-model",
          "*[data-model]||||data-model",
          ".model-number",
          "#model-number",
          "*[class*='model-id']",
          "*[data-qa='model']||||data-qa",
          "*[data-testid='model']||||data-testid",
          "verb-miner-function-default-ore-schemadotorg-product-json:modelNumber",
          "*[name='modelNumber']||||content",
          "*[property='modelNumber']||||content",
          "*[data-automation='model-number']||||data-automation",
          "substring-after(*[contains(text(), 'Item Model Number:')]/text(), 'Item Model Number:')"
        ],
        mpn: [
          "verb-miner-function-default-ore-schemadotorg-product-json:mpn",
          "*[itemprop='mpn']||||content",
          "*[itemprop='mpn']",
          "//*[@itemtype='http://schema.org/Product' or @itemtype = 'http://data-vocabulary.org/Product']//*[@itemprop='model' or @itemprop='mpn' or @itemprop='name']",
          "*[name='product:mfr_part_no']||||content",
          "*[property='product:mfr_part_no']||||content",
          "*[itemprop='product:mfr_part_no']||||content",
          "substring-after(*[contains(text(), 'MPN:')]/text(), 'MPN:')",
          "substring-after(*[contains(text(), 'mpn:')]/text(), 'mpn:')",
          "substring-after(*[contains(text(), 'Manufacturer Model #:')]/text(), 'Manufacturer Model #:')",
          "substring-after(*[contains(text(), 'Manufacturer Part #:')]/text(), 'Manufacturer Part #:')",
          "substring-after(*[contains(text(), 'Manufacturer Part #:')]/text(), 'Manufacturer Part #:')",
          "substring-after(*[contains(text(), 'Manufacturer Part:')]/text(), 'Manufacturer Part:')",
          "substring-after(*[contains(text(), 'Manufacturer Number:')]/text(), 'Manufacturer Number:')",
          "substring-after(*[contains(text(), 'Mfg Model #:')]/text(), 'Mfg Model #:')",
          "substring-after(*[contains(text(), 'Mfg Part #:')]/text(), 'Mfg Part #:')",
          "substring-after(*[contains(text(), 'Mfg Part #:')]/text(), 'Mfg Part #:')",
          "substring-after(*[contains(text(), 'Mfg Part:')]/text(), 'Mfg Part:')",
          "substring-after(*[contains(text(), 'Mfg Number:')]/text(), 'Mfg Number:')",
          "substring-after(*[contains(text(), 'manufacturer model #:')]/text(), 'manufacturer model #:')",
          "substring-after(*[contains(text(), 'manufacturer part #:')]/text(), 'manufacturer part #:')",
          "substring-after(*[contains(text(), 'manufacturer part #:')]/text(), 'manufacturer part #:')",
          "substring-after(*[contains(text(), 'manufacturer part:')]/text(), 'manufacturer part:')",
          "substring-after(*[contains(text(), 'manufacturer number:')]/text(), 'manufacturer number:')",
          "substring-after(*[contains(text(), 'mfg model #:')]/text(), 'mfg model #:')",
          "substring-after(*[contains(text(), 'mfg part #:')]/text(), 'mfg part #:')",
          "substring-after(*[contains(text(), 'mfg part #:')]/text(), 'mfg part #:')",
          "substring-after(*[contains(text(), 'mfg part:')]/text(), 'mfg part:')",
          "substring-after(*[contains(text(), 'mfg number:')]/text(), 'mfg number:')",
          "*[data-product-mpn]||||data-product-mpn",
          "*[data-mpn]||||data-mpn",
          ".manufacturer-part-number",
          "#mpn-number",
          "*[class*='mpn-id']",
          "*[data-qa='mpn']||||data-qa",
          "*[data-testid='mpn']||||data-testid",
          "*[name='mpn']||||content",
          "*[property='mpn']||||content",
          "*[data-automation='mpn']||||data-automation",
          "substring-after(*[contains(text(), 'Part Number:')]/text(), 'Part Number:')",
          "substring-after(*[contains(text(), 'Manufacturer Reference:')]/text(), 'Manufacturer Reference:')"
        ],
        retailer: [
          "*[name='og:site_name']||||content",
          "*[property='og:site_name']||||content",
          "*[itemprop='og:site_name']||||content",
          "verb-miner-function-default-ore-oembed-json:provider",
          "*[data-retailer]||||data-retailer",
          "*[data-store-name]||||data-store-name",
          ".store-name",
          "#retailer-name",
          "*[class*='merchant-name']",
          "*[data-qa='retailer']||||data-qa",
          "*[data-testid='retailer']||||data-testid",
          "verb-miner-function-default-ore-schemadotorg-organization-json:name",
          "*[name='retailer']||||content",
          "*[property='retailer']||||content",
          "*[data-automation='store-name']||||data-automation",
          "meta[name='application-name']||||content",
          "*[name='publisher']||||content",
          "*[property='publisher']||||content",
          "verb-miner-function-default-ore-retailer-use-hostname"
        ],
        sku: [
          "*[itemprop='sku']||||content",
          "*[itemprop='sku']",
          "verb-miner-function-default-ore-schemadotorg-product-json:sku",
          "//*[@itemtype='http://schema.org/Product' or @itemtype='http://schema.org/Offer' or @itemtype = 'http://data-vocabulary.org/Product']//*[@itemprop='sku']/@content|//*[@itemprop='sku']/text()",
          "substring-after(*[contains(text(), 'SKU:')]/text(), 'SKU:')",
          "substring-after(*[contains(text(), 'sku:')]/text(), 'sku:')",
          "*[data-product-sku]||||data-product-sku",
          "*[data-sku]||||data-sku",
          ".product-sku",
          "#product-sku",
          "*[class*='sku-id']",
          "*[data-qa='sku']||||data-qa",
          "*[data-testid='sku']||||data-testid",
          "*[name='sku']||||content",
          "*[property='sku']||||content",
          "*[data-automation='sku']||||data-automation",
          "substring-after(*[contains(text(), 'Item Number:')]/text(), 'Item Number:')",
          "substring-after(*[contains(text(), 'Article Number:')]/text(), 'Article Number:')",
          "*[data-product-id]||||data-product-id"
        ],
        title: [
          "verb-miner-function-default-ore-schemadotorg-product-json:name",
          "verb-miner-function-default-ore-oembed-json:title",
          ".details_item_name",
          "*[data-product-name]||||data-product-name",
          "*[itemtype='http://schema.org/Product'] *[itemprop='name']",
          "*[itemtype='http://data-vocabulary.org/Product'] *[itemprop='name']",
          "*[itemprop='name']",
          "*[name='wanelo:product:name']||||content",
          "*[property='wanelo:product:name']||||content",
          "*[itemprop='wanelo:product:name']||||content",
          "*[name='itemname']||||content",
          "*[property='itemname']||||content",
          "*[itemprop='itemname']||||content",
          "*[name='og:title']||||content",
          "*[property='og:title']||||content",
          "*[itemprop='og:title']||||content",
          "*[name='og:url']||||content",
          "*[property='og:url']||||content",
          "*[itemprop='og:url']||||content",
          "*[name='twitter:title']||||content",
          "*[property='twitter:title']||||content",
          "*[itemprop='twitter:title']||||content",
          "*[name='name']||||content",
          "*[property='name']||||content",
          "*[itemprop='name']||||content",
          "*[name='title']||||content",
          "*[property='title']||||content",
          "*[itemprop='title']||||content",
          "*[data-product-title]||||data-product-title",
          "*[data-title]||||data-title",
          ".product-title",
          "#product-title",
          "*[class*='product-name']",
          "*[data-qa='product-name']||||data-qa",
          "*[data-testid='product-title']||||data-testid",
          "h1.product-name",
          "h1.product-title",
          "*[data-automation='product-title']||||data-automation",
          "*[name='description']||||content",
          "*[property='description']||||content",
          "verb-miner-function-default-ore-schemadotorg-product-json:headline",
          "head > title",
          "title"
        ],
        url: [
          "verb-miner-function-default-ore-schemadotorg-product-json:url",
          "link[rel='canonical']||||href",
          "*[name='og:url']||||content",
          "*[property='og:url']||||content",
          "*[itemprop='og:url']||||content",
          "//*[@itemprop='url']/@content",
          "*[name='twitter:url']||||content",
          "*[property='twitter:url']||||content",
          "*[itemprop='twitter:url']||||content",
          "*[name='wanelo:product:url']||||content",
          "*[property='wanelo:product:url']||||content",
          "*[itemprop='wanelo:product:url']||||content",
          "link[rel='alternate'][hreflang='x-default']||||href",
          "verb-miner-function-default-ore-oembed-json:url",
          "*[data-product-url]||||data-product-url",
          "*[data-url]||||data-url",
          "link[rel='alternate'][type='text/html']||||href",
          "link[rel='shortlink']||||href",
          "*[data-qa='product-url']||||data-qa",
          "*[data-testid='product-url']||||data-testid",
          "*[name='url']||||content",
          "*[property='url']||||content",
          "*[data-automation='product-url']||||data-automation"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "dell",
      name: "Dell",
      category_tags: [
        "electronics"
      ],
      base: "dell.com",
      paths: [
        "/apd/(?<identifier>[\\w-]+)/"
      ],
      scout: null,
      ore: {
        cost: [
          "//div[@class='ps-dell-price ps-simplified']/text()",
          ".ps-dell-price > span:nth-of-type(2)",
          ".price"
        ],
        title: "//div[@class='pg-title']//span",
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin',
          "//meta[@name='CategoryId']/@content"
        ],
        model: [
          "//meta[@name='ProductId']/@content"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||mpn',
          "substring-before(substring-after(//div[contains(text(), 'Manufacturer part')]/text(), 'Manufacturer part '), ' |')"
        ],
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.availability',
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.availability',
          ".dds__badge__label",
          ".sticky__ps__limited__stock",
          ".sticky__ps__low__stock",
          ".sticky__ps__to__stock",
          ".sticky__ps__sold__stock",
          ".sticky_stock_status_sec",
          "//span[contains(@class, 'stock') or contains(@class, 'availability')]",
          "//div[contains(text(), 'Stock') or contains(text(), 'Available') or contains(text(), 'Sold Out')]"
        ],
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.priceCurrency',
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku'
      }
    },
    {
      id: "designerappliances",
      base: "designerappliances.com",
      name: "Designer Appliances",
      category_tags: [
        "appliances"
      ],
      paths: [],
      ore: {},
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "dickies",
      category_tags: [
        "clothing"
      ],
      base: "dickies.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[A-Z0-9]+)\\.html"
      ],
      ore: {
        availability: [
          "//link[@itemprop='availability']/@href",
          "//link [@itemprop='availability']/@href"
        ],
        brand: "//meta[@class='product-sales-price']//text()",
        cost: [
          "//div[@class='product-price product-pricing']//div[contains(@class, 'product-sales-price')]/text()",
          "//div[@class='product-sales-price']//text()"
        ],
        delivery: "//a[@id='fs-popup-trigger']//text()",
        title: "//h1[@class='product-name']//text()",
        sku: "//span[@itemprop='productID']/text()"
      },
      scout: {
        path: "/search?q={{query}}",
        items: "//ul[@id='search-result-items']/li",
        ore: {
          cost: './/div[@class="product-sales-price"]//text()',
          image: './/div[@class="product-image"]//img/@src',
          title: './/div[@class="product-name"]//text()',
          url: './/div[@class="product-name"]/a/@href'
        }
      }
    },
    {
      id: "dietechnik",
      name: "dietechnik",
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html$"
      ],
      base: "dietechnik.de",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.0.availability',
          "//span[contains(@class, 'product-item-subtitle')]/text()"
        ],
        cost: [
          "json||||script:nth-of-type(17)||||ecommerce.items.0.price"
        ],
        currency: [
          "json||||script:nth-of-type(17)||||ecommerce.currency",
          "//meta[@content='EUR']/@content"
        ]
      }
    },
    {
      id: "dimprice",
      name: "dimprice",
      paths: [],
      base: "www.dimprice.de",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//li[contains(@class, 'product-stock')]/span/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[@class='product-price-new']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
        ],
        model: [
          'json||||script[type="application/ld+json"]:nth-of-type(6)||||model'
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(6)||||mpn',
          "//li[@class='product-mpn']/span/text()"
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(6)||||sku'
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "dittrickswines",
      name: "dittrickswines",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "\\/(?<identifier>[a-f0-9]{24})\\?option-id="
      ],
      base: "dittrickswines.com",
      ore: {
        availability: [
          "json||||#product-metadata||||offers.availability",
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          "json||||#product-metadata||||offers.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#product-metadata||||offers.priceCurrency",
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          "json||||#product-metadata||||sku"
        ]
      }
    },
    {
      id: "dollarbargain",
      name: "dollarbargain",
      paths: [
        "/products/(?<identifier>[^/]+)"
      ],
      base: "www.dollarbargain.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.0.availability',
          "//div[contains(@class, 'product-form__info-item product-form__info-item--quantity')]//input[@name='quantity']/@value"
        ],
        cost: [
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(4)||||mpn',
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(15)||||sku',
          "//option[contains(@data-sku, '481358-20cmx20cmx2pcs')]/@data-sku"
        ]
      }
    },
    {
      id: "drizly",
      name: "drizly",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/wine/red-wine/pinot-noir/j-vineyards-pinot-noir-red-wine/(?<identifier>\\w+)"
      ],
      base: "drizly.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(11)||||offers.availability',
        cost: 'json||||script[type="application/json"]:nth-of-type(2)||||price_range',
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(11)||||priceCurrency',
        sku: 'json||||script[type="application/json"]:nth-of-type(2)||||catalogItemId'
      }
    },
    {
      id: "dshomeappliances",
      name: "dshomeappliances",
      category_tags: [
        "appliances"
      ],
      base: "dshomeappliances.com",
      paths: [
        "/products/(?<identifier>[\\w-]+)$"
      ],
      ore: {
        availability: "//div[contains(@class, 'stock-status')]/text()",
        sku: "//span[@class='product-meta__sku-number']/text()",
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.gtin14',
          "//tr[.//b[text()='UPC']]/td[not(b)]/text()"
        ],
        cost: [
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='product:price:currency']/@content"
        ]
      }
    },
    {
      id: "dunelm",
      name: "dunelm",
      category_tags: [
        "home-garden"
      ],
      paths: [],
      base: "dunelm.com",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "e2zstore",
      name: "e2zstore",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "e2zstore.com",
      ore: {
        availability: [
          "json||||.aioseo-schema||||@graph.3.offers.availability",
          "//p[contains(@class, 'stock')]/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.offers.0.priceSpecification.price'
        ],
        currency: [
          "json||||#guaven_woos-js-extra||||currency_symb",
          "//span[@class='woocommerce-Price-currencySymbol']/text()"
        ],
        model: "//div[contains(@class, 'product_meta')]/span[contains(@class, 'sku_wrapper')]/span[@class='sku']/text()",
        sku: [
          'json||||script[type="rocketlazyloadscript"]:nth-of-type(24)||||sku'
        ]
      }
    },
    {
      id: "ebay",
      name: "eBay",
      category_tags: [
        "sells-everything"
      ],
      base: {
        "de-at": "www.ebay.at",
        "de-ch": "www.ebay.ch",
        "de-de": "www.ebay.de",
        "en-au": "www.ebay.com.au",
        "en-ca": "www.ebay.ca",
        "en-gb": "www.ebay.co.uk",
        "en-ie": "www.ebay.ie",
        "en-il": "il.ebay.com",
        "en-in": "www.ebay.com",
        "en-jp": "www.ebay.com",
        "ja-jp": "www.ebay.com",
        "en-my": "www.ebay.com.my",
        "en-ph": "www.ebay.ph",
        "en-sg": "www.ebay.com.sg",
        "en-us": "www.ebay.com",
        "es-ar": "ar.ebay.com",
        "es-bo": "bo.ebay.com",
        "es-cl": "cl.ebay.com",
        "es-co": "co.ebay.com",
        "es-cr": "cr.ebay.com",
        "es-do": "do.ebay.com",
        "es-ec": "ec.ebay.com",
        "es-es": "www.ebay.es",
        "es-gt": "gt.ebay.com",
        "es-hn": "hn.ebay.com",
        "es-mx": "mx.ebay.com",
        "es-ni": "ni.ebay.com",
        "es-pa": "pa.ebay.com",
        "es-pe": "pe.ebay.com",
        "es-pr": "pr.ebay.com",
        "es-py": "py.ebay.com",
        "es-sv": "sv.ebay.com",
        "es-uy": "uy.ebay.com",
        "es-ve": "ve.ebay.com",
        "fr-be": "www.befr.ebay.be",
        "fr-ca": "www.cafr.ebay.ca",
        "fr-fr": "www.ebay.fr",
        "it-it": "www.ebay.it",
        "nl-be": "www.benl.ebay.be",
        "nl-nl": "www.ebay.nl",
        "pl-pl": "www.ebay.pl",
        "pt-br": "br.ebay.com",
        "ru-by": "by.ebay.com",
        "ru-kz": "kz.ebay.com",
        "ru-ru": "ru.ebay.com",
        "zh-hk": "www.ebay.com.hk",
        "*-de": "www.ebay.de"
      },
      paths: [
        "epid=(?<identifier>\\d+)",
        "\\/p\\/(?<identifier>\\d+)",
        "/itm/(?<identifier>\\d+)"
      ],
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin13',
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin8",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin12",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin13",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin14",
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin15",
          "//span[contains(., 'UPC')]/following::span[1]/text()",
          "concat(//div[contains(text(),'UPC')]/following-sibling::*,'_~_',(//*[@itemprop='gtin13'])[1],'_~_',//h3[contains(.,'Item specifics')]/following-sibling::table//td[contains(.,'UPC')]/following-sibling::td,'_~_',substring-after(//ul/li[contains(text(),'UPC:')],': '),'_~_',//td[./font[contains(text(),'UPC')]]/following-sibling::td,'_~_',//div[contains(text(),'UPC')]/following-sibling::*,'_~_',normalize-space(//div[@class='prodDetailSec']//td[text()='UPC']/following-sibling::*),'_~_',//div[contains(text(),'GTIN')]/following-sibling::*,'_~_',//div[@class='app-itemspecifics-mobile-wrapper']//span[contains(text(),'UPC')]//parent::*//parent::*/following-sibling::*)",
          "substring-before(concat(//*[contains(.,'ISBN-13')]/following-sibling::div,','),',')"
        ],
        brand: [
          "verb-miner-function-default-ore-schemadotorg-product-json:brand",
          "concat(//h2[@itemprop='brand'],'_~_',//h2[contains(text(),'Product Identifiers')]/following-sibling::*//div[contains(text(),'BRAND')]/following-sibling::*,'_~_',//div[@class='app-itemspecifics-mobile-wrapper']//span[contains(text(),'Brand')]//parent::*//parent::*/following-sibling::*)"
        ],
        condition: [
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.itemCondition",
          ".x-item-condition-value span.clipped"
        ],
        details: [
          ".x-item-condition-value span.ux-textspans:nth-child(2)"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[@class='vim x-buybox']//span[contains(@class, 'ux-textspans') and contains(., 'EUR')]/text()",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.price",
          "//div[contains(@class, 'x-price-primary')]/span[@class='ux-textspans']/text()",
          "concat(substring-after(normalize-space(//span[@id='prcIsum']),'US $'),'_~_',//h2[contains(text(),'Brand new: lowest price')]/following-sibling::*//h2[@class='display-price'],'_~_',//span[@class='vi-bin-primary-price__main-price'])"
        ],
        costShipping: [
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.shippingDetails.shippingRate.value"
        ],
        currency: [
          "json||||script:nth-of-type(68)||||o.w.0.2.options.global.req.ebay.i18n.lookupContext.locality.siteDefaultIsoCurrencyCode",
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.priceCurrency"
        ],
        image: [
          "verb-miner-function-default-ore-schemadotorg-product-json:image",
          "#icImg||||src"
        ],
        sku: "concat(//div[contains(text(),'eBay Product ID (ePID)')]/following-sibling::*,'_~_',normalize-space(//div[@class='prodDetailSec']//td[contains(text(),'eBay Product ID (ePID)')]//following-sibling::*),'_~_',substring-before(substring-after(//div[@class='rvws_container c-std']//a[@class='btn btn-ter right']/@href,'write-review/'),'?'),'_~_',//div[@id='descItemNumber'],'_~_',substring-before(substring-after(//a[contains(text(),'Read full description')]/@href,'&item='),'&'),'_~_',substring-before(substring-after(//script[contains(text(),'_productid')],'_productid='),'&'),'_~_',//input[@id='appbnr_itm_id']/@value)",
        title: [
          "verb-miner-function-default-ore-schemadotorg-product-json:name",
          "concat(normalize-space(substring-after(id('itemTitle'),'Details about ')),//h1[@class='product-title'],//h1[@class='item-title'],//h1[@class='vi-title__main'])",
          ".it-ttl"
        ],
        availability: [
          ".x-quantity__availability .ux-textspans--BOLD",
          "//div[@class='x-quantity__availability']//span[contains(@class, 'ux-textspans--BOLD')]/text()",
          "#qtyAvailability .ux-textspans"
        ],
        model: [
          "verb-miner-function-default-ore-schemadotorg-product-json:model"
        ],
        mpn: [
          "verb-miner-function-default-ore-schemadotorg-product-json:mpn"
        ]
      },
      scout: {
        path: "/sch/i.html?_nkw={{query}}&_sacat=0&_sop=15",
        items: ".srp-results .s-item__wrapper",
        limit: 10,
        ore: {
          condition: ".SECONDARY_INFO",
          cost: ".s-item__price",
          delivery: ".s-item__shipping",
          image: ".s-item__image img||||src",
          marketplaceSellerName: ".s-seller-feedback",
          title: ".s-item__title span",
          url: "verb-miner-function-ebay-scout-ore-url"
        }
      }
    },
    {
      id: "ebgames",
      name: "ebgames",
      category_tags: [
        "toys-games"
      ],
      paths: [
        "/product/[^/]+/(?<identifier>\\d+)"
      ],
      base: "www.ebgames.com.au",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        currency: "//meta[@property='product:price:currency']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      }
    },
    {
      id: "ebooks",
      name: "eBooks.com",
      category_tags: [
        "books"
      ],
      base: "ebooks.com",
      paths: [
        "(.+)\\/(.+)\\/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: "substring-after(//div[@class='publish']/text()[contains(., 'ISBN')], 'ISBN ')",
        cost: "//div[@class='price placeholder placeholder-hidden']",
        title: "//div[@class='book-info-head']//h1"
      }
    },
    {
      id: "ebuyer",
      name: "ebuyer",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>\\d+)-[^\\/]+\\?"
      ],
      base: "ebuyer.com",
      ore: {
        availability: "//h4[contains(text(), 'Sorry, this product is currently out of stock.')]",
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(2)||||priceIncVat'
        ],
        currency: "//span[@class='smaller currency-symbol']/text()",
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||mpn'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku'
        ]
      }
    },
    {
      id: "ecampus",
      name: "eCampus",
      category_tags: [
        "books"
      ],
      base: "ecampus.com",
      paths: [
        "(.+)\\/(.+)\\/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        availability: ".availability",
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||isbn',
          "//div[@itemprop='isbn']//h3"
        ],
        cost: ".collapsed-item-price",
        title: "//div[@class='details']//h1"
      }
    },
    {
      id: "elcytec",
      name: "elcytec",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "elcytec.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.lowPrice'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.priceCurrency'
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
      }
    },
    {
      id: "electronicexpress",
      name: "electronicexpress",
      category_tags: [
        "electronics",
        "appliances"
      ],
      base: "electronicexpress.com",
      paths: [
        "/catalog/(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability'
        ],
        barcode: [
          "substring-after(//div[contains(text(), 'UPC/EAN:')], 'UPC/EAN:')",
          "substring-after(//div[contains(text(), 'ISBN:')], 'ISBN:')",
          "substring-after(//div[contains(text(), 'GTIN:')], 'GTIN:')"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price'
        ],
        currency: 'json||||script[type="application/ld+json"]||||offers.priceCurrency',
        sku: [
          "//a[@class='btn-add-to-cart btn-add-to-cart-209171 btn-add-rec btn-add-to-cart-carousel btn btn-secondary btn-block']/@data-prod-sku"
        ]
      }
    },
    {
      id: "emiraroad",
      name: "emiraroad",
      paths: [
        "variant=(?<identifier>\\d+)"
      ],
      base: "emiraroad.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.availability',
          "//p[@class='product-inventory']/span/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||sku',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.price',
          "//div[@class='h2 product-single__price']/div/div/span[contains(@class, 'product-price__sale')]/text()"
        ],
        currency: [
          "json||||script:nth-of-type(11)||||currency"
        ],
        model: "//span[contains(text(), 'Item model number:')]/following-sibling::span/text()",
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||sku'
      }
    },
    {
      id: "endclothing",
      name: "endclothing",
      category_tags: [
        "clothing"
      ],
      base: "www.endclothing.com",
      paths: [],
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.availability',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "//meta[@property='product:price:currency']/@content"
        ],
        model: [
          "substring-after(li[contains(., 'Model:')][not(starts-with(normalize-space(.), ':' ))]//text(), 'Model:')"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||sku',
          "json||||#__NEXT_DATA__||||props.initialProps.pageProps.product.sku",
          "substring-after(li[contains(., 'Style Code:') or contains(.,'Style Code:')][not(starts-with(normalize-space(.), ':' ))]//text(), 'Style Code:')"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "everymarket",
      name: "everymarket",
      category_tags: [
        "sells-everything"
      ],
      base: "everymarket.com",
      paths: [
        "/products/(?<identifier>[^/]+)$"
      ],
      ore: {
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//div[@id='product-price']//span[contains(@class, 'price-item--sale')]/text()"
        ],
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//span[contains(@class, 'product-in-stock')]/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ]
      }
    },
    {
      id: "evitamins",
      name: "eVitamins",
      category_tags: [
        "health-pharmacy"
      ],
      base: "evitamins.com",
      paths: [
        "(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//meta[@property='og:upc']/@content",
          "substring-after(//span[@class='size14'],':')"
        ],
        cost: [
          'json||||script[type="text/plain"]:nth-of-type(8)||||Price',
          "//meta[@itemprop='price']/@content",
          "normalize-space(//td[contains(text(),'Our Price')]/following-sibling::*)"
        ],
        sku: [
          'json||||script[type="text/plain"]:nth-of-type(8)||||SKU',
          "//meta[@itemprop='sku']/@content",
          "//input[@name='pid']/@value"
        ],
        title: "//h1",
        availability: "//meta[@itemprop='availability']/@content",
        currency: 'json||||script[type="text/plain"]:nth-of-type(8)||||CurrencyCode'
      }
    },
    {
      id: "expert-technomarkt",
      name: "expert-technomarkt",
      category_tags: [
        "electronics"
      ],
      paths: [],
      base: "www.expert-technomarkt.de",
      ore: {
        barcode: "//meta[@itemprop='gtin13']/@content",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "expert",
      name: "expert",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>\\d+)-[^\\/]+\\.html"
      ],
      base: "www.expert.de",
      ore: {
        availability: [
          "json||||#schema-org-graph||||@graph.2.offers.availability",
          "//div[contains(@class, 'pb-1')]/span[@class='pointText']"
        ],
        cost: [
          "json||||#schema-org-graph||||@graph.2.offers.price"
        ],
        currency: "json||||#schema-org-graph||||@graph.2.offers.priceCurrency",
        sku: "json||||#schema-org-graph||||@graph.2.sku"
      }
    },
    {
      id: "eyebuydirect",
      category_tags: [
        "clothing"
      ],
      base: "eyebuydirect.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[w+]+)\\"
      ],
      ore: {
        availability: "//meta[@itemprop='og:availability']/@content",
        brand: "//h1[@class='product-name']/text()",
        cost: "//span[@class='normal-price price-symbol']/text()",
        mpn: [
          "//meta[@itemprop='mpn']//text()"
        ],
        title: "//h2[@class='product-sub-name']//text()"
      },
      scout: {
        path: "/search?q={{query}}",
        items: './/ol[@class="ais-Hits-list"]/li',
        ore: {
          cost: './/span[@class="item-price normal-price price-symbol"]/text()',
          image: './/div[@class="item-image"]//img/@src',
          url: './/div[@class="item-image"]/a/@href'
        }
      }
    },
    {
      id: "farfetch",
      name: "farfetch",
      category_tags: [
        "clothing"
      ],
      base: "farfetch.com",
      paths: [
        "\\/shopping\\/women\\/.+?-item-(?<identifier>\\d+)\\.aspx"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//meta[@property='og:availability']/@content"
        ],
        cost: [
          "//meta[@property='og:price:amount']/@content",
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//meta[@property='product:custom_label_4']/@content"
        ],
        currency: [
          "json||||#script_pageSettings||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||productID'
        ],
        model: "//p[contains(text(), 'Brand style ID:')]/span/text()"
      }
    },
    {
      id: "farmandfleet",
      name: "Blain's Farm and Fleet",
      category_tags: [
        "home-garden"
      ],
      base: "farmandfleet.com",
      paths: [
        "\\/products\\/(?<identifier>.+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          "json||||#bffschema||||gtin13",
          "//meta[@property='product:upc']/@content"
        ],
        brand: "//meta[@property='product:brand']/@content",
        cost: "//meta[@property='product:price:amount']/@content",
        mpn: "//meta[@property='product:mfr_part_no']/@content",
        sku: [
          "//meta[@property='product:retailer']/@content",
          "//meta[@property='product:retailer_part_no']/@content"
        ],
        title: "//meta[@property='og:title']/@content",
        availability: "//meta[@property='product:availability']/@content"
      }
    },
    {
      id: "fatbraintoys",
      name: "Fat Brain Toys",
      category_tags: [
        "toys-games"
      ],
      base: "fatbraintoys.com",
      paths: [
        "(?<identifier>.+)\\.cfm"
      ],
      scout: null,
      ore: {
        barcode: "//meta[@property='og:upc']/@content",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          "//div[@class='product-price']/span[@class='product-price pull-right']/text()",
          "//span[@itemprop='price']"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.sku',
          "//span[contains(@class, 'sku-number')]/text()",
          "normalize-space(substring-after(//span[@class='sku-number'],':'))"
        ],
        title: "(//h1[@itemprop='name'])[1]",
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//span[contains(@class, 'in-stock')]/b/text()"
        ],
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.priceCurrency',
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
      }
    },
    {
      id: "fishpond",
      name: "Fishpond",
      category_tags: [
        "electronics"
      ],
      base: "fishpond.com",
      paths: [
        "(.+)\\/(.+)\\/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]||||mainItemBarcode',
          "//input[@name='barcode']/@value",
          "//div[contains(text(),'EAN')]/following-sibling::*"
        ],
        brand: "//div[contains(text(),'Brand')]/following-sibling::*",
        cost: "substring-before(substring-after(substring-after(//script[contains(text(),'currency')],'value'),':'),',')",
        title: "//div[@class='b-product-info__title']"
      }
    },
    {
      id: "flipafone",
      name: "flipafone",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "flipafone.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability'
        ],
        cost: [
          "//span[@class='visually-hidden visually-hidden--inline']/following-sibling::span/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(21)||||sku',
          "//div[contains(@class, 'sku')]/span[@data-sku='']/text()"
        ]
      }
    },
    {
      id: "foodlion",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "foodlion.com"
      ],
      mine: "verb-miner-function-foodlion-mine",
      scout: "verb-miner-function-foodlion-scout"
    },
    {
      id: "frankbody",
      name: "frankbody",
      category_tags: [
        "beauty"
      ],
      paths: [
        "/products/(?<identifier>[^/?]+)"
      ],
      base: "frankbody.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin8'
        ],
        cost: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ]
      }
    },
    {
      id: "freemans",
      name: "freemans",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\/products\\/[^\\/]+\\/_\\/(?<identifier>[A-Za-z0-9_]+)"
      ],
      base: "freemans.com",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        barcode: "//meta[@itemprop='gtin13']/@content",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      }
    },
    {
      id: "freshdirect",
      name: "Fresh Direct",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "freshdirect.com"
      },
      paths: [
        "\\/product\\.jsp\\?productId=(?<identifier>[^&]+)",
        "\\/srch\\.jsp\\?pageType=product&productId=(?<identifier>[^&]+)",
        "\\/products\\/(?<identifier>[^?]+)"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: ".product-price",
              at: "afterend"
            },
            {
              selector: ".product-details",
              at: "afterend"
            }
          ]
        }
      ],
      "skip-normal-mining": true,
      mine: "verb-miner-function-freshdirect-mine",
      "brick-and-mortar": "verb-miner-function-freshdirect-mine",
      scout: {
        path: "https://www.freshdirect.com/srch.jsp?searchParam={{query}}",
        items: ".product-item",
        ore: {
          title: ".product-name",
          cost: ".product-price",
          url: ".product-link||||href",
          imageUrl: ".product-image img||||src",
          availability: ".stock-status"
        }
      },
      serviceArea: {
        type: "zone-based-delivery",
        coverage: [
          "NYC",
          "Brooklyn",
          "Queens",
          "Bronx",
          "Manhattan",
          "Westchester",
          "Nassau",
          "Suffolk"
        ],
        headquarters: "Long Island City, NY",
        founded: 1999,
        deliveryModel: "Fresh Direct Zones"
      },
      loyaltyPrograms: {
        deliveryPass: {
          name: "DeliveryPass",
          benefits: [
            "Free delivery",
            "Priority scheduling",
            "Exclusive offers"
          ],
          monthly: true
        }
      },
      services: {
        delivery: "Zone-based fresh food delivery",
        pickupLocations: "Limited pickup locations in NYC",
        mealKits: "Chef-prepared meal solutions",
        wine: "Wine and spirits delivery",
        gourmet: "Artisanal and gourmet foods"
      },
      apiInformation: {
        baseUrl: "https://api.freshdirect.com/",
        authentication: "JWT tokens",
        framework: "Custom e-commerce platform",
        tier: "Tier 3 - Complete custom mining required"
      }
    },
    {
      id: "fril",
      name: "fril",
      paths: [
        "/([^/]+?)/(?<identifier>[\\w+]+)$"
      ],
      base: "item.fril.jp",
      ore: {
        availability: "//meta[@property='product:availability']/@content",
        cost: "//meta[@property='product:price:amount']/@content",
        currency: "//meta[@property='product:price:currency']/@content",
        sku: "//meta[@property='product:retailer_item_id']/@content"
      }
    },
    {
      id: "fritzysrollerskateshop",
      name: "fritzysrollerskateshop",
      category_tags: [
        "clothing"
      ],
      base: "fritzysrollerskateshop.com",
      paths: [],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability'
        ],
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(6)||||barcode',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//span[@id='ProductPrice-4528106897452']/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "fruugo",
      name: "fruugo",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/p-(?<identifier>\\d+-\\d+)"
      ],
      base: "fruugo.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.availability',
          "//meta[@property='og:availability']/@content"
        ],
        barcode: [
          'json||||script[type="application/ld+json"]||||@graph.1.gtin',
          "//meta[@property='og:upc']/@content"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ],
        model: "//meta[contains(@property, 'product:item_group_id')]/@content",
        sku: [
          'json||||script[type="application/ld+json"]||||@graph.1.sku',
          "//meta[@property='product:retailer_item_id']/@content"
        ]
      }
    },
    {
      id: "frys",
      name: "Fry's Electronics",
      category_tags: [
        "electronics"
      ],
      base: "frys.com",
      paths: [
        "product\\/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: "substring(substring-after(//li[contains(text(),'UPC')],' '),2)",
        brand: "substring-after(//title[contains(text(),'FRYS.com')],'|')",
        cost: "normalize-space(//span[@id='did_price1valuediv'])",
        mpn: "//span[contains(text(),'Model')]/following-sibling::*",
        sku: "substring-after(//meta[@property='og:url']/@content,'product/')",
        title: "normalize-space(//h3[@class='product-title'])"
      }
    },
    {
      id: "funko",
      name: "Funko",
      category_tags: [
        "toys-games"
      ],
      base: "funko.com",
      paths: [
        ".*\\/([^\\/]+)\\/(?<identifier>[0-9]+)\\.html$",
        ".*\\/(?<identifier>[0-9]+)\\.html$"
      ],
      ore: {
        cost: [
          ".sales .value",
          ".price .value:not(.del .value)",
          ".price .value"
        ],
        availability: [
          ".add-to-cart",
          "if(//button[contains(@class, 'add-to-cart')], 'in stock', 'unknown')"
        ],
        title: [
          "h1",
          ".product-name"
        ],
        brand: "Funko",
        currency: "USD",
        model: [
          "[data-pid]||||data-pid"
        ],
        image: [
          '[class*="image"] img:not([src*="svg"])',
          ".product-image img",
          ".main-image"
        ],
        description: [
          '[class*="description"]:not(.sr-only)'
        ],
        sku: [
          "[data-pid]||||data-pid"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-tile-col[data-pid]",
        ore: {
          cost: ".price .value",
          title: "h1, h2, h3, h4",
          url: "a||||href",
          image: 'img:not([src*="svg"])||||src'
        }
      }
    },
    {
      id: "furu1",
      name: "furu1",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/product/detail/(?<identifier>\\d+)"
      ],
      base: "www.furu1.online",
      ore: {
        barcode: "//p[contains(@class, 'p-item_01_txt')][preceding-sibling::h3[text()='商品ID']]/text()",
        cost: "//span[@class='p-item_rank_price_yen']/text()",
        model: "//h3[contains(text(), '型番')]/following-sibling::p[1]/text()",
        sku: "//p[contains(@class, 'p-item_01_txt')][preceding-sibling::h3[text()='商品ID']]/text()"
      }
    },
    {
      id: "fye",
      name: "fye",
      category_tags: [
        "toys-games"
      ],
      base: "fye.com",
      paths: [
        "(?<identifier>[a-z0-9\\.]+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: "//li[contains(text(),'UPC')]/span",
        cost: "substring-after(normalize-space(//div[@class='sale-price']),':')",
        title: "(//h3)[1]"
      }
    },
    {
      id: "gadgetsonline",
      name: "gadgetsonline",
      paths: [
        "\\?currency=AUD&variant=(?<identifier>\\d+)"
      ],
      base: "www.gadgetsonline.co.nz",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
        barcode: 'json||||script[type="application/json"]:nth-of-type(5)||||product.variants.0.barcode',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//span[@class='money']/text()"
        ],
        currency: [
          'json||||script[type="application/json"]:nth-of-type(7)||||currency',
          "//a[contains(@class, 'disclosure-list__item--current')]/span[@class='disclosure-list__option-code']/text()"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: "json||||script:nth-of-type(44)||||product.variants.0.sku"
      }
    },
    {
      id: "galaxus",
      name: "galaxus",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/product/(?<identifier>\\w+)-"
      ],
      base: "www.galaxus.de",
      ore: {
        availability: [
          "//meta[@property='og:availability']/@content"
        ],
        barcode: [
          "//meta[@property='gtin']/@content"
        ],
        cost: [
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "//meta[@property='product:price:currency']/@content"
        ],
        model: "//td[contains(text(), 'Artikelnummer')]/following-sibling::td/div/span[1]/text()",
        sku: [
          "//span[contains(@class, 'sc-1omuje8')]/text()"
        ]
      }
    },
    {
      id: "gameloot",
      name: "gameloot",
      category_tags: [
        "toys-games"
      ],
      paths: [
        "/shop/(?<identifier>[^/]+)/"
      ],
      base: "gameloot.in",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.0.offers.0.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.0.offers.0.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.0.offers.0.priceCurrency',
          "//span[@class='woocommerce-Price-currencySymbol']/text()"
        ],
        sku: "//span[@class='sku']"
      }
    },
    {
      id: "gamestop",
      name: "GameStop",
      category_tags: [
        "toys-games"
      ],
      base: {
        "*-us": "gamestop.com",
        "*-ca": "www.gamestop.ca"
      },
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)\\.html",
        "\\/([\\w\\/-]+)\\/(?<identifier>[0-9]+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers[0].availability',
          "verb-miner-function-default-ore-schemadotorg-offer-json:availability",
          ".availability-status, .stock-status, [data-testid*='stock']",
          "//span[contains(@class, 'availability') or contains(text(), 'stock') or contains(@class, 'inStock')]//text()"
        ],
        barcode: [
          "//table[contains(@class, 'product-attribute-table-redesign')]//th[text()='UPC']/following-sibling::td/text()",
          'json||||script[type="application/ld+json"]||||gtin13'
        ],
        brand: [
          "//span[@class='font-body tracking-n3 text-sm underline']/a//text()",
          "normalize-space(//div[@class='product-publisher']/span)"
        ],
        condition: "verb-miner-function-default-ore-schemadotorg-offer-json:itemCondition",
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(4)||||price',
          "//span[@class='prodPriceCont valuteCont pricetext']/text()",
          "//span[@class='pro-day-pricing-2022 pricing show ']/text()",
          "//span[@data-testid='price-default']//text()",
          "#primary-details .selling-price-redesign .actual-price"
        ],
        currency: 'json||||script[type="application/ld+json"]||||offers[0].priceCurrency',
        delivery: "//div[@class='flex flex-col items-baseline']//text()",
        rating: "//span[@itemprop='ratingValue']",
        ratings: "translate((//span[@class='BVRRCount BVRRNonZeroCount']/span)[1],',','')",
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//input[@id='sku-id']/@value",
          "substring(substring-after(//script[@type='application/ld+json'],'sku'),4,6)"
        ],
        title: [
          "//div[@class='flex flex-col-reverse']/h2/text()",
          "normalize-space(//h1[@class='product-name h2']/text())"
        ],
        mpn: "//tr[th[contains(text(), 'Vendor Part Number')]]/td/text()"
      },
      scout: {
        path: "/search/?q={{query}}&lang=default",
        items: [
          ".table .table-cell",
          ".product-tile",
          './/div[@data-list-item-type="Search list"]'
        ],
        ore: {
          cost: [
            "*[data-testid='price-small']",
            "verb-miner-function-gamestop-scout-ore-json:price?.sellingPrice",
            './/span[contains(@class,"has-pro-pricing")]//text()'
          ],
          currency: "verb-miner-function-gamestop-scout-ore-json:price?.currency",
          image: [
            ".tile-image||||src",
            './/div[@class="image-container"]//img/@src'
          ],
          title: [
            "verb-miner-function-gamestop-scout-ore-json:productInfo.name",
            './/div[@class="pdp-link"]//p/text()'
          ],
          url: [
            "*[data-testid='product-card-link']||||href",
            './/a[@class="link-name"]/@href'
          ]
        }
      }
    },
    {
      id: "generalmills",
      name: "General Mills",
      category_tags: [
        "grocery-food"
      ],
      base: "smartlabel.generalmills.com",
      paths: [
        "\\/(?<identifier>\\d+)"
      ],
      identification: true,
      scout: {
        path: "/{{query}}",
        items: "body",
        redirectsSometimes: true
      },
      ore: {
        barcode: "#hdnGTINId||||value",
        brand: ".product-subheader.sub-header",
        image: ".bannerImagePath||||src",
        title: ".product-header-name.header1"
      }
    },
    {
      id: "geo-online",
      name: "geo-online",
      paths: [
        "\\/g\\/(?<identifier>\\w+)/"
      ],
      base: "ec.geo-online.co.jp",
      ore: {
        availability: [
          "json||||script:nth-of-type(33)||||quantity",
          "//tr[th[contains(text(), '在庫')]]/td/text()"
        ],
        barcode: [
          "//td[@id='spec_goods' and preceding-sibling::th[contains(text(), 'JAN')]]/text()"
        ],
        cost: 'json||||script[type="application/ld+json"]||||offers.price',
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ],
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn'
        ],
        sku: [
          "json||||script:nth-of-type(33)||||sku"
        ]
      }
    },
    {
      id: "giant-eagle",
      name: "Giant Eagle",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "gianteagle.com"
      },
      paths: [
        "\\/grocery\\/search\\/product\\/(?<identifier>[^/]+)",
        "\\/product\\/(?<identifier>[^/]+)",
        "\\/p\\/(?<identifier>[^/]+)",
        "\\/groceries\\/(?<identifier>[^/]+)"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: ".product-price, .price-container",
              at: "afterend"
            },
            {
              selector: ".product-details, .product-info",
              at: "afterend"
            }
          ]
        }
      ],
      "skip-normal-mining": true,
      mine: "verb-miner-function-giant-eagle-mine",
      "brick-and-mortar": "verb-miner-function-giant-eagle-brick-and-mortar",
      scout: {
        path: "https://www.gianteagle.com/search?q={{query}}",
        items: ".product-tile, .product-card, .product-item",
        ore: {
          title: ".product-name, .product-title, h3",
          cost: ".product-price, .price-current, .price",
          url: "a||||href",
          imageUrl: "img||||src",
          availability: ".availability, .stock-status, .in-stock"
        }
      },
      serviceArea: {
        type: "regional-pennsylvania-ohio",
        coverage: [
          "PA",
          "OH",
          "WV",
          "IN",
          "MD"
        ],
        headquarters: "Pittsburgh, PA",
        founded: 1931,
        storeCount: "470+"
      },
      loyaltyPrograms: {
        myPerks: {
          name: "myPerks Rewards",
          benefits: [
            "Fuel perks",
            "Personalized coupons",
            "Digital receipts"
          ],
          free: true
        }
      },
      services: {
        pharmacy: "Full-service pharmacy with prescription refills and immunizations",
        groceryPickup: "Curbside pickup available",
        groceryDelivery: "Instacart delivery partnership",
        getgo: "GetGo convenience stores with fuel and food service",
        diversity: "Community-focused with local sourcing initiatives"
      },
      apiInformation: {
        baseUrl: "https://core.shop.gianteagle.com/api/v2/",
        authentication: "Session-based with store selection required",
        framework: "Custom React-based platform",
        tier: "Tier 3 - Complete custom mining required"
      }
    },
    {
      id: "giant-food",
      name: "Giant Food",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "giantfood.com"
      },
      paths: [
        "\\/product\\/(?<identifier>[^/]+)",
        "\\/p\\/(?<identifier>[^/]+)",
        "\\/item\\/(?<identifier>[^/]+)",
        "\\/groceries\\/(?<identifier>[^/]+)"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: ".product-price",
              at: "afterend"
            },
            {
              selector: ".product-details",
              at: "afterend"
            }
          ]
        }
      ],
      "skip-normal-mining": true,
      mine: "verb-miner-function-giant-food-mine",
      "brick-and-mortar": "verb-miner-function-giant-food-mine",
      scout: {
        path: "https://giantfood.com/search?q={{query}}",
        items: ".product-item",
        ore: {
          title: ".product-name",
          cost: ".product-price",
          url: ".product-link||||href",
          imageUrl: ".product-image img||||src",
          availability: ".stock-status"
        }
      },
      serviceArea: {
        type: "regional-mid-atlantic",
        coverage: [
          "MD",
          "DC",
          "VA",
          "DE"
        ],
        headquarters: "Landover, MD",
        founded: 1936,
        storeCount: "165+"
      },
      loyaltyPrograms: {
        rewards: {
          name: "Giant Flexible Rewards",
          benefits: [
            "Flexible points system",
            "Gas rewards",
            "Digital coupons"
          ],
          free: true
        }
      },
      services: {
        pharmacy: "Full-service pharmacy with prescription refills",
        groceryPickup: "Giant Pickup service",
        groceryDelivery: "Giant Delivers and third-party delivery",
        diversity: "Strong focus on diverse community service"
      },
      apiInformation: {
        baseUrl: "https://giantfood.com/api/",
        authentication: "Session-based with Ahold Delhaize shared infrastructure",
        framework: "Peapod Digital Labs platform",
        tier: "Tier 3 - Complete custom mining required"
      }
    },
    {
      id: "giantfoodstores",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "giantfoodstores.com"
      ],
      mine: "verb-miner-function-giantfoodstores-mine"
    },
    {
      id: "gimmenow",
      name: "gimmenow",
      paths: [
        "\\/(?<identifier>[\\w-]+)$"
      ],
      base: "shop.gimmenow.com",
      ore: {
        availability: [
          "//div[contains(@class, 'stock')]/span/text()"
        ],
        cost: [
          "//span[@class='price-wrapper ']/span[@class='price']/text()"
        ],
        currency: [
          'json||||script[type="text/x-magento-init"]:nth-of-type(31)||||*.Magento_Catalog/js/product/view/provider.data.currency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        sku: "//div[@class='product-add-form']//@data-product-sku"
      }
    },
    {
      id: "gizerler",
      name: "gizerler",
      paths: [
        "/urun/(?<identifier>[^/]+)"
      ],
      base: "www.gizerler.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//div[contains(@class, 'product-info-stock')]/div/span[@class='limited_stock']/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku',
          "//a[@id='product_id']/text()"
        ]
      }
    },
    {
      id: "glow",
      name: "glow",
      category_tags: [
        "beauty"
      ],
      paths: [
        "/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "glow.co.uk",
      ore: {
        availability: "//strong[contains(text(), 'In stock')]/text()",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//span[contains(@class, 'sku')]/strong/text()"
      }
    },
    {
      id: "gnc",
      name: "GNC",
      category_tags: [
        "health-pharmacy"
      ],
      base: "www.gnc.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9A-Z]+).html",
        ".*\\/(?<identifier>.+)\\.html",
        "\\/(?<identifier>\\d+)\\.html$",
        "\\/(?<identifier>\\d+)\\.html$"
      ],
      ore: {
        cost: "//span[@itemprop='price']//text()",
        delivery: "//div[@class='fieldset-content']//text()",
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||mpn',
          "//span[@itemprop='productID']//text()"
        ],
        rating: "(//span[@class='pr-snippet-rating-decimal pr-rounded'])[1]/text()",
        ratings: "//p[@class='pr-snapshot-average-based-on-text']/span",
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(9)||||id',
          "//span[@itemprop='productID']"
        ],
        title: [
          "//h1[@class='pdp__product-details__product-title__heading']/text()",
          "//h1[@itemprop='name']"
        ]
      },
      scout: {
        path: "/department/?q={{query}}&lang=default",
        items: [
          './/div[@class="search-result-items-container container-fluid"]/div/li',
          "li.grid-tile"
        ],
        ore: {
          cost: './/span[@class="product-standard-price"]//text()',
          image: [
            './/div[@class="product-name"]//a/img/@src',
            ".thumb-link img||||src"
          ],
          title: [
            './/div[@class="brand-product-name"]//text()',
            ".name-link"
          ],
          url: [
            './/div[@class="product-name"]//a/@href',
            ".name-link||||href"
          ]
        }
      }
    },
    {
      id: "goldfieldsgames",
      name: "goldfieldsgames",
      category_tags: [
        "toys-games"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "goldfieldsgames.com.au",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(7)||||barcode',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//span[@class='price ']/span[@class='money']/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        model: "json||||script:nth-of-type(48)||||product.variants.0.sku",
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: 'json||||script[type="text/javascript"]:nth-of-type(7)||||sku'
      }
    },
    {
      id: "goodsdream",
      name: "goodsdream",
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "goodsdream.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//div[contains(@class, 'wcfm_clearfix')]/following-sibling::div[contains(@class, 'wcfmmp_shipment_processing_display')]/text()"
        ],
        cost: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
        currency: "//span[contains(@class, 'woocommerce-Price-currencySymbol')]/text()"
      }
    },
    {
      id: "google-shopping",
      name: "Google Shopping",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      "is-aggregator": true,
      base: {
        "*-ae": "www.google.ae",
        "*-au": "www.google.com.au",
        "*-br": "www.google.com.br",
        "*-ca": "www.google.ca",
        "*-cn": "www.google.cn",
        "*-de": "www.google.de",
        "*-es": "www.google.es",
        "*-fr": "www.google.fr",
        "*-gb": "www.google.co.uk",
        "*-in": "www.google.co.in",
        "*-it": "www.google.it",
        "*-jp": "www.google.co.jp",
        "*-mx": "www.google.mx",
        "*-nl": "www.google.nl",
        "*-sg": "www.google.com.sg",
        "*-tr": "www.google.com.tr",
        "*-us": "www.google.com"
      },
      scout: "verb-miner-function-google-shopping-scout",
      mine: "verb-miner-function-google-shopping-mine"
    },
    {
      id: "google",
      name: "Google",
      "is-aggregator": true,
      paths: [],
      base: {
        "*-ae": "www.google.ae",
        "*-au": "www.google.com.au",
        "*-br": "www.google.com.br",
        "*-ca": "www.google.ca",
        "*-cn": "www.google.cn",
        "*-de": "www.google.de",
        "*-es": "www.google.es",
        "*-fr": "www.google.fr",
        "*-gb": "www.google.co.uk",
        "*-in": "www.google.co.in",
        "*-it": "www.google.it",
        "*-jp": "www.google.co.jp",
        "*-mx": "www.google.mx",
        "*-nl": "www.google.nl",
        "*-sg": "www.google.com.sg",
        "*-tr": "www.google.com.tr",
        "*-us": "www.google.com"
      },
      asdfasdgscout: "verb-miner-function-google-scout",
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "gravis",
      name: "gravis",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/p/(?<identifier>\\d+)"
      ],
      base: "www.gravis.de",
      ore: {
        availability: "//div[@class='dispo-status dispo-status--detail GREEN']/text()",
        barcode: "//tr[td[contains(text(), 'EAN')]]/td[2]/text()",
        cost: "//meta[@name='product:price:amount']/@content",
        currency: "//meta[@name='product:price:currency']/@content",
        sku: "//input[@name='productCodePost']/@value",
        mpn: "//td[contains(text(), 'Hersteller-Artikelnummer')]/following-sibling::td/text()"
      }
    },
    {
      id: "greentoe",
      name: "Greentoe",
      base: "greentoe.com",
      paths: [
        "/product/(?<identifier>[^/]+)$"
      ],
      ore: {
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.offers.1.price',
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[contains(@class, 'msrp-price-online')]/span/text()"
        ],
        model: [
          "//h2[contains(text(), 'Model:')]/text()"
        ],
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.offers.0.availability',
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability'
        ],
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: [
          "//input[@id='product_id']/@value",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ],
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(2)||||EAN_UPC_Code__c'
      }
    },
    {
      id: "groceryvan",
      name: "groceryvan",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "variant=(?<identifier>\\d+)"
      ],
      base: "www.groceryvan.com.au",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(13)||||ProductID',
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(13)||||Price',
          "//span[@id='ProductPrice']/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        model: "//td[contains(text(), 'Model Number')]/following-sibling::td[@class='attrib-val']/text()",
        sku: [
          "json||||script:nth-of-type(64)||||product.variants.0.sku",
          "//meta[@itemprop='sku']/@content"
        ]
      }
    },
    {
      id: "gurgencler",
      name: "gurgencler",
      paths: [],
      base: "www.gurgencler.com.tr",
      ore: {
        availability: [
          'json||||script[type="text/x-magento-init"]:nth-of-type(20)||||*.Magento_Catalog/js/product/view/provider.data.items.61020.is_available'
        ],
        cost: [
          "//span[contains(@id, 'product-price-')]/span[@class='price']/text()"
        ],
        currency: [
          "//meta[@property='product:price:currency']/@content"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "hanes",
      name: "Hanes",
      category_tags: [
        "clothing"
      ],
      base: "hanes.com",
      paths: [
        "(?<identifier>[a-z0-9\\-]+)\\.html"
      ],
      scout: null,
      ore: {
        cost: [
          "//span[@itemprop='price']",
          "//span[@class='normal-price sly-special-price']//span[@class='price bfx-price']"
        ],
        title: "//span[itemprop='name']"
      }
    },
    {
      id: "hannaford",
      name: "Hannaford",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "hannaford.com"
      },
      paths: [
        "\\/product\\/(?<identifier>[^/]+)",
        "\\/p\\/(?<identifier>[^/]+)",
        "\\/item\\/(?<identifier>[^/]+)",
        "\\/groceries\\/(?<identifier>[^/]+)"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: ".product-price",
              at: "afterend"
            },
            {
              selector: ".product-details",
              at: "afterend"
            }
          ]
        }
      ],
      "skip-normal-mining": true,
      mine: "verb-miner-function-hannaford-mine",
      "brick-and-mortar": "verb-miner-function-hannaford-mine",
      scout: {
        path: "https://www.hannaford.com/search?q={{query}}",
        items: ".product-item",
        ore: {
          title: ".product-name",
          cost: ".product-price",
          url: ".product-link||||href",
          imageUrl: ".product-image img||||src",
          availability: ".stock-status"
        }
      },
      serviceArea: {
        type: "regional-northeast",
        coverage: [
          "ME",
          "NH",
          "VT",
          "MA",
          "NY"
        ],
        headquarters: "Scarborough, ME",
        founded: 1883,
        storeCount: "180+"
      },
      loyaltyPrograms: {
        rewards: {
          name: "My Hannaford Rewards",
          benefits: [
            "Personalized offers",
            "Digital coupons",
            "Pharmacy rewards"
          ],
          free: true
        }
      },
      services: {
        pharmacy: "Full-service pharmacy with prescription refills",
        groceryPickup: "To Go pickup service",
        groceryDelivery: "Home delivery in select markets",
        sustainability: "Local sourcing and environmental focus"
      },
      apiInformation: {
        baseUrl: "https://www.hannaford.com/api/",
        authentication: "Session-based with Ahold Delhaize shared infrastructure",
        framework: "Peapod Digital Labs platform",
        tier: "Tier 3 - Complete custom mining required"
      }
    },
    {
      id: "harveynorman",
      name: "harveynorman",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      base: "www.harveynorman.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability',
          "//div[contains(@class, 'MissedProduct_sf-missed-product__wrapper')]/p/text()"
        ],
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(2)||||product.barcode_gtin',
          "//th[contains(text(), 'Barcode')]/following-sibling::td/text()"
        ],
        cost: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.price',
        currency: "json||||#__NEXT_DATA__||||props.pageProps.pageProps.pageData.storeConfig.base_currency_code",
        model: "//tr[th[contains(text(), 'Model')]]/td/text()",
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(2)||||product.sku',
          "//small[contains(@class, 'ProductPage_sf-page-product__sku-meta')]/text()"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "hashtechguy",
      name: "hashtechguy",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "hashtechguy.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.offers.0.availability',
          "//p[contains(@class, 'stock')]/text()"
        ],
        barcode: [
          "json||||#woo-add-gtin-js-extra||||gtin",
          "//span[contains(@class, 'hwp-gtin')]/span/text()"
        ],
        cost: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.offers.0.priceSpecification.price',
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.offers.0.priceCurrency',
          "//span[@class='woocommerce-Price-currencySymbol']/text()"
        ],
        sku: "//div[contains(@class, 'product-sku')]/text()"
      }
    },
    {
      id: "hayneedle",
      name: "Hayneedle",
      category_tags: [
        "home-garden"
      ],
      base: "hayneedle.com",
      paths: [
        "product\\/(?<identifier>[a-z0-9\\-]+)\\.cfm"
      ],
      scout: null,
      ore: {
        barcode: "substring(substring-after(//script[contains(text(),'upc')],'upc'),4,12)",
        brand: "//div[contains(text(),'Brand')]/following-sibling::*",
        cost: [
          "concat(//span[@class='main-price-dollars'],'.',//span[@class='main-price__cents___2BnzK'])"
        ],
        mpn: "//div[contains(text(),'Model')]/following-sibling::*",
        sku: [
          "//meta[@name='branch:deeplink:product_id']//@content"
        ],
        title: "//h1[@class='title']",
        availability: [
          "json||||script:nth-of-type(13)||||pageData.productStatus.status",
          "//span[contains(@class, 'note')]/text()"
        ]
      }
    },
    {
      id: "heb",
      name: "H-E-B",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "www.heb.com"
      },
      paths: [
        "\\/product\\/(?<identifier>[^/]+)",
        "\\/p\\/(?<identifier>[^/]+)",
        "\\/item\\/(?<identifier>[^/]+)",
        "\\/groceries\\/(?<identifier>[^/]+)",
        "instacart\\.com\\/store\\/h-e-b\\/search\\/(?<identifier>[^/?]+)",
        "instacart\\.com\\/store\\/h-e-b\\/products\\/(?<identifier>[^/?]+)"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: ".price-display, .product-price",
              at: "afterend"
            }
          ]
        }
      ],
      mine: "verb-miner-function-heb-mine",
      "brick-and-mortar": "verb-miner-function-heb-mine-brick-and-mortar",
      scout: "verb-miner-function-heb-scout",
      ore: {
        cost: [
          'meta[property="product:price:amount"]@content',
          ".price",
          "[data-price]",
          'script[type="application/ld+json"]'
        ],
        availability: [
          'meta[property="product:availability"]@content',
          ".availability",
          "[data-availability]",
          ".stock-status"
        ]
      },
      notes: [
        "Optimized for mobile app context: enhanced ore sifters + texas mobile context"
      ]
    },
    {
      id: "hepsiburada",
      name: "hepsiburada",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      base: "www.hepsiburada.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]||||@graph.offers.availability',
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(25)||||product_barcode',
        cost: [
          'json||||script[type="application/ld+json"]||||@graph.offers.price',
          "//div[contains(@class, 'price-container')]/descendant::span[@id='offering-price']/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(25)||||order_currency',
          "//span[@id='offering-price']/span[@class='turkishLira']/text()"
        ],
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(25)||||product_skus.0',
          "//input[@name='sku']/@value"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "herbspro",
      name: "HerbsPro",
      category_tags: [
        "health-pharmacy"
      ],
      base: "herbspro.com",
      paths: [
        "products\\/(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//div[contains(@class, 'product-upc')]/span/text()",
          "substring-after(//li[contains(text(),'UPC')],'UPC: ')"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.price',
          "//meta[@property='og:price:amount']/@content",
          "//div[@class='product-price-box-dg']//span[contains(@class, 'price')]/span[@class='money']/text()",
          "(//span[contains(@id, 'line_discounted_price_')])[1]"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||sku',
          'json||||script[type="text/javascript"]:nth-of-type(42)||||ProductID',
          "substring-after(//li[contains(text(),'SKU')],'SKU: ')"
        ],
        title: "normalize-space(//h1)",
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.availability',
          "//div[contains(@class, 'product-inventory')]/span/div[contains(@class, 'in-stock')]/text()",
          "//div[contains(@class, 'product-inventory')]/span/div[@class='in-stock']/text()"
        ],
        currency: [
          "json||||script:nth-of-type(50)||||user_curr",
          "//meta[@property='og:price:currency']/@content"
        ]
      }
    },
    {
      id: "heritagewineandliquor",
      name: "heritagewineandliquor",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "\\/(?<identifier>[a-f0-9]{24})\\?option-id="
      ],
      base: "heritagewineandliquor.com",
      ore: {
        availability: [
          "json||||#product-metadata||||offers.availability",
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          "json||||#product-metadata||||offers.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#product-metadata||||offers.priceCurrency",
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          "json||||#product-metadata||||sku"
        ]
      }
    },
    {
      id: "holabirdsports",
      name: "holabirdsports",
      category_tags: [
        "sports-outdoors"
      ],
      base: "www.holabirdsports.com",
      paths: [
        "/products/(?<identifier>[^?]+)"
      ],
      ore: {
        availability: [
          'json||||script[type="text/javascript"]:nth-of-type(15)||||available',
          "//meta[@property='product:availability']/@content"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin12',
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(25)||||Price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(24)||||currency',
          "//meta[@property='product:price:currency']/@content"
        ],
        model: "//div[@id='style-number']//span[@class='spec-value']/text()",
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
      }
    },
    {
      id: "homedepot",
      name: "The Home Depot",
      category_tags: [
        "home-garden"
      ],
      base: "www.homedepot.com",
      paths: [
        "\\/p\\/.*\\/(?<identifier>[0-9]+)",
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)\\"
      ],
      "brick-and-mortar": "verb-miner-function-homedepot-mine-brick-and-mortar",
      ore: {
        availability: [
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.availability",
          "//span[@class='alert-inline__message']//text()"
        ],
        barcode: [
          "verb-miner-function-default-ore-schemadotorg-product-json:gtin13"
        ],
        brand: [
          "verb-miner-function-default-ore-schemadotorg-product-json:brand.name",
          "concat(//span[@class='brand'],//h2//span[@class='bttn__content'])"
        ],
        cost: [
          "verb-miner-function-default-ore-schemadotorg-product-json:offers.price",
          "//div[@class='price-format__large price-format__main-price']//text()"
        ],
        costDelivery: "//div[@class='fulfillment__content-wrapper card-deck']//text()",
        currency: "verb-miner-function-default-ore-schemadotorg-product-json:offers.priceCurrency",
        mpn: [
          "substring-after(normalize-space(//h2[contains(text(),'Model #')]),'Model #')"
        ],
        sku: [
          "verb-miner-function-default-ore-schemadotorg-product-json:sku",
          "//h2[contains(text(), 'Store SKU')]/following-sibling::h2[1]/text()",
          "substring-after(//h2[contains(text(),'Internet #')],'#')"
        ],
        title: [
          "verb-miner-function-default-ore-schemadotorg-product-json:name",
          "//h1[@class='product-details__title']/text()",
          "substring-before(//title,' - The Home Depot')"
        ],
        model: "//div[contains(@class, 'sui-flex')]/h2[contains(text(), 'Model #')]/following-sibling::h2/text()",
        url: "verb-miner-function-default-ore-schemadotorg-product-json:offers.url",
        reviews: "verb-miner-function-homedepot-ore-reviews"
      },
      scout: {
        path: "/s/{{query}}",
        items: [
          ".//section[@id='browse-search-pods-1']",
          "div[data-component='productpod']"
        ],
        ore: {
          cost: [
            './/div[@class="price-format__main-price"]//span//text()',
            ".price__numbers"
          ],
          image: [
            './/div[@class="product-pod__image-wrapper"]//img/@src',
            ".plp-pod__image > a img||||src"
          ],
          title: [
            './/h2[@class="product-pod__title product-pod__title__product"]//text()',
            ".plp-pod__image > a img||||alt"
          ],
          url: [
            './/idv[@class="product-pod__title product-pod__title__product"]/a/@href',
            ".plp-pod__image > a||||href"
          ]
        }
      }
    },
    {
      id: "homehardware",
      name: "homehardware",
      category_tags: [
        "home-garden"
      ],
      paths: [
        "/p/(?<identifier>\\d+)"
      ],
      base: "www.homehardware.ca",
      ore: {
        availability: "json||||script:nth-of-type(16)||||inventoryInfo.onlineStockAvailable",
        barcode: [
          "json||||script:nth-of-type(16)||||upc",
          "//meta[@class='product'][@data-gtin='gtin']/@content"
        ],
        cost: [
          "json||||script:nth-of-type(16)||||price.price",
          "//meta[@class='aggregateOffer']/@content"
        ],
        model: [
          "//tr[th[contains(text(), 'Model')]]/td/text()"
        ],
        sku: "json||||script:nth-of-type(16)||||productCode"
      }
    },
    {
      id: "howards",
      name: "howards",
      category_tags: [
        "home-garden"
      ],
      base: "howards.com",
      paths: [
        "\\/(?<identifier>[\\w+]+)\\/$"
      ],
      ore: {
        availability: "//i[@class='material-icons md-24 pure-button-text-color-black out-of-stock']/following-sibling::text()",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//span[@id='product-price-167359']/@data-price",
          "//p[@class='product-details-display-price']/text()"
        ],
        model: [
          "//strong[text()='Model#']/following-sibling::text()"
        ],
        barcode: "//tr[.//b[text()='UPC']]/td[last()]/text()",
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
      }
    },
    {
      id: "hp",
      name: "HP",
      category_tags: [
        "electronics"
      ],
      base: "store.hp.com",
      paths: [
        "(.+)\\/(.+)\\/(.+)\\/(?<identifier>[a-z0-9\\-\\(\\)]+)"
      ],
      scout: null,
      ore: {
        barcode: "substring-before(substring-after(//div[@class='upc pdp-layered'],'UPC: '),'Part')",
        brand: "substring-before(//div[@class='product-detail']/h1,' ')",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[@class='prd-price total-price']"
        ],
        mpn: [
          "//span[@class='pdp-sku']"
        ],
        title: "//div[@class='product-detail']/h1",
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
      }
    },
    {
      id: "hughes",
      name: "hughes",
      paths: [],
      base: "hughes.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//div[contains(@class, 'product-availability-check')]/div/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]||||mpn',
        sku: [
          'json||||script[type="application/ld+json"]||||@id'
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "hulle24",
      name: "hulle24",
      paths: [
        "\\?number=(?<identifier>\\d+)"
      ],
      base: "www.hulle24.de",
      ore: {
        availability: "//span[contains(text(), 'auf Lager')]",
        barcode: "//span[@itemprop='gtin12']/@content",
        cost: [
          "json||||script:nth-of-type(3)||||ecommerce.detail.products.0.price",
          "//div[@class='product--price price--default']/span[@class='price--content content--default ']/text()"
        ],
        currency: [
          "json||||script:nth-of-type(3)||||ecommerce.currencyCode",
          "//span[@itemprop='priceCurrency']/@content"
        ],
        mpn: "//span[@class='config-container-quantity-selection-inputfield is--hidden']/preceding-sibling::span[contains(@itemprop, 'gtin')]/@content",
        sku: "json||||script:nth-of-type(3)||||ecommerce.detail.products.0.id"
      }
    },
    {
      id: "hyvee",
      name: "Hy-Vee",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "hy-vee.com"
      },
      paths: [
        "\\/grocery\\/products\\/(?<identifier>[0-9]+)",
        "\\/grocery\\/products\\/([^\\/]+)\\/(?<identifier>[a-z0-9\\-]+)",
        "\\/grocery\\/([^\\/]+)\\/(?<identifier>[a-z0-9\\-]+)",
        "\\/aisles-online\\/products\\/(?<identifier>[0-9a-z\\-]+)",
        "\\/products\\/([^\\/]+)\\/([^\\/]+)\\/(?<identifier>[a-z0-9\\-]+)"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: "[data-testid='product-price']",
              at: "afterend"
            },
            {
              selector: ".product-details",
              at: "afterend"
            }
          ]
        }
      ],
      mine: "verb-miner-function-hyvee-mine",
      "brick-and-mortar": "verb-miner-function-hyvee-brick-and-mortar",
      scout: {
        path: "https://www.hy-vee.com/search?q={{query}}",
        mine: "verb-miner-function-hyvee-scout"
      },
      cooperativeContext: {
        type: "employee-owned-cooperative",
        ranking: "America's #1 Grocery Store (2024)",
        storeCount: "280+",
        coverage: [
          "IA",
          "NE",
          "MO",
          "KS",
          "MN",
          "SD",
          "IL",
          "WI"
        ],
        headquarters: "West Des Moines, Iowa",
        founded: 1930,
        employeeOwned: true,
        recentAcquisition: "Strack & Van Til (2024)"
      },
      loyaltyPrograms: {
        perks: {
          name: "PERKS",
          benefits: [
            "Fuel rewards",
            "Digital coupons",
            "Personalized deals"
          ],
          free: true
        },
        perksPlus: {
          name: "PERKS PLUS",
          benefits: [
            "Enhanced employee benefits",
            "Exclusive savings",
            "Community rewards"
          ],
          employeeOwnershipBenefits: true
        }
      },
      services: {
        pharmacy: "Full-service pharmacy with prescription refills",
        fuelStations: "Fuel rewards through PERKS program",
        groceryPickup: "Aisles Online pickup service",
        groceryDelivery: "Home delivery in select markets",
        communityServices: "Community rooms and local partnerships"
      },
      apiInformation: {
        baseUrl: "https://api.prod.hy-vee.cloud/discover-api/",
        authentication: "RBAC (Role-Based Access Control)",
        framework: "Next.js with server-side rendering",
        tier: "Tier 3 - Complete custom mining required"
      }
    },
    {
      id: "idefix",
      name: "idefix",
      category_tags: [
        "books"
      ],
      paths: [],
      base: "www.idefix.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        cost: "//meta[@property='og:price:amount']/@content",
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
          "//meta[@property='og:price:currency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "iherb",
      name: "iHerb",
      category_tags: [
        "health-pharmacy"
      ],
      base: "iherb.com",
      paths: [
        "pr\\/(.+)\\/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        availability: "//meta[@property='og:availability']/@content",
        "available-total": "//div[@id='stock-status']//strong[contains(text(), 'In Stock -')]/text()",
        barcode: [
          "//li[contains(text(), 'UPC Code:')]/span[@itemprop='gtin12']/text()",
          "normalize-space(substring-after(//ul[@id='product-specs-list']//li[contains(.,'UPC Code')], ': '))"
        ],
        brand: "//meta[@property='og:brand']/@content",
        condition: "//link[@itemprop='itemCondition']/@href",
        cost: [
          "//strong[@id='one-time-purchase-price-special']/text()",
          "normalize-space(//div[@id='price'])"
        ],
        image: "//img[contains(@class, 'lazy')]/@data-lazyload",
        mpn: "//span[@itemprop='sku']/text()",
        rating: "//meta[@itemprop='ratingValue']/@content",
        "ratings-total": "//div[@itemprop='aggregateRating']/meta[@itemprop='reviewCount']/@content",
        "reviews-total": "//meta[@itemprop='reviewCount']/@content",
        sku: [
          "//span[@itemprop='sku']/text()",
          "(//input[@type='hidden' and @name='pid']/@value)[1]"
        ],
        title: [
          "//h1[@itemprop='name']",
          "//div[@id='name']/text()"
        ],
        units: "//li[contains(text(), 'Package Quantity:')]/span[@class='package-quantity']/text()",
        url: "//link[@itemprop='url']/@href"
      }
    },
    {
      id: "impalarollerskates",
      name: "impalarollerskates",
      category_tags: [
        "clothing"
      ],
      base: "impalarollerskates.com",
      paths: [
        "/products/(?<identifier>[^/]+)$"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability'
        ],
        barcode: 'json||||script[type="application/json"]:nth-of-type(6)||||sku',
        cost: [
          "//div[@id='price-template--14198983753822__main']//span[contains(@class, 'price-item--sale')]/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: [
          "//div[contains(@class, 'product-form__buttons')]/preceding-sibling::input[@name='id']/@value"
        ]
      }
    },
    {
      id: "incase",
      name: "Incase",
      category_tags: [
        "electronics"
      ],
      base: "incase.com",
      paths: [
        "products\\/(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//meta[@property='product:gtin']/@content",
          "substring(substring-after(//script[contains(text(),'gtin')],'gtin12'),4,12)"
        ],
        brand: "substring-after('incase','')",
        cost: [
          "//meta[@itemprop='price']/@content",
          "//span[@class='price']"
        ],
        mpn: [
          "substring-after(//div[@class='mm-product-sku'],'SKU')"
        ],
        title: "concat(substring-after('incase ',''),//meta[@property='og:title']/@content)",
        availability: "//link[@itemprop='availability']/@href",
        sku: "//meta[@itemprop='productID']/@content",
        currency: 'json||||script[type="text/javascript"]:nth-of-type(17)||||currency'
      }
    },
    {
      id: "instacart",
      name: "Instacart",
      category_tags: [
        "grocery-food"
      ],
      base: "www.instacart.com",
      paths: [
        "landing\\?product_id=(?<identifier>[0-9A-Z\\/]+)&retailer_id=(?<identifier2>[0-9A-Z\\/]+)"
      ],
      scout: false,
      mine: "verb-miner-function-instacart-mine"
    },
    {
      id: "iosys",
      name: "iosys",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>\\d+)$"
      ],
      base: "iosys.co.jp",
      ore: {
        availability: 'json||||script[type="application/ld+json"]||||offers.availability',
        currency: 'json||||script[type="application/ld+json"]||||offers.priceCurrency',
        mpn: 'json||||script[type="application/ld+json"]||||mpn',
        sku: [
          "//div[contains(@class, 'about02')]/p[contains(span, '商品番号')]/text()",
          "normalize-space(//*[contains(text(), '商品番号')]/following-sibling::*[not(self::script)][1])"
        ]
      }
    },
    {
      id: "itradeit",
      name: "itradeit",
      paths: [
        "/shop/(?<identifier>[^/]+)/"
      ],
      base: "itradeit.in",
      ore: {
        availability: [
          "json||||.yoast-schema-graph.yoast-schema-graph--woo.yoast-schema-graph--footer||||@graph.0.offers.0.availability",
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          "json||||.yoast-schema-graph.yoast-schema-graph--woo.yoast-schema-graph--footer||||@graph.0.offers.0.offers.1.priceSpecification.price"
        ],
        currency: [
          "json||||.yoast-schema-graph.yoast-schema-graph--woo.yoast-schema-graph--footer||||@graph.0.offers.0.priceCurrency",
          "//span[@class='woocommerce-Price-currencySymbol']/text()"
        ],
        model: [
          "//div[contains(@class, 'pdp__specification-row')]/div[contains(@class, 'pdp__tab-info__list__name')][contains(text(), 'Model')]/following-sibling::div[contains(@class, 'pdp__tab-info__list__value')]/text()"
        ],
        mpn: [
          "//meta[@property='product:retailer_item_id']/@content"
        ],
        sku: [
          "json||||.yoast-schema-graph.yoast-schema-graph--woo.yoast-schema-graph--footer||||@graph.0.sku",
          "//meta[@property='product:retailer_item_id']/@content"
        ]
      }
    },
    {
      id: "jamoon",
      name: "jamoon",
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "jamoon.in",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.0.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.0.priceSpecification.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.0.priceCurrency',
          "//span[contains(@class, 'woocommerce-Price-currencySymbol')]/text()"
        ],
        model: "//tr[contains(@class, '_1s_Smc row')]/td[contains(text(), 'Model Name')]/following-sibling::td/ul/li/text()",
        sku: 'json||||script[type="application/ld+json"]||||@graph.1.sku'
      }
    },
    {
      id: "jbl",
      name: "JBL",
      category_tags: [
        "electronics"
      ],
      base: "jbl.com",
      paths: [
        "(.+)\\/(?<identifier>[A-Z0-9]+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: "substring(substring-after(//a[@class='swatchanchor text-hide color-blue']/@data-lgimg,'upc'),5,12)",
        brand: "substring-after('JBL','')",
        cost: [
          "//span[@class='value']/text()",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//span[contains(@class, 'price-buy-now')]/text()",
          "(//div[@class='product-price ']//span)[1]",
          "//span[@itemprop='price']"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
          "//isapplepay[@id='apple-pay-button']/@sku"
        ],
        title: "//h1[@class='product-name']",
        availability: [
          "//span[contains(text(), 'Sold Out')]",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//div[contains(@class, 'availability')]/p[@class='inStock']/text()"
        ],
        model: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//span[@class='js-specs-sku-id']/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(5)||||siteCurrencyCode',
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
        ]
      }
    },
    {
      id: "jcpenney",
      category_tags: [
        "sells-everything"
      ],
      base: "jcpenney.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)"
      ],
      ore: {
        availability: [
          "//p[@data-automation-id='addToCart'][contains(text(), 'Add to Cart')]||||'in stock'",
          "//p[@data-automation-id='getInStock'][contains(text(), 'Get In Stock Alert')]||||'out of stock'",
          "'unknown'"
        ],
        brand: `substring-after('"brand":{"name":"','')`,
        cost: "//span[@data-automation-id='at-price-value']//text()",
        delivery: "//div[@aria-label='shippingAndReturn']//text()",
        title: ".//h1[@data-automation-id='product-title']/text()",
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||productID'
      },
      scout: {
        "path-disabled": "/s?searchTerm={{query}}",
        items: './/ul[@data-automation-id="gallery-product-list"]/li',
        ore: {
          cost: './/span[@data-automation-id="at-price-value"]/text()',
          image: './/div[@class="Yylbp absolute w-full h-full max-w-full"]/img/@src',
          title: './/div[@class="CaM-7"]/a/text()',
          url: './/a[@class="w-full h-full"]/@href'
        }
      }
    },
    {
      id: "jiomart",
      name: "jiomart",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\/(?<identifier>\\d+)\\?source="
      ],
      base: "www.jiomart.com",
      ore: {
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency'
        ],
        model: "//tr[th[contains(text(), 'Model')]]/td/text()",
        sku: "//input[@id='sku_val']/@value"
      }
    },
    {
      id: "johnlewis",
      name: "johnlewis",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\/(?<identifier>[\\w-]+)$"
      ],
      base: "johnlewis.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//button[contains(text(), 'Add to basket')]/text()"
        ],
        barcode: "json||||#__NEXT_DATA__||||props.pageProps.product.mainVariant.consumerBarcodes.ean13.0",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//span[@data-testid='product:price']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency'
        ],
        model: "json||||#__NEXT_DATA__||||props.pageProps.product.variants.0.attributes.1.value",
        mpn: [
          "json||||#__NEXT_DATA__||||props.pageProps.product.mainVariant.attributes.2.value",
          "//span[contains(@class, 'ProductSpecification_productSpecificationListLabelName') and contains(text(), 'Manufacturer Part Number (MPN)')]/following::dt[1]/text()"
        ],
        sku: [
          "json||||#__PRODUCT_DATA__||||skuId",
          "//input[@data-testid='product:basket:form:skuId']/@value"
        ]
      }
    },
    {
      id: "jomashop",
      name: "JomaShop",
      category_tags: [
        "jewelry-watches"
      ],
      base: "jomashop.com",
      paths: [
        "(?<identifier>[a-z0-9\\-]+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          "//h4[text()='UPC Code']/following-sibling::h4",
          "//li[./label[contains(text(), 'UPC Code')]]//div"
        ],
        brand: [
          "//h4[text()='Brand']/following-sibling::h4",
          "//label[@class='label' and contains(text(), 'Brand')]/following-sibling::div"
        ],
        cost: [
          "//div[@class='now-price']//span[1]",
          "//p[@class='final-price']"
        ],
        image: "//div[contains(@class,'swiper-slide slide-item')]//img[1]/@src",
        mpn: [
          "//h4[text()='Model']/following-sibling::h4",
          "//label[@class='label' and contains(text(), 'Model')]/following-sibling::div"
        ],
        sku: [
          "//meta[@name='preload_data']/@data-preload-product-id",
          "//h4[text()='Internal ID']/following-sibling::h4",
          "substring-after(//span[@class='product-ids'], 'No.')"
        ],
        title: [
          "//span[@class='product-name-container']//span)[1]",
          "//span[@class='product-name']"
        ],
        availability: "//meta[@name='preload_data' and @data-preload-type='product']/@data-preload-product-stock-status",
        model: "//body/@data-model-id"
      }
    },
    {
      id: "joshinweb",
      name: "joshinweb",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>\\d+)\\.html"
      ],
      base: "joshinweb.jp",
      ore: {
        availability: "//dt[contains(text(), '在庫状況')]/a/text()",
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(10)||||item',
        cost: "//dd/i/text()",
        mpn: "//span[contains(@class, 'item_name_03')]/text()",
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(10)||||item',
          "//div[@data-item-unit='code']/@data-item-id"
        ]
      }
    },
    {
      id: "jshopping",
      name: "jshopping",
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "jshopping.in",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.0.availability',
          "//p[@class='stock in-stock']/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.0.priceSpecification.price'
        ],
        currency: [
          "//span[@class='woocommerce-Price-currencySymbol']/text()"
        ],
        sku: 'json||||script[type="application/ld+json"]||||sku'
      }
    },
    {
      id: "jw",
      name: "jw",
      paths: [
        "/product/(?<identifier>[^/]+)"
      ],
      base: "www.jw.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.availability',
          "//meta[@property='product:availability']/@content"
        ],
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||gtin13'
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||script:nth-of-type(35)||||currencyCode",
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||mpn',
          "//div[@class='product attribute mpn']/div[@itemprop='mpn']/text()"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||sku',
          "//meta[@property='product:retailer_item_id']/@content"
        ]
      }
    },
    {
      id: "kaleidoscope",
      name: "kaleidoscope",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      base: "https://www.kaleidoscope.co.uk",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        barcode: "//meta[@itemprop='gtin13']/@content",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        mpn: "substring-after(//div[contains(@class, 'productCatNoContainer')]//span[contains(@class, 'productCode')]/text(), ':')",
        sku: "//meta[@itemprop='sku']/@content"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "karlsonline",
      name: "karlsonline",
      category_tags: [
        "electronics"
      ],
      base: "karlsonline.com",
      paths: [
        "\\/(?<identifier>[^\\/]+)\\/$"
      ],
      ore: {
        availability: "//input[@value='ADD TO CART']/@value",
        cost: [
          "//p[contains(@class, 'product-details-display-price')]/text()",
          "//input[@name='WebPrice']/@value"
        ],
        model: [
          "//h2/strong[text()='Model#']/following-sibling::text()",
          "//input[@id='Model']/@value"
        ],
        barcode: "//td[contains(., 'UPC')]/following-sibling::td/text()"
      }
    },
    {
      id: "kaufland",
      name: "kaufland",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/product/(?<identifier>\\d+)"
      ],
      base: "www.kaufland.de",
      ore: {
        availability: "//p[contains(@class, 'rd-available-items')]/text()",
        currency: "//p[contains(@class, 'rd-price-information__price-and-saving')]/span[@class='rd-price-information__price']/text()"
      }
    },
    {
      id: "keepa",
      name: "Keepa",
      base: {
        "*-us": "keepa.com",
        "*-undefined": "keepa.com"
      },
      paths: [
        "^#!product\\/1-(?<identifier>[B][A-Z0-9]{9})$",
        "#!product\\/1-(?<identifier>[B][A-Z0-9]{9})",
        "product\\/1-(?<identifier>[B][A-Z0-9]{9})",
        "(?<identifier>[B][A-Z0-9]{9})"
      ],
      "skip-normal-mining": true,
      mine: "verb-miner-function-keepa-mine",
      scout: "verb-miner-function-keepa-scout"
    },
    {
      id: "keurig",
      category_tags: [
        "appliances"
      ],
      base: "keurig.com",
      paths: [],
      ore: {
        cost: "//span[@class='od-graphql-price-big-price']/text()",
        title: "//span[@class='heading css-ydslbj']/div/text()"
      },
      scout: {
        "path-disabled": "/search?text={{query}}",
        items: './/div[contains(@class,"search-products")]',
        ore: {
          cost: './/span[@class=" css-x69dr3"]/text()',
          image: './/div[@class="top-content"]/a/img/@src',
          title: './/div[@class="desc_text"]/a/text()',
          url: './/div[@class="desc_text"]/a/@href'
        }
      }
    },
    {
      id: "kickscrew",
      name: "kickscrew",
      category_tags: [
        "clothing"
      ],
      base: "www.kickscrew.com",
      paths: [
        "\\/products\\/(?<identifier>[^?]+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.offers.0.availability',
          "//p[contains(., 'is backordered')]/text()"
        ],
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(25)||||price',
          "//span[contains(@class, 'current-price')]/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        model: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||model',
          "//div[contains(@class, 'pdp-product-info-col')]/h3[contains(text(), 'Model No')]/following-sibling::span[@class='pdp-body-text']/text()"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||mpn',
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(25)||||sku'
        ]
      }
    },
    {
      id: "klarna",
      name: "Klarna",
      category_tags: [
        "sells-everything"
      ],
      "is-aggregator": true,
      paths: [],
      base: "www.klarna.com",
      scout: "verb-miner-function-klarna-scout",
      mine: "verb-miner-function-klarna-mine"
    },
    {
      id: "kmart",
      name: "Kmart",
      category_tags: [
        "sells-everything"
      ],
      base: {
        "*-us": "kmart.com",
        keyCountry: "www.kmart.com.au",
        "*-undefined": "www.kmart.com.au"
      },
      paths: [
        "(.+)\\/p-(?<identifier>[A-Z0-9]+)"
      ],
      scout: null,
      mine: "verb-miner-function-kmart-mine"
    },
    {
      id: "kobo",
      name: "Kobo",
      category_tags: [
        "books"
      ],
      base: "kobo.com",
      paths: [
        "(.+)\\/(.+)\\/(.+)\\/(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: "//dt[contains(text(),'ISBN')]/following-sibling::dd[1]",
        cost: [
          "(//div[@class='price-wrapper']//span)[3]",
          "//span[@data-automation-test-hook='sell-price']"
        ],
        title: [
          "normalize-space((//div[@class='item-info']//span)[1])",
          "//h1[@class='title']"
        ],
        availability: "//meta[@property='og:availability']/@content"
      }
    },
    {
      id: "kohls",
      category_tags: [
        "sells-everything"
      ],
      base: "kohls.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[\\w+]+)\\.jsp",
        ".*\\/prd\\-(?<identifiers>[0-9]+)"
      ],
      mine: "verb-miner-function-kohls-mine",
      scout: {
        path: "/search.jsp?submit-search=web-regular&search={{query}}",
        request: {
          headers: {
            accept: "text/html"
          }
        },
        redirectsSometimes: true,
        items: [
          "li .products_grid",
          ".products"
        ],
        ore: {
          brand: ".brandName",
          cost: [
            ".prod_price_amount red_color",
            ".prod_price_amount.hl_prod_price_amount",
            ".prod_price_amount",
            ".pricing.salePrice"
          ],
          image: [
            ".pmp-hero-img||||src",
            ".heroImage||||src"
          ],
          rating: "substring-before(//span[@class='prod_ratingImg']/a/@title, ' out of')",
          ratings: "substring-before(substring-after(//span[@class='prod_ratingCount']/a, '('), ')')",
          title: [
            ".prod_nameBlock p",
            ".productTitle"
          ],
          url: ".prod_img_block a||||href"
        }
      }
    },
    {
      id: "kroger",
      name: "Kroger",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/products/\\/(?<identifier>[^\\/]+)",
        "\\/p\\/.*\\/(?<identifier>[^\\/\\?\\&]+)"
      ],
      base: {
        "*-us": "kroger.com"
      },
      mine: "verb-miner-function-kroger-mine",
      ore: {
        cost: [
          ".ProductDetails-price",
          ".price",
          '[data-testid="price"]',
          'meta[property="product:price:amount"]@content'
        ],
        availability: [
          ".fulfillment-options",
          ".availability",
          '[data-testid="availability"]',
          'meta[property="product:availability"]@content'
        ]
      },
      scout: {
        path: "https://www.kroger.com/search?query={{query}}",
        items: [
          ".ProductCard",
          ".product-card",
          "[data-testid='product-card']",
          ".item",
          ".ProductTile"
        ],
        ore: {
          title: [
            ".ProductCard-title",
            ".product-title",
            "h3[data-testid='product-title']",
            ".item-title",
            ".ProductTitle"
          ],
          cost: [
            ".ProductPrice",
            ".price-current",
            "[data-testid='price']",
            ".price",
            ".ProductDetails-price"
          ],
          url: [
            "a[href*='/p/']||||href",
            ".ProductCard a||||href",
            "[data-testid='product-link']||||href"
          ],
          image: [
            ".ProductCard img||||src",
            ".product-image img||||src",
            "[data-testid='product-image']||||src"
          ],
          availability: [
            ".fulfillment-options",
            ".availability-status",
            "[data-testid='availability']",
            ".stock-indicator"
          ]
        }
      },
      notes: [
        "Optimized for mobile app context: enhanced custom mine + mobile context",
        "Scout functionality added: comprehensive search support for largest US grocer"
      ]
    },
    {
      id: "lambda-tek",
      name: "lambda-tek",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>[^~]+)~sh"
      ],
      base: "https://www.lambda-tek.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]||||offers.availability',
        barcode: "//li[contains(., 'EAN code:')]/text()",
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//h3[contains(@class, 'price')]/small/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          "//div[contains(@class, 'alert-warning')]/strong/text()"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn',
          "substring-after(//strong[text()='MPN']/following-sibling::text(), ': ')"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku'
        ]
      }
    },
    {
      id: "lampsplus",
      category_tags: [
        "home-garden"
      ],
      base: "lampsplus.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)\\.html",
        "\\/sfp\\/(?<identifier>\\w+)"
      ],
      ore: {
        cost: [
          "//meta[@itemprop='price']/@content",
          "//span[@id='lblPrice']//text()"
        ],
        delivery: "//li[@id='lblFreeReturnsBottom']//text()",
        title: "//h1[@id='h1ProductName']//text()",
        sku: "//meta[@itemprop='sku']/@content"
      },
      scout: {
        "path-disabled": "/products/s_{{query}}/",
        items: './/div[@id="sortResultProducts"]/div',
        ore: {
          cost: './/div[@class="sortResultProdPrice"]//text()',
          image: './/div[@class="sortResultImgContainer"]//img/@src',
          title: './/div[@class="sortResultProdName"]//text()',
          url: './/a[@class="sortResultLink"]/@data-plaurl'
        }
      }
    },
    {
      id: "laptopsdirect",
      name: "laptopsdirect",
      category_tags: [
        "electronics"
      ],
      paths: [],
      base: "laptopsdirect.co.uk",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.schema:availability',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.price',
          "//div[@id='wop']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.currencyUnit'
        ],
        model: "//li[contains(@class, 'terminator')]/h2/text()",
        mpn: "//div[contains(@class, 'breadCrumbTrail')]/ul/li[last()]/h2/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||schema:sku'
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "lenovo",
      category_tags: [
        "electronics"
      ],
      base: "lenovo.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)"
      ],
      ore: {
        availability: [
          "//meta[@name='productstatus']/@content"
        ],
        cost: [
          "//meta[@name='productprice']/@content",
          "//span[@class='final-price']//text()"
        ],
        delivery: "//div[@class='freeshippingQualifier']//text()",
        title: "//h2[@class='product_summary']//text()",
        model: "//meta[@name='ModelNameVariants']/@content",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//meta[@name='productid']/@content"
        ]
      },
      scout: {
        path: "/us/en/search?fq=&text={{query}}",
        items: './/ul[@class="product"]/li',
        ore: {
          cost: './/div[@class="final_price"]/text()',
          image: './/div[@class="normal_image"]//img/@src',
          title: './/div[@class="product_name"]//text()',
          url: './/div[@class="normal_image"]//a/@href'
        }
      }
    },
    {
      id: "lg",
      name: "LG",
      category_tags: [
        "electronics",
        "appliances"
      ],
      base: "lg.com",
      paths: [
        "/monitors/(?<identifier>[\\w-]+)\\?"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//p[contains(text(), 'In Stock')]",
          "json||||#__NEXT_DATA__||||props.pageProps.pdpPageData.labelData.global.label.common.cart.modalOutOfStock",
          "//p[contains(@class, 'MuiTypography-body1') and contains(text(), 'In Stock')]"
        ],
        model: [
          "json||||#__NEXT_DATA__||||props.pageProps.cmsProductData.product_info.model_name",
          "//div[@data-testid='product-information']//span/text()",
          "//span[contains(@class, 'MuiTypography-overline')]/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[contains(@class, 'price-wrapper')]//*[contains(text(), '$')]/text()"
        ],
        currency: [
          "json||||#__NEXT_DATA__||||props.pageProps.productData.product.price.currency"
        ],
        mpn: "//span[@class='MuiTypography-root MuiTypography-overline css-1k5vsc6']/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//span[@class='MuiTypography-root MuiTypography-overline css-1k5vsc6']/text()"
        ]
      }
    },
    {
      id: "lightinthebox",
      name: "lightinthebox",
      category_tags: [
        "clothing"
      ],
      paths: [],
      base: "lightinthebox.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//div[@id='order-action']/input/@value"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//strong[@itemprop='price']/text()"
        ],
        currency: "//span[contains(@class, 'curCountry')]/@data-abbr",
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "liquorama",
      name: "liquorama",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/(?<identifier>[\\w-]+)\\.html$"
      ],
      base: "liquorama.net",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//meta[@property='og:availability']/@content"
        ],
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(12)||||product_attributes.upc',
          "//span[contains(@class, 'productView-info-name') and contains(text(), 'UPC:')]/following-sibling::span[@class='productView-info-value']/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//span[@class='price price--withoutTax']/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(12)||||product_attributes.price.without_tax.currency',
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||mpn',
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(37)||||sku',
          "//span[contains(@class, 'productView-info-name') and contains(text(), 'SKU:')]/following-sibling::span[@class='productView-info-value']/text()"
        ]
      }
    },
    {
      id: "littleangelsprams",
      name: "littleangelsprams",
      paths: [],
      base: "littleangelsprams.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.availability',
          "//p[contains(text(), 'Stock is ordered')]/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(4)||||gtin13',
        cost: 'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.price',
        currency: [
          'json||||script[type="text/plain"]:nth-of-type(18)||||ecommerce.view.currency',
          "//span[contains(@class, 'price-formatted-currency-symbol')]/text()"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(4)||||mpn',
        sku: 'json||||script[type="text/plain"]:nth-of-type(18)||||ecommerce.view.sku'
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "lookfantastic",
      name: "lookfantastic",
      category_tags: [
        "beauty"
      ],
      paths: [
        "\\/(?<identifier>\\d+)\\.html"
      ],
      base: "us.lookfantastic.com",
      ore: {
        availability: [
          "json||||#productSchema||||offers.0.availability",
          "//p[contains(@class, 'productStockInformation_text')]/text()"
        ],
        cost: "json||||#productSchema||||offers.0.price",
        currency: [
          "json||||#productSchema||||offers.0.priceCurrency",
          "//span[@class='productBlock_priceCurrency']/@content"
        ],
        mpn: "json||||#productSchema||||mpn",
        sku: "json||||#productSchema||||sku"
      }
    },
    {
      id: "loopmobile",
      name: "loopmobile",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/products/(?<identifier>[^/]+)"
      ],
      base: "loopmobile.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.0.availability',
          "//div[contains(@class, 'stock_state_case')]/span"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.0.price',
          "//span[@class='price-item price-item--sale']/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(2)||||currency',
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: "json||||#ProductJson-product-template-special||||variants.0.sku"
      }
    },
    {
      id: "lowes",
      category_tags: [
        "home-garden"
      ],
      base: "lowes.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)",
        ".*\\/(?<identifier>.+)\\/"
      ],
      ore: {
        availability: [
          "verb-miner-function-lowes-ore-json:itemInventory.totalAvailableQty"
        ],
        barcode: [
          "verb-miner-function-lowes-ore-json:product.barcode",
          "verb-miner-function-lowes-ore-json:product.barcodes.0.code"
        ],
        brand: [
          "verb-miner-function-lowes-ore-json:product.brand",
          "//div[@itemprop='brand']/text()",
          "//meta[@itemprop='brand']//@content"
        ],
        cost: [
          "verb-miner-function-lowes-ore-json:mfePrice.price.additionalData.sellingPrice",
          "//span[@itemprop='price']/@content"
        ],
        delivery: "//div[contains(@class,'ShippingInventorystyles')]//text()",
        model: [
          "verb-miner-function-lowes-ore-json:product.modelId"
        ],
        mpn: [
          "//span[@class='met-product-model']"
        ],
        rating: "substring-before((//div[@class='BVRRRatingNormalImage']//img)[1]/@alt,' ')",
        ratings: "substring-before(normalize-space((//span[@class='productRating']/text())[2]),' ')",
        sku: [
          "verb-miner-function-lowes-ore-json:product.omniItemId",
          "verb-miner-function-lowes-ore-json:product.productId",
          "substring(substring(substring-before(substring-after(//script[contains(text(),'ivm')],'ivm'),','),4),0,string-length(substring(substring-before(substring-after(//script[contains(text(),'ivm')],'ivm'),','),4)))"
        ],
        title: [
          "verb-miner-function-lowes-ore-json:product.title",
          "//h1//text()",
          "normalize-space(//h1[@class='h3']/text())"
        ]
      },
      scout: {
        path: "/search?searchTerm={{query}}&view=List",
        items: [
          './/section[@id="listItems"]/div',
          ".pl > div > div > div"
        ],
        ore: {
          cost: [
            './/div[@automation-id="slpl-price-info"]//text()',
            "div[data-test='product-actual-price']"
          ],
          image: [
            './/div[@data-selector="splp-prd-img"]/img/@src',
            "div[data-test='product-image'] img||||src"
          ],
          title: [
            './/span[@class="description-spn"]//text()',
            "div[data-test='product-tile-spec'] a"
          ],
          url: [
            './/a[@data-clicktype="product_tile_click"]/@href',
            "div[data-test='product-tile-spec'] a||||href"
          ]
        }
      }
    },
    {
      id: "ltonlinestore",
      name: "ltonlinestore",
      category_tags: [
        "electronics"
      ],
      paths: [
        "-p(?<identifier>\\d+)$"
      ],
      base: "ltonlinestore.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//link[@itemprop='availability']/@href"
        ],
        cost: 'json||||script[type="application/ld+json"]||||offers.price',
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        model: "//span[@class='details-product-attribute__title' and contains(text(), 'Model no')]/following-sibling::span[@class='details-product-attribute__value']/text()",
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//div[contains(@class, 'product-details__product-sku')]"
        ]
      }
    },
    {
      id: "luckyvitamin",
      name: "Lucky Vitamin",
      category_tags: [
        "health-pharmacy"
      ],
      base: "luckyvitamin.com",
      paths: [
        "(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "(//strong[text()='UPC #']/following::div[@class='value'])[1]",
          "//meta[@itemprop='gtin13']/@content"
        ],
        brand: "(//strong[text()='Brand']/following::div[@class='value'])[1]",
        cost: "//span[@itemprop='price']/@content",
        sku: [
          "(//strong[text()='Item #']/following::div[@class='value'])[1]",
          "substring-after(//span[@class='itemNumber'], '#: ')"
        ],
        title: "(//h1[@itemprop='name'])[2]"
      }
    },
    {
      id: "luekensliquors",
      name: "luekensliquors",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "www.luekensliquors.com",
      ore: {
        availability: [
          "json||||.yoast-schema-graph.yoast-schema-graph--woo.yoast-schema-graph--footer||||@graph.0.offers.0.availability",
          "//meta[@property='product:availability']/@content"
        ],
        barcode: [
          "json||||#woo-add-gtin-js-extra||||gtin",
          "//meta[@property='product:retailer_item_id']/@content"
        ],
        cost: [
          "json||||.yoast-schema-graph.yoast-schema-graph--woo.yoast-schema-graph--footer||||@graph.0.offers.0.priceSpecification.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          "json||||script:nth-of-type(89)||||sku"
        ]
      }
    },
    {
      id: "lumens",
      category_tags: [
        "home-garden"
      ],
      base: "lumens.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[w+]+)\\.html",
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      ore: {
        availability: [
          "json||||.selectedVariant||||variant.availabilityMessage",
          "//div[contains(@class, 'availability-web')]/span/text()"
        ],
        cost: [
          "//span[@class='atc-price-section']/text()",
          "//div[@class='atc-price-section']/text()",
          "//div[@class='active-price']/span/text()"
        ],
        delivery: "//div[contains(@class,'no-stk availability')]/span/text()",
        mpn: [
          "json||||.selectedVariant||||variant.mfrId",
          "//p[@id='pdp-mfr-id-list']/span/text()"
        ],
        title: "//h1[contains(@class,'product-title')]//text()",
        sku: [
          "json||||.selectedVariant||||variant.skuId",
          "//div[@id='isSingleSkuProduct']/text()"
        ]
      },
      scout: {
        path: "/search/?q=door{{query}}",
        items: "//ul[@id='search-result-items']/li",
        ore: {
          brand: './/a[@class="thumb-link"]//img/@src',
          cost: './/span[contains(@class,"pricing d-inline-block")]//text()',
          image: './/a[@class="thumb-link"]//img/@src',
          title: './/div[contains(@class,"product-name")]/a/text()',
          url: './/div[contains(@class,"product-name")]/a/@href'
        }
      }
    },
    {
      id: "macys",
      category_tags: [
        "sells-everything"
      ],
      base: "macys.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)"
      ],
      ore: {
        availability: [
          "verb-miner-function-macys-ore-availability"
        ],
        cost: [
          "//div[contains(@class, 'price-details-container')]/div[@class='price-container']/div/div/span[@class='bold']/text()",
          "//div[@class='lowest-sale-price']//text()"
        ],
        delivery: "//div[contains(@class,'ship-it-avail')]//text()",
        title: "//div[@data-auto='product-name']//text()",
        sku: "//meta[@itemprop='productID']/@content"
      },
      scout: {
        "path-disabled": "https://www.macys.com/shop/featured/{{query}}",
        items: './/divl[@class="cell"]/ul/li',
        ore: {
          cost: './/span[@class="priceLabel"]/text()',
          image: './/div[@class="pge-img-opt-expr ll-search-browse-exp"]//img/@src',
          title: './/div[@class="productDescription"]/a/@title',
          url: './/div[@class="productDescription"]/a/@href'
        }
      }
    },
    {
      id: "mango",
      name: "mango",
      category_tags: [
        "clothing"
      ],
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "shop.mango.com",
      ore: {
        cost: 'json||||script[type="text/javascript"]:nth-of-type(4)||||ecommerce.detail.products.0.price',
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(4)||||shop.currency'
        ],
        mpn: 'json||||script[type="text/javascript"]:nth-of-type(4)||||ecommerce.detail.products.0.dimension21',
        sku: 'json||||script[type="text/javascript"]:nth-of-type(4)||||ecommerce.detail.products.0.id'
      }
    },
    {
      id: "marksandspencer",
      name: "marksandspencer",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/p/(?<identifier>[\\w+]+)#"
      ],
      base: "marksandspencer.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceSpecification.price'
        ],
        mpn: "json||||#__NEXT_DATA__||||props.pageProps.productDetails.variants.0.skus.0.price.mfPartnumber",
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
      }
    },
    {
      id: "massgenie",
      name: "MassGenie",
      base: "massgenie.com",
      paths: [
        "(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: "substring-after(//strong[contains(text(),'UPC')]//parent::*,':')",
        cost: "//div[@class='btn-buy-now-pdp']//span[1]",
        sku: "//span[@itemprop='sku']",
        title: "//h1[@class='text-20']"
      }
    },
    {
      id: "mediamarkt",
      name: "mediamarkt",
      category_tags: [
        "electronics",
        "appliances"
      ],
      paths: [],
      base: "www.mediamarkt.com.tr",
      ore: {
        availability: [
          "json||||script:nth-of-type(18)||||dimension25",
          "//meta[@itemprop='availability']/@content"
        ],
        barcode: "json||||script:nth-of-type(18)||||ean",
        cost: [
          "json||||script:nth-of-type(18)||||price",
          "//meta[@itemprop='price']/@content"
        ],
        currency: "//meta[@property='gtm-prop-currency-code']/@content",
        model: "//dt[contains(text(), 'Manufacturer Part Number (MPN):')]/following-sibling::dd[1]/text()",
        mpn: [
          "//dt[contains(text(), 'Manufacturer Part Number')]/following-sibling::dd[1]/text()"
        ],
        sku: [
          "//dd/span[contains(@itemprop, 'sku')]/text()"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "meesho",
      name: "meesho",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/p/(?<identifier>\\w+)$"
      ],
      base: "www.meesho.com",
      ore: {
        availability: "json||||#jsonLd||||offers.availability",
        cost: [
          "json||||#jsonLd||||offers.price"
        ],
        currency: [
          "json||||#jsonLd||||offers.shippingDetails.shippingRate.currency"
        ],
        sku: [
          "json||||#jsonLd||||sku"
        ]
      }
    },
    {
      id: "meijer",
      name: "Meijer",
      category_tags: [
        "sells-everything"
      ],
      base: {
        "*-us": "meijer.com"
      },
      paths: [
        "\\/shopping\\/product\\/[^\\/]+\\/(?<identifier>\\d+)",
        "\\/shopping\\/product\\/[^\\/]+\\/(?<identifier>[a-zA-Z0-9]+)",
        "\\/product\\/[^\\/]+\\/(?<identifier>\\d+)",
        "\\/item\\/(?<identifier>\\d+)",
        "\\/p\\/(?<identifier>\\d+)",
        "\\/(?<identifier>\\d{7,})"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: ".product-price, .price-display, [class*='price']",
              at: "afterend"
            }
          ]
        }
      ],
      mine: "verb-miner-function-meijer-mine",
      "brick-and-mortar": "verb-miner-function-meijer-brick-and-mortar",
      scout: {
        path: "https://www.meijer.com/search?q={{query}}",
        items: ".search-result-item, .product-card, [class*='product-item']",
        ore: {
          title: [
            ".product-title",
            ".item-title",
            "h3",
            "h4",
            "[class*='title'] a",
            ".product-name"
          ],
          cost: [
            ".price",
            ".product-price",
            "[class*='price']:not([class*='was']):not([class*='original'])",
            ".cost",
            "[data-testid*='price']"
          ],
          url: [
            ".product-title a||||href",
            ".item-title a||||href",
            "h3 a||||href",
            "h4 a||||href",
            "a[href*='/product/']||||href",
            "a[href*='/shopping/product/']||||href"
          ],
          image: [
            ".product-image img||||src",
            ".item-image img||||src",
            "img[src*='product']||||src",
            "img||||src"
          ],
          availability: [
            ".availability",
            ".stock-status",
            "[class*='stock']",
            "[class*='available']",
            ".in-stock",
            ".out-of-stock"
          ]
        }
      },
      notes: {
        retailer_info: {
          type: "Supercenter chain",
          founded: "1934",
          headquarters: "Grand Rapids, Michigan",
          stores: "250+ locations",
          states: [
            "MI",
            "OH",
            "IN",
            "IL",
            "KY",
            "WI"
          ],
          formats: [
            "Supercenter",
            "Meijer Grocery"
          ],
          services: [
            "Grocery",
            "General Merchandise",
            "Pharmacy",
            "Gas Stations"
          ]
        },
        technical_status: {
          api_endpoints: "Currently returning 404 errors",
          website_status: "Experiencing access denied issues on many pages",
          working_pages: [
            "Store finder",
            "Weekly ad"
          ],
          authentication: {
            primary_key: "BLVQ8-7JJWJ-F6GWD-TQLC7-EVFCQ",
            secondary_key: "key_GdYuTcnduTUtsZd6"
          }
        },
        implementation_notes: {
          tier: "Tier 3 - Complete custom mining",
          fallback_strategy: "HTML scraping with API endpoints when available",
          store_locator: "Brick-and-mortar function with static data fallback",
          search_focus: "Grocery products within supercenter format"
        }
      }
    },
    {
      id: "melonbooks",
      name: "melonbooks",
      category_tags: [
        "books"
      ],
      paths: [
        "\\?product_id=(?<identifier>\\d+)"
      ],
      base: "www.melonbooks.co.jp",
      ore: {
        availability: "//div[contains(@class, 'state')]/span[@class='state-instock']/text()",
        cost: "//span[@class='yen __discount']/text()",
        sku: "//input[@name='product_id']/@value"
      }
    },
    {
      id: "metro",
      name: "metro",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/product/(?<identifier>[a-z0-9\\-]+)"
      ],
      base: "www.metro.de",
      ore: {
        availability: [
          "json||||#product-schema||||offers.availability",
          "//span[contains(@class, 'info__stock')]/text()"
        ],
        cost: [
          "json||||#product-schema||||offers.highPrice",
          "//p[contains(@class, 'volume-price-subtotal__value__price')]/text()"
        ],
        currency: [
          "json||||#product-schema||||offers.priceCurrency"
        ],
        sku: [
          "json||||#product-schema||||sku",
          "//div[@class='product-details-table__col product-details-table__label' and contains(text(), 'Produkt ID')]/following-sibling::div[contains(@class, 'product-details-table__col')]/text()"
        ]
      }
    },
    {
      id: "metrokitchen",
      name: "MetroKitchen",
      category_tags: [
        "home-garden"
      ],
      base: "metrokitchen.com",
      paths: [
        "product\\/(?<identifier>[a-z0-9\\-\\/]+)",
        "/([^/]+)/(?<identifier>[^/]+)/$"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(9)||||product_attributes.upc',
          "//dt[contains(text(), 'UPC:')]/following-sibling::dd[1]",
          "substring-before(substring-after(//div[@id='more_info'],'UPC:'),' ')"
        ],
        brand: "substring-before(//h1[@itemprop='name'], ' ')",
        cost: "substring-after(//div[@id='item-price'],'$')",
        sku: [
          "//dd[@class='productView-info-value' and preceding-sibling::dt[contains(text(), 'SKU')]]/text()",
          "//span[@itemprop='sku']"
        ],
        title: "//h1[@itemprop='name']",
        availability: "//meta[@itemprop='availability']/@content",
        mpn: "//meta[@itemprop='mpn']/@content"
      }
    },
    {
      id: "microcenter",
      name: "Micro Center",
      category_tags: [
        "electronics"
      ],
      base: "microcenter.com",
      paths: [
        "product\\/(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//span[contains(text(), 'UPC:')]/following-sibling::span[@class='item']/text()",
          "(//div[@id='detail-list']//dt[contains(text(),'UPC')]/following-sibling::dd)[1]"
        ],
        brand: [
          "//*[@data-brand]/@data-brand",
          "substring-before(//small[@itemprop='brandlogo']//@alt,' Logo')"
        ],
        cost: [
          "//*[@data-price]/@data-price"
        ],
        mpn: [
          "//strong[contains(text(), 'Mfr Part#')]/following-sibling::text()",
          "(//div[@id='detail-list']//dt[contains(text(),'Mfr Part')]/following-sibling::dd)[1]"
        ],
        title: [
          "//*[@data-name]/@data-name",
          "//div[@id='details']/h1"
        ],
        sku: "substring-after(normalize-space(//button[contains(@class, 'btn-add')]/span[@class='hide-text']), 'SKU ')",
        url: [
          "link[rel='canonical']||||href"
        ]
      }
    },
    {
      id: "microsoft",
      name: "Microsoft",
      category_tags: [
        "electronics"
      ],
      base: "microsoft.com",
      paths: [
        ".*\\/(?<identifier>.+)\\/"
      ],
      pathsComments: [
        "micrsoft has gross URLs that *do* have a product id, but there's no shorter way to use it to access a product",
        "the entire pathname is the only thing that works to pull up a product, no shortcuts found",
        "/en-us/p/surface-mobile-mouse/8r31p7v1vmpc"
      ],
      ore: {
        cost: "normalize-space(//meta[@itemprop='price']/@content)",
        rating: "substring-before(//div[@class='BVRRRatingNormalImage']/img/@alt,'/')",
        ratings: "(//a[@href='#BVRRWidgetID']/span/span[@class='BVRRNumber'])[1]",
        sku: [
          "//input[@type='radio' and @name='sku-selector']/@value",
          "substring-before(substring-after(//meta[@name='keywords']/@content,','),',')"
        ],
        title: "//h1[@id='DynamicHeading_productTitle']",
        availability: [
          "json||||script:nth-of-type(17)||||buyboxStaticStrings.OUT_OF_STOCK",
          "//span[contains(@class, 'out-of-stock-badge')]/text()"
        ]
      }
    },
    {
      id: "mindfactory",
      name: "mindfactory",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/product_info\\.php\\/(?<identifier>[^_]+)_"
      ],
      base: "www.mindfactory.de",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        barcode: "//strong[contains(text(), 'EAN')]//following-sibling::*[not(self::br)][1]//descendant-or-self::text()",
        cost: "//span[@itemprop='price']/@content",
        currency: "//span[@itemprop='pricecurrency']/@content",
        model: "//span[@class='products-model']/text()"
      }
    },
    {
      id: "mobiletechlab",
      name: "mobiletechlab",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "shop.mobiletechlab.ca",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability',
          "//span[@class='product-form__inventory inventory']/text()"
        ],
        cost: [
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku'
        ]
      }
    },
    {
      id: "mwave",
      name: "mwave",
      category_tags: [
        "electronics"
      ],
      paths: [],
      base: "www.mwave.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||Offers.0.Availability',
          "//span[contains(text(), 'In-Stock')]"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||Offers.0.Price',
          "//div[contains(@class, 'divPriceNormal')]/div/text()"
        ],
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||Offers.0.PriceCurrency',
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||MPN',
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||SKU'
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "mx2games",
      name: "mx2games",
      category_tags: [
        "toys-games"
      ],
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      base: "mx2games.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.offers.0.availability',
          "//div[@class='add-to-cart-button']/a[text()='Add to cart']"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.offers.0.priceSpecification.price',
          "//p[contains(@class, 'price')]/span[contains(@class, 'woocommerce-Price-amount')]/bdi/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.offers.0.priceSpecification.priceCurrency',
          "//span[@class='woocommerce-Price-currencySymbol']/text()"
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.sku'
      }
    },
    {
      id: "mydeal",
      name: "mydeal",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      base: "www.mydeal.com.au",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        barcode: "//div[contains(text(), 'GTIN:')]/span/text()",
        currency: "//meta[@itemprop='currency']/@content",
        sku: "//input[@id='productSku']/@value"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "myer",
      name: "myer",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/p/(?<identifier>[\\w-]+)$"
      ],
      base: "www.myer.com.au",
      ore: {
        availability: [
          "json||||#__NEXT_DATA__||||props.initialState.productDetails.product.result.isAvailable",
          "//button[@data-automation='add-to-bag']/div/p[text()='Add to Bag']"
        ],
        barcode: [
          "json||||#__NEXT_DATA__||||props.initialState.productDetails.product.result.variants.0.ean"
        ],
        cost: [
          "json||||#__NEXT_DATA__||||props.initialState.productDetails.productPrice.finalPrice",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//h3[@data-automation='product-price-was']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
        ],
        mpn: [
          "json||||#__NEXT_DATA__||||props.initialState.productDetails.shopTheLook.shopTheLookData.1.mfPartNumber",
          "json||||#__NEXT_DATA__||||props.initialState.productDetails.product.result.mfPartNumber"
        ],
        sku: [
          "//p[contains(@data-automation, 'product-part-number')]/span/text()",
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//p[contains(text(), 'Product code')]/span/text()"
        ],
        model: "json||||#__NEXT_DATA__||||props.initialState.productDetails.shopTheLook.shopTheLookData.1.mfPartNumber"
      }
    },
    {
      id: "mylayby",
      name: "mylayby",
      paths: [
        "\\/(?<identifier>[\\w-]+)$"
      ],
      base: "mylayby.com",
      ore: {
        availability: [
          "json||||script:nth-of-type(6)||||ecommerce.items.0.item_stock_status",
          "//p[contains(@class, 'availability')]/span/text()"
        ],
        barcode: "//meta[@itemprop='gtin12']/@content",
        cost: [
          "json||||script:nth-of-type(6)||||ecommerce.items.0.price",
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          "json||||script:nth-of-type(6)||||ecommerce.items.0.currency",
          "//meta[@property='product:price:currency']/@content"
        ],
        model: "//meta[@itemprop='model']/@content",
        mpn: "//meta[@itemprop='mpn']/@content",
        sku: [
          "//meta[@itemprop='sku']/@content"
        ]
      }
    },
    {
      id: "myotcstore",
      name: "My OTC Store",
      category_tags: [
        "health-pharmacy"
      ],
      base: "myotcstore.com",
      paths: [
        "store\\/p\\/(?<identifier>[A-Za-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(10)||||product_attributes.upc',
          "//div[@class='productUPC']/dd[contains(@class, 'productView-info-value') and not(contains(@class, 'price'))]/text()",
          "//span[@id='lblBullets']"
        ],
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(29)||||Price',
          "//meta[@itemprop='price']/@content",
          "//span[@id='lblPrice']"
        ],
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(29)||||ProductID',
          "substring-before(substring-after(//link[@rel='canonical']/@href,'/p/'),'-')"
        ],
        title: "//h1[@class='ProductDetailsProductName']"
      }
    },
    {
      id: "n11",
      name: "n11",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      base: "www.n11.com",
      ore: {
        availability: [
          'json||||script[type="text/javascript"]:nth-of-type(12)||||detail.items.0.item_stock'
        ],
        barcode: [
          "//input[@id='unificationDetailGtin']/@value"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.lowPrice'
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(12)||||detail.currency'
        ],
        model: "//li[contains(@class, 'unf-prop-list-item')][p[contains(text(), 'Model')]]/p[@class='unf-prop-list-prop']/text()",
        sku: [
          "//input[@id='skuId']/@value"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "netto-online",
      name: "netto-online",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/p-(?<identifier>\\d+)"
      ],
      base: "www.netto-online.de",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//span[contains(@class, 'product-availability__text')]/text()"
        ],
        cost: 'json||||script[type="application/ld+json"]||||offers.price',
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//meta[@itemprop='sku']/@content"
        ]
      }
    },
    {
      id: "newegg",
      name: "Newegg",
      category_tags: [
        "electronics"
      ],
      base: "newegg.com",
      paths: [
        ".*?Item=(?<identifier>[0-9A-Za-z-]+).*",
        ".*Description=(?<identifier>[0-9a-zA-Z-]+).*",
        ".*Item=(?<identifier>[0-9-A-Za-z-]+).*",
        ".*item=(?<identifier>[0-9a-zA-Z-]+).*",
        ".*ItemList=Combo.(?<identifier>[0-9]+).*",
        ".*itemnumber=(?<identifier>[0-9a-zA-Z-]+).*",
        "\\/product\\/product\\.aspx.*[^\\w]item=(?<identifier>\\w+)",
        "\\/p\\/(?<identifier>[0-9a-zA-Z-]+)"
      ],
      ore: {
        availability: [
          "verb-miner-function-newegg-ore-availability",
          'json||||script[type="application/ld+json"][contains(text(), "offers")]||||offers.availability',
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "[data-stock-status]||||data-stock-status",
          '[data-testid*="cart"], [data-testid*="order"], [data-testid*="notify"]',
          ".stock-status, .availability-info > span:first-child",
          '//button[contains(@class, "btn") and (contains(text(), "Add") or contains(text(), "Pre-order") or contains(text(), "Notify"))]',
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.availability'
        ],
        brand: "//div[@id='Specs']//dl/dt[contains(text(),'Brand')]/following-sibling::dd/text()",
        condition: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.itemCondition',
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.itemCondition',
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.itemCondition',
          "*[data-condition]",
          ".product-condition",
          "//div[contains(@class, 'condition')]//text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.price',
          "//ul[contains(@class, 'price')]/li[contains(@class, 'price-current')]",
          "//div[contains(@class, 'product-price')]/ul/li[@class='price-current']/text()",
          "substring(substring-before(substring(substring-after(//script[contains(text(),'http://schema.org/InStock')],'price'),4),','),0,string-length(substring-before(substring(substring-after(//script[contains(text(),'http://schema.org/InStock')],'price'),4),',')))"
        ],
        images: "verb-miner-function-newegg-ore-images",
        model: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||Model',
          "//table[@class='table-horizontal']//tr[th[contains(text(), 'Model')]]/td/text()",
          "//div[@id='Specs']//dl//dt[contains(., 'Part ')]//following-sibling::dd"
        ],
        rating: "substring-before(substring-after((//img[contains(@class,'eggs')])[1]/@class,'eggs r'),' ')",
        ratings: "//span[@itemprop='reviewCount']",
        sku: [
          "//li[contains(@class, 'is-current')]/text()",
          "//li[contains(@class, 'is-current')]/em/text()",
          "substring-after(//link[@rel='canonical']/@href,'/p/')"
        ],
        title: [
          "*[data-autom='productTitle']",
          "normalize-space(//h1[@id='grpDescrip_h'])"
        ],
        mpn: "json||||script:nth-of-type(44)||||ItemDetail.ManufacturerPartsNumber",
        url: "verb-miner-function-newegg-ore-url"
      }
    },
    {
      id: "nexhour",
      name: "nexhour",
      paths: [
        "/products/(?<identifier>[\\w-]+)"
      ],
      base: "www.nexhour.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//div[contains(@class, 'product-price')]/text()"
        ],
        currency: "//div[contains(@class, 'product-price')]/span[@class='price-font']/text()",
        model: "//div[contains(@class, 'tab-row')][div[text()='Model Name']]/div[2]/text()",
        sku: "//div[contains(@class, 'sku')]/span[@id='product-sku']/text()"
      }
    },
    {
      id: "nfm",
      name: "NFM",
      category_tags: [
        "sells-everything"
      ],
      base: "nfm.com",
      paths: [
        "\\/(?<identifier>\\d+)\\.html"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//span[contains(@class, 'success') and contains(text(), 'In Stock')]"
        ],
        barcode: [
          'json||||script[type="application/ld+json"]||||sku'
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//div[@class='sales on-sale clearfix']/strong/span[@class='value sale-price']/text()",
          "//span[@data-id='salePrice']/text()"
        ],
        model: [
          "//span[@class='product-manufacturer-sku-label' and contains(text(), 'Model:')]/following-sibling::span[contains(@class, 'product-manufacturer-sku')]/text()",
          "//span[@class='product-manufacturer-sku-label' and contains(text(), 'Model:')]/following-sibling::span/text()"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//span[@class='product-sku-label']/following-sibling::span/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ],
        mpn: 'json||||script[type="application/ld+json"]||||mpn'
      }
    },
    {
      id: "nike",
      category_tags: [
        "clothing"
      ],
      base: "nike.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[A-Z0-9]+)\\.html",
        "/t/[^/]+/(?<identifier>[^/?]+)"
      ],
      ore: {
        availability: [
          `substring-before(substring-after(//script[@type='application/ld+json'],'availability": "'),'"')`
        ],
        brand: "//a[@data-path='home']/@data-brand",
        cost: "//div[@class='product-price__wrapper css-13hq5b3']/div/text()",
        delivery: "//div[@id='shippingPickup']//text()",
        mpn: [
          "//div[@class='colorway-images-wrapper']//div//input/@data-style-color"
        ],
        title: "//h1[@data-test='product-title']/text()",
        currency: "json||||#__NEXT_DATA__||||props.pageProps.initialState.localization.currency",
        model: 'json||||script[type="application/ld+json"]||||model'
      },
      scout: {
        "path-disabled": "/w?q={{query}}&vst={{query}}",
        items: './/div[contains(@class,"product-card")]',
        ore: {
          cost: ".//*[@data-test='product-price']/text()",
          image: ".//div[contains(@class,'wall-image-loader')]/div/img/@src",
          title: ".//div[@class='product_msg_info']//text()",
          url: ".//div[@class='product-card__body']/figure/a/@href"
        }
      }
    },
    {
      id: "nikonusa",
      name: "Nikon",
      category_tags: [
        "electronics"
      ],
      base: "nikonusa.com",
      paths: [
        "(.+)\\/(?<identifier>.+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin12',
          "substring(substring-after(//script[contains(text(),'gtin12')],'gtin12'),5,12)"
        ],
        cost: [
          "//div[@class='hero-product-price js-product-price']/span[contains(@class, 'price-now')]/text()",
          "normalize-space(//p[@class='product-price'])"
        ],
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(18)||||selectedSKU',
          "//p[contains(@class, 'js-product-number')]/span[@class='value']/text()",
          "substring(substring-after(//script[contains(text(),'gtin12')],'gtin12'),5,12)"
        ],
        title: "//h1[@class='product-name']"
      }
    },
    {
      id: "nojima",
      name: "nojima",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/commodity/1/(?<identifier>\\d+)/"
      ],
      base: "online.nojima.co.jp",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//font[contains(., '発送目安:')]//span[not(@class)]/text()"
        ],
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//span[contains(@itemprop, 'identifier')]/span/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[contains(@class, 'rankingPrice')]/div[contains(@class, 'price-group')]/span[@class='price']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
          "//meta[@itemprop='currency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//input[@name='availableSku']/@value"
        ]
      }
    },
    {
      id: "nordstrom",
      name: "Nordstrom",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "^https?://(?:shop\\.)?nordstrom\\.com/s/\\d+",
        "^https?://(?:www\\.)?nordstrom\\.com/s/\\d+"
      ],
      scout: {
        path: "https://www.nordstrom.com/search?keyword={{query}}",
        items: [
          ".product-card",
          "[data-automation-id='product-tile']",
          ".search-result-item"
        ],
        ore: {
          title: [
            ".product-title a",
            "[data-automation-id='product-title'] a",
            "h3 a"
          ],
          cost: [
            ".price-current",
            "[data-automation-id='product-price']",
            ".price"
          ],
          url: [
            ".product-title a||||href",
            "[data-automation-id='product-title'] a||||href",
            "h3 a||||href"
          ],
          image: [
            ".product-image img||||src",
            "[data-automation-id='product-image'] img||||src"
          ],
          availability: [
            "[data-automation-id='availability-status']",
            ".availability-message"
          ]
        }
      }
    },
    {
      id: "nubie",
      name: "nubie",
      paths: [
        "/products/(?<identifier>[^/]+)"
      ],
      base: "nubie.co.uk",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
        barcode: [
          "json||||script:nth-of-type(55)||||barcode"
        ],
        cost: [
          "//span[contains(@class, 'price-item--sale')]/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(10)||||currency',
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: [
          "json||||script:nth-of-type(55)||||sku",
          "//span[contains(@class, 'sku')]/text()"
        ]
      }
    },
    {
      id: "nvidia",
      category_tags: [
        "electronics"
      ],
      base: "nvidia.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)"
      ],
      ore: {
        title: "//h1//text()"
      },
      scout: {
        path: "https://api.nvidia.partners/edge/product/search?page=2&limit=9&locale=en-us&search={{query}}",
        items: "searchedProducts.productDetails",
        ore: {
          availability: "retailers.0.isAvailable",
          cost: "productPrice",
          image: "imageURL",
          mpn: "retailers.0.productId",
          title: "productTitle",
          url: "retailers.0.purchaseLink"
        }
      }
    },
    {
      id: "office-partner",
      name: "office-partner",
      category_tags: [
        "office-supplies"
      ],
      paths: [],
      base: "www.office-partner.de",
      ore: {
        availability: [
          "json||||script:nth-of-type(6)||||ecommerce.detail.products.isAvailable",
          "//link[@itemprop='availability']/@href"
        ],
        barcode: "//meta[@itemprop='productID']/@content",
        cost: [
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          "json||||script:nth-of-type(6)||||ecommerce.currencyCode",
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        model: [
          "json||||script:nth-of-type(6)||||ecommerce.detail.products.supplierSku"
        ],
        mpn: [
          "json||||script:nth-of-type(6)||||ecommerce.detail.products.supplierSku"
        ],
        sku: [
          "json||||script:nth-of-type(6)||||ecommerce.detail.products.id",
          "//span[@class='entry--content' and @itemprop='sku']/text()"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "officedepot",
      category_tags: [
        "office-supplies"
      ],
      base: "officedepot.com",
      paths: [
        "/a/products/(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//meta[@itemprop='price']/@content",
          "//span[@class='od-graphql-price-big-price']/text()"
        ],
        delivery: "//div[@class='od-container od-container-lg']//text()",
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn',
          "//td[contains(text(), 'Manufacturer #')]/following-sibling::td/text()"
        ],
        title: "//h1[@itemprop='name']/text()",
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//meta[@itemprop='sku']/@content",
          'json||||script[type="text/javascript"]:nth-of-type(47)||||ecomm_prodid'
        ]
      },
      scout: {
        path: "/c/search?q={{query}}&sts=ma",
        items: './/div[contains(@class,"sku_item")]',
        ore: {
          cost: './/span[@class="price_column right"]/text()',
          image: './/div[@class="photo_no_QV flcl"]/a/img/@src',
          title: './/div[@class="desc_text"]/a/text()',
          url: './/div[@class="desc_text"]/a/@href'
        }
      }
    },
    {
      id: "officeworks",
      name: "officeworks",
      category_tags: [
        "office-supplies"
      ],
      paths: [
        "/p/(?<identifier>[\\w-]+)$"
      ],
      base: "www.officeworks.com.au",
      ore: {
        availability: [
          "//meta[@itemprop='availability']/@content"
        ],
        barcode: [
          "json||||script:nth-of-type(13)||||owProduct.product.gtin",
          "//meta[@itemprop='gtin13']/@content"
        ],
        currency: "//meta[@itemprop='priceCurrency']/@content",
        model: [
          "//meta[@itemprop='productID']/@content"
        ],
        mpn: [
          "//dd[contains(@class, 'SpecificationsTab__SpecValue') and preceding-sibling::dt[contains(text(), 'Part Number')]]/text()"
        ],
        sku: [
          "//meta[@itemprop='sku']/@content"
        ]
      }
    },
    {
      id: "olay",
      name: "Olay",
      category_tags: [
        "beauty"
      ],
      base: "olay.com",
      paths: [
        "(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(9)||||product_attributes.upc',
          "substring(substring-after(substring-after(//div[@id='pagemainwrapper']//form//script/following-sibling::*,'variant_sku'),'sku'),4,12)"
        ],
        cost: [
          "//span[@class='price price--withoutTax']/text()",
          "normalize-space(//span[@class='dtc-price'])"
        ],
        sku: [
          "//input[@name='sku']/@value",
          "substring(substring-after(substring-after(//div[@id='pagemainwrapper']//form//script/following-sibling::*,'variant_sku'),'sku'),4,12)"
        ],
        title: "normalize-space(//h1[@itemprop='name'])",
        availability: "//meta[@property='og:availability']/@content",
        mpn: "//input[@type='hidden'][@name='product_id']/@value"
      }
    },
    {
      id: "oliverbonas",
      name: "oliverbonas",
      category_tags: [
        "clothing"
      ],
      paths: [
        "/gift/[^/]+-(?<identifier>\\d+)"
      ],
      base: "oliverbonas.com",
      ore: {
        availability: "//meta[@property='og:availability']/@content",
        cost: "//meta[@property='og:price:amount']/@content",
        currency: "//meta[@property='og:price:currency']/@content"
      }
    },
    {
      id: "onbuy",
      name: "onbuy",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/p/(?<identifier>[\\w-]+)~"
      ],
      base: "onbuy.com",
      ore: {
        availability: "//p[@class='stock']/text()",
        cost: "//div[contains(@class, 'price')]/text()",
        sku: "//input[@id='product_id']/@value"
      }
    },
    {
      id: "onecall",
      name: "OneCall",
      category_tags: [
        "electronics"
      ],
      base: "onecall.com",
      paths: [
        "product\\/(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: "//th[contains(., 'UPC')]/following-sibling::td",
        brand: "substring-before(//h1,' ')",
        cost: "//span[@itemprop='price']",
        mpn: "substring-before(substring-after(//div[@itemprop='name'], '('), ')')",
        sku: "//th[text()='OID']/following-sibling::td",
        title: "//div[@itemprop='name']"
      }
    },
    {
      id: "onepod",
      name: "onepod",
      paths: [
        "/produkt/(?<identifier>[^/]+)/"
      ],
      base: "onepod.de",
      ore: {
        availability: [
          "json||||.rank-math-schema||||@graph.5.offers.availability",
          "//meta[@property='product:availability']/@content"
        ],
        barcode: "substring-after(//li[contains(text(), 'EAN:')]/text(), 'EAN:')",
        cost: [
          "json||||.rank-math-schema||||@graph.5.offers.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||.rank-math-schema||||@graph.5.offers.priceCurrency",
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: "//li[contains(text(), 'Herstellernummer')]/strong/text()"
      }
    },
    {
      id: "opentip",
      name: "Opentip",
      category_tags: [
        "office-supplies"
      ],
      base: "opentip.com",
      paths: [
        "products_id=(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//span[@id='product_upc']/text()",
          "substring-after(//meta[@itemprop='productID']/@content,'upc:')"
        ],
        brand: "//font[@color='#0066cc']",
        cost: [
          "substring-after(//span[contains(@id, 'disp_one')]/text(), '= ')",
          "//span[@itemprop='price']"
        ],
        mpn: [
          "//td[@class='tableHeading' and contains(.,'Model')]/following-sibling::td/span/text()"
        ],
        sku: [
          "//input[@name='productId_history']/@value"
        ],
        title: "//h1",
        model: "//span[@id='product_model']/text()"
      }
    },
    {
      id: "opticsplanet",
      category_tags: [
        "sports-outdoors"
      ],
      base: "opticsplanet.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)\\.html",
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      ore: {
        barcode: [
          "//span[contains(text(), 'UPC:')]/following-sibling::text()"
        ],
        cost: [
          "//meta[@property='product:price:amount']/@content",
          "//span[@class='Id3qni']//text()"
        ],
        delivery: "//div[@class='yCTQYI']//text()",
        mpn: [
          "//p[contains(span/text(), 'MPN:')]/text()"
        ],
        title: ".//div[@id='page-header-text']/h1/text()",
        sku: "substring-after(//p[contains(@class, 'nBUOJt') and contains(., 'Code:')], 'Code: ')"
      },
      scout: {
        path: "/s/{{query}}",
        items: './/div[@class="Search Results"]',
        ore: {
          cost: './/span[@class="variant-price-dollars"]/text()',
          image: './/img[@class="grid__image_default"]/@src',
          title: './/span[@class="grid__text"]//text()',
          url: './/div[@class="Search Results"]/a/@href'
        }
      }
    },
    {
      id: "otto-office",
      name: "otto-office",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      base: "www.otto-office.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//div[contains(@class, 'info-delivery-time')]/a/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]||||gtin13',
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ],
        mpn: "//td[contains(., 'Hersteller-Artikelnummer')]/following-sibling::td/text()",
        sku: [
          'json||||script[type="application/ld+json"]||||sku'
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "ovantica",
      name: "ovantica",
      paths: [
        "/([^/]+?)/(?<identifier>[\\w-]+)$"
      ],
      base: "ovantica.com",
      ore: {
        availability: [
          "//button[contains(@class, 'action tocart')]/span/text()"
        ],
        cost: [
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="text/x-magento-init"]:nth-of-type(20)||||*.Magento_Catalog/js/product/view/provider.data.currency',
          "//meta[@property='product:price:currency']/@content"
        ],
        model: "//tr[td[contains(text(), 'Model Name')]]/td/ul/li/text()",
        sku: [
          "//input[@name='product']/@value"
        ]
      }
    },
    {
      id: "overstock",
      name: "Overstock",
      category_tags: [
        "home-garden"
      ],
      base: "overstock.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)\\product.html",
        ".*\\/(?<identifier>[0-9]+)\\/"
      ],
      pathsComments: [
        "/Sports-Toys/LEGO-Architecture-Statue-of-Liberty-21042-Building-Kit-1685-Pieces/31497365/product.html",
        "can be reformed to just: /31497365/product.html which redirects to long form"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        brand: [
          "//div[@data-testid='brand-info']/a/text()",
          "substring-after(//div[@data-cy='brand-name'],'by')"
        ],
        cost: [
          "//div[@data-test='current-price']/span[2]/text()",
          "substring-after(//div[@data-cy='product-price-display'],'$')"
        ],
        delivery: "//section[@data-testid='deliveryEstimates']//text()",
        mpn: [
          "//div[contains(text(),'Model Number')]/following-sibling::*"
        ],
        rating: "translate((//span[@itemprop='ratingValue'] | //a[@id='writeReviewLink']),'Write a review','0')",
        ratings: "translate((//span[@itemprop='reviewCount'] | //a[@id='writeReviewLink']),'Write a review','0')",
        sku: "substring(substring-after(//script[contains(text(),'selectedOption')],'selectedOption'),4,8)",
        title: [
          "//h1[@data-test='product-title']//text()",
          "//h3[@data-cy='product-title']"
        ]
      },
      scout: {
        path: "https://www.overstock.com/{{query}},/k,/results.html?page=2&format=fusion&client_id=sn_pag_desktop",
        items: "products",
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          availability: "availability",
          barcode: "productUPC",
          cost: "clubORewards.rewards",
          image: "urls.image",
          mpn: "sku",
          title: "name",
          url: "urls.productPage"
        }
      }
    },
    {
      id: "parkem",
      name: "parkem",
      category_tags: [
        "automotive"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "parkem.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability'
        ],
        barcode: "json||||#quote_product_variants||||barcode",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[contains(@class, 'price__current')]/span[@class='money']/text()"
        ],
        currency: 'json||||script[type="application/json"]:nth-of-type(19)||||currency',
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
        ],
        sku: [
          "json||||#subscribe-it-helper||||sku",
          "//span[@data-product-sku]/text()"
        ]
      }
    },
    {
      id: "parts-express",
      name: "Parts Express",
      category_tags: [
        "electronics"
      ],
      base: "parts-express.com",
      paths: [
        "\\/(?<identifier>[A-Z0-9]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//td[contains(text(), 'UPC')]/following-sibling::td/text()",
          "substring(substring-after(//div[@class='ProducDetailsNote'],'UPC'),1,12)"
        ],
        brand: "//span[@id='ctl00_ctl00_MainContent_uxProduct_BrandLabel']/following-sibling::div",
        cost: [
          "//div[contains(@class, 'product-details-price')]//span[contains(@class, 'product-views-yourprice-tag')]/following-sibling::span/text()",
          "normalize-space(//span[@id='ctl00_ctl00_MainContent_uxProduct_lblBestPrice'])"
        ],
        mpn: [
          "//span[contains(@class, 'product-line-model-label') and contains(text(), 'Part #')]/following-sibling::span[@class='product-line-model-value']/text()",
          "//span[@id='ctl00_ctl00_MainContent_uxProduct_lblModel']"
        ],
        title: "//span[@itemprop='name']",
        availability: "//span[contains(@class, 'product-line-stock-msg-in-text')]/text()",
        sku: "//span[@itemprop='mpn']/text()"
      }
    },
    {
      id: "partsgeek",
      name: "partsgeek",
      category_tags: [
        "automotive"
      ],
      base: "partsgeek.com",
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      ore: {
        availability: "//div[contains(@class, 'product-stock')]/text()",
        cost: [
          "json||||script:nth-of-type(14)||||ecommerce2.items.0.price",
          "//span[contains(@class, 'product-price')]/text()"
        ],
        currency: [
          "json||||script:nth-of-type(14)||||ecommerce2.items.0.currency"
        ],
        mpn: "//span[contains(text(), 'Part Number:')]/following-sibling::text()",
        sku: "//input[@name='alt_sku']/@value"
      }
    },
    {
      id: "patmcgrath",
      name: "patmcgrath",
      category_tags: [
        "beauty"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "www.patmcgrath.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price'
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
      }
    },
    {
      id: "pazarama",
      name: "pazarama",
      category_tags: [
        "clothing"
      ],
      paths: [],
      base: "www.pazarama.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//div[contains(@class, 'min-w-[5rem]')]/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin14',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.Price',
          "//p[contains(@class, 'text-xl')]/span/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "pcrichardandson",
      name: "P.C. Richard & Son",
      category_tags: [
        "electronics",
        "appliances"
      ],
      base: "pcrichard.com",
      paths: [
        "(?<identifier>.+)\\.pcrp",
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: "//th[contains(text(),'UPC')]/following-sibling::*",
        brand: "substring-before(//h1[@class='title'],' ')",
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(7)||||ecommerce.detail.products.0.price',
          "//div[@class='price']/span[@class='salePriceClass']/span[@class='sales']/span/span/text()",
          "//span[@class='value']/span/text()",
          "concat(//span[@class='price-value big gray'],//span[@class='price-value gray big'])"
        ],
        mpn: [
          "//span[contains(@class, 'mpn-number')]/span[@class='product-id']/text()"
        ],
        title: "//h1[@class='title']",
        model: [
          "//span[@class='model-number']/span[@class='product-id']/text()",
          "substring-after(//div[@class='model-info'],'MODEL:')",
          "//div[contains(@class, 'product-number')]/span[@class='model-number']/span[@class='product-id']/text()"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku',
          "//span[@class='product-id']/text()"
        ],
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//button[contains(@class, 'add-to-cart')]/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(7)||||ecommerce.currencyCode',
          "//meta[@property='og:product:price:currency']/@content"
        ]
      }
    },
    {
      id: "perfumesclub",
      name: "perfumesclub",
      category_tags: [
        "beauty"
      ],
      base: "www.perfumesclub.us",
      paths: [
        "/p_(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//button[contains(text(), 'Add to cart')]"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin13',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          "//div[contains(@class, 'contPrecioNuevo')]/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(18)||||MonedaId',
          "//span[@class='newPriceND newPriceNDLines']/strong/text()"
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
      }
    },
    {
      id: "petcaresupplies",
      category_tags: [
        "pet-supplies"
      ],
      base: "petcaresupplies.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[A-Z0-9]+)\\.aspx",
        "\\/(?<identifier>[\\w-]+)\\.aspx$"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//div[@class='freeShippingText']//text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//span[@id='PackSellingPrice']//text()"
        ],
        delivery: "//a[@id='fs-popup-trigger']//text()",
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn'
        ],
        title: "//div[@class='product_PriceTop']/h1/span/text()",
        currency: 'json||||script[type="application/ld+json"]||||offers.priceCurrency'
      },
      scout: {
        path: "/product_search.aspx?search={{query}}",
        items: './/div[@class="HmPg_TopProDiv NewSearchProductBox"]/div',
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: './/div[@class="Home_ProPrice_Left"]//text()',
          image: './/div[@class="Home_Proimg"]//img/@src',
          title: './/div[@class="Home_ProName"]//text()',
          url: './/div[@class="Home_ProName"]/a/@href'
        }
      }
    },
    {
      id: "petco",
      name: "Petco",
      category_tags: [
        "pet-supplies"
      ],
      base: "petco.com",
      paths: [
        "\\/product\\/(?<identifier>[0-9a-z\\-\\/]+)"
      ],
      ore: {
        availability: '//h3[contains(text(),"DaystoShip")]/following::p[1]//text()',
        brand: '//*[contains(@class,"hcZiE")]//text()',
        cost: [
          '//*[contains(@class,"PriceRowContainer")]//text()',
          "//input[@name='offerPriceString']/@value",
          "//span[@class='product-price-normal']",
          "//span[@class='product-price-promo']"
        ],
        rating: "substring-before((//div[@class='BVRRRatingNormalImage']//img)[1]/@alt,' ')",
        ratings: "(//span[@class='BVRRNumber'])[1]",
        sku: [
          '//h3[contains(text(),"SKU")]/following::p[1]//text()',
          "substring-after(//div[@class='product-sku'],'SKU:')"
        ],
        title: [
          '//*[contains(@class,"ProductNameContainer")]//text()',
          "//h1[@itemprop='name']"
        ]
      },
      scout: {
        "path-disabled": "/shop/SearchDisplaycategoryId=&storeId=10151&catalogId=10051&langId=-1&sType=SimpleSearch&resultCatEntryType=2&showResultsPage=true&searchSource=Q&pageView=&beginIndex=0&pageSize=48&fromPageValue=search&searchKeyword=&searcTerm={{query}}",
        items: '//*[contains(@class,"ProductCard")]',
        ore: {
          cost: './/*[contains(text(),"$")]/text()',
          image: './/img[contains(@src,"image/upload")]/@src',
          title: ".//@data-cnstrc-item-name",
          url: ".//@href"
        }
      }
    },
    {
      id: "petmountain",
      name: "Pet Mountain",
      category_tags: [
        "pet-supplies"
      ],
      base: "petmountain.com",
      paths: [
        "\\/product\\/(?<identifier>[a-z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]||||offers.0.gtin12',
          "//div[contains(@class, 'barcode')]/span/text()",
          "//span[@itemprop='productID']"
        ],
        brand: "//div[@id='brand_name']",
        cost: [
          'json||||script[type="application/ld+json"]||||offers.0.price',
          "div.pricing.g > div > span.val",
          "//div[@class='price']"
        ],
        mpn: [
          "//div[contains(@class, 'mpn')]/span/text()",
          "//span[@itemprop='model']"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||offers.0.sku',
          "//div[@class='sku']/span/text()",
          "//div[@class='sku']/text()"
        ],
        title: "concat(//div[@id='brand_name'],//div[@class='set2']/h2)",
        availability: [
          'json||||script[type="application/ld+json"]||||offers.0.availability',
          "//div[contains(@class, 'input-group-text')]/span/b/text()"
        ],
        currency: 'json||||script[type="application/ld+json"]||||offers.0.priceCurrency'
      }
    },
    {
      id: "petplanet",
      name: "petplanet",
      category_tags: [
        "pet-supplies"
      ],
      paths: [
        "\\/p(?<identifier>\\d+)\\/.*\\.aspx"
      ],
      base: "petplanet.co.uk",
      ore: {
        availability: "//span[contains(text(), 'In stock')]",
        cost: "//span[@class='price']/text()"
      }
    },
    {
      id: "petsathome",
      name: "petsathome",
      category_tags: [
        "pet-supplies"
      ],
      paths: [
        "/en/pets/(?<identifier>[\\w-]+)$"
      ],
      base: "petsathome.com",
      ore: {
        model: "//input[@name='cncProductPartNumber']/@value",
        mpn: "//span[@class='pdp-accordion__content-partNumber']/b/text()"
      }
    },
    {
      id: "pgatoursuperstore",
      name: "pgatoursuperstore",
      category_tags: [
        "sports-outdoors"
      ],
      base: "www.pgatoursuperstore.com",
      paths: [],
      ore: {
        availability: "//span[contains(@class, 'in-stock-msg')]/text()",
        barcode: "//meta[@itemprop='gtin12']/@content",
        cost: [
          "json||||script:nth-of-type(30)||||ecommerce.detail.products.0.price",
          "//span[@id='display-price']/text()"
        ],
        currency: "//meta[@itemprop='priceCurrency']/@content",
        model: "//div[contains(@class, 'product-number') and contains(text(), 'Style Number:')]//span/text()",
        sku: [
          "//span[@itemprop='sku']/text()"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "phoneinc",
      name: "phoneinc",
      category_tags: [
        "electronics"
      ],
      paths: [],
      base: "phoneinc.com.au",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        cost: [
          "//span[@class='actual-price']/text()"
        ],
        currency: "//meta[@itemprop='priceCurrency']/@content",
        model: "substring-after(//li[contains(text(), 'Model:')]/text(), 'Model:')",
        sku: [
          "json||||script:nth-of-type(49)||||product.variants.0.sku"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "photospecialist",
      name: "photospecialist",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/([^\\/]+?)\\?srsltid=(?<identifier>[^&]+)"
      ],
      base: "photospecialist.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//span[contains(text(), 'In stock')]"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price'
        ],
        currency: 'json||||script[type="application/ld+json"]||||offers.priceCurrency',
        sku: 'json||||script[type="application/ld+json"]||||offers.sku'
      }
    },
    {
      id: "planettv",
      name: "planettv",
      category_tags: [
        "electronics"
      ],
      base: "planettv.com",
      paths: [],
      ore: {
        availability: 'json||||script[type="application/ld+json"]||||offers.availability',
        barcode: "//td[b='UPC']/following-sibling::td/text()",
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ],
        model: [
          "//span[contains(@class, 'model-number')]/text()"
        ],
        mpn: 'json||||script[type="application/ld+json"]||||mpn'
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "play-asia",
      name: "Play-Asia",
      category_tags: [
        "toys-games"
      ],
      base: "play-asia.com",
      paths: [
        "\\/(?<identifier>[a-z0-9\\-\\/]+)"
      ],
      scout: null,
      ore: {
        barcode: "//td[contains(., 'Item Code')]/following-sibling::td",
        cost: "//span[@itemprop='price']",
        sku: "//td[contains(., 'Item Code')]/following-sibling::td",
        title: "//h1[@itemprop='name']"
      }
    },
    {
      id: "playox",
      name: "playox",
      paths: [
        "\\/(?<identifier>[\\w-]+)$"
      ],
      base: "www.playox.de",
      ore: {
        availability: [
          "json||||script:nth-of-type(8)||||ecommerce.detail.products.isAvailable",
          "//link[@itemprop='availability']/@href"
        ],
        barcode: [
          "//div[contains(@class, 'hersteller--ean_wrapper')]//span[contains(@class, 'entry--label') and contains(text(), 'EAN:')]/following-sibling::span[contains(@class, 'entry--content')]"
        ],
        cost: [
          "json||||script:nth-of-type(8)||||ecommerce.detail.products.price",
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          "json||||script:nth-of-type(8)||||ecommerce.currencyCode",
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        model: [
          "//div[contains(@class, 'hersteller--number')]/span[@class='entry--content']/text()"
        ],
        mpn: [
          "//span[contains(text(), 'Herstellernr.:')]/following-sibling::span/text()"
        ],
        sku: [
          "json||||script:nth-of-type(8)||||ecommerce.detail.products.id",
          "//span[@class='entry--content' and @itemprop='sku']/text()"
        ]
      }
    },
    {
      id: "playstationdirect",
      name: "Playstation",
      category_tags: [
        "toys-games"
      ],
      base: "direct.playstation.com",
      paths: [
        "\\/(.+)\\/(?<identifier>[a-z0-9\\-\\/]+)"
      ],
      scout: null,
      ore: {
        barcode: "//meta[@name='upc']/@content",
        cost: "//div[@class='productHero-info__price']//span[@class='product-price js-actual-price-whole large']",
        sku: "//meta[@name='upc']/@content",
        title: "//meta[@name='title']/@content"
      }
    },
    {
      id: "playstationstore",
      name: "Playstation Store",
      category_tags: [
        "toys-games"
      ],
      base: "store.playstation.com",
      paths: [
        "\\/(.+)\\/product\\/(?<identifier>[A-Z0-9\\-]+)"
      ],
      scout: null,
      ore: {
        barcode: "//meta[@name='upc']/@content",
        cost: "//div[@class='pdp-cta pdp-visible']//div[@class='psw-l-anchor psw-l-stack-left']//label[@class='psw-label psw-l-inline psw-l-line-left psw-fade-in psw-l-anchor psw-bg-0 psw-fill-x']//div[@class='psw-l-anchor psw-l-stack-left psw-l-space-y-l psw-fill-x']//span[@class='psw-fill-x psw-l-line-wrap psw-l-inline']//span[@class='psw-l-space-x-s psw-l-line-left']//span[@class='psw-l-space-x-s psw-l-line-left']//span[@class='psw-h3']",
        sku: "//meta[@name='upc']/@content",
        title: "//meta[@name='title']/@content"
      }
    },
    {
      id: "poshmark",
      name: "poshmark",
      category_tags: [
        "clothing"
      ],
      paths: [
        "/listing/[^-]+-(?<identifier>[a-zA-Z0-9]+)"
      ],
      base: "poshmark.ca",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//meta[@property='product:retailer_item_id']/@content"
        ]
      }
    },
    {
      id: "priceline",
      name: "priceline",
      category_tags: [
        "beauty",
        "health-pharmacy"
      ],
      paths: [
        "/product/(?<identifier>\\d+)/"
      ],
      base: "www.priceline.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//div[contains(text(), 'SKU:')]/text()"
        ]
      }
    },
    {
      id: "pricewhack",
      name: "pricewhack",
      paths: [
        "\\?currency=USD&variant=(?<identifier>\\d+)"
      ],
      base: "pricewhack.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(6)||||offers.availability',
          "//span[@class='atc-button--text']/text()"
        ],
        barcode: 'json||||script[type="application/json"]:nth-of-type(5)||||product.variants.0.barcode',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(6)||||offers.price',
          "//div[contains(@class, 'product--price')]/div[@class='price--main']/span[@class='money']/text()"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@data-currency='USD']/@data-currency"
        ],
        model: "//th[contains(text(), 'Model #')]/following-sibling::th/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(6)||||sku'
        ]
      }
    },
    {
      id: "prioritytire",
      name: "prioritytire",
      category_tags: [
        "automotive"
      ],
      base: "www.prioritytire.com",
      paths: [],
      ore: {
        availability: [
          'json||||script[type="text/javascript"]:nth-of-type(14)||||product_attributes.stock_message',
          "//meta[contains(@itemprop, 'availability')]/@content"
        ],
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(14)||||product_attributes.upc',
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(14)||||product_attributes.price.sale_price_without_tax.formatted',
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(14)||||product_attributes.price.saved.currency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        model: "//input[@name='Model']/@value",
        sku: "json||||script:nth-of-type(110)||||SKU"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "provantage",
      name: "Provantage",
      category_tags: [
        "office-supplies"
      ],
      base: "provantage.com",
      paths: [
        "\\/(?<identifier>.+)\\.htm"
      ],
      scout: null,
      ore: {
        barcode: "normalize-space(substring-after(//p[contains(text(), 'UPC')],':'))",
        brand: "//td[@id='Gmanuf']/following-sibling::*",
        cost: "//span[contains(text(), 'Only')]/following-sibling::*",
        mpn: "normalize-space(substring-after(//p[contains(text(), 'Manufacturer')],'#'))",
        sku: "substring-after(//p[@id='Gsku'],':')",
        title: "//h1"
      }
    },
    {
      id: "pttavm",
      name: "pttavm",
      category_tags: [
        "electronics"
      ],
      paths: [],
      base: "www.pttavm.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]||||offers.availability',
        cost: 'json||||script[type="application/ld+json"]||||offers.price',
        currency: 'json||||script[type="application/ld+json"]||||offers.priceCurrency',
        brand: "//td[contains(text(), 'Marka')]/following-sibling::td/text()",
        sku: 'json||||script[type="application/ld+json"]||||productID'
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "publix",
      name: "Publix Super Markets",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "publix.com"
      },
      paths: [
        "\\/pd\\/(?<identifier>[^\\/]+)$",
        "\\/pd\\/[^\\/]+\\/(?<identifier>[^\\/]+)$",
        "\\/product\\/(?<identifier>[^\\/]+)$",
        "\\/p\\/(?<identifier>[^\\/]+)$"
      ],
      "skip-normal-mining": true,
      mine: "verb-miner-function-publix-mine",
      scout: {
        path: "https://www.publix.com/shop-online/search?searchTerm={{query}}",
        before: "verb-miner-function-publix-scout-before",
        items: ".search-result-item",
        ore: {
          title: ".product-title",
          cost: ".price-display",
          url: ".product-link||||href",
          image: ".product-image img||||src",
          availability: ".stock-status"
        }
      }
    },
    {
      id: "pureformulas",
      name: "PureFormulas",
      category_tags: [
        "health-pharmacy"
      ],
      base: "pureformulas.com",
      paths: [
        "\\/(?<identifier>.+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          "substring-after(//li[contains(text(), 'UPC')]/text(), 'UPC # ')",
          "substring-after(//div[@id='descriptionTab']//li[contains(., 'UPC #')], '#')"
        ],
        brand: "//div[@itemprop='brand']//a",
        cost: [
          "//span[@id='pdpPrice']/text()",
          "(//span[@itemprop='price'])[last()]"
        ],
        mpn: [
          "substring-after(//li[contains(text(), 'MFG #')]/text(), 'MFG # ')",
          "substring-after(//div[@id='descriptionTab']//li[contains(., 'MFG #')], '#')"
        ],
        sku: [
          "//meta[@itemprop='sku']/@content",
          "substring-after(//td[contains(., 'Item Number: ')], ': ')"
        ],
        title: "//h1[@itemprop='name']",
        availability: "//span[@class='stockLevel']/text()"
      }
    },
    {
      id: "qoo10",
      name: "qoo10",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\?goodscode=(?<identifier>\\d+)"
      ],
      base: "www.qoo10.jp",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        mpn: "//td[@itemprop='mpn']/text()",
        cost: "//dd[contains(@class, 'ratenew')]/preceding-sibling::dd[1]",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: 'json||||script[type="text/javascript"]:nth-of-type(30)||||item'
      }
    },
    {
      id: "queencityonline",
      name: "Queen City",
      base: "queencityonline.com",
      paths: [
        "\\/(?<identifier>[\\w+]+)\\/$"
      ],
      ore: {
        availability: "//a[contains(@title, 'In Stock') or contains(text(), 'In-Stock')]",
        barcode: "//td[b='UPC']/following-sibling::td/text()",
        model: [
          "//span[@class='qc-pdp-info-header qc-bold' and contains(text(), 'Model#')]/following-sibling::span/text()",
          "//span[contains(@class, 'qc-pdp-info-header') and text()='Model#']/following-sibling::span[contains(@class, 'qc-pdp-sku')]/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//span[@class='qc-pdp-price qc-pdp-price-large qc-bold qc-iblock']/text()"
        ]
      }
    },
    {
      id: "quill",
      name: "quill",
      category_tags: [
        "office-supplies"
      ],
      base: "www.quill.com",
      paths: [
        "\\/item\\/.*\\/(?<identifier>[^\\/\\?\\&]+)",
        "\\/cbs\\/.*\\/(?<identifier>[^\\/\\?\\&]+)"
      ],
      ore: {
        cost: ".skuPage .price-size",
        model: "substring-after(//div[@class='mb-md-0 ml-md-2 d-none d-sm-flex mb-2']/text(), 'Model #:')",
        sku: [
          "//img[contains(@class, 'SkuPageMainImg2')]/@data-sku"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "rackroomshoes",
      category_tags: [
        "clothing"
      ],
      base: "rackroomshoes.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)\\.html",
        "/p/(?<identifier>[^/]+)/"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//div[@class='detail-sale-price detail-price ']//text()"
        ],
        delivery: "//div[@class='freeshippingQualifier']//text()",
        title: "//div[@class='product-title']//text()",
        barcode: [
          "//input[@id='parentproduct']/@value"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "substring-after(//div[contains(@class, 'product_code')]/text(), 'SKU #: ')"
        ],
        currency: 'json||||script[type="application/ld+json"]||||offers.priceCurrency'
      },
      scout: {
        path: "/search?text={{query}}",
        items: './/div[@class="product-list"]/a',
        ore: {
          cost: './/div[@class="price "]/text()',
          image: './/div[@class="product-box text-center"]//img/@src',
          title: './/h4[@class="product-name"]/text()',
          url: "./@href"
        }
      }
    },
    {
      id: "rakuten",
      name: "Rakuten",
      category_tags: [
        "sells-everything"
      ],
      base: {
        "*-us": "rakuten.com",
        "*-jp": "item.rakuten.co.jp"
      },
      paths: [
        "\\/shop\\/a4c\\/product\\/(?<identifier>[A-Z0-9]+)\\/",
        "\\/(?<identifier>[^\\/]+)\\/?\\?scid",
        "/([^/]+)/(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          "json||||#item-page-app-data||||api.data.itemInfoSku.purchaseInfo.variantMappedInventories.0.quantity",
          "//meta[@itemprop='availability']/@content"
        ],
        barcode: [
          "json||||#item-page-app-data||||api.data.itemInfoSku.articleNumber.value",
          "//meta[@itemprop='gtin13']/@content",
          "//th[contains(text(),'UPC')]/following-sibling::*",
          "//th[contains(text(), 'ISBN')]/following-sibling::td",
          "//th[contains(text(), 'EAN')]/following-sibling::td"
        ],
        brand: "//span[@itemprop='brand']",
        cost: [
          "json||||#item-page-app-data||||api.data.itemInfoSku.purchaseInfo.purchaseBySellType.normalPurchase.preTaxPrice",
          "//meta[@itemprop='price']/@content"
        ],
        costShipping: "substring-before(substring-after(//div[@class='r-product-shipping-info'],'Shipping Fee:'),'+')",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        mpn: [
          "//th[contains(text(),'MPN')]/following-sibling::*"
        ],
        rating: "//span[@id='AuthorArtistTitle_reviewerRating']/meta/@content",
        ratings: "//span[@itemprop='reviewCount']",
        sku: [
          "json||||#item-page-app-data||||api.data.itemInfoSku.pcFields.itemNumber",
          "substring(//div[@data-bv-show='reviews']/@data-bv-productid,0,25)"
        ],
        title: "//h1"
      }
    },
    {
      id: "realtruck",
      name: "realtruck",
      category_tags: [
        "automotive"
      ],
      base: "realtruck.com",
      paths: [
        "/p/(?<identifier>[^/]+)/"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
          "//span[contains(text(), '$')]/text()"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ]
      }
    },
    {
      id: "rebelsport",
      name: "rebelsport",
      category_tags: [
        "sports-outdoors"
      ],
      paths: [
        "/p/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "www.rebelsport.com.au",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(33)||||ecommerce.detail.products.0.price',
          "//meta[@itemprop='price']/@content"
        ],
        currency: "//meta[@itemprop='priceCurrency']/@content",
        mpn: "substring-after(//div[contains(@class, 'product-number fine-print')]/span[@itemprop='productID']/text(), ': ')",
        sku: 'json||||script[type="text/javascript"]:nth-of-type(33)||||ecommerce.detail.products.0.id'
      }
    },
    {
      id: "rei",
      category_tags: [
        "sports-outdoors",
        "clothing"
      ],
      paths: [
        "www.rei.com/product/",
        "www.rei.com/search"
      ],
      scout: {
        path: "https://www.rei.com/search?q={{query}}",
        items: "li[data-cnstrc-item-id]",
        ore: {
          title: "a:contains(text())",
          cost: [
            '[data-ui="sale-price"]',
            '[data-ui="full-price"]'
          ],
          url: "a||||href",
          image: "img||||src",
          availability: `if([data-ui="sale-price"]:exists() || [data-ui="full-price"]:exists(), 'In Stock', 'Out of Stock')`,
          brand: "[data-cnstrc-item-name]||||data-cnstrc-item-name",
          sku: "[data-cnstrc-item-id]||||data-cnstrc-item-id"
        }
      },
      ore: {
        title: [
          "h1",
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||name'
        ],
        cost: [
          ".price-value",
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||hasVariant[0].offers[0].price'
        ],
        availability: [
          "if(button:contains('Add to cart'), 'In Stock', 'Out of Stock')",
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||hasVariant[0].offers[0].availability'
        ],
        image: [
          'img[src*="media"]||||src',
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||image'
        ],
        brand: [
          ".product-tile__brand",
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||brand.name'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||sku'
        ],
        model: [
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||name'
        ],
        barcode: [
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||hasVariant[0].gtin13[0]'
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:contains("ProductGroup")||||hasVariant[0].sku'
        ],
        condition: "New"
      }
    },
    {
      id: "reichelt",
      name: "reichelt",
      category_tags: [
        "sports-outdoors",
        "clothing"
      ],
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      base: {
        "*-us": "reichelt.com",
        "*-de": "www.reichelt.de"
      },
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        barcode: "//meta[@itemprop='gtin13']/@content",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        mpn: "normalize-space(substring-after(//meta[contains(@itemprop, 'productID')]/@content, 'mpn:'))"
      }
    },
    {
      id: "reliancedigital",
      name: "reliancedigital",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "/p/(?<identifier>\\d+)"
      ],
      base: "www.reliancedigital.in",
      ore: {
        availability: [
          "json||||script:nth-of-type(4)||||$bankEmiData.productData.structuredData.offers.availability",
          "//meta[@property='product:availability']/@content"
        ],
        barcode: [
          "json||||script:nth-of-type(4)||||$bankCodeData.productData.ean"
        ],
        cost: [
          "json||||script:nth-of-type(4)||||$pdp.productData.price.value",
          "//span[contains(@class, 'TextWeb__Text')]/span[2]"
        ],
        currency: [
          "json||||script:nth-of-type(4)||||$bankCodeData.productData.price.currencyIso",
          "//meta[@property='product:price:currency']/@content"
        ],
        model: "json||||script:nth-of-type(4)||||$pdp.productData.productModelName",
        sku: [
          "json||||script:nth-of-type(4)||||$deliveryData.productData.sidePanel.0.data.0.skuId",
          "//meta[@property='product:retailer_item_id']/@content"
        ]
      }
    },
    {
      id: "retailmenot",
      name: "Retail Me Not",
      "is-aggregator": true,
      paths: [],
      base: {
        "*-us": "retailmenot.com"
      },
      asdfasdgmine: "verb-miner-function-retailmenot-retailer-mine",
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "revolutionbeauty",
      name: "revolutionbeauty",
      category_tags: [
        "beauty"
      ],
      paths: [
        "\\/(?<identifier>\\d+)\\.html"
      ],
      base: "revolutionbeauty.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//div[contains(@class, 'b-product_tile-availability')]/descendant::p[contains(@class, 'b-notify_me-description_copy')]/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//meta[@property='og:product:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
          "//meta[@property='og:product:price:currency']/@content"
        ],
        model: "//span[contains(@class, 'b-pdp_accordion-product_code')]/text()",
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ]
      }
    },
    {
      id: "rh",
      category_tags: [
        "home-garden"
      ],
      base: "rh.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9a-z]+).jsp.*"
      ],
      ore: {
        cost: "//div[@data-testid='price-for-regular']/text()",
        costMember: "//div[@data-testid='price-for-member']/text()",
        delivery: "//p[@class='MuiTypography-root MuiTypography-body1']//text()",
        title: "//h3[@class='MuiTypography-root MuiTypography-h3']/text()"
      },
      scout: {
        "path-disabled": "/search/results.jsp?Ntt={{query}}",
        items: './/div[@class="MuiGrid-root MuiGrid-container"]/div',
        ore: {
          cost: './/span[@class="priceSpan priceSpanRegular"]/text()',
          image: './/div[@id="component-rh-image_wrapper"]//img/@src',
          title: './/p[contains(@class,"MuiTypography")]/span/text()',
          url: './/a[@class="MuiTypography-root MuiLink-root MuiLink-underlineNone MuiTypography-colorPrimary"]/@href'
        }
      }
    },
    {
      id: "riteaid",
      name: "Rite Aid",
      category_tags: [
        "health-pharmacy"
      ],
      base: "riteaid.com",
      paths: [
        "\\/shop\\/(?<identifier>[a-z0-9]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin13',
          "substring-before(translate(substring-after(substring-after(substring-after(substring-after(//meta[@property='og:image']/@content,'cache/'),'/'),'/'),'/'),'_','.'),'.')"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//meta[@property='product:price:amount']/@content",
          "//meta[@itemprop='price']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//form[@id='product_addtocart_form']/@data-product-sku",
          "normalize-space(substring-after(//div[@class='product attribute sku'],'SKU'))"
        ],
        title: "//span[@itemprop='name']/text()",
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//div[contains(@class, 'stock available')]//span[contains(@class, 'status')]"
        ],
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
      }
    },
    {
      id: "roblox",
      category_tags: [
        "toys-games"
      ],
      base: "roblox.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[A-Z0-9]+)"
      ],
      ore: {
        title: "//h1[@class='game-name']//text()"
      },
      scout: {
        path: "https://www.roblox.com/discover/?Keyword={{query}}",
        items: "//div[@id='games-search-page']/div/div",
        ore: {
          image: './/div[@class="thumbnail-2d-container game-card-thumb-container"]/@style',
          title: './/div[@class="game-card-name game-name-title"]//text()',
          url: './/a[@class="game-card-link"]/@href'
        }
      }
    },
    {
      id: "rockbottomgolf",
      name: "rockbottomgolf",
      category_tags: [
        "sells-everything"
      ],
      base: "www.rockbottomgolf.com",
      paths: [
        "\\/\\?sku=(?<identifier>[^&]+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//meta[@property='og:availability']/@content"
        ],
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(15)||||product_attributes.upc',
          "//dt[contains(text(), 'UPC')]/following-sibling::dd[1]/text()"
        ],
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(15)||||product_attributes.price.without_tax.formatted',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(15)||||product_attributes.price.saved.currency',
          "//meta[@property='product:price:currency']/@content"
        ],
        model: "//dd[contains(@class, 'productView-info-value model')]/text()",
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//dt[@class='productView-info-name sku-label']/following-sibling::dd/text()"
        ]
      }
    },
    {
      id: "samsclub",
      category_tags: [
        "sells-everything"
      ],
      base: "samsclub.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)"
      ],
      ore: {
        availability: [
          "//meta[@itemprop='availability']/@content",
          "//meta[@itemProp='availability']/@content"
        ],
        brand: "//span[@class='sc-product-header-item-number']//text()",
        cost: [
          "//meta[@itemprop='price']/@content",
          "//span[@class='visuallyhidden']//text()"
        ],
        delivery: "//section[contains(@class,'sc-pc-delivery')]//text()",
        mpn: [
          "//meta[@itemprop='mpn']/@content",
          "//meta[@itemProp='mpn']/@content"
        ],
        title: "//meta[@itemprop='name']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      },
      scout: {
        path: "https://www.samsclub.com/s/{{query}}",
        items: "//div[@data-analytics='plp:product']/ul/li",
        ore: {
          cost: './/span[@class="Price-group"]/text()',
          image: './/div[@class="sc-image-wrapper"]//img/@src',
          title: './/div[@class="sc-pc-title-medium"]/h3/@title',
          url: './/a[@role="group"]/@href'
        }
      }
    },
    {
      id: "samsung",
      name: "Samsung",
      category_tags: [
        "electronics"
      ],
      base: "samsung.com",
      paths: [
        ".*\\/(?<identifier>.+)\\/"
      ],
      ore: {
        brand: "substring-after('samsung','')",
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.offers.14.price',
          "//div[@class='product-details__info-price']"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku',
          "//strong[@class='type-p3 product-details__info-sku']"
        ],
        title: "//h1[@class='product-details__info-title']",
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.offers.16.availability',
          "//span[contains(@class, 's-color-out')]/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency',
          "//input[@id='priceCurrency']/@value"
        ]
      }
    },
    {
      id: "scheels",
      name: "scheels",
      category_tags: [
        "sports-outdoors"
      ],
      base: "www.scheels.com",
      paths: [],
      ore: {
        availability: [
          "json||||script:nth-of-type(25)||||productAvailable",
          "//meta[@itemprop='availability']/@content"
        ],
        barcode: "//div[contains(@class, 'product-number')]/span[@itemprop='productID']/text()",
        cost: [
          "json||||script:nth-of-type(25)||||productPrice",
          "//span[@class='price-sales']/span/span[contains(@itemprop, 'price')]/text()"
        ],
        currency: [
          "json||||script:nth-of-type(29)||||ecommerce.items.0.currency",
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        sku: [
          "json||||script:nth-of-type(25)||||productID",
          "//span[@class='productsku']/text()"
        ]
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "scholastic",
      name: "Scholastic",
      category_tags: [
        "books"
      ],
      base: "shop.scholastic.com",
      paths: [
        "\\/(?<identifier>.+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          "substring-after(substring-after(normalize-space(//meta[@name='image']/@content),'/isbn/'), '/')",
          "(//span[@class='spn-product-details'])[1]"
        ],
        cost: "//dd[@itemprop='price']",
        title: "//h1[@itemprop='name']",
        availability: "//span[contains(@class, 'pdp__oos-label')]/text()"
      }
    },
    {
      id: "sears",
      name: "Sears",
      category_tags: [
        "sells-everything"
      ],
      base: "sears.com",
      paths: [
        "(.+)\\/p-(?<identifier>[A-Z0-9]+)"
      ],
      scout: null,
      ore: {
        barcode: "substring-before(//tr/td[contains(text(),'ISBN')]/following-sibling::td/text(),' /')",
        brand: "substring-before(//h1[@class='product-title title-2'],' ')",
        cost: [
          "//span[contains(@class, 'product-final')]/span[contains(@class, 'pricing-sale-ui')]/text()",
          "//h4/span[@class='price-wrapper']",
          "//span[contains(@class, 'pricing-sale-ui')]/text()",
          ".pricing-sale-ui"
        ],
        sku: [
          "substring-after(//div[contains(@class, 'col specs-ul')]/text(), 'Item# : ')",
          "substring-after(//small[contains(text(),'Item #')],'# ')"
        ],
        title: "//h1[@class='product-title title-2']",
        model: "substring-after(//div[contains(@class, 'specs-ul') and contains(text(), 'Model #')]//text(), 'Model # : ')"
      }
    },
    {
      id: "selectonline",
      name: "selectonline",
      paths: [
        "\\?srsltid=(?<identifier>[\\w-]+)"
      ],
      base: "uk.selectonline.com",
      ore: {
        availability: [
          'json||||script[type="text/x-magento-init"]:nth-of-type(25)||||*.Magento_Catalog/js/product/view/provider.data.items.198061.is_available',
          "//span[contains(@class, 'dispatch')]/text()"
        ],
        cost: [
          "//span[@class='price']/text()"
        ],
        currency: [
          "json||||script:nth-of-type(30)||||ecommerce.items.0.currency",
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(4)||||mpn',
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||sku',
          "//td[@data-th='SKU']/text()"
        ]
      }
    },
    {
      id: "selfridges",
      name: "selfridges",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\/cat\\/[^_]+_(?<identifier>[^\\/?]+)"
      ],
      base: "selfridges.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//*[contains(translate(text(), 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'), 'back in stock')]/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ],
        sku: "substring-after(//p[contains(@class, 'ProductDetails__ProductInformation')]/text(), 'Ref: ')"
      }
    },
    {
      id: "sephora",
      category_tags: [
        "beauty"
      ],
      base: "sephora.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[\\w+]+)\\.html",
        "/product/(?<identifier>[\\w-]+)\\?"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//span[@data-at='pickup_stock_level_label']/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          "//b[@class='css-0']/text()",
          "//p[@class='Price']/span/span[1]/text()"
        ],
        delivery: "//label[@data-comp='Checkbox StyledComponent BaseComponent ']//text()",
        title: "//h1[@data-comp='DisplayName StyledComponent BaseComponent ']//text()",
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.priceCurrency',
        sku: "json||||#linkStore||||page.product.productDetails.productId"
      },
      scout: {
        path: "/api/catalog/search?type=keyword&content=true&includeRegionsMap=true&targetSearchEngine=nlp&countryCode=US&q={{query}}",
        items: "products",
        ore: {
          Brand: "brandName",
          cost: "salePrice",
          image: "heroImage",
          title: "currentSku.imageAltText",
          url: "url"
        }
      }
    },
    {
      id: "shein",
      name: "shein",
      category_tags: [
        "clothing"
      ],
      paths: [
        "-p-(?<identifier>\\d+)-cat-"
      ],
      base: "shein.co.uk",
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//div[contains(@class, 'product-intro__head-mainprice')]/div[@class='original from']/span/text()"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "substring-after(//div[contains(text(), 'SKU:')]/text(), 'SKU:')"
        ]
      }
    },
    {
      id: "shiekh",
      name: "shiekh",
      category_tags: [
        "clothing"
      ],
      base: "www.shiekh.com",
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        mpn: "//meta[@itemprop='mpn']/@content",
        sku: [
          'json||||script[type="text/x-magento-init"]:nth-of-type(13)||||*.searchspring-tracking-product-view.sku',
          "//div[contains(@class, 'product attribute sku')]/div[@itemprop='sku']/text()"
        ]
      }
    },
    {
      id: "shopjetson",
      name: "shopjetson",
      base: "shopjetson.com",
      paths: [
        "\\/(?<identifier>[\\w+]+)$"
      ],
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        barcode: "//meta[@itemprop='gtin14']/@content",
        cost: [
          "//span[@id='model_price']/text()",
          "//meta[@itemprop='price']/@content"
        ],
        model: "//input[@name='Model']/@value",
        sku: "//meta[@itemprop='sku']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        mpn: "//meta[@itemprop='sku']/@content"
      }
    },
    {
      id: "shopping",
      name: "Shopping.com",
      category_tags: [
        "sells-everything"
      ],
      base: "shopping.com",
      paths: [
        "id=(?<identifier>[a-z0-9]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "json||||script:nth-of-type(6)||||attributes.EAN",
          "normalize-space(//td[contains(text(),'ISBN')]/following-sibling::*[2])",
          "normalize-space(//td[contains(text(),'UPC')]/following-sibling::*[2])"
        ],
        brand: "substring-before(//h1[@class='productTitle'],' ')",
        cost: [
          "json||||script:nth-of-type(6)||||price.sellingPrice",
          "string(//span[@class='frmMinPrice ' or @class='toSalePrice'])"
        ],
        mpn: [
          "json||||script:nth-of-type(6)||||attributes.MPN",
          "normalize-space(//td[contains(text(),'MPN')]/following-sibling::*[2])"
        ],
        sku: "//input[@name='itemId']/@value",
        title: "//h1[@class='productTitle']",
        currency: "//meta[@property='product:price:currency']/@content",
        model: "json||||script:nth-of-type(6)||||attributes.Model"
      }
    },
    {
      id: "shopto",
      name: "shopto",
      category_tags: [
        "toys-games"
      ],
      paths: [
        "/en/(?<identifier>[^/]+)/"
      ],
      base: "shopto.net",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||Offers.0.availability',
          "//div[contains(@class, 'inventory')]/p[contains(text(), 'In Stock')]"
        ],
        barcode: 'json||||script[type="application/ld+json"]||||mpn',
        cost: [
          'json||||script[type="application/ld+json"]||||Offers.0.price',
          "//meta[@property='og:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||Offers.0.shippingDetails.0.shippingRate.currency',
          "//meta[@property='og:price:currency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]||||mpn',
        sku: [
          'json||||script[type="application/ld+json"]||||sku'
        ]
      }
    },
    {
      id: "shopwinedirect",
      name: "shopwinedirect",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "shopwinedirect.com",
      ore: {
        availability: [
          'json||||script[type="text/javascript"]:nth-of-type(8)||||product_attributes.instock',
          "//meta[@itemprop='availability']/@content"
        ],
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(8)||||product_attributes.upc',
          "//meta[@itemprop='gtin']/@content"
        ],
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(8)||||product_attributes.price.without_tax.formatted',
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(8)||||product_attributes.price.without_tax.currency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        mpn: [
          'json||||script[type="text/javascript"]:nth-of-type(8)||||product_attributes.mpn',
          "//meta[@itemprop='mpn']/@content"
        ],
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(8)||||product_attributes.sku',
          "//dt[contains(@class, 'sku-label')]/following-sibling::dd[contains(@class, 'productView-info-value')]"
        ]
      }
    },
    {
      id: "simply",
      name: "simply",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "www.simply.ca",
      ore: {
        availability: [
          "json||||#ProductJson-product-template||||available",
          "//link[@itemprop='availability']/@href"
        ],
        barcode: "json||||#ProductJson-product-template||||variants.0.barcode",
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(7)||||Price',
          "//span[@class='money']/text()"
        ],
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "json||||#ProductJson-product-template||||variants.0.sku"
      }
    },
    {
      id: "sixityauto",
      name: "sixityauto",
      category_tags: [
        "automotive"
      ],
      base: "sixityauto.com",
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html$"
      ],
      ore: {
        availability: [
          "json||||script:nth-of-type(14)||||ecommerce.items.0.item_stock_status",
          "//meta[@property='product:availability']/@content"
        ],
        barcode: [
          "//td[contains(@data-th, 'GTIN')]/text()"
        ],
        cost: [
          "json||||script:nth-of-type(14)||||ecommerce.items.0.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="text/x-magento-init"]:nth-of-type(22)||||*.Magento_Catalog/js/product/view/provider.data.currency',
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: "//td[@data-th='Part Number']/text()",
        sku: [
          "//meta[@property='product:retailer_item_id']/@content"
        ]
      }
    },
    {
      id: "skechers",
      category_tags: [
        "clothing"
      ],
      base: "skechers.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[\\w+]+)\\.html"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price',
          "//meta[@property='product:price:amount']/@content",
          "//span[@class='sales']/span/text()"
        ],
        delivery: "//div[@id='shippingPickup']//text()",
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn'
        ],
        title: "//h1[@data-test='c-product-details__product-name product-name']/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//span[@class='product-id']/text()"
        ],
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
      },
      scout: {
        path: "/search/?q={{query}}&search-button=&lang=en_US",
        items: './/div[contains(@class,"rfk-product-tile")]',
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: ".//span[@class='sales']/span/text()",
          image: ".//div[contains(@class,'image-container')]//picture/img/@src",
          title: ".//div[@class='pdp-link c-product-tile__title__wrap']//text()",
          url: ".//div[@class='pdp-link c-product-tile__title__wrap']/a/@href"
        }
      }
    },
    {
      id: "smarthome",
      name: "SmartHome",
      category_tags: [
        "electronics"
      ],
      base: "smarthome.com",
      paths: [],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        barcode: "(//li[@class='tab_specs']//tr//td[contains(.,'UPC')]/following-sibling::td)[1]",
        brand: "((//li[@class='tab_specs']//tr//td[contains(.,'Brand')]/following-sibling::td)[1] | (//li[@class='tab_specs']//tr//td[contains(.,'Manufacturer')]/following-sibling::td)[1])[1]",
        cost: "(//span[@itemprop='price'])[1]",
        mpn: "(//li[@class='tab_specs']//tr//td[contains(.,'Manufacturer Product')]/following-sibling::td)[1]",
        sku: "substring-after(//p[@class='product-ids'], '#: ')",
        title: "//h1[@itemprop='name']"
      }
    },
    {
      id: "softwarekeep",
      name: "softwarekeep",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "softwarekeep.ca",
      ore: {
        availability: [
          "json||||#hi-allan||||offers.availability",
          "//div[@class='product-page-actions-box']/button[contains(@class, 'add-to-cart')]/span/text()"
        ],
        barcode: "json||||#hi-allan||||gtin13",
        cost: "json||||#__NEXT_DATA__||||props.pageProps.product.price.minimalPrice.amount.value",
        currency: "json||||#hi-allan||||offers.shippingDetails.shippingRate.currency",
        model: "json||||#hi-allan||||model",
        mpn: "json||||#__NEXT_DATA__||||props.pageProps.product.mpn",
        sku: "json||||#hi-allan||||sku"
      }
    },
    {
      id: "sokoglam",
      name: "sokoglam",
      category_tags: [
        "beauty"
      ],
      base: "sokoglam.com",
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.availability',
          "//link[@itemprop='availability']/@href"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||gtin13',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.price'
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(36)||||currency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(3)||||mpn',
        sku: [
          "json||||script:nth-of-type(92)||||sku",
          "normalize-space(//label[text()='Product sku:']/following-sibling::input/@value)"
        ]
      }
    },
    {
      id: "sonicelectronix",
      name: "Sonic Electronix",
      category_tags: [
        "electronics"
      ],
      base: "sonicelectronix.com",
      paths: [
        "\\/item-(?<identifier>\\d+)-"
      ],
      scout: null,
      ore: {
        barcode: "//div[@class='row' and contains(.,'UPC')]//div[@class='value']",
        brand: "substring-before((//div[@class='header']//h2)[1], ' ')",
        cost: [
          "//h3[@id='product-price-text']/text()",
          "//div[@class='price']//h3"
        ],
        mpn: "substring-after((//div[@id='productContainer']//div[@class='header']//h2)[1], ' ')",
        sku: [
          "//div[contains(@class, 'row oddEvenChild')][./div/p[contains(text(), 'Internal SKU:')]]/div[@class='value']/p/text()",
          "//input[@id='productIDValue']/@value"
        ],
        title: "(//div[@class='header']//h2)[1]",
        availability: "//span[contains(@class, 'inStock')]/text()",
        model: "//div[contains(@class, 'row oddEvenChild')][contains(.//p, 'Model Number:')]/div[@class='value']/p/text()"
      }
    },
    {
      id: "sonos",
      name: "Sonos",
      category_tags: [
        "electronics"
      ],
      base: "sonos.com",
      paths: [],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        barcode: "substring(substring-before(substring(substring-after(//script[contains(text(),'gtin12')],'gtin12'),5),','),0,string-length(substring-before(substring(substring-after(//script[contains(text(),'gtin12')],'gtin12'),5),',')))",
        brand: "substring-after('sonos','')",
        cost: "normalize-space(//span[@class='product-price '])",
        mpn: "//meta[@itemprop='mpn']/@content",
        sku: "//meta[@itemprop='sku']/@content",
        title: "//title"
      }
    },
    {
      id: "spacenk",
      name: "spacenk",
      category_tags: [
        "beauty"
      ],
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "spacenk.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.offers.0.availability',
          "//h4[contains(@class, 'text-cart-green')]/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin13',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.offers.0.price',
          "//span[@class='value']/text()"
        ],
        currency: [
          "json||||script:nth-of-type(16)||||currency"
        ],
        model: "//span[@class='product-id']/text()",
        mpn: "//span[@class='product-id']/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
          "//span[@class='product-id']/text()"
        ]
      }
    },
    {
      id: "spencerstv",
      name: "Spencers TV & Appliance",
      category_tags: [
        "electronics"
      ],
      base: "spencerstv.com",
      paths: [
        "\\/(?<identifier>[\\w-]+)$"
      ],
      ore: {
        cost: "//meta[@property='product:price:amount']/@content",
        sku: "//div[@id='videoly-product-sku']/text()",
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.3.offers.availability',
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.object.gtin12',
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||@graph.1.object.offers.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: "//meta[@name='keywords']/@content"
      }
    },
    {
      id: "stadiumgoods",
      name: "stadiumgoods",
      category_tags: [
        "clothing"
      ],
      base: "stadiumgoods.com",
      paths: [
        "/shopping/(?<identifier>[\\w-]+)\\?"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.availability',
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||offers.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: "//tr[th[contains(text(), 'Manufacturer Sku')]]/td[@class='data']/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||sku'
        ]
      }
    },
    {
      id: "stereoplus",
      name: "stereo+",
      category_tags: [
        "electronics"
      ],
      base: "stereoplus.com",
      paths: [
        "/products/(?<identifier>[^/]+)$"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability',
          'json||||script[type="application/json"]:nth-of-type(2)||||product.available',
          "//div[contains(@class, 'product-available-store')]/ul/li[1]/p/text()"
        ],
        barcode: [
          'json||||script[type="application/json"]:nth-of-type(2)||||product.variants.0.barcode',
          "//span[contains(@class, 'product-meta__barcode-number')]/text()"
        ],
        cost: [
          'json||||script[type="application/json"]:nth-of-type(2)||||product.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        model: "//span[@class='product-meta__sku-number']/text()",
        mpn: [
          'json||||script[type="application/json"]:nth-of-type(2)||||product.tags.13'
        ],
        sku: [
          'json||||script[type="application/json"]:nth-of-type(2)||||product.variants.0.sku',
          "//span[contains(@class, 'product-meta__sku-number')]/text()"
        ],
        currency: "//meta[@property='product:price:currency']/@content"
      }
    },
    {
      id: "stingeroffroad",
      name: "stingeroffroad",
      category_tags: [
        "automotive"
      ],
      base: "stingeroffroad.com",
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//div[contains(@class, 'product__inventory')]/text()"
        ],
        barcode: "json||||.hide||||barcode",
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//meta[@property='og:price:amount']/@content"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(39)||||currency',
          "//meta[@property='og:price:currency']/@content"
        ],
        sku: [
          "json||||.hide||||sku",
          "//p[@class='product-single__sku']/text()"
        ]
      }
    },
    {
      id: "studio",
      name: "studio",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\/(?<identifier>[\\w-]+)\\?source"
      ],
      base: "https://www.studio.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//span[contains(@class, 'product-details__notice-wrapper-message--green')]/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//p[contains(@class, 'product-details__price-now')]/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency'
        ],
        model: "substring-after(//p[contains(text(), 'Item Reference:')], 'Item Reference:')",
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||mpn'
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku',
          "substring-after(//span[contains(@class, 'sku')]/text(), 'SKU:P_')"
        ]
      }
    },
    {
      id: "sukoshimart",
      name: "sukoshimart",
      base: "sukoshimart.com",
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      ore: {
        barcode: 'json||||script[type="text/javascript"]:nth-of-type(8)||||product_id',
        cost: [
          "//meta[@property='og:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//span[contains(text(), 'USD')]"
        ],
        sku: [
          "json||||script:nth-of-type(58)||||product.variants.0.sku"
        ]
      }
    },
    {
      id: "summitracing",
      name: "Summit Racing",
      category_tags: [
        "automotive"
      ],
      base: "summitracing.com",
      paths: [
        "/parts/(?<identifier>[^/]+)"
      ],
      scout: null,
      ore: {
        barcode: "//span[contains(text(), 'UPC')]/following-sibling::span",
        brand: "substring-after(//a[contains(@title,'See parts for')]/@title,'for ')",
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "(//p[@class='price'])[1]"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn',
          "//span[contains(text(),'s Part Number')]/following-sibling::span"
        ],
        sku: [
          "json||||#cordial-view-item||||sku",
          "//div[@class='price-wrapper hide-content pricing-component']/@data-sku",
          "substring-after(//link[@rel='canonical']/@href,'parts/')"
        ],
        title: "//h1[@class='title']",
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//span[contains(@class, 'estimate-shipping-placeholder')]/strong/following-sibling::span/span[@class='display-date']/text()"
        ]
      }
    },
    {
      id: "sunglasshut",
      name: "Sunglass Hut",
      category_tags: [
        "clothing"
      ],
      base: "sunglasshut.com",
      paths: [
        "/us/[^/]+/(?<identifier>[^?]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//meta[@property='og:upc']/@content",
          "//span[starts-with(@id,'upc_')]"
        ],
        brand: "//div[@id='WC_CachedItemDisplay_div_3']//h1",
        cost: [
          "//span[@id='price_STK_HEADER']/text()",
          "//span[@id='price']"
        ],
        mpn: "substring-before( //div[@id='WC_CachedItemDisplay_div_3']//h2, ' ')",
        title: "concat(//div[@id='WC_CachedItemDisplay_div_3']//h1, ' ', //div[@id='WC_CachedItemDisplay_div_3']//h2)",
        availability: "//a[@id='emailMeAvalaible' and contains(text(), 'Email me when available')]"
      }
    },
    {
      id: "supercheapauto",
      name: "supercheapauto",
      category_tags: [
        "automotive"
      ],
      paths: [
        "\\/(?<identifier>\\d+)\\.html$"
      ],
      base: "www.supercheapauto.com.au",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        cost: 'json||||script[type="text/javascript"]:nth-of-type(53)||||ecommerce.detail.products.0.price',
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(53)||||ecommerce.detail.products.0.id',
          "//meta[@itemprop='productID']/@content"
        ]
      }
    },
    {
      id: "superdrug",
      name: "superdrug",
      category_tags: [
        "health-pharmacy"
      ],
      paths: [
        "/p/(?<identifier>[\\w+]+)\\?"
      ],
      base: "superdrug.com",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        mpn: "//meta[@itemprop='mpn']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      }
    },
    {
      id: "supplementwarehouse",
      name: "Supplement Warehouse",
      category_tags: [
        "health-pharmacy"
      ],
      base: "supplementwarehouse.com",
      paths: [
        "/products/(?<identifier>[^?]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//dd[@class='productView-info-value productView-info-value--upc']/text()",
          "((//span[@style and contains(text(),'UPC:')]/ancestor::span)[1]/following-sibling::span)[1]//strong"
        ],
        cost: [
          "//span[contains(@class, 'price--main')]/text()",
          "substring-after(//span[@class='Sizeprice'],'$')"
        ],
        sku: "(//input[@name='idproduct' and @value])[1]/@value",
        title: "//span[@class='ProductName']",
        availability: "//meta[@property='og:availability']/@content"
      }
    },
    {
      id: "suruga-ya",
      name: "suruga-ya",
      paths: [
        "\\/product\\/detail\\/(?<identifier>\\d+)"
      ],
      base: "www.suruga-ya.jp",
      ore: {
        availability: "normalize-space(//div[@class='panel_buy mgnB20']/div[contains(@class, 'out-of-stock-text')]/text())",
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||gtin13'
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price'
        ],
        currency: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.priceCurrency',
        model: "//th[contains(., ' 型番 ') or contains(., '型番')]/following-sibling::td/text()",
        sku: "//table[contains(@class, 'tbl_product_info')]/tbody/tr/th[text()='管理番号']/following-sibling::td/text()"
      }
    },
    {
      id: "t-mobile",
      name: "T-Mobile",
      category_tags: [
        "electronics"
      ],
      base: "www.t-mobile.com",
      paths: [
        "\\?sku=(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//meta[@name='WT.pn_sku']/@content"
        ],
        cost: [
          "(//div[@id='Price'])[1]"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//input[@type='hidden' and @id='hdnCurDeviceID']/@value"
        ],
        title: "//h2/span[@id='lblDeviceNameOverview']",
        availability: [
          "//div[contains(@class, 'product-inventory-status')]/tmo-product-inventory-status-element/p/span[@class='text-small font-weight-bold text-green']/text()"
        ],
        currency: 'json||||script[type="application/ld+json"]||||offers.priceCurrency'
      }
    },
    {
      id: "target",
      name: "Target",
      category_tags: [
        "sells-everything"
      ],
      base: {
        "*-us": "www.target.com",
        "*-ca": "intl.target.com",
        "*-au": "www.target.com.au",
        "*-undefined": "www.target.com.au"
      },
      paths: [
        "-\\/A-(?<identifier>\\d+)",
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)",
        ".*\\/-\\/A-(?<identifier>[0-9]+).*"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: "span[data-test='product-regular-price']",
              at: "afterend"
            }
          ]
        }
      ],
      ore: {
        barcode: [
          "verb-miner-function-target-ore-json:data.product.item.primary_barcode"
        ],
        brand: "verb-miner-function-target-ore-json:data.product.item.primary_brand.name",
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//span[@data-testid='current-price']/span/text()",
          "//meta[@itemprop='price']/@content",
          "verb-miner-function-target-ore-json:data.product.price.formatted_current_price"
        ],
        images: "verb-miner-function-target-ore-images",
        url: "verb-miner-function-target-ore-json:data.product.item.enrichment.buy_url",
        title: "verb-miner-function-target-ore-json:data.product.item.product_description.title",
        availability: [
          "json||||#__NEXT_DATA__||||props.pageProps.product.productAvailability",
          "//meta[@itemprop='availability']/@content"
        ],
        currency: [
          "json||||#__NEXT_DATA__||||props.pageProps.product.price.currencyIso",
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//meta[@itemprop='productID']/@content"
        ]
      },
      scout: {
        path: "https://www.target.com/s?searchTerm={{query}}",
        items: 'div[data-test="product-grid"] > div > section > div > div',
        ore: {
          cost: './/span[@data-test="current-price"]/text()',
          image: './/div[contains(@class,"ProductCardImage")]/picture/img/@src',
          title: './/div[contains(@class,"ProductCardItemInfo")]//text()',
          url: './/a[@role="group"]/@href'
        }
      }
    },
    {
      id: "teknosa",
      name: "teknosa",
      category_tags: [
        "electronics"
      ],
      paths: [],
      base: "www.teknosa.com",
      ore: {
        availability: [
          "json||||#schemaJSON||||@graph.offers.availability",
          "//button[@data-product-stock-status='Satışta']/text()"
        ],
        cost: [
          "//span[contains(@class, 'prc-last')]/text()"
        ],
        currency: [
          "json||||script:nth-of-type(7)||||product.currency"
        ],
        sku: "json||||#schemaJSON||||@graph.sku"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "tekshop247",
      name: "tekshop247",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>\\d+)"
      ],
      base: "tekshop247.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.availability',
          "//link[@itemprop='availability']/@href"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(4)||||gtin13',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||offers.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "json||||script:nth-of-type(7)||||currency.iso_code",
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        model: "//span[contains(@itemprop, 'mpn')]/text()",
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||mpn',
          "//div[@class='product-reference']/span[@itemprop='mpn']/text()"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(4)||||sku',
          "//span[@itemprop='sku']/text()"
        ]
      }
    },
    {
      id: "telekom",
      name: "telekom",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\?accessory=(?<identifier>\\d+)"
      ],
      base: "www.telekom.de",
      ore: {
        availability: "//div[@id='js-deliveryTextDestA']/text()",
        cost: "//span[contains(@class, 'price__total-price')]/text()",
        currency: "//span[contains(@class, 'price__currency')]/text()"
      }
    },
    {
      id: "textbooks",
      name: "Textbooks.com",
      category_tags: [
        "books"
      ],
      base: "textbooks.com",
      paths: [
        "\\/(?<identifier>\\d+)\\/[^\\/]+\\.php"
      ],
      scout: null,
      ore: {
        barcode: [
          "//meta[@itemprop='gtin13']/@content",
          "(//span[@class='regGray14px']/text())[last()]"
        ],
        sku: [
          "//meta[@itemprop='productID']/@content",
          "(//span[@class='regGray14px']/text())[last()]"
        ],
        title: "//span[@itemprop='name']",
        availability: "//link[@itemprop='availability']/@href",
        cost: "//div[@class='bold black']/span/span[@itemprop='price']/text()"
      }
    },
    {
      id: "tfaw",
      name: "Things From Another World",
      category_tags: [
        "toys-games"
      ],
      base: "tfaw.com",
      paths: [
        "/([^/]+?)/(?<identifier>[\\w-]+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          "//div[contains(@class, 'getUpc')]/div[@class='value']/text()",
          "//td[contains(text(), 'ISBN')]/following-sibling::td",
          "//td[contains(text(),'UPC')]/following-sibling::td"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//span[@id='product-price-763692']/text()",
          "substring-after(//span[@class='redheader'],substring-before(//span[@class='redheader'],'$'))"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku',
          "//div[contains(@class, 'product-info-price')]//div[contains(@class, 'sku')]/div[@class='value']/text()",
          "substring-before(substring-after(//base/@href,'___'),'/')"
        ],
        title: "(//span[@class='blackheader'])[1]",
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//div[contains(@class, 'product attribute availability')]/div[@class='value']/text()"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||mpn',
          "normalize-space(//div[contains(@class, 'product attribute getIsbn')]//div[contains(@class, 'value')]/text())"
        ],
        currency: "json||||script:nth-of-type(141)||||currency"
      }
    },
    {
      id: "thebodyshop",
      name: "thebodyshop",
      category_tags: [
        "beauty"
      ],
      paths: [
        "/p/(?<identifier>\\w+)"
      ],
      base: "thebodyshop.com",
      ore: {
        availability: "normalize-space(//button[contains(@class, 'add-to-bag-set__add')])",
        cost: "//span[contains(@class, 'price__element--formatted')]/text()"
      }
    },
    {
      id: "theclubfactory",
      name: "theclubfactory",
      category_tags: [
        "clothing"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "theclubfactory.in",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability',
          "//button[@data-action='add-to-cart']/text()"
        ],
        cost: [
          'json||||script[type="application/json"]:nth-of-type(2)||||product.price',
          "//span[contains(@class, 'price--highlight')]/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(3)||||itemReviewed.offers.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ],
        model: [
          "//meta[@property='og:type' and @content='product']//following::*[contains(text(), 'Variant')][1]/../descendant::option[@selected='selected']/@data-sku"
        ],
        sku: [
          "json||||script:nth-of-type(31)||||product.variants.0.sku",
          "//select[@id='product-select-7566487027962']/option[@selected]/@data-sku"
        ]
      }
    },
    {
      id: "thegoodguys",
      name: "thegoodguys",
      category_tags: [
        "sells-everything"
      ],
      paths: [
        "\\?istCompanyId=[\\w-]+&istFeedId=[\\w-]+&istItemId=(?<identifier>[\\w-]+)&"
      ],
      base: "www.thegoodguys.com.au",
      ore: {
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.priceCurrency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        model: "//div[contains(@class, 'pdpmodelnumber')]//span[contains(@class, 'titleItems_model_digit')]/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
        ]
      }
    },
    {
      id: "thesource",
      name: "thesource",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/p/(?<identifier>[\\w+]+)\\?"
      ],
      base: "www.thesource.ca",
      ore: {
        availability: "//div[@id='unavailableProductWarning']/p[@class='product-not-displayable-text']",
        barcode: [
          "//div[contains(text(), 'UPC:')]/following-sibling::div[1]/text()"
        ],
        mpn: "//div[contains(text(), 'Manufacturer’s Part Number:')]/following-sibling::div[1]/text()",
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(17)||||item',
          "//li[contains(text(), 'SKU:')]//span[@class='identifier']/text()"
        ]
      }
    },
    {
      id: "three",
      name: "three",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "three.co.uk",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//span[contains(@class, 't4s-available-status')]/span[@data-instock-status]"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//meta[@property='og:price:amount']/@content"
        ],
        currency: [
          "json||||#apple-pay-shop-capabilities||||currencyCode",
          "//meta[@property='og:price:currency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]||||mpn',
        barcode: 'json||||script[type="application/ld+json"]||||mpn',
        sku: "json||||script:nth-of-type(40)||||product.variants.0.sku"
      }
    },
    {
      id: "thriftbooks",
      name: "Thrift Books",
      category_tags: [
        "books"
      ],
      base: "thriftbooks.com",
      paths: [
        "\\/w/.*\\/(?<identifier>[^\\/\\?\\&]+)"
      ],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        barcode: "//span[contains(text(),'ISBN')]/following-sibling::*",
        cost: "//span[@class='price']",
        sku: "//span[contains(text(),'ISBN')]/following-sibling::*",
        title: "//h1[@itemprop='name']"
      }
    },
    {
      id: "thrivemarket",
      name: "Thrive Market",
      category_tags: [
        "grocery-food"
      ],
      base: "thrivemarket.com",
      paths: [
        "/p/(?<identifier>[^?]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "substring-after(//p[@data-test-id='product-detail__text-sku'],': ')"
        ],
        cost: [
          "json||||#__NEXT_DATA__||||props.pageProps.product.map_price",
          "//div[contains(@class, 'sc-610e4009')]/div/div/div[@class='sc-610e4009-1 bbDDcF']/text()",
          "//div[@itemprop='offers']//meta[@itemprop='price']/@content"
        ],
        title: "substring-before(//title,'-')",
        currency: "json||||#__NEXT_DATA__||||props.pageProps.product.currency",
        sku: "json||||#__NEXT_DATA__||||props.pageProps.product.sku"
      }
    },
    {
      id: "tigerdirect",
      name: "Tiger Direct",
      category_tags: [
        "electronics"
      ],
      base: "www.tigerdirect.com",
      scheme: "http",
      paths: [
        ".*Sku\\=(?<identifier>[0-9]+)"
      ],
      ore: {
        barcode: [
          "substring-after(//p[@data-test-id='product-detail__text-sku'],': ')",
          "//ul[@class='pInfo']/li/node()[contains(.,'UPC')]/following-sibling::strong[1]",
          "//ul[@class='pInfo']/li/node()[contains(.,'EAN')]/following-sibling::strong[1]",
          "//ul[@class='pInfo']/li/node()[contains(.,'ISBN')]/following-sibling::strong[1]"
        ],
        brand: "(//ul[@class='pInfo']/li/strong)[1]",
        cost: [
          "//div[@itemprop='offers']//meta[@itemprop='price']/@content",
          "(//span[@class='salePrice'])[1]"
        ],
        delivery: "substring-before(//strong[@class='prodFreeShip'],' ')",
        mpn: "(//ul[@class='pInfo']/li/b)[1]",
        rating: "(//div[@class='itemRating']//strong)[1]",
        ratings: "substring-before(substring-after(//a[contains(.,'Read reviews')]/text(),'('), ')')",
        sku: [
          "substring-after(//p[@data-test-id='product-detail__text-sku'],': ')",
          "normalize-space(substring-before(substring-after(//span[@class='sku' and contains(.,'Item#:')],'Item#:'),'|'))"
        ],
        title: [
          "//div[@class='pdp-info']/h1",
          "substring-before(//title,'-')"
        ]
      },
      scout: {
        "path-disabled": "/applications/SearchTools/search.asp?keywords={{query}}",
        items: "div.product",
        ore: {
          cost: ".salePrice",
          title: ".itemName",
          image: ".productImage img||||src",
          url: ".itemName a||||href"
        }
      }
    },
    {
      id: "tireagent",
      name: "tireagent",
      category_tags: [
        "automotive"
      ],
      base: "tireagent.com",
      paths: [
        "/products/(?<identifier>[^?]+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//p[contains(@class, 'text-green') and contains(@class, 'leading-4')]"
        ],
        cost: 'json||||script[type="application/ld+json"]||||offers.price',
        currency: 'json||||script[type="application/ld+json"]||||offers.priceCurrency',
        model: 'json||||script[type="application/ld+json"]||||model',
        sku: 'json||||script[type="application/ld+json"]||||sku'
      }
    },
    {
      id: "tkmaxx",
      name: "tkmaxx",
      category_tags: [
        "clothing"
      ],
      paths: [
        "/p/(?<identifier>\\d+)"
      ],
      base: "tkmaxx.com",
      ore: {
        availability: "//div[contains(@class, 'stock-status')]/text()",
        barcode: "//input[@name='productCodePost']/@value",
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(7)||||ecommerce.detail.products.0.price',
          "//div[@class='price']/div[@class='product-price']/p[contains(@class, 'item-price-original')]/text()"
        ],
        currency: 'json||||script[type="text/javascript"]:nth-of-type(7)||||currencyCode',
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(7)||||ecommerce.detail.products.0.id'
        ]
      }
    },
    {
      id: "toolup",
      name: "ToolUp",
      category_tags: [
        "home-garden"
      ],
      base: "toolup.com",
      paths: [],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        barcode: "normalize-space(substring-after(//b[contains(text(),'UPC:')]//parent::*,'UPC:'))",
        brand: "substring-before(normalize-space(//h1),' ')",
        cost: [
          "//div[contains(@class, 'product-views-price')]/span[@class='product-views-price-exact']/span[@class='product-views-price-lead']/text()",
          "//meta[@itemprop='price']/@content"
        ],
        mpn: [
          "//span[@itemprop='mpn']"
        ],
        title: "normalize-space(//h1)",
        sku: "//span[contains(@class, 'product-line-sku-value')]/text()"
      }
    },
    {
      id: "tractorsupply",
      name: "Tractor Supply",
      category_tags: [
        "home-garden"
      ],
      base: "tractorsupply.com",
      paths: [
        "/tsc/product(?<identifier>[^?]+)"
      ],
      scout: null,
      ore: {}
    },
    {
      id: "tradeindia",
      name: "tradeindia",
      paths: [
        "\\/products\\/(?<identifier>[a-z0-9-]+)\\.html"
      ],
      base: "www.tradeindia.com",
      ore: {
        availability: [
          "json||||#__NEXT_DATA__||||props.pageProps.initialState.product.PDP_page.PDP_page_res.company_details.in_stock"
        ],
        cost: [
          "json||||#__NEXT_DATA__||||props.pageProps.initialState.product.PDP_page.PDP_page_res.product_details.price"
        ],
        sku: "json||||#__NEXT_DATA__||||props.pageProps.initialState.product.PDP_page.PDP_page_res.product_details.product_id"
      }
    },
    {
      id: "tradeinn",
      name: "tradeinn",
      category_tags: [
        "sports-outdoors"
      ],
      paths: [
        "\\/p\\?id_producte=(?<identifier>\\d+)"
      ],
      base: "www.tradeinn.com",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      }
    },
    {
      id: "traderjoes",
      name: "Trader Joe's",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "www.traderjoes.com"
      },
      paths: [
        "/home/products/pdp/(?<identifier>[^-]+-\\d+)",
        "/home/products/pdp/(?<identifier>[\\w-]+)"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: ".product-title, h1",
              at: "afterend"
            }
          ]
        }
      ],
      ore: {
        title: [
          "verb-miner-function-traderjoes-ore-title",
          'meta[property="og:title"]@content',
          "h1",
          ".product-title"
        ],
        cost: [
          "verb-miner-function-traderjoes-ore-price",
          'meta[property="product:price:amount"]@content',
          ".price",
          "[data-price]"
        ],
        availability: [
          "verb-miner-function-traderjoes-ore-availability",
          'meta[property="product:availability"]@content',
          ".availability",
          ".stock-status"
        ],
        images: [
          "verb-miner-function-traderjoes-ore-images",
          'meta[property="og:image"]@content',
          ".product-image img",
          'img[src*="products"]'
        ],
        barcode: [
          "verb-miner-function-traderjoes-ore-barcode",
          "[data-upc]",
          ".product-upc"
        ],
        brand: [
          "Trader Joe's"
        ],
        manufacturer: [
          "Trader Joe's"
        ],
        currency: [
          "USD"
        ],
        description: [
          "verb-miner-function-traderjoes-ore-description",
          'meta[property="og:description"]@content',
          ".product-description",
          ".product-details"
        ],
        category: [
          "verb-miner-function-traderjoes-ore-category",
          ".breadcrumb",
          ".category-name"
        ],
        sku: [
          "verb-miner-function-traderjoes-ore-sku"
        ],
        model: [
          "verb-miner-function-traderjoes-ore-model"
        ],
        mpn: [
          "verb-miner-function-traderjoes-ore-mpn"
        ],
        identifier: [
          "verb-miner-function-traderjoes-ore-identifier"
        ]
      },
      "brick-and-mortar": "verb-miner-function-traderjoes-brick-and-mortar",
      scout: "verb-miner-function-traderjoes-scout",
      notes: [
        "Tier 2 miner: Uses custom ore functions for client-side data extraction",
        "Product URLs follow pattern: /home/products/pdp/product-name-XXXXXX",
        "Metadata available in raw HTML for title and images",
        "Price and detailed info requires custom functions",
        "Specialty grocer with unique product focus and cult following"
      ]
    },
    {
      id: "trendyol",
      name: "trendyol",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      base: "www.trendyol.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability'
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin13',
        cost: [
          "//span[@class='prc-dsc']/text()"
        ],
        currency: [
          'json||||script[type="application/javascript"]:nth-of-type(1)||||product.price.currency'
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku'
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "troyestore",
      name: "troyestore",
      paths: [
        "\\/(?<identifier>[^\\/]+)$"
      ],
      base: "www.troyestore.com",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@property='product:price:currency']/@content",
        model: "//p[contains(text(), 'Ürün Kodu :')]/span/text()",
        mpn: "//meta[@itemprop='mpn']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      }
    },
    {
      id: "truegether",
      name: "truegether",
      paths: [
        "\\/(?<identifier>USER\\.\\w+-\\w+-\\w+-\\w+-\\w+)\\/listing.html"
      ],
      base: "www.truegether.com",
      ore: {
        availability: "//meta[@itemprop='availability']/@content",
        barcode: "//span[@itemprop='gtin12']/text()"
      }
    },
    {
      id: "turkcell",
      name: "turkcell",
      category_tags: [
        "electronics"
      ],
      paths: [
        "\\/(?<identifier>[^\\/]+)\\?seller="
      ],
      base: "www.turkcell.com.tr",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.availability',
          "//div[@id='last-stock-message']/strong/text()"
        ],
        cost: [
          "//meta[@name='cashPrice']/@content"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency'
        ],
        mpn: "//div[contains(@class, 'm-product-detail-features__title') and contains(text(), 'Part Number')]/following-sibling::div[contains(@class, 'm-product-detail-features__text')]/text()",
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku'
        ]
      }
    },
    {
      id: "tvt",
      name: "tvt",
      paths: [
        "/urun/(?<identifier>[^/]+)"
      ],
      base: "www.tvt.com.tr",
      ore: {
        availability: "//link[@itemprop='availability']/@href",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//span[@itemprop='sku']/text()"
      }
    },
    {
      id: "ucuzbudur",
      name: "ucuzbudur",
      category_tags: [
        "electronics"
      ],
      paths: [
        "/(?<identifier>[^/]+)$"
      ],
      base: "www.ucuzbudur.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
          "//meta[@property='product:availability']/@content"
        ],
        barcode: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku',
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.price'
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency',
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: [
          "//meta[@property='product:retailer_item_id']/@content"
        ]
      }
    },
    {
      id: "ulta",
      name: "ulta",
      category_tags: [
        "beauty"
      ],
      base: "ulta.com",
      paths: [
        "\\/p\\/(?<identifier>.+?)\\?sku"
      ],
      ore: {
        cost: "//div[@class='ProductPricing']/span/text()",
        currency: "//afterpay-placement/@data-currency"
      }
    },
    {
      id: "ultimategamingparadise",
      name: "ultimategamingparadise",
      category_tags: [
        "toys-games"
      ],
      paths: [
        "\\/(?<identifier>[\\w-]+)\\/$"
      ],
      base: "ultimategamingparadise.com",
      ore: {
        availability: [
          "json||||.rank-math-schema-pro||||@graph.5.offers.availability",
          "//span[contains(@class, 'product-card__meta__item--red')]/text()"
        ],
        barcode: "//tr[th[contains(text(), 'GTIN')]]/td/p/text()",
        cost: [
          "json||||script:nth-of-type(28)||||ecommerce.detail.products.0.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "//meta[@property='product:price:currency']/@content"
        ],
        mpn: "//tr[./th[contains(text(), 'MPN')]]/td/p/text()",
        sku: [
          "json||||script:nth-of-type(28)||||ecommerce.detail.products.0.sku",
          "//meta[@property='product:retailer_item_id']/@content"
        ]
      }
    },
    {
      id: "unboxify",
      name: "unboxify",
      paths: [
        "\\?variant=(?<identifier>\\d+)"
      ],
      base: "www.unboxify.in",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//meta[@property='og:availability']/@content"
        ],
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.gtin12',
          "//span[contains(@class, 'strong') and contains(text(), 'Barcode:')]/following-sibling::text()[1]"
        ],
        cost: [
          "json||||script:nth-of-type(30)||||product.variants.0.price",
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: "//meta[@property='og:price:currency']/@content",
        mpn: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||mpn',
        sku: "//input[@name='id']/@value"
      }
    },
    {
      id: "usda",
      name: "USDA",
      base: "fdc.nal.usda.gov",
      paths: [
        ".*\\/(?<identifier>.+)\\/"
      ],
      identification: true,
      scout: {
        path: "/portal-data/external/search",
        request: {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            Accept: "application/json"
          },
          body: {
            includeDataTypes: {
              "Survey (FNDDS)": true,
              Foundation: true,
              Branded: true,
              "SR Legacy": true,
              Experimental: false
            },
            referenceFoodsCheckBox: true,
            requireAllWords: true,
            sortCriteria: {
              sortColumn: "description",
              sortDirection: "asc"
            },
            generalSearchInput: "{{query}}",
            pageNumber: 1,
            exactBrandOwner: null
          }
        },
        ore: {
          title: "json:foods.[0].description",
          brand: "json:foods.[0].brandOwner"
        }
      }
    },
    {
      id: "valorebooks",
      name: "Valore Books",
      category_tags: [
        "books"
      ],
      base: "valorebooks.com",
      paths: [],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        barcode: "//h2[@itemprop='isbn']",
        cost: "(//div[@class='title_wrapper' and contains(./div/span,'New')]/following-sibling::div/div//span[@class='price'])[1]",
        sku: "//h2[@itemprop='isbn']",
        title: "id('itemresult_Title')"
      }
    },
    {
      id: "vatanbilgisayar",
      name: "vatanbilgisayar",
      category_tags: [
        "electronics",
        "appliances"
      ],
      paths: [
        "/([^/]+?)/(?<identifier>[\\w-]+)\\.html"
      ],
      base: "www.vatanbilgisayar.com",
      ore: {
        availability: 'json||||script[type="application/ld+json"]||||offers.0.availability',
        cost: [
          'json||||script[type="application/ld+json"]||||offers.0.price'
        ]
      }
    },
    {
      id: "very",
      name: "very",
      category_tags: [
        "sells-everything"
      ],
      paths: [],
      base: "very.co.uk",
      ore: {
        availability: "//meta[@property='product:availability']/@content",
        barcode: "//strong[contains(text(), 'EAN')]/following-sibling::text()",
        cost: "//meta[@itemprop='price']/@content",
        currency: "//meta[@itemprop='priceCurrency']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      },
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      }
    },
    {
      id: "victoriassecret",
      category_tags: [
        "clothing"
      ],
      base: "victoriassecret.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)\\"
      ],
      ore: {
        cost: "//span[@class='prism-danger-zone']//text()",
        delivery: "//div[data-testid='ReturnOptions']//text()",
        title: "//div[@data-testid='ProductInfo-shortDescription']/span/text()"
      },
      scout: {
        path: "/us/vs/search?q={{query}}",
        items: "//div[@data-testid='StandardProductCardGrid']/div",
        ore: {
          cost: ".//div[@data-testid='ProductCardPrice']//text()",
          image: ".//picture//source/@srcset",
          title: './/div[contains(@class,"product-card-body-item")]//a/@name',
          url: './/div[contains(@class,"product-card-body-item")]//a/@href'
        }
      }
    },
    {
      id: "videoandaudiocenter",
      name: "videoandaudiocenter",
      category_tags: [
        "electronics"
      ],
      base: "videoandaudiocenter.com",
      paths: [
        "\\/(?<identifier>[^/]+)"
      ],
      ore: {
        availability: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.availability',
        barcode: [
          'json||||script[type="text/javascript"]:nth-of-type(9)||||product_attributes.upc',
          "//dt[contains(@class, 'upc-label')]/following-sibling::dd[1]"
        ],
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(9)||||product_attributes.price.without_tax.formatted',
          "//span[contains(@class, 'price-now-label')]/following-sibling::span[contains(@class, 'price--withoutTax')]/text()"
        ],
        currency: [
          'json||||script[type="text/javascript"]:nth-of-type(9)||||product_attributes.price.saved.currency',
          "//meta[@property='product:price:currency']/@content"
        ],
        model: "//dd[@class='productView-info-value productView-sku-value']/text()",
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(9)||||product_attributes.sku',
          "//dd[contains(@class, 'productView-sku-value')]/text()"
        ]
      }
    },
    {
      id: "vipoutlet",
      name: "vipoutlet",
      base: "vipoutlet.com",
      paths: [
        "/product/(?<identifier>[^/]+)/"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||@graph.1.offers.0.availability',
          "//div[contains(@class, 'out-of-stock-bar')]/text()"
        ],
        barcode: "//div[contains(@class, 'product-properties__item')]/div[contains(@class, 'column shrink product-properties__label') and contains(text(), 'UPC:')]/following-sibling::div[contains(@class, 'column product-properties__value')]/text()",
        cost: 'json||||script[type="application/ld+json"]||||@graph.1.offers.0.priceSpecification.price',
        currency: 'json||||script[type="application/ld+json"]||||@graph.1.offers.0.priceCurrency',
        sku: [
          "//div[contains(@class, 'product-properties__item')]/div[contains(@class, 'column shrink product-properties__label') and contains(text(), 'SKU:')]/following-sibling::div[contains(@class, 'column product-properties__value')]/text()"
        ]
      }
    },
    {
      id: "vitacost",
      name: "Vitacost",
      category_tags: [
        "health-pharmacy"
      ],
      base: "vitacost.com",
      paths: [
        "\\/(?<identifier>[\\w-]+)\\?CSRC",
        "\\?csrc=GPF-(?<identifier>\\d+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "substring-after(//li[starts-with(text(), 'SKU #:')], ': ')",
          "substring-before(normalize-space(substring-after(id('pdTitleBlock')/ul,'SKU #: ')),' ')"
        ],
        cost: [
          "//p[contains(@class, 'pRetailPrice')]/text()",
          'json||||script[type="text/javascript"]:nth-of-type(45)||||products.0.price',
          "//p[contains(@class, 'pOurPrice')]/text()",
          "substring-after(//p[contains(text(),'Retail price:')]/preceding-sibling::*[1],'$')"
        ],
        sku: [
          'json||||script[type="text/javascript"]:nth-of-type(45)||||products.0.sku',
          "substring-after(//li[contains(text(), 'SKU #:')]/text(), 'SKU #:')",
          "substring-before(normalize-space(substring-after(id('pdTitleBlock')/ul,'SKU #: ')),' ')"
        ],
        title: "substring-before(normalize-space(//title/text()),' - Vitacost')",
        availability: [
          "//div[@class='RSTR_TopQtyBuy_Product dashed section']//li[contains(@id, 'atcButtonWrapper')]/input[@value='Add to cart']/@value",
          'json||||script[type="text/javascript"]:nth-of-type(45)||||products.0.inStock'
        ],
        currency: "//p[contains(@class, 'pRetailPrice') and contains(@itemprop, 'price')] | //p[starts-with(normalize-space(text()), 'Our price:')]/text()"
      }
    },
    {
      id: "vitalsource",
      name: "VitalSource",
      category_tags: [
        "books"
      ],
      base: "vitalsource.com",
      paths: [
        "/products/[^-]+-(?<identifier>[^?]+)"
      ],
      scout: null,
      ore: {
        barcode: [
          "//meta[@itemprop='sku']/@content",
          "//span[@itemprop='isbn']"
        ],
        title: "//div[@class='right_sidebar']/h1",
        availability: "//link[@itemprop='availability']/@content",
        cost: "//div[contains(@class, 'total-price')]/text()",
        sku: "//meta[@itemprop='sku']/@content"
      }
    },
    {
      id: "vitaminshoppe",
      name: "Vitamin Shoppe",
      category_tags: [
        "health-pharmacy"
      ],
      base: "vitaminshoppe.com",
      paths: [
        "/\\p\\/.*\\/(?<identifier>[^\\/\\?\\&]+)"
      ],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        brand: "//div[@class='productBrandName']//span",
        cost: "//span[@itemprop='price']",
        sku: "substring-after(substring-after(//meta[@property='og:url']/@content,'p/'),'/')",
        title: "concat(//div[@class='productBrandName']//span,' ', normalize-space(//h1[@itemprop='name']))"
      }
    },
    {
      id: "walgreens",
      category_tags: [
        "electronics",
        "appliances"
      ],
      base: "walgreens.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[a-z0-9]+)"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.0.availability'
        ],
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin'
        ],
        cost: [
          "json||||script:nth-of-type(28)||||product.results.priceInfo.regularPrice",
          "//span[@class='product__price']//text()"
        ],
        delivery: "//div[@aria-labelledby='shipment-details']//text()",
        title: "//span[@id='productTitle']//text()",
        sku: "json||||script:nth-of-type(28)||||product.results.productInfo.dsSkuId"
      },
      scout: {
        path: "https://www.walgreens.com/search/results.jsp?Ntt={{query}}",
        items: "//ul[@class='product-container']/li",
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: './/span[contains(@class,"product__price")]/text()',
          image: './/figure[@class="product__img"]/img/@src',
          title: './/strong[@class="description"]//text()',
          url: './/div[@class="product__text"]//a/@href'
        }
      }
    },
    {
      id: "walmart",
      name: "Walmart",
      category_tags: [
        "sells-everything"
      ],
      base: "www.walmart.com",
      paths: [
        "(.*)?\\/ip\\/(?:[^\\/])+\\/(?<identifier>\\w+)",
        "(.*)?\\/ip\\/.*\\/(?<identifier>[0-9]+).*",
        "(.*)?\\/ip\\/(?<identifier>[0-9]+).*",
        "\\/ip\\/(?<identifier>.+)"
      ],
      inject: [
        {
          id: "button-watch",
          selectors: [
            {
              selector: "*[data-testid='price-wrap']",
              at: "afterend"
            }
          ]
        }
      ],
      observe: [
        {
          selector: "h1[itemprop='name']"
        }
      ],
      ore: {
        availability: [
          "json||||#__NEXT_DATA__||||props.pageProps.initialData.data.product.fulfillmentOptions.0.availabilityStatus",
          "verb-miner-function-walmart-ore-json:offers.0.availability"
        ],
        brand: "verb-miner-function-walmart-ore-json:brand.name",
        barcode: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||gtin13',
          "verb-miner-function-walmart-ore-json:gtin13"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.price',
          "//div[@data-automation-id='product-price']/div[contains(@class, 'b')]/text()",
          '.buy-box-container [data-testid="price-wrap"] [itemprop="price"]:first',
          '.items-baseline [itemprop="price"]:first',
          "verb-miner-function-walmart-ore-json:offers.0.price",
          "//span[contains(@class, 'inline-flex')]/span[@itemprop='price']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||offers.priceCurrency',
          "//span[@itemprop='priceCurrency']/text()",
          "verb-miner-function-walmart-ore-json:offers.0.priceCurrency"
        ],
        image: "verb-miner-function-walmart-ore-json:image",
        model: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||model',
          "verb-miner-function-walmart-ore-json:model"
        ],
        sku: [
          'json||||script[type="application/ld+json"]:nth-of-type(1)||||sku',
          "verb-miner-function-walmart-ore-json:sku"
        ],
        title: "verb-miner-function-walmart-ore-json:name",
        url: [
          "link[rel='canonical']||||href",
          "verb-miner-function-walmart-ore-json:offers.0.url"
        ]
      },
      scout: {
        path: "/search/?query={{query}}",
        items: [
          ".search-result-listview-item",
          "ul.search-result-gridview-items li"
        ],
        queries: "verb-miner-function-walmart-scout-queries",
        ore: {
          request: {
            headers: {
              "user-agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.2.1 Safari/605.1.15"
            }
          },
          image: ".search-result-productimage img||||src",
          title: ".search-result-product-title a span",
          url: ".search-result-product-title a||||href"
        }
      },
      mine: "verb-miner-function-walmart-mine"
    },
    {
      id: "wayfair",
      name: "Wayfair",
      category_tags: [
        "home-garden"
      ],
      base: "wayfair.com",
      paths: [
        ".*\\/(?<identifier>.+)\\/"
      ],
      pathsComments: [
        "wayfair has gross URLs with no real product ids except for a pathname",
        "the entire pathname is the only thing that works to pull up a product, no shortcuts found",
        "/furniture/pdp/august-grove-malcolm-solid-wood-dining-chair-atgr1049.html?piid=17610693"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          "(//div[@data-enzyme-id='PriceBlock']//div[@class='sc-1b0ahtz-0 gekUVm'])[2]",
          ".ShippingHeadline-text"
        ],
        barcode: "//meta[@property='og:upc']/@content",
        brand: [
          "//a[@data-enzyme-id='pdp-title-block-manufacturer-name']",
          "a[data-click-location='manufacturer_link']"
        ],
        cost: [
          "(//div[@data-enzyme-id='PriceBlock']//span)[1]",
          "//div[@class='StandardPriceBlock']//span[@class='notranslate']"
        ],
        costDelivery: "//div[@class='DeliveryView']//span[@class='ShippingHeadline-text']",
        delivery: "//div[@class='DeliveryView']//p[@class='DeliveryView-shipping-leadTime']/span",
        mpn: "substring(substring-before(substring-after(//script[contains(text(),'partNumberToShow')],'partNumberToShow'),','),4,string-length(substring-before(substring-after(//script[contains(text(),'partNumberToShow')],'partNumberToShow'),','))-4)",
        title: [
          "//header[@class='ProductDetailInfoBlock-header']//h1",
          "substring-before(//title,' &')"
        ]
      },
      scout: {
        path: "/keyword.php?keyword={{query}}",
        items: ".//div[contains(@class,'pl-Grid-item')]",
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: ".//div[@class='SFPrice']/span[@font-size='3000']",
          image: ".//img[@data-hb-id='FluidImage']",
          title: ".//h2[@class='pl-ProductCardName']/span",
          url: ".//a[@class='pl-ProductCard-productCardElement']/@href"
        }
      }
    },
    {
      id: "webstaurant",
      name: "The Webstaurant Store",
      category_tags: [
        "home-garden"
      ],
      base: "webstaurantstore.com",
      paths: [],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        barcode: "substring-before(normalize-space(substring-after(id('page'),'UPC Code:')),' ')",
        brand: "//img[contains(@alt,'View All Products')]/parent::a/@title",
        cost: "//span[@itemprop='price']",
        mpn: "substring-after(//span[@class='mfr-number suffix_meta'],'#')",
        sku: "substring-before(substring-after(substring-after(//link[@rel='canonical']/@href,'.com/'),'/'),'.')",
        title: "//h1[@itemprop='Name']"
      }
    },
    {
      id: "wegmans",
      name: "Wegmans Food Markets",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "shop.wegmans.com"
      },
      paths: [
        "/shop/categories/(?<identifier>[0-9]+)",
        "/shop/products/(?<identifier>[0-9]+)",
        "/product/(?<identifier>[0-9]+)"
      ],
      ore: {
        title: [
          'h1[data-testid="product-title"]',
          ".product-title",
          "h1.product-name",
          'json||||script[type="application/ld+json"]||||name'
        ],
        cost: [
          "verb-miner-function-wegmans-ore-price",
          ".price-current",
          '[data-testid="current-price"]',
          'json||||script[type="application/ld+json"]||||offers.price'
        ],
        availability: [
          "verb-miner-function-wegmans-ore-availability",
          '[data-testid="availability"]',
          ".availability-status",
          'json||||script[type="application/ld+json"]||||offers.availability'
        ],
        images: [
          "verb-miner-function-wegmans-ore-images",
          ".product-image img",
          '[data-testid="product-image"] img'
        ],
        barcode: [
          "verb-miner-function-wegmans-ore-barcode",
          '[data-testid="upc"]',
          ".product-upc"
        ],
        brand: [
          ".product-brand",
          '[data-testid="brand"]',
          'json||||script[type="application/ld+json"]||||brand.name'
        ],
        manufacturer: [
          ".product-manufacturer",
          '[data-testid="manufacturer"]'
        ],
        currency: [
          "USD"
        ]
      },
      "brick-and-mortar": "verb-miner-function-wegmans-brick-and-mortar",
      scout: "verb-miner-function-wegmans-scout"
    },
    {
      id: "westmarine",
      name: "West Marine",
      category_tags: [
        "sports-outdoors"
      ],
      base: "westmarine.com",
      paths: [
        "\\/(?<identifier>[\\w-]+)\\.html"
      ],
      scout: null,
      ore: {
        barcode: [
          "substring-after(//span[@class='product-upc'],'# ')"
        ],
        brand: "//span[@class='title-brand']",
        cost: [
          'json||||script[type="text/javascript"]:nth-of-type(13)||||events.0.ecommerce.detail.products.0.price',
          "//meta[@property='og:product:price:amount']/@content",
          "normalize-space(//p[@class='promo price bigger'] | //p[@class='regularPrice bigger'])"
        ],
        mpn: [
          "//span[@class='product-mfg-id']/text()",
          "substring-after(//span[@class='product-manufno'],'#')"
        ],
        sku: [
          "//span[@class='product-id']/text()",
          "substring-after(//span[@class='product-modelno'],'#')"
        ],
        title: "normalize-space(substring-before(//title,'|'))",
        availability: [
          'json||||script[type="text/javascript"]:nth-of-type(13)||||events.0.ecommerce.detail.products.0.dimension21',
          "//div[@id='waitlist']//span[contains(@class, 'waitlist-title')]/text()"
        ],
        currency: 'json||||script[type="text/javascript"]:nth-of-type(13)||||events.0.ecommerce.currencyCode',
        model: 'json||||script[type="text/javascript"]:nth-of-type(13)||||events.0.ecommerce.detail.products.0.dimension14'
      }
    },
    {
      id: "wiggle",
      name: "wiggle",
      category_tags: [
        "sports-outdoors"
      ],
      paths: [
        "/p/(?<identifier>[\\w-]+)$"
      ],
      base: "wiggle.com",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.offers.0.0.availability',
          "//button[@data-testid='Product-action-button']"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.offers.0.0.price',
          "//p[@data-testid='product-price']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.priceCurrency'
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||sku'
      }
    },
    {
      id: "wilson",
      name: "wilson",
      category_tags: [
        "sports-outdoors"
      ],
      base: "wilson.com",
      paths: [
        "/product/(?<identifier>[^/]+)\\?"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.0.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.0.price',
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          "json||||script:nth-of-type(36)||||currencyCode",
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        model: "substring-before(//meta[@name='at-model-number']/@content, '$')",
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn',
          "//div[contains(@class, 'product-detail_specifications')]/table/thead/tr/th[text()='Model Number']/following-sibling::td/div/text()"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku'
        ]
      }
    },
    {
      id: "wincofoods",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "wincofoods.com"
      },
      paths: [
        "/search\\?q=(?<identifier>[^&]+)",
        "/site-search\\?query=(?<identifier>[^&]+)",
        "/shop-our-brand/(?<identifier>[^/]+)",
        "/lists/item/(?<identifier>[^/]+)",
        "/product/(?<identifier>[^/]+)",
        "/products/(?<identifier>[^/]+)"
      ],
      mine: "verb-miner-function-wincofoods-mine",
      ore: {
        brick_and_mortar: "verb-miner-function-wincofoods-ore-brick-and-mortar",
        cost: [
          ".price",
          ".product-price",
          "[data-price]",
          'meta[property="product:price:amount"]@content'
        ],
        availability: [
          ".availability",
          ".in-stock",
          "[data-availability]",
          'meta[property="product:availability"]@content'
        ],
        title: [
          "h1.product-title",
          ".product-name",
          "h1",
          'meta[property="og:title"]@content'
        ]
      },
      scout: "verb-miner-function-wincofoods-scout",
      notes: [
        "Optimized for mobile app context: regional mobile ip strategy"
      ]
    },
    {
      id: "wine",
      category_tags: [
        "grocery-food"
      ],
      base: {
        "*-us": "wine.com",
        keyCountry: "coaltrainwine.com"
      },
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)"
      ],
      ore: {
        request: {
          headers: {
            connection: "keep-alive"
          }
        },
        availability: [
          "json||||#product-metadata||||offers.availability",
          "//meta[@property='product:availability']/@content",
          "//meta[@name='ProductAvailability']/@content"
        ],
        barcode: "//meta[@name='productID']/@content",
        brand: `substring-after('"brand":"','')`,
        cost: [
          "json||||#product-metadata||||offers.price",
          "//meta[@property='product:price:amount']/@content",
          "//span[@class='productPrice_price-sale']//text()"
        ],
        delivery: "//div[@class='prodItemStock_status']//text()",
        mpn: "//meta[@name='pProductID']/@content",
        title: "//h1[@class='pipName']/text()",
        currency: [
          "json||||#product-metadata||||offers.priceCurrency",
          "//meta[@property='product:price:currency']/@content"
        ],
        sku: [
          "json||||#product-metadata||||sku"
        ]
      },
      scout: {
        path: "/search/{{query}}/0",
        items: './/ul[@class="prodList"]/li',
        ore: {
          request: {
            headers: {
              connection: "keep-alive"
            }
          },
          cost: './/span[@class="productPrice_price-regWhole"]/text()',
          image: './/picture[@class="prodItemImage_image"]//img/@src',
          title: './/span[@class="prodItemInfo_name"]/@title',
          url: './/a[@class="prodItemInfo_link event_productClick"]/@href'
        }
      }
    },
    {
      id: "wineanthology",
      name: "wineanthology",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/product/(?<identifier>\\d+)"
      ],
      base: "wineanthology.com",
      ore: {
        availability: "//div[contains(@class, 'product_page_availability')]/text()",
        barcode: "//meta[@itemprop='gtin13']/@content",
        cost: "//td[@class='wa_sale_price']/text()",
        mpn: "//meta[@itemprop='mpn']/@content",
        sku: "//meta[@itemprop='sku']/@content"
      }
    },
    {
      id: "womanwithin",
      category_tags: [
        "clothing"
      ],
      base: "womanwithin.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[0-9]+)\\.html"
      ],
      ore: {
        availability: [
          'json||||script[type="yo/sequence/chain/1"]:nth-of-type(19)||||product_item_status.0',
          "//div[contains(@class, 'availability')]/@data-available"
        ],
        cost: [
          "//div[contains(@class, 'prices')]/div[@class='price']//span[contains(@class, 'value')]/text()",
          "//div[@class='price']//text()"
        ],
        delivery: "//div[@id='shippingAccordion']//text()",
        mpn: [
          'json||||script[type="yo/sequence/chain/1"]:nth-of-type(19)||||product_item_id.0'
        ],
        title: "//h1[@class='product-name mb-0']//text()",
        sku: [
          'json||||script[type="yo/sequence/chain/1"]:nth-of-type(19)||||product_sku.0',
          "//span[contains(@class, 'product-variant-id')]/text()"
        ],
        currency: "json||||#globale-script-loader-data||||currency"
      },
      scout: {
        path: "/search?q={{query}}",
        items: './/div[@class="row product-grid"]/div',
        ore: {
          cost: './/span[@class="price-product-sales-price d-inline-flex"]//text()',
          image: './/img[contains(@class,"tile-image")]/@src',
          title: './/div[@class="pdp-link my-2"]//text()',
          url: './/div[@class="pdp-link my-2"]/a/@href'
        }
      }
    },
    {
      id: "woolworths",
      name: "woolworths",
      category_tags: [
        "grocery-food"
      ],
      paths: [
        "/shop/productdetails/(?<identifier>\\d+)"
      ],
      base: "www.woolworths.com.au",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          "//span[contains(text(), 'Add to cart') or contains(text(),'out of stock')]/text()"
        ],
        barcode: 'json||||script[type="application/ld+json"]||||gtin13',
        cost: 'json||||script[type="application/ld+json"]||||offers.price',
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ],
        sku: 'json||||script[type="application/ld+json"]||||sku'
      }
    },
    {
      id: "wordery",
      name: "Wordery",
      category_tags: [
        "books"
      ],
      base: "wordery.com",
      paths: [],
      scout: {
        path: "/search?q={{query}}",
        items: ".product-item"
      },
      ore: {
        barcode: [
          "//meta[@property='book:isbn']/@content",
          "//span[@itemprop='isbn']"
        ],
        cost: [
          "//strong[contains(@class, 'u-fs--ex')]/text()",
          "//meta[@itemprop='priceCurrency']/following-sibling::strong"
        ],
        title: "//h1[@itemprop='name']",
        availability: "//a[contains(@href, '#about-out-of-stock-items')]/text()"
      }
    },
    {
      id: "worldwidegolfshops",
      name: "worldwidegolfshops",
      category_tags: [
        "sports-outdoors"
      ],
      base: "worldwidegolfshops.com",
      paths: [
        "\\/p\\?idsku=(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.offers.0.availability',
          "//meta[@property='product:availability']/@content"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.offers.0.price',
          "//meta[@property='product:price:amount']/@content"
        ],
        currency: [
          "//meta[@name='currency']/@content"
        ]
      }
    },
    {
      id: "wowma",
      name: "wowma",
      paths: [
        "/item/(?<identifier>\\d+)"
      ],
      base: "wowma.jp",
      ore: {
        availability: "json||||#json-ld||||offers.availability",
        cost: "json||||#json-ld||||offers.price",
        sku: "json||||#__NEXT_DATA__||||props.pageProps.initialState.itemDetails.itemPageInfo.itemInfo.lotNumber"
      }
    },
    {
      id: "yahoo",
      name: "Yahoo Shopping Japan",
      paths: [
        "/([^/]+?)/(?<identifier>[\\w+]+)\\.html",
        "/search/(?<identifier>[\\w\\-]+)",
        "/item/(?<identifier>[\\w\\-]+)"
      ],
      base: "store.shopping.yahoo.co.jp",
      scout: {
        path: "https://search.shopping.yahoo.co.jp/search?p={{query}}",
        items: [
          ".result .Product",
          ".searchResult .item",
          ".product-item",
          ".item-card"
        ],
        ore: {
          title: [
            ".Product-title a",
            ".item-title",
            ".product-name a",
            "h3 a",
            'json||||script[type="application/ld+json"]||||name'
          ],
          cost: [
            ".Product-price .price",
            ".price-current",
            ".item-price",
            'json||||script[type="application/ld+json"]||||offers.price',
            "//meta[@itemprop='price']/@content"
          ],
          url: [
            ".Product-title a||||href",
            ".item-title a||||href",
            ".product-name a||||href",
            "h3 a||||href"
          ],
          image: [
            ".Product-image img||||src",
            ".item-image img||||src",
            ".product-image img||||src",
            "img[src*='shopping.c.yimg.jp']||||src"
          ],
          availability: [
            ".Product-stock",
            ".stock-status",
            ".availability",
            'json||||script[type="application/ld+json"]||||offers.availability'
          ],
          brand: [
            ".Product-brand",
            ".brand-name",
            ".item-brand"
          ]
        }
      },
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability',
          ".stock-status",
          ".availability-status",
          "//span[contains(@class, 'stock')]"
        ],
        barcode: [
          'json||||script[type="application/ld+json"]||||gtin13',
          'json||||script[type="application/ld+json"]||||gtin',
          "//meta[@property='product:isbn']/@content",
          "//span[contains(text(), 'JAN')]/following-sibling::span",
          "//td[contains(text(), 'JAN')]/following-sibling::td"
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//meta[@itemprop='price']/@content",
          ".price-current",
          ".product-price .price",
          "//span[contains(@class, 'price')]"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          "//meta[@itemprop='priceCurrency']/@content"
        ],
        title: [
          'json||||script[type="application/ld+json"]||||name',
          "h1.product-title",
          "h1.item-title",
          ".product-name h1",
          "//meta[@property='og:title']/@content",
          "//title"
        ],
        image: [
          'json||||script[type="application/ld+json"]||||image',
          "//meta[@property='og:image']/@content",
          ".product-image img||||src",
          ".main-image img||||src",
          ".item-image img||||src",
          "img[src*='shopping.c.yimg.jp']||||src"
        ],
        brand: [
          'json||||script[type="application/ld+json"]||||brand.name',
          'json||||script[type="application/ld+json"]||||manufacturer.name',
          ".product-brand",
          ".brand-name",
          "//meta[@property='product:brand']/@content",
          "//span[contains(text(), 'ブランド')]/following-sibling::span",
          "//td[contains(text(), 'ブランド')]/following-sibling::td"
        ],
        condition: [
          'json||||script[type="application/ld+json"]||||offers.itemCondition',
          ".product-condition",
          ".item-condition",
          "//span[contains(text(), '状態')]/following-sibling::span",
          "//td[contains(text(), '状態')]/following-sibling::td"
        ],
        model: [
          'json||||script[type="application/ld+json"]||||model',
          ".product-model",
          ".model-number",
          "//meta[@property='product:model']/@content",
          "//span[contains(text(), 'モデル')]/following-sibling::span",
          "//td[contains(text(), 'モデル')]/following-sibling::td",
          "//span[contains(text(), '型番')]/following-sibling::span",
          "//td[contains(text(), '型番')]/following-sibling::td"
        ],
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn',
          ".manufacturer-part-number",
          ".mpn",
          "//meta[@property='product:mpn']/@content",
          "//span[contains(text(), 'MPN')]/following-sibling::span",
          "//td[contains(text(), 'MPN')]/following-sibling::td",
          "//span[contains(text(), '部品番号')]/following-sibling::span"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//meta[@property='product:sku']/@content",
          ".product-sku",
          ".sku-code",
          "//span[contains(text(), 'SKU')]/following-sibling::span",
          "//td[contains(text(), 'SKU')]/following-sibling::td",
          "//span[contains(text(), '商品コード')]/following-sibling::span"
        ],
        rating: [
          'json||||script[type="application/ld+json"]||||aggregateRating.ratingValue',
          ".product-rating .rating-value",
          ".review-rating",
          "//meta[@property='product:rating']/@content"
        ],
        category: [
          'json||||script[type="application/ld+json"]||||category',
          "string-join(.breadcrumb a, ' > ')",
          "string-join(.breadcrumbs a, ' > ')",
          "string-join(.navigation-path a, ' > ')"
        ]
      }
    },
    {
      id: "yahoo",
      name: "yahoo",
      paths: [
        "/([^/]+?)/(?<identifier>[\\w+]+)\\.html"
      ],
      base: "store.shopping.yahoo.co.jp",
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability'
        ],
        barcode: 'json||||script[type="application/ld+json"]||||gtin13',
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//meta[@itemprop='price']/@content"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency',
          "//meta[@itemprop='priceCurrency']/@content"
        ]
      }
    },
    {
      id: "yesstyle",
      name: "yesstyle",
      category_tags: [
        "clothing"
      ],
      base: "yesstyle.com",
      paths: [
        "/info\\.html/pid\\.(?<identifier>\\d+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.availability',
          "//span[contains(@class, 'buyOptions_option-additional-info')]/text()"
        ],
        cost: [
          'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.price',
          "//span[@class='productDetailPage_sellingPrice__s6PZu']/text()"
        ],
        currency: [
          "json||||#__NEXT_DATA__||||props.pageProps.basic.currencyName"
        ],
        sku: 'json||||script[type="application/ld+json"]:nth-of-type(2)||||offers.0.sku'
      }
    },
    {
      id: "zoro",
      name: "Zoro",
      category_tags: [
        "office-supplies"
      ],
      base: "zoro.com",
      paths: [
        "\\/(.+)\\/([^\\/]+?)\\/(?<identifier>[A-Z0-9]+)"
      ],
      ore: {
        availability: [
          'json||||script[type="application/ld+json"]||||offers.availability'
        ],
        cost: [
          'json||||script[type="application/ld+json"]||||offers.price',
          "//div[contains(@class, 'product-price-container')]/div[@data-za='product-price']/text()",
          "//div[@class='product-price-container d-flex align-end inline']/div[@data-za='product-price' and @class='price font-weight-bold text-h2']/text()",
          "//span[@class='product__price']//text()"
        ],
        delivery: "//div[@class='shipping-info mb-3']//text()",
        mpn: [
          'json||||script[type="application/ld+json"]||||mpn',
          "//span[contains(@data-za, 'PDPMfrNo')]/text()",
          "//div[contains(@class, 'product-spec-info')]//span[text()='MFR #']/following-sibling::div[@class='value text-body-1 pl-2']/text()"
        ],
        title: "//h1[@data-za='product-name']//text()",
        barcode: [
          'json||||script[type="application/ld+json"]||||gtin12',
          "//span[contains(@class, 'text-body-1 font-weight-bold') and contains(text(), 'UPC #')]/following-sibling::div[@class='value text-body-1 pl-2']",
          "//span[contains(text(), 'UPC #')]/following-sibling::div[@class='value text-body-1 pl-2']/text()"
        ],
        model: [
          "//li[contains(@class, 'pa-2')]/div/span[text()='MFR #']/following-sibling::div[@class='value text-body-1 pl-2']/text()"
        ],
        sku: [
          'json||||script[type="application/ld+json"]||||sku',
          "//li[contains(@class, 'pa-2')]/div/span[text()='Zoro #']/following-sibling::div[@class='value text-body-1 pl-2']/text()"
        ],
        currency: [
          'json||||script[type="application/ld+json"]||||offers.priceCurrency'
        ]
      },
      scout: {
        path: "https://www.zoro.com/search?q={{query}}",
        items: "//div[@class='row search-results']/div",
        ore: {
          cost: './/span[@data-za="product-price"]/img/@src',
          image: './/div[@class="v-image__image v-image__image--cover"]/@style',
          title: './/strong[@class="description"]//text()',
          url: './/div[@class="product-title"]//a/@title'
        }
      }
    }
  ];
}

// src/prospector/noun-prospector.ts
var import_config, minerDefinitions, nounProspectorGlobal;
var init_noun_prospector = __esm(() => {
  import_config = __toESM(require_config(), 1);
  minerDefinitions = verbMinerDefinitionsGetAll();
  nounProspectorGlobal = {
    config: import_config.default.configUserDefault,
    expeditions: {},
    retailerAllowedDomains: [],
    portsPickaxe: {},
    callbacksPickaxeMessages: {},
    cachedMinerDefinitions: minerDefinitions,
    cachedIdentifiersAggregators: minerDefinitions?.map((d) => d?.["is-aggregator"] ? d?.id : null).filter((d) => !!d),
    sifterCallbacks: {},
    storageHTML: {},
    routinesAttemptedRegistry: new Map,
    medalStandWebSockets: new Map
  };
});

// ../node_modules/@firebase/util/dist/index.esm2017.js
function getGlobal() {
  if (typeof self !== "undefined") {
    return self;
  }
  if (typeof window !== "undefined") {
    return window;
  }
  if (typeof global !== "undefined") {
    return global;
  }
  throw new Error("Unable to locate global object.");
}

class Deferred {
  constructor() {
    this.reject = () => {};
    this.resolve = () => {};
    this.promise = new Promise((resolve, reject) => {
      this.resolve = resolve;
      this.reject = reject;
    });
  }
  wrapCallback(callback) {
    return (error, value) => {
      if (error) {
        this.reject(error);
      } else {
        this.resolve(value);
      }
      if (typeof callback === "function") {
        this.promise.catch(() => {});
        if (callback.length === 1) {
          callback(error);
        } else {
          callback(error, value);
        }
      }
    };
  }
}
function getUA() {
  if (typeof navigator !== "undefined" && typeof navigator["userAgent"] === "string") {
    return navigator["userAgent"];
  } else {
    return "";
  }
}
function isMobileCordova() {
  return typeof window !== "undefined" && !!(window["cordova"] || window["phonegap"] || window["PhoneGap"]) && /ios|iphone|ipod|ipad|android|blackberry|iemobile/i.test(getUA());
}
function isBrowserExtension() {
  const runtime = typeof chrome === "object" ? chrome.runtime : typeof browser === "object" ? browser.runtime : undefined;
  return typeof runtime === "object" && runtime.id !== undefined;
}
function isReactNative() {
  return typeof navigator === "object" && navigator["product"] === "ReactNative";
}
function isIE() {
  const ua = getUA();
  return ua.indexOf("MSIE ") >= 0 || ua.indexOf("Trident/") >= 0;
}
function isIndexedDBAvailable() {
  try {
    return typeof indexedDB === "object";
  } catch (e) {
    return false;
  }
}
function validateIndexedDBOpenable() {
  return new Promise((resolve, reject) => {
    try {
      let preExist = true;
      const DB_CHECK_NAME = "validate-browser-context-for-indexeddb-analytics-module";
      const request = self.indexedDB.open(DB_CHECK_NAME);
      request.onsuccess = () => {
        request.result.close();
        if (!preExist) {
          self.indexedDB.deleteDatabase(DB_CHECK_NAME);
        }
        resolve(true);
      };
      request.onupgradeneeded = () => {
        preExist = false;
      };
      request.onerror = () => {
        var _a;
        reject(((_a = request.error) === null || _a === undefined ? undefined : _a.message) || "");
      };
    } catch (error) {
      reject(error);
    }
  });
}

class ErrorFactory {
  constructor(service, serviceName, errors) {
    this.service = service;
    this.serviceName = serviceName;
    this.errors = errors;
  }
  create(code, ...data) {
    const customData = data[0] || {};
    const fullCode = `${this.service}/${code}`;
    const template = this.errors[code];
    const message = template ? replaceTemplate(template, customData) : "Error";
    const fullMessage = `${this.serviceName}: ${message} (${fullCode}).`;
    const error = new FirebaseError(fullCode, fullMessage, customData);
    return error;
  }
}
function replaceTemplate(template, data) {
  return template.replace(PATTERN, (_, key) => {
    const value = data[key];
    return value != null ? String(value) : `<${key}?>`;
  });
}
function isEmpty(obj) {
  for (const key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      return false;
    }
  }
  return true;
}
function deepEqual(a, b) {
  if (a === b) {
    return true;
  }
  const aKeys = Object.keys(a);
  const bKeys = Object.keys(b);
  for (const k of aKeys) {
    if (!bKeys.includes(k)) {
      return false;
    }
    const aProp = a[k];
    const bProp = b[k];
    if (isObject(aProp) && isObject(bProp)) {
      if (!deepEqual(aProp, bProp)) {
        return false;
      }
    } else if (aProp !== bProp) {
      return false;
    }
  }
  for (const k of bKeys) {
    if (!aKeys.includes(k)) {
      return false;
    }
  }
  return true;
}
function isObject(thing) {
  return thing !== null && typeof thing === "object";
}
function querystring(querystringParams) {
  const params = [];
  for (const [key, value] of Object.entries(querystringParams)) {
    if (Array.isArray(value)) {
      value.forEach((arrayVal) => {
        params.push(encodeURIComponent(key) + "=" + encodeURIComponent(arrayVal));
      });
    } else {
      params.push(encodeURIComponent(key) + "=" + encodeURIComponent(value));
    }
  }
  return params.length ? "&" + params.join("&") : "";
}
function querystringDecode(querystring2) {
  const obj = {};
  const tokens = querystring2.replace(/^\?/, "").split("&");
  tokens.forEach((token) => {
    if (token) {
      const [key, value] = token.split("=");
      obj[decodeURIComponent(key)] = decodeURIComponent(value);
    }
  });
  return obj;
}
function extractQuerystring(url) {
  const queryStart = url.indexOf("?");
  if (!queryStart) {
    return "";
  }
  const fragmentStart = url.indexOf("#", queryStart);
  return url.substring(queryStart, fragmentStart > 0 ? fragmentStart : undefined);
}
function createSubscribe(executor, onNoObservers) {
  const proxy = new ObserverProxy(executor, onNoObservers);
  return proxy.subscribe.bind(proxy);
}

class ObserverProxy {
  constructor(executor, onNoObservers) {
    this.observers = [];
    this.unsubscribes = [];
    this.observerCount = 0;
    this.task = Promise.resolve();
    this.finalized = false;
    this.onNoObservers = onNoObservers;
    this.task.then(() => {
      executor(this);
    }).catch((e) => {
      this.error(e);
    });
  }
  next(value) {
    this.forEachObserver((observer) => {
      observer.next(value);
    });
  }
  error(error) {
    this.forEachObserver((observer) => {
      observer.error(error);
    });
    this.close(error);
  }
  complete() {
    this.forEachObserver((observer) => {
      observer.complete();
    });
    this.close();
  }
  subscribe(nextOrObserver, error, complete) {
    let observer;
    if (nextOrObserver === undefined && error === undefined && complete === undefined) {
      throw new Error("Missing Observer.");
    }
    if (implementsAnyMethods(nextOrObserver, [
      "next",
      "error",
      "complete"
    ])) {
      observer = nextOrObserver;
    } else {
      observer = {
        next: nextOrObserver,
        error,
        complete
      };
    }
    if (observer.next === undefined) {
      observer.next = noop;
    }
    if (observer.error === undefined) {
      observer.error = noop;
    }
    if (observer.complete === undefined) {
      observer.complete = noop;
    }
    const unsub = this.unsubscribeOne.bind(this, this.observers.length);
    if (this.finalized) {
      this.task.then(() => {
        try {
          if (this.finalError) {
            observer.error(this.finalError);
          } else {
            observer.complete();
          }
        } catch (e) {}
        return;
      });
    }
    this.observers.push(observer);
    return unsub;
  }
  unsubscribeOne(i) {
    if (this.observers === undefined || this.observers[i] === undefined) {
      return;
    }
    delete this.observers[i];
    this.observerCount -= 1;
    if (this.observerCount === 0 && this.onNoObservers !== undefined) {
      this.onNoObservers(this);
    }
  }
  forEachObserver(fn) {
    if (this.finalized) {
      return;
    }
    for (let i = 0;i < this.observers.length; i++) {
      this.sendOne(i, fn);
    }
  }
  sendOne(i, fn) {
    this.task.then(() => {
      if (this.observers !== undefined && this.observers[i] !== undefined) {
        try {
          fn(this.observers[i]);
        } catch (e) {
          if (typeof console !== "undefined" && console.error) {
            console.error(e);
          }
        }
      }
    });
  }
  close(err) {
    if (this.finalized) {
      return;
    }
    this.finalized = true;
    if (err !== undefined) {
      this.finalError = err;
    }
    this.task.then(() => {
      this.observers = undefined;
      this.onNoObservers = undefined;
    });
  }
}
function implementsAnyMethods(obj, methods) {
  if (typeof obj !== "object" || obj === null) {
    return false;
  }
  for (const method of methods) {
    if (method in obj && typeof obj[method] === "function") {
      return true;
    }
  }
  return false;
}
function noop() {}
function getModularInstance(service) {
  if (service && service._delegate) {
    return service._delegate;
  } else {
    return service;
  }
}
var stringToByteArray$1 = function(str) {
  const out = [];
  let p = 0;
  for (let i = 0;i < str.length; i++) {
    let c = str.charCodeAt(i);
    if (c < 128) {
      out[p++] = c;
    } else if (c < 2048) {
      out[p++] = c >> 6 | 192;
      out[p++] = c & 63 | 128;
    } else if ((c & 64512) === 55296 && i + 1 < str.length && (str.charCodeAt(i + 1) & 64512) === 56320) {
      c = 65536 + ((c & 1023) << 10) + (str.charCodeAt(++i) & 1023);
      out[p++] = c >> 18 | 240;
      out[p++] = c >> 12 & 63 | 128;
      out[p++] = c >> 6 & 63 | 128;
      out[p++] = c & 63 | 128;
    } else {
      out[p++] = c >> 12 | 224;
      out[p++] = c >> 6 & 63 | 128;
      out[p++] = c & 63 | 128;
    }
  }
  return out;
}, byteArrayToString = function(bytes) {
  const out = [];
  let pos = 0, c = 0;
  while (pos < bytes.length) {
    const c1 = bytes[pos++];
    if (c1 < 128) {
      out[c++] = String.fromCharCode(c1);
    } else if (c1 > 191 && c1 < 224) {
      const c2 = bytes[pos++];
      out[c++] = String.fromCharCode((c1 & 31) << 6 | c2 & 63);
    } else if (c1 > 239 && c1 < 365) {
      const c2 = bytes[pos++];
      const c3 = bytes[pos++];
      const c4 = bytes[pos++];
      const u = ((c1 & 7) << 18 | (c2 & 63) << 12 | (c3 & 63) << 6 | c4 & 63) - 65536;
      out[c++] = String.fromCharCode(55296 + (u >> 10));
      out[c++] = String.fromCharCode(56320 + (u & 1023));
    } else {
      const c2 = bytes[pos++];
      const c3 = bytes[pos++];
      out[c++] = String.fromCharCode((c1 & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
    }
  }
  return out.join("");
}, base64, DecodeBase64StringError, base64Encode = function(str) {
  const utf8Bytes = stringToByteArray$1(str);
  return base64.encodeByteArray(utf8Bytes, true);
}, base64urlEncodeWithoutPadding = function(str) {
  return base64Encode(str).replace(/\./g, "");
}, base64Decode = function(str) {
  try {
    return base64.decodeString(str, true);
  } catch (e) {
    console.error("base64Decode failed: ", e);
  }
  return null;
}, getDefaultsFromGlobal = () => getGlobal().__FIREBASE_DEFAULTS__, getDefaultsFromEnvVariable = () => {
  if (typeof process === "undefined" || typeof process.env === "undefined") {
    return;
  }
  const defaultsJsonString = process.env.__FIREBASE_DEFAULTS__;
  if (defaultsJsonString) {
    return JSON.parse(defaultsJsonString);
  }
}, getDefaultsFromCookie = () => {
  if (typeof document === "undefined") {
    return;
  }
  let match;
  try {
    match = document.cookie.match(/__FIREBASE_DEFAULTS__=([^;]+)/);
  } catch (e) {
    return;
  }
  const decoded = match && base64Decode(match[1]);
  return decoded && JSON.parse(decoded);
}, getDefaults = () => {
  try {
    return getDefaultsFromGlobal() || getDefaultsFromEnvVariable() || getDefaultsFromCookie();
  } catch (e) {
    console.info(`Unable to get __FIREBASE_DEFAULTS__ due to: ${e}`);
    return;
  }
}, getDefaultEmulatorHost = (productName) => {
  var _a, _b;
  return (_b = (_a = getDefaults()) === null || _a === undefined ? undefined : _a.emulatorHosts) === null || _b === undefined ? undefined : _b[productName];
}, getDefaultAppConfig = () => {
  var _a;
  return (_a = getDefaults()) === null || _a === undefined ? undefined : _a.config;
}, getExperimentalSetting = (name) => {
  var _a;
  return (_a = getDefaults()) === null || _a === undefined ? undefined : _a[`_${name}`];
}, ERROR_NAME = "FirebaseError", FirebaseError, PATTERN, MAX_VALUE_MILLIS;
var init_index_esm2017 = __esm(() => {
  base64 = {
    byteToCharMap_: null,
    charToByteMap_: null,
    byteToCharMapWebSafe_: null,
    charToByteMapWebSafe_: null,
    ENCODED_VALS_BASE: "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + "abcdefghijklmnopqrstuvwxyz" + "0123456789",
    get ENCODED_VALS() {
      return this.ENCODED_VALS_BASE + "+/=";
    },
    get ENCODED_VALS_WEBSAFE() {
      return this.ENCODED_VALS_BASE + "-_.";
    },
    HAS_NATIVE_SUPPORT: typeof atob === "function",
    encodeByteArray(input, webSafe) {
      if (!Array.isArray(input)) {
        throw Error("encodeByteArray takes an array as a parameter");
      }
      this.init_();
      const byteToCharMap = webSafe ? this.byteToCharMapWebSafe_ : this.byteToCharMap_;
      const output = [];
      for (let i = 0;i < input.length; i += 3) {
        const byte1 = input[i];
        const haveByte2 = i + 1 < input.length;
        const byte2 = haveByte2 ? input[i + 1] : 0;
        const haveByte3 = i + 2 < input.length;
        const byte3 = haveByte3 ? input[i + 2] : 0;
        const outByte1 = byte1 >> 2;
        const outByte2 = (byte1 & 3) << 4 | byte2 >> 4;
        let outByte3 = (byte2 & 15) << 2 | byte3 >> 6;
        let outByte4 = byte3 & 63;
        if (!haveByte3) {
          outByte4 = 64;
          if (!haveByte2) {
            outByte3 = 64;
          }
        }
        output.push(byteToCharMap[outByte1], byteToCharMap[outByte2], byteToCharMap[outByte3], byteToCharMap[outByte4]);
      }
      return output.join("");
    },
    encodeString(input, webSafe) {
      if (this.HAS_NATIVE_SUPPORT && !webSafe) {
        return btoa(input);
      }
      return this.encodeByteArray(stringToByteArray$1(input), webSafe);
    },
    decodeString(input, webSafe) {
      if (this.HAS_NATIVE_SUPPORT && !webSafe) {
        return atob(input);
      }
      return byteArrayToString(this.decodeStringToByteArray(input, webSafe));
    },
    decodeStringToByteArray(input, webSafe) {
      this.init_();
      const charToByteMap = webSafe ? this.charToByteMapWebSafe_ : this.charToByteMap_;
      const output = [];
      for (let i = 0;i < input.length; ) {
        const byte1 = charToByteMap[input.charAt(i++)];
        const haveByte2 = i < input.length;
        const byte2 = haveByte2 ? charToByteMap[input.charAt(i)] : 0;
        ++i;
        const haveByte3 = i < input.length;
        const byte3 = haveByte3 ? charToByteMap[input.charAt(i)] : 64;
        ++i;
        const haveByte4 = i < input.length;
        const byte4 = haveByte4 ? charToByteMap[input.charAt(i)] : 64;
        ++i;
        if (byte1 == null || byte2 == null || byte3 == null || byte4 == null) {
          throw new DecodeBase64StringError;
        }
        const outByte1 = byte1 << 2 | byte2 >> 4;
        output.push(outByte1);
        if (byte3 !== 64) {
          const outByte2 = byte2 << 4 & 240 | byte3 >> 2;
          output.push(outByte2);
          if (byte4 !== 64) {
            const outByte3 = byte3 << 6 & 192 | byte4;
            output.push(outByte3);
          }
        }
      }
      return output;
    },
    init_() {
      if (!this.byteToCharMap_) {
        this.byteToCharMap_ = {};
        this.charToByteMap_ = {};
        this.byteToCharMapWebSafe_ = {};
        this.charToByteMapWebSafe_ = {};
        for (let i = 0;i < this.ENCODED_VALS.length; i++) {
          this.byteToCharMap_[i] = this.ENCODED_VALS.charAt(i);
          this.charToByteMap_[this.byteToCharMap_[i]] = i;
          this.byteToCharMapWebSafe_[i] = this.ENCODED_VALS_WEBSAFE.charAt(i);
          this.charToByteMapWebSafe_[this.byteToCharMapWebSafe_[i]] = i;
          if (i >= this.ENCODED_VALS_BASE.length) {
            this.charToByteMap_[this.ENCODED_VALS_WEBSAFE.charAt(i)] = i;
            this.charToByteMapWebSafe_[this.ENCODED_VALS.charAt(i)] = i;
          }
        }
      }
    }
  };
  DecodeBase64StringError = class DecodeBase64StringError extends Error {
    constructor() {
      super(...arguments);
      this.name = "DecodeBase64StringError";
    }
  };
  FirebaseError = class FirebaseError extends Error {
    constructor(code, message, customData) {
      super(message);
      this.code = code;
      this.customData = customData;
      this.name = ERROR_NAME;
      Object.setPrototypeOf(this, FirebaseError.prototype);
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, ErrorFactory.prototype.create);
      }
    }
  };
  PATTERN = /\{\$([^}]+)}/g;
  MAX_VALUE_MILLIS = 4 * 60 * 60 * 1000;
});

// ../node_modules/@firebase/app/node_modules/@firebase/component/dist/esm/index.esm2017.js
class Component {
  constructor(name, instanceFactory, type) {
    this.name = name;
    this.instanceFactory = instanceFactory;
    this.type = type;
    this.multipleInstances = false;
    this.serviceProps = {};
    this.instantiationMode = "LAZY";
    this.onInstanceCreated = null;
  }
  setInstantiationMode(mode) {
    this.instantiationMode = mode;
    return this;
  }
  setMultipleInstances(multipleInstances) {
    this.multipleInstances = multipleInstances;
    return this;
  }
  setServiceProps(props) {
    this.serviceProps = props;
    return this;
  }
  setInstanceCreatedCallback(callback) {
    this.onInstanceCreated = callback;
    return this;
  }
}

class Provider {
  constructor(name, container) {
    this.name = name;
    this.container = container;
    this.component = null;
    this.instances = new Map;
    this.instancesDeferred = new Map;
    this.instancesOptions = new Map;
    this.onInitCallbacks = new Map;
  }
  get(identifier) {
    const normalizedIdentifier = this.normalizeInstanceIdentifier(identifier);
    if (!this.instancesDeferred.has(normalizedIdentifier)) {
      const deferred = new Deferred;
      this.instancesDeferred.set(normalizedIdentifier, deferred);
      if (this.isInitialized(normalizedIdentifier) || this.shouldAutoInitialize()) {
        try {
          const instance = this.getOrInitializeService({
            instanceIdentifier: normalizedIdentifier
          });
          if (instance) {
            deferred.resolve(instance);
          }
        } catch (e) {}
      }
    }
    return this.instancesDeferred.get(normalizedIdentifier).promise;
  }
  getImmediate(options) {
    var _a;
    const normalizedIdentifier = this.normalizeInstanceIdentifier(options === null || options === undefined ? undefined : options.identifier);
    const optional = (_a = options === null || options === undefined ? undefined : options.optional) !== null && _a !== undefined ? _a : false;
    if (this.isInitialized(normalizedIdentifier) || this.shouldAutoInitialize()) {
      try {
        return this.getOrInitializeService({
          instanceIdentifier: normalizedIdentifier
        });
      } catch (e) {
        if (optional) {
          return null;
        } else {
          throw e;
        }
      }
    } else {
      if (optional) {
        return null;
      } else {
        throw Error(`Service ${this.name} is not available`);
      }
    }
  }
  getComponent() {
    return this.component;
  }
  setComponent(component) {
    if (component.name !== this.name) {
      throw Error(`Mismatching Component ${component.name} for Provider ${this.name}.`);
    }
    if (this.component) {
      throw Error(`Component for ${this.name} has already been provided`);
    }
    this.component = component;
    if (!this.shouldAutoInitialize()) {
      return;
    }
    if (isComponentEager(component)) {
      try {
        this.getOrInitializeService({ instanceIdentifier: DEFAULT_ENTRY_NAME });
      } catch (e) {}
    }
    for (const [instanceIdentifier, instanceDeferred] of this.instancesDeferred.entries()) {
      const normalizedIdentifier = this.normalizeInstanceIdentifier(instanceIdentifier);
      try {
        const instance = this.getOrInitializeService({
          instanceIdentifier: normalizedIdentifier
        });
        instanceDeferred.resolve(instance);
      } catch (e) {}
    }
  }
  clearInstance(identifier = DEFAULT_ENTRY_NAME) {
    this.instancesDeferred.delete(identifier);
    this.instancesOptions.delete(identifier);
    this.instances.delete(identifier);
  }
  async delete() {
    const services = Array.from(this.instances.values());
    await Promise.all([
      ...services.filter((service) => ("INTERNAL" in service)).map((service) => service.INTERNAL.delete()),
      ...services.filter((service) => ("_delete" in service)).map((service) => service._delete())
    ]);
  }
  isComponentSet() {
    return this.component != null;
  }
  isInitialized(identifier = DEFAULT_ENTRY_NAME) {
    return this.instances.has(identifier);
  }
  getOptions(identifier = DEFAULT_ENTRY_NAME) {
    return this.instancesOptions.get(identifier) || {};
  }
  initialize(opts = {}) {
    const { options = {} } = opts;
    const normalizedIdentifier = this.normalizeInstanceIdentifier(opts.instanceIdentifier);
    if (this.isInitialized(normalizedIdentifier)) {
      throw Error(`${this.name}(${normalizedIdentifier}) has already been initialized`);
    }
    if (!this.isComponentSet()) {
      throw Error(`Component ${this.name} has not been registered yet`);
    }
    const instance = this.getOrInitializeService({
      instanceIdentifier: normalizedIdentifier,
      options
    });
    for (const [instanceIdentifier, instanceDeferred] of this.instancesDeferred.entries()) {
      const normalizedDeferredIdentifier = this.normalizeInstanceIdentifier(instanceIdentifier);
      if (normalizedIdentifier === normalizedDeferredIdentifier) {
        instanceDeferred.resolve(instance);
      }
    }
    return instance;
  }
  onInit(callback, identifier) {
    var _a;
    const normalizedIdentifier = this.normalizeInstanceIdentifier(identifier);
    const existingCallbacks = (_a = this.onInitCallbacks.get(normalizedIdentifier)) !== null && _a !== undefined ? _a : new Set;
    existingCallbacks.add(callback);
    this.onInitCallbacks.set(normalizedIdentifier, existingCallbacks);
    const existingInstance = this.instances.get(normalizedIdentifier);
    if (existingInstance) {
      callback(existingInstance, normalizedIdentifier);
    }
    return () => {
      existingCallbacks.delete(callback);
    };
  }
  invokeOnInitCallbacks(instance, identifier) {
    const callbacks = this.onInitCallbacks.get(identifier);
    if (!callbacks) {
      return;
    }
    for (const callback of callbacks) {
      try {
        callback(instance, identifier);
      } catch (_a) {}
    }
  }
  getOrInitializeService({ instanceIdentifier, options = {} }) {
    let instance = this.instances.get(instanceIdentifier);
    if (!instance && this.component) {
      instance = this.component.instanceFactory(this.container, {
        instanceIdentifier: normalizeIdentifierForFactory(instanceIdentifier),
        options
      });
      this.instances.set(instanceIdentifier, instance);
      this.instancesOptions.set(instanceIdentifier, options);
      this.invokeOnInitCallbacks(instance, instanceIdentifier);
      if (this.component.onInstanceCreated) {
        try {
          this.component.onInstanceCreated(this.container, instanceIdentifier, instance);
        } catch (_a) {}
      }
    }
    return instance || null;
  }
  normalizeInstanceIdentifier(identifier = DEFAULT_ENTRY_NAME) {
    if (this.component) {
      return this.component.multipleInstances ? identifier : DEFAULT_ENTRY_NAME;
    } else {
      return identifier;
    }
  }
  shouldAutoInitialize() {
    return !!this.component && this.component.instantiationMode !== "EXPLICIT";
  }
}
function normalizeIdentifierForFactory(identifier) {
  return identifier === DEFAULT_ENTRY_NAME ? undefined : identifier;
}
function isComponentEager(component) {
  return component.instantiationMode === "EAGER";
}

class ComponentContainer {
  constructor(name) {
    this.name = name;
    this.providers = new Map;
  }
  addComponent(component) {
    const provider = this.getProvider(component.name);
    if (provider.isComponentSet()) {
      throw new Error(`Component ${component.name} has already been registered with ${this.name}`);
    }
    provider.setComponent(component);
  }
  addOrOverwriteComponent(component) {
    const provider = this.getProvider(component.name);
    if (provider.isComponentSet()) {
      this.providers.delete(component.name);
    }
    this.addComponent(component);
  }
  getProvider(name) {
    if (this.providers.has(name)) {
      return this.providers.get(name);
    }
    const provider = new Provider(name, this);
    this.providers.set(name, provider);
    return provider;
  }
  getProviders() {
    return Array.from(this.providers.values());
  }
}
var DEFAULT_ENTRY_NAME = "[DEFAULT]";
var init_index_esm20172 = __esm(() => {
  init_index_esm2017();
});

// ../node_modules/@firebase/app/node_modules/@firebase/logger/dist/esm/index.esm2017.js
class Logger {
  constructor(name) {
    this.name = name;
    this._logLevel = defaultLogLevel;
    this._logHandler = defaultLogHandler;
    this._userLogHandler = null;
    instances.push(this);
  }
  get logLevel() {
    return this._logLevel;
  }
  set logLevel(val) {
    if (!(val in LogLevel)) {
      throw new TypeError(`Invalid value "${val}" assigned to \`logLevel\``);
    }
    this._logLevel = val;
  }
  setLogLevel(val) {
    this._logLevel = typeof val === "string" ? levelStringToEnum[val] : val;
  }
  get logHandler() {
    return this._logHandler;
  }
  set logHandler(val) {
    if (typeof val !== "function") {
      throw new TypeError("Value assigned to `logHandler` must be a function");
    }
    this._logHandler = val;
  }
  get userLogHandler() {
    return this._userLogHandler;
  }
  set userLogHandler(val) {
    this._userLogHandler = val;
  }
  debug(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel.DEBUG, ...args);
    this._logHandler(this, LogLevel.DEBUG, ...args);
  }
  log(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel.VERBOSE, ...args);
    this._logHandler(this, LogLevel.VERBOSE, ...args);
  }
  info(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel.INFO, ...args);
    this._logHandler(this, LogLevel.INFO, ...args);
  }
  warn(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel.WARN, ...args);
    this._logHandler(this, LogLevel.WARN, ...args);
  }
  error(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel.ERROR, ...args);
    this._logHandler(this, LogLevel.ERROR, ...args);
  }
}
var instances, LogLevel, levelStringToEnum, defaultLogLevel, ConsoleMethod, defaultLogHandler = (instance, logType, ...args) => {
  if (logType < instance.logLevel) {
    return;
  }
  const now = new Date().toISOString();
  const method = ConsoleMethod[logType];
  if (method) {
    console[method](`[${now}]  ${instance.name}:`, ...args);
  } else {
    throw new Error(`Attempted to log a message with an invalid logType (value: ${logType})`);
  }
};
var init_index_esm20173 = __esm(() => {
  instances = [];
  (function(LogLevel2) {
    LogLevel2[LogLevel2["DEBUG"] = 0] = "DEBUG";
    LogLevel2[LogLevel2["VERBOSE"] = 1] = "VERBOSE";
    LogLevel2[LogLevel2["INFO"] = 2] = "INFO";
    LogLevel2[LogLevel2["WARN"] = 3] = "WARN";
    LogLevel2[LogLevel2["ERROR"] = 4] = "ERROR";
    LogLevel2[LogLevel2["SILENT"] = 5] = "SILENT";
  })(LogLevel || (LogLevel = {}));
  levelStringToEnum = {
    debug: LogLevel.DEBUG,
    verbose: LogLevel.VERBOSE,
    info: LogLevel.INFO,
    warn: LogLevel.WARN,
    error: LogLevel.ERROR,
    silent: LogLevel.SILENT
  };
  defaultLogLevel = LogLevel.INFO;
  ConsoleMethod = {
    [LogLevel.DEBUG]: "log",
    [LogLevel.VERBOSE]: "log",
    [LogLevel.INFO]: "info",
    [LogLevel.WARN]: "warn",
    [LogLevel.ERROR]: "error"
  };
});

// ../node_modules/idb/build/wrap-idb-value.js
function getIdbProxyableTypes() {
  return idbProxyableTypes || (idbProxyableTypes = [
    IDBDatabase,
    IDBObjectStore,
    IDBIndex,
    IDBCursor,
    IDBTransaction
  ]);
}
function getCursorAdvanceMethods() {
  return cursorAdvanceMethods || (cursorAdvanceMethods = [
    IDBCursor.prototype.advance,
    IDBCursor.prototype.continue,
    IDBCursor.prototype.continuePrimaryKey
  ]);
}
function promisifyRequest(request) {
  const promise = new Promise((resolve, reject) => {
    const unlisten = () => {
      request.removeEventListener("success", success);
      request.removeEventListener("error", error);
    };
    const success = () => {
      resolve(wrap(request.result));
      unlisten();
    };
    const error = () => {
      reject(request.error);
      unlisten();
    };
    request.addEventListener("success", success);
    request.addEventListener("error", error);
  });
  promise.then((value) => {
    if (value instanceof IDBCursor) {
      cursorRequestMap.set(value, request);
    }
  }).catch(() => {});
  reverseTransformCache.set(promise, request);
  return promise;
}
function cacheDonePromiseForTransaction(tx) {
  if (transactionDoneMap.has(tx))
    return;
  const done = new Promise((resolve, reject) => {
    const unlisten = () => {
      tx.removeEventListener("complete", complete);
      tx.removeEventListener("error", error);
      tx.removeEventListener("abort", error);
    };
    const complete = () => {
      resolve();
      unlisten();
    };
    const error = () => {
      reject(tx.error || new DOMException("AbortError", "AbortError"));
      unlisten();
    };
    tx.addEventListener("complete", complete);
    tx.addEventListener("error", error);
    tx.addEventListener("abort", error);
  });
  transactionDoneMap.set(tx, done);
}
function replaceTraps(callback) {
  idbProxyTraps = callback(idbProxyTraps);
}
function wrapFunction(func) {
  if (func === IDBDatabase.prototype.transaction && !("objectStoreNames" in IDBTransaction.prototype)) {
    return function(storeNames, ...args) {
      const tx = func.call(unwrap(this), storeNames, ...args);
      transactionStoreNamesMap.set(tx, storeNames.sort ? storeNames.sort() : [storeNames]);
      return wrap(tx);
    };
  }
  if (getCursorAdvanceMethods().includes(func)) {
    return function(...args) {
      func.apply(unwrap(this), args);
      return wrap(cursorRequestMap.get(this));
    };
  }
  return function(...args) {
    return wrap(func.apply(unwrap(this), args));
  };
}
function transformCachableValue(value) {
  if (typeof value === "function")
    return wrapFunction(value);
  if (value instanceof IDBTransaction)
    cacheDonePromiseForTransaction(value);
  if (instanceOfAny(value, getIdbProxyableTypes()))
    return new Proxy(value, idbProxyTraps);
  return value;
}
function wrap(value) {
  if (value instanceof IDBRequest)
    return promisifyRequest(value);
  if (transformCache.has(value))
    return transformCache.get(value);
  const newValue = transformCachableValue(value);
  if (newValue !== value) {
    transformCache.set(value, newValue);
    reverseTransformCache.set(newValue, value);
  }
  return newValue;
}
var instanceOfAny = (object, constructors) => constructors.some((c) => object instanceof c), idbProxyableTypes, cursorAdvanceMethods, cursorRequestMap, transactionDoneMap, transactionStoreNamesMap, transformCache, reverseTransformCache, idbProxyTraps, unwrap = (value) => reverseTransformCache.get(value);
var init_wrap_idb_value = __esm(() => {
  cursorRequestMap = new WeakMap;
  transactionDoneMap = new WeakMap;
  transactionStoreNamesMap = new WeakMap;
  transformCache = new WeakMap;
  reverseTransformCache = new WeakMap;
  idbProxyTraps = {
    get(target, prop, receiver) {
      if (target instanceof IDBTransaction) {
        if (prop === "done")
          return transactionDoneMap.get(target);
        if (prop === "objectStoreNames") {
          return target.objectStoreNames || transactionStoreNamesMap.get(target);
        }
        if (prop === "store") {
          return receiver.objectStoreNames[1] ? undefined : receiver.objectStore(receiver.objectStoreNames[0]);
        }
      }
      return wrap(target[prop]);
    },
    set(target, prop, value) {
      target[prop] = value;
      return true;
    },
    has(target, prop) {
      if (target instanceof IDBTransaction && (prop === "done" || prop === "store")) {
        return true;
      }
      return prop in target;
    }
  };
});

// ../node_modules/idb/build/index-72f7278d0035e72b3f590dcb594529c4-544c8ad1d62a03099a8d7ec2c4340acd.js
function openDB(name, version, { blocked, upgrade, blocking, terminated } = {}) {
  const request = indexedDB.open(name, version);
  const openPromise = wrap(request);
  if (upgrade) {
    request.addEventListener("upgradeneeded", (event) => {
      upgrade(wrap(request.result), event.oldVersion, event.newVersion, wrap(request.transaction), event);
    });
  }
  if (blocked) {
    request.addEventListener("blocked", (event) => blocked(event.oldVersion, event.newVersion, event));
  }
  openPromise.then((db) => {
    if (terminated)
      db.addEventListener("close", () => terminated());
    if (blocking) {
      db.addEventListener("versionchange", (event) => blocking(event.oldVersion, event.newVersion, event));
    }
  }).catch(() => {});
  return openPromise;
}
function getMethod(target, prop) {
  if (!(target instanceof IDBDatabase && !(prop in target) && typeof prop === "string")) {
    return;
  }
  if (cachedMethods.get(prop))
    return cachedMethods.get(prop);
  const targetFuncName = prop.replace(/FromIndex$/, "");
  const useIndex = prop !== targetFuncName;
  const isWrite = writeMethods.includes(targetFuncName);
  if (!(targetFuncName in (useIndex ? IDBIndex : IDBObjectStore).prototype) || !(isWrite || readMethods.includes(targetFuncName))) {
    return;
  }
  const method = async function(storeName, ...args) {
    const tx = this.transaction(storeName, isWrite ? "readwrite" : "readonly");
    let target2 = tx.store;
    if (useIndex)
      target2 = target2.index(args.shift());
    return (await Promise.all([
      target2[targetFuncName](...args),
      isWrite && tx.done
    ]))[0];
  };
  cachedMethods.set(prop, method);
  return method;
}
var readMethods, writeMethods, cachedMethods;
var init_build = __esm(() => {
  init_wrap_idb_value();
  init_wrap_idb_value();
  readMethods = ["get", "getKey", "getAll", "getAllKeys", "count"];
  writeMethods = ["put", "add", "delete", "clear"];
  cachedMethods = new Map;
  replaceTraps((oldTraps) => ({
    ...oldTraps,
    get: (target, prop, receiver) => getMethod(target, prop) || oldTraps.get(target, prop, receiver),
    has: (target, prop) => !!getMethod(target, prop) || oldTraps.has(target, prop)
  }));
});

// ../node_modules/@firebase/app/dist/esm/index.esm2017.js
class PlatformLoggerServiceImpl {
  constructor(container) {
    this.container = container;
  }
  getPlatformInfoString() {
    const providers = this.container.getProviders();
    return providers.map((provider) => {
      if (isVersionServiceProvider(provider)) {
        const service = provider.getImmediate();
        return `${service.library}/${service.version}`;
      } else {
        return null;
      }
    }).filter((logString) => logString).join(" ");
  }
}
function isVersionServiceProvider(provider) {
  const component = provider.getComponent();
  return (component === null || component === undefined ? undefined : component.type) === "VERSION";
}
function _addComponent(app, component) {
  try {
    app.container.addComponent(component);
  } catch (e) {
    logger.debug(`Component ${component.name} failed to register with FirebaseApp ${app.name}`, e);
  }
}
function _registerComponent(component) {
  const componentName = component.name;
  if (_components.has(componentName)) {
    logger.debug(`There were multiple attempts to register component ${componentName}.`);
    return false;
  }
  _components.set(componentName, component);
  for (const app of _apps.values()) {
    _addComponent(app, component);
  }
  return true;
}
function _getProvider(app, name2) {
  const heartbeatController = app.container.getProvider("heartbeat").getImmediate({ optional: true });
  if (heartbeatController) {
    heartbeatController.triggerHeartbeat();
  }
  return app.container.getProvider(name2);
}

class FirebaseAppImpl {
  constructor(options, config, container) {
    this._isDeleted = false;
    this._options = Object.assign({}, options);
    this._config = Object.assign({}, config);
    this._name = config.name;
    this._automaticDataCollectionEnabled = config.automaticDataCollectionEnabled;
    this._container = container;
    this.container.addComponent(new Component("app", () => this, "PUBLIC"));
  }
  get automaticDataCollectionEnabled() {
    this.checkDestroyed();
    return this._automaticDataCollectionEnabled;
  }
  set automaticDataCollectionEnabled(val) {
    this.checkDestroyed();
    this._automaticDataCollectionEnabled = val;
  }
  get name() {
    this.checkDestroyed();
    return this._name;
  }
  get options() {
    this.checkDestroyed();
    return this._options;
  }
  get config() {
    this.checkDestroyed();
    return this._config;
  }
  get container() {
    return this._container;
  }
  get isDeleted() {
    return this._isDeleted;
  }
  set isDeleted(val) {
    this._isDeleted = val;
  }
  checkDestroyed() {
    if (this.isDeleted) {
      throw ERROR_FACTORY.create("app-deleted", { appName: this._name });
    }
  }
}
function initializeApp(_options, rawConfig = {}) {
  let options = _options;
  if (typeof rawConfig !== "object") {
    const name3 = rawConfig;
    rawConfig = { name: name3 };
  }
  const config = Object.assign({ name: DEFAULT_ENTRY_NAME2, automaticDataCollectionEnabled: false }, rawConfig);
  const name2 = config.name;
  if (typeof name2 !== "string" || !name2) {
    throw ERROR_FACTORY.create("bad-app-name", {
      appName: String(name2)
    });
  }
  options || (options = getDefaultAppConfig());
  if (!options) {
    throw ERROR_FACTORY.create("no-options");
  }
  const existingApp = _apps.get(name2);
  if (existingApp) {
    if (deepEqual(options, existingApp.options) && deepEqual(config, existingApp.config)) {
      return existingApp;
    } else {
      throw ERROR_FACTORY.create("duplicate-app", { appName: name2 });
    }
  }
  const container = new ComponentContainer(name2);
  for (const component of _components.values()) {
    container.addComponent(component);
  }
  const newApp = new FirebaseAppImpl(options, config, container);
  _apps.set(name2, newApp);
  return newApp;
}
function getApp(name2 = DEFAULT_ENTRY_NAME2) {
  const app = _apps.get(name2);
  if (!app && name2 === DEFAULT_ENTRY_NAME2 && getDefaultAppConfig()) {
    return initializeApp();
  }
  if (!app) {
    throw ERROR_FACTORY.create("no-app", { appName: name2 });
  }
  return app;
}
function getApps() {
  return Array.from(_apps.values());
}
function registerVersion(libraryKeyOrName, version2, variant) {
  var _a;
  let library = (_a = PLATFORM_LOG_STRING[libraryKeyOrName]) !== null && _a !== undefined ? _a : libraryKeyOrName;
  if (variant) {
    library += `-${variant}`;
  }
  const libraryMismatch = library.match(/\s|\//);
  const versionMismatch = version2.match(/\s|\//);
  if (libraryMismatch || versionMismatch) {
    const warning = [
      `Unable to register library "${library}" with version "${version2}":`
    ];
    if (libraryMismatch) {
      warning.push(`library name "${library}" contains illegal characters (whitespace or "/")`);
    }
    if (libraryMismatch && versionMismatch) {
      warning.push("and");
    }
    if (versionMismatch) {
      warning.push(`version name "${version2}" contains illegal characters (whitespace or "/")`);
    }
    logger.warn(warning.join(" "));
    return;
  }
  _registerComponent(new Component(`${library}-version`, () => ({ library, version: version2 }), "VERSION"));
}
function getDbPromise() {
  if (!dbPromise) {
    dbPromise = openDB(DB_NAME, DB_VERSION, {
      upgrade: (db, oldVersion) => {
        switch (oldVersion) {
          case 0:
            db.createObjectStore(STORE_NAME);
        }
      }
    }).catch((e) => {
      throw ERROR_FACTORY.create("idb-open", {
        originalErrorMessage: e.message
      });
    });
  }
  return dbPromise;
}
async function readHeartbeatsFromIndexedDB(app) {
  try {
    const db = await getDbPromise();
    const result = await db.transaction(STORE_NAME).objectStore(STORE_NAME).get(computeKey(app));
    return result;
  } catch (e) {
    if (e instanceof FirebaseError) {
      logger.warn(e.message);
    } else {
      const idbGetError = ERROR_FACTORY.create("idb-get", {
        originalErrorMessage: e === null || e === undefined ? undefined : e.message
      });
      logger.warn(idbGetError.message);
    }
  }
}
async function writeHeartbeatsToIndexedDB(app, heartbeatObject) {
  try {
    const db = await getDbPromise();
    const tx = db.transaction(STORE_NAME, "readwrite");
    const objectStore = tx.objectStore(STORE_NAME);
    await objectStore.put(heartbeatObject, computeKey(app));
    await tx.done;
  } catch (e) {
    if (e instanceof FirebaseError) {
      logger.warn(e.message);
    } else {
      const idbGetError = ERROR_FACTORY.create("idb-set", {
        originalErrorMessage: e === null || e === undefined ? undefined : e.message
      });
      logger.warn(idbGetError.message);
    }
  }
}
function computeKey(app) {
  return `${app.name}!${app.options.appId}`;
}

class HeartbeatServiceImpl {
  constructor(container) {
    this.container = container;
    this._heartbeatsCache = null;
    const app = this.container.getProvider("app").getImmediate();
    this._storage = new HeartbeatStorageImpl(app);
    this._heartbeatsCachePromise = this._storage.read().then((result) => {
      this._heartbeatsCache = result;
      return result;
    });
  }
  async triggerHeartbeat() {
    const platformLogger = this.container.getProvider("platform-logger").getImmediate();
    const agent = platformLogger.getPlatformInfoString();
    const date = getUTCDateString();
    if (this._heartbeatsCache === null) {
      this._heartbeatsCache = await this._heartbeatsCachePromise;
    }
    if (this._heartbeatsCache.lastSentHeartbeatDate === date || this._heartbeatsCache.heartbeats.some((singleDateHeartbeat) => singleDateHeartbeat.date === date)) {
      return;
    } else {
      this._heartbeatsCache.heartbeats.push({ date, agent });
    }
    this._heartbeatsCache.heartbeats = this._heartbeatsCache.heartbeats.filter((singleDateHeartbeat) => {
      const hbTimestamp = new Date(singleDateHeartbeat.date).valueOf();
      const now = Date.now();
      return now - hbTimestamp <= STORED_HEARTBEAT_RETENTION_MAX_MILLIS;
    });
    return this._storage.overwrite(this._heartbeatsCache);
  }
  async getHeartbeatsHeader() {
    if (this._heartbeatsCache === null) {
      await this._heartbeatsCachePromise;
    }
    if (this._heartbeatsCache === null || this._heartbeatsCache.heartbeats.length === 0) {
      return "";
    }
    const date = getUTCDateString();
    const { heartbeatsToSend, unsentEntries } = extractHeartbeatsForHeader(this._heartbeatsCache.heartbeats);
    const headerString = base64urlEncodeWithoutPadding(JSON.stringify({ version: 2, heartbeats: heartbeatsToSend }));
    this._heartbeatsCache.lastSentHeartbeatDate = date;
    if (unsentEntries.length > 0) {
      this._heartbeatsCache.heartbeats = unsentEntries;
      await this._storage.overwrite(this._heartbeatsCache);
    } else {
      this._heartbeatsCache.heartbeats = [];
      this._storage.overwrite(this._heartbeatsCache);
    }
    return headerString;
  }
}
function getUTCDateString() {
  const today = new Date;
  return today.toISOString().substring(0, 10);
}
function extractHeartbeatsForHeader(heartbeatsCache, maxSize = MAX_HEADER_BYTES) {
  const heartbeatsToSend = [];
  let unsentEntries = heartbeatsCache.slice();
  for (const singleDateHeartbeat of heartbeatsCache) {
    const heartbeatEntry = heartbeatsToSend.find((hb) => hb.agent === singleDateHeartbeat.agent);
    if (!heartbeatEntry) {
      heartbeatsToSend.push({
        agent: singleDateHeartbeat.agent,
        dates: [singleDateHeartbeat.date]
      });
      if (countBytes(heartbeatsToSend) > maxSize) {
        heartbeatsToSend.pop();
        break;
      }
    } else {
      heartbeatEntry.dates.push(singleDateHeartbeat.date);
      if (countBytes(heartbeatsToSend) > maxSize) {
        heartbeatEntry.dates.pop();
        break;
      }
    }
    unsentEntries = unsentEntries.slice(1);
  }
  return {
    heartbeatsToSend,
    unsentEntries
  };
}

class HeartbeatStorageImpl {
  constructor(app) {
    this.app = app;
    this._canUseIndexedDBPromise = this.runIndexedDBEnvironmentCheck();
  }
  async runIndexedDBEnvironmentCheck() {
    if (!isIndexedDBAvailable()) {
      return false;
    } else {
      return validateIndexedDBOpenable().then(() => true).catch(() => false);
    }
  }
  async read() {
    const canUseIndexedDB = await this._canUseIndexedDBPromise;
    if (!canUseIndexedDB) {
      return { heartbeats: [] };
    } else {
      const idbHeartbeatObject = await readHeartbeatsFromIndexedDB(this.app);
      return idbHeartbeatObject || { heartbeats: [] };
    }
  }
  async overwrite(heartbeatsObject) {
    var _a;
    const canUseIndexedDB = await this._canUseIndexedDBPromise;
    if (!canUseIndexedDB) {
      return;
    } else {
      const existingHeartbeatsObject = await this.read();
      return writeHeartbeatsToIndexedDB(this.app, {
        lastSentHeartbeatDate: (_a = heartbeatsObject.lastSentHeartbeatDate) !== null && _a !== undefined ? _a : existingHeartbeatsObject.lastSentHeartbeatDate,
        heartbeats: heartbeatsObject.heartbeats
      });
    }
  }
  async add(heartbeatsObject) {
    var _a;
    const canUseIndexedDB = await this._canUseIndexedDBPromise;
    if (!canUseIndexedDB) {
      return;
    } else {
      const existingHeartbeatsObject = await this.read();
      return writeHeartbeatsToIndexedDB(this.app, {
        lastSentHeartbeatDate: (_a = heartbeatsObject.lastSentHeartbeatDate) !== null && _a !== undefined ? _a : existingHeartbeatsObject.lastSentHeartbeatDate,
        heartbeats: [
          ...existingHeartbeatsObject.heartbeats,
          ...heartbeatsObject.heartbeats
        ]
      });
    }
  }
}
function countBytes(heartbeatsCache) {
  return base64urlEncodeWithoutPadding(JSON.stringify({ version: 2, heartbeats: heartbeatsCache })).length;
}
function registerCoreComponents(variant) {
  _registerComponent(new Component("platform-logger", (container) => new PlatformLoggerServiceImpl(container), "PRIVATE"));
  _registerComponent(new Component("heartbeat", (container) => new HeartbeatServiceImpl(container), "PRIVATE"));
  registerVersion(name$o, version$1, variant);
  registerVersion(name$o, version$1, "esm2017");
  registerVersion("fire-js", "");
}
var name$o = "@firebase/app", version$1 = "0.9.18", logger, name$n = "@firebase/app-compat", name$m = "@firebase/analytics-compat", name$l = "@firebase/analytics", name$k = "@firebase/app-check-compat", name$j = "@firebase/app-check", name$i = "@firebase/auth", name$h = "@firebase/auth-compat", name$g = "@firebase/database", name$f = "@firebase/database-compat", name$e = "@firebase/functions", name$d = "@firebase/functions-compat", name$c = "@firebase/installations", name$b = "@firebase/installations-compat", name$a = "@firebase/messaging", name$9 = "@firebase/messaging-compat", name$8 = "@firebase/performance", name$7 = "@firebase/performance-compat", name$6 = "@firebase/remote-config", name$5 = "@firebase/remote-config-compat", name$4 = "@firebase/storage", name$3 = "@firebase/storage-compat", name$2 = "@firebase/firestore", name$1 = "@firebase/firestore-compat", name = "firebase", version = "10.3.1", DEFAULT_ENTRY_NAME2 = "[DEFAULT]", PLATFORM_LOG_STRING, _apps, _components, ERRORS, ERROR_FACTORY, SDK_VERSION, DB_NAME = "firebase-heartbeat-database", DB_VERSION = 1, STORE_NAME = "firebase-heartbeat-store", dbPromise = null, MAX_HEADER_BYTES = 1024, STORED_HEARTBEAT_RETENTION_MAX_MILLIS;
var init_index_esm20174 = __esm(() => {
  init_index_esm20172();
  init_index_esm20173();
  init_index_esm2017();
  init_index_esm2017();
  init_build();
  logger = new Logger("@firebase/app");
  PLATFORM_LOG_STRING = {
    [name$o]: "fire-core",
    [name$n]: "fire-core-compat",
    [name$l]: "fire-analytics",
    [name$m]: "fire-analytics-compat",
    [name$j]: "fire-app-check",
    [name$k]: "fire-app-check-compat",
    [name$i]: "fire-auth",
    [name$h]: "fire-auth-compat",
    [name$g]: "fire-rtdb",
    [name$f]: "fire-rtdb-compat",
    [name$e]: "fire-fn",
    [name$d]: "fire-fn-compat",
    [name$c]: "fire-iid",
    [name$b]: "fire-iid-compat",
    [name$a]: "fire-fcm",
    [name$9]: "fire-fcm-compat",
    [name$8]: "fire-perf",
    [name$7]: "fire-perf-compat",
    [name$6]: "fire-rc",
    [name$5]: "fire-rc-compat",
    [name$4]: "fire-gcs",
    [name$3]: "fire-gcs-compat",
    [name$2]: "fire-fst",
    [name$1]: "fire-fst-compat",
    "fire-js": "fire-js",
    [name]: "fire-js-all"
  };
  _apps = new Map;
  _components = new Map;
  ERRORS = {
    ["no-app"]: "No Firebase App '{$appName}' has been created - " + "call initializeApp() first",
    ["bad-app-name"]: "Illegal App name: '{$appName}",
    ["duplicate-app"]: "Firebase App named '{$appName}' already exists with different options or config",
    ["app-deleted"]: "Firebase App named '{$appName}' already deleted",
    ["no-options"]: "Need to provide options, when not being deployed to hosting via source.",
    ["invalid-app-argument"]: "firebase.{$appName}() takes either no argument or a " + "Firebase App instance.",
    ["invalid-log-argument"]: "First argument to `onLog` must be null or a function.",
    ["idb-open"]: "Error thrown when opening IndexedDB. Original error: {$originalErrorMessage}.",
    ["idb-get"]: "Error thrown when reading from IndexedDB. Original error: {$originalErrorMessage}.",
    ["idb-set"]: "Error thrown when writing to IndexedDB. Original error: {$originalErrorMessage}.",
    ["idb-delete"]: "Error thrown when deleting from IndexedDB. Original error: {$originalErrorMessage}."
  };
  ERROR_FACTORY = new ErrorFactory("app", "Firebase", ERRORS);
  SDK_VERSION = version;
  STORED_HEARTBEAT_RETENTION_MAX_MILLIS = 30 * 24 * 60 * 60 * 1000;
  registerCoreComponents("");
});

// ../node_modules/firebase/app/dist/esm/index.esm.js
var name2 = "firebase", version2 = "10.3.1";
var init_index_esm = __esm(() => {
  init_index_esm20174();
  init_index_esm20174();
  registerVersion(name2, version2, "app");
});

// ../node_modules/@firebase/logger/dist/esm/index.esm2017.js
class Logger2 {
  constructor(name3) {
    this.name = name3;
    this._logLevel = defaultLogLevel2;
    this._logHandler = defaultLogHandler2;
    this._userLogHandler = null;
    instances2.push(this);
  }
  get logLevel() {
    return this._logLevel;
  }
  set logLevel(val) {
    if (!(val in LogLevel2)) {
      throw new TypeError(`Invalid value "${val}" assigned to \`logLevel\``);
    }
    this._logLevel = val;
  }
  setLogLevel(val) {
    this._logLevel = typeof val === "string" ? levelStringToEnum2[val] : val;
  }
  get logHandler() {
    return this._logHandler;
  }
  set logHandler(val) {
    if (typeof val !== "function") {
      throw new TypeError("Value assigned to `logHandler` must be a function");
    }
    this._logHandler = val;
  }
  get userLogHandler() {
    return this._userLogHandler;
  }
  set userLogHandler(val) {
    this._userLogHandler = val;
  }
  debug(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel2.DEBUG, ...args);
    this._logHandler(this, LogLevel2.DEBUG, ...args);
  }
  log(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel2.VERBOSE, ...args);
    this._logHandler(this, LogLevel2.VERBOSE, ...args);
  }
  info(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel2.INFO, ...args);
    this._logHandler(this, LogLevel2.INFO, ...args);
  }
  warn(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel2.WARN, ...args);
    this._logHandler(this, LogLevel2.WARN, ...args);
  }
  error(...args) {
    this._userLogHandler && this._userLogHandler(this, LogLevel2.ERROR, ...args);
    this._logHandler(this, LogLevel2.ERROR, ...args);
  }
}
var instances2, LogLevel2, levelStringToEnum2, defaultLogLevel2, ConsoleMethod2, defaultLogHandler2 = (instance, logType, ...args) => {
  if (logType < instance.logLevel) {
    return;
  }
  const now = new Date().toISOString();
  const method = ConsoleMethod2[logType];
  if (method) {
    console[method](`[${now}]  ${instance.name}:`, ...args);
  } else {
    throw new Error(`Attempted to log a message with an invalid logType (value: ${logType})`);
  }
};
var init_index_esm20175 = __esm(() => {
  instances2 = [];
  (function(LogLevel3) {
    LogLevel3[LogLevel3["DEBUG"] = 0] = "DEBUG";
    LogLevel3[LogLevel3["VERBOSE"] = 1] = "VERBOSE";
    LogLevel3[LogLevel3["INFO"] = 2] = "INFO";
    LogLevel3[LogLevel3["WARN"] = 3] = "WARN";
    LogLevel3[LogLevel3["ERROR"] = 4] = "ERROR";
    LogLevel3[LogLevel3["SILENT"] = 5] = "SILENT";
  })(LogLevel2 || (LogLevel2 = {}));
  levelStringToEnum2 = {
    debug: LogLevel2.DEBUG,
    verbose: LogLevel2.VERBOSE,
    info: LogLevel2.INFO,
    warn: LogLevel2.WARN,
    error: LogLevel2.ERROR,
    silent: LogLevel2.SILENT
  };
  defaultLogLevel2 = LogLevel2.INFO;
  ConsoleMethod2 = {
    [LogLevel2.DEBUG]: "log",
    [LogLevel2.VERBOSE]: "log",
    [LogLevel2.INFO]: "info",
    [LogLevel2.WARN]: "warn",
    [LogLevel2.ERROR]: "error"
  };
});

// ../node_modules/firebase/node_modules/tslib/tslib.es6.mjs
function __rest(s, e) {
  var t = {};
  for (var p in s)
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i = 0, p = Object.getOwnPropertySymbols(s);i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
        t[p[i]] = s[p[i]];
    }
  return t;
}
var init_tslib_es6 = () => {};

// ../node_modules/@firebase/component/node_modules/@firebase/util/dist/postinstall.mjs
var init_postinstall = () => {};

// ../node_modules/@firebase/component/node_modules/@firebase/util/dist/index.esm2017.js
var stringToByteArray$12 = function(str) {
  const out = [];
  let p = 0;
  for (let i = 0;i < str.length; i++) {
    let c = str.charCodeAt(i);
    if (c < 128) {
      out[p++] = c;
    } else if (c < 2048) {
      out[p++] = c >> 6 | 192;
      out[p++] = c & 63 | 128;
    } else if ((c & 64512) === 55296 && i + 1 < str.length && (str.charCodeAt(i + 1) & 64512) === 56320) {
      c = 65536 + ((c & 1023) << 10) + (str.charCodeAt(++i) & 1023);
      out[p++] = c >> 18 | 240;
      out[p++] = c >> 12 & 63 | 128;
      out[p++] = c >> 6 & 63 | 128;
      out[p++] = c & 63 | 128;
    } else {
      out[p++] = c >> 12 | 224;
      out[p++] = c >> 6 & 63 | 128;
      out[p++] = c & 63 | 128;
    }
  }
  return out;
}, byteArrayToString2 = function(bytes) {
  const out = [];
  let pos = 0, c = 0;
  while (pos < bytes.length) {
    const c1 = bytes[pos++];
    if (c1 < 128) {
      out[c++] = String.fromCharCode(c1);
    } else if (c1 > 191 && c1 < 224) {
      const c2 = bytes[pos++];
      out[c++] = String.fromCharCode((c1 & 31) << 6 | c2 & 63);
    } else if (c1 > 239 && c1 < 365) {
      const c2 = bytes[pos++];
      const c3 = bytes[pos++];
      const c4 = bytes[pos++];
      const u = ((c1 & 7) << 18 | (c2 & 63) << 12 | (c3 & 63) << 6 | c4 & 63) - 65536;
      out[c++] = String.fromCharCode(55296 + (u >> 10));
      out[c++] = String.fromCharCode(56320 + (u & 1023));
    } else {
      const c2 = bytes[pos++];
      const c3 = bytes[pos++];
      out[c++] = String.fromCharCode((c1 & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
    }
  }
  return out.join("");
}, base642, DecodeBase64StringError2, MAX_VALUE_MILLIS2;
var init_index_esm20176 = __esm(() => {
  init_postinstall();
  base642 = {
    byteToCharMap_: null,
    charToByteMap_: null,
    byteToCharMapWebSafe_: null,
    charToByteMapWebSafe_: null,
    ENCODED_VALS_BASE: "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + "abcdefghijklmnopqrstuvwxyz" + "0123456789",
    get ENCODED_VALS() {
      return this.ENCODED_VALS_BASE + "+/=";
    },
    get ENCODED_VALS_WEBSAFE() {
      return this.ENCODED_VALS_BASE + "-_.";
    },
    HAS_NATIVE_SUPPORT: typeof atob === "function",
    encodeByteArray(input, webSafe) {
      if (!Array.isArray(input)) {
        throw Error("encodeByteArray takes an array as a parameter");
      }
      this.init_();
      const byteToCharMap = webSafe ? this.byteToCharMapWebSafe_ : this.byteToCharMap_;
      const output = [];
      for (let i = 0;i < input.length; i += 3) {
        const byte1 = input[i];
        const haveByte2 = i + 1 < input.length;
        const byte2 = haveByte2 ? input[i + 1] : 0;
        const haveByte3 = i + 2 < input.length;
        const byte3 = haveByte3 ? input[i + 2] : 0;
        const outByte1 = byte1 >> 2;
        const outByte2 = (byte1 & 3) << 4 | byte2 >> 4;
        let outByte3 = (byte2 & 15) << 2 | byte3 >> 6;
        let outByte4 = byte3 & 63;
        if (!haveByte3) {
          outByte4 = 64;
          if (!haveByte2) {
            outByte3 = 64;
          }
        }
        output.push(byteToCharMap[outByte1], byteToCharMap[outByte2], byteToCharMap[outByte3], byteToCharMap[outByte4]);
      }
      return output.join("");
    },
    encodeString(input, webSafe) {
      if (this.HAS_NATIVE_SUPPORT && !webSafe) {
        return btoa(input);
      }
      return this.encodeByteArray(stringToByteArray$12(input), webSafe);
    },
    decodeString(input, webSafe) {
      if (this.HAS_NATIVE_SUPPORT && !webSafe) {
        return atob(input);
      }
      return byteArrayToString2(this.decodeStringToByteArray(input, webSafe));
    },
    decodeStringToByteArray(input, webSafe) {
      this.init_();
      const charToByteMap = webSafe ? this.charToByteMapWebSafe_ : this.charToByteMap_;
      const output = [];
      for (let i = 0;i < input.length; ) {
        const byte1 = charToByteMap[input.charAt(i++)];
        const haveByte2 = i < input.length;
        const byte2 = haveByte2 ? charToByteMap[input.charAt(i)] : 0;
        ++i;
        const haveByte3 = i < input.length;
        const byte3 = haveByte3 ? charToByteMap[input.charAt(i)] : 64;
        ++i;
        const haveByte4 = i < input.length;
        const byte4 = haveByte4 ? charToByteMap[input.charAt(i)] : 64;
        ++i;
        if (byte1 == null || byte2 == null || byte3 == null || byte4 == null) {
          throw new DecodeBase64StringError2;
        }
        const outByte1 = byte1 << 2 | byte2 >> 4;
        output.push(outByte1);
        if (byte3 !== 64) {
          const outByte2 = byte2 << 4 & 240 | byte3 >> 2;
          output.push(outByte2);
          if (byte4 !== 64) {
            const outByte3 = byte3 << 6 & 192 | byte4;
            output.push(outByte3);
          }
        }
      }
      return output;
    },
    init_() {
      if (!this.byteToCharMap_) {
        this.byteToCharMap_ = {};
        this.charToByteMap_ = {};
        this.byteToCharMapWebSafe_ = {};
        this.charToByteMapWebSafe_ = {};
        for (let i = 0;i < this.ENCODED_VALS.length; i++) {
          this.byteToCharMap_[i] = this.ENCODED_VALS.charAt(i);
          this.charToByteMap_[this.byteToCharMap_[i]] = i;
          this.byteToCharMapWebSafe_[i] = this.ENCODED_VALS_WEBSAFE.charAt(i);
          this.charToByteMapWebSafe_[this.byteToCharMapWebSafe_[i]] = i;
          if (i >= this.ENCODED_VALS_BASE.length) {
            this.charToByteMap_[this.ENCODED_VALS_WEBSAFE.charAt(i)] = i;
            this.charToByteMapWebSafe_[this.ENCODED_VALS.charAt(i)] = i;
          }
        }
      }
    }
  };
  DecodeBase64StringError2 = class DecodeBase64StringError2 extends Error {
    constructor() {
      super(...arguments);
      this.name = "DecodeBase64StringError";
    }
  };
  MAX_VALUE_MILLIS2 = 4 * 60 * 60 * 1000;
});

// ../node_modules/@firebase/component/dist/esm/index.esm2017.js
class Component2 {
  constructor(name3, instanceFactory, type) {
    this.name = name3;
    this.instanceFactory = instanceFactory;
    this.type = type;
    this.multipleInstances = false;
    this.serviceProps = {};
    this.instantiationMode = "LAZY";
    this.onInstanceCreated = null;
  }
  setInstantiationMode(mode) {
    this.instantiationMode = mode;
    return this;
  }
  setMultipleInstances(multipleInstances) {
    this.multipleInstances = multipleInstances;
    return this;
  }
  setServiceProps(props) {
    this.serviceProps = props;
    return this;
  }
  setInstanceCreatedCallback(callback) {
    this.onInstanceCreated = callback;
    return this;
  }
}
var init_index_esm20177 = __esm(() => {
  init_index_esm20176();
});

// ../node_modules/firebase/node_modules/@firebase/auth/dist/esm2017/index-9a76d29a.js
function isEnterprise(grecaptcha) {
  return grecaptcha !== undefined && grecaptcha.enterprise !== undefined;
}

class RecaptchaConfig {
  constructor(response) {
    this.siteKey = "";
    this.emailPasswordEnabled = false;
    if (response.recaptchaKey === undefined) {
      throw new Error("recaptchaKey undefined");
    }
    this.siteKey = response.recaptchaKey.split("/")[3];
    this.emailPasswordEnabled = response.recaptchaEnforcementState.some((enforcementState) => enforcementState.provider === "EMAIL_PASSWORD_PROVIDER" && enforcementState.enforcementState !== "OFF");
  }
}
function _prodErrorMap() {
  return {
    ["dependent-sdk-initialized-before-auth"]: "Another Firebase SDK was initialized and is trying to use Auth before Auth is " + "initialized. Please be sure to call `initializeAuth` or `getAuth` before " + "starting any other Firebase SDK."
  };
}
function _logWarn(msg, ...args) {
  if (logClient.logLevel <= LogLevel2.WARN) {
    logClient.warn(`Auth (${SDK_VERSION}): ${msg}`, ...args);
  }
}
function _logError(msg, ...args) {
  if (logClient.logLevel <= LogLevel2.ERROR) {
    logClient.error(`Auth (${SDK_VERSION}): ${msg}`, ...args);
  }
}
function _fail(authOrCode, ...rest) {
  throw createErrorInternal(authOrCode, ...rest);
}
function _createError(authOrCode, ...rest) {
  return createErrorInternal(authOrCode, ...rest);
}
function _errorWithCustomMessage(auth, code, message) {
  const errorMap = Object.assign(Object.assign({}, prodErrorMap()), { [code]: message });
  const factory = new ErrorFactory("auth", "Firebase", errorMap);
  return factory.create(code, {
    appName: auth.name
  });
}
function createErrorInternal(authOrCode, ...rest) {
  if (typeof authOrCode !== "string") {
    const code = rest[0];
    const fullParams = [...rest.slice(1)];
    if (fullParams[0]) {
      fullParams[0].appName = authOrCode.name;
    }
    return authOrCode._errorFactory.create(code, ...fullParams);
  }
  return _DEFAULT_AUTH_ERROR_FACTORY.create(authOrCode, ...rest);
}
function _assert(assertion, authOrCode, ...rest) {
  if (!assertion) {
    throw createErrorInternal(authOrCode, ...rest);
  }
}
function debugFail(failure) {
  const message = `INTERNAL ASSERTION FAILED: ` + failure;
  _logError(message);
  throw new Error(message);
}
function debugAssert(assertion, message) {
  if (!assertion) {
    debugFail(message);
  }
}
function _getCurrentUrl() {
  var _a;
  return typeof self !== "undefined" && ((_a = self.location) === null || _a === undefined ? undefined : _a.href) || "";
}
function _isHttpOrHttps() {
  return _getCurrentScheme() === "http:" || _getCurrentScheme() === "https:";
}
function _getCurrentScheme() {
  var _a;
  return typeof self !== "undefined" && ((_a = self.location) === null || _a === undefined ? undefined : _a.protocol) || null;
}
function _isOnline() {
  if (typeof navigator !== "undefined" && navigator && "onLine" in navigator && typeof navigator.onLine === "boolean" && (_isHttpOrHttps() || isBrowserExtension() || ("connection" in navigator))) {
    return navigator.onLine;
  }
  return true;
}
function _getUserLanguage() {
  if (typeof navigator === "undefined") {
    return null;
  }
  const navigatorLanguage = navigator;
  return navigatorLanguage.languages && navigatorLanguage.languages[0] || navigatorLanguage.language || null;
}

class Delay {
  constructor(shortDelay, longDelay) {
    this.shortDelay = shortDelay;
    this.longDelay = longDelay;
    debugAssert(longDelay > shortDelay, "Short delay should be less than long delay!");
    this.isMobile = isMobileCordova() || isReactNative();
  }
  get() {
    if (!_isOnline()) {
      return Math.min(5000, this.shortDelay);
    }
    return this.isMobile ? this.longDelay : this.shortDelay;
  }
}
function _emulatorUrl(config, path) {
  debugAssert(config.emulator, "Emulator should always be set here");
  const { url } = config.emulator;
  if (!path) {
    return url;
  }
  return `${url}${path.startsWith("/") ? path.slice(1) : path}`;
}

class FetchProvider {
  static initialize(fetchImpl, headersImpl, responseImpl) {
    this.fetchImpl = fetchImpl;
    if (headersImpl) {
      this.headersImpl = headersImpl;
    }
    if (responseImpl) {
      this.responseImpl = responseImpl;
    }
  }
  static fetch() {
    if (this.fetchImpl) {
      return this.fetchImpl;
    }
    if (typeof self !== "undefined" && "fetch" in self) {
      return self.fetch;
    }
    debugFail("Could not find fetch implementation, make sure you call FetchProvider.initialize() with an appropriate polyfill");
  }
  static headers() {
    if (this.headersImpl) {
      return this.headersImpl;
    }
    if (typeof self !== "undefined" && "Headers" in self) {
      return self.Headers;
    }
    debugFail("Could not find Headers implementation, make sure you call FetchProvider.initialize() with an appropriate polyfill");
  }
  static response() {
    if (this.responseImpl) {
      return this.responseImpl;
    }
    if (typeof self !== "undefined" && "Response" in self) {
      return self.Response;
    }
    debugFail("Could not find Response implementation, make sure you call FetchProvider.initialize() with an appropriate polyfill");
  }
}
function _addTidIfNecessary(auth, request) {
  if (auth.tenantId && !request.tenantId) {
    return Object.assign(Object.assign({}, request), { tenantId: auth.tenantId });
  }
  return request;
}
async function _performApiRequest(auth, method, path, request, customErrorMap = {}) {
  return _performFetchWithErrorHandling(auth, customErrorMap, async () => {
    let body = {};
    let params = {};
    if (request) {
      if (method === "GET") {
        params = request;
      } else {
        body = {
          body: JSON.stringify(request)
        };
      }
    }
    const query = querystring(Object.assign({ key: auth.config.apiKey }, params)).slice(1);
    const headers = await auth._getAdditionalHeaders();
    headers["Content-Type"] = "application/json";
    if (auth.languageCode) {
      headers["X-Firebase-Locale"] = auth.languageCode;
    }
    return FetchProvider.fetch()(_getFinalTarget(auth, auth.config.apiHost, path, query), Object.assign({
      method,
      headers,
      referrerPolicy: "no-referrer"
    }, body));
  });
}
async function _performFetchWithErrorHandling(auth, customErrorMap, fetchFn) {
  auth._canInitEmulator = false;
  const errorMap = Object.assign(Object.assign({}, SERVER_ERROR_MAP), customErrorMap);
  try {
    const networkTimeout = new NetworkTimeout(auth);
    const response = await Promise.race([
      fetchFn(),
      networkTimeout.promise
    ]);
    networkTimeout.clearNetworkTimeout();
    const json = await response.json();
    if ("needConfirmation" in json) {
      throw _makeTaggedError(auth, "account-exists-with-different-credential", json);
    }
    if (response.ok && !("errorMessage" in json)) {
      return json;
    } else {
      const errorMessage = response.ok ? json.errorMessage : json.error.message;
      const [serverErrorCode, serverErrorMessage] = errorMessage.split(" : ");
      if (serverErrorCode === "FEDERATED_USER_ID_ALREADY_LINKED") {
        throw _makeTaggedError(auth, "credential-already-in-use", json);
      } else if (serverErrorCode === "EMAIL_EXISTS") {
        throw _makeTaggedError(auth, "email-already-in-use", json);
      } else if (serverErrorCode === "USER_DISABLED") {
        throw _makeTaggedError(auth, "user-disabled", json);
      }
      const authError = errorMap[serverErrorCode] || serverErrorCode.toLowerCase().replace(/[_\s]+/g, "-");
      if (serverErrorMessage) {
        throw _errorWithCustomMessage(auth, authError, serverErrorMessage);
      } else {
        _fail(auth, authError);
      }
    }
  } catch (e) {
    if (e instanceof FirebaseError) {
      throw e;
    }
    _fail(auth, "network-request-failed", { message: String(e) });
  }
}
async function _performSignInRequest(auth, method, path, request, customErrorMap = {}) {
  const serverResponse = await _performApiRequest(auth, method, path, request, customErrorMap);
  if ("mfaPendingCredential" in serverResponse) {
    _fail(auth, "multi-factor-auth-required", {
      _serverResponse: serverResponse
    });
  }
  return serverResponse;
}
function _getFinalTarget(auth, host, path, query) {
  const base = `${host}${path}?${query}`;
  if (!auth.config.emulator) {
    return `${auth.config.apiScheme}://${base}`;
  }
  return _emulatorUrl(auth.config, base);
}

class NetworkTimeout {
  constructor(auth) {
    this.auth = auth;
    this.timer = null;
    this.promise = new Promise((_, reject) => {
      this.timer = setTimeout(() => {
        return reject(_createError(this.auth, "network-request-failed"));
      }, DEFAULT_API_TIMEOUT_MS.get());
    });
  }
  clearNetworkTimeout() {
    clearTimeout(this.timer);
  }
}
function _makeTaggedError(auth, code, response) {
  const errorParams = {
    appName: auth.name
  };
  if (response.email) {
    errorParams.email = response.email;
  }
  if (response.phoneNumber) {
    errorParams.phoneNumber = response.phoneNumber;
  }
  const error = _createError(auth, code, errorParams);
  error.customData._tokenResponse = response;
  return error;
}
async function getRecaptchaConfig(auth, request) {
  return _performApiRequest(auth, "GET", "/v2/recaptchaConfig", _addTidIfNecessary(auth, request));
}
async function deleteAccount(auth, request) {
  return _performApiRequest(auth, "POST", "/v1/accounts:delete", request);
}
async function getAccountInfo(auth, request) {
  return _performApiRequest(auth, "POST", "/v1/accounts:lookup", request);
}
function utcTimestampToDateString(utcTimestamp) {
  if (!utcTimestamp) {
    return;
  }
  try {
    const date = new Date(Number(utcTimestamp));
    if (!isNaN(date.getTime())) {
      return date.toUTCString();
    }
  } catch (e) {}
  return;
}
async function getIdTokenResult(user, forceRefresh = false) {
  const userInternal = getModularInstance(user);
  const token = await userInternal.getIdToken(forceRefresh);
  const claims = _parseToken(token);
  _assert(claims && claims.exp && claims.auth_time && claims.iat, userInternal.auth, "internal-error");
  const firebase = typeof claims.firebase === "object" ? claims.firebase : undefined;
  const signInProvider = firebase === null || firebase === undefined ? undefined : firebase["sign_in_provider"];
  return {
    claims,
    token,
    authTime: utcTimestampToDateString(secondsStringToMilliseconds(claims.auth_time)),
    issuedAtTime: utcTimestampToDateString(secondsStringToMilliseconds(claims.iat)),
    expirationTime: utcTimestampToDateString(secondsStringToMilliseconds(claims.exp)),
    signInProvider: signInProvider || null,
    signInSecondFactor: (firebase === null || firebase === undefined ? undefined : firebase["sign_in_second_factor"]) || null
  };
}
function secondsStringToMilliseconds(seconds) {
  return Number(seconds) * 1000;
}
function _parseToken(token) {
  const [algorithm, payload, signature] = token.split(".");
  if (algorithm === undefined || payload === undefined || signature === undefined) {
    _logError("JWT malformed, contained fewer than 3 sections");
    return null;
  }
  try {
    const decoded = base64Decode(payload);
    if (!decoded) {
      _logError("Failed to decode base64 JWT payload");
      return null;
    }
    return JSON.parse(decoded);
  } catch (e) {
    _logError("Caught error parsing JWT payload as JSON", e === null || e === undefined ? undefined : e.toString());
    return null;
  }
}
function _tokenExpiresIn(token) {
  const parsedToken = _parseToken(token);
  _assert(parsedToken, "internal-error");
  _assert(typeof parsedToken.exp !== "undefined", "internal-error");
  _assert(typeof parsedToken.iat !== "undefined", "internal-error");
  return Number(parsedToken.exp) - Number(parsedToken.iat);
}
async function _logoutIfInvalidated(user, promise, bypassAuthState = false) {
  if (bypassAuthState) {
    return promise;
  }
  try {
    return await promise;
  } catch (e) {
    if (e instanceof FirebaseError && isUserInvalidated(e)) {
      if (user.auth.currentUser === user) {
        await user.auth.signOut();
      }
    }
    throw e;
  }
}
function isUserInvalidated({ code }) {
  return code === `auth/${"user-disabled"}` || code === `auth/${"user-token-expired"}`;
}

class ProactiveRefresh {
  constructor(user) {
    this.user = user;
    this.isRunning = false;
    this.timerId = null;
    this.errorBackoff = 30000;
  }
  _start() {
    if (this.isRunning) {
      return;
    }
    this.isRunning = true;
    this.schedule();
  }
  _stop() {
    if (!this.isRunning) {
      return;
    }
    this.isRunning = false;
    if (this.timerId !== null) {
      clearTimeout(this.timerId);
    }
  }
  getInterval(wasError) {
    var _a;
    if (wasError) {
      const interval = this.errorBackoff;
      this.errorBackoff = Math.min(this.errorBackoff * 2, 960000);
      return interval;
    } else {
      this.errorBackoff = 30000;
      const expTime = (_a = this.user.stsTokenManager.expirationTime) !== null && _a !== undefined ? _a : 0;
      const interval = expTime - Date.now() - 300000;
      return Math.max(0, interval);
    }
  }
  schedule(wasError = false) {
    if (!this.isRunning) {
      return;
    }
    const interval = this.getInterval(wasError);
    this.timerId = setTimeout(async () => {
      await this.iteration();
    }, interval);
  }
  async iteration() {
    try {
      await this.user.getIdToken(true);
    } catch (e) {
      if ((e === null || e === undefined ? undefined : e.code) === `auth/${"network-request-failed"}`) {
        this.schedule(true);
      }
      return;
    }
    this.schedule();
  }
}

class UserMetadata {
  constructor(createdAt, lastLoginAt) {
    this.createdAt = createdAt;
    this.lastLoginAt = lastLoginAt;
    this._initializeTime();
  }
  _initializeTime() {
    this.lastSignInTime = utcTimestampToDateString(this.lastLoginAt);
    this.creationTime = utcTimestampToDateString(this.createdAt);
  }
  _copy(metadata) {
    this.createdAt = metadata.createdAt;
    this.lastLoginAt = metadata.lastLoginAt;
    this._initializeTime();
  }
  toJSON() {
    return {
      createdAt: this.createdAt,
      lastLoginAt: this.lastLoginAt
    };
  }
}
async function _reloadWithoutSaving(user) {
  var _a;
  const auth = user.auth;
  const idToken = await user.getIdToken();
  const response = await _logoutIfInvalidated(user, getAccountInfo(auth, { idToken }));
  _assert(response === null || response === undefined ? undefined : response.users.length, auth, "internal-error");
  const coreAccount = response.users[0];
  user._notifyReloadListener(coreAccount);
  const newProviderData = ((_a = coreAccount.providerUserInfo) === null || _a === undefined ? undefined : _a.length) ? extractProviderData(coreAccount.providerUserInfo) : [];
  const providerData = mergeProviderData(user.providerData, newProviderData);
  const oldIsAnonymous = user.isAnonymous;
  const newIsAnonymous = !(user.email && coreAccount.passwordHash) && !(providerData === null || providerData === undefined ? undefined : providerData.length);
  const isAnonymous = !oldIsAnonymous ? false : newIsAnonymous;
  const updates = {
    uid: coreAccount.localId,
    displayName: coreAccount.displayName || null,
    photoURL: coreAccount.photoUrl || null,
    email: coreAccount.email || null,
    emailVerified: coreAccount.emailVerified || false,
    phoneNumber: coreAccount.phoneNumber || null,
    tenantId: coreAccount.tenantId || null,
    providerData,
    metadata: new UserMetadata(coreAccount.createdAt, coreAccount.lastLoginAt),
    isAnonymous
  };
  Object.assign(user, updates);
}
async function reload(user) {
  const userInternal = getModularInstance(user);
  await _reloadWithoutSaving(userInternal);
  await userInternal.auth._persistUserIfCurrent(userInternal);
  userInternal.auth._notifyListenersIfCurrent(userInternal);
}
function mergeProviderData(original, newData) {
  const deduped = original.filter((o) => !newData.some((n) => n.providerId === o.providerId));
  return [...deduped, ...newData];
}
function extractProviderData(providers) {
  return providers.map((_a) => {
    var { providerId } = _a, provider = __rest(_a, ["providerId"]);
    return {
      providerId,
      uid: provider.rawId || "",
      displayName: provider.displayName || null,
      email: provider.email || null,
      phoneNumber: provider.phoneNumber || null,
      photoURL: provider.photoUrl || null
    };
  });
}
async function requestStsToken(auth, refreshToken) {
  const response = await _performFetchWithErrorHandling(auth, {}, async () => {
    const body = querystring({
      grant_type: "refresh_token",
      refresh_token: refreshToken
    }).slice(1);
    const { tokenApiHost, apiKey } = auth.config;
    const url = _getFinalTarget(auth, tokenApiHost, "/v1/token", `key=${apiKey}`);
    const headers = await auth._getAdditionalHeaders();
    headers["Content-Type"] = "application/x-www-form-urlencoded";
    return FetchProvider.fetch()(url, {
      method: "POST",
      headers,
      body
    });
  });
  return {
    accessToken: response.access_token,
    expiresIn: response.expires_in,
    refreshToken: response.refresh_token
  };
}

class StsTokenManager {
  constructor() {
    this.refreshToken = null;
    this.accessToken = null;
    this.expirationTime = null;
  }
  get isExpired() {
    return !this.expirationTime || Date.now() > this.expirationTime - 30000;
  }
  updateFromServerResponse(response) {
    _assert(response.idToken, "internal-error");
    _assert(typeof response.idToken !== "undefined", "internal-error");
    _assert(typeof response.refreshToken !== "undefined", "internal-error");
    const expiresIn = "expiresIn" in response && typeof response.expiresIn !== "undefined" ? Number(response.expiresIn) : _tokenExpiresIn(response.idToken);
    this.updateTokensAndExpiration(response.idToken, response.refreshToken, expiresIn);
  }
  async getToken(auth, forceRefresh = false) {
    _assert(!this.accessToken || this.refreshToken, auth, "user-token-expired");
    if (!forceRefresh && this.accessToken && !this.isExpired) {
      return this.accessToken;
    }
    if (this.refreshToken) {
      await this.refresh(auth, this.refreshToken);
      return this.accessToken;
    }
    return null;
  }
  clearRefreshToken() {
    this.refreshToken = null;
  }
  async refresh(auth, oldToken) {
    const { accessToken, refreshToken, expiresIn } = await requestStsToken(auth, oldToken);
    this.updateTokensAndExpiration(accessToken, refreshToken, Number(expiresIn));
  }
  updateTokensAndExpiration(accessToken, refreshToken, expiresInSec) {
    this.refreshToken = refreshToken || null;
    this.accessToken = accessToken || null;
    this.expirationTime = Date.now() + expiresInSec * 1000;
  }
  static fromJSON(appName, object) {
    const { refreshToken, accessToken, expirationTime } = object;
    const manager = new StsTokenManager;
    if (refreshToken) {
      _assert(typeof refreshToken === "string", "internal-error", {
        appName
      });
      manager.refreshToken = refreshToken;
    }
    if (accessToken) {
      _assert(typeof accessToken === "string", "internal-error", {
        appName
      });
      manager.accessToken = accessToken;
    }
    if (expirationTime) {
      _assert(typeof expirationTime === "number", "internal-error", {
        appName
      });
      manager.expirationTime = expirationTime;
    }
    return manager;
  }
  toJSON() {
    return {
      refreshToken: this.refreshToken,
      accessToken: this.accessToken,
      expirationTime: this.expirationTime
    };
  }
  _assign(stsTokenManager) {
    this.accessToken = stsTokenManager.accessToken;
    this.refreshToken = stsTokenManager.refreshToken;
    this.expirationTime = stsTokenManager.expirationTime;
  }
  _clone() {
    return Object.assign(new StsTokenManager, this.toJSON());
  }
  _performRefresh() {
    return debugFail("not implemented");
  }
}
function assertStringOrUndefined(assertion, appName) {
  _assert(typeof assertion === "string" || typeof assertion === "undefined", "internal-error", { appName });
}

class UserImpl {
  constructor(_a) {
    var { uid, auth, stsTokenManager } = _a, opt = __rest(_a, ["uid", "auth", "stsTokenManager"]);
    this.providerId = "firebase";
    this.proactiveRefresh = new ProactiveRefresh(this);
    this.reloadUserInfo = null;
    this.reloadListener = null;
    this.uid = uid;
    this.auth = auth;
    this.stsTokenManager = stsTokenManager;
    this.accessToken = stsTokenManager.accessToken;
    this.displayName = opt.displayName || null;
    this.email = opt.email || null;
    this.emailVerified = opt.emailVerified || false;
    this.phoneNumber = opt.phoneNumber || null;
    this.photoURL = opt.photoURL || null;
    this.isAnonymous = opt.isAnonymous || false;
    this.tenantId = opt.tenantId || null;
    this.providerData = opt.providerData ? [...opt.providerData] : [];
    this.metadata = new UserMetadata(opt.createdAt || undefined, opt.lastLoginAt || undefined);
  }
  async getIdToken(forceRefresh) {
    const accessToken = await _logoutIfInvalidated(this, this.stsTokenManager.getToken(this.auth, forceRefresh));
    _assert(accessToken, this.auth, "internal-error");
    if (this.accessToken !== accessToken) {
      this.accessToken = accessToken;
      await this.auth._persistUserIfCurrent(this);
      this.auth._notifyListenersIfCurrent(this);
    }
    return accessToken;
  }
  getIdTokenResult(forceRefresh) {
    return getIdTokenResult(this, forceRefresh);
  }
  reload() {
    return reload(this);
  }
  _assign(user) {
    if (this === user) {
      return;
    }
    _assert(this.uid === user.uid, this.auth, "internal-error");
    this.displayName = user.displayName;
    this.photoURL = user.photoURL;
    this.email = user.email;
    this.emailVerified = user.emailVerified;
    this.phoneNumber = user.phoneNumber;
    this.isAnonymous = user.isAnonymous;
    this.tenantId = user.tenantId;
    this.providerData = user.providerData.map((userInfo) => Object.assign({}, userInfo));
    this.metadata._copy(user.metadata);
    this.stsTokenManager._assign(user.stsTokenManager);
  }
  _clone(auth) {
    const newUser = new UserImpl(Object.assign(Object.assign({}, this), { auth, stsTokenManager: this.stsTokenManager._clone() }));
    newUser.metadata._copy(this.metadata);
    return newUser;
  }
  _onReload(callback) {
    _assert(!this.reloadListener, this.auth, "internal-error");
    this.reloadListener = callback;
    if (this.reloadUserInfo) {
      this._notifyReloadListener(this.reloadUserInfo);
      this.reloadUserInfo = null;
    }
  }
  _notifyReloadListener(userInfo) {
    if (this.reloadListener) {
      this.reloadListener(userInfo);
    } else {
      this.reloadUserInfo = userInfo;
    }
  }
  _startProactiveRefresh() {
    this.proactiveRefresh._start();
  }
  _stopProactiveRefresh() {
    this.proactiveRefresh._stop();
  }
  async _updateTokensIfNecessary(response, reload2 = false) {
    let tokensRefreshed = false;
    if (response.idToken && response.idToken !== this.stsTokenManager.accessToken) {
      this.stsTokenManager.updateFromServerResponse(response);
      tokensRefreshed = true;
    }
    if (reload2) {
      await _reloadWithoutSaving(this);
    }
    await this.auth._persistUserIfCurrent(this);
    if (tokensRefreshed) {
      this.auth._notifyListenersIfCurrent(this);
    }
  }
  async delete() {
    const idToken = await this.getIdToken();
    await _logoutIfInvalidated(this, deleteAccount(this.auth, { idToken }));
    this.stsTokenManager.clearRefreshToken();
    return this.auth.signOut();
  }
  toJSON() {
    return Object.assign(Object.assign({
      uid: this.uid,
      email: this.email || undefined,
      emailVerified: this.emailVerified,
      displayName: this.displayName || undefined,
      isAnonymous: this.isAnonymous,
      photoURL: this.photoURL || undefined,
      phoneNumber: this.phoneNumber || undefined,
      tenantId: this.tenantId || undefined,
      providerData: this.providerData.map((userInfo) => Object.assign({}, userInfo)),
      stsTokenManager: this.stsTokenManager.toJSON(),
      _redirectEventId: this._redirectEventId
    }, this.metadata.toJSON()), {
      apiKey: this.auth.config.apiKey,
      appName: this.auth.name
    });
  }
  get refreshToken() {
    return this.stsTokenManager.refreshToken || "";
  }
  static _fromJSON(auth, object) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    const displayName = (_a = object.displayName) !== null && _a !== undefined ? _a : undefined;
    const email = (_b = object.email) !== null && _b !== undefined ? _b : undefined;
    const phoneNumber = (_c = object.phoneNumber) !== null && _c !== undefined ? _c : undefined;
    const photoURL = (_d = object.photoURL) !== null && _d !== undefined ? _d : undefined;
    const tenantId = (_e = object.tenantId) !== null && _e !== undefined ? _e : undefined;
    const _redirectEventId = (_f = object._redirectEventId) !== null && _f !== undefined ? _f : undefined;
    const createdAt = (_g = object.createdAt) !== null && _g !== undefined ? _g : undefined;
    const lastLoginAt = (_h = object.lastLoginAt) !== null && _h !== undefined ? _h : undefined;
    const { uid, emailVerified, isAnonymous, providerData, stsTokenManager: plainObjectTokenManager } = object;
    _assert(uid && plainObjectTokenManager, auth, "internal-error");
    const stsTokenManager = StsTokenManager.fromJSON(this.name, plainObjectTokenManager);
    _assert(typeof uid === "string", auth, "internal-error");
    assertStringOrUndefined(displayName, auth.name);
    assertStringOrUndefined(email, auth.name);
    _assert(typeof emailVerified === "boolean", auth, "internal-error");
    _assert(typeof isAnonymous === "boolean", auth, "internal-error");
    assertStringOrUndefined(phoneNumber, auth.name);
    assertStringOrUndefined(photoURL, auth.name);
    assertStringOrUndefined(tenantId, auth.name);
    assertStringOrUndefined(_redirectEventId, auth.name);
    assertStringOrUndefined(createdAt, auth.name);
    assertStringOrUndefined(lastLoginAt, auth.name);
    const user = new UserImpl({
      uid,
      auth,
      email,
      emailVerified,
      displayName,
      isAnonymous,
      photoURL,
      phoneNumber,
      tenantId,
      stsTokenManager,
      createdAt,
      lastLoginAt
    });
    if (providerData && Array.isArray(providerData)) {
      user.providerData = providerData.map((userInfo) => Object.assign({}, userInfo));
    }
    if (_redirectEventId) {
      user._redirectEventId = _redirectEventId;
    }
    return user;
  }
  static async _fromIdTokenResponse(auth, idTokenResponse, isAnonymous = false) {
    const stsTokenManager = new StsTokenManager;
    stsTokenManager.updateFromServerResponse(idTokenResponse);
    const user = new UserImpl({
      uid: idTokenResponse.localId,
      auth,
      stsTokenManager,
      isAnonymous
    });
    await _reloadWithoutSaving(user);
    return user;
  }
}
function _getInstance(cls) {
  debugAssert(cls instanceof Function, "Expected a class definition");
  let instance = instanceCache.get(cls);
  if (instance) {
    debugAssert(instance instanceof cls, "Instance stored in cache mismatched with class");
    return instance;
  }
  instance = new cls;
  instanceCache.set(cls, instance);
  return instance;
}

class InMemoryPersistence {
  constructor() {
    this.type = "NONE";
    this.storage = {};
  }
  async _isAvailable() {
    return true;
  }
  async _set(key, value) {
    this.storage[key] = value;
  }
  async _get(key) {
    const value = this.storage[key];
    return value === undefined ? null : value;
  }
  async _remove(key) {
    delete this.storage[key];
  }
  _addListener(_key, _listener) {
    return;
  }
  _removeListener(_key, _listener) {
    return;
  }
}
function _persistenceKeyName(key, apiKey, appName) {
  return `${"firebase"}:${key}:${apiKey}:${appName}`;
}

class PersistenceUserManager {
  constructor(persistence, auth, userKey) {
    this.persistence = persistence;
    this.auth = auth;
    this.userKey = userKey;
    const { config, name: name3 } = this.auth;
    this.fullUserKey = _persistenceKeyName(this.userKey, config.apiKey, name3);
    this.fullPersistenceKey = _persistenceKeyName("persistence", config.apiKey, name3);
    this.boundEventHandler = auth._onStorageEvent.bind(auth);
    this.persistence._addListener(this.fullUserKey, this.boundEventHandler);
  }
  setCurrentUser(user) {
    return this.persistence._set(this.fullUserKey, user.toJSON());
  }
  async getCurrentUser() {
    const blob = await this.persistence._get(this.fullUserKey);
    return blob ? UserImpl._fromJSON(this.auth, blob) : null;
  }
  removeCurrentUser() {
    return this.persistence._remove(this.fullUserKey);
  }
  savePersistenceForRedirect() {
    return this.persistence._set(this.fullPersistenceKey, this.persistence.type);
  }
  async setPersistence(newPersistence) {
    if (this.persistence === newPersistence) {
      return;
    }
    const currentUser = await this.getCurrentUser();
    await this.removeCurrentUser();
    this.persistence = newPersistence;
    if (currentUser) {
      return this.setCurrentUser(currentUser);
    }
  }
  delete() {
    this.persistence._removeListener(this.fullUserKey, this.boundEventHandler);
  }
  static async create(auth, persistenceHierarchy, userKey = "authUser") {
    if (!persistenceHierarchy.length) {
      return new PersistenceUserManager(_getInstance(inMemoryPersistence), auth, userKey);
    }
    const availablePersistences = (await Promise.all(persistenceHierarchy.map(async (persistence) => {
      if (await persistence._isAvailable()) {
        return persistence;
      }
      return;
    }))).filter((persistence) => persistence);
    let selectedPersistence = availablePersistences[0] || _getInstance(inMemoryPersistence);
    const key = _persistenceKeyName(userKey, auth.config.apiKey, auth.name);
    let userToMigrate = null;
    for (const persistence of persistenceHierarchy) {
      try {
        const blob = await persistence._get(key);
        if (blob) {
          const user = UserImpl._fromJSON(auth, blob);
          if (persistence !== selectedPersistence) {
            userToMigrate = user;
          }
          selectedPersistence = persistence;
          break;
        }
      } catch (_a) {}
    }
    const migrationHierarchy = availablePersistences.filter((p) => p._shouldAllowMigration);
    if (!selectedPersistence._shouldAllowMigration || !migrationHierarchy.length) {
      return new PersistenceUserManager(selectedPersistence, auth, userKey);
    }
    selectedPersistence = migrationHierarchy[0];
    if (userToMigrate) {
      await selectedPersistence._set(key, userToMigrate.toJSON());
    }
    await Promise.all(persistenceHierarchy.map(async (persistence) => {
      if (persistence !== selectedPersistence) {
        try {
          await persistence._remove(key);
        } catch (_a) {}
      }
    }));
    return new PersistenceUserManager(selectedPersistence, auth, userKey);
  }
}
function _getBrowserName(userAgent) {
  const ua = userAgent.toLowerCase();
  if (ua.includes("opera/") || ua.includes("opr/") || ua.includes("opios/")) {
    return "Opera";
  } else if (_isIEMobile(ua)) {
    return "IEMobile";
  } else if (ua.includes("msie") || ua.includes("trident/")) {
    return "IE";
  } else if (ua.includes("edge/")) {
    return "Edge";
  } else if (_isFirefox(ua)) {
    return "Firefox";
  } else if (ua.includes("silk/")) {
    return "Silk";
  } else if (_isBlackBerry(ua)) {
    return "Blackberry";
  } else if (_isWebOS(ua)) {
    return "Webos";
  } else if (_isSafari(ua)) {
    return "Safari";
  } else if ((ua.includes("chrome/") || _isChromeIOS(ua)) && !ua.includes("edge/")) {
    return "Chrome";
  } else if (_isAndroid(ua)) {
    return "Android";
  } else {
    const re = /([a-zA-Z\d\.]+)\/[a-zA-Z\d\.]*$/;
    const matches = userAgent.match(re);
    if ((matches === null || matches === undefined ? undefined : matches.length) === 2) {
      return matches[1];
    }
  }
  return "Other";
}
function _isFirefox(ua = getUA()) {
  return /firefox\//i.test(ua);
}
function _isSafari(userAgent = getUA()) {
  const ua = userAgent.toLowerCase();
  return ua.includes("safari/") && !ua.includes("chrome/") && !ua.includes("crios/") && !ua.includes("android");
}
function _isChromeIOS(ua = getUA()) {
  return /crios\//i.test(ua);
}
function _isIEMobile(ua = getUA()) {
  return /iemobile/i.test(ua);
}
function _isAndroid(ua = getUA()) {
  return /android/i.test(ua);
}
function _isBlackBerry(ua = getUA()) {
  return /blackberry/i.test(ua);
}
function _isWebOS(ua = getUA()) {
  return /webos/i.test(ua);
}
function _isIOS(ua = getUA()) {
  return /iphone|ipad|ipod/i.test(ua) || /macintosh/i.test(ua) && /mobile/i.test(ua);
}
function _isIOSStandalone(ua = getUA()) {
  var _a;
  return _isIOS(ua) && !!((_a = window.navigator) === null || _a === undefined ? undefined : _a.standalone);
}
function _isIE10() {
  return isIE() && document.documentMode === 10;
}
function _isMobileBrowser(ua = getUA()) {
  return _isIOS(ua) || _isAndroid(ua) || _isWebOS(ua) || _isBlackBerry(ua) || /windows phone/i.test(ua) || _isIEMobile(ua);
}
function _isIframe() {
  try {
    return !!(window && window !== window.top);
  } catch (e) {
    return false;
  }
}
function _getClientVersion(clientPlatform, frameworks = []) {
  let reportedPlatform;
  switch (clientPlatform) {
    case "Browser":
      reportedPlatform = _getBrowserName(getUA());
      break;
    case "Worker":
      reportedPlatform = `${_getBrowserName(getUA())}-${clientPlatform}`;
      break;
    default:
      reportedPlatform = clientPlatform;
  }
  const reportedFrameworks = frameworks.length ? frameworks.join(",") : "FirebaseCore-web";
  return `${reportedPlatform}/${"JsCore"}/${SDK_VERSION}/${reportedFrameworks}`;
}

class AuthMiddlewareQueue {
  constructor(auth) {
    this.auth = auth;
    this.queue = [];
  }
  pushCallback(callback, onAbort) {
    const wrappedCallback = (user) => new Promise((resolve, reject) => {
      try {
        const result = callback(user);
        resolve(result);
      } catch (e) {
        reject(e);
      }
    });
    wrappedCallback.onAbort = onAbort;
    this.queue.push(wrappedCallback);
    const index = this.queue.length - 1;
    return () => {
      this.queue[index] = () => Promise.resolve();
    };
  }
  async runMiddleware(nextUser) {
    if (this.auth.currentUser === nextUser) {
      return;
    }
    const onAbortStack = [];
    try {
      for (const beforeStateCallback of this.queue) {
        await beforeStateCallback(nextUser);
        if (beforeStateCallback.onAbort) {
          onAbortStack.push(beforeStateCallback.onAbort);
        }
      }
    } catch (e) {
      onAbortStack.reverse();
      for (const onAbort of onAbortStack) {
        try {
          onAbort();
        } catch (_) {}
      }
      throw this.auth._errorFactory.create("login-blocked", {
        originalMessage: e === null || e === undefined ? undefined : e.message
      });
    }
  }
}
async function _getPasswordPolicy(auth, request = {}) {
  return _performApiRequest(auth, "GET", "/v2/passwordPolicy", _addTidIfNecessary(auth, request));
}

class PasswordPolicyImpl {
  constructor(response) {
    var _a, _b, _c, _d;
    const responseOptions = response.customStrengthOptions;
    this.customStrengthOptions = {};
    this.customStrengthOptions.minPasswordLength = (_a = responseOptions.minPasswordLength) !== null && _a !== undefined ? _a : MINIMUM_MIN_PASSWORD_LENGTH;
    if (responseOptions.maxPasswordLength) {
      this.customStrengthOptions.maxPasswordLength = responseOptions.maxPasswordLength;
    }
    if (responseOptions.containsLowercaseCharacter !== undefined) {
      this.customStrengthOptions.containsLowercaseLetter = responseOptions.containsLowercaseCharacter;
    }
    if (responseOptions.containsUppercaseCharacter !== undefined) {
      this.customStrengthOptions.containsUppercaseLetter = responseOptions.containsUppercaseCharacter;
    }
    if (responseOptions.containsNumericCharacter !== undefined) {
      this.customStrengthOptions.containsNumericCharacter = responseOptions.containsNumericCharacter;
    }
    if (responseOptions.containsNonAlphanumericCharacter !== undefined) {
      this.customStrengthOptions.containsNonAlphanumericCharacter = responseOptions.containsNonAlphanumericCharacter;
    }
    this.enforcementState = response.enforcementState;
    if (this.enforcementState === "ENFORCEMENT_STATE_UNSPECIFIED") {
      this.enforcementState = "OFF";
    }
    this.allowedNonAlphanumericCharacters = (_c = (_b = response.allowedNonAlphanumericCharacters) === null || _b === undefined ? undefined : _b.join("")) !== null && _c !== undefined ? _c : "";
    this.forceUpgradeOnSignin = (_d = response.forceUpgradeOnSignin) !== null && _d !== undefined ? _d : false;
    this.schemaVersion = response.schemaVersion;
  }
  validatePassword(password) {
    var _a, _b, _c, _d, _e, _f;
    const status = {
      isValid: true,
      passwordPolicy: this
    };
    this.validatePasswordLengthOptions(password, status);
    this.validatePasswordCharacterOptions(password, status);
    status.isValid && (status.isValid = (_a = status.meetsMinPasswordLength) !== null && _a !== undefined ? _a : true);
    status.isValid && (status.isValid = (_b = status.meetsMaxPasswordLength) !== null && _b !== undefined ? _b : true);
    status.isValid && (status.isValid = (_c = status.containsLowercaseLetter) !== null && _c !== undefined ? _c : true);
    status.isValid && (status.isValid = (_d = status.containsUppercaseLetter) !== null && _d !== undefined ? _d : true);
    status.isValid && (status.isValid = (_e = status.containsNumericCharacter) !== null && _e !== undefined ? _e : true);
    status.isValid && (status.isValid = (_f = status.containsNonAlphanumericCharacter) !== null && _f !== undefined ? _f : true);
    return status;
  }
  validatePasswordLengthOptions(password, status) {
    const minPasswordLength = this.customStrengthOptions.minPasswordLength;
    const maxPasswordLength = this.customStrengthOptions.maxPasswordLength;
    if (minPasswordLength) {
      status.meetsMinPasswordLength = password.length >= minPasswordLength;
    }
    if (maxPasswordLength) {
      status.meetsMaxPasswordLength = password.length <= maxPasswordLength;
    }
  }
  validatePasswordCharacterOptions(password, status) {
    this.updatePasswordCharacterOptionsStatuses(status, false, false, false, false);
    let passwordChar;
    for (let i = 0;i < password.length; i++) {
      passwordChar = password.charAt(i);
      this.updatePasswordCharacterOptionsStatuses(status, passwordChar >= "a" && passwordChar <= "z", passwordChar >= "A" && passwordChar <= "Z", passwordChar >= "0" && passwordChar <= "9", this.allowedNonAlphanumericCharacters.includes(passwordChar));
    }
  }
  updatePasswordCharacterOptionsStatuses(status, containsLowercaseCharacter, containsUppercaseCharacter, containsNumericCharacter, containsNonAlphanumericCharacter) {
    if (this.customStrengthOptions.containsLowercaseLetter) {
      status.containsLowercaseLetter || (status.containsLowercaseLetter = containsLowercaseCharacter);
    }
    if (this.customStrengthOptions.containsUppercaseLetter) {
      status.containsUppercaseLetter || (status.containsUppercaseLetter = containsUppercaseCharacter);
    }
    if (this.customStrengthOptions.containsNumericCharacter) {
      status.containsNumericCharacter || (status.containsNumericCharacter = containsNumericCharacter);
    }
    if (this.customStrengthOptions.containsNonAlphanumericCharacter) {
      status.containsNonAlphanumericCharacter || (status.containsNonAlphanumericCharacter = containsNonAlphanumericCharacter);
    }
  }
}

class AuthImpl {
  constructor(app2, heartbeatServiceProvider, appCheckServiceProvider, config) {
    this.app = app2;
    this.heartbeatServiceProvider = heartbeatServiceProvider;
    this.appCheckServiceProvider = appCheckServiceProvider;
    this.config = config;
    this.currentUser = null;
    this.emulatorConfig = null;
    this.operations = Promise.resolve();
    this.authStateSubscription = new Subscription(this);
    this.idTokenSubscription = new Subscription(this);
    this.beforeStateQueue = new AuthMiddlewareQueue(this);
    this.redirectUser = null;
    this.isProactiveRefreshEnabled = false;
    this.EXPECTED_PASSWORD_POLICY_SCHEMA_VERSION = 1;
    this._canInitEmulator = true;
    this._isInitialized = false;
    this._deleted = false;
    this._initializationPromise = null;
    this._popupRedirectResolver = null;
    this._errorFactory = _DEFAULT_AUTH_ERROR_FACTORY;
    this._agentRecaptchaConfig = null;
    this._tenantRecaptchaConfigs = {};
    this._projectPasswordPolicy = null;
    this._tenantPasswordPolicies = {};
    this.lastNotifiedUid = undefined;
    this.languageCode = null;
    this.tenantId = null;
    this.settings = { appVerificationDisabledForTesting: false };
    this.frameworks = [];
    this.name = app2.name;
    this.clientVersion = config.sdkClientVersion;
  }
  _initializeWithPersistence(persistenceHierarchy, popupRedirectResolver) {
    if (popupRedirectResolver) {
      this._popupRedirectResolver = _getInstance(popupRedirectResolver);
    }
    this._initializationPromise = this.queue(async () => {
      var _a, _b;
      if (this._deleted) {
        return;
      }
      this.persistenceManager = await PersistenceUserManager.create(this, persistenceHierarchy);
      if (this._deleted) {
        return;
      }
      if ((_a = this._popupRedirectResolver) === null || _a === undefined ? undefined : _a._shouldInitProactively) {
        try {
          await this._popupRedirectResolver._initialize(this);
        } catch (e) {}
      }
      await this.initializeCurrentUser(popupRedirectResolver);
      this.lastNotifiedUid = ((_b = this.currentUser) === null || _b === undefined ? undefined : _b.uid) || null;
      if (this._deleted) {
        return;
      }
      this._isInitialized = true;
    });
    return this._initializationPromise;
  }
  async _onStorageEvent() {
    if (this._deleted) {
      return;
    }
    const user = await this.assertedPersistence.getCurrentUser();
    if (!this.currentUser && !user) {
      return;
    }
    if (this.currentUser && user && this.currentUser.uid === user.uid) {
      this._currentUser._assign(user);
      await this.currentUser.getIdToken();
      return;
    }
    await this._updateCurrentUser(user, true);
  }
  async initializeCurrentUser(popupRedirectResolver) {
    var _a;
    const previouslyStoredUser = await this.assertedPersistence.getCurrentUser();
    let futureCurrentUser = previouslyStoredUser;
    let needsTocheckMiddleware = false;
    if (popupRedirectResolver && this.config.authDomain) {
      await this.getOrInitRedirectPersistenceManager();
      const redirectUserEventId = (_a = this.redirectUser) === null || _a === undefined ? undefined : _a._redirectEventId;
      const storedUserEventId = futureCurrentUser === null || futureCurrentUser === undefined ? undefined : futureCurrentUser._redirectEventId;
      const result = await this.tryRedirectSignIn(popupRedirectResolver);
      if ((!redirectUserEventId || redirectUserEventId === storedUserEventId) && (result === null || result === undefined ? undefined : result.user)) {
        futureCurrentUser = result.user;
        needsTocheckMiddleware = true;
      }
    }
    if (!futureCurrentUser) {
      return this.directlySetCurrentUser(null);
    }
    if (!futureCurrentUser._redirectEventId) {
      if (needsTocheckMiddleware) {
        try {
          await this.beforeStateQueue.runMiddleware(futureCurrentUser);
        } catch (e) {
          futureCurrentUser = previouslyStoredUser;
          this._popupRedirectResolver._overrideRedirectResult(this, () => Promise.reject(e));
        }
      }
      if (futureCurrentUser) {
        return this.reloadAndSetCurrentUserOrClear(futureCurrentUser);
      } else {
        return this.directlySetCurrentUser(null);
      }
    }
    _assert(this._popupRedirectResolver, this, "argument-error");
    await this.getOrInitRedirectPersistenceManager();
    if (this.redirectUser && this.redirectUser._redirectEventId === futureCurrentUser._redirectEventId) {
      return this.directlySetCurrentUser(futureCurrentUser);
    }
    return this.reloadAndSetCurrentUserOrClear(futureCurrentUser);
  }
  async tryRedirectSignIn(redirectResolver) {
    let result = null;
    try {
      result = await this._popupRedirectResolver._completeRedirectFn(this, redirectResolver, true);
    } catch (e) {
      await this._setRedirectUser(null);
    }
    return result;
  }
  async reloadAndSetCurrentUserOrClear(user) {
    try {
      await _reloadWithoutSaving(user);
    } catch (e) {
      if ((e === null || e === undefined ? undefined : e.code) !== `auth/${"network-request-failed"}`) {
        return this.directlySetCurrentUser(null);
      }
    }
    return this.directlySetCurrentUser(user);
  }
  useDeviceLanguage() {
    this.languageCode = _getUserLanguage();
  }
  async _delete() {
    this._deleted = true;
  }
  async updateCurrentUser(userExtern) {
    const user = userExtern ? getModularInstance(userExtern) : null;
    if (user) {
      _assert(user.auth.config.apiKey === this.config.apiKey, this, "invalid-user-token");
    }
    return this._updateCurrentUser(user && user._clone(this));
  }
  async _updateCurrentUser(user, skipBeforeStateCallbacks = false) {
    if (this._deleted) {
      return;
    }
    if (user) {
      _assert(this.tenantId === user.tenantId, this, "tenant-id-mismatch");
    }
    if (!skipBeforeStateCallbacks) {
      await this.beforeStateQueue.runMiddleware(user);
    }
    return this.queue(async () => {
      await this.directlySetCurrentUser(user);
      this.notifyAuthListeners();
    });
  }
  async signOut() {
    await this.beforeStateQueue.runMiddleware(null);
    if (this.redirectPersistenceManager || this._popupRedirectResolver) {
      await this._setRedirectUser(null);
    }
    return this._updateCurrentUser(null, true);
  }
  setPersistence(persistence) {
    return this.queue(async () => {
      await this.assertedPersistence.setPersistence(_getInstance(persistence));
    });
  }
  _getRecaptchaConfig() {
    if (this.tenantId == null) {
      return this._agentRecaptchaConfig;
    } else {
      return this._tenantRecaptchaConfigs[this.tenantId];
    }
  }
  async validatePassword(password) {
    if (!this._getPasswordPolicyInternal()) {
      await this._updatePasswordPolicy();
    }
    const passwordPolicy = this._getPasswordPolicyInternal();
    if (passwordPolicy.schemaVersion !== this.EXPECTED_PASSWORD_POLICY_SCHEMA_VERSION) {
      return Promise.reject(this._errorFactory.create("unsupported-password-policy-schema-version", {}));
    }
    return passwordPolicy.validatePassword(password);
  }
  _getPasswordPolicyInternal() {
    if (this.tenantId === null) {
      return this._projectPasswordPolicy;
    } else {
      return this._tenantPasswordPolicies[this.tenantId];
    }
  }
  async _updatePasswordPolicy() {
    const response = await _getPasswordPolicy(this);
    const passwordPolicy = new PasswordPolicyImpl(response);
    if (this.tenantId === null) {
      this._projectPasswordPolicy = passwordPolicy;
    } else {
      this._tenantPasswordPolicies[this.tenantId] = passwordPolicy;
    }
  }
  _getPersistence() {
    return this.assertedPersistence.persistence.type;
  }
  _updateErrorMap(errorMap) {
    this._errorFactory = new ErrorFactory("auth", "Firebase", errorMap());
  }
  onAuthStateChanged(nextOrObserver, error, completed) {
    return this.registerStateListener(this.authStateSubscription, nextOrObserver, error, completed);
  }
  beforeAuthStateChanged(callback, onAbort) {
    return this.beforeStateQueue.pushCallback(callback, onAbort);
  }
  onIdTokenChanged(nextOrObserver, error, completed) {
    return this.registerStateListener(this.idTokenSubscription, nextOrObserver, error, completed);
  }
  authStateReady() {
    return new Promise((resolve, reject) => {
      if (this.currentUser) {
        resolve();
      } else {
        const unsubscribe = this.onAuthStateChanged(() => {
          unsubscribe();
          resolve();
        }, reject);
      }
    });
  }
  toJSON() {
    var _a;
    return {
      apiKey: this.config.apiKey,
      authDomain: this.config.authDomain,
      appName: this.name,
      currentUser: (_a = this._currentUser) === null || _a === undefined ? undefined : _a.toJSON()
    };
  }
  async _setRedirectUser(user, popupRedirectResolver) {
    const redirectManager = await this.getOrInitRedirectPersistenceManager(popupRedirectResolver);
    return user === null ? redirectManager.removeCurrentUser() : redirectManager.setCurrentUser(user);
  }
  async getOrInitRedirectPersistenceManager(popupRedirectResolver) {
    if (!this.redirectPersistenceManager) {
      const resolver = popupRedirectResolver && _getInstance(popupRedirectResolver) || this._popupRedirectResolver;
      _assert(resolver, this, "argument-error");
      this.redirectPersistenceManager = await PersistenceUserManager.create(this, [_getInstance(resolver._redirectPersistence)], "redirectUser");
      this.redirectUser = await this.redirectPersistenceManager.getCurrentUser();
    }
    return this.redirectPersistenceManager;
  }
  async _redirectUserForId(id) {
    var _a, _b;
    if (this._isInitialized) {
      await this.queue(async () => {});
    }
    if (((_a = this._currentUser) === null || _a === undefined ? undefined : _a._redirectEventId) === id) {
      return this._currentUser;
    }
    if (((_b = this.redirectUser) === null || _b === undefined ? undefined : _b._redirectEventId) === id) {
      return this.redirectUser;
    }
    return null;
  }
  async _persistUserIfCurrent(user) {
    if (user === this.currentUser) {
      return this.queue(async () => this.directlySetCurrentUser(user));
    }
  }
  _notifyListenersIfCurrent(user) {
    if (user === this.currentUser) {
      this.notifyAuthListeners();
    }
  }
  _key() {
    return `${this.config.authDomain}:${this.config.apiKey}:${this.name}`;
  }
  _startProactiveRefresh() {
    this.isProactiveRefreshEnabled = true;
    if (this.currentUser) {
      this._currentUser._startProactiveRefresh();
    }
  }
  _stopProactiveRefresh() {
    this.isProactiveRefreshEnabled = false;
    if (this.currentUser) {
      this._currentUser._stopProactiveRefresh();
    }
  }
  get _currentUser() {
    return this.currentUser;
  }
  notifyAuthListeners() {
    var _a, _b;
    if (!this._isInitialized) {
      return;
    }
    this.idTokenSubscription.next(this.currentUser);
    const currentUid = (_b = (_a = this.currentUser) === null || _a === undefined ? undefined : _a.uid) !== null && _b !== undefined ? _b : null;
    if (this.lastNotifiedUid !== currentUid) {
      this.lastNotifiedUid = currentUid;
      this.authStateSubscription.next(this.currentUser);
    }
  }
  registerStateListener(subscription, nextOrObserver, error, completed) {
    if (this._deleted) {
      return () => {};
    }
    const cb = typeof nextOrObserver === "function" ? nextOrObserver : nextOrObserver.next.bind(nextOrObserver);
    let isUnsubscribed = false;
    const promise = this._isInitialized ? Promise.resolve() : this._initializationPromise;
    _assert(promise, this, "internal-error");
    promise.then(() => {
      if (isUnsubscribed) {
        return;
      }
      cb(this.currentUser);
    });
    if (typeof nextOrObserver === "function") {
      const unsubscribe = subscription.addObserver(nextOrObserver, error, completed);
      return () => {
        isUnsubscribed = true;
        unsubscribe();
      };
    } else {
      const unsubscribe = subscription.addObserver(nextOrObserver);
      return () => {
        isUnsubscribed = true;
        unsubscribe();
      };
    }
  }
  async directlySetCurrentUser(user) {
    if (this.currentUser && this.currentUser !== user) {
      this._currentUser._stopProactiveRefresh();
    }
    if (user && this.isProactiveRefreshEnabled) {
      user._startProactiveRefresh();
    }
    this.currentUser = user;
    if (user) {
      await this.assertedPersistence.setCurrentUser(user);
    } else {
      await this.assertedPersistence.removeCurrentUser();
    }
  }
  queue(action) {
    this.operations = this.operations.then(action, action);
    return this.operations;
  }
  get assertedPersistence() {
    _assert(this.persistenceManager, this, "internal-error");
    return this.persistenceManager;
  }
  _logFramework(framework) {
    if (!framework || this.frameworks.includes(framework)) {
      return;
    }
    this.frameworks.push(framework);
    this.frameworks.sort();
    this.clientVersion = _getClientVersion(this.config.clientPlatform, this._getFrameworks());
  }
  _getFrameworks() {
    return this.frameworks;
  }
  async _getAdditionalHeaders() {
    var _a;
    const headers = {
      ["X-Client-Version"]: this.clientVersion
    };
    if (this.app.options.appId) {
      headers["X-Firebase-gmpid"] = this.app.options.appId;
    }
    const heartbeatsHeader = await ((_a = this.heartbeatServiceProvider.getImmediate({
      optional: true
    })) === null || _a === undefined ? undefined : _a.getHeartbeatsHeader());
    if (heartbeatsHeader) {
      headers["X-Firebase-Client"] = heartbeatsHeader;
    }
    const appCheckToken = await this._getAppCheckToken();
    if (appCheckToken) {
      headers["X-Firebase-AppCheck"] = appCheckToken;
    }
    return headers;
  }
  async _getAppCheckToken() {
    var _a;
    const appCheckTokenResult = await ((_a = this.appCheckServiceProvider.getImmediate({ optional: true })) === null || _a === undefined ? undefined : _a.getToken());
    if (appCheckTokenResult === null || appCheckTokenResult === undefined ? undefined : appCheckTokenResult.error) {
      _logWarn(`Error while retrieving App Check token: ${appCheckTokenResult.error}`);
    }
    return appCheckTokenResult === null || appCheckTokenResult === undefined ? undefined : appCheckTokenResult.token;
  }
}
function _castAuth(auth) {
  return getModularInstance(auth);
}

class Subscription {
  constructor(auth) {
    this.auth = auth;
    this.observer = null;
    this.addObserver = createSubscribe((observer) => this.observer = observer);
  }
  get next() {
    _assert(this.observer, this.auth, "internal-error");
    return this.observer.next.bind(this.observer);
  }
}
function getScriptParentElement() {
  var _a, _b;
  return (_b = (_a = document.getElementsByTagName("head")) === null || _a === undefined ? undefined : _a[0]) !== null && _b !== undefined ? _b : document;
}
function _loadJS(url) {
  return new Promise((resolve, reject) => {
    const el = document.createElement("script");
    el.setAttribute("src", url);
    el.onload = resolve;
    el.onerror = (e) => {
      const error = _createError("internal-error");
      error.customData = e;
      reject(error);
    };
    el.type = "text/javascript";
    el.charset = "UTF-8";
    getScriptParentElement().appendChild(el);
  });
}
function _generateCallbackName(prefix) {
  return `__${prefix}${Math.floor(Math.random() * 1e6)}`;
}

class RecaptchaEnterpriseVerifier {
  constructor(authExtern) {
    this.type = RECAPTCHA_ENTERPRISE_VERIFIER_TYPE;
    this.auth = _castAuth(authExtern);
  }
  async verify(action = "verify", forceRefresh = false) {
    async function retrieveSiteKey(auth) {
      if (!forceRefresh) {
        if (auth.tenantId == null && auth._agentRecaptchaConfig != null) {
          return auth._agentRecaptchaConfig.siteKey;
        }
        if (auth.tenantId != null && auth._tenantRecaptchaConfigs[auth.tenantId] !== undefined) {
          return auth._tenantRecaptchaConfigs[auth.tenantId].siteKey;
        }
      }
      return new Promise(async (resolve, reject) => {
        getRecaptchaConfig(auth, {
          clientType: "CLIENT_TYPE_WEB",
          version: "RECAPTCHA_ENTERPRISE"
        }).then((response) => {
          if (response.recaptchaKey === undefined) {
            reject(new Error("recaptcha Enterprise site key undefined"));
          } else {
            const config = new RecaptchaConfig(response);
            if (auth.tenantId == null) {
              auth._agentRecaptchaConfig = config;
            } else {
              auth._tenantRecaptchaConfigs[auth.tenantId] = config;
            }
            return resolve(config.siteKey);
          }
        }).catch((error) => {
          reject(error);
        });
      });
    }
    function retrieveRecaptchaToken(siteKey, resolve, reject) {
      const grecaptcha = window.grecaptcha;
      if (isEnterprise(grecaptcha)) {
        grecaptcha.enterprise.ready(() => {
          grecaptcha.enterprise.execute(siteKey, { action }).then((token) => {
            resolve(token);
          }).catch(() => {
            resolve(FAKE_TOKEN);
          });
        });
      } else {
        reject(Error("No reCAPTCHA enterprise script loaded."));
      }
    }
    return new Promise((resolve, reject) => {
      retrieveSiteKey(this.auth).then((siteKey) => {
        if (!forceRefresh && isEnterprise(window.grecaptcha)) {
          retrieveRecaptchaToken(siteKey, resolve, reject);
        } else {
          if (typeof window === "undefined") {
            reject(new Error("RecaptchaVerifier is only supported in browser"));
            return;
          }
          _loadJS(RECAPTCHA_ENTERPRISE_URL + siteKey).then(() => {
            retrieveRecaptchaToken(siteKey, resolve, reject);
          }).catch((error) => {
            reject(error);
          });
        }
      }).catch((error) => {
        reject(error);
      });
    });
  }
}
async function injectRecaptchaFields(auth, request, action, captchaResp = false) {
  const verifier = new RecaptchaEnterpriseVerifier(auth);
  let captchaResponse;
  try {
    captchaResponse = await verifier.verify(action);
  } catch (error) {
    captchaResponse = await verifier.verify(action, true);
  }
  const newRequest = Object.assign({}, request);
  if (!captchaResp) {
    Object.assign(newRequest, { captchaResponse });
  } else {
    Object.assign(newRequest, { captchaResp: captchaResponse });
  }
  Object.assign(newRequest, { clientType: "CLIENT_TYPE_WEB" });
  Object.assign(newRequest, {
    recaptchaVersion: "RECAPTCHA_ENTERPRISE"
  });
  return newRequest;
}
function initializeAuth(app2, deps) {
  const provider = _getProvider(app2, "auth");
  if (provider.isInitialized()) {
    const auth2 = provider.getImmediate();
    const initialOptions = provider.getOptions();
    if (deepEqual(initialOptions, deps !== null && deps !== undefined ? deps : {})) {
      return auth2;
    } else {
      _fail(auth2, "already-initialized");
    }
  }
  const auth = provider.initialize({ options: deps });
  return auth;
}
function _initializeAuthInstance(auth, deps) {
  const persistence = (deps === null || deps === undefined ? undefined : deps.persistence) || [];
  const hierarchy = (Array.isArray(persistence) ? persistence : [persistence]).map(_getInstance);
  if (deps === null || deps === undefined ? undefined : deps.errorMap) {
    auth._updateErrorMap(deps.errorMap);
  }
  auth._initializeWithPersistence(hierarchy, deps === null || deps === undefined ? undefined : deps.popupRedirectResolver);
}
function connectAuthEmulator(auth, url, options) {
  const authInternal = _castAuth(auth);
  _assert(authInternal._canInitEmulator, authInternal, "emulator-config-failed");
  _assert(/^https?:\/\//.test(url), authInternal, "invalid-emulator-scheme");
  const disableWarnings = !!(options === null || options === undefined ? undefined : options.disableWarnings);
  const protocol = extractProtocol(url);
  const { host, port } = extractHostAndPort(url);
  const portStr = port === null ? "" : `:${port}`;
  authInternal.config.emulator = { url: `${protocol}//${host}${portStr}/` };
  authInternal.settings.appVerificationDisabledForTesting = true;
  authInternal.emulatorConfig = Object.freeze({
    host,
    port,
    protocol: protocol.replace(":", ""),
    options: Object.freeze({ disableWarnings })
  });
  if (!disableWarnings) {
    emitEmulatorWarning();
  }
}
function extractProtocol(url) {
  const protocolEnd = url.indexOf(":");
  return protocolEnd < 0 ? "" : url.substr(0, protocolEnd + 1);
}
function extractHostAndPort(url) {
  const protocol = extractProtocol(url);
  const authority = /(\/\/)?([^?#/]+)/.exec(url.substr(protocol.length));
  if (!authority) {
    return { host: "", port: null };
  }
  const hostAndPort = authority[2].split("@").pop() || "";
  const bracketedIPv6 = /^(\[[^\]]+\])(:|$)/.exec(hostAndPort);
  if (bracketedIPv6) {
    const host = bracketedIPv6[1];
    return { host, port: parsePort(hostAndPort.substr(host.length + 1)) };
  } else {
    const [host, port] = hostAndPort.split(":");
    return { host, port: parsePort(port) };
  }
}
function parsePort(portStr) {
  if (!portStr) {
    return null;
  }
  const port = Number(portStr);
  if (isNaN(port)) {
    return null;
  }
  return port;
}
function emitEmulatorWarning() {
  function attachBanner() {
    const el = document.createElement("p");
    const sty = el.style;
    el.innerText = "Running in emulator mode. Do not use with production credentials.";
    sty.position = "fixed";
    sty.width = "100%";
    sty.backgroundColor = "#ffffff";
    sty.border = ".1em solid #000000";
    sty.color = "#b50000";
    sty.bottom = "0px";
    sty.left = "0px";
    sty.margin = "0px";
    sty.zIndex = "10000";
    sty.textAlign = "center";
    el.classList.add("firebase-emulator-warning");
    document.body.appendChild(el);
  }
  if (typeof console !== "undefined" && typeof console.info === "function") {
    console.info("WARNING: You are using the Auth Emulator," + " which is intended for local testing only.  Do not use with" + " production credentials.");
  }
  if (typeof window !== "undefined" && typeof document !== "undefined") {
    if (document.readyState === "loading") {
      window.addEventListener("DOMContentLoaded", attachBanner);
    } else {
      attachBanner();
    }
  }
}

class AuthCredential {
  constructor(providerId, signInMethod) {
    this.providerId = providerId;
    this.signInMethod = signInMethod;
  }
  toJSON() {
    return debugFail("not implemented");
  }
  _getIdTokenResponse(_auth) {
    return debugFail("not implemented");
  }
  _linkToIdToken(_auth, _idToken) {
    return debugFail("not implemented");
  }
  _getReauthenticationResolver(_auth) {
    return debugFail("not implemented");
  }
}
async function updateEmailPassword(auth, request) {
  return _performApiRequest(auth, "POST", "/v1/accounts:update", request);
}
async function signInWithPassword(auth, request) {
  return _performSignInRequest(auth, "POST", "/v1/accounts:signInWithPassword", _addTidIfNecessary(auth, request));
}
async function signInWithEmailLink$1(auth, request) {
  return _performSignInRequest(auth, "POST", "/v1/accounts:signInWithEmailLink", _addTidIfNecessary(auth, request));
}
async function signInWithEmailLinkForLinking(auth, request) {
  return _performSignInRequest(auth, "POST", "/v1/accounts:signInWithEmailLink", _addTidIfNecessary(auth, request));
}
async function signInWithIdp(auth, request) {
  return _performSignInRequest(auth, "POST", "/v1/accounts:signInWithIdp", _addTidIfNecessary(auth, request));
}
async function sendPhoneVerificationCode(auth, request) {
  return _performApiRequest(auth, "POST", "/v1/accounts:sendVerificationCode", _addTidIfNecessary(auth, request));
}
async function signInWithPhoneNumber$1(auth, request) {
  return _performSignInRequest(auth, "POST", "/v1/accounts:signInWithPhoneNumber", _addTidIfNecessary(auth, request));
}
async function linkWithPhoneNumber$1(auth, request) {
  const response = await _performSignInRequest(auth, "POST", "/v1/accounts:signInWithPhoneNumber", _addTidIfNecessary(auth, request));
  if (response.temporaryProof) {
    throw _makeTaggedError(auth, "account-exists-with-different-credential", response);
  }
  return response;
}
async function verifyPhoneNumberForExisting(auth, request) {
  const apiRequest = Object.assign(Object.assign({}, request), { operation: "REAUTH" });
  return _performSignInRequest(auth, "POST", "/v1/accounts:signInWithPhoneNumber", _addTidIfNecessary(auth, apiRequest), VERIFY_PHONE_NUMBER_FOR_EXISTING_ERROR_MAP_);
}
function parseMode(mode) {
  switch (mode) {
    case "recoverEmail":
      return "RECOVER_EMAIL";
    case "resetPassword":
      return "PASSWORD_RESET";
    case "signIn":
      return "EMAIL_SIGNIN";
    case "verifyEmail":
      return "VERIFY_EMAIL";
    case "verifyAndChangeEmail":
      return "VERIFY_AND_CHANGE_EMAIL";
    case "revertSecondFactorAddition":
      return "REVERT_SECOND_FACTOR_ADDITION";
    default:
      return null;
  }
}
function parseDeepLink(url) {
  const link = querystringDecode(extractQuerystring(url))["link"];
  const doubleDeepLink = link ? querystringDecode(extractQuerystring(link))["deep_link_id"] : null;
  const iOSDeepLink = querystringDecode(extractQuerystring(url))["deep_link_id"];
  const iOSDoubleDeepLink = iOSDeepLink ? querystringDecode(extractQuerystring(iOSDeepLink))["link"] : null;
  return iOSDoubleDeepLink || iOSDeepLink || doubleDeepLink || link || url;
}

class ActionCodeURL {
  constructor(actionLink) {
    var _a, _b, _c, _d, _e, _f;
    const searchParams = querystringDecode(extractQuerystring(actionLink));
    const apiKey = (_a = searchParams["apiKey"]) !== null && _a !== undefined ? _a : null;
    const code = (_b = searchParams["oobCode"]) !== null && _b !== undefined ? _b : null;
    const operation = parseMode((_c = searchParams["mode"]) !== null && _c !== undefined ? _c : null);
    _assert(apiKey && code && operation, "argument-error");
    this.apiKey = apiKey;
    this.operation = operation;
    this.code = code;
    this.continueUrl = (_d = searchParams["continueUrl"]) !== null && _d !== undefined ? _d : null;
    this.languageCode = (_e = searchParams["languageCode"]) !== null && _e !== undefined ? _e : null;
    this.tenantId = (_f = searchParams["tenantId"]) !== null && _f !== undefined ? _f : null;
  }
  static parseLink(link) {
    const actionLink = parseDeepLink(link);
    try {
      return new ActionCodeURL(actionLink);
    } catch (_a) {
      return null;
    }
  }
}

class EmailAuthProvider {
  constructor() {
    this.providerId = EmailAuthProvider.PROVIDER_ID;
  }
  static credential(email, password) {
    return EmailAuthCredential._fromEmailAndPassword(email, password);
  }
  static credentialWithLink(email, emailLink) {
    const actionCodeUrl = ActionCodeURL.parseLink(emailLink);
    _assert(actionCodeUrl, "argument-error");
    return EmailAuthCredential._fromEmailAndCode(email, actionCodeUrl.code, actionCodeUrl.tenantId);
  }
}

class FederatedAuthProvider {
  constructor(providerId) {
    this.providerId = providerId;
    this.defaultLanguageCode = null;
    this.customParameters = {};
  }
  setDefaultLanguage(languageCode) {
    this.defaultLanguageCode = languageCode;
  }
  setCustomParameters(customOAuthParameters) {
    this.customParameters = customOAuthParameters;
    return this;
  }
  getCustomParameters() {
    return this.customParameters;
  }
}
async function signUp(auth, request) {
  return _performSignInRequest(auth, "POST", "/v1/accounts:signUp", _addTidIfNecessary(auth, request));
}

class UserCredentialImpl {
  constructor(params) {
    this.user = params.user;
    this.providerId = params.providerId;
    this._tokenResponse = params._tokenResponse;
    this.operationType = params.operationType;
  }
  static async _fromIdTokenResponse(auth, operationType, idTokenResponse, isAnonymous = false) {
    const user = await UserImpl._fromIdTokenResponse(auth, idTokenResponse, isAnonymous);
    const providerId = providerIdForResponse(idTokenResponse);
    const userCred = new UserCredentialImpl({
      user,
      providerId,
      _tokenResponse: idTokenResponse,
      operationType
    });
    return userCred;
  }
  static async _forOperation(user, operationType, response) {
    await user._updateTokensIfNecessary(response, true);
    const providerId = providerIdForResponse(response);
    return new UserCredentialImpl({
      user,
      providerId,
      _tokenResponse: response,
      operationType
    });
  }
}
function providerIdForResponse(response) {
  if (response.providerId) {
    return response.providerId;
  }
  if ("phoneNumber" in response) {
    return "phone";
  }
  return null;
}
async function signInAnonymously(auth) {
  var _a;
  const authInternal = _castAuth(auth);
  await authInternal._initializationPromise;
  if ((_a = authInternal.currentUser) === null || _a === undefined ? undefined : _a.isAnonymous) {
    return new UserCredentialImpl({
      user: authInternal.currentUser,
      providerId: null,
      operationType: "signIn"
    });
  }
  const response = await signUp(authInternal, {
    returnSecureToken: true
  });
  const userCredential = await UserCredentialImpl._fromIdTokenResponse(authInternal, "signIn", response, true);
  await authInternal._updateCurrentUser(userCredential.user);
  return userCredential;
}
function _processCredentialSavingMfaContextIfNecessary(auth, operationType, credential, user) {
  const idTokenProvider = operationType === "reauthenticate" ? credential._getReauthenticationResolver(auth) : credential._getIdTokenResponse(auth);
  return idTokenProvider.catch((error) => {
    if (error.code === `auth/${"multi-factor-auth-required"}`) {
      throw MultiFactorError._fromErrorAndOperation(auth, error, operationType, user);
    }
    throw error;
  });
}
async function _link$1(user, credential, bypassAuthState = false) {
  const response = await _logoutIfInvalidated(user, credential._linkToIdToken(user.auth, await user.getIdToken()), bypassAuthState);
  return UserCredentialImpl._forOperation(user, "link", response);
}
async function _reauthenticate(user, credential, bypassAuthState = false) {
  const { auth } = user;
  const operationType = "reauthenticate";
  try {
    const response = await _logoutIfInvalidated(user, _processCredentialSavingMfaContextIfNecessary(auth, operationType, credential, user), bypassAuthState);
    _assert(response.idToken, auth, "internal-error");
    const parsed = _parseToken(response.idToken);
    _assert(parsed, auth, "internal-error");
    const { sub: localId } = parsed;
    _assert(user.uid === localId, auth, "user-mismatch");
    return UserCredentialImpl._forOperation(user, operationType, response);
  } catch (e) {
    if ((e === null || e === undefined ? undefined : e.code) === `auth/${"user-not-found"}`) {
      _fail(auth, "user-mismatch");
    }
    throw e;
  }
}
async function _signInWithCredential(auth, credential, bypassAuthState = false) {
  const operationType = "signIn";
  const response = await _processCredentialSavingMfaContextIfNecessary(auth, operationType, credential);
  const userCredential = await UserCredentialImpl._fromIdTokenResponse(auth, operationType, response);
  if (!bypassAuthState) {
    await auth._updateCurrentUser(userCredential.user);
  }
  return userCredential;
}
async function signInWithCustomToken$1(auth, request) {
  return _performSignInRequest(auth, "POST", "/v1/accounts:signInWithCustomToken", _addTidIfNecessary(auth, request));
}
async function signInWithCustomToken(auth, customToken) {
  const authInternal = _castAuth(auth);
  const response = await signInWithCustomToken$1(authInternal, {
    token: customToken,
    returnSecureToken: true
  });
  const cred = await UserCredentialImpl._fromIdTokenResponse(authInternal, "signIn", response);
  await authInternal._updateCurrentUser(cred.user);
  return cred;
}
function setPersistence(auth, persistence) {
  return getModularInstance(auth).setPersistence(persistence);
}
function onIdTokenChanged(auth, nextOrObserver, error, completed) {
  return getModularInstance(auth).onIdTokenChanged(nextOrObserver, error, completed);
}
function beforeAuthStateChanged(auth, callback, onAbort) {
  return getModularInstance(auth).beforeAuthStateChanged(callback, onAbort);
}
function onAuthStateChanged(auth, nextOrObserver, error, completed) {
  return getModularInstance(auth).onAuthStateChanged(nextOrObserver, error, completed);
}
function startEnrollPhoneMfa(auth, request) {
  return _performApiRequest(auth, "POST", "/v2/accounts/mfaEnrollment:start", _addTidIfNecessary(auth, request));
}
function finalizeEnrollPhoneMfa(auth, request) {
  return _performApiRequest(auth, "POST", "/v2/accounts/mfaEnrollment:finalize", _addTidIfNecessary(auth, request));
}
function startEnrollTotpMfa(auth, request) {
  return _performApiRequest(auth, "POST", "/v2/accounts/mfaEnrollment:start", _addTidIfNecessary(auth, request));
}
function finalizeEnrollTotpMfa(auth, request) {
  return _performApiRequest(auth, "POST", "/v2/accounts/mfaEnrollment:finalize", _addTidIfNecessary(auth, request));
}

class BrowserPersistenceClass {
  constructor(storageRetriever, type) {
    this.storageRetriever = storageRetriever;
    this.type = type;
  }
  _isAvailable() {
    try {
      if (!this.storage) {
        return Promise.resolve(false);
      }
      this.storage.setItem(STORAGE_AVAILABLE_KEY, "1");
      this.storage.removeItem(STORAGE_AVAILABLE_KEY);
      return Promise.resolve(true);
    } catch (_a) {
      return Promise.resolve(false);
    }
  }
  _set(key, value) {
    this.storage.setItem(key, JSON.stringify(value));
    return Promise.resolve();
  }
  _get(key) {
    const json = this.storage.getItem(key);
    return Promise.resolve(json ? JSON.parse(json) : null);
  }
  _remove(key) {
    this.storage.removeItem(key);
    return Promise.resolve();
  }
  get storage() {
    return this.storageRetriever();
  }
}
function _iframeCannotSyncWebStorage() {
  const ua = getUA();
  return _isSafari(ua) || _isIOS(ua);
}
function _allSettled(promises) {
  return Promise.all(promises.map(async (promise) => {
    try {
      const value = await promise;
      return {
        fulfilled: true,
        value
      };
    } catch (reason) {
      return {
        fulfilled: false,
        reason
      };
    }
  }));
}

class Receiver {
  constructor(eventTarget) {
    this.eventTarget = eventTarget;
    this.handlersMap = {};
    this.boundEventHandler = this.handleEvent.bind(this);
  }
  static _getInstance(eventTarget) {
    const existingInstance = this.receivers.find((receiver) => receiver.isListeningto(eventTarget));
    if (existingInstance) {
      return existingInstance;
    }
    const newInstance = new Receiver(eventTarget);
    this.receivers.push(newInstance);
    return newInstance;
  }
  isListeningto(eventTarget) {
    return this.eventTarget === eventTarget;
  }
  async handleEvent(event) {
    const messageEvent = event;
    const { eventId, eventType, data } = messageEvent.data;
    const handlers = this.handlersMap[eventType];
    if (!(handlers === null || handlers === undefined ? undefined : handlers.size)) {
      return;
    }
    messageEvent.ports[0].postMessage({
      status: "ack",
      eventId,
      eventType
    });
    const promises = Array.from(handlers).map(async (handler) => handler(messageEvent.origin, data));
    const response = await _allSettled(promises);
    messageEvent.ports[0].postMessage({
      status: "done",
      eventId,
      eventType,
      response
    });
  }
  _subscribe(eventType, eventHandler) {
    if (Object.keys(this.handlersMap).length === 0) {
      this.eventTarget.addEventListener("message", this.boundEventHandler);
    }
    if (!this.handlersMap[eventType]) {
      this.handlersMap[eventType] = new Set;
    }
    this.handlersMap[eventType].add(eventHandler);
  }
  _unsubscribe(eventType, eventHandler) {
    if (this.handlersMap[eventType] && eventHandler) {
      this.handlersMap[eventType].delete(eventHandler);
    }
    if (!eventHandler || this.handlersMap[eventType].size === 0) {
      delete this.handlersMap[eventType];
    }
    if (Object.keys(this.handlersMap).length === 0) {
      this.eventTarget.removeEventListener("message", this.boundEventHandler);
    }
  }
}
function _generateEventId(prefix = "", digits = 10) {
  let random = "";
  for (let i = 0;i < digits; i++) {
    random += Math.floor(Math.random() * 10);
  }
  return prefix + random;
}

class Sender {
  constructor(target) {
    this.target = target;
    this.handlers = new Set;
  }
  removeMessageHandler(handler) {
    if (handler.messageChannel) {
      handler.messageChannel.port1.removeEventListener("message", handler.onMessage);
      handler.messageChannel.port1.close();
    }
    this.handlers.delete(handler);
  }
  async _send(eventType, data, timeout = 50) {
    const messageChannel = typeof MessageChannel !== "undefined" ? new MessageChannel : null;
    if (!messageChannel) {
      throw new Error("connection_unavailable");
    }
    let completionTimer;
    let handler;
    return new Promise((resolve, reject) => {
      const eventId = _generateEventId("", 20);
      messageChannel.port1.start();
      const ackTimer = setTimeout(() => {
        reject(new Error("unsupported_event"));
      }, timeout);
      handler = {
        messageChannel,
        onMessage(event) {
          const messageEvent = event;
          if (messageEvent.data.eventId !== eventId) {
            return;
          }
          switch (messageEvent.data.status) {
            case "ack":
              clearTimeout(ackTimer);
              completionTimer = setTimeout(() => {
                reject(new Error("timeout"));
              }, 3000);
              break;
            case "done":
              clearTimeout(completionTimer);
              resolve(messageEvent.data.response);
              break;
            default:
              clearTimeout(ackTimer);
              clearTimeout(completionTimer);
              reject(new Error("invalid_response"));
              break;
          }
        }
      };
      this.handlers.add(handler);
      messageChannel.port1.addEventListener("message", handler.onMessage);
      this.target.postMessage({
        eventType,
        eventId,
        data
      }, [messageChannel.port2]);
    }).finally(() => {
      if (handler) {
        this.removeMessageHandler(handler);
      }
    });
  }
}
function _window() {
  return window;
}
function _setWindowLocation(url) {
  _window().location.href = url;
}
function _isWorker() {
  return typeof _window()["WorkerGlobalScope"] !== "undefined" && typeof _window()["importScripts"] === "function";
}
async function _getActiveServiceWorker() {
  if (!(navigator === null || navigator === undefined ? undefined : navigator.serviceWorker)) {
    return null;
  }
  try {
    const registration = await navigator.serviceWorker.ready;
    return registration.active;
  } catch (_a) {
    return null;
  }
}
function _getServiceWorkerController() {
  var _a;
  return ((_a = navigator === null || navigator === undefined ? undefined : navigator.serviceWorker) === null || _a === undefined ? undefined : _a.controller) || null;
}
function _getWorkerGlobalScope() {
  return _isWorker() ? self : null;
}

class DBPromise {
  constructor(request) {
    this.request = request;
  }
  toPromise() {
    return new Promise((resolve, reject) => {
      this.request.addEventListener("success", () => {
        resolve(this.request.result);
      });
      this.request.addEventListener("error", () => {
        reject(this.request.error);
      });
    });
  }
}
function getObjectStore(db, isReadWrite) {
  return db.transaction([DB_OBJECTSTORE_NAME], isReadWrite ? "readwrite" : "readonly").objectStore(DB_OBJECTSTORE_NAME);
}
function _deleteDatabase() {
  const request = indexedDB.deleteDatabase(DB_NAME2);
  return new DBPromise(request).toPromise();
}
function _openDatabase() {
  const request = indexedDB.open(DB_NAME2, DB_VERSION2);
  return new Promise((resolve, reject) => {
    request.addEventListener("error", () => {
      reject(request.error);
    });
    request.addEventListener("upgradeneeded", () => {
      const db = request.result;
      try {
        db.createObjectStore(DB_OBJECTSTORE_NAME, { keyPath: DB_DATA_KEYPATH });
      } catch (e) {
        reject(e);
      }
    });
    request.addEventListener("success", async () => {
      const db = request.result;
      if (!db.objectStoreNames.contains(DB_OBJECTSTORE_NAME)) {
        db.close();
        await _deleteDatabase();
        resolve(await _openDatabase());
      } else {
        resolve(db);
      }
    });
  });
}
async function _putObject(db, key, value) {
  const request = getObjectStore(db, true).put({
    [DB_DATA_KEYPATH]: key,
    value
  });
  return new DBPromise(request).toPromise();
}
async function getObject(db, key) {
  const request = getObjectStore(db, false).get(key);
  const data = await new DBPromise(request).toPromise();
  return data === undefined ? null : data.value;
}
function _deleteObject(db, key) {
  const request = getObjectStore(db, true).delete(key);
  return new DBPromise(request).toPromise();
}

class IndexedDBLocalPersistence {
  constructor() {
    this.type = "LOCAL";
    this._shouldAllowMigration = true;
    this.listeners = {};
    this.localCache = {};
    this.pollTimer = null;
    this.pendingWrites = 0;
    this.receiver = null;
    this.sender = null;
    this.serviceWorkerReceiverAvailable = false;
    this.activeServiceWorker = null;
    this._workerInitializationPromise = this.initializeServiceWorkerMessaging().then(() => {}, () => {});
  }
  async _openDb() {
    if (this.db) {
      return this.db;
    }
    this.db = await _openDatabase();
    return this.db;
  }
  async _withRetries(op) {
    let numAttempts = 0;
    while (true) {
      try {
        const db = await this._openDb();
        return await op(db);
      } catch (e) {
        if (numAttempts++ > _TRANSACTION_RETRY_COUNT) {
          throw e;
        }
        if (this.db) {
          this.db.close();
          this.db = undefined;
        }
      }
    }
  }
  async initializeServiceWorkerMessaging() {
    return _isWorker() ? this.initializeReceiver() : this.initializeSender();
  }
  async initializeReceiver() {
    this.receiver = Receiver._getInstance(_getWorkerGlobalScope());
    this.receiver._subscribe("keyChanged", async (_origin, data) => {
      const keys = await this._poll();
      return {
        keyProcessed: keys.includes(data.key)
      };
    });
    this.receiver._subscribe("ping", async (_origin, _data) => {
      return ["keyChanged"];
    });
  }
  async initializeSender() {
    var _a, _b;
    this.activeServiceWorker = await _getActiveServiceWorker();
    if (!this.activeServiceWorker) {
      return;
    }
    this.sender = new Sender(this.activeServiceWorker);
    const results = await this.sender._send("ping", {}, 800);
    if (!results) {
      return;
    }
    if (((_a = results[0]) === null || _a === undefined ? undefined : _a.fulfilled) && ((_b = results[0]) === null || _b === undefined ? undefined : _b.value.includes("keyChanged"))) {
      this.serviceWorkerReceiverAvailable = true;
    }
  }
  async notifyServiceWorker(key) {
    if (!this.sender || !this.activeServiceWorker || _getServiceWorkerController() !== this.activeServiceWorker) {
      return;
    }
    try {
      await this.sender._send("keyChanged", { key }, this.serviceWorkerReceiverAvailable ? 800 : 50);
    } catch (_a) {}
  }
  async _isAvailable() {
    try {
      if (!indexedDB) {
        return false;
      }
      const db = await _openDatabase();
      await _putObject(db, STORAGE_AVAILABLE_KEY, "1");
      await _deleteObject(db, STORAGE_AVAILABLE_KEY);
      return true;
    } catch (_a) {}
    return false;
  }
  async _withPendingWrite(write) {
    this.pendingWrites++;
    try {
      await write();
    } finally {
      this.pendingWrites--;
    }
  }
  async _set(key, value) {
    return this._withPendingWrite(async () => {
      await this._withRetries((db) => _putObject(db, key, value));
      this.localCache[key] = value;
      return this.notifyServiceWorker(key);
    });
  }
  async _get(key) {
    const obj = await this._withRetries((db) => getObject(db, key));
    this.localCache[key] = obj;
    return obj;
  }
  async _remove(key) {
    return this._withPendingWrite(async () => {
      await this._withRetries((db) => _deleteObject(db, key));
      delete this.localCache[key];
      return this.notifyServiceWorker(key);
    });
  }
  async _poll() {
    const result = await this._withRetries((db) => {
      const getAllRequest = getObjectStore(db, false).getAll();
      return new DBPromise(getAllRequest).toPromise();
    });
    if (!result) {
      return [];
    }
    if (this.pendingWrites !== 0) {
      return [];
    }
    const keys = [];
    const keysInResult = new Set;
    for (const { fbase_key: key, value } of result) {
      keysInResult.add(key);
      if (JSON.stringify(this.localCache[key]) !== JSON.stringify(value)) {
        this.notifyListeners(key, value);
        keys.push(key);
      }
    }
    for (const localKey of Object.keys(this.localCache)) {
      if (this.localCache[localKey] && !keysInResult.has(localKey)) {
        this.notifyListeners(localKey, null);
        keys.push(localKey);
      }
    }
    return keys;
  }
  notifyListeners(key, newValue) {
    this.localCache[key] = newValue;
    const listeners = this.listeners[key];
    if (listeners) {
      for (const listener of Array.from(listeners)) {
        listener(newValue);
      }
    }
  }
  startPolling() {
    this.stopPolling();
    this.pollTimer = setInterval(async () => this._poll(), _POLLING_INTERVAL_MS);
  }
  stopPolling() {
    if (this.pollTimer) {
      clearInterval(this.pollTimer);
      this.pollTimer = null;
    }
  }
  _addListener(key, listener) {
    if (Object.keys(this.listeners).length === 0) {
      this.startPolling();
    }
    if (!this.listeners[key]) {
      this.listeners[key] = new Set;
      this._get(key);
    }
    this.listeners[key].add(listener);
  }
  _removeListener(key, listener) {
    if (this.listeners[key]) {
      this.listeners[key].delete(listener);
      if (this.listeners[key].size === 0) {
        delete this.listeners[key];
      }
    }
    if (Object.keys(this.listeners).length === 0) {
      this.stopPolling();
    }
  }
}
function startSignInPhoneMfa(auth, request) {
  return _performApiRequest(auth, "POST", "/v2/accounts/mfaSignIn:start", _addTidIfNecessary(auth, request));
}
function finalizeSignInPhoneMfa(auth, request) {
  return _performApiRequest(auth, "POST", "/v2/accounts/mfaSignIn:finalize", _addTidIfNecessary(auth, request));
}
function finalizeSignInTotpMfa(auth, request) {
  return _performApiRequest(auth, "POST", "/v2/accounts/mfaSignIn:finalize", _addTidIfNecessary(auth, request));
}
async function _verifyPhoneNumber(auth, options, verifier) {
  var _a;
  const recaptchaToken = await verifier.verify();
  try {
    _assert(typeof recaptchaToken === "string", auth, "argument-error");
    _assert(verifier.type === RECAPTCHA_VERIFIER_TYPE, auth, "argument-error");
    let phoneInfoOptions;
    if (typeof options === "string") {
      phoneInfoOptions = {
        phoneNumber: options
      };
    } else {
      phoneInfoOptions = options;
    }
    if ("session" in phoneInfoOptions) {
      const session = phoneInfoOptions.session;
      if ("phoneNumber" in phoneInfoOptions) {
        _assert(session.type === "enroll", auth, "internal-error");
        const response = await startEnrollPhoneMfa(auth, {
          idToken: session.credential,
          phoneEnrollmentInfo: {
            phoneNumber: phoneInfoOptions.phoneNumber,
            recaptchaToken
          }
        });
        return response.phoneSessionInfo.sessionInfo;
      } else {
        _assert(session.type === "signin", auth, "internal-error");
        const mfaEnrollmentId = ((_a = phoneInfoOptions.multiFactorHint) === null || _a === undefined ? undefined : _a.uid) || phoneInfoOptions.multiFactorUid;
        _assert(mfaEnrollmentId, auth, "missing-multi-factor-info");
        const response = await startSignInPhoneMfa(auth, {
          mfaPendingCredential: session.credential,
          mfaEnrollmentId,
          phoneSignInInfo: {
            recaptchaToken
          }
        });
        return response.phoneResponseInfo.sessionInfo;
      }
    } else {
      const { sessionInfo } = await sendPhoneVerificationCode(auth, {
        phoneNumber: phoneInfoOptions.phoneNumber,
        recaptchaToken
      });
      return sessionInfo;
    }
  } finally {
    verifier._reset();
  }
}

class PhoneAuthProvider {
  constructor(auth) {
    this.providerId = PhoneAuthProvider.PROVIDER_ID;
    this.auth = _castAuth(auth);
  }
  verifyPhoneNumber(phoneOptions, applicationVerifier) {
    return _verifyPhoneNumber(this.auth, phoneOptions, getModularInstance(applicationVerifier));
  }
  static credential(verificationId, verificationCode) {
    return PhoneAuthCredential._fromVerification(verificationId, verificationCode);
  }
  static credentialFromResult(userCredential) {
    const credential = userCredential;
    return PhoneAuthProvider.credentialFromTaggedObject(credential);
  }
  static credentialFromError(error) {
    return PhoneAuthProvider.credentialFromTaggedObject(error.customData || {});
  }
  static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {
    if (!tokenResponse) {
      return null;
    }
    const { phoneNumber, temporaryProof } = tokenResponse;
    if (phoneNumber && temporaryProof) {
      return PhoneAuthCredential._fromTokenResponse(phoneNumber, temporaryProof);
    }
    return null;
  }
}
function _withDefaultResolver(auth, resolverOverride) {
  if (resolverOverride) {
    return _getInstance(resolverOverride);
  }
  _assert(auth._popupRedirectResolver, auth, "argument-error");
  return auth._popupRedirectResolver;
}
function _signIn(params) {
  return _signInWithCredential(params.auth, new IdpCredential(params), params.bypassAuthState);
}
function _reauth(params) {
  const { auth, user } = params;
  _assert(user, auth, "internal-error");
  return _reauthenticate(user, new IdpCredential(params), params.bypassAuthState);
}
async function _link(params) {
  const { auth, user } = params;
  _assert(user, auth, "internal-error");
  return _link$1(user, new IdpCredential(params), params.bypassAuthState);
}

class AbstractPopupRedirectOperation {
  constructor(auth, filter, resolver, user, bypassAuthState = false) {
    this.auth = auth;
    this.resolver = resolver;
    this.user = user;
    this.bypassAuthState = bypassAuthState;
    this.pendingPromise = null;
    this.eventManager = null;
    this.filter = Array.isArray(filter) ? filter : [filter];
  }
  execute() {
    return new Promise(async (resolve, reject) => {
      this.pendingPromise = { resolve, reject };
      try {
        this.eventManager = await this.resolver._initialize(this.auth);
        await this.onExecution();
        this.eventManager.registerConsumer(this);
      } catch (e) {
        this.reject(e);
      }
    });
  }
  async onAuthEvent(event) {
    const { urlResponse, sessionId, postBody, tenantId, error, type } = event;
    if (error) {
      this.reject(error);
      return;
    }
    const params = {
      auth: this.auth,
      requestUri: urlResponse,
      sessionId,
      tenantId: tenantId || undefined,
      postBody: postBody || undefined,
      user: this.user,
      bypassAuthState: this.bypassAuthState
    };
    try {
      this.resolve(await this.getIdpTask(type)(params));
    } catch (e) {
      this.reject(e);
    }
  }
  onError(error) {
    this.reject(error);
  }
  getIdpTask(type) {
    switch (type) {
      case "signInViaPopup":
      case "signInViaRedirect":
        return _signIn;
      case "linkViaPopup":
      case "linkViaRedirect":
        return _link;
      case "reauthViaPopup":
      case "reauthViaRedirect":
        return _reauth;
      default:
        _fail(this.auth, "internal-error");
    }
  }
  resolve(cred) {
    debugAssert(this.pendingPromise, "Pending promise was never set");
    this.pendingPromise.resolve(cred);
    this.unregisterAndCleanUp();
  }
  reject(error) {
    debugAssert(this.pendingPromise, "Pending promise was never set");
    this.pendingPromise.reject(error);
    this.unregisterAndCleanUp();
  }
  unregisterAndCleanUp() {
    if (this.eventManager) {
      this.eventManager.unregisterConsumer(this);
    }
    this.pendingPromise = null;
    this.cleanUp();
  }
}
async function _getAndClearPendingRedirectStatus(resolver, auth) {
  const key = pendingRedirectKey(auth);
  const persistence = resolverPersistence(resolver);
  if (!await persistence._isAvailable()) {
    return false;
  }
  const hasPendingRedirect = await persistence._get(key) === "true";
  await persistence._remove(key);
  return hasPendingRedirect;
}
function _overrideRedirectResult(auth, result) {
  redirectOutcomeMap.set(auth._key(), result);
}
function resolverPersistence(resolver) {
  return _getInstance(resolver._redirectPersistence);
}
function pendingRedirectKey(auth) {
  return _persistenceKeyName(PENDING_REDIRECT_KEY, auth.config.apiKey, auth.name);
}
async function _getRedirectResult(auth, resolverExtern, bypassAuthState = false) {
  const authInternal = _castAuth(auth);
  const resolver = _withDefaultResolver(authInternal, resolverExtern);
  const action = new RedirectAction(authInternal, resolver, bypassAuthState);
  const result = await action.execute();
  if (result && !bypassAuthState) {
    delete result.user._redirectEventId;
    await authInternal._persistUserIfCurrent(result.user);
    await authInternal._setRedirectUser(null, resolverExtern);
  }
  return result;
}

class AuthEventManager {
  constructor(auth) {
    this.auth = auth;
    this.cachedEventUids = new Set;
    this.consumers = new Set;
    this.queuedRedirectEvent = null;
    this.hasHandledPotentialRedirect = false;
    this.lastProcessedEventTime = Date.now();
  }
  registerConsumer(authEventConsumer) {
    this.consumers.add(authEventConsumer);
    if (this.queuedRedirectEvent && this.isEventForConsumer(this.queuedRedirectEvent, authEventConsumer)) {
      this.sendToConsumer(this.queuedRedirectEvent, authEventConsumer);
      this.saveEventToCache(this.queuedRedirectEvent);
      this.queuedRedirectEvent = null;
    }
  }
  unregisterConsumer(authEventConsumer) {
    this.consumers.delete(authEventConsumer);
  }
  onEvent(event) {
    if (this.hasEventBeenHandled(event)) {
      return false;
    }
    let handled = false;
    this.consumers.forEach((consumer) => {
      if (this.isEventForConsumer(event, consumer)) {
        handled = true;
        this.sendToConsumer(event, consumer);
        this.saveEventToCache(event);
      }
    });
    if (this.hasHandledPotentialRedirect || !isRedirectEvent(event)) {
      return handled;
    }
    this.hasHandledPotentialRedirect = true;
    if (!handled) {
      this.queuedRedirectEvent = event;
      handled = true;
    }
    return handled;
  }
  sendToConsumer(event, consumer) {
    var _a;
    if (event.error && !isNullRedirectEvent(event)) {
      const code = ((_a = event.error.code) === null || _a === undefined ? undefined : _a.split("auth/")[1]) || "internal-error";
      consumer.onError(_createError(this.auth, code));
    } else {
      consumer.onAuthEvent(event);
    }
  }
  isEventForConsumer(event, consumer) {
    const eventIdMatches = consumer.eventId === null || !!event.eventId && event.eventId === consumer.eventId;
    return consumer.filter.includes(event.type) && eventIdMatches;
  }
  hasEventBeenHandled(event) {
    if (Date.now() - this.lastProcessedEventTime >= EVENT_DUPLICATION_CACHE_DURATION_MS) {
      this.cachedEventUids.clear();
    }
    return this.cachedEventUids.has(eventUid(event));
  }
  saveEventToCache(event) {
    this.cachedEventUids.add(eventUid(event));
    this.lastProcessedEventTime = Date.now();
  }
}
function eventUid(e) {
  return [e.type, e.eventId, e.sessionId, e.tenantId].filter((v) => v).join("-");
}
function isNullRedirectEvent({ type, error }) {
  return type === "unknown" && (error === null || error === undefined ? undefined : error.code) === `auth/${"no-auth-event"}`;
}
function isRedirectEvent(event) {
  switch (event.type) {
    case "signInViaRedirect":
    case "linkViaRedirect":
    case "reauthViaRedirect":
      return true;
    case "unknown":
      return isNullRedirectEvent(event);
    default:
      return false;
  }
}
async function _getProjectConfig(auth, request = {}) {
  return _performApiRequest(auth, "GET", "/v1/projects", request);
}
async function _validateOrigin(auth) {
  if (auth.config.emulator) {
    return;
  }
  const { authorizedDomains } = await _getProjectConfig(auth);
  for (const domain of authorizedDomains) {
    try {
      if (matchDomain(domain)) {
        return;
      }
    } catch (_a) {}
  }
  _fail(auth, "unauthorized-domain");
}
function matchDomain(expected) {
  const currentUrl = _getCurrentUrl();
  const { protocol, hostname } = new URL(currentUrl);
  if (expected.startsWith("chrome-extension://")) {
    const ceUrl = new URL(expected);
    if (ceUrl.hostname === "" && hostname === "") {
      return protocol === "chrome-extension:" && expected.replace("chrome-extension://", "") === currentUrl.replace("chrome-extension://", "");
    }
    return protocol === "chrome-extension:" && ceUrl.hostname === hostname;
  }
  if (!HTTP_REGEX.test(protocol)) {
    return false;
  }
  if (IP_ADDRESS_REGEX.test(expected)) {
    return hostname === expected;
  }
  const escapedDomainPattern = expected.replace(/\./g, "\\.");
  const re = new RegExp("^(.+\\." + escapedDomainPattern + "|" + escapedDomainPattern + ")$", "i");
  return re.test(hostname);
}
function resetUnloadedGapiModules() {
  const beacon = _window().___jsl;
  if (beacon === null || beacon === undefined ? undefined : beacon.H) {
    for (const hint of Object.keys(beacon.H)) {
      beacon.H[hint].r = beacon.H[hint].r || [];
      beacon.H[hint].L = beacon.H[hint].L || [];
      beacon.H[hint].r = [...beacon.H[hint].L];
      if (beacon.CP) {
        for (let i = 0;i < beacon.CP.length; i++) {
          beacon.CP[i] = null;
        }
      }
    }
  }
}
function loadGapi(auth) {
  return new Promise((resolve, reject) => {
    var _a, _b, _c;
    function loadGapiIframe() {
      resetUnloadedGapiModules();
      gapi.load("gapi.iframes", {
        callback: () => {
          resolve(gapi.iframes.getContext());
        },
        ontimeout: () => {
          resetUnloadedGapiModules();
          reject(_createError(auth, "network-request-failed"));
        },
        timeout: NETWORK_TIMEOUT.get()
      });
    }
    if ((_b = (_a = _window().gapi) === null || _a === undefined ? undefined : _a.iframes) === null || _b === undefined ? undefined : _b.Iframe) {
      resolve(gapi.iframes.getContext());
    } else if (!!((_c = _window().gapi) === null || _c === undefined ? undefined : _c.load)) {
      loadGapiIframe();
    } else {
      const cbName = _generateCallbackName("iframefcb");
      _window()[cbName] = () => {
        if (!!gapi.load) {
          loadGapiIframe();
        } else {
          reject(_createError(auth, "network-request-failed"));
        }
      };
      return _loadJS(`https://apis.google.com/js/api.js?onload=${cbName}`).catch((e) => reject(e));
    }
  }).catch((error) => {
    cachedGApiLoader = null;
    throw error;
  });
}
function _loadGapi(auth) {
  cachedGApiLoader = cachedGApiLoader || loadGapi(auth);
  return cachedGApiLoader;
}
function getIframeUrl(auth) {
  const config = auth.config;
  _assert(config.authDomain, auth, "auth-domain-config-required");
  const url = config.emulator ? _emulatorUrl(config, EMULATED_IFRAME_PATH) : `https://${auth.config.authDomain}/${IFRAME_PATH}`;
  const params = {
    apiKey: config.apiKey,
    appName: auth.name,
    v: SDK_VERSION
  };
  const eid = EID_FROM_APIHOST.get(auth.config.apiHost);
  if (eid) {
    params.eid = eid;
  }
  const frameworks = auth._getFrameworks();
  if (frameworks.length) {
    params.fw = frameworks.join(",");
  }
  return `${url}?${querystring(params).slice(1)}`;
}
async function _openIframe(auth) {
  const context = await _loadGapi(auth);
  const gapi2 = _window().gapi;
  _assert(gapi2, auth, "internal-error");
  return context.open({
    where: document.body,
    url: getIframeUrl(auth),
    messageHandlersFilter: gapi2.iframes.CROSS_ORIGIN_IFRAMES_FILTER,
    attributes: IFRAME_ATTRIBUTES,
    dontclear: true
  }, (iframe) => new Promise(async (resolve, reject) => {
    await iframe.restyle({
      setHideOnLeave: false
    });
    const networkError = _createError(auth, "network-request-failed");
    const networkErrorTimer = _window().setTimeout(() => {
      reject(networkError);
    }, PING_TIMEOUT.get());
    function clearTimerAndResolve() {
      _window().clearTimeout(networkErrorTimer);
      resolve(iframe);
    }
    iframe.ping(clearTimerAndResolve).then(clearTimerAndResolve, () => {
      reject(networkError);
    });
  }));
}

class AuthPopup {
  constructor(window2) {
    this.window = window2;
    this.associatedEvent = null;
  }
  close() {
    if (this.window) {
      try {
        this.window.close();
      } catch (e) {}
    }
  }
}
function _open(auth, url, name3, width = DEFAULT_WIDTH, height = DEFAULT_HEIGHT) {
  const top = Math.max((window.screen.availHeight - height) / 2, 0).toString();
  const left = Math.max((window.screen.availWidth - width) / 2, 0).toString();
  let target = "";
  const options = Object.assign(Object.assign({}, BASE_POPUP_OPTIONS), {
    width: width.toString(),
    height: height.toString(),
    top,
    left
  });
  const ua = getUA().toLowerCase();
  if (name3) {
    target = _isChromeIOS(ua) ? TARGET_BLANK : name3;
  }
  if (_isFirefox(ua)) {
    url = url || FIREFOX_EMPTY_URL;
    options.scrollbars = "yes";
  }
  const optionsString = Object.entries(options).reduce((accum, [key, value]) => `${accum}${key}=${value},`, "");
  if (_isIOSStandalone(ua) && target !== "_self") {
    openAsNewWindowIOS(url || "", target);
    return new AuthPopup(null);
  }
  const newWin = window.open(url || "", target, optionsString);
  _assert(newWin, auth, "popup-blocked");
  try {
    newWin.focus();
  } catch (e) {}
  return new AuthPopup(newWin);
}
function openAsNewWindowIOS(url, target) {
  const el = document.createElement("a");
  el.href = url;
  el.target = target;
  const click = document.createEvent("MouseEvent");
  click.initMouseEvent("click", true, true, window, 1, 0, 0, 0, 0, false, false, false, false, 1, null);
  el.dispatchEvent(click);
}
async function _getRedirectUrl(auth, provider, authType, redirectUrl, eventId, additionalParams) {
  _assert(auth.config.authDomain, auth, "auth-domain-config-required");
  _assert(auth.config.apiKey, auth, "invalid-api-key");
  const params = {
    apiKey: auth.config.apiKey,
    appName: auth.name,
    authType,
    redirectUrl,
    v: SDK_VERSION,
    eventId
  };
  if (provider instanceof FederatedAuthProvider) {
    provider.setDefaultLanguage(auth.languageCode);
    params.providerId = provider.providerId || "";
    if (!isEmpty(provider.getCustomParameters())) {
      params.customParameters = JSON.stringify(provider.getCustomParameters());
    }
    for (const [key, value] of Object.entries(additionalParams || {})) {
      params[key] = value;
    }
  }
  if (provider instanceof BaseOAuthProvider) {
    const scopes = provider.getScopes().filter((scope) => scope !== "");
    if (scopes.length > 0) {
      params.scopes = scopes.join(",");
    }
  }
  if (auth.tenantId) {
    params.tid = auth.tenantId;
  }
  const paramsDict = params;
  for (const key of Object.keys(paramsDict)) {
    if (paramsDict[key] === undefined) {
      delete paramsDict[key];
    }
  }
  const appCheckToken = await auth._getAppCheckToken();
  const appCheckTokenFragment = appCheckToken ? `#${FIREBASE_APP_CHECK_FRAGMENT_ID}=${encodeURIComponent(appCheckToken)}` : "";
  return `${getHandlerBase(auth)}?${querystring(paramsDict).slice(1)}${appCheckTokenFragment}`;
}
function getHandlerBase({ config }) {
  if (!config.emulator) {
    return `https://${config.authDomain}/${WIDGET_PATH}`;
  }
  return _emulatorUrl(config, EMULATOR_WIDGET_PATH);
}

class BrowserPopupRedirectResolver {
  constructor() {
    this.eventManagers = {};
    this.iframes = {};
    this.originValidationPromises = {};
    this._redirectPersistence = browserSessionPersistence;
    this._completeRedirectFn = _getRedirectResult;
    this._overrideRedirectResult = _overrideRedirectResult;
  }
  async _openPopup(auth, provider, authType, eventId) {
    var _a;
    debugAssert((_a = this.eventManagers[auth._key()]) === null || _a === undefined ? undefined : _a.manager, "_initialize() not called before _openPopup()");
    const url = await _getRedirectUrl(auth, provider, authType, _getCurrentUrl(), eventId);
    return _open(auth, url, _generateEventId());
  }
  async _openRedirect(auth, provider, authType, eventId) {
    await this._originValidation(auth);
    const url = await _getRedirectUrl(auth, provider, authType, _getCurrentUrl(), eventId);
    _setWindowLocation(url);
    return new Promise(() => {});
  }
  _initialize(auth) {
    const key = auth._key();
    if (this.eventManagers[key]) {
      const { manager, promise: promise2 } = this.eventManagers[key];
      if (manager) {
        return Promise.resolve(manager);
      } else {
        debugAssert(promise2, "If manager is not set, promise should be");
        return promise2;
      }
    }
    const promise = this.initAndGetManager(auth);
    this.eventManagers[key] = { promise };
    promise.catch(() => {
      delete this.eventManagers[key];
    });
    return promise;
  }
  async initAndGetManager(auth) {
    const iframe = await _openIframe(auth);
    const manager = new AuthEventManager(auth);
    iframe.register("authEvent", (iframeEvent) => {
      _assert(iframeEvent === null || iframeEvent === undefined ? undefined : iframeEvent.authEvent, auth, "invalid-auth-event");
      const handled = manager.onEvent(iframeEvent.authEvent);
      return { status: handled ? "ACK" : "ERROR" };
    }, gapi.iframes.CROSS_ORIGIN_IFRAMES_FILTER);
    this.eventManagers[auth._key()] = { manager };
    this.iframes[auth._key()] = iframe;
    return manager;
  }
  _isIframeWebStorageSupported(auth, cb) {
    const iframe = this.iframes[auth._key()];
    iframe.send(WEB_STORAGE_SUPPORT_KEY, { type: WEB_STORAGE_SUPPORT_KEY }, (result) => {
      var _a;
      const isSupported = (_a = result === null || result === undefined ? undefined : result[0]) === null || _a === undefined ? undefined : _a[WEB_STORAGE_SUPPORT_KEY];
      if (isSupported !== undefined) {
        cb(!!isSupported);
      }
      _fail(auth, "internal-error");
    }, gapi.iframes.CROSS_ORIGIN_IFRAMES_FILTER);
  }
  _originValidation(auth) {
    const key = auth._key();
    if (!this.originValidationPromises[key]) {
      this.originValidationPromises[key] = _validateOrigin(auth);
    }
    return this.originValidationPromises[key];
  }
  get _shouldInitProactively() {
    return _isMobileBrowser() || _isSafari() || _isIOS();
  }
}

class MultiFactorAssertionImpl {
  constructor(factorId) {
    this.factorId = factorId;
  }
  _process(auth, session, displayName) {
    switch (session.type) {
      case "enroll":
        return this._finalizeEnroll(auth, session.credential, displayName);
      case "signin":
        return this._finalizeSignIn(auth, session.credential);
      default:
        return debugFail("unexpected MultiFactorSessionType");
    }
  }
}

class PhoneMultiFactorGenerator {
  constructor() {}
  static assertion(credential) {
    return PhoneMultiFactorAssertionImpl._fromCredential(credential);
  }
}

class TotpMultiFactorGenerator {
  static assertionForEnrollment(secret, oneTimePassword) {
    return TotpMultiFactorAssertionImpl._fromSecret(secret, oneTimePassword);
  }
  static assertionForSignIn(enrollmentId, oneTimePassword) {
    return TotpMultiFactorAssertionImpl._fromEnrollmentId(enrollmentId, oneTimePassword);
  }
  static async generateSecret(session) {
    var _a;
    const mfaSession = session;
    _assert(typeof ((_a = mfaSession.user) === null || _a === undefined ? undefined : _a.auth) !== "undefined", "internal-error");
    const response = await startEnrollTotpMfa(mfaSession.user.auth, {
      idToken: mfaSession.credential,
      totpEnrollmentInfo: {}
    });
    return TotpSecret._fromStartTotpMfaEnrollmentResponse(response, mfaSession.user.auth);
  }
}

class TotpSecret {
  constructor(secretKey, hashingAlgorithm, codeLength, codeIntervalSeconds, enrollmentCompletionDeadline, sessionInfo, auth) {
    this.sessionInfo = sessionInfo;
    this.auth = auth;
    this.secretKey = secretKey;
    this.hashingAlgorithm = hashingAlgorithm;
    this.codeLength = codeLength;
    this.codeIntervalSeconds = codeIntervalSeconds;
    this.enrollmentCompletionDeadline = enrollmentCompletionDeadline;
  }
  static _fromStartTotpMfaEnrollmentResponse(response, auth) {
    return new TotpSecret(response.totpSessionInfo.sharedSecretKey, response.totpSessionInfo.hashingAlgorithm, response.totpSessionInfo.verificationCodeLength, response.totpSessionInfo.periodSec, new Date(response.totpSessionInfo.finalizeEnrollmentTime).toUTCString(), response.totpSessionInfo.sessionInfo, auth);
  }
  _makeTotpVerificationInfo(otp) {
    return { sessionInfo: this.sessionInfo, verificationCode: otp };
  }
  generateQrCodeUrl(accountName, issuer) {
    var _a;
    let useDefaults = false;
    if (_isEmptyString(accountName) || _isEmptyString(issuer)) {
      useDefaults = true;
    }
    if (useDefaults) {
      if (_isEmptyString(accountName)) {
        accountName = ((_a = this.auth.currentUser) === null || _a === undefined ? undefined : _a.email) || "unknownuser";
      }
      if (_isEmptyString(issuer)) {
        issuer = this.auth.name;
      }
    }
    return `otpauth://totp/${issuer}:${accountName}?secret=${this.secretKey}&issuer=${issuer}&algorithm=${this.hashingAlgorithm}&digits=${this.codeLength}`;
  }
}
function _isEmptyString(input) {
  return typeof input === "undefined" || (input === null || input === undefined ? undefined : input.length) === 0;
}

class AuthInterop {
  constructor(auth) {
    this.auth = auth;
    this.internalListeners = new Map;
  }
  getUid() {
    var _a;
    this.assertAuthConfigured();
    return ((_a = this.auth.currentUser) === null || _a === undefined ? undefined : _a.uid) || null;
  }
  async getToken(forceRefresh) {
    this.assertAuthConfigured();
    await this.auth._initializationPromise;
    if (!this.auth.currentUser) {
      return null;
    }
    const accessToken = await this.auth.currentUser.getIdToken(forceRefresh);
    return { accessToken };
  }
  addAuthTokenListener(listener) {
    this.assertAuthConfigured();
    if (this.internalListeners.has(listener)) {
      return;
    }
    const unsubscribe = this.auth.onIdTokenChanged((user) => {
      listener((user === null || user === undefined ? undefined : user.stsTokenManager.accessToken) || null);
    });
    this.internalListeners.set(listener, unsubscribe);
    this.updateProactiveRefresh();
  }
  removeAuthTokenListener(listener) {
    this.assertAuthConfigured();
    const unsubscribe = this.internalListeners.get(listener);
    if (!unsubscribe) {
      return;
    }
    this.internalListeners.delete(listener);
    unsubscribe();
    this.updateProactiveRefresh();
  }
  assertAuthConfigured() {
    _assert(this.auth._initializationPromise, "dependent-sdk-initialized-before-auth");
  }
  updateProactiveRefresh() {
    if (this.internalListeners.size > 0) {
      this.auth._startProactiveRefresh();
    } else {
      this.auth._stopProactiveRefresh();
    }
  }
}
function getVersionForPlatform(clientPlatform) {
  switch (clientPlatform) {
    case "Node":
      return "node";
    case "ReactNative":
      return "rn";
    case "Worker":
      return "webworker";
    case "Cordova":
      return "cordova";
    default:
      return;
  }
}
function registerAuth(clientPlatform) {
  _registerComponent(new Component2("auth", (container, { options: deps }) => {
    const app2 = container.getProvider("app").getImmediate();
    const heartbeatServiceProvider = container.getProvider("heartbeat");
    const appCheckServiceProvider = container.getProvider("app-check-internal");
    const { apiKey, authDomain } = app2.options;
    _assert(apiKey && !apiKey.includes(":"), "invalid-api-key", { appName: app2.name });
    const config = {
      apiKey,
      authDomain,
      clientPlatform,
      apiHost: "identitytoolkit.googleapis.com",
      tokenApiHost: "securetoken.googleapis.com",
      apiScheme: "https",
      sdkClientVersion: _getClientVersion(clientPlatform)
    };
    const authInstance = new AuthImpl(app2, heartbeatServiceProvider, appCheckServiceProvider, config);
    _initializeAuthInstance(authInstance, deps);
    return authInstance;
  }, "PUBLIC").setInstantiationMode("EXPLICIT").setInstanceCreatedCallback((container, _instanceIdentifier, _instance) => {
    const authInternalProvider = container.getProvider("auth-internal");
    authInternalProvider.initialize();
  }));
  _registerComponent(new Component2("auth-internal", (container) => {
    const auth = _castAuth(container.getProvider("auth").getImmediate());
    return ((auth2) => new AuthInterop(auth2))(auth);
  }, "PRIVATE").setInstantiationMode("EXPLICIT"));
  registerVersion(name3, version3, getVersionForPlatform(clientPlatform));
  registerVersion(name3, version3, "esm2017");
}
function getAuth(app2 = getApp()) {
  const provider = _getProvider(app2, "auth");
  if (provider.isInitialized()) {
    return provider.getImmediate();
  }
  const auth = initializeAuth(app2, {
    popupRedirectResolver: browserPopupRedirectResolver,
    persistence: [
      indexedDBLocalPersistence,
      browserLocalPersistence,
      browserSessionPersistence
    ]
  });
  const authTokenSyncUrl = getExperimentalSetting("authTokenSyncURL");
  if (authTokenSyncUrl) {
    const mintCookie = mintCookieFactory(authTokenSyncUrl);
    beforeAuthStateChanged(auth, mintCookie, () => mintCookie(auth.currentUser));
    onIdTokenChanged(auth, (user) => mintCookie(user));
  }
  const authEmulatorHost = getDefaultEmulatorHost("auth");
  if (authEmulatorHost) {
    connectAuthEmulator(auth, `http://${authEmulatorHost}`);
  }
  return auth;
}
var prodErrorMap, _DEFAULT_AUTH_ERROR_FACTORY, logClient, SERVER_ERROR_MAP, DEFAULT_API_TIMEOUT_MS, instanceCache, inMemoryPersistence, MINIMUM_MIN_PASSWORD_LENGTH = 6, RECAPTCHA_ENTERPRISE_URL = "https://www.google.com/recaptcha/enterprise.js?render=", RECAPTCHA_ENTERPRISE_VERIFIER_TYPE = "recaptcha-enterprise", FAKE_TOKEN = "NO_RECAPTCHA", EmailAuthCredential, IDP_REQUEST_URI$1 = "http://localhost", OAuthCredential, VERIFY_PHONE_NUMBER_FOR_EXISTING_ERROR_MAP_, PhoneAuthCredential, BaseOAuthProvider, FacebookAuthProvider, GoogleAuthProvider, GithubAuthProvider, TwitterAuthProvider, MultiFactorError, multiFactorUserCache, STORAGE_AVAILABLE_KEY = "__sak", _POLLING_INTERVAL_MS$1 = 1000, IE10_LOCAL_STORAGE_SYNC_DELAY = 10, BrowserLocalPersistence, browserLocalPersistence, BrowserSessionPersistence, browserSessionPersistence, DB_NAME2 = "firebaseLocalStorageDb", DB_VERSION2 = 1, DB_OBJECTSTORE_NAME = "firebaseLocalStorage", DB_DATA_KEYPATH = "fbase_key", _POLLING_INTERVAL_MS = 800, _TRANSACTION_RETRY_COUNT = 3, indexedDBLocalPersistence, _JSLOAD_CALLBACK, NETWORK_TIMEOUT_DELAY, RECAPTCHA_VERIFIER_TYPE = "recaptcha", IdpCredential, _POLL_WINDOW_CLOSE_TIMEOUT, PopupOperation, PENDING_REDIRECT_KEY = "pendingRedirect", redirectOutcomeMap, RedirectAction, EVENT_DUPLICATION_CACHE_DURATION_MS, IP_ADDRESS_REGEX, HTTP_REGEX, NETWORK_TIMEOUT, cachedGApiLoader = null, PING_TIMEOUT, IFRAME_PATH = "__/auth/iframe", EMULATED_IFRAME_PATH = "emulator/auth/iframe", IFRAME_ATTRIBUTES, EID_FROM_APIHOST, BASE_POPUP_OPTIONS, DEFAULT_WIDTH = 500, DEFAULT_HEIGHT = 600, TARGET_BLANK = "_blank", FIREFOX_EMPTY_URL = "http://localhost", WIDGET_PATH = "__/auth/handler", EMULATOR_WIDGET_PATH = "emulator/auth/handler", FIREBASE_APP_CHECK_FRAGMENT_ID, WEB_STORAGE_SUPPORT_KEY = "webStorageSupport", browserPopupRedirectResolver, PhoneMultiFactorAssertionImpl, TotpMultiFactorAssertionImpl, name3 = "@firebase/auth", version3 = "1.3.0", DEFAULT_ID_TOKEN_MAX_AGE, authIdTokenMaxAge, lastPostedIdToken = null, mintCookieFactory = (url) => async (user) => {
  const idTokenResult = user && await user.getIdTokenResult();
  const idTokenAge = idTokenResult && (new Date().getTime() - Date.parse(idTokenResult.issuedAtTime)) / 1000;
  if (idTokenAge && idTokenAge > authIdTokenMaxAge) {
    return;
  }
  const idToken = idTokenResult === null || idTokenResult === undefined ? undefined : idTokenResult.token;
  if (lastPostedIdToken === idToken) {
    return;
  }
  lastPostedIdToken = idToken;
  await fetch(url, {
    method: idToken ? "POST" : "DELETE",
    headers: idToken ? {
      Authorization: `Bearer ${idToken}`
    } : {}
  });
};
var init_index_9a76d29a = __esm(() => {
  init_index_esm2017();
  init_index_esm20174();
  init_index_esm20175();
  init_tslib_es6();
  init_index_esm20177();
  prodErrorMap = _prodErrorMap;
  _DEFAULT_AUTH_ERROR_FACTORY = new ErrorFactory("auth", "Firebase", _prodErrorMap());
  logClient = new Logger2("@firebase/auth");
  SERVER_ERROR_MAP = {
    ["CREDENTIAL_MISMATCH"]: "custom-token-mismatch",
    ["MISSING_CUSTOM_TOKEN"]: "internal-error",
    ["INVALID_IDENTIFIER"]: "invalid-email",
    ["MISSING_CONTINUE_URI"]: "internal-error",
    ["INVALID_PASSWORD"]: "wrong-password",
    ["MISSING_PASSWORD"]: "missing-password",
    ["EMAIL_EXISTS"]: "email-already-in-use",
    ["PASSWORD_LOGIN_DISABLED"]: "operation-not-allowed",
    ["INVALID_IDP_RESPONSE"]: "invalid-credential",
    ["INVALID_PENDING_TOKEN"]: "invalid-credential",
    ["FEDERATED_USER_ID_ALREADY_LINKED"]: "credential-already-in-use",
    ["MISSING_REQ_TYPE"]: "internal-error",
    ["EMAIL_NOT_FOUND"]: "user-not-found",
    ["RESET_PASSWORD_EXCEED_LIMIT"]: "too-many-requests",
    ["EXPIRED_OOB_CODE"]: "expired-action-code",
    ["INVALID_OOB_CODE"]: "invalid-action-code",
    ["MISSING_OOB_CODE"]: "internal-error",
    ["CREDENTIAL_TOO_OLD_LOGIN_AGAIN"]: "requires-recent-login",
    ["INVALID_ID_TOKEN"]: "invalid-user-token",
    ["TOKEN_EXPIRED"]: "user-token-expired",
    ["USER_NOT_FOUND"]: "user-token-expired",
    ["TOO_MANY_ATTEMPTS_TRY_LATER"]: "too-many-requests",
    ["PASSWORD_DOES_NOT_MEET_REQUIREMENTS"]: "password-does-not-meet-requirements",
    ["INVALID_CODE"]: "invalid-verification-code",
    ["INVALID_SESSION_INFO"]: "invalid-verification-id",
    ["INVALID_TEMPORARY_PROOF"]: "invalid-credential",
    ["MISSING_SESSION_INFO"]: "missing-verification-id",
    ["SESSION_EXPIRED"]: "code-expired",
    ["MISSING_ANDROID_PACKAGE_NAME"]: "missing-android-pkg-name",
    ["UNAUTHORIZED_DOMAIN"]: "unauthorized-continue-uri",
    ["INVALID_OAUTH_CLIENT_ID"]: "invalid-oauth-client-id",
    ["ADMIN_ONLY_OPERATION"]: "admin-restricted-operation",
    ["INVALID_MFA_PENDING_CREDENTIAL"]: "invalid-multi-factor-session",
    ["MFA_ENROLLMENT_NOT_FOUND"]: "multi-factor-info-not-found",
    ["MISSING_MFA_ENROLLMENT_ID"]: "missing-multi-factor-info",
    ["MISSING_MFA_PENDING_CREDENTIAL"]: "missing-multi-factor-session",
    ["SECOND_FACTOR_EXISTS"]: "second-factor-already-in-use",
    ["SECOND_FACTOR_LIMIT_EXCEEDED"]: "maximum-second-factor-count-exceeded",
    ["BLOCKING_FUNCTION_ERROR_RESPONSE"]: "internal-error",
    ["RECAPTCHA_NOT_ENABLED"]: "recaptcha-not-enabled",
    ["MISSING_RECAPTCHA_TOKEN"]: "missing-recaptcha-token",
    ["INVALID_RECAPTCHA_TOKEN"]: "invalid-recaptcha-token",
    ["INVALID_RECAPTCHA_ACTION"]: "invalid-recaptcha-action",
    ["MISSING_CLIENT_TYPE"]: "missing-client-type",
    ["MISSING_RECAPTCHA_VERSION"]: "missing-recaptcha-version",
    ["INVALID_RECAPTCHA_VERSION"]: "invalid-recaptcha-version",
    ["INVALID_REQ_TYPE"]: "invalid-req-type"
  };
  DEFAULT_API_TIMEOUT_MS = new Delay(30000, 60000);
  instanceCache = new Map;
  InMemoryPersistence.type = "NONE";
  inMemoryPersistence = InMemoryPersistence;
  EmailAuthCredential = class EmailAuthCredential extends AuthCredential {
    constructor(_email, _password, signInMethod, _tenantId = null) {
      super("password", signInMethod);
      this._email = _email;
      this._password = _password;
      this._tenantId = _tenantId;
    }
    static _fromEmailAndPassword(email, password) {
      return new EmailAuthCredential(email, password, "password");
    }
    static _fromEmailAndCode(email, oobCode, tenantId = null) {
      return new EmailAuthCredential(email, oobCode, "emailLink", tenantId);
    }
    toJSON() {
      return {
        email: this._email,
        password: this._password,
        signInMethod: this.signInMethod,
        tenantId: this._tenantId
      };
    }
    static fromJSON(json) {
      const obj = typeof json === "string" ? JSON.parse(json) : json;
      if ((obj === null || obj === undefined ? undefined : obj.email) && (obj === null || obj === undefined ? undefined : obj.password)) {
        if (obj.signInMethod === "password") {
          return this._fromEmailAndPassword(obj.email, obj.password);
        } else if (obj.signInMethod === "emailLink") {
          return this._fromEmailAndCode(obj.email, obj.password, obj.tenantId);
        }
      }
      return null;
    }
    async _getIdTokenResponse(auth) {
      var _a;
      switch (this.signInMethod) {
        case "password":
          const request = {
            returnSecureToken: true,
            email: this._email,
            password: this._password,
            clientType: "CLIENT_TYPE_WEB"
          };
          if ((_a = auth._getRecaptchaConfig()) === null || _a === undefined ? undefined : _a.emailPasswordEnabled) {
            const requestWithRecaptcha = await injectRecaptchaFields(auth, request, "signInWithPassword");
            return signInWithPassword(auth, requestWithRecaptcha);
          } else {
            return signInWithPassword(auth, request).catch(async (error) => {
              if (error.code === `auth/${"missing-recaptcha-token"}`) {
                console.log("Sign-in with email address and password is protected by reCAPTCHA for this project. Automatically triggering the reCAPTCHA flow and restarting the sign-in flow.");
                const requestWithRecaptcha = await injectRecaptchaFields(auth, request, "signInWithPassword");
                return signInWithPassword(auth, requestWithRecaptcha);
              } else {
                return Promise.reject(error);
              }
            });
          }
        case "emailLink":
          return signInWithEmailLink$1(auth, {
            email: this._email,
            oobCode: this._password
          });
        default:
          _fail(auth, "internal-error");
      }
    }
    async _linkToIdToken(auth, idToken) {
      switch (this.signInMethod) {
        case "password":
          return updateEmailPassword(auth, {
            idToken,
            returnSecureToken: true,
            email: this._email,
            password: this._password
          });
        case "emailLink":
          return signInWithEmailLinkForLinking(auth, {
            idToken,
            email: this._email,
            oobCode: this._password
          });
        default:
          _fail(auth, "internal-error");
      }
    }
    _getReauthenticationResolver(auth) {
      return this._getIdTokenResponse(auth);
    }
  };
  OAuthCredential = class OAuthCredential extends AuthCredential {
    constructor() {
      super(...arguments);
      this.pendingToken = null;
    }
    static _fromParams(params) {
      const cred = new OAuthCredential(params.providerId, params.signInMethod);
      if (params.idToken || params.accessToken) {
        if (params.idToken) {
          cred.idToken = params.idToken;
        }
        if (params.accessToken) {
          cred.accessToken = params.accessToken;
        }
        if (params.nonce && !params.pendingToken) {
          cred.nonce = params.nonce;
        }
        if (params.pendingToken) {
          cred.pendingToken = params.pendingToken;
        }
      } else if (params.oauthToken && params.oauthTokenSecret) {
        cred.accessToken = params.oauthToken;
        cred.secret = params.oauthTokenSecret;
      } else {
        _fail("argument-error");
      }
      return cred;
    }
    toJSON() {
      return {
        idToken: this.idToken,
        accessToken: this.accessToken,
        secret: this.secret,
        nonce: this.nonce,
        pendingToken: this.pendingToken,
        providerId: this.providerId,
        signInMethod: this.signInMethod
      };
    }
    static fromJSON(json) {
      const obj = typeof json === "string" ? JSON.parse(json) : json;
      const { providerId, signInMethod } = obj, rest = __rest(obj, ["providerId", "signInMethod"]);
      if (!providerId || !signInMethod) {
        return null;
      }
      const cred = new OAuthCredential(providerId, signInMethod);
      cred.idToken = rest.idToken || undefined;
      cred.accessToken = rest.accessToken || undefined;
      cred.secret = rest.secret;
      cred.nonce = rest.nonce;
      cred.pendingToken = rest.pendingToken || null;
      return cred;
    }
    _getIdTokenResponse(auth) {
      const request = this.buildRequest();
      return signInWithIdp(auth, request);
    }
    _linkToIdToken(auth, idToken) {
      const request = this.buildRequest();
      request.idToken = idToken;
      return signInWithIdp(auth, request);
    }
    _getReauthenticationResolver(auth) {
      const request = this.buildRequest();
      request.autoCreate = false;
      return signInWithIdp(auth, request);
    }
    buildRequest() {
      const request = {
        requestUri: IDP_REQUEST_URI$1,
        returnSecureToken: true
      };
      if (this.pendingToken) {
        request.pendingToken = this.pendingToken;
      } else {
        const postBody = {};
        if (this.idToken) {
          postBody["id_token"] = this.idToken;
        }
        if (this.accessToken) {
          postBody["access_token"] = this.accessToken;
        }
        if (this.secret) {
          postBody["oauth_token_secret"] = this.secret;
        }
        postBody["providerId"] = this.providerId;
        if (this.nonce && !this.pendingToken) {
          postBody["nonce"] = this.nonce;
        }
        request.postBody = querystring(postBody);
      }
      return request;
    }
  };
  VERIFY_PHONE_NUMBER_FOR_EXISTING_ERROR_MAP_ = {
    ["USER_NOT_FOUND"]: "user-not-found"
  };
  PhoneAuthCredential = class PhoneAuthCredential extends AuthCredential {
    constructor(params) {
      super("phone", "phone");
      this.params = params;
    }
    static _fromVerification(verificationId, verificationCode) {
      return new PhoneAuthCredential({ verificationId, verificationCode });
    }
    static _fromTokenResponse(phoneNumber, temporaryProof) {
      return new PhoneAuthCredential({ phoneNumber, temporaryProof });
    }
    _getIdTokenResponse(auth) {
      return signInWithPhoneNumber$1(auth, this._makeVerificationRequest());
    }
    _linkToIdToken(auth, idToken) {
      return linkWithPhoneNumber$1(auth, Object.assign({ idToken }, this._makeVerificationRequest()));
    }
    _getReauthenticationResolver(auth) {
      return verifyPhoneNumberForExisting(auth, this._makeVerificationRequest());
    }
    _makeVerificationRequest() {
      const { temporaryProof, phoneNumber, verificationId, verificationCode } = this.params;
      if (temporaryProof && phoneNumber) {
        return { temporaryProof, phoneNumber };
      }
      return {
        sessionInfo: verificationId,
        code: verificationCode
      };
    }
    toJSON() {
      const obj = {
        providerId: this.providerId
      };
      if (this.params.phoneNumber) {
        obj.phoneNumber = this.params.phoneNumber;
      }
      if (this.params.temporaryProof) {
        obj.temporaryProof = this.params.temporaryProof;
      }
      if (this.params.verificationCode) {
        obj.verificationCode = this.params.verificationCode;
      }
      if (this.params.verificationId) {
        obj.verificationId = this.params.verificationId;
      }
      return obj;
    }
    static fromJSON(json) {
      if (typeof json === "string") {
        json = JSON.parse(json);
      }
      const { verificationId, verificationCode, phoneNumber, temporaryProof } = json;
      if (!verificationCode && !verificationId && !phoneNumber && !temporaryProof) {
        return null;
      }
      return new PhoneAuthCredential({
        verificationId,
        verificationCode,
        phoneNumber,
        temporaryProof
      });
    }
  };
  EmailAuthProvider.PROVIDER_ID = "password";
  EmailAuthProvider.EMAIL_PASSWORD_SIGN_IN_METHOD = "password";
  EmailAuthProvider.EMAIL_LINK_SIGN_IN_METHOD = "emailLink";
  BaseOAuthProvider = class BaseOAuthProvider extends FederatedAuthProvider {
    constructor() {
      super(...arguments);
      this.scopes = [];
    }
    addScope(scope) {
      if (!this.scopes.includes(scope)) {
        this.scopes.push(scope);
      }
      return this;
    }
    getScopes() {
      return [...this.scopes];
    }
  };
  FacebookAuthProvider = class FacebookAuthProvider extends BaseOAuthProvider {
    constructor() {
      super("facebook.com");
    }
    static credential(accessToken) {
      return OAuthCredential._fromParams({
        providerId: FacebookAuthProvider.PROVIDER_ID,
        signInMethod: FacebookAuthProvider.FACEBOOK_SIGN_IN_METHOD,
        accessToken
      });
    }
    static credentialFromResult(userCredential) {
      return FacebookAuthProvider.credentialFromTaggedObject(userCredential);
    }
    static credentialFromError(error) {
      return FacebookAuthProvider.credentialFromTaggedObject(error.customData || {});
    }
    static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {
      if (!tokenResponse || !("oauthAccessToken" in tokenResponse)) {
        return null;
      }
      if (!tokenResponse.oauthAccessToken) {
        return null;
      }
      try {
        return FacebookAuthProvider.credential(tokenResponse.oauthAccessToken);
      } catch (_a) {
        return null;
      }
    }
  };
  FacebookAuthProvider.FACEBOOK_SIGN_IN_METHOD = "facebook.com";
  FacebookAuthProvider.PROVIDER_ID = "facebook.com";
  GoogleAuthProvider = class GoogleAuthProvider extends BaseOAuthProvider {
    constructor() {
      super("google.com");
      this.addScope("profile");
    }
    static credential(idToken, accessToken) {
      return OAuthCredential._fromParams({
        providerId: GoogleAuthProvider.PROVIDER_ID,
        signInMethod: GoogleAuthProvider.GOOGLE_SIGN_IN_METHOD,
        idToken,
        accessToken
      });
    }
    static credentialFromResult(userCredential) {
      return GoogleAuthProvider.credentialFromTaggedObject(userCredential);
    }
    static credentialFromError(error) {
      return GoogleAuthProvider.credentialFromTaggedObject(error.customData || {});
    }
    static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {
      if (!tokenResponse) {
        return null;
      }
      const { oauthIdToken, oauthAccessToken } = tokenResponse;
      if (!oauthIdToken && !oauthAccessToken) {
        return null;
      }
      try {
        return GoogleAuthProvider.credential(oauthIdToken, oauthAccessToken);
      } catch (_a) {
        return null;
      }
    }
  };
  GoogleAuthProvider.GOOGLE_SIGN_IN_METHOD = "google.com";
  GoogleAuthProvider.PROVIDER_ID = "google.com";
  GithubAuthProvider = class GithubAuthProvider extends BaseOAuthProvider {
    constructor() {
      super("github.com");
    }
    static credential(accessToken) {
      return OAuthCredential._fromParams({
        providerId: GithubAuthProvider.PROVIDER_ID,
        signInMethod: GithubAuthProvider.GITHUB_SIGN_IN_METHOD,
        accessToken
      });
    }
    static credentialFromResult(userCredential) {
      return GithubAuthProvider.credentialFromTaggedObject(userCredential);
    }
    static credentialFromError(error) {
      return GithubAuthProvider.credentialFromTaggedObject(error.customData || {});
    }
    static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {
      if (!tokenResponse || !("oauthAccessToken" in tokenResponse)) {
        return null;
      }
      if (!tokenResponse.oauthAccessToken) {
        return null;
      }
      try {
        return GithubAuthProvider.credential(tokenResponse.oauthAccessToken);
      } catch (_a) {
        return null;
      }
    }
  };
  GithubAuthProvider.GITHUB_SIGN_IN_METHOD = "github.com";
  GithubAuthProvider.PROVIDER_ID = "github.com";
  TwitterAuthProvider = class TwitterAuthProvider extends BaseOAuthProvider {
    constructor() {
      super("twitter.com");
    }
    static credential(token, secret) {
      return OAuthCredential._fromParams({
        providerId: TwitterAuthProvider.PROVIDER_ID,
        signInMethod: TwitterAuthProvider.TWITTER_SIGN_IN_METHOD,
        oauthToken: token,
        oauthTokenSecret: secret
      });
    }
    static credentialFromResult(userCredential) {
      return TwitterAuthProvider.credentialFromTaggedObject(userCredential);
    }
    static credentialFromError(error) {
      return TwitterAuthProvider.credentialFromTaggedObject(error.customData || {});
    }
    static credentialFromTaggedObject({ _tokenResponse: tokenResponse }) {
      if (!tokenResponse) {
        return null;
      }
      const { oauthAccessToken, oauthTokenSecret } = tokenResponse;
      if (!oauthAccessToken || !oauthTokenSecret) {
        return null;
      }
      try {
        return TwitterAuthProvider.credential(oauthAccessToken, oauthTokenSecret);
      } catch (_a) {
        return null;
      }
    }
  };
  TwitterAuthProvider.TWITTER_SIGN_IN_METHOD = "twitter.com";
  TwitterAuthProvider.PROVIDER_ID = "twitter.com";
  MultiFactorError = class MultiFactorError extends FirebaseError {
    constructor(auth, error, operationType, user) {
      var _a;
      super(error.code, error.message);
      this.operationType = operationType;
      this.user = user;
      Object.setPrototypeOf(this, MultiFactorError.prototype);
      this.customData = {
        appName: auth.name,
        tenantId: (_a = auth.tenantId) !== null && _a !== undefined ? _a : undefined,
        _serverResponse: error.customData._serverResponse,
        operationType
      };
    }
    static _fromErrorAndOperation(auth, error, operationType, user) {
      return new MultiFactorError(auth, error, operationType, user);
    }
  };
  multiFactorUserCache = new WeakMap;
  BrowserLocalPersistence = class BrowserLocalPersistence extends BrowserPersistenceClass {
    constructor() {
      super(() => window.localStorage, "LOCAL");
      this.boundEventHandler = (event, poll) => this.onStorageEvent(event, poll);
      this.listeners = {};
      this.localCache = {};
      this.pollTimer = null;
      this.safariLocalStorageNotSynced = _iframeCannotSyncWebStorage() && _isIframe();
      this.fallbackToPolling = _isMobileBrowser();
      this._shouldAllowMigration = true;
    }
    forAllChangedKeys(cb) {
      for (const key of Object.keys(this.listeners)) {
        const newValue = this.storage.getItem(key);
        const oldValue = this.localCache[key];
        if (newValue !== oldValue) {
          cb(key, oldValue, newValue);
        }
      }
    }
    onStorageEvent(event, poll = false) {
      if (!event.key) {
        this.forAllChangedKeys((key2, _oldValue, newValue) => {
          this.notifyListeners(key2, newValue);
        });
        return;
      }
      const key = event.key;
      if (poll) {
        this.detachListener();
      } else {
        this.stopPolling();
      }
      if (this.safariLocalStorageNotSynced) {
        const storedValue2 = this.storage.getItem(key);
        if (event.newValue !== storedValue2) {
          if (event.newValue !== null) {
            this.storage.setItem(key, event.newValue);
          } else {
            this.storage.removeItem(key);
          }
        } else if (this.localCache[key] === event.newValue && !poll) {
          return;
        }
      }
      const triggerListeners = () => {
        const storedValue2 = this.storage.getItem(key);
        if (!poll && this.localCache[key] === storedValue2) {
          return;
        }
        this.notifyListeners(key, storedValue2);
      };
      const storedValue = this.storage.getItem(key);
      if (_isIE10() && storedValue !== event.newValue && event.newValue !== event.oldValue) {
        setTimeout(triggerListeners, IE10_LOCAL_STORAGE_SYNC_DELAY);
      } else {
        triggerListeners();
      }
    }
    notifyListeners(key, value) {
      this.localCache[key] = value;
      const listeners = this.listeners[key];
      if (listeners) {
        for (const listener of Array.from(listeners)) {
          listener(value ? JSON.parse(value) : value);
        }
      }
    }
    startPolling() {
      this.stopPolling();
      this.pollTimer = setInterval(() => {
        this.forAllChangedKeys((key, oldValue, newValue) => {
          this.onStorageEvent(new StorageEvent("storage", {
            key,
            oldValue,
            newValue
          }), true);
        });
      }, _POLLING_INTERVAL_MS$1);
    }
    stopPolling() {
      if (this.pollTimer) {
        clearInterval(this.pollTimer);
        this.pollTimer = null;
      }
    }
    attachListener() {
      window.addEventListener("storage", this.boundEventHandler);
    }
    detachListener() {
      window.removeEventListener("storage", this.boundEventHandler);
    }
    _addListener(key, listener) {
      if (Object.keys(this.listeners).length === 0) {
        if (this.fallbackToPolling) {
          this.startPolling();
        } else {
          this.attachListener();
        }
      }
      if (!this.listeners[key]) {
        this.listeners[key] = new Set;
        this.localCache[key] = this.storage.getItem(key);
      }
      this.listeners[key].add(listener);
    }
    _removeListener(key, listener) {
      if (this.listeners[key]) {
        this.listeners[key].delete(listener);
        if (this.listeners[key].size === 0) {
          delete this.listeners[key];
        }
      }
      if (Object.keys(this.listeners).length === 0) {
        this.detachListener();
        this.stopPolling();
      }
    }
    async _set(key, value) {
      await super._set(key, value);
      this.localCache[key] = JSON.stringify(value);
    }
    async _get(key) {
      const value = await super._get(key);
      this.localCache[key] = JSON.stringify(value);
      return value;
    }
    async _remove(key) {
      await super._remove(key);
      delete this.localCache[key];
    }
  };
  BrowserLocalPersistence.type = "LOCAL";
  browserLocalPersistence = BrowserLocalPersistence;
  BrowserSessionPersistence = class BrowserSessionPersistence extends BrowserPersistenceClass {
    constructor() {
      super(() => window.sessionStorage, "SESSION");
    }
    _addListener(_key, _listener) {
      return;
    }
    _removeListener(_key, _listener) {
      return;
    }
  };
  BrowserSessionPersistence.type = "SESSION";
  browserSessionPersistence = BrowserSessionPersistence;
  Receiver.receivers = [];
  IndexedDBLocalPersistence.type = "LOCAL";
  indexedDBLocalPersistence = IndexedDBLocalPersistence;
  _JSLOAD_CALLBACK = _generateCallbackName("rcb");
  NETWORK_TIMEOUT_DELAY = new Delay(30000, 60000);
  PhoneAuthProvider.PROVIDER_ID = "phone";
  PhoneAuthProvider.PHONE_SIGN_IN_METHOD = "phone";
  IdpCredential = class IdpCredential extends AuthCredential {
    constructor(params) {
      super("custom", "custom");
      this.params = params;
    }
    _getIdTokenResponse(auth) {
      return signInWithIdp(auth, this._buildIdpRequest());
    }
    _linkToIdToken(auth, idToken) {
      return signInWithIdp(auth, this._buildIdpRequest(idToken));
    }
    _getReauthenticationResolver(auth) {
      return signInWithIdp(auth, this._buildIdpRequest());
    }
    _buildIdpRequest(idToken) {
      const request = {
        requestUri: this.params.requestUri,
        sessionId: this.params.sessionId,
        postBody: this.params.postBody,
        tenantId: this.params.tenantId,
        pendingToken: this.params.pendingToken,
        returnSecureToken: true,
        returnIdpCredential: true
      };
      if (idToken) {
        request.idToken = idToken;
      }
      return request;
    }
  };
  _POLL_WINDOW_CLOSE_TIMEOUT = new Delay(2000, 1e4);
  PopupOperation = class PopupOperation extends AbstractPopupRedirectOperation {
    constructor(auth, filter, provider, resolver, user) {
      super(auth, filter, resolver, user);
      this.provider = provider;
      this.authWindow = null;
      this.pollId = null;
      if (PopupOperation.currentPopupAction) {
        PopupOperation.currentPopupAction.cancel();
      }
      PopupOperation.currentPopupAction = this;
    }
    async executeNotNull() {
      const result = await this.execute();
      _assert(result, this.auth, "internal-error");
      return result;
    }
    async onExecution() {
      debugAssert(this.filter.length === 1, "Popup operations only handle one event");
      const eventId = _generateEventId();
      this.authWindow = await this.resolver._openPopup(this.auth, this.provider, this.filter[0], eventId);
      this.authWindow.associatedEvent = eventId;
      this.resolver._originValidation(this.auth).catch((e) => {
        this.reject(e);
      });
      this.resolver._isIframeWebStorageSupported(this.auth, (isSupported) => {
        if (!isSupported) {
          this.reject(_createError(this.auth, "web-storage-unsupported"));
        }
      });
      this.pollUserCancellation();
    }
    get eventId() {
      var _a;
      return ((_a = this.authWindow) === null || _a === undefined ? undefined : _a.associatedEvent) || null;
    }
    cancel() {
      this.reject(_createError(this.auth, "cancelled-popup-request"));
    }
    cleanUp() {
      if (this.authWindow) {
        this.authWindow.close();
      }
      if (this.pollId) {
        window.clearTimeout(this.pollId);
      }
      this.authWindow = null;
      this.pollId = null;
      PopupOperation.currentPopupAction = null;
    }
    pollUserCancellation() {
      const poll = () => {
        var _a, _b;
        if ((_b = (_a = this.authWindow) === null || _a === undefined ? undefined : _a.window) === null || _b === undefined ? undefined : _b.closed) {
          this.pollId = window.setTimeout(() => {
            this.pollId = null;
            this.reject(_createError(this.auth, "popup-closed-by-user"));
          }, 8000);
          return;
        }
        this.pollId = window.setTimeout(poll, _POLL_WINDOW_CLOSE_TIMEOUT.get());
      };
      poll();
    }
  };
  PopupOperation.currentPopupAction = null;
  redirectOutcomeMap = new Map;
  RedirectAction = class RedirectAction extends AbstractPopupRedirectOperation {
    constructor(auth, resolver, bypassAuthState = false) {
      super(auth, [
        "signInViaRedirect",
        "linkViaRedirect",
        "reauthViaRedirect",
        "unknown"
      ], resolver, undefined, bypassAuthState);
      this.eventId = null;
    }
    async execute() {
      let readyOutcome = redirectOutcomeMap.get(this.auth._key());
      if (!readyOutcome) {
        try {
          const hasPendingRedirect = await _getAndClearPendingRedirectStatus(this.resolver, this.auth);
          const result = hasPendingRedirect ? await super.execute() : null;
          readyOutcome = () => Promise.resolve(result);
        } catch (e) {
          readyOutcome = () => Promise.reject(e);
        }
        redirectOutcomeMap.set(this.auth._key(), readyOutcome);
      }
      if (!this.bypassAuthState) {
        redirectOutcomeMap.set(this.auth._key(), () => Promise.resolve(null));
      }
      return readyOutcome();
    }
    async onAuthEvent(event) {
      if (event.type === "signInViaRedirect") {
        return super.onAuthEvent(event);
      } else if (event.type === "unknown") {
        this.resolve(null);
        return;
      }
      if (event.eventId) {
        const user = await this.auth._redirectUserForId(event.eventId);
        if (user) {
          this.user = user;
          return super.onAuthEvent(event);
        } else {
          this.resolve(null);
        }
      }
    }
    async onExecution() {}
    cleanUp() {}
  };
  EVENT_DUPLICATION_CACHE_DURATION_MS = 10 * 60 * 1000;
  IP_ADDRESS_REGEX = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
  HTTP_REGEX = /^https?/;
  NETWORK_TIMEOUT = new Delay(30000, 60000);
  PING_TIMEOUT = new Delay(5000, 15000);
  IFRAME_ATTRIBUTES = {
    style: {
      position: "absolute",
      top: "-100px",
      width: "1px",
      height: "1px"
    },
    "aria-hidden": "true",
    tabindex: "-1"
  };
  EID_FROM_APIHOST = new Map([
    ["identitytoolkit.googleapis.com", "p"],
    ["staging-identitytoolkit.sandbox.googleapis.com", "s"],
    ["test-identitytoolkit.sandbox.googleapis.com", "t"]
  ]);
  BASE_POPUP_OPTIONS = {
    location: "yes",
    resizable: "yes",
    statusbar: "yes",
    toolbar: "no"
  };
  FIREBASE_APP_CHECK_FRAGMENT_ID = encodeURIComponent("fac");
  browserPopupRedirectResolver = BrowserPopupRedirectResolver;
  PhoneMultiFactorAssertionImpl = class PhoneMultiFactorAssertionImpl extends MultiFactorAssertionImpl {
    constructor(credential) {
      super("phone");
      this.credential = credential;
    }
    static _fromCredential(credential) {
      return new PhoneMultiFactorAssertionImpl(credential);
    }
    _finalizeEnroll(auth, idToken, displayName) {
      return finalizeEnrollPhoneMfa(auth, {
        idToken,
        displayName,
        phoneVerificationInfo: this.credential._makeVerificationRequest()
      });
    }
    _finalizeSignIn(auth, mfaPendingCredential) {
      return finalizeSignInPhoneMfa(auth, {
        mfaPendingCredential,
        phoneVerificationInfo: this.credential._makeVerificationRequest()
      });
    }
  };
  PhoneMultiFactorGenerator.FACTOR_ID = "phone";
  TotpMultiFactorGenerator.FACTOR_ID = "totp";
  TotpMultiFactorAssertionImpl = class TotpMultiFactorAssertionImpl extends MultiFactorAssertionImpl {
    constructor(otp, enrollmentId, secret) {
      super("totp");
      this.otp = otp;
      this.enrollmentId = enrollmentId;
      this.secret = secret;
    }
    static _fromSecret(secret, otp) {
      return new TotpMultiFactorAssertionImpl(otp, undefined, secret);
    }
    static _fromEnrollmentId(enrollmentId, otp) {
      return new TotpMultiFactorAssertionImpl(otp, enrollmentId);
    }
    async _finalizeEnroll(auth, idToken, displayName) {
      _assert(typeof this.secret !== "undefined", auth, "argument-error");
      return finalizeEnrollTotpMfa(auth, {
        idToken,
        displayName,
        totpVerificationInfo: this.secret._makeTotpVerificationInfo(this.otp)
      });
    }
    async _finalizeSignIn(auth, mfaPendingCredential) {
      _assert(this.enrollmentId !== undefined && this.otp !== undefined, auth, "argument-error");
      const totpVerificationInfo = { verificationCode: this.otp };
      return finalizeSignInTotpMfa(auth, {
        mfaPendingCredential,
        mfaEnrollmentId: this.enrollmentId,
        totpVerificationInfo
      });
    }
  };
  DEFAULT_ID_TOKEN_MAX_AGE = 5 * 60;
  authIdTokenMaxAge = getExperimentalSetting("authIdTokenMaxAge") || DEFAULT_ID_TOKEN_MAX_AGE;
  registerAuth("Browser");
});

// ../node_modules/firebase/node_modules/@firebase/auth/dist/esm2017/index-72f7278d0035e72b3f590dcb594529c4-544c8ad1d62a03099a8d7ec2c4340acd.js
var init_esm2017 = __esm(() => {
  init_index_9a76d29a();
  init_index_esm2017();
  init_index_esm20174();
  init_index_esm20175();
  init_index_esm20177();
});

// ../node_modules/firebase/auth/dist/esm/index.esm.js
var init_index_esm2 = __esm(() => {
  init_esm2017();
});

// ../shared/.build/noun-affiliate-commission-summary.js
var require_noun_affiliate_commission_summary = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-agentic-search-types.js
var require_noun_agentic_search_types = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-annotation.js
var require_noun_annotation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-article-preview.js
var require_noun_article_preview = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-availability.js
var require_noun_availability = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-barcode-kind.js
var require_noun_barcode_kind = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-medal-stand-analysis.js
var require_noun_medal_stand_analysis = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-chart-options.js
var require_noun_chart_options = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-condition.js
var require_noun_condition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-credit-card-affiliate-links.js
var require_noun_credit_card_affiliate_links = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.CREDIT_CARD_ALL = exports.CREDIT_CARD_HONORABLE_MENTIONS = exports.CREDIT_CARD_FEATURED = undefined;
  exports.verbCreditCardAffiliateUrlGet = verbCreditCardAffiliateUrlGet;
  exports.verbCreditCardForCategoryGet = verbCreditCardForCategoryGet;
  exports.verbCreditCardLinksAreConfigured = verbCreditCardLinksAreConfigured;
  exports.CREDIT_CARD_FEATURED = [
    {
      cardId: "citi-double-cash",
      issuer: "Citi",
      cardName: "Double Cash Card",
      affiliateUrl: "PLACEHOLDER_CITI_DOUBLE_CASH",
      cashbackPercent: 2,
      bestFor: ["everyday", "general"],
      annualFee: 0,
      description: "2% back on everything. 1% when you buy, 1% when you pay. No categories to track."
    },
    {
      cardId: "discover-it",
      issuer: "Discover",
      cardName: "it Cash Back",
      affiliateUrl: "PLACEHOLDER_DISCOVER_IT",
      cashbackPercent: 5,
      bestFor: ["new-cardholder", "rotating-categories"],
      annualFee: 0,
      description: "5% on rotating categories + unlimited cashback match your first year."
    },
    {
      cardId: "capital-one-savorone",
      issuer: "Capital One",
      cardName: "SavorOne Cash Rewards",
      affiliateUrl: "PLACEHOLDER_CAPITAL_ONE_SAVOR_ONE",
      cashbackPercent: 3,
      bestFor: ["dining", "groceries", "entertainment"],
      annualFee: 0,
      description: "3% on dining, entertainment, streaming, and grocery stores."
    },
    {
      cardId: "chase-freedom-unlimited",
      issuer: "Chase",
      cardName: "Freedom Unlimited",
      affiliateUrl: "PLACEHOLDER_CHASE_FREEDOM_UNLIMITED",
      cashbackPercent: 5,
      bestFor: ["travel", "flexible"],
      annualFee: 0,
      description: "5% on travel through Chase, 3% on dining and drugstores, 1.5% on everything else."
    },
    {
      cardId: "amex-blue-cash-preferred",
      issuer: "American Express",
      cardName: "Blue Cash Preferred",
      affiliateUrl: "PLACEHOLDER_AMEX_BLUE_CASH_PREFERRED",
      cashbackPercent: 6,
      bestFor: ["groceries", "streaming"],
      annualFee: 95,
      description: "6% at U.S. supermarkets (up to $6k/year), 6% on streaming, 3% at gas stations."
    }
  ];
  exports.CREDIT_CARD_HONORABLE_MENTIONS = [
    {
      cardId: "chase-sapphire-reserve",
      issuer: "Chase",
      cardName: "Sapphire Reserve",
      affiliateUrl: "PLACEHOLDER_CHASE_SAPPHIRE_RESERVE",
      cashbackPercent: 3,
      bestFor: ["travel", "premium"],
      annualFee: 550,
      description: "Premium travel card with 3x points on travel, $300 travel credit, Priority Pass."
    },
    {
      cardId: "capital-one-venture",
      issuer: "Capital One",
      cardName: "Venture Rewards",
      affiliateUrl: "PLACEHOLDER_CAPITAL_ONE_VENTURE",
      cashbackPercent: 2,
      bestFor: ["travel", "simple-miles"],
      annualFee: 95,
      description: "2x miles on every purchase. 75,000 mile welcome bonus."
    },
    {
      cardId: "citi-custom-cash",
      issuer: "Citi",
      cardName: "Custom Cash",
      affiliateUrl: "PLACEHOLDER_CITI_CUSTOM_CASH",
      cashbackPercent: 5,
      bestFor: ["flexible-categories"],
      annualFee: 0,
      description: "Auto 5% on your highest spend category each month (up to $500)."
    },
    {
      cardId: "amex-gold",
      issuer: "American Express",
      cardName: "Gold Card",
      affiliateUrl: "PLACEHOLDER_AMEX_GOLD",
      cashbackPercent: 4,
      bestFor: ["dining", "groceries", "premium"],
      annualFee: 325,
      description: "4x points on dining and groceries. $325 fee with $400+ in statement credits."
    }
  ];
  exports.CREDIT_CARD_ALL = [
    ...exports.CREDIT_CARD_FEATURED,
    ...exports.CREDIT_CARD_HONORABLE_MENTIONS
  ];
  function verbCreditCardAffiliateUrlGet({ card, surface }) {
    const baseUrl = card.affiliateUrl;
    if (baseUrl.startsWith("PLACEHOLDER")) {
      return baseUrl;
    }
    const separator = baseUrl.includes("?") ? "&" : "?";
    return `${baseUrl}${separator}utm_source=${surface}&utm_medium=credit-card-guide&utm_campaign=2026`;
  }
  function verbCreditCardForCategoryGet({ category }) {
    const lowerCategory = (category || "").toLowerCase();
    if (lowerCategory.includes("grocer") || lowerCategory.includes("food")) {
      return exports.CREDIT_CARD_FEATURED.find((c) => c.cardId === "amex-blue-cash-preferred");
    }
    if (lowerCategory.includes("dining") || lowerCategory.includes("restaurant")) {
      return exports.CREDIT_CARD_FEATURED.find((c) => c.cardId === "capital-one-savorone");
    }
    if (lowerCategory.includes("travel") || lowerCategory.includes("flight") || lowerCategory.includes("hotel")) {
      return exports.CREDIT_CARD_FEATURED.find((c) => c.cardId === "chase-freedom-unlimited");
    }
    return exports.CREDIT_CARD_FEATURED.find((c) => c.cardId === "citi-double-cash");
  }
  function verbCreditCardLinksAreConfigured() {
    return exports.CREDIT_CARD_FEATURED.every((card) => !card.affiliateUrl.startsWith("PLACEHOLDER"));
  }
});

// ../shared/.build/noun-coordinates.js
var require_noun_coordinates = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbCoordinatesCreate = verbCoordinatesCreate;
  exports.verbCoordinatesDistanceInKilometersGet = verbCoordinatesDistanceInKilometersGet;
  function verbCoordinatesCreate({ latitude, longitude }) {
    return {
      latitude,
      longitude
    };
  }
  function verbCoordinatesDistanceInKilometersGet({ coordinates1, coordinates2 }) {
    const earthRadius = 6371;
    const lat1Rad = coordinates1.latitude * Math.PI / 180;
    const lat2Rad = coordinates2.latitude * Math.PI / 180;
    const lon1Rad = coordinates1.longitude * Math.PI / 180;
    const lon2Rad = coordinates2.longitude * Math.PI / 180;
    const dLat = lat2Rad - lat1Rad;
    const dLon = lon2Rad - lon1Rad;
    const a = Math.sin(dLat / 2) * Math.sin(dLat / 2) + Math.cos(lat1Rad) * Math.cos(lat2Rad) * Math.sin(dLon / 2) * Math.sin(dLon / 2);
    const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
    return earthRadius * c;
  }
});

// ../shared/.build/noun-expedition-kind.js
var require_noun_expedition_kind = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-expedition-report.js
var require_noun_expedition_report = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-expedition-request.js
var require_noun_expedition_request = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-expedition.js
var require_noun_expedition = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-enhanced-search-results.js
var require_noun_enhanced_search_results = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-enterprise-search-subscription.js
var require_noun_enterprise_search_subscription = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-extension-content-injection-point.js
var require_noun_extension_content_injection_point = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-extension-observation-point.js
var require_noun_extension_observation_point = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-feature.js
var require_noun_feature = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-feed-item-read-options.js
var require_noun_feed_item_read_options = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-feed-item.js
var require_noun_feed_item = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-google-shopping-price-history.js
var require_noun_google_shopping_price_history = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-grade.js
var require_noun_grade = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-jsonish.js
var require_noun_jsonish = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-miner.js
var require_noun_miner = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-mineral.js
var require_noun_mineral = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-nil.js
var require_noun_nil = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-ore-items.js
var require_noun_ore_items = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-ore-request.js
var require_noun_ore_request = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-ore.js
var require_noun_ore = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-platform-type.js
var require_noun_platform_type = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-product-read-input.js
var require_noun_product_read_input = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-prospector-config.js
var require_noun_prospector_config = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-prospector-expedition-results.js
var require_noun_prospector_expedition_results = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-prospector-filters-prices.js
var require_noun_prospector_filters_prices = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-prospector-public.js
var require_noun_prospector_public = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-prospector-redirect-config.js
var require_noun_prospector_redirect_config = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-prospector-user-settings.js
var require_noun_prospector_user_settings = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-refinery-offer.js
var require_noun_refinery_offer = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-scout.js
var require_noun_scout = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-search-source.js
var require_noun_search_source = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.SCOUT_TAG_DISPLAY_NAMES = exports.SOURCE_DISPLAY_NAMES = exports.ALL_SCOUT_TAGS = exports.ALL_SERVER_SOURCES = exports.SEARCH_SOURCE_PREFERENCES_DEFAULT = undefined;
  exports.verbSearchDedupKeyGenerate = verbSearchDedupKeyGenerate;
  function verbSearchDedupKeyGenerate({ title, retailer, price_cents }) {
    const normalizedTitle = title.toLowerCase().replace(/[^a-z0-9\s]/g, "").replace(/\s+/g, " ").trim().substring(0, 100);
    const normalizedRetailer = retailer.toLowerCase().replace(/[^a-z0-9]/g, "");
    const priceBucket = price_cents ? Math.round(price_cents / 100) : 0;
    return `${normalizedTitle}|${normalizedRetailer}|${priceBucket}`;
  }
  exports.SEARCH_SOURCE_PREFERENCES_DEFAULT = {
    intentDefaults: {},
    globallyDisabled: [],
    globallyDisabledScoutTags: []
  };
  exports.ALL_SERVER_SOURCES = [
    "amazon",
    "walmart",
    "google_shopping",
    "groceries",
    "digital_music",
    "digital_video",
    "digital_games",
    "digital_books",
    "shopify_catalog"
  ];
  exports.ALL_SCOUT_TAGS = [
    "sells-everything",
    "electronics",
    "grocery-food",
    "clothing",
    "home-garden",
    "books",
    "toys-games",
    "sports-outdoors",
    "beauty",
    "health-pharmacy",
    "appliances",
    "automotive",
    "office-supplies",
    "pet-supplies",
    "jewelry-watches"
  ];
  exports.SOURCE_DISPLAY_NAMES = {
    amazon: "Amazon",
    walmart: "Walmart",
    google_shopping: "Google Shopping",
    groceries: "Groceries",
    digital_music: "Music",
    digital_video: "Video",
    digital_games: "Games",
    digital_books: "Books",
    shopify_catalog: "Shopify Stores"
  };
  exports.SCOUT_TAG_DISPLAY_NAMES = {
    "sells-everything": "Major Retailers",
    electronics: "Electronics",
    "grocery-food": "Grocery Stores",
    clothing: "Clothing",
    "home-garden": "Home & Garden",
    books: "Bookstores",
    "toys-games": "Toys & Games",
    "sports-outdoors": "Sports & Outdoors",
    beauty: "Beauty",
    "health-pharmacy": "Health & Pharmacy",
    appliances: "Appliances",
    automotive: "Automotive",
    "office-supplies": "Office Supplies",
    "pet-supplies": "Pet Supplies",
    "jewelry-watches": "Jewelry & Watches"
  };
});

// ../shared/.build/noun-siftable.js
var require_noun_siftable = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sifter-function-context.js
var require_noun_sifter_function_context = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sifter-function.js
var require_noun_sifter_function = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sifter.js
var require_noun_sifter = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-alert.js
var require_noun_sql_alert = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-article.js
var require_noun_sql_article = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-auth.js
var require_noun_sql_auth = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-blog-post.js
var require_noun_sql_blog_post = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-background-session.js
var require_noun_sql_background_session = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-click.js
var require_noun_sql_click = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-conversation-message.js
var require_noun_sql_conversation_message = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-conversation.js
var require_noun_sql_conversation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-coupon-code.js
var require_noun_sql_coupon_code = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-credit-card-reward.js
var require_noun_sql_credit_card_reward = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-credentials.js
var require_noun_sql_credentials = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-deal.js
var require_noun_sql_deal = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-device.js
var require_noun_sql_device = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-expedition-record.js
var require_noun_sql_expedition_record = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-folder.js
var require_noun_sql_folder = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-keyword-search.js
var require_noun_sql_keyword_search = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-offer-archive.js
var require_noun_sql_offer_archive = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-offer-change.js
var require_noun_sql_offer_change = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-offer-stats.js
var require_noun_sql_offer_stats = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-offer-track.js
var require_noun_sql_offer_track = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-offer-tracks-computed.js
var require_noun_sql_offer_tracks_computed = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-offer.js
var require_noun_sql_offer = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-post-external.js
var require_noun_sql_post_external = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-product-association.js
var require_noun_sql_product_association = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-product-identifiers.js
var require_noun_sql_product_identifiers = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-product-refresh-metadata.js
var require_noun_sql_product_refresh_metadata = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-product-review-phrase.js
var require_noun_sql_product_review_phrase = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-product.js
var require_noun_sql_product = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-purchase.js
var require_noun_sql_purchase = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-queued.js
var require_noun_sql_queued = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-retailer.js
var require_noun_sql_retailer = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-review.js
var require_noun_sql_review = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-ucp-checkout.js
var require_noun_ucp_checkout = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-tag.js
var require_noun_sql_tag = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-tagged.js
var require_noun_sql_tagged = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-user.js
var require_noun_sql_user = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-user-feedback.js
var require_noun_sql_user_feedback = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-sql-watched-product.js
var require_noun_sql_watched_product = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-new-low-validation.js
var require_noun_new_low_validation = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-business-chart-config.js
var require_noun_business_chart_config = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-business-import-job.js
var require_noun_business_import_job = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-business-product.js
var require_noun_business_product = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.BUSINESS_PLAN_LIMITS = undefined;
  exports.BUSINESS_PLAN_LIMITS = {
    starter: {
      plan: "starter",
      productLimit: 50,
      refreshFrequencies: ["daily", "weekly", "manual"],
      features: {
        bulkImport: true,
        apiAccess: false,
        prioritySupport: false,
        customIntegrations: false
      }
    },
    growth: {
      plan: "growth",
      productLimit: 250,
      refreshFrequencies: ["4hours", "12hours", "daily", "weekly", "manual"],
      features: {
        bulkImport: true,
        apiAccess: false,
        prioritySupport: false,
        customIntegrations: false
      }
    },
    pro: {
      plan: "pro",
      productLimit: null,
      refreshFrequencies: ["hourly", "4hours", "12hours", "daily", "weekly", "manual"],
      features: {
        bulkImport: true,
        apiAccess: true,
        prioritySupport: true,
        customIntegrations: true
      }
    }
  };
});

// ../shared/.build/noun-sql-web-push-subscription.js
var require_noun_sql_web_push_subscription = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-task-product-refresh.js
var require_noun_task_product_refresh = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-task-refill-background-refresh-queue.js
var require_noun_task_refill_background_refresh_queue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-venue.js
var require_noun_venue = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/noun-verb-remote.js
var require_noun_verb_remote = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
});

// ../shared/.build/verb-array-shuffle.js
var require_verb_array_shuffle = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbArrayShuffle = verbArrayShuffle;
  function verbArrayShuffle(a) {
    var j, x, i;
    for (i = a.length - 1;i > 0; i--) {
      j = Math.floor(Math.random() * (i + 1));
      x = a[i];
      a[i] = a[j];
      a[j] = x;
    }
    return a;
  }
});

// ../shared/.build/verb-browser-get.js
var require_verb_browser_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbBrowserGet = undefined;
  var verbBrowserGet = () => {
    if (typeof browser !== "undefined") {
      return browser;
    } else if (typeof chrome !== "undefined") {
      return chrome;
    }
    return;
  };
  exports.verbBrowserGet = verbBrowserGet;
});

// ../node_modules/seed-random/index-72f7278d0035e72b3f590dcb594529c4-544c8ad1d62a03099a8d7ec2c4340acd.js
var require_seed_random = __commonJS((exports, module) => {
  var width = 256;
  var chunks = 6;
  var digits = 52;
  var pool = [];
  var GLOBAL = typeof global === "undefined" ? window : global;
  var startdenom = Math.pow(width, chunks);
  var significance = Math.pow(2, digits);
  var overflow = significance * 2;
  var mask = width - 1;
  var oldRandom = Math.random;
  module.exports = function(seed, options) {
    if (options && options.global === true) {
      options.global = false;
      Math.random = module.exports(seed, options);
      options.global = true;
      return Math.random;
    }
    var use_entropy = options && options.entropy || false;
    var key = [];
    var shortseed = mixkey(flatten(use_entropy ? [seed, tostring(pool)] : (0 in arguments) ? seed : autoseed(), 3), key);
    var arc4 = new ARC4(key);
    mixkey(tostring(arc4.S), pool);
    return function() {
      var n = arc4.g(chunks), d = startdenom, x = 0;
      while (n < significance) {
        n = (n + x) * width;
        d *= width;
        x = arc4.g(1);
      }
      while (n >= overflow) {
        n /= 2;
        d /= 2;
        x >>>= 1;
      }
      return (n + x) / d;
    };
  };
  module.exports.resetGlobal = function() {
    Math.random = oldRandom;
  };
  function ARC4(key) {
    var t, keylen = key.length, me = this, i = 0, j = me.i = me.j = 0, s = me.S = [];
    if (!keylen) {
      key = [keylen++];
    }
    while (i < width) {
      s[i] = i++;
    }
    for (i = 0;i < width; i++) {
      s[i] = s[j = mask & j + key[i % keylen] + (t = s[i])];
      s[j] = t;
    }
    (me.g = function(count) {
      var t2, r = 0, i2 = me.i, j2 = me.j, s2 = me.S;
      while (count--) {
        t2 = s2[i2 = mask & i2 + 1];
        r = r * width + s2[mask & (s2[i2] = s2[j2 = mask & j2 + t2]) + (s2[j2] = t2)];
      }
      me.i = i2;
      me.j = j2;
      return r;
    })(width);
  }
  function flatten(obj, depth) {
    var result = [], typ = (typeof obj)[0], prop;
    if (depth && typ == "o") {
      for (prop in obj) {
        try {
          result.push(flatten(obj[prop], depth - 1));
        } catch (e) {}
      }
    }
    return result.length ? result : typ == "s" ? obj : obj + "\x00";
  }
  function mixkey(seed, key) {
    var stringseed = seed + "", smear, j = 0;
    while (j < stringseed.length) {
      key[mask & j] = mask & (smear ^= key[mask & j] * 19) + stringseed.charCodeAt(j++);
    }
    return tostring(key);
  }
  function autoseed(seed) {
    try {
      GLOBAL.crypto.getRandomValues(seed = new Uint8Array(width));
      return tostring(seed);
    } catch (e) {
      return [
        +new Date,
        GLOBAL,
        GLOBAL.navigator && GLOBAL.navigator.plugins,
        GLOBAL.screen,
        tostring(pool)
      ];
    }
  }
  function tostring(a) {
    return String.fromCharCode.apply(0, a);
  }
  mixkey(Math.random(), pool);
});

// ../shared/.build/verb-color-generate-procedurally-from-string.js
var require_verb_color_generate_procedurally_from_string = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbColorGenerateProcedurallyFromString = verbColorGenerateProcedurallyFromString;
  exports.verbColorWithFallback = verbColorWithFallback;
  function verbColorGenerateProcedurallyFromString(input) {
    if (!input) {
      return "0279FD";
    }
    if (input == "track-lowest") {
      return "32C557";
    }
    if (input == "track-lowest-new") {
      return "32C557";
    }
    const choices = [
      "D97706",
      "2563EB",
      "60A5FA",
      "6366F1",
      "9D174D",
      "BE7B31",
      "944280",
      "556A9D"
    ];
    const seed = require_seed_random();
    const random = seed(input, {});
    return choices[Math.floor(random() * choices.length)];
  }
  function verbColorWithFallback(proceduralGenerationInput, input) {
    var _a;
    const output = (_a = input !== null && input !== undefined ? input : verbColorGenerateProcedurallyFromString(proceduralGenerationInput)) !== null && _a !== undefined ? _a : "0279FD";
    return output;
  }
});

// ../config/config/config.json
var require_config2 = __commonJS((exports, module) => {
  module.exports = {
    "background-refresh-enabled": true,
    "background-refresh-refill-tasks": 1000,
    "background-refresh-expeditions-per-session": 10,
    "background-refresh-expeditions-per-session-ios": 8,
    "background-refresh-expeditions-per-session-android": 15,
    "background-refresh-expeditions-per-session-browser-extension": 20,
    "background-refresh-refill-retries-before-giving-up": 5,
    "background-refresh-job-retry-in-seconds": 1,
    "background-refresh-job-subscription-identifier": "projects/shopsavvy-firebase/subscriptions/background-refresher-en-us-sub",
    "background-refresh-priority-high-expire-ttl-in-seconds-comment": "4 hours",
    "background-refresh-priority-high-expire-ttl-in-seconds": 14400,
    "background-refresh-priority-low-expire-ttl-in-seconds-comment": "1 week",
    "background-refresh-priority-low-expire-ttl-in-seconds": 604800,
    "background-refresh-priority-normal-expire-ttl-in-seconds-comment": "1 day",
    "background-refresh-priority-normal-expire-ttl-in-seconds": 86400,
    "background-refresh-priority-rarely-expire-ttl-in-seconds-comment": "1 year",
    "background-refresh-priority-rarely-expire-ttl-in-seconds": 31536000,
    "background-refresh-pubsub-topic-identifier": "background-refresher-en-us",
    "background-refresh-reset-stuck-records-threshold-hours": 1,
    "background-refresh-timeout-ios": 25000,
    "background-refresh-timeout-android": 540000,
    "background-refresh-timeout-browser": 270000,
    "background-refresh-network-timeout": 15000,
    "background-refresh-retry-count": 2,
    "background-refresh-logging-level": "info",
    "background-refresh-memory-limit": 1e8,
    "identifier-admob-ad-unit-native-android-shopsavvy-home": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-native-android-shopsavvy-search": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-native-android-shopsavvy-search-results": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-native-android-shopsavvy-compare": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-native-android-shopsavvy-scan": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-native-android-shopsavvy-watching": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-native-android-shopsavvy-more": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-native-android-shopsavvy-help": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-native-android-shopsavvy-deal": "ca-app-pub-6509382790810007/1506205249",
    "identifier-admob-ad-unit-interstitial-android-shopsavvy-after-scan": "ca-app-pub-6509382790810007/6528783162",
    "identifier-admob-ad-unit-interstitial-android-shopsavvy-after-search": "ca-app-pub-6509382790810007/6528783162",
    "identifier-admob-ad-unit-interstitial-android-shopsavvy-app-open": "ca-app-pub-6509382790810007/2662568344",
    "identifier-admob-ad-unit-banner-android-shopsavvy-home": "ca-app-pub-6509382790810007/6672395147",
    "identifier-admob-ad-unit-banner-android-shopsavvy-search": "ca-app-pub-6509382790810007/1013714674",
    "identifier-admob-ad-unit-banner-android-shopsavvy-search-results": "ca-app-pub-6509382790810007/3051014211",
    "identifier-admob-ad-unit-banner-android-shopsavvy-compare": "ca-app-pub-6509382790810007/8758636465",
    "identifier-admob-ad-unit-banner-android-shopsavvy-scan": "ca-app-pub-6509382790810007/5509656596",
    "identifier-admob-ad-unit-banner-android-shopsavvy-watching": "ca-app-pub-6509382790810007/6672395147",
    "identifier-admob-ad-unit-banner-android-shopsavvy-more": "ca-app-pub-6509382790810007/8509061313",
    "identifier-admob-ad-unit-banner-ios-shopsavvy-home": "ca-app-pub-6509382790810007/4938509636",
    "identifier-admob-ad-unit-banner-ios-shopsavvy-search": "ca-app-pub-6509382790810007/2336698345",
    "identifier-admob-ad-unit-banner-ios-shopsavvy-search-results": "ca-app-pub-6509382790810007/1441090083",
    "identifier-admob-ad-unit-banner-ios-shopsavvy-compare": "ca-app-pub-6509382790810007/4997191717",
    "identifier-admob-ad-unit-banner-ios-shopsavvy-scan": "ca-app-pub-6509382790810007/4541055829",
    "identifier-admob-ad-unit-banner-ios-shopsavvy-watching": "ca-app-pub-6509382790810007/4938509636",
    "identifier-admob-ad-unit-banner-ios-shopsavvy-more": "ca-app-pub-6509382790810007/1438549647",
    "identifier-admob-ad-unit-native-ios-shopsavvy-home": "ca-app-pub-6509382790810007/7995576068",
    "identifier-admob-ad-unit-native-ios-shopsavvy-search": "ca-app-pub-6509382790810007/7705051587",
    "identifier-admob-ad-unit-native-ios-shopsavvy-search-results": "ca-app-pub-6509382790810007/5030501370",
    "identifier-admob-ad-unit-native-ios-shopsavvy-compare": "ca-app-pub-6509382790810007/7128075975",
    "identifier-admob-ad-unit-native-ios-shopsavvy-scan": "ca-app-pub-6509382790810007/4321900578",
    "identifier-admob-ad-unit-native-ios-shopsavvy-watching": "ca-app-pub-6509382790810007/7995576068",
    "identifier-admob-ad-unit-native-ios-shopsavvy-more": "ca-app-pub-6509382790810007/4129495977",
    "identifier-admob-ad-unit-interstitial-ios-shopsavvy-after-scan": "ca-app-pub-6509382790810007/4526388393",
    "identifier-admob-ad-unit-interstitial-ios-shopsavvy-after-search": "ca-app-pub-6509382790810007/4196646524",
    "identifier-admob-ad-unit-interstitial-ios-shopsavvy-related": "ca-app-pub-6509382790810007/7077166040",
    "identifier-firebase-qr-code-reader-ios": "1:440632085034:ios:db4f844a7902faa9",
    "identifier-firebase-regulator": "1:440632085034:web:40c539ddc5df2e5245d153",
    "identifier-firebase-shopsavvy-android": "1:440632085034:android:cddb98d29ca4764a",
    "identifier-firebase-shopsavvy-browser-extension": "1:440632085034:web:ba98e7b652b32ad345d153",
    "identifier-firebase-shopsavvy-ios": "1:440632085034:ios:cef6f326d4075f96",
    "identifier-firebase-shopsavvy-web": "1:440632085034:web:40c539ddc5df2e5245d153",
    "identifier-sender-gcm-shopsavvy-browser-extension": "440632085034",
    "identifier-sender-gcm-shopsavvy-web": "440632085034",
    "identifier-measurement-shopsavvy-browser-extension": "G-73EN459ND0",
    "identifier-measurement-shopsavvy-web": "G-EXKLBKMHM0",
    "key-api-firebase-shopsavvy-browser-extension": "AIzaSyDwmOwZMkiYAhN4ZVR7Ik4U1MAxjhCYmy4",
    "key-api-firebase-shopsavvy-web": "AIzaSyDwmOwZMkiYAhN4ZVR7Ik4U1MAxjhCYmy4",
    "minimum-required-retailers-expedition-rate-prompt": 5,
    "minimum-required-retailers-expedition-rate-prompt-description": "minimum number of retailers required to be found during an expedition to attempt to show a prompt the user to rate the app",
    "config-refinery-host": "146.190.169.60:3002",
    "key-api-amazon-access": "AKIAIFVZBYHPBDD4KDFA",
    "identifier-api-amazon-partner-tag": "shopsavvyemai-20",
    "config-api-amazon-partner-type": "Associates",
    "config-api-amazon-host": "webservices.amazon.com",
    "config-api-amazon-region": "us-east-1",
    "config-api-amazon-keyword-search-resources": [
      "BrowseNodeInfo.BrowseNodes",
      "BrowseNodeInfo.BrowseNodes.Ancestor",
      "Images.Primary.Small",
      "Images.Primary.Medium",
      "Images.Primary.Large",
      "ItemInfo.ByLineInfo",
      "ItemInfo.Classifications",
      "ItemInfo.ExternalIds",
      "ItemInfo.ManufactureInfo",
      "ItemInfo.ProductInfo",
      "ItemInfo.Title",
      "Offers.Listings.Availability.Type",
      "Offers.Listings.Condition",
      "Offers.Listings.MerchantInfo",
      "Offers.Listings.Price"
    ],
    "config-api-amazon-keyword-search-index": "All",
    "config-api-amazon-keyword-search-item-count": 10,
    "config-api-amazon-keyword-search-sort": "Relevance",
    "config-api-amazon-marketplace-domains": {
      US: "www.amazon.com",
      AE: "www.amazon.ae",
      AU: "www.amazon.com.au",
      BE: "www.amazon.com.be",
      BR: "www.amazon.com.br",
      CA: "www.amazon.ca",
      CN: "www.amazon.cn",
      DE: "www.amazon.de",
      EG: "www.amazon.eg",
      ES: "www.amazon.es",
      FR: "www.amazon.fr",
      IN: "www.amazon.in",
      IT: "www.amazon.it",
      JP: "www.amazon.co.jp",
      MX: "www.amazon.com.mx",
      NL: "www.amazon.nl",
      PL: "www.amazon.pl",
      SA: "www.amazon.sa",
      SE: "www.amazon.se",
      SG: "www.amazon.sg",
      TR: "www.amazon.com.tr",
      UK: "www.amazon.co.uk"
    },
    "identifiers-retailers-popular": [
      "amazon",
      "walmart",
      "bestbuy",
      "target",
      "homedepot",
      "lowes"
    ],
    "identifiers-retailers-verified": [
      "1800petmeds",
      "abercrombieandfitch",
      "abt",
      "a4c",
      "acmemarkets",
      "acehardware",
      "adidas",
      "adorama",
      "aeropostale",
      "albertsons",
      "aldoshoes",
      "aliexpress",
      "amazon",
      "alibaba",
      "allsaints",
      "americaneagle",
      "americancrew",
      "americanapparel",
      "anthropologie",
      "anntaylor",
      "apple",
      "asos",
      "athleta",
      "bambeco",
      "bananarepublic",
      "barnesandnoble",
      "basspro",
      "bathandbodyworks",
      "betterworldbooks",
      "belk",
      "beauty",
      "biblio",
      "bonanza",
      "bloomingdales",
      "blackmilkclothing",
      "blackbirdballard",
      "bonobos",
      "bjs",
      "blinq",
      "booksamillion",
      "buywinesonline",
      "brookshiregrocerycompany",
      "brookstone",
      "charlotterusse",
      "cb2",
      "carters",
      "chewy",
      "chroniclebooks",
      "cinemanow",
      "cleanitsupply",
      "coach",
      "colehaan",
      "crateandbarrel",
      "crutchfield",
      "costco",
      "cvs",
      "deepdiscount",
      "datavision",
      "decorativecountryliving",
      "dailysale",
      "delias",
      "dell",
      "denydesigns",
      "dickssportinggoods",
      "dillards",
      "disneystore",
      "dormify",
      "drugstore",
      "dx",
      "ebid",
      "dwr",
      "ecampus",
      "ebay",
      "etsy",
      "express",
      "fancy",
      "fanatics",
      "focuscamera",
      "firebox",
      "fitbit",
      "fisherprice",
      "freepeople",
      "forever21",
      "footlocker",
      "fredmeyer",
      "frys",
      "gamestop",
      "gap",
      "groupon",
      "guitarcenter",
      "hasbro",
      "half",
      "gymboree",
      "hammacher",
      "hammacherschlemmer",
      "hm",
      "heb",
      "hollister",
      "homedepot",
      "horchow",
      "homeland",
      "hickorees",
      "ikea",
      "ilumi",
      "instacart",
      "restorationhardware",
      "jackthreads",
      "jackspade",
      "jet",
      "jcrew",
      "joesjeans",
      "jlpowell",
      "jewelosco",
      "joann",
      "karmaloop",
      "juicycouture",
      "katespade",
      "kmart",
      "landsend",
      "kohls",
      "lego",
      "levi",
      "lanebryant",
      "lenovo",
      "llbean",
      "livingsocial",
      "lululemon",
      "lowes",
      "lordandtaylor",
      "maccosmetics",
      "lovehoney",
      "lulus",
      "macys",
      "madewell",
      "macofalltrades",
      "mattel",
      "massgenie",
      "michaels",
      "microcenter",
      "menswearhouse",
      "momastore",
      "metropcs",
      "michaelkors",
      "mlbshop",
      "mrporter",
      "modcloth",
      "musiciansfriend",
      "needsupply",
      "nastygal",
      "newegg",
      "ninewest",
      "neimanmarcus",
      "netaporter",
      "mytheresa",
      "nebraskafurnituremart",
      "northerntool",
      "nfm",
      "officedepot",
      "nike",
      "nflshop",
      "oaknyc",
      "oldnavy",
      "offerup",
      "nordstrom",
      "officemax",
      "officialcostumes",
      "okini",
      "opensky",
      "pacsun",
      "opulentitems",
      "overstock",
      "oshkosh",
      "papyrus",
      "pathmark",
      "owc",
      "patagonia",
      "pbteen",
      "pcrichard",
      "pcrichardandson",
      "pcrichardson",
      "pcrichardson",
      "photojojo",
      "perpetualkid",
      "petsmart",
      "potterybarn",
      "pourporter",
      "potterybarnkids",
      "pricewhack",
      "quill",
      "quirky",
      "puma",
      "razerzone",
      "radioshack",
      "qvc",
      "safeway",
      "revolveclothing",
      "riverisland",
      "ross",
      "ruelala",
      "sears",
      "sallybeauty",
      "samsung",
      "sephora",
      "samsclub",
      "saturdaysnyc",
      "shaws",
      "shopbop",
      "sportchalet",
      "society6",
      "staples",
      "sportsauthority",
      "spring",
      "spool72",
      "starmarket",
      "stevemadden",
      "super1foods",
      "surlatable",
      "sweetwater",
      "target",
      "techforless",
      "thefryecompany",
      "thefreshmarketstore",
      "theoutnet",
      "thriftbooks",
      "thenorthface",
      "thinkgeek",
      "thestore",
      "tomthumb",
      "toms",
      "tillys",
      "toolnut",
      "tobi",
      "tigerdirect",
      "topman",
      "totalwine",
      "topshop",
      "toysrus",
      "ulta",
      "unbeatablesale",
      "uncommongoods",
      "ugmonk",
      "unionmadegoods",
      "urbanoutfitters",
      "vans",
      "uscellular",
      "victoriassecret",
      "walmart",
      "verizon",
      "vipoutlet",
      "vitaminshoppe",
      "weismarkets",
      "walgreens",
      "wayfair",
      "westelm",
      "wetseal",
      "withings",
      "wilson",
      "windsor",
      "worldmarket",
      "jcpenney",
      "zara",
      "petco",
      "bestbuy",
      "zavvi",
      "yoox",
      "zappos",
      "zgallerie",
      "zazzle",
      "bedbathandbeyond",
      "bhphotovideo",
      "luckybrand",
      "zulily",
      "zoro"
    ],
    "config-refinery-features-shopsavvy": [
      {
        identifier: 1,
        emoji: "🔍",
        headline: "Real-Time Shopping Intelligence",
        subheadline: "Finds every retailer selling an item in real-time, then collects all the prices and other details from each one, so you can always know that you're getting the best possible deal on your purchase."
      },
      {
        identifier: 2,
        emoji: "📈",
        headline: "Advanced Multi-Retailer Price History",
        subheadline: "ShopSavvy tracks every price change at every retailer. Compare price history for multiple retailers and track the lowest price over time."
      },
      {
        identifier: 3,
        emoji: "🔔",
        headline: "Price Drop & Deal Alerts",
        subheadline: "Find out instantly when an item you're interested in drops in price, or something you're shopping for goes on sale. Receive alerts instantly via email or notification."
      },
      {
        identifier: 4,
        emoji: "📦",
        headline: "Back-In-Stock Alerts",
        subheadline: "No more checking multiple web pages over and over. ShopSavvy will continuously check and let you know as soon as we see your item in-stock anywhere."
      },
      {
        identifier: 5,
        emoji: "🔎",
        headline: "Universal Product Search",
        subheadline: "Don't waste time searching a bunch of different sites. ShopSavvy searches all of them with support for keyword, brand, category, and more."
      },
      {
        identifier: 6,
        emoji: "📍",
        headline: "Local Store Finder",
        subheadline: "Stop wasting time going to multiple nearby stores. Find out who actually has an item available at stores near you. No more disappointing trips to stores that are out of stock."
      },
      {
        identifier: 7,
        emoji: "🏪",
        headline: "Comprehensive Third-Party Support",
        subheadline: "Find ratings for each seller, know item conditions, and see in-stock status without checking individual websites."
      },
      {
        identifier: 8,
        emoji: "🎯",
        headline: "Never Miss Out on a Deal Again",
        subheadline: "ShopSavvy will continuously search for any deals matching any of your saved searches and let you know as soon as we see one go live."
      },
      {
        identifier: 9,
        emoji: "📱",
        headline: "Lightning Fast Barcode Scanning",
        subheadline: "Uses advanced machine learning tech to allow your device's camera scan barcodes just as fast as the laser at a supermarket checkout."
      },
      {
        identifier: 10,
        emoji: "🔄",
        headline: "Share to ShopSavvy",
        subheadline: "No matter what you're doing on your device, you can always share a link to any product to ShopSavvy to compare and track prices for it."
      },
      {
        identifier: 11,
        emoji: "🌐",
        headline: "Mobile Browser Extension",
        subheadline: "Enable ShopSavvy's mobile browsing extension to automatically compare and track prices while you shop on your phone or tablet."
      },
      {
        identifier: 12,
        emoji: "📱",
        headline: "Homescreen Widgets",
        subheadline: "Add one or more widgets to your homescreen to track the current lowest price of any of the items in your Watchlist."
      },
      {
        identifier: 13,
        emoji: "🔐",
        headline: "Privacy Protected Shopping",
        subheadline: "ShopSavvy does not collect any personal information, and does not share your shopping habits with anyone."
      },
      {
        identifier: 14,
        emoji: "🚚",
        headline: "Shipping & Delivery Estimates",
        subheadline: "See estimated shipping costs and arrival dates so you can make informed decisions when price isn't the only consideration."
      },
      {
        identifier: 15,
        emoji: "📋",
        headline: "Fully Configurable Alerts",
        subheadline: "Choose exactly what kinds of notifications you want, limit notifications to only popular retailers, and more."
      },
      {
        identifier: 16,
        emoji: "🏷️",
        headline: "Deal Score Filtering",
        subheadline: "ShopSavvy evaluates every deal against our vast knowledge of the shopping world, and gives each one a Deal Score. Configure any saved search to only match deals with at least your desired score."
      },
      {
        identifier: 17,
        emoji: "🔍",
        headline: "Clean Search Results",
        subheadline: "ShopSavvy doesn't try to push you to any specific products in the results. Find deals and coupons matching your search too."
      },
      {
        identifier: 18,
        emoji: "📱",
        headline: "QR Code Support",
        subheadline: "Recognizes and handles all popular formats of QR codes to take something from the real world and view more information about it on your device."
      },
      {
        identifier: 19,
        emoji: "💭",
        headline: "TLDR Reviews",
        subheadline: "Expertly researched reviews about products you're interested in, condensed down to a score, pros/cons and a bottom line."
      },
      {
        identifier: 20,
        emoji: "🥇",
        headline: "Best Picks",
        subheadline: "Expert recommendations highlighting the best overall choice, a budget-friendly option, and picks for specific needs, helping you shop smarter and with confidence."
      }
    ],
    "consumer-followup-launch-date": "2026-02-05"
  };
});

// ../shared/.build/verb-config-key-value-get.js
var require_verb_config_key_value_get = __commonJS((exports) => {
  var __importDefault = exports && exports.__importDefault || function(mod) {
    return mod && mod.__esModule ? mod : { default: mod };
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbConfigKeyValueGet = verbConfigKeyValueGet;
  var config_json_1 = __importDefault(require_config2());
  function verbConfigKeyValueGet(key) {
    return config_json_1.default === null || config_json_1.default === undefined ? undefined : config_json_1.default[key];
  }
});

// ../shared/.build/verb-currency-code-sanitize.js
var require_verb_currency_code_sanitize = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbCurrencyCodeSanitize = verbCurrencyCodeSanitize;
  function verbCurrencyCodeSanitize({ currency }) {
    if (currency && /^[A-Z]{3}$/.test(currency))
      return currency;
    return "USD";
  }
});

// ../shared/.build/verb-date-formatted-relative-time-get.js
var require_verb_date_formatted_relative_time_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbDateFormattedRelativeTimeGet = verbDateFormattedRelativeTimeGet;
  function verbDateFormattedRelativeTimeGet(input) {
    var _a, _b;
    if (!input) {
      return "";
    }
    if (!input.getTime) {
      try {
        input = new Date(input);
      } catch (error) {
        return "";
      }
    }
    if (!input.getTime) {
      return "";
    }
    const now = new Date;
    const diffInMilliseconds = ((_a = input === null || input === undefined ? undefined : input.getTime) === null || _a === undefined ? undefined : _a.call(input)) - ((_b = now === null || now === undefined ? undefined : now.getTime) === null || _b === undefined ? undefined : _b.call(now));
    const formatter = new Intl.RelativeTimeFormat("en", { numeric: "auto" });
    const diffInSeconds = Math.floor(diffInMilliseconds / 1000);
    if (Math.abs(diffInSeconds) < 60) {
      return formatter.format(diffInSeconds, "second");
    }
    const diffInMinutes = Math.floor(diffInMilliseconds / 60000);
    if (Math.abs(diffInMinutes) < 60) {
      return formatter.format(diffInMinutes, "minute");
    }
    const diffInHours = Math.floor(diffInMilliseconds / 3600000);
    if (Math.abs(diffInHours) < 24) {
      return formatter.format(diffInHours, "hour");
    }
    const diffInDays = Math.floor(diffInMilliseconds / 86400000);
    return formatter.format(diffInDays, "day");
  }
});

// ../shared/.build/verb-dates-number-of-days-between-get.js
var require_verb_dates_number_of_days_between_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbDatesNumberOfDaysBetweenGet = undefined;
  var verbDatesNumberOfDaysBetweenGet = (startDate, endDate) => {
    if (!startDate || !endDate) {
      return 0;
    }
    if (typeof startDate == "string") {
      startDate = new Date(startDate);
    }
    if (typeof endDate == "string") {
      endDate = new Date(endDate);
    }
    const oneDay = 1000 * 60 * 60 * 24;
    const start = Date.UTC(endDate === null || endDate === undefined ? undefined : endDate.getFullYear(), endDate === null || endDate === undefined ? undefined : endDate.getMonth(), endDate === null || endDate === undefined ? undefined : endDate.getDate());
    const end = Date.UTC(startDate === null || startDate === undefined ? undefined : startDate.getFullYear(), startDate === null || startDate === undefined ? undefined : startDate.getMonth(), startDate === null || startDate === undefined ? undefined : startDate.getDate());
    return (start - end) / oneDay;
  };
  exports.verbDatesNumberOfDaysBetweenGet = verbDatesNumberOfDaysBetweenGet;
});

// ../shared/.build/verb-grade-style-get.js
var require_verb_grade_style_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbGradeStyleGet = verbGradeStyleGet;
  function verbGradeStyleGet({ letter, suffix, value }) {
    if (value >= 0.97) {
      return "positive";
    } else if (value >= 0.93) {
      return "positive";
    } else if (value >= 0.9) {
      return "positive";
    } else if (value >= 0.87) {
      return "default";
    } else if (value >= 0.83) {
      return "default";
    } else if (value >= 0.8) {
      return "default";
    } else if (value >= 0.77) {
      return "attention";
    } else if (value >= 0.73) {
      return "attention";
    } else if (value >= 0.7) {
      return "attention";
    } else if (value >= 0.67) {
      return "attention";
    } else if (value >= 0.63) {
      return "negative";
    } else {
      return "negative";
    }
  }
});

// ../shared/.build/verb-locale-get-normalized.js
var require_verb_locale_get_normalized = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbLocaleGetNormalized = verbLocaleGetNormalized;
  function verbLocaleGetNormalized(locale) {
    if (!locale) {
      return "en-us";
    }
    if (locale.includes("#")) {
      const index = locale.indexOf("#");
      return locale.toLowerCase().replace(/_/g, "-").substring(0, index);
    }
    return locale.toLowerCase().replace(/_/g, "-");
  }
});

// ../shared/.build/verb-localized-text-get.js
var require_verb_localized_text_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbLocalizedTextGet = verbLocalizedTextGet;
  function verbLocalizedTextGet(identifier, locale = "en-us", values = {}) {
    var _a, _b, _c, _d;
    let json = undefined;
    if (typeof identifier != "string") {
      json = Object.assign({}, identifier);
    }
    let text = undefined;
    try {
      text = (_c = (_b = (_a = json === null || json === undefined ? undefined : json[locale === null || locale === undefined ? undefined : locale.toLowerCase()]) !== null && _a !== undefined ? _a : json === null || json === undefined ? undefined : json[locale === null || locale === undefined ? undefined : locale.toLowerCase().replace(/-.*/, "-*")]) !== null && _b !== undefined ? _b : json === null || json === undefined ? undefined : json.string) !== null && _c !== undefined ? _c : json === null || json === undefined ? undefined : json.text;
      if (!text) {
        return `${identifier}-localization-error` + (values ? " " + JSON.stringify(values) : "");
      }
      if (typeof values === "string") {
        return text.replace("{{1}}", values);
      }
      if (Array.isArray(values)) {
        let i = 0;
        for (const key of values !== null && values !== undefined ? values : []) {
          const value = values[key];
          text = text.replace("{{" + i + "}}", value);
          i++;
        }
        return text;
      }
      for (const key of (_d = Object.keys(values)) !== null && _d !== undefined ? _d : []) {
        const value = values[key];
        text = text.replace("{{" + key + "}}", value);
      }
    } catch (e) {
      console.log("LOCALIZATION PARSE ERROR", { e, message: e.message, identifier, locale, values, json, text });
    }
    return text !== null && text !== undefined ? text : `${identifier}-missing-localization`;
  }
});

// ../shared/.build/verb-path-user-is-staff.js
var require_verb_path_user_is_staff = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbPathUserIsStaff = verbPathUserIsStaff;
  function verbPathUserIsStaff({ pathUser }) {
    let isStaff = false;
    if ([
      "49935",
      "ejCL0TeD9KbXbiDlG7Iuk1fbTJ82",
      "XPQZY2r41HRSAYfPC2eEcXehiSg1",
      "OiVsCIvKnRNVyUwDYLl6k2gvUF53",
      "1JF0BvcE8ZS1AoPuYlxMsiAHDqY2",
      "X3y3yYE193OxN3HOPIQrurDwtCE2",
      "6vXGBhCUD0WG7CU1vJbYLHU6gjA3"
    ].includes((pathUser === null || pathUser === undefined ? undefined : pathUser.split("/").pop()) || "")) {
      isStaff = true;
    }
    return isStaff;
  }
});

// ../shared/.build/verb-platform-is-kind.js
var require_verb_platform_is_kind = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbPlatformIsKindElectron = exports.verbPlatformIsKindCEF = exports.verbPlatformIsKindPlaywright = exports.verbPlatformIsKindWindowsTablet = exports.verbPlatformIsKindWindows = exports.verbPlatformIsKindTablet = exports.verbPlatformIsKindSafari = exports.verbPlatformIsKindOpera = exports.verbPlatformIsKindMobile = exports.verbPlatformIsKindMac = exports.verbPlatformIsKindLinux = exports.verbPlatformIsKindiPod = exports.verbPlatformIsKindiPhone = exports.verbPlatformIsKindiPad = exports.verbPlatformIsKindiOS = exports.verbPlatformIsKindFirefox = exports.verbPlatformIsKindEdge = exports.verbPlatformIsKindDesktop = exports.verbPlatformIsKindChrome = exports.verbPlatformIsKindAndroidTablet = exports.verbPlatformIsKindAndroidPhone = exports.verbPlatformIsKindAndroid = undefined;
  exports.verbPlatformIsKindPWA = verbPlatformIsKindPWA;
  var platform = (typeof navigator != "undefined" && navigator && navigator.platform || "").toLowerCase();
  var userAgent = (typeof navigator != "undefined" && navigator && navigator.userAgent || "").toLowerCase();
  var vendor = (typeof navigator != "undefined" && navigator && navigator.vendor || "").toLowerCase();
  var verbPlatformIsKindAndroid = () => /android/.test(userAgent);
  exports.verbPlatformIsKindAndroid = verbPlatformIsKindAndroid;
  var verbPlatformIsKindAndroidPhone = () => /android/.test(userAgent) && /mobile/.test(userAgent);
  exports.verbPlatformIsKindAndroidPhone = verbPlatformIsKindAndroidPhone;
  var verbPlatformIsKindAndroidTablet = () => /android/.test(userAgent) && !/mobile/.test(userAgent);
  exports.verbPlatformIsKindAndroidTablet = verbPlatformIsKindAndroidTablet;
  var verbPlatformIsKindChrome = () => {
    const match = /google inc/.test(vendor) ? userAgent.match(/(?:chrome|crios)\/(\d+)/) : null;
    return match !== null && !(0, exports.verbPlatformIsKindOpera)();
  };
  exports.verbPlatformIsKindChrome = verbPlatformIsKindChrome;
  var verbPlatformIsKindDesktop = () => !(0, exports.verbPlatformIsKindMobile)() && !(0, exports.verbPlatformIsKindTablet)();
  exports.verbPlatformIsKindDesktop = verbPlatformIsKindDesktop;
  var verbPlatformIsKindEdge = () => {
    const match = userAgent.match(/edg\/(\d+)/i);
    return match !== null;
  };
  exports.verbPlatformIsKindEdge = verbPlatformIsKindEdge;
  var verbPlatformIsKindFirefox = () => {
    const match = userAgent.match(/(?:firefox|fxios)\/(\d+)/);
    return match !== null;
  };
  exports.verbPlatformIsKindFirefox = verbPlatformIsKindFirefox;
  var verbPlatformIsKindiOS = () => (0, exports.verbPlatformIsKindiPhone)() || (0, exports.verbPlatformIsKindiPad)() || (0, exports.verbPlatformIsKindiPod)();
  exports.verbPlatformIsKindiOS = verbPlatformIsKindiOS;
  var verbPlatformIsKindiPad = () => {
    const match = userAgent.match(/ipad.+?os (\d+)/);
    const isiPadOSTest2 = typeof navigator != "undefined" && /Macintosh/.test(navigator === null || navigator === undefined ? undefined : navigator.userAgent) && (typeof document != "undefined" && ("ontouchend" in document));
    return match !== null || isiPadOSTest2;
  };
  exports.verbPlatformIsKindiPad = verbPlatformIsKindiPad;
  var verbPlatformIsKindiPhone = () => {
    const match = (0, exports.verbPlatformIsKindiPad)() ? null : userAgent.match(/iphone(?:.+?os (\d+))?/);
    return match !== null;
  };
  exports.verbPlatformIsKindiPhone = verbPlatformIsKindiPhone;
  var verbPlatformIsKindiPod = () => {
    const match = userAgent.match(/ipod.+?os (\d+)/);
    return match !== null;
  };
  exports.verbPlatformIsKindiPod = verbPlatformIsKindiPod;
  var verbPlatformIsKindLinux = () => /linux/.test(platform) && (0, exports.verbPlatformIsKindAndroid)() == false;
  exports.verbPlatformIsKindLinux = verbPlatformIsKindLinux;
  var verbPlatformIsKindMac = () => /mac/.test(platform);
  exports.verbPlatformIsKindMac = verbPlatformIsKindMac;
  var verbPlatformIsKindMobile = () => (0, exports.verbPlatformIsKindiPhone)() || (0, exports.verbPlatformIsKindiPod)() || (0, exports.verbPlatformIsKindAndroidPhone)();
  exports.verbPlatformIsKindMobile = verbPlatformIsKindMobile;
  var verbPlatformIsKindOpera = () => {
    const match = userAgent.match(/(?:^opera.+?version|opr)\/(\d+)/);
    return match !== null;
  };
  exports.verbPlatformIsKindOpera = verbPlatformIsKindOpera;
  var verbPlatformIsKindSafari = () => {
    const match = userAgent.match(/version\/(\d+).+?safari/);
    return match !== null;
  };
  exports.verbPlatformIsKindSafari = verbPlatformIsKindSafari;
  var verbPlatformIsKindTablet = () => (0, exports.verbPlatformIsKindiPad)() || (0, exports.verbPlatformIsKindAndroidTablet)() || (0, exports.verbPlatformIsKindWindowsTablet)();
  exports.verbPlatformIsKindTablet = verbPlatformIsKindTablet;
  var verbPlatformIsKindWindows = () => /win/.test(platform);
  exports.verbPlatformIsKindWindows = verbPlatformIsKindWindows;
  var verbPlatformIsKindWindowsTablet = () => (0, exports.verbPlatformIsKindWindows)() && /touch/.test(userAgent);
  exports.verbPlatformIsKindWindowsTablet = verbPlatformIsKindWindowsTablet;
  var verbPlatformIsKindPlaywright = () => {
    return typeof window !== "undefined" && window && window.__playwright__ && window.__playwright__ === true;
  };
  exports.verbPlatformIsKindPlaywright = verbPlatformIsKindPlaywright;
  var verbPlatformIsKindCEF = () => {
    return typeof window !== "undefined" && window && typeof window.cefQuery === "function";
  };
  exports.verbPlatformIsKindCEF = verbPlatformIsKindCEF;
  var verbPlatformIsKindElectron = () => {
    return typeof window !== "undefined" && window && typeof window.electronBridge === "object";
  };
  exports.verbPlatformIsKindElectron = verbPlatformIsKindElectron;
  function verbPlatformIsKindPWA() {
    if ("standalone" in window.navigator && window.navigator.standalone) {
      return true;
    }
    if (window.matchMedia("(display-mode: standalone)").matches) {
      return true;
    }
    return false;
  }
});

// ../shared/.build/verb-retailer-identifier-is-include-in-config-array.js
var require_verb_retailer_identifier_is_include_in_config_array = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbRetailerIdentifierIsIncludeInConfigArray = verbRetailerIdentifierIsIncludeInConfigArray;
  var verb_config_key_value_get_1 = require_verb_config_key_value_get();
  function verbRetailerIdentifierIsIncludeInConfigArray({ identifierRetailer, identifierConfigField }) {
    var _a;
    if (!identifierRetailer) {
      return false;
    }
    const idToUse = identifierRetailer.toLowerCase();
    const identifiersRetailersToSearch = (_a = (0, verb_config_key_value_get_1.verbConfigKeyValueGet)(identifierConfigField)) !== null && _a !== undefined ? _a : [];
    const found = identifiersRetailersToSearch === null || identifiersRetailersToSearch === undefined ? undefined : identifiersRetailersToSearch.find((idr) => idr === idToUse);
    if (found) {
      return true;
    }
    return false;
  }
});

// ../shared/.build/verb-retailer-identifier-is-popular.js
var require_verb_retailer_identifier_is_popular = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbRetailerIdentifierIsPopular = verbRetailerIdentifierIsPopular;
  var verb_retailer_identifier_is_include_in_config_array_1 = require_verb_retailer_identifier_is_include_in_config_array();
  function verbRetailerIdentifierIsPopular(identifier) {
    if (!identifier) {
      return false;
    }
    let normalizedIdentifier = identifier;
    if (identifier.startsWith("retailers/")) {
      normalizedIdentifier = identifier.substring("retailers/".length);
    }
    return (0, verb_retailer_identifier_is_include_in_config_array_1.verbRetailerIdentifierIsIncludeInConfigArray)({
      identifierRetailer: normalizedIdentifier,
      identifierConfigField: "identifiers-retailers-popular"
    });
  }
});

// ../shared/.build/verb-retailer-identifier-is-verified.js
var require_verb_retailer_identifier_is_verified = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbRetailerIdentifierIsVerfied = verbRetailerIdentifierIsVerfied;
  var verb_retailer_identifier_is_include_in_config_array_1 = require_verb_retailer_identifier_is_include_in_config_array();
  function verbRetailerIdentifierIsVerfied(identifier) {
    if (!identifier) {
      return false;
    }
    let normalizedIdentifier = identifier;
    if (identifier.startsWith("retailers/")) {
      normalizedIdentifier = identifier.substring("retailers/".length);
    }
    return (0, verb_retailer_identifier_is_include_in_config_array_1.verbRetailerIdentifierIsIncludeInConfigArray)({
      identifierRetailer: normalizedIdentifier,
      identifierConfigField: "identifiers-retailers-verified"
    });
  }
});

// ../shared/.build/verb-retailer-slug-get.js
var require_verb_retailer_slug_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbRetailerSlugGet = verbRetailerSlugGet;
  function verbRetailerSlugGet(retailerPath) {
    if (!retailerPath)
      return retailerPath;
    return retailerPath.startsWith("retailers/") ? retailerPath.substring("retailers/".length) : retailerPath;
  }
});

// ../shared/.build/verb-score-computed-get.js
var require_verb_score_computed_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbScoreComputedGet = verbScoreComputedGet;
  function verbScoreComputedGet(article) {
    var _a;
    if (!article) {
      return {};
    }
    const scores = (_a = article.scores) !== null && _a !== undefined ? _a : article.scores_synthetic;
    if (!scores) {
      return {};
    }
    let score;
    if (scores === null || scores === undefined ? undefined : scores.overall) {
      score = Number(scores === null || scores === undefined ? undefined : scores.overall) * 10;
    }
    let scoreFormatted;
    if (score) {
      scoreFormatted = score.toString().substring(0, 4);
    }
    if (scoreFormatted === null || scoreFormatted === undefined ? undefined : scoreFormatted.endsWith(".0")) {
      scoreFormatted = scoreFormatted.slice(0, -2);
    }
    if (scoreFormatted === null || scoreFormatted === undefined ? undefined : scoreFormatted.endsWith("0")) {
      scoreFormatted = scoreFormatted.slice(0, -1);
    }
    if ((scores === null || scores === undefined ? undefined : scores.overall) == 1) {
      score = 10;
      scoreFormatted = "10";
    }
    let scoresAspects = {};
    let scoresAspectsFormatted = {};
    if (scores === null || scores === undefined ? undefined : scores.aspects_professional) {
      for (const k of Object.keys(scores.aspects_professional)) {
        if (scores.aspects_professional[k]) {
          scoresAspects[k] = scores.aspects_professional[k];
          const scoreFormattedAspect = (Number(scores.aspects_professional[k]) * 10).toString().substring(0, 4);
          if (scoreFormattedAspect.endsWith(".0")) {
            scoreFormattedAspect.slice(0, -2);
          }
          if (scoreFormattedAspect.endsWith("0")) {
            scoreFormattedAspect.slice(0, -1);
          }
          scoresAspectsFormatted[k] = scoreFormattedAspect;
        }
      }
    }
    let scoreProfessional;
    let scoreFormattedProfessional;
    if (scores === null || scores === undefined ? undefined : scores.overall_professional) {
      scoreProfessional = Number(scores === null || scores === undefined ? undefined : scores.overall_professional) * 10;
      scoreFormattedProfessional = scoreProfessional.toString().substring(0, 4);
      if (scoreFormattedProfessional.endsWith(".0")) {
        scoreFormattedProfessional.slice(0, -2);
      }
      if (scoreFormattedProfessional.endsWith("0")) {
        scoreFormattedProfessional.slice(0, -1);
      }
    }
    let scoreConsumer;
    let scoreFormattedConsumer;
    if (scores === null || scores === undefined ? undefined : scores.overall_customer) {
      scoreConsumer = Number(scores === null || scores === undefined ? undefined : scores.overall_customer) * 10;
      scoreFormattedConsumer = scoreConsumer.toString().substring(0, 4);
      if (scoreFormattedConsumer.endsWith(".0")) {
        scoreFormattedConsumer.slice(0, -2);
      }
      if (scoreFormattedConsumer.endsWith("0")) {
        scoreFormattedConsumer.slice(0, -1);
      }
    }
    return {
      score,
      justification: scores === null || scores === undefined ? undefined : scores.overall_justification,
      scoreFormatted,
      scoreProfessional,
      scoreFormattedProfessional,
      scoreConsumer,
      scoreFormattedConsumer,
      scoresAspects,
      scoresAspectsFormatted
    };
  }
});

// ../shared/.build/verb-url-cleaned-get.js
var require_verb_url_cleaned_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbURLCleanedGet = verbURLCleanedGet;
  function verbURLCleanedGet(wrappedUrl, barcode, errorUrl = "https://shopsavvy.com?error=redirect.unwrap") {
    try {
      if (wrappedUrl && wrappedUrl.toLowerCase().includes("google.com/aclk")) {
        if (barcode) {
          return new URL(`https://www.google.com/search?tbm=shop&q=${barcode}`);
        } else if (errorUrl) {
          return new URL(errorUrl);
        } else {
          return null;
        }
      }
      let url = null;
      try {
        const input = wrappedUrl === null || wrappedUrl === undefined ? undefined : wrappedUrl.replace(/&opi=(\d+)/, "");
        url = new URL(input);
        let wrapped = false;
        do {
          wrapped = false;
          let urlParam = url.searchParams.get("url") || url.searchParams.get("urllink") || url.searchParams.get("u") || url.searchParams.get("u2") || url.searchParams.get("u1") || url.searchParams.get("t") || url.searchParams.get("l") || url.searchParams.get("location") || url.searchParams.get("p") || url.searchParams.get("murl");
          if (!urlParam) {
            switch (url.hostname) {
              case "prf.hn":
                urlParam = decodeURIComponent(url.toString().split("destination:")[1]);
                break;
              case "www.google.com":
                const q = url.searchParams.get("q");
                if ((q === null || q === undefined ? undefined : q.startsWith("http://")) || (q === null || q === undefined ? undefined : q.startsWith("https://"))) {
                  let isValidUrl = true;
                  try {
                    const test = new URL(q);
                  } catch (_) {
                    isValidUrl = false;
                  }
                  if (isValidUrl)
                    urlParam = q;
                }
                break;
            }
          }
          if (urlParam && urlParam.startsWith("www")) {
            urlParam = "https://" + urlParam;
          }
          if (urlParam && urlParam.startsWith("http")) {
            if (urlParam.startsWith("http%3A%2F%2F") || urlParam.startsWith("https%3A%2F%2F")) {
              urlParam = unescape(urlParam);
            }
            try {
              url = new URL(urlParam);
              wrapped = true;
            } catch (failSilently) {}
          }
        } while (wrapped);
      } catch (err) {
        console.log((err === null || err === undefined ? undefined : err.message) || "Error unwrapping URL.", wrappedUrl, err);
      }
      const trackingParams = [
        "utm_source",
        "utm_medium",
        "utm_campaign",
        "utm_content",
        "utm_term",
        "tag",
        "ascsubtag",
        "smid",
        "psc",
        "acampID",
        "loc",
        "ref",
        "clickId",
        "cjevent",
        "cjdata",
        "cnxclid",
        "pjpid",
        "nm_mc",
        "cm_mmc",
        "AFFID",
        "AFFNAME",
        "ACRID",
        "ASUBID",
        "ASID",
        "ranMID",
        "ranEAID",
        "ranSiteID",
        "cmp",
        "refby",
        "user",
        "srsltid",
        "com_cvv",
        "vfsku",
        "opi"
      ];
      for (const param of trackingParams) {
        url === null || url === undefined || url.searchParams.delete(param);
      }
      if ((url === null || url === undefined ? undefined : url.hostname) === "walmart.com") {
        url = new URL(url.toString().replace("walmart.com", "www.walmart.com"));
      } else if ((url === null || url === undefined ? undefined : url.hostname) === "bestbuy.com") {
        url = new URL(url.toString().replace("bestbuy.com", "www.bestbuy.com"));
      }
      if ((url === null || url === undefined ? undefined : url.hostname) === "www.bestbuy.com" && url.pathname.startsWith("/product/")) {
        const productMatch = url.pathname.match(/^\/product\/(.+?)\/[A-Za-z0-9]+\/sku\/(\d+)/);
        if (productMatch) {
          const [, slug, skuId] = productMatch;
          url.pathname = `/site/${slug}/${skuId}.p`;
          url.search = `?skuId=${skuId}`;
        }
      }
      if ((url === null || url === undefined ? undefined : url.hostname) === "www.walmart.com") {
        url.searchParams.delete("selectedSellerId");
      }
      return url;
    } catch (error) {
      console.log("Error unwrapping URL.", { wrappedUrl, error });
      return new URL(wrappedUrl);
    }
  }
});

// ../shared/.build/verb-url-is-google-redirect.js
var require_verb_url_is_google_redirect = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbURLIsGoogleRedirect = verbURLIsGoogleRedirect;
  function verbURLIsGoogleRedirect(url) {
    if (!url)
      return false;
    try {
      const urlObj = new URL(url);
      const hostname = urlObj.hostname.toLowerCase();
      if (!hostname.includes("google.com") && !hostname.includes("google.co.")) {
        return false;
      }
      const pathname = urlObj.pathname.toLowerCase();
      const searchParams = urlObj.searchParams;
      if (pathname === "/search" || pathname.startsWith("/search")) {
        if (searchParams.get("ibp") === "oshop")
          return true;
        if (searchParams.get("udm") === "28")
          return true;
        if (searchParams.has("prds"))
          return true;
      }
      if (pathname.startsWith("/async/"))
        return true;
      if (pathname === "/aclk" || pathname.startsWith("/aclk"))
        return true;
      if (pathname === "/url" || pathname.startsWith("/url"))
        return true;
      return false;
    } catch (_a) {
      const lowerUrl = url.toLowerCase();
      return lowerUrl.includes("google.com/search") && (lowerUrl.includes("ibp=oshop") || lowerUrl.includes("udm=28") || lowerUrl.includes("prds=")) || lowerUrl.includes("google.com/aclk") || lowerUrl.includes("google.com/async/");
    }
  }
});

// ../shared/.build/verb-url-normalize-for-matching.js
var require_verb_url_normalize_for_matching = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbUrlNormalizeForMatching = verbUrlNormalizeForMatching;
  function verbUrlNormalizeForMatching({ url }) {
    if (!url || typeof url !== "string") {
      return url;
    }
    try {
      const trackingParams = [
        "utm_source",
        "utm_medium",
        "utm_campaign",
        "utm_term",
        "utm_content",
        "fbclid",
        "gclid",
        "gclsrc",
        "gbraid",
        "wbraid",
        "_ga",
        "_gac",
        "_gid",
        "_gcl_au",
        "msclkid",
        "mc_cid",
        "mc_eid",
        "ref",
        "referrer",
        "src",
        "adid",
        "campaignid",
        "creative",
        "dclid",
        "ds_rl",
        "ei",
        "ved",
        "usg",
        "sa"
      ];
      let cleanUrl = url.trim();
      if (cleanUrl.includes("shopsavvy.com/redirect?url=")) {
        try {
          const urlParams = new URLSearchParams(cleanUrl.split("?")[1]);
          const extractedUrl = urlParams.get("url");
          if (extractedUrl) {
            cleanUrl = decodeURIComponent(extractedUrl);
          }
        } catch (error) {}
      }
      const urlObj = new URL(cleanUrl);
      urlObj.hostname = urlObj.hostname.replace(/^www\./, "");
      const searchParams = new URLSearchParams(urlObj.search);
      for (const param of trackingParams) {
        searchParams.delete(param);
      }
      const sortedParams = new URLSearchParams;
      const sortedKeys = Array.from(searchParams.keys()).sort();
      for (const key of sortedKeys) {
        const values = searchParams.getAll(key);
        for (const value of values) {
          sortedParams.append(key, value);
        }
      }
      urlObj.search = sortedParams.toString();
      if (urlObj.pathname.endsWith("/") && urlObj.pathname.length > 1) {
        urlObj.pathname = urlObj.pathname.slice(0, -1);
      }
      urlObj.hash = "";
      const normalizedUrl = urlObj.toString();
      return normalizedUrl.replace(/^https?:\/\//, "");
    } catch (error) {
      return url;
    }
  }
});

// ../shared/.build/verb-url-retailer-identifier-get.js
var require_verb_url_retailer_identifier_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbURLRetailerIdentifierGet = verbURLRetailerIdentifierGet;
  function verbURLRetailerIdentifierGet(urlString, name4) {
    var _a;
    if (!urlString) {
      return;
    }
    let input = urlString;
    if (typeof input !== "string") {
      input = input === null || input === undefined ? undefined : input.toString();
    }
    if (!input) {
      return;
    }
    if (((_a = input === null || input === undefined ? undefined : input.startsWith) === null || _a === undefined ? undefined : _a.call(input, "http")) == false) {
      input = `http://${input}`;
    }
    let hostname;
    try {
      const match = input.match(/^(?:https?:\/\/)?(?:www\.)?([^\/\?#:]+)/i);
      if (match && match[1]) {
        hostname = match[1];
      }
    } catch (e) {}
    if (!hostname && !name4) {
      return;
    }
    if (hostname) {
      if (hostname !== "localhost" && hostname !== "http") {
        const parts = hostname.split(".");
        if (parts.length < 2)
          return;
        const sld = parts[parts.length - 2];
        const subdomain = parts.length > 2 ? parts.slice(0, -2).join(".") : null;
        if (sld !== "google") {
          if (RETAILERS_ON_SUBDOMAINS.find((r) => r === sld)) {
            if (subdomain && subdomain !== "www") {
              return subdomain;
            }
            return sld;
          }
          return sld;
        }
      }
    }
    if (name4) {
      const lowercaseName = name4.toLowerCase();
      const cleanName = lowercaseName.replace(/[^a-z0-9]/g, "");
      for (const key in RETAILER_MISSPELLINGS) {
        for (const misspelling of RETAILER_MISSPELLINGS[key])
          if (cleanName === misspelling.toLowerCase().replace(/[^a-z0-9]/g, "")) {
            return key;
          }
      }
      let hash = lowercaseName;
      hash = hash.replace("&", "and").replace(".com", "").replace(".net", "").replace(".co", "").replace(".net", "").replace(".ca", "").replace(".ch", "").replace(".de", "").replace(".nu", "").replace(".nl", "").replace(".it", "").replace(".fr", "").replace(".fm", "").replace(".eu", "").replace(".es", "").replace(".nu", "").replace(".ne", "").replace(".au", "").replace(".at", "").replace(".br", "").replace(".biz", "").replace(".cz", "").replace(".CZ", "").replace(".us", "").replace(".tv", "").replace(".cc", "").replace(".info", "").replace(".sm", "").replace(".ie", "").replace(".pl", "").replace(".cn", "").replace(".org", "").replace(".Org", "").replace(".co.uk", "").replace(".uk", "").replace("www.", "").replace("ww.", "").replace("http", "").replace("://", "").replace("...", "").replace(", inc.", "").replace(" inc.", "").replace(",inc.", "").replace(" inc.", "").replace("-inc", "").replace("-com", "").replace(" co.", "").replace(" corp.", "").replace("-llc", "").replace(" llc.", "").replace(".llc", "").replace("adapter", "").replace(".amazonwebstore.c", "").replace(".amazonwebstore.", "").replace(".amazonwebstore", "").replace(".amazonwebstor", "").replace(".amazonwebsto", "").replace(".amazonwebst", "").replace(".amazonwebs", "").replace(".amazonweb", "").replace(".amazonwe", "").replace(".amazonw", "").replace(".amazon", "").replace(".amazo", "").replace(".amaz", "").replace(".ama", "").replace(".am", "").replace("�", "");
      hash = hash.replace(/[^A-Za-z0-9]/g, "");
      if (hash !== "") {
        return hash;
      }
    }
    return "unknown";
  }
  var RETAILERS_ON_SUBDOMAINS = [
    "ebay",
    "myshopify",
    "gap",
    "mattel",
    "ricardobeverlyhills"
  ];
  var RETAILER_MISSPELLINGS = {
    academy: ["Academy Sports Outdoor", "Academy Sports"],
    apple: ["Apple Store"],
    burlington: ["Burlington Coat Factory"],
    callawaypreowned: ["Callaway Golf PreOwned"],
    columbia: ["Columbia Sportswear"],
    costco: ["Costco Wholesale"],
    cvs: ["CVS Pharmacy"],
    dsw: ["DSW Designer Shoe Warehouse"],
    eastbay: ["eastbayathleticsportsource"],
    frys: ["Frys Electronics"],
    hammacher: ["Hammacher Schlemmer"],
    heartlandvetsupply: ["heartland veterinary supply"],
    homedepot: ["The Home Depot"],
    lego: ["Lego Store"],
    lowes: ["Lowes Home Improvement"],
    michaels: ["michaels stores"],
    myotcstore: ["myotcstorehealthandbeautyonlineshop"],
    riteaid: ["Rite Aid Pharmacy"],
    sonos: ["sonosaudio"],
    sprouts: ["Sprouts Farmers Market"],
    walgreens: ["Walgreens Pharmacy"],
    walmart: [
      "Walmart Supercenter",
      "Walmart Neighborhood Market",
      "Walmart Express",
      "Walmart 2"
    ]
  };
});

// ../shared/.build/verb-offer-title-from-url-extract.js
var require_verb_offer_title_from_url_extract = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbOfferTitleFromURLExtract = verbOfferTitleFromURLExtract;
  var REDIRECT_HOSTS = [
    "goto.walmart.com",
    "redirect.viglink.com",
    "www.jdoqocy.com",
    "www.tkqlhce.com",
    "www.anrdoezrs.net",
    "www.dpbolvw.net",
    "www.kqzyfj.com",
    "click.linksynergy.com",
    "www.avantlink.com",
    "shareasale.com"
  ];
  var NON_PRODUCT_SEGMENTS = [
    "p",
    "ip",
    "dp",
    "gp",
    "product",
    "item",
    "products",
    "items",
    "shop",
    "buy",
    "store",
    "catalog",
    "category",
    "search",
    "browse",
    "detail",
    "details",
    "view",
    "show"
  ];
  function verbOfferTitleFromURLExtract(url) {
    if (!url)
      return null;
    try {
      let targetURL = url;
      if (REDIRECT_HOSTS.some((host) => url.includes(host))) {
        try {
          const parsedRedirect = new URL(url);
          const params = new URLSearchParams(parsedRedirect.search);
          const innerUrl = params.get("u") || params.get("url") || params.get("murl") || params.get("destination") || params.get("redirect");
          if (innerUrl) {
            targetURL = decodeURIComponent(innerUrl);
          }
        } catch (_a) {}
      }
      const parsed = new URL(targetURL);
      const segments = parsed.pathname.split("/").filter((s) => s.length > 0);
      const slugSegment = segments.filter((s) => {
        if (!/[a-zA-Z]/.test(s))
          return false;
        if (/^\d+$/.test(s))
          return false;
        if (NON_PRODUCT_SEGMENTS.includes(s.toLowerCase()))
          return false;
        if (s.length < 6)
          return false;
        const letterCount = (s.match(/[a-zA-Z]/g) || []).length;
        const digitCount = (s.match(/\d/g) || []).length;
        if (digitCount > letterCount * 2)
          return false;
        return true;
      }).sort((a, b) => b.length - a.length)[0];
      if (!slugSegment)
        return null;
      const title = slugSegment.replace(/[-_]+/g, " ").replace(/\b\w/g, (c) => c.toUpperCase()).replace(/\s+/g, " ").trim();
      if (title.length < 10)
        return null;
      return title;
    } catch (_b) {
      return null;
    }
  }
});

// ../shared/.build/verb-search-preferred-url-get.js
var require_verb_search_preferred_url_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbSearchPreferredURLGet = verbSearchPreferredURLGet;
  var verb_url_is_google_redirect_1 = require_verb_url_is_google_redirect();
  var RETAILER_PRIORITY = [
    "amazon",
    "walmart",
    "target",
    "bestbuy",
    "best buy",
    "costco",
    "newegg",
    "homedepot",
    "home depot",
    "lowes",
    "lowe's",
    "bhphoto",
    "b&h",
    "adorama"
  ];
  function verbSearchPreferredURLGet(product) {
    const allUrls = [];
    if (product.url) {
      allUrls.push({
        url: product.url,
        retailer: (product.retailer_name || "").toLowerCase(),
        source: product.source
      });
    }
    if (product.other_sources) {
      for (const source of product.other_sources) {
        if (source.url) {
          allUrls.push({
            url: source.url,
            retailer: (source.retailer_name || "").toLowerCase(),
            source: source.source
          });
        }
      }
    }
    const directUrls = allUrls.filter((u) => !(0, verb_url_is_google_redirect_1.verbURLIsGoogleRedirect)(u.url));
    if (directUrls.length === 0) {
      return product.url;
    }
    for (const priorityRetailer of RETAILER_PRIORITY) {
      const match = directUrls.find((u) => u.retailer.includes(priorityRetailer) || u.source === priorityRetailer);
      if (match)
        return match.url;
    }
    return directUrls[0].url;
  }
});

// ../shared/.build/verb-uuid-generate.js
var require_verb_uuid_generate = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbUUIDGenerate = undefined;
  var verbUUIDGenerate2 = function() {
    function s4() {
      return Math.floor((1 + Math.random()) * 65536).toString(16).substring(1);
    }
    return s4() + s4() + "-" + s4() + "-" + s4() + "-" + s4() + "-" + s4() + s4() + s4();
  };
  exports.verbUUIDGenerate = verbUUIDGenerate2;
});

// ../shared/.build/verb-watched-product-watching-key-get.js
var require_verb_watched_product_watching_key_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbWatchedProductWatchingKeyGet = verbWatchedProductWatchingKeyGet;
  function verbWatchedProductWatchingKeyGet(watchedProduct) {
    if (!watchedProduct || !watchedProduct.product) {
      throw new Error("Product path is required for generating the watching key");
    }
    let key = "";
    key += `product|${watchedProduct.product}`;
    if (watchedProduct.settings_specific_quality) {
      key += `${watchedProduct.settings_specific_quality}|`;
    }
    if (watchedProduct.settings_specific_drop_percentage) {
      key += `${watchedProduct.settings_specific_drop_percentage}|`;
    }
    if (watchedProduct.settings_specific_drop_amount) {
      key += `${watchedProduct.settings_specific_drop_amount}|`;
    }
    if (watchedProduct.settings_drop_lowest) {
      key += `${watchedProduct.settings_drop_lowest}|`;
    }
    if (watchedProduct.settings_drop_any) {
      key += `${watchedProduct.settings_drop_any}|`;
    }
    if (watchedProduct.settings_in_stock) {
      key += `${watchedProduct.settings_in_stock}|`;
    }
    if (watchedProduct.settings_retailers) {
      key += `${watchedProduct.settings_retailers}|`;
    }
    return key;
  }
});

// ../shared/.build/verb-watched-search-watching-key-get.js
var require_verb_watched_search_watching_key_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbWatchedSearchWatchingKeyGet = verbWatchedSearchWatchingKeyGet;
  function verbWatchedSearchWatchingKeyGet(watchedSearch) {
    var _a, _b, _c, _d, _e;
    if (!watchedSearch) {
      throw new Error("WatchedSearch object is required for generating the watching key");
    }
    if (!((_a = watchedSearch.include) === null || _a === undefined ? undefined : _a.trim())) {
      throw new Error("Search include term is required for generating the watching key");
    }
    let key = "";
    key += `search|`;
    if (((_c = (_b = watchedSearch.include) === null || _b === undefined ? undefined : _b.trim()) === null || _c === undefined ? undefined : _c.length) > 0) {
      key += `${watchedSearch.include}|`;
    }
    if (((_e = (_d = watchedSearch.exclude) === null || _d === undefined ? undefined : _d.trim()) === null || _e === undefined ? undefined : _e.length) > 0) {
      key += `${watchedSearch.exclude}|`;
    }
    if (watchedSearch.quality) {
      key += `${(watchedSearch.quality * 100).toFixed(0)}|`;
    }
    return key;
  }
});

// ../shared/.build/verb-image-url-get.js
var require_verb_image_url_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbImageUrlGet = verbImageUrlGet;
  exports.verbDealImageUrlExtract = verbDealImageUrlExtract;
  function verbImageUrlGet(imageUrl, options) {
    if (!imageUrl) {
      return "";
    }
    if (imageUrl.startsWith("https://") || imageUrl.startsWith("http://")) {
      return imageUrl;
    }
    const params = options ? `?w=${options.width}&h=${options.height}&f=fit` : "";
    return `https://x.shopsavvy.com/${imageUrl}${params}`;
  }
  function verbDealImageUrlExtract(dealImage) {
    if (!dealImage)
      return;
    if (typeof dealImage === "string") {
      try {
        const parsed = JSON.parse(dealImage);
        return parsed === null || parsed === undefined ? undefined : parsed.url;
      } catch (_a) {
        return dealImage;
      }
    }
    if (typeof dealImage === "object" && dealImage.url) {
      return dealImage.url;
    }
    return;
  }
});

// ../shared/.build/verb-prime-day-is-active.js
var require_verb_prime_day_is_active = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbPrimeDayIsActive = verbPrimeDayIsActive;
  function verbPrimeDayIsActive() {
    const now = new Date;
    const currentYear = now.getFullYear();
    const currentMonth = now.getMonth();
    const currentDate = now.getDate();
    if (currentYear === 2025 && currentMonth === 6) {
      return currentDate >= 8 && currentDate <= 11;
    }
    return false;
  }
});

// ../shared/.build/verb-prime-day-link-get.js
var require_verb_prime_day_link_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbPrimeDayLinkGet = verbPrimeDayLinkGet;
  function verbPrimeDayLinkGet(platform) {
    const baseUrl = "https://www.amazon.com/primeday";
    const trackingParams = {
      ios: "ssi.nul-1-20",
      android: "ssa.nul-1-20",
      web: "ssd.nul-1-20"
    };
    const param = trackingParams[platform];
    return `${baseUrl}?tag=${param}`;
  }
});

// ../shared/.build/verb-prime-day-test-mode-toggle.js
var require_verb_prime_day_test_mode_toggle = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbPrimeDayTestModeEnable = verbPrimeDayTestModeEnable;
  exports.verbPrimeDayTestModeDisable = verbPrimeDayTestModeDisable;
  exports.verbPrimeDayTestModeStatus = verbPrimeDayTestModeStatus;
  function verbPrimeDayTestModeEnable() {
    if (typeof window !== "undefined") {
      localStorage.setItem("primeDayTestMode", "true");
      console.log("\uD83C\uDF89 Prime Day test mode ENABLED - refresh the page to see changes");
    }
  }
  function verbPrimeDayTestModeDisable() {
    if (typeof window !== "undefined") {
      localStorage.removeItem("primeDayTestMode");
      console.log("Prime Day test mode DISABLED - refresh the page to see changes");
    }
  }
  function verbPrimeDayTestModeStatus() {
    if (typeof window !== "undefined") {
      return localStorage.getItem("primeDayTestMode") === "true";
    }
    return false;
  }
});

// ../shared/.build/verb-prime-day-end-date-get.js
var require_verb_prime_day_end_date_get = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbPrimeDayEndDateGet = verbPrimeDayEndDateGet;
  function verbPrimeDayEndDateGet() {
    return "Friday at midnight";
  }
});

// ../shared/.build/verb-enhanced-search-fuzzy-match.js
var require_verb_enhanced_search_fuzzy_match = __commonJS((exports) => {
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.findBestEnhancedSearchMatch = findBestEnhancedSearchMatch;
  exports.filterProductLinesByQuery = filterProductLinesByQuery;
  exports.normalizeSearchString = normalizeSearchString;
  exports.calculateSimilarity = calculateSimilarity;
  exports.containsAllWords = containsAllWords;
  function normalizeSearchString(str) {
    return str.toLowerCase().trim().replace(/[^\w\s]/g, "").replace(/\s+/g, " ");
  }
  function containsAllWords(query, keyword) {
    const queryWords = normalizeSearchString(query).split(" ");
    const keywordWords = normalizeSearchString(keyword).split(" ");
    return keywordWords.every((keywordWord) => queryWords.some((queryWord) => queryWord.includes(keywordWord)));
  }
  var COMMON_ABBREVIATIONS = new Map([
    ["ps5", ["playstation"]],
    ["ps4", ["playstation"]],
    ["ps3", ["playstation"]],
    ["xbox", ["xbox"]],
    ["tv", ["television"]],
    ["pc", ["computer"]],
    ["mac", ["macbook", "imac"]],
    ["ipad", ["ipad"]],
    ["iphone", ["iphone"]]
  ]);
  function matchesAbbreviation(query, keyword) {
    const normalQuery = normalizeSearchString(query);
    const normalKeyword = normalizeSearchString(keyword);
    if (COMMON_ABBREVIATIONS.has(normalQuery)) {
      const expansion = COMMON_ABBREVIATIONS.get(normalQuery);
      return expansion.some((term) => normalKeyword.includes(term));
    }
    if (COMMON_ABBREVIATIONS.has(normalKeyword)) {
      const expansion = COMMON_ABBREVIATIONS.get(normalKeyword);
      return expansion.some((term) => term.length >= 3 && normalQuery.includes(term));
    }
    return false;
  }
  function calculateSimilarity(query, keyword) {
    const normalQuery = normalizeSearchString(query);
    const normalKeyword = normalizeSearchString(keyword);
    if (normalQuery === normalKeyword)
      return 1;
    const queryWords = normalQuery.split(" ");
    const keywordWords = normalKeyword.split(" ");
    const wordCoverageRatio = keywordWords.length / queryWords.length;
    if (normalQuery.includes(normalKeyword)) {
      if (wordCoverageRatio >= 0.75) {
        return 0.9;
      } else if (wordCoverageRatio >= 0.5) {
        return 0.9 * wordCoverageRatio + 0.4;
      } else {
        return 0.9 * wordCoverageRatio + 0.2;
      }
    }
    if (normalKeyword.includes(normalQuery))
      return 0.8;
    if (containsAllWords(normalQuery, normalKeyword)) {
      if (wordCoverageRatio >= 0.5) {
        return 0.7;
      } else {
        return 0.7 * wordCoverageRatio + 0.3;
      }
    }
    if (matchesAbbreviation(query, keyword))
      return 0.65;
    const matchingWords = queryWords.filter((qw) => {
      if (qw.length <= 2)
        return false;
      return keywordWords.some((kw) => {
        if (kw.length <= 2)
          return false;
        if (kw.includes(qw) && qw.length >= 3)
          return true;
        if (qw.includes(kw) && kw.length >= 3)
          return true;
        return false;
      });
    });
    if (matchingWords.length > 0) {
      const matchRatio = matchingWords.length / queryWords.length;
      if (matchRatio < 0.5) {
        return 0.2 + matchRatio * 0.3;
      }
      return 0.3 + matchingWords.length / Math.max(queryWords.length, keywordWords.length) * 0.4;
    }
    return 0;
  }
  function findBestEnhancedSearchMatch(query, enhancedResults) {
    let bestMatch = null;
    let bestScore = 0;
    let bestKeyword = "";
    for (const enhancedResult of enhancedResults) {
      const primaryScore = calculateSimilarity(query, enhancedResult.keyword);
      if (primaryScore > bestScore) {
        bestScore = primaryScore;
        bestMatch = enhancedResult.data;
        bestKeyword = enhancedResult.keyword;
      }
      for (const keyword of enhancedResult.keywords) {
        const score = calculateSimilarity(query, keyword);
        if (score > bestScore) {
          bestScore = score;
          bestMatch = enhancedResult.data;
          bestKeyword = keyword;
        }
      }
    }
    if (bestScore >= 0.6) {
      return { result: bestMatch, score: bestScore, matchedKeyword: bestKeyword };
    }
    return null;
  }
  function filterProductLinesByQuery(productLines, query) {
    const filteredLines = [];
    for (const line of productLines) {
      if (!line.keywords) {
        filteredLines.push(line);
        continue;
      }
      const bestScore = Math.max(...line.keywords.map((keyword) => calculateSimilarity(query, keyword)));
      if (bestScore >= 0.6) {
        filteredLines.push(Object.assign(Object.assign({}, line), {
          matchScore: bestScore
        }));
      }
    }
    return filteredLines.sort((a, b) => (b.matchScore || 0) - (a.matchScore || 0));
  }
});

// ../shared/.build/verb-amazon-api-rate-limiter.js
var require_verb_amazon_api_rate_limiter = __commonJS((exports) => {
  var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
    function adopt(value) {
      return value instanceof P ? value : new P(function(resolve) {
        resolve(value);
      });
    }
    return new (P || (P = Promise))(function(resolve, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }
      function step(result) {
        result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  exports.verbAmazonApiRateLimitWait = verbAmazonApiRateLimitWait;
  exports.verbAmazonApiRateLimitTimeUntilNext = verbAmazonApiRateLimitTimeUntilNext;
  var lastAmazonApiCall = 0;
  function verbAmazonApiRateLimitWait() {
    return __awaiter(this, undefined, undefined, function* () {
      const now = Date.now();
      const timeSinceLastCall = now - lastAmazonApiCall;
      const minInterval = 1000;
      if (timeSinceLastCall < minInterval) {
        const waitTime = minInterval - timeSinceLastCall;
        console.log(`⏱️ Amazon API rate limit: waiting ${waitTime}ms...`);
        yield new Promise((resolve) => setTimeout(resolve, waitTime));
      }
      lastAmazonApiCall = Date.now();
    });
  }
  function verbAmazonApiRateLimitTimeUntilNext() {
    const now = Date.now();
    const timeSinceLastCall = now - lastAmazonApiCall;
    const minInterval = 1000;
    return Math.max(0, minInterval - timeSinceLastCall);
  }
});

// ../shared/.build/index-72f7278d0035e72b3f590dcb594529c4-544c8ad1d62a03099a8d7ec2c4340acd.js
var require__ = __commonJS((exports) => {
  var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() {
        return m[k];
      } };
    }
    Object.defineProperty(o, k2, desc);
  } : function(o, m, k, k2) {
    if (k2 === undefined)
      k2 = k;
    o[k2] = m[k];
  });
  var __exportStar = exports && exports.__exportStar || function(m, exports2) {
    for (var p in m)
      if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports2, p))
        __createBinding(exports2, m, p);
  };
  Object.defineProperty(exports, "__esModule", { value: true });
  __exportStar(require_noun_affiliate_commission_summary(), exports);
  __exportStar(require_noun_agentic_search_types(), exports);
  __exportStar(require_noun_annotation(), exports);
  __exportStar(require_noun_article_preview(), exports);
  __exportStar(require_noun_availability(), exports);
  __exportStar(require_noun_barcode_kind(), exports);
  __exportStar(require_noun_medal_stand_analysis(), exports);
  __exportStar(require_noun_chart_options(), exports);
  __exportStar(require_noun_condition(), exports);
  __exportStar(require_noun_credit_card_affiliate_links(), exports);
  __exportStar(require_noun_coordinates(), exports);
  __exportStar(require_noun_expedition_kind(), exports);
  __exportStar(require_noun_expedition_report(), exports);
  __exportStar(require_noun_expedition_request(), exports);
  __exportStar(require_noun_expedition(), exports);
  __exportStar(require_noun_enhanced_search_results(), exports);
  __exportStar(require_noun_enterprise_search_subscription(), exports);
  __exportStar(require_noun_extension_content_injection_point(), exports);
  __exportStar(require_noun_extension_observation_point(), exports);
  __exportStar(require_noun_feature(), exports);
  __exportStar(require_noun_feed_item_read_options(), exports);
  __exportStar(require_noun_feed_item(), exports);
  __exportStar(require_noun_google_shopping_price_history(), exports);
  __exportStar(require_noun_grade(), exports);
  __exportStar(require_noun_jsonish(), exports);
  __exportStar(require_noun_miner(), exports);
  __exportStar(require_noun_mineral(), exports);
  __exportStar(require_noun_nil(), exports);
  __exportStar(require_noun_ore_items(), exports);
  __exportStar(require_noun_ore_request(), exports);
  __exportStar(require_noun_ore(), exports);
  __exportStar(require_noun_platform_type(), exports);
  __exportStar(require_noun_product_read_input(), exports);
  __exportStar(require_noun_prospector_config(), exports);
  __exportStar(require_noun_prospector_expedition_results(), exports);
  __exportStar(require_noun_prospector_filters_prices(), exports);
  __exportStar(require_noun_prospector_public(), exports);
  __exportStar(require_noun_prospector_redirect_config(), exports);
  __exportStar(require_noun_prospector_user_settings(), exports);
  __exportStar(require_noun_refinery_offer(), exports);
  __exportStar(require_noun_scout(), exports);
  __exportStar(require_noun_search_source(), exports);
  __exportStar(require_noun_siftable(), exports);
  __exportStar(require_noun_sifter_function_context(), exports);
  __exportStar(require_noun_sifter_function(), exports);
  __exportStar(require_noun_sifter(), exports);
  __exportStar(require_noun_sql_alert(), exports);
  __exportStar(require_noun_sql_article(), exports);
  __exportStar(require_noun_sql_auth(), exports);
  __exportStar(require_noun_sql_blog_post(), exports);
  __exportStar(require_noun_sql_background_session(), exports);
  __exportStar(require_noun_sql_click(), exports);
  __exportStar(require_noun_sql_conversation_message(), exports);
  __exportStar(require_noun_sql_conversation(), exports);
  __exportStar(require_noun_sql_coupon_code(), exports);
  __exportStar(require_noun_sql_credit_card_reward(), exports);
  __exportStar(require_noun_sql_credentials(), exports);
  __exportStar(require_noun_sql_deal(), exports);
  __exportStar(require_noun_sql_device(), exports);
  __exportStar(require_noun_sql_expedition_record(), exports);
  __exportStar(require_noun_sql_folder(), exports);
  __exportStar(require_noun_sql_keyword_search(), exports);
  __exportStar(require_noun_sql_offer_archive(), exports);
  __exportStar(require_noun_sql_offer_change(), exports);
  __exportStar(require_noun_sql_offer_stats(), exports);
  __exportStar(require_noun_sql_offer_track(), exports);
  __exportStar(require_noun_sql_offer_tracks_computed(), exports);
  __exportStar(require_noun_sql_offer(), exports);
  __exportStar(require_noun_sql_post_external(), exports);
  __exportStar(require_noun_sql_product_association(), exports);
  __exportStar(require_noun_sql_product_identifiers(), exports);
  __exportStar(require_noun_sql_product_refresh_metadata(), exports);
  __exportStar(require_noun_sql_product_review_phrase(), exports);
  __exportStar(require_noun_sql_product(), exports);
  __exportStar(require_noun_sql_purchase(), exports);
  __exportStar(require_noun_sql_queued(), exports);
  __exportStar(require_noun_sql_retailer(), exports);
  __exportStar(require_noun_sql_review(), exports);
  __exportStar(require_noun_ucp_checkout(), exports);
  __exportStar(require_noun_sql_tag(), exports);
  __exportStar(require_noun_sql_tagged(), exports);
  __exportStar(require_noun_sql_user(), exports);
  __exportStar(require_noun_sql_user_feedback(), exports);
  __exportStar(require_noun_sql_watched_product(), exports);
  __exportStar(require_noun_new_low_validation(), exports);
  __exportStar(require_noun_business_chart_config(), exports);
  __exportStar(require_noun_business_import_job(), exports);
  __exportStar(require_noun_business_product(), exports);
  __exportStar(require_noun_sql_web_push_subscription(), exports);
  __exportStar(require_noun_task_product_refresh(), exports);
  __exportStar(require_noun_task_refill_background_refresh_queue(), exports);
  __exportStar(require_noun_venue(), exports);
  __exportStar(require_noun_verb_remote(), exports);
  __exportStar(require_verb_array_shuffle(), exports);
  __exportStar(require_verb_browser_get(), exports);
  __exportStar(require_verb_color_generate_procedurally_from_string(), exports);
  __exportStar(require_verb_config_key_value_get(), exports);
  __exportStar(require_verb_currency_code_sanitize(), exports);
  __exportStar(require_verb_date_formatted_relative_time_get(), exports);
  __exportStar(require_verb_dates_number_of_days_between_get(), exports);
  __exportStar(require_verb_grade_style_get(), exports);
  __exportStar(require_verb_locale_get_normalized(), exports);
  __exportStar(require_verb_localized_text_get(), exports);
  __exportStar(require_verb_path_user_is_staff(), exports);
  __exportStar(require_verb_platform_is_kind(), exports);
  __exportStar(require_verb_retailer_identifier_is_include_in_config_array(), exports);
  __exportStar(require_verb_retailer_identifier_is_popular(), exports);
  __exportStar(require_verb_retailer_identifier_is_verified(), exports);
  __exportStar(require_verb_retailer_slug_get(), exports);
  __exportStar(require_verb_score_computed_get(), exports);
  __exportStar(require_verb_url_cleaned_get(), exports);
  __exportStar(require_verb_url_is_google_redirect(), exports);
  __exportStar(require_verb_url_normalize_for_matching(), exports);
  __exportStar(require_verb_url_retailer_identifier_get(), exports);
  __exportStar(require_verb_offer_title_from_url_extract(), exports);
  __exportStar(require_verb_search_preferred_url_get(), exports);
  __exportStar(require_verb_uuid_generate(), exports);
  __exportStar(require_verb_watched_product_watching_key_get(), exports);
  __exportStar(require_verb_watched_search_watching_key_get(), exports);
  __exportStar(require_verb_image_url_get(), exports);
  __exportStar(require_verb_prime_day_is_active(), exports);
  __exportStar(require_verb_prime_day_link_get(), exports);
  __exportStar(require_verb_prime_day_test_mode_toggle(), exports);
  __exportStar(require_verb_prime_day_end_date_get(), exports);
  __exportStar(require_verb_enhanced_search_fuzzy_match(), exports);
  __exportStar(require_verb_amazon_api_rate_limiter(), exports);
});

// src/verb-environment-megazord-get.ts
function verbEnvironmentMegazordGet() {
  if (false) {}
  const jsonString = '{"megazord":"production","prospector":"browser"}';
  let json;
  try {
    json = JSON.parse(jsonString);
  } catch (e) {
    return null;
  }
  return json;
}

// src/prospector/verb-prospector-config-locale-get.ts
function verbProspectorConfigLocaleGet() {
  return nounProspectorGlobal.config?.locale?.toLowerCase() ?? "en-us";
}
function verbProspectorConfigLocaleCountryCodeGet() {
  return nounProspectorGlobal.config?.locale?.split("-")?.[1]?.toLowerCase() ?? "us";
}
function verbProspectorConfigLocaleLanguageCodeGet() {
  return nounProspectorGlobal.config?.locale?.split("-")?.[0]?.toLowerCase() ?? "en";
}
var init_verb_prospector_config_locale_get = __esm(() => {
  init_noun_prospector();
});

// src/prospector/verb-prospector-config-version-get.ts
function verbProspectorConfigVersionAppGet() {
  return nounProspectorGlobal?.config?.versionApp;
}
function verbProspectorConfigVersionBuildGet() {
  return nounProspectorGlobal?.config?.versionBuild;
}
var init_verb_prospector_config_version_get = __esm(() => {
  init_noun_prospector();
});

// src/verb-remote.ts
var exports_verb_remote = {};
__export(exports_verb_remote, {
  verbRemote: () => verbRemote
});
async function verbRemote({ auth: auth2, identifierVerb, parameters = {}, optionsRequest = {} }) {
  if (identifierVerb === "prospector-expedition-queue-get") {}
  const isRemoteLog = identifierVerb === "remote-log" || identifierVerb === "log";
  const isBunEnvironment2 = verbEnvironmentMegazordGet()?.prospector === "bun";
  if (!hasLoggedEnvironment) {
    hasLoggedEnvironment = true;
  }
  if (isBunEnvironment2 && !auth2 && globalThis.nounProspectorGlobal?.firebase?.auth) {
    auth2 = globalThis.nounProspectorGlobal.firebase.auth;
  }
  const hasExternalToken = !!parameters?._token;
  if (!isRemoteLog && !isBunEnvironment2 && !hasExternalToken) {
    if (!auth2) {
      const apps = getApps();
      if (apps.length === 0) {
        const maxWaitTime = 1e4;
        const checkInterval = 100;
        let waitedTime = 0;
        await new Promise((resolve, reject) => {
          const waitInterval = setInterval(() => {
            waitedTime += checkInterval;
            const currentApps = getApps();
            if (currentApps.length > 0) {
              clearInterval(waitInterval);
              resolve();
            } else if (waitedTime >= maxWaitTime) {
              clearInterval(waitInterval);
              reject(new Error(`Firebase failed to initialize after ${maxWaitTime}ms. Setup message may not have been received from native app.`));
            }
          }, checkInterval);
        });
      }
      auth2 = getAuth(getApps()?.[0]);
    }
    if (!auth2) {
      throw new Error("native.auth missing");
    }
    if (!auth2?.currentUser) {
      throw new Error("native.auth.currentUser missing");
    }
  }
  return new Promise(async (resolve, reject) => {
    try {
      let optionsRequestInternal = {};
      let finalParameters = { ...parameters };
      if (!finalParameters._locale) {
        try {
          const locale = verbProspectorConfigLocaleGet();
          finalParameters._locale = import_shared.verbLocaleGetNormalized(locale);
        } catch (e) {
          if (typeof navigator !== "undefined" && navigator.language) {
            finalParameters._locale = import_shared.verbLocaleGetNormalized(navigator.language);
          } else {
            finalParameters._locale = import_shared.verbLocaleGetNormalized("en-us");
          }
        }
      }
      if (!finalParameters._app_version) {
        try {
          const versionApp = verbProspectorConfigVersionAppGet();
          if (versionApp) {
            finalParameters._app_version = versionApp;
          }
        } catch (e) {}
      }
      if (!finalParameters._build_version) {
        try {
          const versionBuild = verbProspectorConfigVersionBuildGet();
          if (versionBuild) {
            finalParameters._build_version = versionBuild;
          }
        } catch (e) {}
      }
      if (isBunEnvironment2 && globalThis._bunUserInfo) {
        finalParameters._user = globalThis._bunUserInfo;
      }
      if (finalParameters && Object.keys(finalParameters).length > 0) {
        optionsRequestInternal.headers = { "Content-Type": "application/json" };
        optionsRequestInternal.body = JSON.stringify(finalParameters);
      }
      const headers = {
        ...optionsRequest.headers,
        ...optionsRequestInternal.headers
      };
      if (!isRemoteLog) {
        if (finalParameters?._token) {
          headers["Authorization"] = `Bearer ${finalParameters._token}`;
          delete finalParameters._token;
          if (parameters?._token)
            delete parameters._token;
        } else if (isBunEnvironment2) {
          if (globalThis._bunAuthToken) {
            headers["Authorization"] = `Bearer ${globalThis._bunAuthToken}`;
          } else if (auth2?.currentUser) {
            try {
              const idToken = await auth2.currentUser.getIdToken();
              headers["Authorization"] = `Bearer ${idToken}`(globalThis)._bunAuthToken = idToken;
            } catch (tokenError) {
              console.error(`Error getting auth token in bun environment: ${tokenError.message}`);
              console.warn("In bun environment: continuing without token");
            }
          } else if (globalThis.nounProspectorGlobal?.firebase?.auth?.currentUser) {
            try {
              const idToken = await globalThis.nounProspectorGlobal.firebase.auth.currentUser.getIdToken();
              headers["Authorization"] = `Bearer ${idToken}`(globalThis)._bunAuthToken = idToken;
            } catch (tokenError) {
              console.error(`Error getting token from global context: ${tokenError.message}`);
              console.warn("Continuing without token");
            }
          } else {}
        } else if (auth2?.currentUser) {
          try {
            const idToken = await auth2.currentUser.getIdToken();
            headers["Authorization"] = `Bearer ${idToken}`;
          } catch (tokenError) {
            console.error(`Error getting auth token: ${tokenError.message}`);
            throw tokenError;
          }
        }
      }
      const options = {
        method: "POST",
        ...optionsRequest,
        ...optionsRequestInternal,
        headers
      };
      if (identifierVerb === "prospector-offer-validate-individual") {
        options.priority = "high";
        options.keepalive = false;
        options.cache = "no-cache";
      }
      let url;
      if (host.startsWith("http://") || host.startsWith("https://")) {
        url = `${host}/api/v1/verbs/${identifierVerb}`;
      } else {
        const protocol = host.includes(".") && !host.match(/^\d+\.\d+\.\d+\.\d+/) ? "https" : "http";
        url = `${protocol}://${host}/api/v1/verbs/${identifierVerb}`;
      }
      let response;
      const fetchStartMs = Date.now();
      console.log(`[verbRemote] START ${identifierVerb}`);
      try {
        response = await fetch(url, options);
        const fetchElapsedMs = Date.now() - fetchStartMs;
        console.log(`[verbRemote] DONE ${identifierVerb} ${response.status} ${fetchElapsedMs}ms`);
      } catch (error) {
        if (identifierVerb === "prospector-expedition-queue-get") {
          console.error(`[DEBUG] verbRemote fetch error for expedition queue:`, {
            name: error.name,
            code: error.code,
            message: error.message,
            url
          });
        } else {
          console.error("verbRemote fetch error", {
            name: error.name,
            code: error.code,
            message: error.message,
            url
          });
        }
        const enhancedError = new Error(`verbRemote fetch error: ${error.message || "Unknown network error"}`);
        enhancedError.code = error.code || "network_error";
        enhancedError.originalError = error;
        enhancedError.stack = error.stack;
        reject(enhancedError);
      }
      if (!response) {
        console.error("verbRemote response missing", { url, verb: identifierVerb });
        reject(new Error("verbRemote fetch response missing"));
      }
      if (!response?.ok) {
        if ((response.status === 401 || response.status === 403) && !isRemoteLog && !parameters?._retryAttempted) {
          try {
            if (isBunEnvironment2) {
              globalThis._bunAuthToken = null;
            }
            let freshToken = null;
            if (auth2?.currentUser) {
              freshToken = await auth2.currentUser.getIdToken(true);
              if (isBunEnvironment2) {
                globalThis._bunAuthToken = freshToken;
              }
            } else if (globalThis.nounProspectorGlobal?.firebase?.auth?.currentUser) {
              freshToken = await globalThis.nounProspectorGlobal.firebase.auth.currentUser.getIdToken(true);
              if (isBunEnvironment2) {
                globalThis._bunAuthToken = freshToken;
              }
            }
            if (freshToken) {
              const retryParameters = { ...parameters, _retryAttempted: true };
              const retryResult = await verbRemote({ auth: auth2, identifierVerb, parameters: retryParameters, optionsRequest });
              resolve(retryResult);
              return;
            } else {}
          } catch (refreshError) {
            console.error(`Token refresh failed after ${response.status} error:`, refreshError.message);
          }
        }
        let errorDetails = null;
        let errorBodyText = "";
        try {
          const responseClone = response.clone();
          try {
            errorDetails = await responseClone.json();
          } catch (jsonError) {
            try {
              errorBodyText = await response.text();
            } catch (textError) {}
          }
        } catch (cloneError) {
          try {
            errorDetails = await response.json();
          } catch (jsonError) {}
        }
        if (identifierVerb === "prospector-expedition-queue-get") {
          console.error(`[DEBUG] Expedition queue HTTP error response:`, {
            status: response.status,
            statusText: response.statusText,
            url,
            errorDetails,
            errorBodyText: errorBodyText?.substring(0, 300)
          });
        } else {
          console.error("verbRemote HTTP error", {
            status: response.status,
            statusText: response.statusText,
            url,
            verb: identifierVerb
          });
        }
        const errorMessage = errorDetails?.error || errorDetails?.message || `HTTP error! status: ${response.status} ${response.statusText}`;
        const httpError = new Error(errorMessage);
        httpError.status = response.status;
        httpError.statusText = response.statusText;
        httpError.responseBody = errorDetails;
        reject(httpError);
      }
      const data = await response.json();
      resolve(data);
    } catch (error) {
      console.log("verbRemote error", error);
      reject(error);
    }
  });
}
var import_shared, hostProduction = "refinery.shopsavvy.com", hostLocal = "192.168.4.23:3002", isBunEnvironment, useLocalForTesting, host, hasLoggedEnvironment = false;
var init_verb_remote = __esm(() => {
  init_index_esm();
  init_index_esm2();
  import_shared = __toESM(require__(), 1);
  init_verb_prospector_config_locale_get();
  init_verb_prospector_config_version_get();
  isBunEnvironment = verbEnvironmentMegazordGet()?.prospector === "bun";
  useLocalForTesting = globalThis._useLocalRefineryServer === true || typeof process !== "undefined" && process.argv?.includes("--local");
  host = useLocalForTesting ? hostLocal : isBunEnvironment || verbEnvironmentMegazordGet().megazord === "production" ? hostProduction : hostLocal;
});

// src/prospector/verb-log.ts
async function verbLog({ category, where, identifier, things = [], remote }) {
  if (remote) {
    await verbRemote({
      auth: getAuth(getApps()[0]),
      identifierVerb: "log",
      parameters: {
        level: "info",
        message: `${category} [${where}] ${identifier ?? ""}`,
        thingsJSON: JSON.stringify({ json: JSON.stringify(things) })
      }
    });
  }
}
function verbLogValidation(stage, {
  expeditionId,
  offerIdentifier,
  retailer,
  source,
  durationMs,
  result,
  error
}) {
  const timestamp = new Date().toISOString();
  if (stage === "starting") {} else if (stage === "completed") {
    const duration = durationMs ? ` in ${durationMs}ms` : "";
    const status = result ? "VALID" : "INVALID";
  } else if (stage === "failed") {
    const duration = durationMs ? ` after ${durationMs}ms` : "";
  }
}
var init_verb_log = __esm(() => {
  init_index_esm();
  init_index_esm2();
  init_verb_remote();
});

// src/prospector/noun-mailbox.ts
var nounGlobalMailboxStorage;
var init_noun_mailbox = __esm(() => {
  nounGlobalMailboxStorage = {};
});

// src/prospector/verb-window-get.ts
function verbWindowGet() {
  if (typeof window !== "undefined") {
    return window;
  }
  return null;
}

// src/prospector/verb-expedition-get-barcode.ts
function verbExpeditionGetBarcode(expedition) {
  return expedition?.request?.barcode ?? expedition?.discoveredBarcode;
}

// ../config/strings/src/text-almost-done.json
var require_text_almost_done = __commonJS((exports, module) => {
  module.exports = {
    "en-*": "Almost Done",
    "ar-*": "اكتمل تقريباً",
    "de-*": "Fast fertig",
    "el-*": "Σχεδόν έτοιμο",
    "es-*": "Casi listo",
    "fa-*": "تقریباً تمام",
    "fr-*": "Presque terminé",
    "hi-*": "लगभग पूरा हुआ",
    "hu-*": "Majdnem kész",
    "in-*": "Hampir Selesai",
    "is-*": "Næstum búið",
    "it-*": "Quasi fatto",
    "iw-*": "כמעט סיימנו",
    "ja-*": "もう少しで完了",
    "ko-*": "거의 완료됨",
    "ms-*": "Hampir Siap",
    "my-*": "လုနီးပါးပြီးပါပြီ",
    "nl-*": "Bijna klaar",
    "pl-*": "Prawie gotowe",
    "pt-*": "Quase pronto",
    "ru-*": "Почти готово",
    "sv-*": "Nästan klar",
    "tr-*": "Neredeyse Bitti",
    "uk-*": "Майже готово",
    "vi-*": "Gần xong",
    "zh-*": "即将完成",
    "zh-Hans-*": "即将完成",
    "zh-Hant-*": "即將完成",
    "zh-TW": "即將完成",
    "ca-*": "Gairebé fet",
    "cs-*": "Téměř hotovo",
    "da-*": "Næsten færdig",
    "fi-*": "Melkein valmis",
    "he-*": "כמעט הושלם",
    "hr-*": "Skoro gotovo",
    "id-*": "Hampir Selesai",
    "no-*": "Nesten ferdig",
    "ro-*": "Aproape gata",
    "sk-*": "Takmer hotovo",
    "th-*": "ใกล้จะเสร็จแล้ว"
  };
});

// src/prospector/noun-retailer-cache.ts
var nounRetailersCacheRawGlobal, nounRetailersCacheGlobal;
var init_noun_retailer_cache = __esm(() => {
  nounRetailersCacheRawGlobal = [];
  nounRetailersCacheGlobal = {};
});

// src/prospector/verb-refinery-offer-identifier-get.ts
var exports_verb_refinery_offer_identifier_get = {};
__export(exports_verb_refinery_offer_identifier_get, {
  verbRefineryOfferIdentifierGet: () => verbRefineryOfferIdentifierGet
});
function normalizeRetailerNameForIdentifier(retailerName) {
  if (!retailerName || typeof retailerName !== "string")
    return;
  let normalized = retailerName.toLowerCase().trim();
  const domainSuffixes = [".com", ".net", ".org", ".co", ".store", ".shop", ".us", ".ca", ".co.uk"];
  for (const suffix of domainSuffixes) {
    if (normalized.endsWith(suffix)) {
      normalized = normalized.substring(0, normalized.length - suffix.length);
      break;
    }
  }
  if (normalized.startsWith("www.")) {
    normalized = normalized.substring(4);
  }
  normalized = normalized.replace(/\s+/g, "");
  return normalized;
}
function verbRefineryOfferIdentifierGet(offer) {
  let identifier = "";
  let retailerName = offer.retailer_name;
  if (!retailerName && offer.URL) {
    try {
      const urlString = offer.URL;
      const match = urlString.match(/^(?:https?:\/\/)?(?:www\.)?([^\/\?#]+)/i);
      if (match && match[1]) {
        retailerName = match[1];
      }
    } catch (e) {}
  }
  const normalizedRetailerName = normalizeRetailerNameForIdentifier(retailerName);
  if (retailerName && typeof retailerName === "string" && retailerName.toLowerCase().includes("nfm")) {}
  if (normalizedRetailerName) {
    identifier += normalizedRetailerName;
  }
  if (offer.venue) {
    identifier += offer.venue;
  }
  if (offer.price_currency) {
    identifier += offer.price_currency;
  }
  if (offer.address) {
    identifier += offer.address;
  }
  if (offer.condition) {
    identifier += offer.condition;
  }
  identifier += offer.is_marketplace === true ? "true" : "false";
  if (offer.marketplace_seller) {
    identifier += offer.marketplace_seller;
  }
  return identifier;
}

// node:punycode
var exports_punycode = {};
__export(exports_punycode, {
  default: () => export_default
});
var __create2, __getProtoOf2, __defProp2, __getOwnPropNames2, __hasOwnProp2, __reExport = (target, mod, secondTarget) => {
  for (let key of __getOwnPropNames2(mod))
    if (!__hasOwnProp2.call(target, key) && key !== "default")
      __defProp2(target, key, { get: () => mod[key], enumerable: true });
  if (secondTarget) {
    for (let key of __getOwnPropNames2(mod))
      if (!__hasOwnProp2.call(secondTarget, key) && key !== "default")
        __defProp2(secondTarget, key, { get: () => mod[key], enumerable: true });
    return secondTarget;
  }
}, __toESM2 = (mod, isNodeMode, target) => {
  target = mod != null ? __create2(__getProtoOf2(mod)) : {};
  let to = isNodeMode || !mod || !mod.__esModule ? __defProp2(target, "default", { value: mod, enumerable: true }) : target;
  for (let key of __getOwnPropNames2(mod))
    if (!__hasOwnProp2.call(to, key))
      __defProp2(to, key, { get: () => mod[key], enumerable: true });
  return to;
}, __commonJS2 = (cb, mod) => () => (mod || cb((mod = { exports: {} }).exports, mod), mod.exports), __export2 = (target, all) => {
  for (var name4 in all)
    __defProp2(target, name4, { get: all[name4], enumerable: true, configurable: true, set: (newValue) => all[name4] = () => newValue });
}, require_punycode, exports_punycode2, import_punycode, export_default;
var init_punycode = __esm(() => {
  __create2 = Object.create;
  ({ getPrototypeOf: __getProtoOf2, defineProperty: __defProp2, getOwnPropertyNames: __getOwnPropNames2 } = Object);
  __hasOwnProp2 = Object.prototype.hasOwnProperty;
  require_punycode = __commonJS2((exports, module) => {
    var regexPunycode = /^xn--/, regexNonASCII = /[^\0-\x7F]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = { overflow: "Overflow: input needs wider integers to process", "not-basic": "Illegal input >= 0x80 (not a basic code point)", "invalid-input": "Invalid input" }, floor = Math.floor, stringFromCharCode = String.fromCharCode;
    function error(type) {
      throw new RangeError(errors[type]);
    }
    function map(array, callback) {
      let result = [], length = array.length;
      while (length--)
        result[length] = callback(array[length]);
      return result;
    }
    function mapDomain(domain, callback) {
      let parts = domain.split("@"), result = "";
      if (parts.length > 1)
        result = parts[0] + "@", domain = parts[1];
      domain = domain.replace(regexSeparators, ".");
      let labels = domain.split("."), encoded = map(labels, callback).join(".");
      return result + encoded;
    }
    function ucs2decode(string) {
      let output = [], counter = 0, length = string.length;
      while (counter < length) {
        let value = string.charCodeAt(counter++);
        if (value >= 55296 && value <= 56319 && counter < length) {
          let extra = string.charCodeAt(counter++);
          if ((extra & 64512) == 56320)
            output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
          else
            output.push(value), counter--;
        } else
          output.push(value);
      }
      return output;
    }
    var ucs2encode = (codePoints) => String.fromCodePoint(...codePoints), basicToDigit = function(codePoint) {
      if (codePoint >= 48 && codePoint < 58)
        return 26 + (codePoint - 48);
      if (codePoint >= 65 && codePoint < 91)
        return codePoint - 65;
      if (codePoint >= 97 && codePoint < 123)
        return codePoint - 97;
      return 36;
    }, digitToBasic = function(digit, flag) {
      return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
    }, adapt = function(delta, numPoints, firstTime) {
      let k = 0;
      delta = firstTime ? floor(delta / 700) : delta >> 1, delta += floor(delta / numPoints);
      for (;delta > 455; k += 36)
        delta = floor(delta / 35);
      return floor(k + 36 * delta / (delta + 38));
    }, decode = function(input) {
      let output = [], inputLength = input.length, i = 0, n = 128, bias = 72, basic = input.lastIndexOf("-");
      if (basic < 0)
        basic = 0;
      for (let j = 0;j < basic; ++j) {
        if (input.charCodeAt(j) >= 128)
          error("not-basic");
        output.push(input.charCodeAt(j));
      }
      for (let index = basic > 0 ? basic + 1 : 0;index < inputLength; ) {
        let oldi = i;
        for (let w = 1, k = 36;; k += 36) {
          if (index >= inputLength)
            error("invalid-input");
          let digit = basicToDigit(input.charCodeAt(index++));
          if (digit >= 36)
            error("invalid-input");
          if (digit > floor((2147483647 - i) / w))
            error("overflow");
          i += digit * w;
          let t = k <= bias ? 1 : k >= bias + 26 ? 26 : k - bias;
          if (digit < t)
            break;
          let baseMinusT = 36 - t;
          if (w > floor(2147483647 / baseMinusT))
            error("overflow");
          w *= baseMinusT;
        }
        let out = output.length + 1;
        if (bias = adapt(i - oldi, out, oldi == 0), floor(i / out) > 2147483647 - n)
          error("overflow");
        n += floor(i / out), i %= out, output.splice(i++, 0, n);
      }
      return String.fromCodePoint(...output);
    }, encode = function(input) {
      let output = [];
      input = ucs2decode(input);
      let inputLength = input.length, n = 128, delta = 0, bias = 72;
      for (let currentValue of input)
        if (currentValue < 128)
          output.push(stringFromCharCode(currentValue));
      let basicLength = output.length, handledCPCount = basicLength;
      if (basicLength)
        output.push("-");
      while (handledCPCount < inputLength) {
        let m = 2147483647;
        for (let currentValue of input)
          if (currentValue >= n && currentValue < m)
            m = currentValue;
        let handledCPCountPlusOne = handledCPCount + 1;
        if (m - n > floor((2147483647 - delta) / handledCPCountPlusOne))
          error("overflow");
        delta += (m - n) * handledCPCountPlusOne, n = m;
        for (let currentValue of input) {
          if (currentValue < n && ++delta > 2147483647)
            error("overflow");
          if (currentValue === n) {
            let q = delta;
            for (let k = 36;; k += 36) {
              let t = k <= bias ? 1 : k >= bias + 26 ? 26 : k - bias;
              if (q < t)
                break;
              let qMinusT = q - t, baseMinusT = 36 - t;
              output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))), q = floor(qMinusT / baseMinusT);
            }
            output.push(stringFromCharCode(digitToBasic(q, 0))), bias = adapt(delta, handledCPCountPlusOne, handledCPCount === basicLength), delta = 0, ++handledCPCount;
          }
        }
        ++delta, ++n;
      }
      return output.join("");
    }, toUnicode = function(input) {
      return mapDomain(input, function(string) {
        return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
      });
    }, toASCII = function(input) {
      return mapDomain(input, function(string) {
        return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
      });
    }, punycode = { version: "2.3.1", ucs2: { decode: ucs2decode, encode: ucs2encode }, decode, encode, toASCII, toUnicode };
    module.exports = punycode;
  });
  exports_punycode2 = {};
  __export2(exports_punycode2, { default: () => import_punycode.default });
  __reExport(exports_punycode2, __toESM2(require_punycode(), 1));
  import_punycode = __toESM2(require_punycode(), 1);
  export_default = import_punycode.default;
});

// ../node_modules/psl/data/rules.json
var require_rules = __commonJS((exports, module) => {
  module.exports = [
    "ac",
    "com.ac",
    "edu.ac",
    "gov.ac",
    "net.ac",
    "mil.ac",
    "org.ac",
    "ad",
    "nom.ad",
    "ae",
    "co.ae",
    "net.ae",
    "org.ae",
    "sch.ae",
    "ac.ae",
    "gov.ae",
    "mil.ae",
    "aero",
    "accident-investigation.aero",
    "accident-prevention.aero",
    "aerobatic.aero",
    "aeroclub.aero",
    "aerodrome.aero",
    "agents.aero",
    "aircraft.aero",
    "airline.aero",
    "airport.aero",
    "air-surveillance.aero",
    "airtraffic.aero",
    "air-traffic-control.aero",
    "ambulance.aero",
    "amusement.aero",
    "association.aero",
    "author.aero",
    "ballooning.aero",
    "broker.aero",
    "caa.aero",
    "cargo.aero",
    "catering.aero",
    "certification.aero",
    "championship.aero",
    "charter.aero",
    "civilaviation.aero",
    "club.aero",
    "conference.aero",
    "consultant.aero",
    "consulting.aero",
    "control.aero",
    "council.aero",
    "crew.aero",
    "design.aero",
    "dgca.aero",
    "educator.aero",
    "emergency.aero",
    "engine.aero",
    "engineer.aero",
    "entertainment.aero",
    "equipment.aero",
    "exchange.aero",
    "express.aero",
    "federation.aero",
    "flight.aero",
    "fuel.aero",
    "gliding.aero",
    "government.aero",
    "groundhandling.aero",
    "group.aero",
    "hanggliding.aero",
    "homebuilt.aero",
    "insurance.aero",
    "journal.aero",
    "journalist.aero",
    "leasing.aero",
    "logistics.aero",
    "magazine.aero",
    "maintenance.aero",
    "media.aero",
    "microlight.aero",
    "modelling.aero",
    "navigation.aero",
    "parachuting.aero",
    "paragliding.aero",
    "passenger-association.aero",
    "pilot.aero",
    "press.aero",
    "production.aero",
    "recreation.aero",
    "repbody.aero",
    "res.aero",
    "research.aero",
    "rotorcraft.aero",
    "safety.aero",
    "scientist.aero",
    "services.aero",
    "show.aero",
    "skydiving.aero",
    "software.aero",
    "student.aero",
    "trader.aero",
    "trading.aero",
    "trainer.aero",
    "union.aero",
    "workinggroup.aero",
    "works.aero",
    "af",
    "gov.af",
    "com.af",
    "org.af",
    "net.af",
    "edu.af",
    "ag",
    "com.ag",
    "org.ag",
    "net.ag",
    "co.ag",
    "nom.ag",
    "ai",
    "off.ai",
    "com.ai",
    "net.ai",
    "org.ai",
    "al",
    "com.al",
    "edu.al",
    "gov.al",
    "mil.al",
    "net.al",
    "org.al",
    "am",
    "co.am",
    "com.am",
    "commune.am",
    "net.am",
    "org.am",
    "ao",
    "ed.ao",
    "gv.ao",
    "og.ao",
    "co.ao",
    "pb.ao",
    "it.ao",
    "aq",
    "ar",
    "bet.ar",
    "com.ar",
    "coop.ar",
    "edu.ar",
    "gob.ar",
    "gov.ar",
    "int.ar",
    "mil.ar",
    "musica.ar",
    "mutual.ar",
    "net.ar",
    "org.ar",
    "senasa.ar",
    "tur.ar",
    "arpa",
    "e164.arpa",
    "in-addr.arpa",
    "ip6.arpa",
    "iris.arpa",
    "uri.arpa",
    "urn.arpa",
    "as",
    "gov.as",
    "asia",
    "at",
    "ac.at",
    "co.at",
    "gv.at",
    "or.at",
    "sth.ac.at",
    "au",
    "com.au",
    "net.au",
    "org.au",
    "edu.au",
    "gov.au",
    "asn.au",
    "id.au",
    "info.au",
    "conf.au",
    "oz.au",
    "act.au",
    "nsw.au",
    "nt.au",
    "qld.au",
    "sa.au",
    "tas.au",
    "vic.au",
    "wa.au",
    "act.edu.au",
    "catholic.edu.au",
    "nsw.edu.au",
    "nt.edu.au",
    "qld.edu.au",
    "sa.edu.au",
    "tas.edu.au",
    "vic.edu.au",
    "wa.edu.au",
    "qld.gov.au",
    "sa.gov.au",
    "tas.gov.au",
    "vic.gov.au",
    "wa.gov.au",
    "schools.nsw.edu.au",
    "aw",
    "com.aw",
    "ax",
    "az",
    "com.az",
    "net.az",
    "int.az",
    "gov.az",
    "org.az",
    "edu.az",
    "info.az",
    "pp.az",
    "mil.az",
    "name.az",
    "pro.az",
    "biz.az",
    "ba",
    "com.ba",
    "edu.ba",
    "gov.ba",
    "mil.ba",
    "net.ba",
    "org.ba",
    "bb",
    "biz.bb",
    "co.bb",
    "com.bb",
    "edu.bb",
    "gov.bb",
    "info.bb",
    "net.bb",
    "org.bb",
    "store.bb",
    "tv.bb",
    "*.bd",
    "be",
    "ac.be",
    "bf",
    "gov.bf",
    "bg",
    "a.bg",
    "b.bg",
    "c.bg",
    "d.bg",
    "e.bg",
    "f.bg",
    "g.bg",
    "h.bg",
    "i.bg",
    "j.bg",
    "k.bg",
    "l.bg",
    "m.bg",
    "n.bg",
    "o.bg",
    "p.bg",
    "q.bg",
    "r.bg",
    "s.bg",
    "t.bg",
    "u.bg",
    "v.bg",
    "w.bg",
    "x.bg",
    "y.bg",
    "z.bg",
    "0.bg",
    "1.bg",
    "2.bg",
    "3.bg",
    "4.bg",
    "5.bg",
    "6.bg",
    "7.bg",
    "8.bg",
    "9.bg",
    "bh",
    "com.bh",
    "edu.bh",
    "net.bh",
    "org.bh",
    "gov.bh",
    "bi",
    "co.bi",
    "com.bi",
    "edu.bi",
    "or.bi",
    "org.bi",
    "biz",
    "bj",
    "asso.bj",
    "barreau.bj",
    "gouv.bj",
    "bm",
    "com.bm",
    "edu.bm",
    "gov.bm",
    "net.bm",
    "org.bm",
    "bn",
    "com.bn",
    "edu.bn",
    "gov.bn",
    "net.bn",
    "org.bn",
    "bo",
    "com.bo",
    "edu.bo",
    "gob.bo",
    "int.bo",
    "org.bo",
    "net.bo",
    "mil.bo",
    "tv.bo",
    "web.bo",
    "academia.bo",
    "agro.bo",
    "arte.bo",
    "blog.bo",
    "bolivia.bo",
    "ciencia.bo",
    "cooperativa.bo",
    "democracia.bo",
    "deporte.bo",
    "ecologia.bo",
    "economia.bo",
    "empresa.bo",
    "indigena.bo",
    "industria.bo",
    "info.bo",
    "medicina.bo",
    "movimiento.bo",
    "musica.bo",
    "natural.bo",
    "nombre.bo",
    "noticias.bo",
    "patria.bo",
    "politica.bo",
    "profesional.bo",
    "plurinacional.bo",
    "pueblo.bo",
    "revista.bo",
    "salud.bo",
    "tecnologia.bo",
    "tksat.bo",
    "transporte.bo",
    "wiki.bo",
    "br",
    "9guacu.br",
    "abc.br",
    "adm.br",
    "adv.br",
    "agr.br",
    "aju.br",
    "am.br",
    "anani.br",
    "aparecida.br",
    "app.br",
    "arq.br",
    "art.br",
    "ato.br",
    "b.br",
    "barueri.br",
    "belem.br",
    "bhz.br",
    "bib.br",
    "bio.br",
    "blog.br",
    "bmd.br",
    "boavista.br",
    "bsb.br",
    "campinagrande.br",
    "campinas.br",
    "caxias.br",
    "cim.br",
    "cng.br",
    "cnt.br",
    "com.br",
    "contagem.br",
    "coop.br",
    "coz.br",
    "cri.br",
    "cuiaba.br",
    "curitiba.br",
    "def.br",
    "des.br",
    "det.br",
    "dev.br",
    "ecn.br",
    "eco.br",
    "edu.br",
    "emp.br",
    "enf.br",
    "eng.br",
    "esp.br",
    "etc.br",
    "eti.br",
    "far.br",
    "feira.br",
    "flog.br",
    "floripa.br",
    "fm.br",
    "fnd.br",
    "fortal.br",
    "fot.br",
    "foz.br",
    "fst.br",
    "g12.br",
    "geo.br",
    "ggf.br",
    "goiania.br",
    "gov.br",
    "ac.gov.br",
    "al.gov.br",
    "am.gov.br",
    "ap.gov.br",
    "ba.gov.br",
    "ce.gov.br",
    "df.gov.br",
    "es.gov.br",
    "go.gov.br",
    "ma.gov.br",
    "mg.gov.br",
    "ms.gov.br",
    "mt.gov.br",
    "pa.gov.br",
    "pb.gov.br",
    "pe.gov.br",
    "pi.gov.br",
    "pr.gov.br",
    "rj.gov.br",
    "rn.gov.br",
    "ro.gov.br",
    "rr.gov.br",
    "rs.gov.br",
    "sc.gov.br",
    "se.gov.br",
    "sp.gov.br",
    "to.gov.br",
    "gru.br",
    "imb.br",
    "ind.br",
    "inf.br",
    "jab.br",
    "jampa.br",
    "jdf.br",
    "joinville.br",
    "jor.br",
    "jus.br",
    "leg.br",
    "lel.br",
    "log.br",
    "londrina.br",
    "macapa.br",
    "maceio.br",
    "manaus.br",
    "maringa.br",
    "mat.br",
    "med.br",
    "mil.br",
    "morena.br",
    "mp.br",
    "mus.br",
    "natal.br",
    "net.br",
    "niteroi.br",
    "*.nom.br",
    "not.br",
    "ntr.br",
    "odo.br",
    "ong.br",
    "org.br",
    "osasco.br",
    "palmas.br",
    "poa.br",
    "ppg.br",
    "pro.br",
    "psc.br",
    "psi.br",
    "pvh.br",
    "qsl.br",
    "radio.br",
    "rec.br",
    "recife.br",
    "rep.br",
    "ribeirao.br",
    "rio.br",
    "riobranco.br",
    "riopreto.br",
    "salvador.br",
    "sampa.br",
    "santamaria.br",
    "santoandre.br",
    "saobernardo.br",
    "saogonca.br",
    "seg.br",
    "sjc.br",
    "slg.br",
    "slz.br",
    "sorocaba.br",
    "srv.br",
    "taxi.br",
    "tc.br",
    "tec.br",
    "teo.br",
    "the.br",
    "tmp.br",
    "trd.br",
    "tur.br",
    "tv.br",
    "udi.br",
    "vet.br",
    "vix.br",
    "vlog.br",
    "wiki.br",
    "zlg.br",
    "bs",
    "com.bs",
    "net.bs",
    "org.bs",
    "edu.bs",
    "gov.bs",
    "bt",
    "com.bt",
    "edu.bt",
    "gov.bt",
    "net.bt",
    "org.bt",
    "bv",
    "bw",
    "co.bw",
    "org.bw",
    "by",
    "gov.by",
    "mil.by",
    "com.by",
    "of.by",
    "bz",
    "com.bz",
    "net.bz",
    "org.bz",
    "edu.bz",
    "gov.bz",
    "ca",
    "ab.ca",
    "bc.ca",
    "mb.ca",
    "nb.ca",
    "nf.ca",
    "nl.ca",
    "ns.ca",
    "nt.ca",
    "nu.ca",
    "on.ca",
    "pe.ca",
    "qc.ca",
    "sk.ca",
    "yk.ca",
    "gc.ca",
    "cat",
    "cc",
    "cd",
    "gov.cd",
    "cf",
    "cg",
    "ch",
    "ci",
    "org.ci",
    "or.ci",
    "com.ci",
    "co.ci",
    "edu.ci",
    "ed.ci",
    "ac.ci",
    "net.ci",
    "go.ci",
    "asso.ci",
    "aéroport.ci",
    "int.ci",
    "presse.ci",
    "md.ci",
    "gouv.ci",
    "*.ck",
    "!www.ck",
    "cl",
    "co.cl",
    "gob.cl",
    "gov.cl",
    "mil.cl",
    "cm",
    "co.cm",
    "com.cm",
    "gov.cm",
    "net.cm",
    "cn",
    "ac.cn",
    "com.cn",
    "edu.cn",
    "gov.cn",
    "net.cn",
    "org.cn",
    "mil.cn",
    "公司.cn",
    "网络.cn",
    "網絡.cn",
    "ah.cn",
    "bj.cn",
    "cq.cn",
    "fj.cn",
    "gd.cn",
    "gs.cn",
    "gz.cn",
    "gx.cn",
    "ha.cn",
    "hb.cn",
    "he.cn",
    "hi.cn",
    "hl.cn",
    "hn.cn",
    "jl.cn",
    "js.cn",
    "jx.cn",
    "ln.cn",
    "nm.cn",
    "nx.cn",
    "qh.cn",
    "sc.cn",
    "sd.cn",
    "sh.cn",
    "sn.cn",
    "sx.cn",
    "tj.cn",
    "xj.cn",
    "xz.cn",
    "yn.cn",
    "zj.cn",
    "hk.cn",
    "mo.cn",
    "tw.cn",
    "co",
    "arts.co",
    "com.co",
    "edu.co",
    "firm.co",
    "gov.co",
    "info.co",
    "int.co",
    "mil.co",
    "net.co",
    "nom.co",
    "org.co",
    "rec.co",
    "web.co",
    "com",
    "coop",
    "cr",
    "ac.cr",
    "co.cr",
    "ed.cr",
    "fi.cr",
    "go.cr",
    "or.cr",
    "sa.cr",
    "cu",
    "com.cu",
    "edu.cu",
    "org.cu",
    "net.cu",
    "gov.cu",
    "inf.cu",
    "cv",
    "com.cv",
    "edu.cv",
    "int.cv",
    "nome.cv",
    "org.cv",
    "cw",
    "com.cw",
    "edu.cw",
    "net.cw",
    "org.cw",
    "cx",
    "gov.cx",
    "cy",
    "ac.cy",
    "biz.cy",
    "com.cy",
    "ekloges.cy",
    "gov.cy",
    "ltd.cy",
    "mil.cy",
    "net.cy",
    "org.cy",
    "press.cy",
    "pro.cy",
    "tm.cy",
    "cz",
    "de",
    "dj",
    "dk",
    "dm",
    "com.dm",
    "net.dm",
    "org.dm",
    "edu.dm",
    "gov.dm",
    "do",
    "art.do",
    "com.do",
    "edu.do",
    "gob.do",
    "gov.do",
    "mil.do",
    "net.do",
    "org.do",
    "sld.do",
    "web.do",
    "dz",
    "art.dz",
    "asso.dz",
    "com.dz",
    "edu.dz",
    "gov.dz",
    "org.dz",
    "net.dz",
    "pol.dz",
    "soc.dz",
    "tm.dz",
    "ec",
    "com.ec",
    "info.ec",
    "net.ec",
    "fin.ec",
    "k12.ec",
    "med.ec",
    "pro.ec",
    "org.ec",
    "edu.ec",
    "gov.ec",
    "gob.ec",
    "mil.ec",
    "edu",
    "ee",
    "edu.ee",
    "gov.ee",
    "riik.ee",
    "lib.ee",
    "med.ee",
    "com.ee",
    "pri.ee",
    "aip.ee",
    "org.ee",
    "fie.ee",
    "eg",
    "com.eg",
    "edu.eg",
    "eun.eg",
    "gov.eg",
    "mil.eg",
    "name.eg",
    "net.eg",
    "org.eg",
    "sci.eg",
    "*.er",
    "es",
    "com.es",
    "nom.es",
    "org.es",
    "gob.es",
    "edu.es",
    "et",
    "com.et",
    "gov.et",
    "org.et",
    "edu.et",
    "biz.et",
    "name.et",
    "info.et",
    "net.et",
    "eu",
    "fi",
    "aland.fi",
    "fj",
    "ac.fj",
    "biz.fj",
    "com.fj",
    "gov.fj",
    "info.fj",
    "mil.fj",
    "name.fj",
    "net.fj",
    "org.fj",
    "pro.fj",
    "*.fk",
    "com.fm",
    "edu.fm",
    "net.fm",
    "org.fm",
    "fm",
    "fo",
    "fr",
    "asso.fr",
    "com.fr",
    "gouv.fr",
    "nom.fr",
    "prd.fr",
    "tm.fr",
    "aeroport.fr",
    "avocat.fr",
    "avoues.fr",
    "cci.fr",
    "chambagri.fr",
    "chirurgiens-dentistes.fr",
    "experts-comptables.fr",
    "geometre-expert.fr",
    "greta.fr",
    "huissier-justice.fr",
    "medecin.fr",
    "notaires.fr",
    "pharmacien.fr",
    "port.fr",
    "veterinaire.fr",
    "ga",
    "gb",
    "edu.gd",
    "gov.gd",
    "gd",
    "ge",
    "com.ge",
    "edu.ge",
    "gov.ge",
    "org.ge",
    "mil.ge",
    "net.ge",
    "pvt.ge",
    "gf",
    "gg",
    "co.gg",
    "net.gg",
    "org.gg",
    "gh",
    "com.gh",
    "edu.gh",
    "gov.gh",
    "org.gh",
    "mil.gh",
    "gi",
    "com.gi",
    "ltd.gi",
    "gov.gi",
    "mod.gi",
    "edu.gi",
    "org.gi",
    "gl",
    "co.gl",
    "com.gl",
    "edu.gl",
    "net.gl",
    "org.gl",
    "gm",
    "gn",
    "ac.gn",
    "com.gn",
    "edu.gn",
    "gov.gn",
    "org.gn",
    "net.gn",
    "gov",
    "gp",
    "com.gp",
    "net.gp",
    "mobi.gp",
    "edu.gp",
    "org.gp",
    "asso.gp",
    "gq",
    "gr",
    "com.gr",
    "edu.gr",
    "net.gr",
    "org.gr",
    "gov.gr",
    "gs",
    "gt",
    "com.gt",
    "edu.gt",
    "gob.gt",
    "ind.gt",
    "mil.gt",
    "net.gt",
    "org.gt",
    "gu",
    "com.gu",
    "edu.gu",
    "gov.gu",
    "guam.gu",
    "info.gu",
    "net.gu",
    "org.gu",
    "web.gu",
    "gw",
    "gy",
    "co.gy",
    "com.gy",
    "edu.gy",
    "gov.gy",
    "net.gy",
    "org.gy",
    "hk",
    "com.hk",
    "edu.hk",
    "gov.hk",
    "idv.hk",
    "net.hk",
    "org.hk",
    "公司.hk",
    "教育.hk",
    "敎育.hk",
    "政府.hk",
    "個人.hk",
    "个��.hk",
    "箇人.hk",
    "網络.hk",
    "网络.hk",
    "组織.hk",
    "網絡.hk",
    "网絡.hk",
    "组织.hk",
    "組織.hk",
    "組织.hk",
    "hm",
    "hn",
    "com.hn",
    "edu.hn",
    "org.hn",
    "net.hn",
    "mil.hn",
    "gob.hn",
    "hr",
    "iz.hr",
    "from.hr",
    "name.hr",
    "com.hr",
    "ht",
    "com.ht",
    "shop.ht",
    "firm.ht",
    "info.ht",
    "adult.ht",
    "net.ht",
    "pro.ht",
    "org.ht",
    "med.ht",
    "art.ht",
    "coop.ht",
    "pol.ht",
    "asso.ht",
    "edu.ht",
    "rel.ht",
    "gouv.ht",
    "perso.ht",
    "hu",
    "co.hu",
    "info.hu",
    "org.hu",
    "priv.hu",
    "sport.hu",
    "tm.hu",
    "2000.hu",
    "agrar.hu",
    "bolt.hu",
    "casino.hu",
    "city.hu",
    "erotica.hu",
    "erotika.hu",
    "film.hu",
    "forum.hu",
    "games.hu",
    "hotel.hu",
    "ingatlan.hu",
    "jogasz.hu",
    "konyvelo.hu",
    "lakas.hu",
    "media.hu",
    "news.hu",
    "reklam.hu",
    "sex.hu",
    "shop.hu",
    "suli.hu",
    "szex.hu",
    "tozsde.hu",
    "utazas.hu",
    "video.hu",
    "id",
    "ac.id",
    "biz.id",
    "co.id",
    "desa.id",
    "go.id",
    "mil.id",
    "my.id",
    "net.id",
    "or.id",
    "ponpes.id",
    "sch.id",
    "web.id",
    "ie",
    "gov.ie",
    "il",
    "ac.il",
    "co.il",
    "gov.il",
    "idf.il",
    "k12.il",
    "muni.il",
    "net.il",
    "org.il",
    "im",
    "ac.im",
    "co.im",
    "com.im",
    "ltd.co.im",
    "net.im",
    "org.im",
    "plc.co.im",
    "tt.im",
    "tv.im",
    "in",
    "co.in",
    "firm.in",
    "net.in",
    "org.in",
    "gen.in",
    "ind.in",
    "nic.in",
    "ac.in",
    "edu.in",
    "res.in",
    "gov.in",
    "mil.in",
    "info",
    "int",
    "eu.int",
    "io",
    "com.io",
    "iq",
    "gov.iq",
    "edu.iq",
    "mil.iq",
    "com.iq",
    "org.iq",
    "net.iq",
    "ir",
    "ac.ir",
    "co.ir",
    "gov.ir",
    "id.ir",
    "net.ir",
    "org.ir",
    "sch.ir",
    "ایران.ir",
    "ايران.ir",
    "is",
    "net.is",
    "com.is",
    "edu.is",
    "gov.is",
    "org.is",
    "int.is",
    "it",
    "gov.it",
    "edu.it",
    "abr.it",
    "abruzzo.it",
    "aosta-valley.it",
    "aostavalley.it",
    "bas.it",
    "basilicata.it",
    "cal.it",
    "calabria.it",
    "cam.it",
    "campania.it",
    "emilia-romagna.it",
    "emiliaromagna.it",
    "emr.it",
    "friuli-v-giulia.it",
    "friuli-ve-giulia.it",
    "friuli-vegiulia.it",
    "friuli-venezia-giulia.it",
    "friuli-veneziagiulia.it",
    "friuli-vgiulia.it",
    "friuliv-giulia.it",
    "friulive-giulia.it",
    "friulivegiulia.it",
    "friulivenezia-giulia.it",
    "friuliveneziagiulia.it",
    "friulivgiulia.it",
    "fvg.it",
    "laz.it",
    "lazio.it",
    "lig.it",
    "liguria.it",
    "lom.it",
    "lombardia.it",
    "lombardy.it",
    "lucania.it",
    "mar.it",
    "marche.it",
    "mol.it",
    "molise.it",
    "piedmont.it",
    "piemonte.it",
    "pmn.it",
    "pug.it",
    "puglia.it",
    "sar.it",
    "sardegna.it",
    "sardinia.it",
    "sic.it",
    "sicilia.it",
    "sicily.it",
    "taa.it",
    "tos.it",
    "toscana.it",
    "trentin-sud-tirol.it",
    "trentin-süd-tirol.it",
    "trentin-sudtirol.it",
    "trentin-südtirol.it",
    "trentin-sued-tirol.it",
    "trentin-suedtirol.it",
    "trentino-a-adige.it",
    "trentino-aadige.it",
    "trentino-alto-adige.it",
    "trentino-altoadige.it",
    "trentino-s-tirol.it",
    "trentino-stirol.it",
    "trentino-sud-tirol.it",
    "trentino-süd-tirol.it",
    "trentino-sudtirol.it",
    "trentino-südtirol.it",
    "trentino-sued-tirol.it",
    "trentino-suedtirol.it",
    "trentino.it",
    "trentinoa-adige.it",
    "trentinoaadige.it",
    "trentinoalto-adige.it",
    "trentinoaltoadige.it",
    "trentinos-tirol.it",
    "trentinostirol.it",
    "trentinosud-tirol.it",
    "trentinosüd-tirol.it",
    "trentinosudtirol.it",
    "trentinosüdtirol.it",
    "trentinosued-tirol.it",
    "trentinosuedtirol.it",
    "trentinsud-tirol.it",
    "trentinsüd-tirol.it",
    "trentinsudtirol.it",
    "trentinsüdtirol.it",
    "trentinsued-tirol.it",
    "trentinsuedtirol.it",
    "tuscany.it",
    "umb.it",
    "umbria.it",
    "val-d-aosta.it",
    "val-daosta.it",
    "vald-aosta.it",
    "valdaosta.it",
    "valle-aosta.it",
    "valle-d-aosta.it",
    "valle-daosta.it",
    "valleaosta.it",
    "valled-aosta.it",
    "valledaosta.it",
    "vallee-aoste.it",
    "vallée-aoste.it",
    "vallee-d-aoste.it",
    "vallée-d-aoste.it",
    "valleeaoste.it",
    "valléeaoste.it",
    "valleedaoste.it",
    "valléedaoste.it",
    "vao.it",
    "vda.it",
    "ven.it",
    "veneto.it",
    "ag.it",
    "agrigento.it",
    "al.it",
    "alessandria.it",
    "alto-adige.it",
    "altoadige.it",
    "an.it",
    "ancona.it",
    "andria-barletta-trani.it",
    "andria-trani-barletta.it",
    "andriabarlettatrani.it",
    "andriatranibarletta.it",
    "ao.it",
    "aosta.it",
    "aoste.it",
    "ap.it",
    "aq.it",
    "aquila.it",
    "ar.it",
    "arezzo.it",
    "ascoli-piceno.it",
    "ascolipiceno.it",
    "asti.it",
    "at.it",
    "av.it",
    "avellino.it",
    "ba.it",
    "balsan-sudtirol.it",
    "balsan-südtirol.it",
    "balsan-suedtirol.it",
    "balsan.it",
    "bari.it",
    "barletta-trani-andria.it",
    "barlettatraniandria.it",
    "belluno.it",
    "benevento.it",
    "bergamo.it",
    "bg.it",
    "bi.it",
    "biella.it",
    "bl.it",
    "bn.it",
    "bo.it",
    "bologna.it",
    "bolzano-altoadige.it",
    "bolzano.it",
    "bozen-sudtirol.it",
    "bozen-südtirol.it",
    "bozen-suedtirol.it",
    "bozen.it",
    "br.it",
    "brescia.it",
    "brindisi.it",
    "bs.it",
    "bt.it",
    "bulsan-sudtirol.it",
    "bulsan-südtirol.it",
    "bulsan-suedtirol.it",
    "bulsan.it",
    "bz.it",
    "ca.it",
    "cagliari.it",
    "caltanissetta.it",
    "campidano-medio.it",
    "campidanomedio.it",
    "campobasso.it",
    "carbonia-iglesias.it",
    "carboniaiglesias.it",
    "carrara-massa.it",
    "carraramassa.it",
    "caserta.it",
    "catania.it",
    "catanzaro.it",
    "cb.it",
    "ce.it",
    "cesena-forli.it",
    "cesena-forlì.it",
    "cesenaforli.it",
    "cesenaforlì.it",
    "ch.it",
    "chieti.it",
    "ci.it",
    "cl.it",
    "cn.it",
    "co.it",
    "como.it",
    "cosenza.it",
    "cr.it",
    "cremona.it",
    "crotone.it",
    "cs.it",
    "ct.it",
    "cuneo.it",
    "cz.it",
    "dell-ogliastra.it",
    "dellogliastra.it",
    "en.it",
    "enna.it",
    "fc.it",
    "fe.it",
    "fermo.it",
    "ferrara.it",
    "fg.it",
    "fi.it",
    "firenze.it",
    "florence.it",
    "fm.it",
    "foggia.it",
    "forli-cesena.it",
    "forlì-cesena.it",
    "forlicesena.it",
    "forlìcesena.it",
    "fr.it",
    "frosinone.it",
    "ge.it",
    "genoa.it",
    "genova.it",
    "go.it",
    "gorizia.it",
    "gr.it",
    "grosseto.it",
    "iglesias-carbonia.it",
    "iglesiascarbonia.it",
    "im.it",
    "imperia.it",
    "is.it",
    "isernia.it",
    "kr.it",
    "la-spezia.it",
    "laquila.it",
    "laspezia.it",
    "latina.it",
    "lc.it",
    "le.it",
    "lecce.it",
    "lecco.it",
    "li.it",
    "livorno.it",
    "lo.it",
    "lodi.it",
    "lt.it",
    "lu.it",
    "lucca.it",
    "macerata.it",
    "mantova.it",
    "massa-carrara.it",
    "massacarrara.it",
    "matera.it",
    "mb.it",
    "mc.it",
    "me.it",
    "medio-campidano.it",
    "mediocampidano.it",
    "messina.it",
    "mi.it",
    "milan.it",
    "milano.it",
    "mn.it",
    "mo.it",
    "modena.it",
    "monza-brianza.it",
    "monza-e-della-brianza.it",
    "monza.it",
    "monzabrianza.it",
    "monzaebrianza.it",
    "monzaedellabrianza.it",
    "ms.it",
    "mt.it",
    "na.it",
    "naples.it",
    "napoli.it",
    "no.it",
    "novara.it",
    "nu.it",
    "nuoro.it",
    "og.it",
    "ogliastra.it",
    "olbia-tempio.it",
    "olbiatempio.it",
    "or.it",
    "oristano.it",
    "ot.it",
    "pa.it",
    "padova.it",
    "padua.it",
    "palermo.it",
    "parma.it",
    "pavia.it",
    "pc.it",
    "pd.it",
    "pe.it",
    "perugia.it",
    "pesaro-urbino.it",
    "pesarourbino.it",
    "pescara.it",
    "pg.it",
    "pi.it",
    "piacenza.it",
    "pisa.it",
    "pistoia.it",
    "pn.it",
    "po.it",
    "pordenone.it",
    "potenza.it",
    "pr.it",
    "prato.it",
    "pt.it",
    "pu.it",
    "pv.it",
    "pz.it",
    "ra.it",
    "ragusa.it",
    "ravenna.it",
    "rc.it",
    "re.it",
    "reggio-calabria.it",
    "reggio-emilia.it",
    "reggiocalabria.it",
    "reggioemilia.it",
    "rg.it",
    "ri.it",
    "rieti.it",
    "rimini.it",
    "rm.it",
    "rn.it",
    "ro.it",
    "roma.it",
    "rome.it",
    "rovigo.it",
    "sa.it",
    "salerno.it",
    "sassari.it",
    "savona.it",
    "si.it",
    "siena.it",
    "siracusa.it",
    "so.it",
    "sondrio.it",
    "sp.it",
    "sr.it",
    "ss.it",
    "suedtirol.it",
    "südtirol.it",
    "sv.it",
    "ta.it",
    "taranto.it",
    "te.it",
    "tempio-olbia.it",
    "tempioolbia.it",
    "teramo.it",
    "terni.it",
    "tn.it",
    "to.it",
    "torino.it",
    "tp.it",
    "tr.it",
    "trani-andria-barletta.it",
    "trani-barletta-andria.it",
    "traniandriabarletta.it",
    "tranibarlettaandria.it",
    "trapani.it",
    "trento.it",
    "treviso.it",
    "trieste.it",
    "ts.it",
    "turin.it",
    "tv.it",
    "ud.it",
    "udine.it",
    "urbino-pesaro.it",
    "urbinopesaro.it",
    "va.it",
    "varese.it",
    "vb.it",
    "vc.it",
    "ve.it",
    "venezia.it",
    "venice.it",
    "verbania.it",
    "vercelli.it",
    "verona.it",
    "vi.it",
    "vibo-valentia.it",
    "vibovalentia.it",
    "vicenza.it",
    "viterbo.it",
    "vr.it",
    "vs.it",
    "vt.it",
    "vv.it",
    "je",
    "co.je",
    "net.je",
    "org.je",
    "*.jm",
    "jo",
    "com.jo",
    "org.jo",
    "net.jo",
    "edu.jo",
    "sch.jo",
    "gov.jo",
    "mil.jo",
    "name.jo",
    "jobs",
    "jp",
    "ac.jp",
    "ad.jp",
    "co.jp",
    "ed.jp",
    "go.jp",
    "gr.jp",
    "lg.jp",
    "ne.jp",
    "or.jp",
    "aichi.jp",
    "akita.jp",
    "aomori.jp",
    "chiba.jp",
    "ehime.jp",
    "fukui.jp",
    "fukuoka.jp",
    "fukushima.jp",
    "gifu.jp",
    "gunma.jp",
    "hiroshima.jp",
    "hokkaido.jp",
    "hyogo.jp",
    "ibaraki.jp",
    "ishikawa.jp",
    "iwate.jp",
    "kagawa.jp",
    "kagoshima.jp",
    "kanagawa.jp",
    "kochi.jp",
    "kumamoto.jp",
    "kyoto.jp",
    "mie.jp",
    "miyagi.jp",
    "miyazaki.jp",
    "nagano.jp",
    "nagasaki.jp",
    "nara.jp",
    "niigata.jp",
    "oita.jp",
    "okayama.jp",
    "okinawa.jp",
    "osaka.jp",
    "saga.jp",
    "saitama.jp",
    "shiga.jp",
    "shimane.jp",
    "shizuoka.jp",
    "tochigi.jp",
    "tokushima.jp",
    "tokyo.jp",
    "tottori.jp",
    "toyama.jp",
    "wakayama.jp",
    "yamagata.jp",
    "yamaguchi.jp",
    "yamanashi.jp",
    "栃木.jp",
    "愛知.jp",
    "愛媛.jp",
    "兵庫.jp",
    "熊本.jp",
    "茨城.jp",
    "北海道.jp",
    "千葉.jp",
    "和歌山.jp",
    "長崎.jp",
    "長野.jp",
    "新潟.jp",
    "青森.jp",
    "静岡.jp",
    "東京.jp",
    "石川.jp",
    "埼玉.jp",
    "三重.jp",
    "京都.jp",
    "佐賀.jp",
    "大分.jp",
    "大阪.jp",
    "奈良.jp",
    "宮城.jp",
    "宮崎.jp",
    "富山.jp",
    "山口.jp",
    "山形.jp",
    "山梨.jp",
    "岩手.jp",
    "岐阜.jp",
    "岡山.jp",
    "島根.jp",
    "広島.jp",
    "徳島.jp",
    "沖縄.jp",
    "滋賀.jp",
    "神奈川.jp",
    "福井.jp",
    "福岡.jp",
    "福島.jp",
    "秋田.jp",
    "群馬.jp",
    "香川.jp",
    "高知.jp",
    "鳥取.jp",
    "鹿児島.jp",
    "*.kawasaki.jp",
    "*.kitakyushu.jp",
    "*.kobe.jp",
    "*.nagoya.jp",
    "*.sapporo.jp",
    "*.sendai.jp",
    "*.yokohama.jp",
    "!city.kawasaki.jp",
    "!city.kitakyushu.jp",
    "!city.kobe.jp",
    "!city.nagoya.jp",
    "!city.sapporo.jp",
    "!city.sendai.jp",
    "!city.yokohama.jp",
    "aisai.aichi.jp",
    "ama.aichi.jp",
    "anjo.aichi.jp",
    "asuke.aichi.jp",
    "chiryu.aichi.jp",
    "chita.aichi.jp",
    "fuso.aichi.jp",
    "gamagori.aichi.jp",
    "handa.aichi.jp",
    "hazu.aichi.jp",
    "hekinan.aichi.jp",
    "higashiura.aichi.jp",
    "ichinomiya.aichi.jp",
    "inazawa.aichi.jp",
    "inuyama.aichi.jp",
    "isshiki.aichi.jp",
    "iwakura.aichi.jp",
    "kanie.aichi.jp",
    "kariya.aichi.jp",
    "kasugai.aichi.jp",
    "kira.aichi.jp",
    "kiyosu.aichi.jp",
    "komaki.aichi.jp",
    "konan.aichi.jp",
    "kota.aichi.jp",
    "mihama.aichi.jp",
    "miyoshi.aichi.jp",
    "nishio.aichi.jp",
    "nisshin.aichi.jp",
    "obu.aichi.jp",
    "oguchi.aichi.jp",
    "oharu.aichi.jp",
    "okazaki.aichi.jp",
    "owariasahi.aichi.jp",
    "seto.aichi.jp",
    "shikatsu.aichi.jp",
    "shinshiro.aichi.jp",
    "shitara.aichi.jp",
    "tahara.aichi.jp",
    "takahama.aichi.jp",
    "tobishima.aichi.jp",
    "toei.aichi.jp",
    "togo.aichi.jp",
    "tokai.aichi.jp",
    "tokoname.aichi.jp",
    "toyoake.aichi.jp",
    "toyohashi.aichi.jp",
    "toyokawa.aichi.jp",
    "toyone.aichi.jp",
    "toyota.aichi.jp",
    "tsushima.aichi.jp",
    "yatomi.aichi.jp",
    "akita.akita.jp",
    "daisen.akita.jp",
    "fujisato.akita.jp",
    "gojome.akita.jp",
    "hachirogata.akita.jp",
    "happou.akita.jp",
    "higashinaruse.akita.jp",
    "honjo.akita.jp",
    "honjyo.akita.jp",
    "ikawa.akita.jp",
    "kamikoani.akita.jp",
    "kamioka.akita.jp",
    "katagami.akita.jp",
    "kazuno.akita.jp",
    "kitaakita.akita.jp",
    "kosaka.akita.jp",
    "kyowa.akita.jp",
    "misato.akita.jp",
    "mitane.akita.jp",
    "moriyoshi.akita.jp",
    "nikaho.akita.jp",
    "noshiro.akita.jp",
    "odate.akita.jp",
    "oga.akita.jp",
    "ogata.akita.jp",
    "semboku.akita.jp",
    "yokote.akita.jp",
    "yurihonjo.akita.jp",
    "aomori.aomori.jp",
    "gonohe.aomori.jp",
    "hachinohe.aomori.jp",
    "hashikami.aomori.jp",
    "hiranai.aomori.jp",
    "hirosaki.aomori.jp",
    "itayanagi.aomori.jp",
    "kuroishi.aomori.jp",
    "misawa.aomori.jp",
    "mutsu.aomori.jp",
    "nakadomari.aomori.jp",
    "noheji.aomori.jp",
    "oirase.aomori.jp",
    "owani.aomori.jp",
    "rokunohe.aomori.jp",
    "sannohe.aomori.jp",
    "shichinohe.aomori.jp",
    "shingo.aomori.jp",
    "takko.aomori.jp",
    "towada.aomori.jp",
    "tsugaru.aomori.jp",
    "tsuruta.aomori.jp",
    "abiko.chiba.jp",
    "asahi.chiba.jp",
    "chonan.chiba.jp",
    "chosei.chiba.jp",
    "choshi.chiba.jp",
    "chuo.chiba.jp",
    "funabashi.chiba.jp",
    "futtsu.chiba.jp",
    "hanamigawa.chiba.jp",
    "ichihara.chiba.jp",
    "ichikawa.chiba.jp",
    "ichinomiya.chiba.jp",
    "inzai.chiba.jp",
    "isumi.chiba.jp",
    "kamagaya.chiba.jp",
    "kamogawa.chiba.jp",
    "kashiwa.chiba.jp",
    "katori.chiba.jp",
    "katsuura.chiba.jp",
    "kimitsu.chiba.jp",
    "kisarazu.chiba.jp",
    "kozaki.chiba.jp",
    "kujukuri.chiba.jp",
    "kyonan.chiba.jp",
    "matsudo.chiba.jp",
    "midori.chiba.jp",
    "mihama.chiba.jp",
    "minamiboso.chiba.jp",
    "mobara.chiba.jp",
    "mutsuzawa.chiba.jp",
    "nagara.chiba.jp",
    "nagareyama.chiba.jp",
    "narashino.chiba.jp",
    "narita.chiba.jp",
    "noda.chiba.jp",
    "oamishirasato.chiba.jp",
    "omigawa.chiba.jp",
    "onjuku.chiba.jp",
    "otaki.chiba.jp",
    "sakae.chiba.jp",
    "sakura.chiba.jp",
    "shimofusa.chiba.jp",
    "shirako.chiba.jp",
    "shiroi.chiba.jp",
    "shisui.chiba.jp",
    "sodegaura.chiba.jp",
    "sosa.chiba.jp",
    "tako.chiba.jp",
    "tateyama.chiba.jp",
    "togane.chiba.jp",
    "tohnosho.chiba.jp",
    "tomisato.chiba.jp",
    "urayasu.chiba.jp",
    "yachimata.chiba.jp",
    "yachiyo.chiba.jp",
    "yokaichiba.chiba.jp",
    "yokoshibahikari.chiba.jp",
    "yotsukaido.chiba.jp",
    "ainan.ehime.jp",
    "honai.ehime.jp",
    "ikata.ehime.jp",
    "imabari.ehime.jp",
    "iyo.ehime.jp",
    "kamijima.ehime.jp",
    "kihoku.ehime.jp",
    "kumakogen.ehime.jp",
    "masaki.ehime.jp",
    "matsuno.ehime.jp",
    "matsuyama.ehime.jp",
    "namikata.ehime.jp",
    "niihama.ehime.jp",
    "ozu.ehime.jp",
    "saijo.ehime.jp",
    "seiyo.ehime.jp",
    "shikokuchuo.ehime.jp",
    "tobe.ehime.jp",
    "toon.ehime.jp",
    "uchiko.ehime.jp",
    "uwajima.ehime.jp",
    "yawatahama.ehime.jp",
    "echizen.fukui.jp",
    "eiheiji.fukui.jp",
    "fukui.fukui.jp",
    "ikeda.fukui.jp",
    "katsuyama.fukui.jp",
    "mihama.fukui.jp",
    "minamiechizen.fukui.jp",
    "obama.fukui.jp",
    "ohi.fukui.jp",
    "ono.fukui.jp",
    "sabae.fukui.jp",
    "sakai.fukui.jp",
    "takahama.fukui.jp",
    "tsuruga.fukui.jp",
    "wakasa.fukui.jp",
    "ashiya.fukuoka.jp",
    "buzen.fukuoka.jp",
    "chikugo.fukuoka.jp",
    "chikuho.fukuoka.jp",
    "chikujo.fukuoka.jp",
    "chikushino.fukuoka.jp",
    "chikuzen.fukuoka.jp",
    "chuo.fukuoka.jp",
    "dazaifu.fukuoka.jp",
    "fukuchi.fukuoka.jp",
    "hakata.fukuoka.jp",
    "higashi.fukuoka.jp",
    "hirokawa.fukuoka.jp",
    "hisayama.fukuoka.jp",
    "iizuka.fukuoka.jp",
    "inatsuki.fukuoka.jp",
    "kaho.fukuoka.jp",
    "kasuga.fukuoka.jp",
    "kasuya.fukuoka.jp",
    "kawara.fukuoka.jp",
    "keisen.fukuoka.jp",
    "koga.fukuoka.jp",
    "kurate.fukuoka.jp",
    "kurogi.fukuoka.jp",
    "kurume.fukuoka.jp",
    "minami.fukuoka.jp",
    "miyako.fukuoka.jp",
    "miyama.fukuoka.jp",
    "miyawaka.fukuoka.jp",
    "mizumaki.fukuoka.jp",
    "munakata.fukuoka.jp",
    "nakagawa.fukuoka.jp",
    "nakama.fukuoka.jp",
    "nishi.fukuoka.jp",
    "nogata.fukuoka.jp",
    "ogori.fukuoka.jp",
    "okagaki.fukuoka.jp",
    "okawa.fukuoka.jp",
    "oki.fukuoka.jp",
    "omuta.fukuoka.jp",
    "onga.fukuoka.jp",
    "onojo.fukuoka.jp",
    "oto.fukuoka.jp",
    "saigawa.fukuoka.jp",
    "sasaguri.fukuoka.jp",
    "shingu.fukuoka.jp",
    "shinyoshitomi.fukuoka.jp",
    "shonai.fukuoka.jp",
    "soeda.fukuoka.jp",
    "sue.fukuoka.jp",
    "tachiarai.fukuoka.jp",
    "tagawa.fukuoka.jp",
    "takata.fukuoka.jp",
    "toho.fukuoka.jp",
    "toyotsu.fukuoka.jp",
    "tsuiki.fukuoka.jp",
    "ukiha.fukuoka.jp",
    "umi.fukuoka.jp",
    "usui.fukuoka.jp",
    "yamada.fukuoka.jp",
    "yame.fukuoka.jp",
    "yanagawa.fukuoka.jp",
    "yukuhashi.fukuoka.jp",
    "aizubange.fukushima.jp",
    "aizumisato.fukushima.jp",
    "aizuwakamatsu.fukushima.jp",
    "asakawa.fukushima.jp",
    "bandai.fukushima.jp",
    "date.fukushima.jp",
    "fukushima.fukushima.jp",
    "furudono.fukushima.jp",
    "futaba.fukushima.jp",
    "hanawa.fukushima.jp",
    "higashi.fukushima.jp",
    "hirata.fukushima.jp",
    "hirono.fukushima.jp",
    "iitate.fukushima.jp",
    "inawashiro.fukushima.jp",
    "ishikawa.fukushima.jp",
    "iwaki.fukushima.jp",
    "izumizaki.fukushima.jp",
    "kagamiishi.fukushima.jp",
    "kaneyama.fukushima.jp",
    "kawamata.fukushima.jp",
    "kitakata.fukushima.jp",
    "kitashiobara.fukushima.jp",
    "koori.fukushima.jp",
    "koriyama.fukushima.jp",
    "kunimi.fukushima.jp",
    "miharu.fukushima.jp",
    "mishima.fukushima.jp",
    "namie.fukushima.jp",
    "nango.fukushima.jp",
    "nishiaizu.fukushima.jp",
    "nishigo.fukushima.jp",
    "okuma.fukushima.jp",
    "omotego.fukushima.jp",
    "ono.fukushima.jp",
    "otama.fukushima.jp",
    "samegawa.fukushima.jp",
    "shimogo.fukushima.jp",
    "shirakawa.fukushima.jp",
    "showa.fukushima.jp",
    "soma.fukushima.jp",
    "sukagawa.fukushima.jp",
    "taishin.fukushima.jp",
    "tamakawa.fukushima.jp",
    "tanagura.fukushima.jp",
    "tenei.fukushima.jp",
    "yabuki.fukushima.jp",
    "yamato.fukushima.jp",
    "yamatsuri.fukushima.jp",
    "yanaizu.fukushima.jp",
    "yugawa.fukushima.jp",
    "anpachi.gifu.jp",
    "ena.gifu.jp",
    "gifu.gifu.jp",
    "ginan.gifu.jp",
    "godo.gifu.jp",
    "gujo.gifu.jp",
    "hashima.gifu.jp",
    "hichiso.gifu.jp",
    "hida.gifu.jp",
    "higashishirakawa.gifu.jp",
    "ibigawa.gifu.jp",
    "ikeda.gifu.jp",
    "kakamigahara.gifu.jp",
    "kani.gifu.jp",
    "kasahara.gifu.jp",
    "kasamatsu.gifu.jp",
    "kawaue.gifu.jp",
    "kitagata.gifu.jp",
    "mino.gifu.jp",
    "minokamo.gifu.jp",
    "mitake.gifu.jp",
    "mizunami.gifu.jp",
    "motosu.gifu.jp",
    "nakatsugawa.gifu.jp",
    "ogaki.gifu.jp",
    "sakahogi.gifu.jp",
    "seki.gifu.jp",
    "sekigahara.gifu.jp",
    "shirakawa.gifu.jp",
    "tajimi.gifu.jp",
    "takayama.gifu.jp",
    "tarui.gifu.jp",
    "toki.gifu.jp",
    "tomika.gifu.jp",
    "wanouchi.gifu.jp",
    "yamagata.gifu.jp",
    "yaotsu.gifu.jp",
    "yoro.gifu.jp",
    "annaka.gunma.jp",
    "chiyoda.gunma.jp",
    "fujioka.gunma.jp",
    "higashiagatsuma.gunma.jp",
    "isesaki.gunma.jp",
    "itakura.gunma.jp",
    "kanna.gunma.jp",
    "kanra.gunma.jp",
    "katashina.gunma.jp",
    "kawaba.gunma.jp",
    "kiryu.gunma.jp",
    "kusatsu.gunma.jp",
    "maebashi.gunma.jp",
    "meiwa.gunma.jp",
    "midori.gunma.jp",
    "minakami.gunma.jp",
    "naganohara.gunma.jp",
    "nakanojo.gunma.jp",
    "nanmoku.gunma.jp",
    "numata.gunma.jp",
    "oizumi.gunma.jp",
    "ora.gunma.jp",
    "ota.gunma.jp",
    "shibukawa.gunma.jp",
    "shimonita.gunma.jp",
    "shinto.gunma.jp",
    "showa.gunma.jp",
    "takasaki.gunma.jp",
    "takayama.gunma.jp",
    "tamamura.gunma.jp",
    "tatebayashi.gunma.jp",
    "tomioka.gunma.jp",
    "tsukiyono.gunma.jp",
    "tsumagoi.gunma.jp",
    "ueno.gunma.jp",
    "yoshioka.gunma.jp",
    "asaminami.hiroshima.jp",
    "daiwa.hiroshima.jp",
    "etajima.hiroshima.jp",
    "fuchu.hiroshima.jp",
    "fukuyama.hiroshima.jp",
    "hatsukaichi.hiroshima.jp",
    "higashihiroshima.hiroshima.jp",
    "hongo.hiroshima.jp",
    "jinsekikogen.hiroshima.jp",
    "kaita.hiroshima.jp",
    "kui.hiroshima.jp",
    "kumano.hiroshima.jp",
    "kure.hiroshima.jp",
    "mihara.hiroshima.jp",
    "miyoshi.hiroshima.jp",
    "naka.hiroshima.jp",
    "onomichi.hiroshima.jp",
    "osakikamijima.hiroshima.jp",
    "otake.hiroshima.jp",
    "saka.hiroshima.jp",
    "sera.hiroshima.jp",
    "seranishi.hiroshima.jp",
    "shinichi.hiroshima.jp",
    "shobara.hiroshima.jp",
    "takehara.hiroshima.jp",
    "abashiri.hokkaido.jp",
    "abira.hokkaido.jp",
    "aibetsu.hokkaido.jp",
    "akabira.hokkaido.jp",
    "akkeshi.hokkaido.jp",
    "asahikawa.hokkaido.jp",
    "ashibetsu.hokkaido.jp",
    "ashoro.hokkaido.jp",
    "assabu.hokkaido.jp",
    "atsuma.hokkaido.jp",
    "bibai.hokkaido.jp",
    "biei.hokkaido.jp",
    "bifuka.hokkaido.jp",
    "bihoro.hokkaido.jp",
    "biratori.hokkaido.jp",
    "chippubetsu.hokkaido.jp",
    "chitose.hokkaido.jp",
    "date.hokkaido.jp",
    "ebetsu.hokkaido.jp",
    "embetsu.hokkaido.jp",
    "eniwa.hokkaido.jp",
    "erimo.hokkaido.jp",
    "esan.hokkaido.jp",
    "esashi.hokkaido.jp",
    "fukagawa.hokkaido.jp",
    "fukushima.hokkaido.jp",
    "furano.hokkaido.jp",
    "furubira.hokkaido.jp",
    "haboro.hokkaido.jp",
    "hakodate.hokkaido.jp",
    "hamatonbetsu.hokkaido.jp",
    "hidaka.hokkaido.jp",
    "higashikagura.hokkaido.jp",
    "higashikawa.hokkaido.jp",
    "hiroo.hokkaido.jp",
    "hokuryu.hokkaido.jp",
    "hokuto.hokkaido.jp",
    "honbetsu.hokkaido.jp",
    "horokanai.hokkaido.jp",
    "horonobe.hokkaido.jp",
    "ikeda.hokkaido.jp",
    "imakane.hokkaido.jp",
    "ishikari.hokkaido.jp",
    "iwamizawa.hokkaido.jp",
    "iwanai.hokkaido.jp",
    "kamifurano.hokkaido.jp",
    "kamikawa.hokkaido.jp",
    "kamishihoro.hokkaido.jp",
    "kamisunagawa.hokkaido.jp",
    "kamoenai.hokkaido.jp",
    "kayabe.hokkaido.jp",
    "kembuchi.hokkaido.jp",
    "kikonai.hokkaido.jp",
    "kimobetsu.hokkaido.jp",
    "kitahiroshima.hokkaido.jp",
    "kitami.hokkaido.jp",
    "kiyosato.hokkaido.jp",
    "koshimizu.hokkaido.jp",
    "kunneppu.hokkaido.jp",
    "kuriyama.hokkaido.jp",
    "kuromatsunai.hokkaido.jp",
    "kushiro.hokkaido.jp",
    "kutchan.hokkaido.jp",
    "kyowa.hokkaido.jp",
    "mashike.hokkaido.jp",
    "matsumae.hokkaido.jp",
    "mikasa.hokkaido.jp",
    "minamifurano.hokkaido.jp",
    "mombetsu.hokkaido.jp",
    "moseushi.hokkaido.jp",
    "mukawa.hokkaido.jp",
    "muroran.hokkaido.jp",
    "naie.hokkaido.jp",
    "nakagawa.hokkaido.jp",
    "nakasatsunai.hokkaido.jp",
    "nakatombetsu.hokkaido.jp",
    "nanae.hokkaido.jp",
    "nanporo.hokkaido.jp",
    "nayoro.hokkaido.jp",
    "nemuro.hokkaido.jp",
    "niikappu.hokkaido.jp",
    "niki.hokkaido.jp",
    "nishiokoppe.hokkaido.jp",
    "noboribetsu.hokkaido.jp",
    "numata.hokkaido.jp",
    "obihiro.hokkaido.jp",
    "obira.hokkaido.jp",
    "oketo.hokkaido.jp",
    "okoppe.hokkaido.jp",
    "otaru.hokkaido.jp",
    "otobe.hokkaido.jp",
    "otofuke.hokkaido.jp",
    "otoineppu.hokkaido.jp",
    "oumu.hokkaido.jp",
    "ozora.hokkaido.jp",
    "pippu.hokkaido.jp",
    "rankoshi.hokkaido.jp",
    "rebun.hokkaido.jp",
    "rikubetsu.hokkaido.jp",
    "rishiri.hokkaido.jp",
    "rishirifuji.hokkaido.jp",
    "saroma.hokkaido.jp",
    "sarufutsu.hokkaido.jp",
    "shakotan.hokkaido.jp",
    "shari.hokkaido.jp",
    "shibecha.hokkaido.jp",
    "shibetsu.hokkaido.jp",
    "shikabe.hokkaido.jp",
    "shikaoi.hokkaido.jp",
    "shimamaki.hokkaido.jp",
    "shimizu.hokkaido.jp",
    "shimokawa.hokkaido.jp",
    "shinshinotsu.hokkaido.jp",
    "shintoku.hokkaido.jp",
    "shiranuka.hokkaido.jp",
    "shiraoi.hokkaido.jp",
    "shiriuchi.hokkaido.jp",
    "sobetsu.hokkaido.jp",
    "sunagawa.hokkaido.jp",
    "taiki.hokkaido.jp",
    "takasu.hokkaido.jp",
    "takikawa.hokkaido.jp",
    "takinoue.hokkaido.jp",
    "teshikaga.hokkaido.jp",
    "tobetsu.hokkaido.jp",
    "tohma.hokkaido.jp",
    "tomakomai.hokkaido.jp",
    "tomari.hokkaido.jp",
    "toya.hokkaido.jp",
    "toyako.hokkaido.jp",
    "toyotomi.hokkaido.jp",
    "toyoura.hokkaido.jp",
    "tsubetsu.hokkaido.jp",
    "tsukigata.hokkaido.jp",
    "urakawa.hokkaido.jp",
    "urausu.hokkaido.jp",
    "uryu.hokkaido.jp",
    "utashinai.hokkaido.jp",
    "wakkanai.hokkaido.jp",
    "wassamu.hokkaido.jp",
    "yakumo.hokkaido.jp",
    "yoichi.hokkaido.jp",
    "aioi.hyogo.jp",
    "akashi.hyogo.jp",
    "ako.hyogo.jp",
    "amagasaki.hyogo.jp",
    "aogaki.hyogo.jp",
    "asago.hyogo.jp",
    "ashiya.hyogo.jp",
    "awaji.hyogo.jp",
    "fukusaki.hyogo.jp",
    "goshiki.hyogo.jp",
    "harima.hyogo.jp",
    "himeji.hyogo.jp",
    "ichikawa.hyogo.jp",
    "inagawa.hyogo.jp",
    "itami.hyogo.jp",
    "kakogawa.hyogo.jp",
    "kamigori.hyogo.jp",
    "kamikawa.hyogo.jp",
    "kasai.hyogo.jp",
    "kasuga.hyogo.jp",
    "kawanishi.hyogo.jp",
    "miki.hyogo.jp",
    "minamiawaji.hyogo.jp",
    "nishinomiya.hyogo.jp",
    "nishiwaki.hyogo.jp",
    "ono.hyogo.jp",
    "sanda.hyogo.jp",
    "sannan.hyogo.jp",
    "sasayama.hyogo.jp",
    "sayo.hyogo.jp",
    "shingu.hyogo.jp",
    "shinonsen.hyogo.jp",
    "shiso.hyogo.jp",
    "sumoto.hyogo.jp",
    "taishi.hyogo.jp",
    "taka.hyogo.jp",
    "takarazuka.hyogo.jp",
    "takasago.hyogo.jp",
    "takino.hyogo.jp",
    "tamba.hyogo.jp",
    "tatsuno.hyogo.jp",
    "toyooka.hyogo.jp",
    "yabu.hyogo.jp",
    "yashiro.hyogo.jp",
    "yoka.hyogo.jp",
    "yokawa.hyogo.jp",
    "ami.ibaraki.jp",
    "asahi.ibaraki.jp",
    "bando.ibaraki.jp",
    "chikusei.ibaraki.jp",
    "daigo.ibaraki.jp",
    "fujishiro.ibaraki.jp",
    "hitachi.ibaraki.jp",
    "hitachinaka.ibaraki.jp",
    "hitachiomiya.ibaraki.jp",
    "hitachiota.ibaraki.jp",
    "ibaraki.ibaraki.jp",
    "ina.ibaraki.jp",
    "inashiki.ibaraki.jp",
    "itako.ibaraki.jp",
    "iwama.ibaraki.jp",
    "joso.ibaraki.jp",
    "kamisu.ibaraki.jp",
    "kasama.ibaraki.jp",
    "kashima.ibaraki.jp",
    "kasumigaura.ibaraki.jp",
    "koga.ibaraki.jp",
    "miho.ibaraki.jp",
    "mito.ibaraki.jp",
    "moriya.ibaraki.jp",
    "naka.ibaraki.jp",
    "namegata.ibaraki.jp",
    "oarai.ibaraki.jp",
    "ogawa.ibaraki.jp",
    "omitama.ibaraki.jp",
    "ryugasaki.ibaraki.jp",
    "sakai.ibaraki.jp",
    "sakuragawa.ibaraki.jp",
    "shimodate.ibaraki.jp",
    "shimotsuma.ibaraki.jp",
    "shirosato.ibaraki.jp",
    "sowa.ibaraki.jp",
    "suifu.ibaraki.jp",
    "takahagi.ibaraki.jp",
    "tamatsukuri.ibaraki.jp",
    "tokai.ibaraki.jp",
    "tomobe.ibaraki.jp",
    "tone.ibaraki.jp",
    "toride.ibaraki.jp",
    "tsuchiura.ibaraki.jp",
    "tsukuba.ibaraki.jp",
    "uchihara.ibaraki.jp",
    "ushiku.ibaraki.jp",
    "yachiyo.ibaraki.jp",
    "yamagata.ibaraki.jp",
    "yawara.ibaraki.jp",
    "yuki.ibaraki.jp",
    "anamizu.ishikawa.jp",
    "hakui.ishikawa.jp",
    "hakusan.ishikawa.jp",
    "kaga.ishikawa.jp",
    "kahoku.ishikawa.jp",
    "kanazawa.ishikawa.jp",
    "kawakita.ishikawa.jp",
    "komatsu.ishikawa.jp",
    "nakanoto.ishikawa.jp",
    "nanao.ishikawa.jp",
    "nomi.ishikawa.jp",
    "nonoichi.ishikawa.jp",
    "noto.ishikawa.jp",
    "shika.ishikawa.jp",
    "suzu.ishikawa.jp",
    "tsubata.ishikawa.jp",
    "tsurugi.ishikawa.jp",
    "uchinada.ishikawa.jp",
    "wajima.ishikawa.jp",
    "fudai.iwate.jp",
    "fujisawa.iwate.jp",
    "hanamaki.iwate.jp",
    "hiraizumi.iwate.jp",
    "hirono.iwate.jp",
    "ichinohe.iwate.jp",
    "ichinoseki.iwate.jp",
    "iwaizumi.iwate.jp",
    "iwate.iwate.jp",
    "joboji.iwate.jp",
    "kamaishi.iwate.jp",
    "kanegasaki.iwate.jp",
    "karumai.iwate.jp",
    "kawai.iwate.jp",
    "kitakami.iwate.jp",
    "kuji.iwate.jp",
    "kunohe.iwate.jp",
    "kuzumaki.iwate.jp",
    "miyako.iwate.jp",
    "mizusawa.iwate.jp",
    "morioka.iwate.jp",
    "ninohe.iwate.jp",
    "noda.iwate.jp",
    "ofunato.iwate.jp",
    "oshu.iwate.jp",
    "otsuchi.iwate.jp",
    "rikuzentakata.iwate.jp",
    "shiwa.iwate.jp",
    "shizukuishi.iwate.jp",
    "sumita.iwate.jp",
    "tanohata.iwate.jp",
    "tono.iwate.jp",
    "yahaba.iwate.jp",
    "yamada.iwate.jp",
    "ayagawa.kagawa.jp",
    "higashikagawa.kagawa.jp",
    "kanonji.kagawa.jp",
    "kotohira.kagawa.jp",
    "manno.kagawa.jp",
    "marugame.kagawa.jp",
    "mitoyo.kagawa.jp",
    "naoshima.kagawa.jp",
    "sanuki.kagawa.jp",
    "tadotsu.kagawa.jp",
    "takamatsu.kagawa.jp",
    "tonosho.kagawa.jp",
    "uchinomi.kagawa.jp",
    "utazu.kagawa.jp",
    "zentsuji.kagawa.jp",
    "akune.kagoshima.jp",
    "amami.kagoshima.jp",
    "hioki.kagoshima.jp",
    "isa.kagoshima.jp",
    "isen.kagoshima.jp",
    "izumi.kagoshima.jp",
    "kagoshima.kagoshima.jp",
    "kanoya.kagoshima.jp",
    "kawanabe.kagoshima.jp",
    "kinko.kagoshima.jp",
    "kouyama.kagoshima.jp",
    "makurazaki.kagoshima.jp",
    "matsumoto.kagoshima.jp",
    "minamitane.kagoshima.jp",
    "nakatane.kagoshima.jp",
    "nishinoomote.kagoshima.jp",
    "satsumasendai.kagoshima.jp",
    "soo.kagoshima.jp",
    "tarumizu.kagoshima.jp",
    "yusui.kagoshima.jp",
    "aikawa.kanagawa.jp",
    "atsugi.kanagawa.jp",
    "ayase.kanagawa.jp",
    "chigasaki.kanagawa.jp",
    "ebina.kanagawa.jp",
    "fujisawa.kanagawa.jp",
    "hadano.kanagawa.jp",
    "hakone.kanagawa.jp",
    "hiratsuka.kanagawa.jp",
    "isehara.kanagawa.jp",
    "kaisei.kanagawa.jp",
    "kamakura.kanagawa.jp",
    "kiyokawa.kanagawa.jp",
    "matsuda.kanagawa.jp",
    "minamiashigara.kanagawa.jp",
    "miura.kanagawa.jp",
    "nakai.kanagawa.jp",
    "ninomiya.kanagawa.jp",
    "odawara.kanagawa.jp",
    "oi.kanagawa.jp",
    "oiso.kanagawa.jp",
    "sagamihara.kanagawa.jp",
    "samukawa.kanagawa.jp",
    "tsukui.kanagawa.jp",
    "yamakita.kanagawa.jp",
    "yamato.kanagawa.jp",
    "yokosuka.kanagawa.jp",
    "yugawara.kanagawa.jp",
    "zama.kanagawa.jp",
    "zushi.kanagawa.jp",
    "aki.kochi.jp",
    "geisei.kochi.jp",
    "hidaka.kochi.jp",
    "higashitsuno.kochi.jp",
    "ino.kochi.jp",
    "kagami.kochi.jp",
    "kami.kochi.jp",
    "kitagawa.kochi.jp",
    "kochi.kochi.jp",
    "mihara.kochi.jp",
    "motoyama.kochi.jp",
    "muroto.kochi.jp",
    "nahari.kochi.jp",
    "nakamura.kochi.jp",
    "nankoku.kochi.jp",
    "nishitosa.kochi.jp",
    "niyodogawa.kochi.jp",
    "ochi.kochi.jp",
    "okawa.kochi.jp",
    "otoyo.kochi.jp",
    "otsuki.kochi.jp",
    "sakawa.kochi.jp",
    "sukumo.kochi.jp",
    "susaki.kochi.jp",
    "tosa.kochi.jp",
    "tosashimizu.kochi.jp",
    "toyo.kochi.jp",
    "tsuno.kochi.jp",
    "umaji.kochi.jp",
    "yasuda.kochi.jp",
    "yusuhara.kochi.jp",
    "amakusa.kumamoto.jp",
    "arao.kumamoto.jp",
    "aso.kumamoto.jp",
    "choyo.kumamoto.jp",
    "gyokuto.kumamoto.jp",
    "kamiamakusa.kumamoto.jp",
    "kikuchi.kumamoto.jp",
    "kumamoto.kumamoto.jp",
    "mashiki.kumamoto.jp",
    "mifune.kumamoto.jp",
    "minamata.kumamoto.jp",
    "minamioguni.kumamoto.jp",
    "nagasu.kumamoto.jp",
    "nishihara.kumamoto.jp",
    "oguni.kumamoto.jp",
    "ozu.kumamoto.jp",
    "sumoto.kumamoto.jp",
    "takamori.kumamoto.jp",
    "uki.kumamoto.jp",
    "uto.kumamoto.jp",
    "yamaga.kumamoto.jp",
    "yamato.kumamoto.jp",
    "yatsushiro.kumamoto.jp",
    "ayabe.kyoto.jp",
    "fukuchiyama.kyoto.jp",
    "higashiyama.kyoto.jp",
    "ide.kyoto.jp",
    "ine.kyoto.jp",
    "joyo.kyoto.jp",
    "kameoka.kyoto.jp",
    "kamo.kyoto.jp",
    "kita.kyoto.jp",
    "kizu.kyoto.jp",
    "kumiyama.kyoto.jp",
    "kyotamba.kyoto.jp",
    "kyotanabe.kyoto.jp",
    "kyotango.kyoto.jp",
    "maizuru.kyoto.jp",
    "minami.kyoto.jp",
    "minamiyamashiro.kyoto.jp",
    "miyazu.kyoto.jp",
    "muko.kyoto.jp",
    "nagaokakyo.kyoto.jp",
    "nakagyo.kyoto.jp",
    "nantan.kyoto.jp",
    "oyamazaki.kyoto.jp",
    "sakyo.kyoto.jp",
    "seika.kyoto.jp",
    "tanabe.kyoto.jp",
    "uji.kyoto.jp",
    "ujitawara.kyoto.jp",
    "wazuka.kyoto.jp",
    "yamashina.kyoto.jp",
    "yawata.kyoto.jp",
    "asahi.mie.jp",
    "inabe.mie.jp",
    "ise.mie.jp",
    "kameyama.mie.jp",
    "kawagoe.mie.jp",
    "kiho.mie.jp",
    "kisosaki.mie.jp",
    "kiwa.mie.jp",
    "komono.mie.jp",
    "kumano.mie.jp",
    "kuwana.mie.jp",
    "matsusaka.mie.jp",
    "meiwa.mie.jp",
    "mihama.mie.jp",
    "minamiise.mie.jp",
    "misugi.mie.jp",
    "miyama.mie.jp",
    "nabari.mie.jp",
    "shima.mie.jp",
    "suzuka.mie.jp",
    "tado.mie.jp",
    "taiki.mie.jp",
    "taki.mie.jp",
    "tamaki.mie.jp",
    "toba.mie.jp",
    "tsu.mie.jp",
    "udono.mie.jp",
    "ureshino.mie.jp",
    "watarai.mie.jp",
    "yokkaichi.mie.jp",
    "furukawa.miyagi.jp",
    "higashimatsushima.miyagi.jp",
    "ishinomaki.miyagi.jp",
    "iwanuma.miyagi.jp",
    "kakuda.miyagi.jp",
    "kami.miyagi.jp",
    "kawasaki.miyagi.jp",
    "marumori.miyagi.jp",
    "matsushima.miyagi.jp",
    "minamisanriku.miyagi.jp",
    "misato.miyagi.jp",
    "murata.miyagi.jp",
    "natori.miyagi.jp",
    "ogawara.miyagi.jp",
    "ohira.miyagi.jp",
    "onagawa.miyagi.jp",
    "osaki.miyagi.jp",
    "rifu.miyagi.jp",
    "semine.miyagi.jp",
    "shibata.miyagi.jp",
    "shichikashuku.miyagi.jp",
    "shikama.miyagi.jp",
    "shiogama.miyagi.jp",
    "shiroishi.miyagi.jp",
    "tagajo.miyagi.jp",
    "taiwa.miyagi.jp",
    "tome.miyagi.jp",
    "tomiya.miyagi.jp",
    "wakuya.miyagi.jp",
    "watari.miyagi.jp",
    "yamamoto.miyagi.jp",
    "zao.miyagi.jp",
    "aya.miyazaki.jp",
    "ebino.miyazaki.jp",
    "gokase.miyazaki.jp",
    "hyuga.miyazaki.jp",
    "kadogawa.miyazaki.jp",
    "kawaminami.miyazaki.jp",
    "kijo.miyazaki.jp",
    "kitagawa.miyazaki.jp",
    "kitakata.miyazaki.jp",
    "kitaura.miyazaki.jp",
    "kobayashi.miyazaki.jp",
    "kunitomi.miyazaki.jp",
    "kushima.miyazaki.jp",
    "mimata.miyazaki.jp",
    "miyakonojo.miyazaki.jp",
    "miyazaki.miyazaki.jp",
    "morotsuka.miyazaki.jp",
    "nichinan.miyazaki.jp",
    "nishimera.miyazaki.jp",
    "nobeoka.miyazaki.jp",
    "saito.miyazaki.jp",
    "shiiba.miyazaki.jp",
    "shintomi.miyazaki.jp",
    "takaharu.miyazaki.jp",
    "takanabe.miyazaki.jp",
    "takazaki.miyazaki.jp",
    "tsuno.miyazaki.jp",
    "achi.nagano.jp",
    "agematsu.nagano.jp",
    "anan.nagano.jp",
    "aoki.nagano.jp",
    "asahi.nagano.jp",
    "azumino.nagano.jp",
    "chikuhoku.nagano.jp",
    "chikuma.nagano.jp",
    "chino.nagano.jp",
    "fujimi.nagano.jp",
    "hakuba.nagano.jp",
    "hara.nagano.jp",
    "hiraya.nagano.jp",
    "iida.nagano.jp",
    "iijima.nagano.jp",
    "iiyama.nagano.jp",
    "iizuna.nagano.jp",
    "ikeda.nagano.jp",
    "ikusaka.nagano.jp",
    "ina.nagano.jp",
    "karuizawa.nagano.jp",
    "kawakami.nagano.jp",
    "kiso.nagano.jp",
    "kisofukushima.nagano.jp",
    "kitaaiki.nagano.jp",
    "komagane.nagano.jp",
    "komoro.nagano.jp",
    "matsukawa.nagano.jp",
    "matsumoto.nagano.jp",
    "miasa.nagano.jp",
    "minamiaiki.nagano.jp",
    "minamimaki.nagano.jp",
    "minamiminowa.nagano.jp",
    "minowa.nagano.jp",
    "miyada.nagano.jp",
    "miyota.nagano.jp",
    "mochizuki.nagano.jp",
    "nagano.nagano.jp",
    "nagawa.nagano.jp",
    "nagiso.nagano.jp",
    "nakagawa.nagano.jp",
    "nakano.nagano.jp",
    "nozawaonsen.nagano.jp",
    "obuse.nagano.jp",
    "ogawa.nagano.jp",
    "okaya.nagano.jp",
    "omachi.nagano.jp",
    "omi.nagano.jp",
    "ookuwa.nagano.jp",
    "ooshika.nagano.jp",
    "otaki.nagano.jp",
    "otari.nagano.jp",
    "sakae.nagano.jp",
    "sakaki.nagano.jp",
    "saku.nagano.jp",
    "sakuho.nagano.jp",
    "shimosuwa.nagano.jp",
    "shinanomachi.nagano.jp",
    "shiojiri.nagano.jp",
    "suwa.nagano.jp",
    "suzaka.nagano.jp",
    "takagi.nagano.jp",
    "takamori.nagano.jp",
    "takayama.nagano.jp",
    "tateshina.nagano.jp",
    "tatsuno.nagano.jp",
    "togakushi.nagano.jp",
    "togura.nagano.jp",
    "tomi.nagano.jp",
    "ueda.nagano.jp",
    "wada.nagano.jp",
    "yamagata.nagano.jp",
    "yamanouchi.nagano.jp",
    "yasaka.nagano.jp",
    "yasuoka.nagano.jp",
    "chijiwa.nagasaki.jp",
    "futsu.nagasaki.jp",
    "goto.nagasaki.jp",
    "hasami.nagasaki.jp",
    "hirado.nagasaki.jp",
    "iki.nagasaki.jp",
    "isahaya.nagasaki.jp",
    "kawatana.nagasaki.jp",
    "kuchinotsu.nagasaki.jp",
    "matsuura.nagasaki.jp",
    "nagasaki.nagasaki.jp",
    "obama.nagasaki.jp",
    "omura.nagasaki.jp",
    "oseto.nagasaki.jp",
    "saikai.nagasaki.jp",
    "sasebo.nagasaki.jp",
    "seihi.nagasaki.jp",
    "shimabara.nagasaki.jp",
    "shinkamigoto.nagasaki.jp",
    "togitsu.nagasaki.jp",
    "tsushima.nagasaki.jp",
    "unzen.nagasaki.jp",
    "ando.nara.jp",
    "gose.nara.jp",
    "heguri.nara.jp",
    "higashiyoshino.nara.jp",
    "ikaruga.nara.jp",
    "ikoma.nara.jp",
    "kamikitayama.nara.jp",
    "kanmaki.nara.jp",
    "kashiba.nara.jp",
    "kashihara.nara.jp",
    "katsuragi.nara.jp",
    "kawai.nara.jp",
    "kawakami.nara.jp",
    "kawanishi.nara.jp",
    "koryo.nara.jp",
    "kurotaki.nara.jp",
    "mitsue.nara.jp",
    "miyake.nara.jp",
    "nara.nara.jp",
    "nosegawa.nara.jp",
    "oji.nara.jp",
    "ouda.nara.jp",
    "oyodo.nara.jp",
    "sakurai.nara.jp",
    "sango.nara.jp",
    "shimoichi.nara.jp",
    "shimokitayama.nara.jp",
    "shinjo.nara.jp",
    "soni.nara.jp",
    "takatori.nara.jp",
    "tawaramoto.nara.jp",
    "tenkawa.nara.jp",
    "tenri.nara.jp",
    "uda.nara.jp",
    "yamatokoriyama.nara.jp",
    "yamatotakada.nara.jp",
    "yamazoe.nara.jp",
    "yoshino.nara.jp",
    "aga.niigata.jp",
    "agano.niigata.jp",
    "gosen.niigata.jp",
    "itoigawa.niigata.jp",
    "izumozaki.niigata.jp",
    "joetsu.niigata.jp",
    "kamo.niigata.jp",
    "kariwa.niigata.jp",
    "kashiwazaki.niigata.jp",
    "minamiuonuma.niigata.jp",
    "mitsuke.niigata.jp",
    "muika.niigata.jp",
    "murakami.niigata.jp",
    "myoko.niigata.jp",
    "nagaoka.niigata.jp",
    "niigata.niigata.jp",
    "ojiya.niigata.jp",
    "omi.niigata.jp",
    "sado.niigata.jp",
    "sanjo.niigata.jp",
    "seiro.niigata.jp",
    "seirou.niigata.jp",
    "sekikawa.niigata.jp",
    "shibata.niigata.jp",
    "tagami.niigata.jp",
    "tainai.niigata.jp",
    "tochio.niigata.jp",
    "tokamachi.niigata.jp",
    "tsubame.niigata.jp",
    "tsunan.niigata.jp",
    "uonuma.niigata.jp",
    "yahiko.niigata.jp",
    "yoita.niigata.jp",
    "yuzawa.niigata.jp",
    "beppu.oita.jp",
    "bungoono.oita.jp",
    "bungotakada.oita.jp",
    "hasama.oita.jp",
    "hiji.oita.jp",
    "himeshima.oita.jp",
    "hita.oita.jp",
    "kamitsue.oita.jp",
    "kokonoe.oita.jp",
    "kuju.oita.jp",
    "kunisaki.oita.jp",
    "kusu.oita.jp",
    "oita.oita.jp",
    "saiki.oita.jp",
    "taketa.oita.jp",
    "tsukumi.oita.jp",
    "usa.oita.jp",
    "usuki.oita.jp",
    "yufu.oita.jp",
    "akaiwa.okayama.jp",
    "asakuchi.okayama.jp",
    "bizen.okayama.jp",
    "hayashima.okayama.jp",
    "ibara.okayama.jp",
    "kagamino.okayama.jp",
    "kasaoka.okayama.jp",
    "kibichuo.okayama.jp",
    "kumenan.okayama.jp",
    "kurashiki.okayama.jp",
    "maniwa.okayama.jp",
    "misaki.okayama.jp",
    "nagi.okayama.jp",
    "niimi.okayama.jp",
    "nishiawakura.okayama.jp",
    "okayama.okayama.jp",
    "satosho.okayama.jp",
    "setouchi.okayama.jp",
    "shinjo.okayama.jp",
    "shoo.okayama.jp",
    "soja.okayama.jp",
    "takahashi.okayama.jp",
    "tamano.okayama.jp",
    "tsuyama.okayama.jp",
    "wake.okayama.jp",
    "yakage.okayama.jp",
    "aguni.okinawa.jp",
    "ginowan.okinawa.jp",
    "ginoza.okinawa.jp",
    "gushikami.okinawa.jp",
    "haebaru.okinawa.jp",
    "higashi.okinawa.jp",
    "hirara.okinawa.jp",
    "iheya.okinawa.jp",
    "ishigaki.okinawa.jp",
    "ishikawa.okinawa.jp",
    "itoman.okinawa.jp",
    "izena.okinawa.jp",
    "kadena.okinawa.jp",
    "kin.okinawa.jp",
    "kitadaito.okinawa.jp",
    "kitanakagusuku.okinawa.jp",
    "kumejima.okinawa.jp",
    "kunigami.okinawa.jp",
    "minamidaito.okinawa.jp",
    "motobu.okinawa.jp",
    "nago.okinawa.jp",
    "naha.okinawa.jp",
    "nakagusuku.okinawa.jp",
    "nakijin.okinawa.jp",
    "nanjo.okinawa.jp",
    "nishihara.okinawa.jp",
    "ogimi.okinawa.jp",
    "okinawa.okinawa.jp",
    "onna.okinawa.jp",
    "shimoji.okinawa.jp",
    "taketomi.okinawa.jp",
    "tarama.okinawa.jp",
    "tokashiki.okinawa.jp",
    "tomigusuku.okinawa.jp",
    "tonaki.okinawa.jp",
    "urasoe.okinawa.jp",
    "uruma.okinawa.jp",
    "yaese.okinawa.jp",
    "yomitan.okinawa.jp",
    "yonabaru.okinawa.jp",
    "yonaguni.okinawa.jp",
    "zamami.okinawa.jp",
    "abeno.osaka.jp",
    "chihayaakasaka.osaka.jp",
    "chuo.osaka.jp",
    "daito.osaka.jp",
    "fujiidera.osaka.jp",
    "habikino.osaka.jp",
    "hannan.osaka.jp",
    "higashiosaka.osaka.jp",
    "higashisumiyoshi.osaka.jp",
    "higashiyodogawa.osaka.jp",
    "hirakata.osaka.jp",
    "ibaraki.osaka.jp",
    "ikeda.osaka.jp",
    "izumi.osaka.jp",
    "izumiotsu.osaka.jp",
    "izumisano.osaka.jp",
    "kadoma.osaka.jp",
    "kaizuka.osaka.jp",
    "kanan.osaka.jp",
    "kashiwara.osaka.jp",
    "katano.osaka.jp",
    "kawachinagano.osaka.jp",
    "kishiwada.osaka.jp",
    "kita.osaka.jp",
    "kumatori.osaka.jp",
    "matsubara.osaka.jp",
    "minato.osaka.jp",
    "minoh.osaka.jp",
    "misaki.osaka.jp",
    "moriguchi.osaka.jp",
    "neyagawa.osaka.jp",
    "nishi.osaka.jp",
    "nose.osaka.jp",
    "osakasayama.osaka.jp",
    "sakai.osaka.jp",
    "sayama.osaka.jp",
    "sennan.osaka.jp",
    "settsu.osaka.jp",
    "shijonawate.osaka.jp",
    "shimamoto.osaka.jp",
    "suita.osaka.jp",
    "tadaoka.osaka.jp",
    "taishi.osaka.jp",
    "tajiri.osaka.jp",
    "takaishi.osaka.jp",
    "takatsuki.osaka.jp",
    "tondabayashi.osaka.jp",
    "toyonaka.osaka.jp",
    "toyono.osaka.jp",
    "yao.osaka.jp",
    "ariake.saga.jp",
    "arita.saga.jp",
    "fukudomi.saga.jp",
    "genkai.saga.jp",
    "hamatama.saga.jp",
    "hizen.saga.jp",
    "imari.saga.jp",
    "kamimine.saga.jp",
    "kanzaki.saga.jp",
    "karatsu.saga.jp",
    "kashima.saga.jp",
    "kitagata.saga.jp",
    "kitahata.saga.jp",
    "kiyama.saga.jp",
    "kouhoku.saga.jp",
    "kyuragi.saga.jp",
    "nishiarita.saga.jp",
    "ogi.saga.jp",
    "omachi.saga.jp",
    "ouchi.saga.jp",
    "saga.saga.jp",
    "shiroishi.saga.jp",
    "taku.saga.jp",
    "tara.saga.jp",
    "tosu.saga.jp",
    "yoshinogari.saga.jp",
    "arakawa.saitama.jp",
    "asaka.saitama.jp",
    "chichibu.saitama.jp",
    "fujimi.saitama.jp",
    "fujimino.saitama.jp",
    "fukaya.saitama.jp",
    "hanno.saitama.jp",
    "hanyu.saitama.jp",
    "hasuda.saitama.jp",
    "hatogaya.saitama.jp",
    "hatoyama.saitama.jp",
    "hidaka.saitama.jp",
    "higashichichibu.saitama.jp",
    "higashimatsuyama.saitama.jp",
    "honjo.saitama.jp",
    "ina.saitama.jp",
    "iruma.saitama.jp",
    "iwatsuki.saitama.jp",
    "kamiizumi.saitama.jp",
    "kamikawa.saitama.jp",
    "kamisato.saitama.jp",
    "kasukabe.saitama.jp",
    "kawagoe.saitama.jp",
    "kawaguchi.saitama.jp",
    "kawajima.saitama.jp",
    "kazo.saitama.jp",
    "kitamoto.saitama.jp",
    "koshigaya.saitama.jp",
    "kounosu.saitama.jp",
    "kuki.saitama.jp",
    "kumagaya.saitama.jp",
    "matsubushi.saitama.jp",
    "minano.saitama.jp",
    "misato.saitama.jp",
    "miyashiro.saitama.jp",
    "miyoshi.saitama.jp",
    "moroyama.saitama.jp",
    "nagatoro.saitama.jp",
    "namegawa.saitama.jp",
    "niiza.saitama.jp",
    "ogano.saitama.jp",
    "ogawa.saitama.jp",
    "ogose.saitama.jp",
    "okegawa.saitama.jp",
    "omiya.saitama.jp",
    "otaki.saitama.jp",
    "ranzan.saitama.jp",
    "ryokami.saitama.jp",
    "saitama.saitama.jp",
    "sakado.saitama.jp",
    "satte.saitama.jp",
    "sayama.saitama.jp",
    "shiki.saitama.jp",
    "shiraoka.saitama.jp",
    "soka.saitama.jp",
    "sugito.saitama.jp",
    "toda.saitama.jp",
    "tokigawa.saitama.jp",
    "tokorozawa.saitama.jp",
    "tsurugashima.saitama.jp",
    "urawa.saitama.jp",
    "warabi.saitama.jp",
    "yashio.saitama.jp",
    "yokoze.saitama.jp",
    "yono.saitama.jp",
    "yorii.saitama.jp",
    "yoshida.saitama.jp",
    "yoshikawa.saitama.jp",
    "yoshimi.saitama.jp",
    "aisho.shiga.jp",
    "gamo.shiga.jp",
    "higashiomi.shiga.jp",
    "hikone.shiga.jp",
    "koka.shiga.jp",
    "konan.shiga.jp",
    "kosei.shiga.jp",
    "koto.shiga.jp",
    "kusatsu.shiga.jp",
    "maibara.shiga.jp",
    "moriyama.shiga.jp",
    "nagahama.shiga.jp",
    "nishiazai.shiga.jp",
    "notogawa.shiga.jp",
    "omihachiman.shiga.jp",
    "otsu.shiga.jp",
    "ritto.shiga.jp",
    "ryuoh.shiga.jp",
    "takashima.shiga.jp",
    "takatsuki.shiga.jp",
    "torahime.shiga.jp",
    "toyosato.shiga.jp",
    "yasu.shiga.jp",
    "akagi.shimane.jp",
    "ama.shimane.jp",
    "gotsu.shimane.jp",
    "hamada.shimane.jp",
    "higashiizumo.shimane.jp",
    "hikawa.shimane.jp",
    "hikimi.shimane.jp",
    "izumo.shimane.jp",
    "kakinoki.shimane.jp",
    "masuda.shimane.jp",
    "matsue.shimane.jp",
    "misato.shimane.jp",
    "nishinoshima.shimane.jp",
    "ohda.shimane.jp",
    "okinoshima.shimane.jp",
    "okuizumo.shimane.jp",
    "shimane.shimane.jp",
    "tamayu.shimane.jp",
    "tsuwano.shimane.jp",
    "unnan.shimane.jp",
    "yakumo.shimane.jp",
    "yasugi.shimane.jp",
    "yatsuka.shimane.jp",
    "arai.shizuoka.jp",
    "atami.shizuoka.jp",
    "fuji.shizuoka.jp",
    "fujieda.shizuoka.jp",
    "fujikawa.shizuoka.jp",
    "fujinomiya.shizuoka.jp",
    "fukuroi.shizuoka.jp",
    "gotemba.shizuoka.jp",
    "haibara.shizuoka.jp",
    "hamamatsu.shizuoka.jp",
    "higashiizu.shizuoka.jp",
    "ito.shizuoka.jp",
    "iwata.shizuoka.jp",
    "izu.shizuoka.jp",
    "izunokuni.shizuoka.jp",
    "kakegawa.shizuoka.jp",
    "kannami.shizuoka.jp",
    "kawanehon.shizuoka.jp",
    "kawazu.shizuoka.jp",
    "kikugawa.shizuoka.jp",
    "kosai.shizuoka.jp",
    "makinohara.shizuoka.jp",
    "matsuzaki.shizuoka.jp",
    "minamiizu.shizuoka.jp",
    "mishima.shizuoka.jp",
    "morimachi.shizuoka.jp",
    "nishiizu.shizuoka.jp",
    "numazu.shizuoka.jp",
    "omaezaki.shizuoka.jp",
    "shimada.shizuoka.jp",
    "shimizu.shizuoka.jp",
    "shimoda.shizuoka.jp",
    "shizuoka.shizuoka.jp",
    "susono.shizuoka.jp",
    "yaizu.shizuoka.jp",
    "yoshida.shizuoka.jp",
    "ashikaga.tochigi.jp",
    "bato.tochigi.jp",
    "haga.tochigi.jp",
    "ichikai.tochigi.jp",
    "iwafune.tochigi.jp",
    "kaminokawa.tochigi.jp",
    "kanuma.tochigi.jp",
    "karasuyama.tochigi.jp",
    "kuroiso.tochigi.jp",
    "mashiko.tochigi.jp",
    "mibu.tochigi.jp",
    "moka.tochigi.jp",
    "motegi.tochigi.jp",
    "nasu.tochigi.jp",
    "nasushiobara.tochigi.jp",
    "nikko.tochigi.jp",
    "nishikata.tochigi.jp",
    "nogi.tochigi.jp",
    "ohira.tochigi.jp",
    "ohtawara.tochigi.jp",
    "oyama.tochigi.jp",
    "sakura.tochigi.jp",
    "sano.tochigi.jp",
    "shimotsuke.tochigi.jp",
    "shioya.tochigi.jp",
    "takanezawa.tochigi.jp",
    "tochigi.tochigi.jp",
    "tsuga.tochigi.jp",
    "ujiie.tochigi.jp",
    "utsunomiya.tochigi.jp",
    "yaita.tochigi.jp",
    "aizumi.tokushima.jp",
    "anan.tokushima.jp",
    "ichiba.tokushima.jp",
    "itano.tokushima.jp",
    "kainan.tokushima.jp",
    "komatsushima.tokushima.jp",
    "matsushige.tokushima.jp",
    "mima.tokushima.jp",
    "minami.tokushima.jp",
    "miyoshi.tokushima.jp",
    "mugi.tokushima.jp",
    "nakagawa.tokushima.jp",
    "naruto.tokushima.jp",
    "sanagochi.tokushima.jp",
    "shishikui.tokushima.jp",
    "tokushima.tokushima.jp",
    "wajiki.tokushima.jp",
    "adachi.tokyo.jp",
    "akiruno.tokyo.jp",
    "akishima.tokyo.jp",
    "aogashima.tokyo.jp",
    "arakawa.tokyo.jp",
    "bunkyo.tokyo.jp",
    "chiyoda.tokyo.jp",
    "chofu.tokyo.jp",
    "chuo.tokyo.jp",
    "edogawa.tokyo.jp",
    "fuchu.tokyo.jp",
    "fussa.tokyo.jp",
    "hachijo.tokyo.jp",
    "hachioji.tokyo.jp",
    "hamura.tokyo.jp",
    "higashikurume.tokyo.jp",
    "higashimurayama.tokyo.jp",
    "higashiyamato.tokyo.jp",
    "hino.tokyo.jp",
    "hinode.tokyo.jp",
    "hinohara.tokyo.jp",
    "inagi.tokyo.jp",
    "itabashi.tokyo.jp",
    "katsushika.tokyo.jp",
    "kita.tokyo.jp",
    "kiyose.tokyo.jp",
    "kodaira.tokyo.jp",
    "koganei.tokyo.jp",
    "kokubunji.tokyo.jp",
    "komae.tokyo.jp",
    "koto.tokyo.jp",
    "kouzushima.tokyo.jp",
    "kunitachi.tokyo.jp",
    "machida.tokyo.jp",
    "meguro.tokyo.jp",
    "minato.tokyo.jp",
    "mitaka.tokyo.jp",
    "mizuho.tokyo.jp",
    "musashimurayama.tokyo.jp",
    "musashino.tokyo.jp",
    "nakano.tokyo.jp",
    "nerima.tokyo.jp",
    "ogasawara.tokyo.jp",
    "okutama.tokyo.jp",
    "ome.tokyo.jp",
    "oshima.tokyo.jp",
    "ota.tokyo.jp",
    "setagaya.tokyo.jp",
    "shibuya.tokyo.jp",
    "shinagawa.tokyo.jp",
    "shinjuku.tokyo.jp",
    "suginami.tokyo.jp",
    "sumida.tokyo.jp",
    "tachikawa.tokyo.jp",
    "taito.tokyo.jp",
    "tama.tokyo.jp",
    "toshima.tokyo.jp",
    "chizu.tottori.jp",
    "hino.tottori.jp",
    "kawahara.tottori.jp",
    "koge.tottori.jp",
    "kotoura.tottori.jp",
    "misasa.tottori.jp",
    "nanbu.tottori.jp",
    "nichinan.tottori.jp",
    "sakaiminato.tottori.jp",
    "tottori.tottori.jp",
    "wakasa.tottori.jp",
    "yazu.tottori.jp",
    "yonago.tottori.jp",
    "asahi.toyama.jp",
    "fuchu.toyama.jp",
    "fukumitsu.toyama.jp",
    "funahashi.toyama.jp",
    "himi.toyama.jp",
    "imizu.toyama.jp",
    "inami.toyama.jp",
    "johana.toyama.jp",
    "kamiichi.toyama.jp",
    "kurobe.toyama.jp",
    "nakaniikawa.toyama.jp",
    "namerikawa.toyama.jp",
    "nanto.toyama.jp",
    "nyuzen.toyama.jp",
    "oyabe.toyama.jp",
    "taira.toyama.jp",
    "takaoka.toyama.jp",
    "tateyama.toyama.jp",
    "toga.toyama.jp",
    "tonami.toyama.jp",
    "toyama.toyama.jp",
    "unazuki.toyama.jp",
    "uozu.toyama.jp",
    "yamada.toyama.jp",
    "arida.wakayama.jp",
    "aridagawa.wakayama.jp",
    "gobo.wakayama.jp",
    "hashimoto.wakayama.jp",
    "hidaka.wakayama.jp",
    "hirogawa.wakayama.jp",
    "inami.wakayama.jp",
    "iwade.wakayama.jp",
    "kainan.wakayama.jp",
    "kamitonda.wakayama.jp",
    "katsuragi.wakayama.jp",
    "kimino.wakayama.jp",
    "kinokawa.wakayama.jp",
    "kitayama.wakayama.jp",
    "koya.wakayama.jp",
    "koza.wakayama.jp",
    "kozagawa.wakayama.jp",
    "kudoyama.wakayama.jp",
    "kushimoto.wakayama.jp",
    "mihama.wakayama.jp",
    "misato.wakayama.jp",
    "nachikatsuura.wakayama.jp",
    "shingu.wakayama.jp",
    "shirahama.wakayama.jp",
    "taiji.wakayama.jp",
    "tanabe.wakayama.jp",
    "wakayama.wakayama.jp",
    "yuasa.wakayama.jp",
    "yura.wakayama.jp",
    "asahi.yamagata.jp",
    "funagata.yamagata.jp",
    "higashine.yamagata.jp",
    "iide.yamagata.jp",
    "kahoku.yamagata.jp",
    "kaminoyama.yamagata.jp",
    "kaneyama.yamagata.jp",
    "kawanishi.yamagata.jp",
    "mamurogawa.yamagata.jp",
    "mikawa.yamagata.jp",
    "murayama.yamagata.jp",
    "nagai.yamagata.jp",
    "nakayama.yamagata.jp",
    "nanyo.yamagata.jp",
    "nishikawa.yamagata.jp",
    "obanazawa.yamagata.jp",
    "oe.yamagata.jp",
    "oguni.yamagata.jp",
    "ohkura.yamagata.jp",
    "oishida.yamagata.jp",
    "sagae.yamagata.jp",
    "sakata.yamagata.jp",
    "sakegawa.yamagata.jp",
    "shinjo.yamagata.jp",
    "shirataka.yamagata.jp",
    "shonai.yamagata.jp",
    "takahata.yamagata.jp",
    "tendo.yamagata.jp",
    "tozawa.yamagata.jp",
    "tsuruoka.yamagata.jp",
    "yamagata.yamagata.jp",
    "yamanobe.yamagata.jp",
    "yonezawa.yamagata.jp",
    "yuza.yamagata.jp",
    "abu.yamaguchi.jp",
    "hagi.yamaguchi.jp",
    "hikari.yamaguchi.jp",
    "hofu.yamaguchi.jp",
    "iwakuni.yamaguchi.jp",
    "kudamatsu.yamaguchi.jp",
    "mitou.yamaguchi.jp",
    "nagato.yamaguchi.jp",
    "oshima.yamaguchi.jp",
    "shimonoseki.yamaguchi.jp",
    "shunan.yamaguchi.jp",
    "tabuse.yamaguchi.jp",
    "tokuyama.yamaguchi.jp",
    "toyota.yamaguchi.jp",
    "ube.yamaguchi.jp",
    "yuu.yamaguchi.jp",
    "chuo.yamanashi.jp",
    "doshi.yamanashi.jp",
    "fuefuki.yamanashi.jp",
    "fujikawa.yamanashi.jp",
    "fujikawaguchiko.yamanashi.jp",
    "fujiyoshida.yamanashi.jp",
    "hayakawa.yamanashi.jp",
    "hokuto.yamanashi.jp",
    "ichikawamisato.yamanashi.jp",
    "kai.yamanashi.jp",
    "kofu.yamanashi.jp",
    "koshu.yamanashi.jp",
    "kosuge.yamanashi.jp",
    "minami-alps.yamanashi.jp",
    "minobu.yamanashi.jp",
    "nakamichi.yamanashi.jp",
    "nanbu.yamanashi.jp",
    "narusawa.yamanashi.jp",
    "nirasaki.yamanashi.jp",
    "nishikatsura.yamanashi.jp",
    "oshino.yamanashi.jp",
    "otsuki.yamanashi.jp",
    "showa.yamanashi.jp",
    "tabayama.yamanashi.jp",
    "tsuru.yamanashi.jp",
    "uenohara.yamanashi.jp",
    "yamanakako.yamanashi.jp",
    "yamanashi.yamanashi.jp",
    "ke",
    "ac.ke",
    "co.ke",
    "go.ke",
    "info.ke",
    "me.ke",
    "mobi.ke",
    "ne.ke",
    "or.ke",
    "sc.ke",
    "kg",
    "org.kg",
    "net.kg",
    "com.kg",
    "edu.kg",
    "gov.kg",
    "mil.kg",
    "*.kh",
    "ki",
    "edu.ki",
    "biz.ki",
    "net.ki",
    "org.ki",
    "gov.ki",
    "info.ki",
    "com.ki",
    "km",
    "org.km",
    "nom.km",
    "gov.km",
    "prd.km",
    "tm.km",
    "edu.km",
    "mil.km",
    "ass.km",
    "com.km",
    "coop.km",
    "asso.km",
    "presse.km",
    "medecin.km",
    "notaires.km",
    "pharmaciens.km",
    "veterinaire.km",
    "gouv.km",
    "kn",
    "net.kn",
    "org.kn",
    "edu.kn",
    "gov.kn",
    "kp",
    "com.kp",
    "edu.kp",
    "gov.kp",
    "org.kp",
    "rep.kp",
    "tra.kp",
    "kr",
    "ac.kr",
    "co.kr",
    "es.kr",
    "go.kr",
    "hs.kr",
    "kg.kr",
    "mil.kr",
    "ms.kr",
    "ne.kr",
    "or.kr",
    "pe.kr",
    "re.kr",
    "sc.kr",
    "busan.kr",
    "chungbuk.kr",
    "chungnam.kr",
    "daegu.kr",
    "daejeon.kr",
    "gangwon.kr",
    "gwangju.kr",
    "gyeongbuk.kr",
    "gyeonggi.kr",
    "gyeongnam.kr",
    "incheon.kr",
    "jeju.kr",
    "jeonbuk.kr",
    "jeonnam.kr",
    "seoul.kr",
    "ulsan.kr",
    "kw",
    "com.kw",
    "edu.kw",
    "emb.kw",
    "gov.kw",
    "ind.kw",
    "net.kw",
    "org.kw",
    "ky",
    "com.ky",
    "edu.ky",
    "net.ky",
    "org.ky",
    "kz",
    "org.kz",
    "edu.kz",
    "net.kz",
    "gov.kz",
    "mil.kz",
    "com.kz",
    "la",
    "int.la",
    "net.la",
    "info.la",
    "edu.la",
    "gov.la",
    "per.la",
    "com.la",
    "org.la",
    "lb",
    "com.lb",
    "edu.lb",
    "gov.lb",
    "net.lb",
    "org.lb",
    "lc",
    "com.lc",
    "net.lc",
    "co.lc",
    "org.lc",
    "edu.lc",
    "gov.lc",
    "li",
    "lk",
    "gov.lk",
    "sch.lk",
    "net.lk",
    "int.lk",
    "com.lk",
    "org.lk",
    "edu.lk",
    "ngo.lk",
    "soc.lk",
    "web.lk",
    "ltd.lk",
    "assn.lk",
    "grp.lk",
    "hotel.lk",
    "ac.lk",
    "lr",
    "com.lr",
    "edu.lr",
    "gov.lr",
    "org.lr",
    "net.lr",
    "ls",
    "ac.ls",
    "biz.ls",
    "co.ls",
    "edu.ls",
    "gov.ls",
    "info.ls",
    "net.ls",
    "org.ls",
    "sc.ls",
    "lt",
    "gov.lt",
    "lu",
    "lv",
    "com.lv",
    "edu.lv",
    "gov.lv",
    "org.lv",
    "mil.lv",
    "id.lv",
    "net.lv",
    "asn.lv",
    "conf.lv",
    "ly",
    "com.ly",
    "net.ly",
    "gov.ly",
    "plc.ly",
    "edu.ly",
    "sch.ly",
    "med.ly",
    "org.ly",
    "id.ly",
    "ma",
    "co.ma",
    "net.ma",
    "gov.ma",
    "org.ma",
    "ac.ma",
    "press.ma",
    "mc",
    "tm.mc",
    "asso.mc",
    "md",
    "me",
    "co.me",
    "net.me",
    "org.me",
    "edu.me",
    "ac.me",
    "gov.me",
    "its.me",
    "priv.me",
    "mg",
    "org.mg",
    "nom.mg",
    "gov.mg",
    "prd.mg",
    "tm.mg",
    "edu.mg",
    "mil.mg",
    "com.mg",
    "co.mg",
    "mh",
    "mil",
    "mk",
    "com.mk",
    "org.mk",
    "net.mk",
    "edu.mk",
    "gov.mk",
    "inf.mk",
    "name.mk",
    "ml",
    "com.ml",
    "edu.ml",
    "gouv.ml",
    "gov.ml",
    "net.ml",
    "org.ml",
    "presse.ml",
    "*.mm",
    "mn",
    "gov.mn",
    "edu.mn",
    "org.mn",
    "mo",
    "com.mo",
    "net.mo",
    "org.mo",
    "edu.mo",
    "gov.mo",
    "mobi",
    "mp",
    "mq",
    "mr",
    "gov.mr",
    "ms",
    "com.ms",
    "edu.ms",
    "gov.ms",
    "net.ms",
    "org.ms",
    "mt",
    "com.mt",
    "edu.mt",
    "net.mt",
    "org.mt",
    "mu",
    "com.mu",
    "net.mu",
    "org.mu",
    "gov.mu",
    "ac.mu",
    "co.mu",
    "or.mu",
    "museum",
    "academy.museum",
    "agriculture.museum",
    "air.museum",
    "airguard.museum",
    "alabama.museum",
    "alaska.museum",
    "amber.museum",
    "ambulance.museum",
    "american.museum",
    "americana.museum",
    "americanantiques.museum",
    "americanart.museum",
    "amsterdam.museum",
    "and.museum",
    "annefrank.museum",
    "anthro.museum",
    "anthropology.museum",
    "antiques.museum",
    "aquarium.museum",
    "arboretum.museum",
    "archaeological.museum",
    "archaeology.museum",
    "architecture.museum",
    "art.museum",
    "artanddesign.museum",
    "artcenter.museum",
    "artdeco.museum",
    "arteducation.museum",
    "artgallery.museum",
    "arts.museum",
    "artsandcrafts.museum",
    "asmatart.museum",
    "assassination.museum",
    "assisi.museum",
    "association.museum",
    "astronomy.museum",
    "atlanta.museum",
    "austin.museum",
    "australia.museum",
    "automotive.museum",
    "aviation.museum",
    "axis.museum",
    "badajoz.museum",
    "baghdad.museum",
    "bahn.museum",
    "bale.museum",
    "baltimore.museum",
    "barcelona.museum",
    "baseball.museum",
    "basel.museum",
    "baths.museum",
    "bauern.museum",
    "beauxarts.museum",
    "beeldengeluid.museum",
    "bellevue.museum",
    "bergbau.museum",
    "berkeley.museum",
    "berlin.museum",
    "bern.museum",
    "bible.museum",
    "bilbao.museum",
    "bill.museum",
    "birdart.museum",
    "birthplace.museum",
    "bonn.museum",
    "boston.museum",
    "botanical.museum",
    "botanicalgarden.museum",
    "botanicgarden.museum",
    "botany.museum",
    "brandywinevalley.museum",
    "brasil.museum",
    "bristol.museum",
    "british.museum",
    "britishcolumbia.museum",
    "broadcast.museum",
    "brunel.museum",
    "brussel.museum",
    "brussels.museum",
    "bruxelles.museum",
    "building.museum",
    "burghof.museum",
    "bus.museum",
    "bushey.museum",
    "cadaques.museum",
    "california.museum",
    "cambridge.museum",
    "can.museum",
    "canada.museum",
    "capebreton.museum",
    "carrier.museum",
    "cartoonart.museum",
    "casadelamoneda.museum",
    "castle.museum",
    "castres.museum",
    "celtic.museum",
    "center.museum",
    "chattanooga.museum",
    "cheltenham.museum",
    "chesapeakebay.museum",
    "chicago.museum",
    "children.museum",
    "childrens.museum",
    "childrensgarden.museum",
    "chiropractic.museum",
    "chocolate.museum",
    "christiansburg.museum",
    "cincinnati.museum",
    "cinema.museum",
    "circus.museum",
    "civilisation.museum",
    "civilization.museum",
    "civilwar.museum",
    "clinton.museum",
    "clock.museum",
    "coal.museum",
    "coastaldefence.museum",
    "cody.museum",
    "coldwar.museum",
    "collection.museum",
    "colonialwilliamsburg.museum",
    "coloradoplateau.museum",
    "columbia.museum",
    "columbus.museum",
    "communication.museum",
    "communications.museum",
    "community.museum",
    "computer.museum",
    "computerhistory.museum",
    "comunicações.museum",
    "contemporary.museum",
    "contemporaryart.museum",
    "convent.museum",
    "copenhagen.museum",
    "corporation.museum",
    "correios-e-telecomunicações.museum",
    "corvette.museum",
    "costume.museum",
    "countryestate.museum",
    "county.museum",
    "crafts.museum",
    "cranbrook.museum",
    "creation.museum",
    "cultural.museum",
    "culturalcenter.museum",
    "culture.museum",
    "cyber.museum",
    "cymru.museum",
    "dali.museum",
    "dallas.museum",
    "database.museum",
    "ddr.museum",
    "decorativearts.museum",
    "delaware.museum",
    "delmenhorst.museum",
    "denmark.museum",
    "depot.museum",
    "design.museum",
    "detroit.museum",
    "dinosaur.museum",
    "discovery.museum",
    "dolls.museum",
    "donostia.museum",
    "durham.museum",
    "eastafrica.museum",
    "eastcoast.museum",
    "education.museum",
    "educational.museum",
    "egyptian.museum",
    "eisenbahn.museum",
    "elburg.museum",
    "elvendrell.museum",
    "embroidery.museum",
    "encyclopedic.museum",
    "england.museum",
    "entomology.museum",
    "environment.museum",
    "environmentalconservation.museum",
    "epilepsy.museum",
    "essex.museum",
    "estate.museum",
    "ethnology.museum",
    "exeter.museum",
    "exhibition.museum",
    "family.museum",
    "farm.museum",
    "farmequipment.museum",
    "farmers.museum",
    "farmstead.museum",
    "field.museum",
    "figueres.museum",
    "filatelia.museum",
    "film.museum",
    "fineart.museum",
    "finearts.museum",
    "finland.museum",
    "flanders.museum",
    "florida.museum",
    "force.museum",
    "fortmissoula.museum",
    "fortworth.museum",
    "foundation.museum",
    "francaise.museum",
    "frankfurt.museum",
    "franziskaner.museum",
    "freemasonry.museum",
    "freiburg.museum",
    "fribourg.museum",
    "frog.museum",
    "fundacio.museum",
    "furniture.museum",
    "gallery.museum",
    "garden.museum",
    "gateway.museum",
    "geelvinck.museum",
    "gemological.museum",
    "geology.museum",
    "georgia.museum",
    "giessen.museum",
    "glas.museum",
    "glass.museum",
    "gorge.museum",
    "grandrapids.museum",
    "graz.museum",
    "guernsey.museum",
    "halloffame.museum",
    "hamburg.museum",
    "handson.museum",
    "harvestcelebration.museum",
    "hawaii.museum",
    "health.museum",
    "heimatunduhren.museum",
    "hellas.museum",
    "helsinki.museum",
    "hembygdsforbund.museum",
    "heritage.museum",
    "histoire.museum",
    "historical.museum",
    "historicalsociety.museum",
    "historichouses.museum",
    "historisch.museum",
    "historisches.museum",
    "history.museum",
    "historyofscience.museum",
    "horology.museum",
    "house.museum",
    "humanities.museum",
    "illustration.museum",
    "imageandsound.museum",
    "indian.museum",
    "indiana.museum",
    "indianapolis.museum",
    "indianmarket.museum",
    "intelligence.museum",
    "interactive.museum",
    "iraq.museum",
    "iron.museum",
    "isleofman.museum",
    "jamison.museum",
    "jefferson.museum",
    "jerusalem.museum",
    "jewelry.museum",
    "jewish.museum",
    "jewishart.museum",
    "jfk.museum",
    "journalism.museum",
    "judaica.museum",
    "judygarland.museum",
    "juedisches.museum",
    "juif.museum",
    "karate.museum",
    "karikatur.museum",
    "kids.museum",
    "koebenhavn.museum",
    "koeln.museum",
    "kunst.museum",
    "kunstsammlung.museum",
    "kunstunddesign.museum",
    "labor.museum",
    "labour.museum",
    "lajolla.museum",
    "lancashire.museum",
    "landes.museum",
    "lans.museum",
    "läns.museum",
    "larsson.museum",
    "lewismiller.museum",
    "lincoln.museum",
    "linz.museum",
    "living.museum",
    "livinghistory.museum",
    "localhistory.museum",
    "london.museum",
    "losangeles.museum",
    "louvre.museum",
    "loyalist.museum",
    "lucerne.museum",
    "luxembourg.museum",
    "luzern.museum",
    "mad.museum",
    "madrid.museum",
    "mallorca.museum",
    "manchester.museum",
    "mansion.museum",
    "mansions.museum",
    "manx.museum",
    "marburg.museum",
    "maritime.museum",
    "maritimo.museum",
    "maryland.museum",
    "marylhurst.museum",
    "media.museum",
    "medical.museum",
    "medizinhistorisches.museum",
    "meeres.museum",
    "memorial.museum",
    "mesaverde.museum",
    "michigan.museum",
    "midatlantic.museum",
    "military.museum",
    "mill.museum",
    "miners.museum",
    "mining.museum",
    "minnesota.museum",
    "missile.museum",
    "missoula.museum",
    "modern.museum",
    "moma.museum",
    "money.museum",
    "monmouth.museum",
    "monticello.museum",
    "montreal.museum",
    "moscow.museum",
    "motorcycle.museum",
    "muenchen.museum",
    "muenster.museum",
    "mulhouse.museum",
    "muncie.museum",
    "museet.museum",
    "museumcenter.museum",
    "museumvereniging.museum",
    "music.museum",
    "national.museum",
    "nationalfirearms.museum",
    "nationalheritage.museum",
    "nativeamerican.museum",
    "naturalhistory.museum",
    "naturalhistorymuseum.museum",
    "naturalsciences.museum",
    "nature.museum",
    "naturhistorisches.museum",
    "natuurwetenschappen.museum",
    "naumburg.museum",
    "naval.museum",
    "nebraska.museum",
    "neues.museum",
    "newhampshire.museum",
    "newjersey.museum",
    "newmexico.museum",
    "newport.museum",
    "newspaper.museum",
    "newyork.museum",
    "niepce.museum",
    "norfolk.museum",
    "north.museum",
    "nrw.museum",
    "nyc.museum",
    "nyny.museum",
    "oceanographic.museum",
    "oceanographique.museum",
    "omaha.museum",
    "online.museum",
    "ontario.museum",
    "openair.museum",
    "oregon.museum",
    "oregontrail.museum",
    "otago.museum",
    "oxford.museum",
    "pacific.museum",
    "paderborn.museum",
    "palace.museum",
    "paleo.museum",
    "palmsprings.museum",
    "panama.museum",
    "paris.museum",
    "pasadena.museum",
    "pharmacy.museum",
    "philadelphia.museum",
    "philadelphiaarea.museum",
    "philately.museum",
    "phoenix.museum",
    "photography.museum",
    "pilots.museum",
    "pittsburgh.museum",
    "planetarium.museum",
    "plantation.museum",
    "plants.museum",
    "plaza.museum",
    "portal.museum",
    "portland.museum",
    "portlligat.museum",
    "posts-and-telecommunications.museum",
    "preservation.museum",
    "presidio.museum",
    "press.museum",
    "project.museum",
    "public.museum",
    "pubol.museum",
    "quebec.museum",
    "railroad.museum",
    "railway.museum",
    "research.museum",
    "resistance.museum",
    "riodejaneiro.museum",
    "rochester.museum",
    "rockart.museum",
    "roma.museum",
    "russia.museum",
    "saintlouis.museum",
    "salem.museum",
    "salvadordali.museum",
    "salzburg.museum",
    "sandiego.museum",
    "sanfrancisco.museum",
    "santabarbara.museum",
    "santacruz.museum",
    "santafe.museum",
    "saskatchewan.museum",
    "satx.museum",
    "savannahga.museum",
    "schlesisches.museum",
    "schoenbrunn.museum",
    "schokoladen.museum",
    "school.museum",
    "schweiz.museum",
    "science.museum",
    "scienceandhistory.museum",
    "scienceandindustry.museum",
    "sciencecenter.museum",
    "sciencecenters.museum",
    "science-fiction.museum",
    "sciencehistory.museum",
    "sciences.museum",
    "sciencesnaturelles.museum",
    "scotland.museum",
    "seaport.museum",
    "settlement.museum",
    "settlers.museum",
    "shell.museum",
    "sherbrooke.museum",
    "sibenik.museum",
    "silk.museum",
    "ski.museum",
    "skole.museum",
    "society.museum",
    "sologne.museum",
    "soundandvision.museum",
    "southcarolina.museum",
    "southwest.museum",
    "space.museum",
    "spy.museum",
    "square.museum",
    "stadt.museum",
    "stalbans.museum",
    "starnberg.museum",
    "state.museum",
    "stateofdelaware.museum",
    "station.museum",
    "steam.museum",
    "steiermark.museum",
    "stjohn.museum",
    "stockholm.museum",
    "stpetersburg.museum",
    "stuttgart.museum",
    "suisse.museum",
    "surgeonshall.museum",
    "surrey.museum",
    "svizzera.museum",
    "sweden.museum",
    "sydney.museum",
    "tank.museum",
    "tcm.museum",
    "technology.museum",
    "telekommunikation.museum",
    "television.museum",
    "texas.museum",
    "textile.museum",
    "theater.museum",
    "time.museum",
    "timekeeping.museum",
    "topology.museum",
    "torino.museum",
    "touch.museum",
    "town.museum",
    "transport.museum",
    "tree.museum",
    "trolley.museum",
    "trust.museum",
    "trustee.museum",
    "uhren.museum",
    "ulm.museum",
    "undersea.museum",
    "university.museum",
    "usa.museum",
    "usantiques.museum",
    "usarts.museum",
    "uscountryestate.museum",
    "usculture.museum",
    "usdecorativearts.museum",
    "usgarden.museum",
    "ushistory.museum",
    "ushuaia.museum",
    "uslivinghistory.museum",
    "utah.museum",
    "uvic.museum",
    "valley.museum",
    "vantaa.museum",
    "versailles.museum",
    "viking.museum",
    "village.museum",
    "virginia.museum",
    "virtual.museum",
    "virtuel.museum",
    "vlaanderen.museum",
    "volkenkunde.museum",
    "wales.museum",
    "wallonie.museum",
    "war.museum",
    "washingtondc.museum",
    "watchandclock.museum",
    "watch-and-clock.museum",
    "western.museum",
    "westfalen.museum",
    "whaling.museum",
    "wildlife.museum",
    "williamsburg.museum",
    "windmill.museum",
    "workshop.museum",
    "york.museum",
    "yorkshire.museum",
    "yosemite.museum",
    "youth.museum",
    "zoological.museum",
    "zoology.museum",
    "ירושלים.museum",
    "иком.museum",
    "mv",
    "aero.mv",
    "biz.mv",
    "com.mv",
    "coop.mv",
    "edu.mv",
    "gov.mv",
    "info.mv",
    "int.mv",
    "mil.mv",
    "museum.mv",
    "name.mv",
    "net.mv",
    "org.mv",
    "pro.mv",
    "mw",
    "ac.mw",
    "biz.mw",
    "co.mw",
    "com.mw",
    "coop.mw",
    "edu.mw",
    "gov.mw",
    "int.mw",
    "museum.mw",
    "net.mw",
    "org.mw",
    "mx",
    "com.mx",
    "org.mx",
    "gob.mx",
    "edu.mx",
    "net.mx",
    "my",
    "biz.my",
    "com.my",
    "edu.my",
    "gov.my",
    "mil.my",
    "name.my",
    "net.my",
    "org.my",
    "mz",
    "ac.mz",
    "adv.mz",
    "co.mz",
    "edu.mz",
    "gov.mz",
    "mil.mz",
    "net.mz",
    "org.mz",
    "na",
    "info.na",
    "pro.na",
    "name.na",
    "school.na",
    "or.na",
    "dr.na",
    "us.na",
    "mx.na",
    "ca.na",
    "in.na",
    "cc.na",
    "tv.na",
    "ws.na",
    "mobi.na",
    "co.na",
    "com.na",
    "org.na",
    "name",
    "nc",
    "asso.nc",
    "nom.nc",
    "ne",
    "net",
    "nf",
    "com.nf",
    "net.nf",
    "per.nf",
    "rec.nf",
    "web.nf",
    "arts.nf",
    "firm.nf",
    "info.nf",
    "other.nf",
    "store.nf",
    "ng",
    "com.ng",
    "edu.ng",
    "gov.ng",
    "i.ng",
    "mil.ng",
    "mobi.ng",
    "name.ng",
    "net.ng",
    "org.ng",
    "sch.ng",
    "ni",
    "ac.ni",
    "biz.ni",
    "co.ni",
    "com.ni",
    "edu.ni",
    "gob.ni",
    "in.ni",
    "info.ni",
    "int.ni",
    "mil.ni",
    "net.ni",
    "nom.ni",
    "org.ni",
    "web.ni",
    "nl",
    "no",
    "fhs.no",
    "vgs.no",
    "fylkesbibl.no",
    "folkebibl.no",
    "museum.no",
    "idrett.no",
    "priv.no",
    "mil.no",
    "stat.no",
    "dep.no",
    "kommune.no",
    "herad.no",
    "aa.no",
    "ah.no",
    "bu.no",
    "fm.no",
    "hl.no",
    "hm.no",
    "jan-mayen.no",
    "mr.no",
    "nl.no",
    "nt.no",
    "of.no",
    "ol.no",
    "oslo.no",
    "rl.no",
    "sf.no",
    "st.no",
    "svalbard.no",
    "tm.no",
    "tr.no",
    "va.no",
    "vf.no",
    "gs.aa.no",
    "gs.ah.no",
    "gs.bu.no",
    "gs.fm.no",
    "gs.hl.no",
    "gs.hm.no",
    "gs.jan-mayen.no",
    "gs.mr.no",
    "gs.nl.no",
    "gs.nt.no",
    "gs.of.no",
    "gs.ol.no",
    "gs.oslo.no",
    "gs.rl.no",
    "gs.sf.no",
    "gs.st.no",
    "gs.svalbard.no",
    "gs.tm.no",
    "gs.tr.no",
    "gs.va.no",
    "gs.vf.no",
    "akrehamn.no",
    "åkrehamn.no",
    "algard.no",
    "ålgård.no",
    "arna.no",
    "brumunddal.no",
    "bryne.no",
    "bronnoysund.no",
    "brønnøysund.no",
    "drobak.no",
    "drøbak.no",
    "egersund.no",
    "fetsund.no",
    "floro.no",
    "florø.no",
    "fredrikstad.no",
    "hokksund.no",
    "honefoss.no",
    "hønefoss.no",
    "jessheim.no",
    "jorpeland.no",
    "jørpeland.no",
    "kirkenes.no",
    "kopervik.no",
    "krokstadelva.no",
    "langevag.no",
    "langevåg.no",
    "leirvik.no",
    "mjondalen.no",
    "mjøndalen.no",
    "mo-i-rana.no",
    "mosjoen.no",
    "mosjøen.no",
    "nesoddtangen.no",
    "orkanger.no",
    "osoyro.no",
    "osøyro.no",
    "raholt.no",
    "råholt.no",
    "sandnessjoen.no",
    "sandnessjøen.no",
    "skedsmokorset.no",
    "slattum.no",
    "spjelkavik.no",
    "stathelle.no",
    "stavern.no",
    "stjordalshalsen.no",
    "stjørdalshalsen.no",
    "tananger.no",
    "tranby.no",
    "vossevangen.no",
    "afjord.no",
    "åfjord.no",
    "agdenes.no",
    "al.no",
    "ål.no",
    "alesund.no",
    "ålesund.no",
    "alstahaug.no",
    "alta.no",
    "áltá.no",
    "alaheadju.no",
    "álaheadju.no",
    "alvdal.no",
    "amli.no",
    "åmli.no",
    "amot.no",
    "åmot.no",
    "andebu.no",
    "andoy.no",
    "andøy.no",
    "andasuolo.no",
    "ardal.no",
    "årdal.no",
    "aremark.no",
    "arendal.no",
    "ås.no",
    "aseral.no",
    "åseral.no",
    "asker.no",
    "askim.no",
    "askvoll.no",
    "askoy.no",
    "askøy.no",
    "asnes.no",
    "åsnes.no",
    "audnedaln.no",
    "aukra.no",
    "aure.no",
    "aurland.no",
    "aurskog-holand.no",
    "aurskog-høland.no",
    "austevoll.no",
    "austrheim.no",
    "averoy.no",
    "averøy.no",
    "balestrand.no",
    "ballangen.no",
    "balat.no",
    "bálát.no",
    "balsfjord.no",
    "bahccavuotna.no",
    "báhccavuotna.no",
    "bamble.no",
    "bardu.no",
    "beardu.no",
    "beiarn.no",
    "bajddar.no",
    "bájddar.no",
    "baidar.no",
    "báidár.no",
    "berg.no",
    "bergen.no",
    "berlevag.no",
    "berlevåg.no",
    "bearalvahki.no",
    "bearalváhki.no",
    "bindal.no",
    "birkenes.no",
    "bjarkoy.no",
    "bjarkøy.no",
    "bjerkreim.no",
    "bjugn.no",
    "bodo.no",
    "bodø.no",
    "badaddja.no",
    "bådåddjå.no",
    "budejju.no",
    "bokn.no",
    "bremanger.no",
    "bronnoy.no",
    "brønnøy.no",
    "bygland.no",
    "bykle.no",
    "barum.no",
    "bærum.no",
    "bo.telemark.no",
    "bø.telemark.no",
    "bo.nordland.no",
    "bø.nordland.no",
    "bievat.no",
    "bievát.no",
    "bomlo.no",
    "bømlo.no",
    "batsfjord.no",
    "båtsfjord.no",
    "bahcavuotna.no",
    "báhcavuotna.no",
    "dovre.no",
    "drammen.no",
    "drangedal.no",
    "dyroy.no",
    "dyrøy.no",
    "donna.no",
    "dønna.no",
    "eid.no",
    "eidfjord.no",
    "eidsberg.no",
    "eidskog.no",
    "eidsvoll.no",
    "eigersund.no",
    "elverum.no",
    "enebakk.no",
    "engerdal.no",
    "etne.no",
    "etnedal.no",
    "evenes.no",
    "evenassi.no",
    "evenášši.no",
    "evje-og-hornnes.no",
    "farsund.no",
    "fauske.no",
    "fuossko.no",
    "fuoisku.no",
    "fedje.no",
    "fet.no",
    "finnoy.no",
    "finnøy.no",
    "fitjar.no",
    "fjaler.no",
    "fjell.no",
    "flakstad.no",
    "flatanger.no",
    "flekkefjord.no",
    "flesberg.no",
    "flora.no",
    "fla.no",
    "flå.no",
    "folldal.no",
    "forsand.no",
    "fosnes.no",
    "frei.no",
    "frogn.no",
    "froland.no",
    "frosta.no",
    "frana.no",
    "fræna.no",
    "froya.no",
    "frøya.no",
    "fusa.no",
    "fyresdal.no",
    "forde.no",
    "førde.no",
    "gamvik.no",
    "gangaviika.no",
    "gáŋgaviika.no",
    "gaular.no",
    "gausdal.no",
    "gildeskal.no",
    "gildeskål.no",
    "giske.no",
    "gjemnes.no",
    "gjerdrum.no",
    "gjerstad.no",
    "gjesdal.no",
    "gjovik.no",
    "gjøvik.no",
    "gloppen.no",
    "gol.no",
    "gran.no",
    "grane.no",
    "granvin.no",
    "gratangen.no",
    "grimstad.no",
    "grong.no",
    "kraanghke.no",
    "kråanghke.no",
    "grue.no",
    "gulen.no",
    "hadsel.no",
    "halden.no",
    "halsa.no",
    "hamar.no",
    "hamaroy.no",
    "habmer.no",
    "hábmer.no",
    "hapmir.no",
    "hápmir.no",
    "hammerfest.no",
    "hammarfeasta.no",
    "hámmárfeasta.no",
    "haram.no",
    "hareid.no",
    "harstad.no",
    "hasvik.no",
    "aknoluokta.no",
    "ákŋoluokta.no",
    "hattfjelldal.no",
    "aarborte.no",
    "haugesund.no",
    "hemne.no",
    "hemnes.no",
    "hemsedal.no",
    "heroy.more-og-romsdal.no",
    "herøy.møre-og-romsdal.no",
    "heroy.nordland.no",
    "herøy.nordland.no",
    "hitra.no",
    "hjartdal.no",
    "hjelmeland.no",
    "hobol.no",
    "hobøl.no",
    "hof.no",
    "hol.no",
    "hole.no",
    "holmestrand.no",
    "holtalen.no",
    "holtålen.no",
    "hornindal.no",
    "horten.no",
    "hurdal.no",
    "hurum.no",
    "hvaler.no",
    "hyllestad.no",
    "hagebostad.no",
    "hægebostad.no",
    "hoyanger.no",
    "høyanger.no",
    "hoylandet.no",
    "høylandet.no",
    "ha.no",
    "hå.no",
    "ibestad.no",
    "inderoy.no",
    "inderøy.no",
    "iveland.no",
    "jevnaker.no",
    "jondal.no",
    "jolster.no",
    "jølster.no",
    "karasjok.no",
    "karasjohka.no",
    "kárášjohka.no",
    "karlsoy.no",
    "galsa.no",
    "gálsá.no",
    "karmoy.no",
    "karmøy.no",
    "kautokeino.no",
    "guovdageaidnu.no",
    "klepp.no",
    "klabu.no",
    "klæbu.no",
    "kongsberg.no",
    "kongsvinger.no",
    "kragero.no",
    "kragerø.no",
    "kristiansand.no",
    "kristiansund.no",
    "krodsherad.no",
    "krødsherad.no",
    "kvalsund.no",
    "rahkkeravju.no",
    "ráhkkerávju.no",
    "kvam.no",
    "kvinesdal.no",
    "kvinnherad.no",
    "kviteseid.no",
    "kvitsoy.no",
    "kvitsøy.no",
    "kvafjord.no",
    "kvæfjord.no",
    "giehtavuoatna.no",
    "kvanangen.no",
    "kvænangen.no",
    "navuotna.no",
    "návuotna.no",
    "kafjord.no",
    "kåfjord.no",
    "gaivuotna.no",
    "gáivuotna.no",
    "larvik.no",
    "lavangen.no",
    "lavagis.no",
    "loabat.no",
    "loabát.no",
    "lebesby.no",
    "davvesiida.no",
    "leikanger.no",
    "leirfjord.no",
    "leka.no",
    "leksvik.no",
    "lenvik.no",
    "leangaviika.no",
    "leaŋgaviika.no",
    "lesja.no",
    "levanger.no",
    "lier.no",
    "lierne.no",
    "lillehammer.no",
    "lillesand.no",
    "lindesnes.no",
    "lindas.no",
    "lindås.no",
    "lom.no",
    "loppa.no",
    "lahppi.no",
    "láhppi.no",
    "lund.no",
    "lunner.no",
    "luroy.no",
    "lurøy.no",
    "luster.no",
    "lyngdal.no",
    "lyngen.no",
    "ivgu.no",
    "lardal.no",
    "lerdal.no",
    "lærdal.no",
    "lodingen.no",
    "lødingen.no",
    "lorenskog.no",
    "lørenskog.no",
    "loten.no",
    "løten.no",
    "malvik.no",
    "masoy.no",
    "måsøy.no",
    "muosat.no",
    "muosát.no",
    "mandal.no",
    "marker.no",
    "marnardal.no",
    "masfjorden.no",
    "meland.no",
    "meldal.no",
    "melhus.no",
    "meloy.no",
    "meløy.no",
    "meraker.no",
    "meråker.no",
    "moareke.no",
    "moåreke.no",
    "midsund.no",
    "midtre-gauldal.no",
    "modalen.no",
    "modum.no",
    "molde.no",
    "moskenes.no",
    "moss.no",
    "mosvik.no",
    "malselv.no",
    "målselv.no",
    "malatvuopmi.no",
    "málatvuopmi.no",
    "namdalseid.no",
    "aejrie.no",
    "namsos.no",
    "namsskogan.no",
    "naamesjevuemie.no",
    "nååmesjevuemie.no",
    "laakesvuemie.no",
    "nannestad.no",
    "narvik.no",
    "narviika.no",
    "naustdal.no",
    "nedre-eiker.no",
    "nes.akershus.no",
    "nes.buskerud.no",
    "nesna.no",
    "nesodden.no",
    "nesseby.no",
    "unjarga.no",
    "unjárga.no",
    "nesset.no",
    "nissedal.no",
    "nittedal.no",
    "nord-aurdal.no",
    "nord-fron.no",
    "nord-odal.no",
    "norddal.no",
    "nordkapp.no",
    "davvenjarga.no",
    "davvenjárga.no",
    "nordre-land.no",
    "nordreisa.no",
    "raisa.no",
    "ráisa.no",
    "nore-og-uvdal.no",
    "notodden.no",
    "naroy.no",
    "nærøy.no",
    "notteroy.no",
    "nøtterøy.no",
    "odda.no",
    "oksnes.no",
    "øksnes.no",
    "oppdal.no",
    "oppegard.no",
    "oppegård.no",
    "orkdal.no",
    "orland.no",
    "ørland.no",
    "orskog.no",
    "ørskog.no",
    "orsta.no",
    "ørsta.no",
    "os.hedmark.no",
    "os.hordaland.no",
    "osen.no",
    "osteroy.no",
    "osterøy.no",
    "ostre-toten.no",
    "østre-toten.no",
    "overhalla.no",
    "ovre-eiker.no",
    "øvre-eiker.no",
    "oyer.no",
    "øyer.no",
    "oygarden.no",
    "øygarden.no",
    "oystre-slidre.no",
    "øystre-slidre.no",
    "porsanger.no",
    "porsangu.no",
    "porsáŋgu.no",
    "porsgrunn.no",
    "radoy.no",
    "radøy.no",
    "rakkestad.no",
    "rana.no",
    "ruovat.no",
    "randaberg.no",
    "rauma.no",
    "rendalen.no",
    "rennebu.no",
    "rennesoy.no",
    "rennesøy.no",
    "rindal.no",
    "ringebu.no",
    "ringerike.no",
    "ringsaker.no",
    "rissa.no",
    "risor.no",
    "risør.no",
    "roan.no",
    "rollag.no",
    "rygge.no",
    "ralingen.no",
    "rælingen.no",
    "rodoy.no",
    "rødøy.no",
    "romskog.no",
    "rømskog.no",
    "roros.no",
    "røros.no",
    "rost.no",
    "røst.no",
    "royken.no",
    "røyken.no",
    "royrvik.no",
    "røyrvik.no",
    "rade.no",
    "råde.no",
    "salangen.no",
    "siellak.no",
    "saltdal.no",
    "salat.no",
    "sálát.no",
    "sálat.no",
    "samnanger.no",
    "sande.more-og-romsdal.no",
    "sande.møre-og-romsdal.no",
    "sande.vestfold.no",
    "sandefjord.no",
    "sandnes.no",
    "sandoy.no",
    "sandøy.no",
    "sarpsborg.no",
    "sauda.no",
    "sauherad.no",
    "sel.no",
    "selbu.no",
    "selje.no",
    "seljord.no",
    "sigdal.no",
    "siljan.no",
    "sirdal.no",
    "skaun.no",
    "skedsmo.no",
    "ski.no",
    "skien.no",
    "skiptvet.no",
    "skjervoy.no",
    "skjervøy.no",
    "skierva.no",
    "skiervá.no",
    "skjak.no",
    "skjåk.no",
    "skodje.no",
    "skanland.no",
    "skånland.no",
    "skanit.no",
    "skánit.no",
    "smola.no",
    "smøla.no",
    "snillfjord.no",
    "snasa.no",
    "snåsa.no",
    "snoasa.no",
    "snaase.no",
    "snåase.no",
    "sogndal.no",
    "sokndal.no",
    "sola.no",
    "solund.no",
    "songdalen.no",
    "sortland.no",
    "spydeberg.no",
    "stange.no",
    "stavanger.no",
    "steigen.no",
    "steinkjer.no",
    "stjordal.no",
    "stjørdal.no",
    "stokke.no",
    "stor-elvdal.no",
    "stord.no",
    "stordal.no",
    "storfjord.no",
    "omasvuotna.no",
    "strand.no",
    "stranda.no",
    "stryn.no",
    "sula.no",
    "suldal.no",
    "sund.no",
    "sunndal.no",
    "surnadal.no",
    "sveio.no",
    "svelvik.no",
    "sykkylven.no",
    "sogne.no",
    "søgne.no",
    "somna.no",
    "sømna.no",
    "sondre-land.no",
    "søndre-land.no",
    "sor-aurdal.no",
    "sør-aurdal.no",
    "sor-fron.no",
    "sør-fron.no",
    "sor-odal.no",
    "sør-odal.no",
    "sor-varanger.no",
    "sør-varanger.no",
    "matta-varjjat.no",
    "mátta-várjjat.no",
    "sorfold.no",
    "sørfold.no",
    "sorreisa.no",
    "sørreisa.no",
    "sorum.no",
    "sørum.no",
    "tana.no",
    "deatnu.no",
    "time.no",
    "tingvoll.no",
    "tinn.no",
    "tjeldsund.no",
    "dielddanuorri.no",
    "tjome.no",
    "tjøme.no",
    "tokke.no",
    "tolga.no",
    "torsken.no",
    "tranoy.no",
    "tranøy.no",
    "tromso.no",
    "tromsø.no",
    "tromsa.no",
    "romsa.no",
    "trondheim.no",
    "troandin.no",
    "trysil.no",
    "trana.no",
    "træna.no",
    "trogstad.no",
    "trøgstad.no",
    "tvedestrand.no",
    "tydal.no",
    "tynset.no",
    "tysfjord.no",
    "divtasvuodna.no",
    "divttasvuotna.no",
    "tysnes.no",
    "tysvar.no",
    "tysvær.no",
    "tonsberg.no",
    "tønsberg.no",
    "ullensaker.no",
    "ullensvang.no",
    "ulvik.no",
    "utsira.no",
    "vadso.no",
    "vadsø.no",
    "cahcesuolo.no",
    "čáhcesuolo.no",
    "vaksdal.no",
    "valle.no",
    "vang.no",
    "vanylven.no",
    "vardo.no",
    "vardø.no",
    "varggat.no",
    "várggát.no",
    "vefsn.no",
    "vaapste.no",
    "vega.no",
    "vegarshei.no",
    "vegårshei.no",
    "vennesla.no",
    "verdal.no",
    "verran.no",
    "vestby.no",
    "vestnes.no",
    "vestre-slidre.no",
    "vestre-toten.no",
    "vestvagoy.no",
    "vestvågøy.no",
    "vevelstad.no",
    "vik.no",
    "vikna.no",
    "vindafjord.no",
    "volda.no",
    "voss.no",
    "varoy.no",
    "værøy.no",
    "vagan.no",
    "vågan.no",
    "voagat.no",
    "vagsoy.no",
    "vågsøy.no",
    "vaga.no",
    "vågå.no",
    "valer.ostfold.no",
    "våler.østfold.no",
    "valer.hedmark.no",
    "våler.hedmark.no",
    "*.np",
    "nr",
    "biz.nr",
    "info.nr",
    "gov.nr",
    "edu.nr",
    "org.nr",
    "net.nr",
    "com.nr",
    "nu",
    "nz",
    "ac.nz",
    "co.nz",
    "cri.nz",
    "geek.nz",
    "gen.nz",
    "govt.nz",
    "health.nz",
    "iwi.nz",
    "kiwi.nz",
    "maori.nz",
    "mil.nz",
    "māori.nz",
    "net.nz",
    "org.nz",
    "parliament.nz",
    "school.nz",
    "om",
    "co.om",
    "com.om",
    "edu.om",
    "gov.om",
    "med.om",
    "museum.om",
    "net.om",
    "org.om",
    "pro.om",
    "onion",
    "org",
    "pa",
    "ac.pa",
    "gob.pa",
    "com.pa",
    "org.pa",
    "sld.pa",
    "edu.pa",
    "net.pa",
    "ing.pa",
    "abo.pa",
    "med.pa",
    "nom.pa",
    "pe",
    "edu.pe",
    "gob.pe",
    "nom.pe",
    "mil.pe",
    "org.pe",
    "com.pe",
    "net.pe",
    "pf",
    "com.pf",
    "org.pf",
    "edu.pf",
    "*.pg",
    "ph",
    "com.ph",
    "net.ph",
    "org.ph",
    "gov.ph",
    "edu.ph",
    "ngo.ph",
    "mil.ph",
    "i.ph",
    "pk",
    "com.pk",
    "net.pk",
    "edu.pk",
    "org.pk",
    "fam.pk",
    "biz.pk",
    "web.pk",
    "gov.pk",
    "gob.pk",
    "gok.pk",
    "gon.pk",
    "gop.pk",
    "gos.pk",
    "info.pk",
    "pl",
    "com.pl",
    "net.pl",
    "org.pl",
    "aid.pl",
    "agro.pl",
    "atm.pl",
    "auto.pl",
    "biz.pl",
    "edu.pl",
    "gmina.pl",
    "gsm.pl",
    "info.pl",
    "mail.pl",
    "miasta.pl",
    "media.pl",
    "mil.pl",
    "nieruchomosci.pl",
    "nom.pl",
    "pc.pl",
    "powiat.pl",
    "priv.pl",
    "realestate.pl",
    "rel.pl",
    "sex.pl",
    "shop.pl",
    "sklep.pl",
    "sos.pl",
    "szkola.pl",
    "targi.pl",
    "tm.pl",
    "tourism.pl",
    "travel.pl",
    "turystyka.pl",
    "gov.pl",
    "ap.gov.pl",
    "ic.gov.pl",
    "is.gov.pl",
    "us.gov.pl",
    "kmpsp.gov.pl",
    "kppsp.gov.pl",
    "kwpsp.gov.pl",
    "psp.gov.pl",
    "wskr.gov.pl",
    "kwp.gov.pl",
    "mw.gov.pl",
    "ug.gov.pl",
    "um.gov.pl",
    "umig.gov.pl",
    "ugim.gov.pl",
    "upow.gov.pl",
    "uw.gov.pl",
    "starostwo.gov.pl",
    "pa.gov.pl",
    "po.gov.pl",
    "psse.gov.pl",
    "pup.gov.pl",
    "rzgw.gov.pl",
    "sa.gov.pl",
    "so.gov.pl",
    "sr.gov.pl",
    "wsa.gov.pl",
    "sko.gov.pl",
    "uzs.gov.pl",
    "wiih.gov.pl",
    "winb.gov.pl",
    "pinb.gov.pl",
    "wios.gov.pl",
    "witd.gov.pl",
    "wzmiuw.gov.pl",
    "piw.gov.pl",
    "wiw.gov.pl",
    "griw.gov.pl",
    "wif.gov.pl",
    "oum.gov.pl",
    "sdn.gov.pl",
    "zp.gov.pl",
    "uppo.gov.pl",
    "mup.gov.pl",
    "wuoz.gov.pl",
    "konsulat.gov.pl",
    "oirm.gov.pl",
    "augustow.pl",
    "babia-gora.pl",
    "bedzin.pl",
    "beskidy.pl",
    "bialowieza.pl",
    "bialystok.pl",
    "bielawa.pl",
    "bieszczady.pl",
    "boleslawiec.pl",
    "bydgoszcz.pl",
    "bytom.pl",
    "cieszyn.pl",
    "czeladz.pl",
    "czest.pl",
    "dlugoleka.pl",
    "elblag.pl",
    "elk.pl",
    "glogow.pl",
    "gniezno.pl",
    "gorlice.pl",
    "grajewo.pl",
    "ilawa.pl",
    "jaworzno.pl",
    "jelenia-gora.pl",
    "jgora.pl",
    "kalisz.pl",
    "kazimierz-dolny.pl",
    "karpacz.pl",
    "kartuzy.pl",
    "kaszuby.pl",
    "katowice.pl",
    "kepno.pl",
    "ketrzyn.pl",
    "klodzko.pl",
    "kobierzyce.pl",
    "kolobrzeg.pl",
    "konin.pl",
    "konskowola.pl",
    "kutno.pl",
    "lapy.pl",
    "lebork.pl",
    "legnica.pl",
    "lezajsk.pl",
    "limanowa.pl",
    "lomza.pl",
    "lowicz.pl",
    "lubin.pl",
    "lukow.pl",
    "malbork.pl",
    "malopolska.pl",
    "mazowsze.pl",
    "mazury.pl",
    "mielec.pl",
    "mielno.pl",
    "mragowo.pl",
    "naklo.pl",
    "nowaruda.pl",
    "nysa.pl",
    "olawa.pl",
    "olecko.pl",
    "olkusz.pl",
    "olsztyn.pl",
    "opoczno.pl",
    "opole.pl",
    "ostroda.pl",
    "ostroleka.pl",
    "ostrowiec.pl",
    "ostrowwlkp.pl",
    "pila.pl",
    "pisz.pl",
    "podhale.pl",
    "podlasie.pl",
    "polkowice.pl",
    "pomorze.pl",
    "pomorskie.pl",
    "prochowice.pl",
    "pruszkow.pl",
    "przeworsk.pl",
    "pulawy.pl",
    "radom.pl",
    "rawa-maz.pl",
    "rybnik.pl",
    "rzeszow.pl",
    "sanok.pl",
    "sejny.pl",
    "slask.pl",
    "slupsk.pl",
    "sosnowiec.pl",
    "stalowa-wola.pl",
    "skoczow.pl",
    "starachowice.pl",
    "stargard.pl",
    "suwalki.pl",
    "swidnica.pl",
    "swiebodzin.pl",
    "swinoujscie.pl",
    "szczecin.pl",
    "szczytno.pl",
    "tarnobrzeg.pl",
    "tgory.pl",
    "turek.pl",
    "tychy.pl",
    "ustka.pl",
    "walbrzych.pl",
    "warmia.pl",
    "warszawa.pl",
    "waw.pl",
    "wegrow.pl",
    "wielun.pl",
    "wlocl.pl",
    "wloclawek.pl",
    "wodzislaw.pl",
    "wolomin.pl",
    "wroclaw.pl",
    "zachpomor.pl",
    "zagan.pl",
    "zarow.pl",
    "zgora.pl",
    "zgorzelec.pl",
    "pm",
    "pn",
    "gov.pn",
    "co.pn",
    "org.pn",
    "edu.pn",
    "net.pn",
    "post",
    "pr",
    "com.pr",
    "net.pr",
    "org.pr",
    "gov.pr",
    "edu.pr",
    "isla.pr",
    "pro.pr",
    "biz.pr",
    "info.pr",
    "name.pr",
    "est.pr",
    "prof.pr",
    "ac.pr",
    "pro",
    "aaa.pro",
    "aca.pro",
    "acct.pro",
    "avocat.pro",
    "bar.pro",
    "cpa.pro",
    "eng.pro",
    "jur.pro",
    "law.pro",
    "med.pro",
    "recht.pro",
    "ps",
    "edu.ps",
    "gov.ps",
    "sec.ps",
    "plo.ps",
    "com.ps",
    "org.ps",
    "net.ps",
    "pt",
    "net.pt",
    "gov.pt",
    "org.pt",
    "edu.pt",
    "int.pt",
    "publ.pt",
    "com.pt",
    "nome.pt",
    "pw",
    "co.pw",
    "ne.pw",
    "or.pw",
    "ed.pw",
    "go.pw",
    "belau.pw",
    "py",
    "com.py",
    "coop.py",
    "edu.py",
    "gov.py",
    "mil.py",
    "net.py",
    "org.py",
    "qa",
    "com.qa",
    "edu.qa",
    "gov.qa",
    "mil.qa",
    "name.qa",
    "net.qa",
    "org.qa",
    "sch.qa",
    "re",
    "asso.re",
    "com.re",
    "nom.re",
    "ro",
    "arts.ro",
    "com.ro",
    "firm.ro",
    "info.ro",
    "nom.ro",
    "nt.ro",
    "org.ro",
    "rec.ro",
    "store.ro",
    "tm.ro",
    "www.ro",
    "rs",
    "ac.rs",
    "co.rs",
    "edu.rs",
    "gov.rs",
    "in.rs",
    "org.rs",
    "ru",
    "rw",
    "ac.rw",
    "co.rw",
    "coop.rw",
    "gov.rw",
    "mil.rw",
    "net.rw",
    "org.rw",
    "sa",
    "com.sa",
    "net.sa",
    "org.sa",
    "gov.sa",
    "med.sa",
    "pub.sa",
    "edu.sa",
    "sch.sa",
    "sb",
    "com.sb",
    "edu.sb",
    "gov.sb",
    "net.sb",
    "org.sb",
    "sc",
    "com.sc",
    "gov.sc",
    "net.sc",
    "org.sc",
    "edu.sc",
    "sd",
    "com.sd",
    "net.sd",
    "org.sd",
    "edu.sd",
    "med.sd",
    "tv.sd",
    "gov.sd",
    "info.sd",
    "se",
    "a.se",
    "ac.se",
    "b.se",
    "bd.se",
    "brand.se",
    "c.se",
    "d.se",
    "e.se",
    "f.se",
    "fh.se",
    "fhsk.se",
    "fhv.se",
    "g.se",
    "h.se",
    "i.se",
    "k.se",
    "komforb.se",
    "kommunalforbund.se",
    "komvux.se",
    "l.se",
    "lanbib.se",
    "m.se",
    "n.se",
    "naturbruksgymn.se",
    "o.se",
    "org.se",
    "p.se",
    "parti.se",
    "pp.se",
    "press.se",
    "r.se",
    "s.se",
    "t.se",
    "tm.se",
    "u.se",
    "w.se",
    "x.se",
    "y.se",
    "z.se",
    "sg",
    "com.sg",
    "net.sg",
    "org.sg",
    "gov.sg",
    "edu.sg",
    "per.sg",
    "sh",
    "com.sh",
    "net.sh",
    "gov.sh",
    "org.sh",
    "mil.sh",
    "si",
    "sj",
    "sk",
    "sl",
    "com.sl",
    "net.sl",
    "edu.sl",
    "gov.sl",
    "org.sl",
    "sm",
    "sn",
    "art.sn",
    "com.sn",
    "edu.sn",
    "gouv.sn",
    "org.sn",
    "perso.sn",
    "univ.sn",
    "so",
    "com.so",
    "edu.so",
    "gov.so",
    "me.so",
    "net.so",
    "org.so",
    "sr",
    "ss",
    "biz.ss",
    "com.ss",
    "edu.ss",
    "gov.ss",
    "me.ss",
    "net.ss",
    "org.ss",
    "sch.ss",
    "st",
    "co.st",
    "com.st",
    "consulado.st",
    "edu.st",
    "embaixada.st",
    "mil.st",
    "net.st",
    "org.st",
    "principe.st",
    "saotome.st",
    "store.st",
    "su",
    "sv",
    "com.sv",
    "edu.sv",
    "gob.sv",
    "org.sv",
    "red.sv",
    "sx",
    "gov.sx",
    "sy",
    "edu.sy",
    "gov.sy",
    "net.sy",
    "mil.sy",
    "com.sy",
    "org.sy",
    "sz",
    "co.sz",
    "ac.sz",
    "org.sz",
    "tc",
    "td",
    "tel",
    "tf",
    "tg",
    "th",
    "ac.th",
    "co.th",
    "go.th",
    "in.th",
    "mi.th",
    "net.th",
    "or.th",
    "tj",
    "ac.tj",
    "biz.tj",
    "co.tj",
    "com.tj",
    "edu.tj",
    "go.tj",
    "gov.tj",
    "int.tj",
    "mil.tj",
    "name.tj",
    "net.tj",
    "nic.tj",
    "org.tj",
    "test.tj",
    "web.tj",
    "tk",
    "tl",
    "gov.tl",
    "tm",
    "com.tm",
    "co.tm",
    "org.tm",
    "net.tm",
    "nom.tm",
    "gov.tm",
    "mil.tm",
    "edu.tm",
    "tn",
    "com.tn",
    "ens.tn",
    "fin.tn",
    "gov.tn",
    "ind.tn",
    "info.tn",
    "intl.tn",
    "mincom.tn",
    "nat.tn",
    "net.tn",
    "org.tn",
    "perso.tn",
    "tourism.tn",
    "to",
    "com.to",
    "gov.to",
    "net.to",
    "org.to",
    "edu.to",
    "mil.to",
    "tr",
    "av.tr",
    "bbs.tr",
    "bel.tr",
    "biz.tr",
    "com.tr",
    "dr.tr",
    "edu.tr",
    "gen.tr",
    "gov.tr",
    "info.tr",
    "mil.tr",
    "k12.tr",
    "kep.tr",
    "name.tr",
    "net.tr",
    "org.tr",
    "pol.tr",
    "tel.tr",
    "tsk.tr",
    "tv.tr",
    "web.tr",
    "nc.tr",
    "gov.nc.tr",
    "tt",
    "co.tt",
    "com.tt",
    "org.tt",
    "net.tt",
    "biz.tt",
    "info.tt",
    "pro.tt",
    "int.tt",
    "coop.tt",
    "jobs.tt",
    "mobi.tt",
    "travel.tt",
    "museum.tt",
    "aero.tt",
    "name.tt",
    "gov.tt",
    "edu.tt",
    "tv",
    "tw",
    "edu.tw",
    "gov.tw",
    "mil.tw",
    "com.tw",
    "net.tw",
    "org.tw",
    "idv.tw",
    "game.tw",
    "ebiz.tw",
    "club.tw",
    "網路.tw",
    "組織.tw",
    "商業.tw",
    "tz",
    "ac.tz",
    "co.tz",
    "go.tz",
    "hotel.tz",
    "info.tz",
    "me.tz",
    "mil.tz",
    "mobi.tz",
    "ne.tz",
    "or.tz",
    "sc.tz",
    "tv.tz",
    "ua",
    "com.ua",
    "edu.ua",
    "gov.ua",
    "in.ua",
    "net.ua",
    "org.ua",
    "cherkassy.ua",
    "cherkasy.ua",
    "chernigov.ua",
    "chernihiv.ua",
    "chernivtsi.ua",
    "chernovtsy.ua",
    "ck.ua",
    "cn.ua",
    "cr.ua",
    "crimea.ua",
    "cv.ua",
    "dn.ua",
    "dnepropetrovsk.ua",
    "dnipropetrovsk.ua",
    "donetsk.ua",
    "dp.ua",
    "if.ua",
    "ivano-frankivsk.ua",
    "kh.ua",
    "kharkiv.ua",
    "kharkov.ua",
    "kherson.ua",
    "khmelnitskiy.ua",
    "khmelnytskyi.ua",
    "kiev.ua",
    "kirovograd.ua",
    "km.ua",
    "kr.ua",
    "krym.ua",
    "ks.ua",
    "kv.ua",
    "kyiv.ua",
    "lg.ua",
    "lt.ua",
    "lugansk.ua",
    "lutsk.ua",
    "lv.ua",
    "lviv.ua",
    "mk.ua",
    "mykolaiv.ua",
    "nikolaev.ua",
    "od.ua",
    "odesa.ua",
    "odessa.ua",
    "pl.ua",
    "poltava.ua",
    "rivne.ua",
    "rovno.ua",
    "rv.ua",
    "sb.ua",
    "sebastopol.ua",
    "sevastopol.ua",
    "sm.ua",
    "sumy.ua",
    "te.ua",
    "ternopil.ua",
    "uz.ua",
    "uzhgorod.ua",
    "vinnica.ua",
    "vinnytsia.ua",
    "vn.ua",
    "volyn.ua",
    "yalta.ua",
    "zaporizhzhe.ua",
    "zaporizhzhia.ua",
    "zhitomir.ua",
    "zhytomyr.ua",
    "zp.ua",
    "zt.ua",
    "ug",
    "co.ug",
    "or.ug",
    "ac.ug",
    "sc.ug",
    "go.ug",
    "ne.ug",
    "com.ug",
    "org.ug",
    "uk",
    "ac.uk",
    "co.uk",
    "gov.uk",
    "ltd.uk",
    "me.uk",
    "net.uk",
    "nhs.uk",
    "org.uk",
    "plc.uk",
    "police.uk",
    "*.sch.uk",
    "us",
    "dni.us",
    "fed.us",
    "isa.us",
    "kids.us",
    "nsn.us",
    "ak.us",
    "al.us",
    "ar.us",
    "as.us",
    "az.us",
    "ca.us",
    "co.us",
    "ct.us",
    "dc.us",
    "de.us",
    "fl.us",
    "ga.us",
    "gu.us",
    "hi.us",
    "ia.us",
    "id.us",
    "il.us",
    "in.us",
    "ks.us",
    "ky.us",
    "la.us",
    "ma.us",
    "md.us",
    "me.us",
    "mi.us",
    "mn.us",
    "mo.us",
    "ms.us",
    "mt.us",
    "nc.us",
    "nd.us",
    "ne.us",
    "nh.us",
    "nj.us",
    "nm.us",
    "nv.us",
    "ny.us",
    "oh.us",
    "ok.us",
    "or.us",
    "pa.us",
    "pr.us",
    "ri.us",
    "sc.us",
    "sd.us",
    "tn.us",
    "tx.us",
    "ut.us",
    "vi.us",
    "vt.us",
    "va.us",
    "wa.us",
    "wi.us",
    "wv.us",
    "wy.us",
    "k12.ak.us",
    "k12.al.us",
    "k12.ar.us",
    "k12.as.us",
    "k12.az.us",
    "k12.ca.us",
    "k12.co.us",
    "k12.ct.us",
    "k12.dc.us",
    "k12.de.us",
    "k12.fl.us",
    "k12.ga.us",
    "k12.gu.us",
    "k12.ia.us",
    "k12.id.us",
    "k12.il.us",
    "k12.in.us",
    "k12.ks.us",
    "k12.ky.us",
    "k12.la.us",
    "k12.ma.us",
    "k12.md.us",
    "k12.me.us",
    "k12.mi.us",
    "k12.mn.us",
    "k12.mo.us",
    "k12.ms.us",
    "k12.mt.us",
    "k12.nc.us",
    "k12.ne.us",
    "k12.nh.us",
    "k12.nj.us",
    "k12.nm.us",
    "k12.nv.us",
    "k12.ny.us",
    "k12.oh.us",
    "k12.ok.us",
    "k12.or.us",
    "k12.pa.us",
    "k12.pr.us",
    "k12.sc.us",
    "k12.tn.us",
    "k12.tx.us",
    "k12.ut.us",
    "k12.vi.us",
    "k12.vt.us",
    "k12.va.us",
    "k12.wa.us",
    "k12.wi.us",
    "k12.wy.us",
    "cc.ak.us",
    "cc.al.us",
    "cc.ar.us",
    "cc.as.us",
    "cc.az.us",
    "cc.ca.us",
    "cc.co.us",
    "cc.ct.us",
    "cc.dc.us",
    "cc.de.us",
    "cc.fl.us",
    "cc.ga.us",
    "cc.gu.us",
    "cc.hi.us",
    "cc.ia.us",
    "cc.id.us",
    "cc.il.us",
    "cc.in.us",
    "cc.ks.us",
    "cc.ky.us",
    "cc.la.us",
    "cc.ma.us",
    "cc.md.us",
    "cc.me.us",
    "cc.mi.us",
    "cc.mn.us",
    "cc.mo.us",
    "cc.ms.us",
    "cc.mt.us",
    "cc.nc.us",
    "cc.nd.us",
    "cc.ne.us",
    "cc.nh.us",
    "cc.nj.us",
    "cc.nm.us",
    "cc.nv.us",
    "cc.ny.us",
    "cc.oh.us",
    "cc.ok.us",
    "cc.or.us",
    "cc.pa.us",
    "cc.pr.us",
    "cc.ri.us",
    "cc.sc.us",
    "cc.sd.us",
    "cc.tn.us",
    "cc.tx.us",
    "cc.ut.us",
    "cc.vi.us",
    "cc.vt.us",
    "cc.va.us",
    "cc.wa.us",
    "cc.wi.us",
    "cc.wv.us",
    "cc.wy.us",
    "lib.ak.us",
    "lib.al.us",
    "lib.ar.us",
    "lib.as.us",
    "lib.az.us",
    "lib.ca.us",
    "lib.co.us",
    "lib.ct.us",
    "lib.dc.us",
    "lib.fl.us",
    "lib.ga.us",
    "lib.gu.us",
    "lib.hi.us",
    "lib.ia.us",
    "lib.id.us",
    "lib.il.us",
    "lib.in.us",
    "lib.ks.us",
    "lib.ky.us",
    "lib.la.us",
    "lib.ma.us",
    "lib.md.us",
    "lib.me.us",
    "lib.mi.us",
    "lib.mn.us",
    "lib.mo.us",
    "lib.ms.us",
    "lib.mt.us",
    "lib.nc.us",
    "lib.nd.us",
    "lib.ne.us",
    "lib.nh.us",
    "lib.nj.us",
    "lib.nm.us",
    "lib.nv.us",
    "lib.ny.us",
    "lib.oh.us",
    "lib.ok.us",
    "lib.or.us",
    "lib.pa.us",
    "lib.pr.us",
    "lib.ri.us",
    "lib.sc.us",
    "lib.sd.us",
    "lib.tn.us",
    "lib.tx.us",
    "lib.ut.us",
    "lib.vi.us",
    "lib.vt.us",
    "lib.va.us",
    "lib.wa.us",
    "lib.wi.us",
    "lib.wy.us",
    "pvt.k12.ma.us",
    "chtr.k12.ma.us",
    "paroch.k12.ma.us",
    "ann-arbor.mi.us",
    "cog.mi.us",
    "dst.mi.us",
    "eaton.mi.us",
    "gen.mi.us",
    "mus.mi.us",
    "tec.mi.us",
    "washtenaw.mi.us",
    "uy",
    "com.uy",
    "edu.uy",
    "gub.uy",
    "mil.uy",
    "net.uy",
    "org.uy",
    "uz",
    "co.uz",
    "com.uz",
    "net.uz",
    "org.uz",
    "va",
    "vc",
    "com.vc",
    "net.vc",
    "org.vc",
    "gov.vc",
    "mil.vc",
    "edu.vc",
    "ve",
    "arts.ve",
    "bib.ve",
    "co.ve",
    "com.ve",
    "e12.ve",
    "edu.ve",
    "firm.ve",
    "gob.ve",
    "gov.ve",
    "info.ve",
    "int.ve",
    "mil.ve",
    "net.ve",
    "nom.ve",
    "org.ve",
    "rar.ve",
    "rec.ve",
    "store.ve",
    "tec.ve",
    "web.ve",
    "vg",
    "vi",
    "co.vi",
    "com.vi",
    "k12.vi",
    "net.vi",
    "org.vi",
    "vn",
    "com.vn",
    "net.vn",
    "org.vn",
    "edu.vn",
    "gov.vn",
    "int.vn",
    "ac.vn",
    "biz.vn",
    "info.vn",
    "name.vn",
    "pro.vn",
    "health.vn",
    "vu",
    "com.vu",
    "edu.vu",
    "net.vu",
    "org.vu",
    "wf",
    "ws",
    "com.ws",
    "net.ws",
    "org.ws",
    "gov.ws",
    "edu.ws",
    "yt",
    "امارات",
    "հայ",
    "বাংলা",
    "бг",
    "البحرين",
    "бел",
    "中国",
    "中國",
    "الجزائر",
    "مصر",
    "ею",
    "ευ",
    "موريتانيا",
    "გე",
    "ελ",
    "香港",
    "公司.香港",
    "教育.香港",
    "政府.香港",
    "個人.香港",
    "網絡.香港",
    "組織.香港",
    "ಭಾರತ",
    "ଭାରତ",
    "ভাৰত",
    "भारतम्",
    "भारोत",
    "ڀارت",
    "ഭാരതം",
    "भारत",
    "بارت",
    "بھارت",
    "భారత్",
    "ભારત",
    "ਭਾਰਤ",
    "ভারত",
    "இந்தியா",
    "ایران",
    "ايران",
    "عراق",
    "الاردن",
    "한국",
    "қаз",
    "ລາວ",
    "ලංකා",
    "இலங்கை",
    "المغرب",
    "мкд",
    "мон",
    "澳門",
    "澳门",
    "مليسيا",
    "عمان",
    "پاکستان",
    "پاكستان",
    "فلسطين",
    "срб",
    "пр.срб",
    "орг.срб",
    "обр.срб",
    "од.срб",
    "упр.срб",
    "ак.срб",
    "рф",
    "قطر",
    "السعودية",
    "السعودیة",
    "السعودیۃ",
    "السعوديه",
    "سودان",
    "新加坡",
    "சிங்கப்பூர்",
    "سورية",
    "سوريا",
    "ไทย",
    "ศึกษา.ไทย",
    "ธุรกิจ.ไทย",
    "รัฐบาล.ไทย",
    "ทหาร.ไทย",
    "เน็ต.ไทย",
    "องค์กร.ไทย",
    "تونس",
    "台灣",
    "台湾",
    "臺灣",
    "укр",
    "اليمن",
    "xxx",
    "ye",
    "com.ye",
    "edu.ye",
    "gov.ye",
    "net.ye",
    "mil.ye",
    "org.ye",
    "ac.za",
    "agric.za",
    "alt.za",
    "co.za",
    "edu.za",
    "gov.za",
    "grondar.za",
    "law.za",
    "mil.za",
    "net.za",
    "ngo.za",
    "nic.za",
    "nis.za",
    "nom.za",
    "org.za",
    "school.za",
    "tm.za",
    "web.za",
    "zm",
    "ac.zm",
    "biz.zm",
    "co.zm",
    "com.zm",
    "edu.zm",
    "gov.zm",
    "info.zm",
    "mil.zm",
    "net.zm",
    "org.zm",
    "sch.zm",
    "zw",
    "ac.zw",
    "co.zw",
    "gov.zw",
    "mil.zw",
    "org.zw",
    "aaa",
    "aarp",
    "abarth",
    "abb",
    "abbott",
    "abbvie",
    "abc",
    "able",
    "abogado",
    "abudhabi",
    "academy",
    "accenture",
    "accountant",
    "accountants",
    "aco",
    "actor",
    "adac",
    "ads",
    "adult",
    "aeg",
    "aetna",
    "afl",
    "africa",
    "agakhan",
    "agency",
    "aig",
    "airbus",
    "airforce",
    "airtel",
    "akdn",
    "alfaromeo",
    "alibaba",
    "alipay",
    "allfinanz",
    "allstate",
    "ally",
    "alsace",
    "alstom",
    "amazon",
    "americanexpress",
    "americanfamily",
    "amex",
    "amfam",
    "amica",
    "amsterdam",
    "analytics",
    "android",
    "anquan",
    "anz",
    "aol",
    "apartments",
    "app",
    "apple",
    "aquarelle",
    "arab",
    "aramco",
    "archi",
    "army",
    "art",
    "arte",
    "asda",
    "associates",
    "athleta",
    "attorney",
    "auction",
    "audi",
    "audible",
    "audio",
    "auspost",
    "author",
    "auto",
    "autos",
    "avianca",
    "aws",
    "axa",
    "azure",
    "baby",
    "baidu",
    "banamex",
    "bananarepublic",
    "band",
    "bank",
    "bar",
    "barcelona",
    "barclaycard",
    "barclays",
    "barefoot",
    "bargains",
    "baseball",
    "basketball",
    "bauhaus",
    "bayern",
    "bbc",
    "bbt",
    "bbva",
    "bcg",
    "bcn",
    "beats",
    "beauty",
    "beer",
    "bentley",
    "berlin",
    "best",
    "bestbuy",
    "bet",
    "bharti",
    "bible",
    "bid",
    "bike",
    "bing",
    "bingo",
    "bio",
    "black",
    "blackfriday",
    "blockbuster",
    "blog",
    "bloomberg",
    "blue",
    "bms",
    "bmw",
    "bnpparibas",
    "boats",
    "boehringer",
    "bofa",
    "bom",
    "bond",
    "boo",
    "book",
    "booking",
    "bosch",
    "bostik",
    "boston",
    "bot",
    "boutique",
    "box",
    "bradesco",
    "bridgestone",
    "broadway",
    "broker",
    "brother",
    "brussels",
    "bugatti",
    "build",
    "builders",
    "business",
    "buy",
    "buzz",
    "bzh",
    "cab",
    "cafe",
    "cal",
    "call",
    "calvinklein",
    "cam",
    "camera",
    "camp",
    "cancerresearch",
    "canon",
    "capetown",
    "capital",
    "capitalone",
    "car",
    "caravan",
    "cards",
    "care",
    "career",
    "careers",
    "cars",
    "casa",
    "case",
    "cash",
    "casino",
    "catering",
    "catholic",
    "cba",
    "cbn",
    "cbre",
    "cbs",
    "center",
    "ceo",
    "cern",
    "cfa",
    "cfd",
    "chanel",
    "channel",
    "charity",
    "chase",
    "chat",
    "cheap",
    "chintai",
    "christmas",
    "chrome",
    "church",
    "cipriani",
    "circle",
    "cisco",
    "citadel",
    "citi",
    "citic",
    "city",
    "cityeats",
    "claims",
    "cleaning",
    "click",
    "clinic",
    "clinique",
    "clothing",
    "cloud",
    "club",
    "clubmed",
    "coach",
    "codes",
    "coffee",
    "college",
    "cologne",
    "comcast",
    "commbank",
    "community",
    "company",
    "compare",
    "computer",
    "comsec",
    "condos",
    "construction",
    "consulting",
    "contact",
    "contractors",
    "cooking",
    "cookingchannel",
    "cool",
    "corsica",
    "country",
    "coupon",
    "coupons",
    "courses",
    "cpa",
    "credit",
    "creditcard",
    "creditunion",
    "cricket",
    "crown",
    "crs",
    "cruise",
    "cruises",
    "cuisinella",
    "cymru",
    "cyou",
    "dabur",
    "dad",
    "dance",
    "data",
    "date",
    "dating",
    "datsun",
    "day",
    "dclk",
    "dds",
    "deal",
    "dealer",
    "deals",
    "degree",
    "delivery",
    "dell",
    "deloitte",
    "delta",
    "democrat",
    "dental",
    "dentist",
    "desi",
    "design",
    "dev",
    "dhl",
    "diamonds",
    "diet",
    "digital",
    "direct",
    "directory",
    "discount",
    "discover",
    "dish",
    "diy",
    "dnp",
    "docs",
    "doctor",
    "dog",
    "domains",
    "dot",
    "download",
    "drive",
    "dtv",
    "dubai",
    "dunlop",
    "dupont",
    "durban",
    "dvag",
    "dvr",
    "earth",
    "eat",
    "eco",
    "edeka",
    "education",
    "email",
    "emerck",
    "energy",
    "engineer",
    "engineering",
    "enterprises",
    "epson",
    "equipment",
    "ericsson",
    "erni",
    "esq",
    "estate",
    "etisalat",
    "eurovision",
    "eus",
    "events",
    "exchange",
    "expert",
    "exposed",
    "express",
    "extraspace",
    "fage",
    "fail",
    "fairwinds",
    "faith",
    "family",
    "fan",
    "fans",
    "farm",
    "farmers",
    "fashion",
    "fast",
    "fedex",
    "feedback",
    "ferrari",
    "ferrero",
    "fiat",
    "fidelity",
    "fido",
    "film",
    "final",
    "finance",
    "financial",
    "fire",
    "firestone",
    "firmdale",
    "fish",
    "fishing",
    "fit",
    "fitness",
    "flickr",
    "flights",
    "flir",
    "florist",
    "flowers",
    "fly",
    "foo",
    "food",
    "foodnetwork",
    "football",
    "ford",
    "forex",
    "forsale",
    "forum",
    "foundation",
    "fox",
    "free",
    "fresenius",
    "frl",
    "frogans",
    "frontdoor",
    "frontier",
    "ftr",
    "fujitsu",
    "fun",
    "fund",
    "furniture",
    "futbol",
    "fyi",
    "gal",
    "gallery",
    "gallo",
    "gallup",
    "game",
    "games",
    "gap",
    "garden",
    "gay",
    "gbiz",
    "gdn",
    "gea",
    "gent",
    "genting",
    "george",
    "ggee",
    "gift",
    "gifts",
    "gives",
    "giving",
    "glass",
    "gle",
    "global",
    "globo",
    "gmail",
    "gmbh",
    "gmo",
    "gmx",
    "godaddy",
    "gold",
    "goldpoint",
    "golf",
    "goo",
    "goodyear",
    "goog",
    "google",
    "gop",
    "got",
    "grainger",
    "graphics",
    "gratis",
    "green",
    "gripe",
    "grocery",
    "group",
    "guardian",
    "gucci",
    "guge",
    "guide",
    "guitars",
    "guru",
    "hair",
    "hamburg",
    "hangout",
    "haus",
    "hbo",
    "hdfc",
    "hdfcbank",
    "health",
    "healthcare",
    "help",
    "helsinki",
    "here",
    "hermes",
    "hgtv",
    "hiphop",
    "hisamitsu",
    "hitachi",
    "hiv",
    "hkt",
    "hockey",
    "holdings",
    "holiday",
    "homedepot",
    "homegoods",
    "homes",
    "homesense",
    "honda",
    "horse",
    "hospital",
    "host",
    "hosting",
    "hot",
    "hoteles",
    "hotels",
    "hotmail",
    "house",
    "how",
    "hsbc",
    "hughes",
    "hyatt",
    "hyundai",
    "ibm",
    "icbc",
    "ice",
    "icu",
    "ieee",
    "ifm",
    "ikano",
    "imamat",
    "imdb",
    "immo",
    "immobilien",
    "inc",
    "industries",
    "infiniti",
    "ing",
    "ink",
    "institute",
    "insurance",
    "insure",
    "international",
    "intuit",
    "investments",
    "ipiranga",
    "irish",
    "ismaili",
    "ist",
    "istanbul",
    "itau",
    "itv",
    "jaguar",
    "java",
    "jcb",
    "jeep",
    "jetzt",
    "jewelry",
    "jio",
    "jll",
    "jmp",
    "jnj",
    "joburg",
    "jot",
    "joy",
    "jpmorgan",
    "jprs",
    "juegos",
    "juniper",
    "kaufen",
    "kddi",
    "kerryhotels",
    "kerrylogistics",
    "kerryproperties",
    "kfh",
    "kia",
    "kids",
    "kim",
    "kinder",
    "kindle",
    "kitchen",
    "kiwi",
    "koeln",
    "komatsu",
    "kosher",
    "kpmg",
    "kpn",
    "krd",
    "kred",
    "kuokgroup",
    "kyoto",
    "lacaixa",
    "lamborghini",
    "lamer",
    "lancaster",
    "lancia",
    "land",
    "landrover",
    "lanxess",
    "lasalle",
    "lat",
    "latino",
    "latrobe",
    "law",
    "lawyer",
    "lds",
    "lease",
    "leclerc",
    "lefrak",
    "legal",
    "lego",
    "lexus",
    "lgbt",
    "lidl",
    "life",
    "lifeinsurance",
    "lifestyle",
    "lighting",
    "like",
    "lilly",
    "limited",
    "limo",
    "lincoln",
    "linde",
    "link",
    "lipsy",
    "live",
    "living",
    "llc",
    "llp",
    "loan",
    "loans",
    "locker",
    "locus",
    "loft",
    "lol",
    "london",
    "lotte",
    "lotto",
    "love",
    "lpl",
    "lplfinancial",
    "ltd",
    "ltda",
    "lundbeck",
    "luxe",
    "luxury",
    "macys",
    "madrid",
    "maif",
    "maison",
    "makeup",
    "man",
    "management",
    "mango",
    "map",
    "market",
    "marketing",
    "markets",
    "marriott",
    "marshalls",
    "maserati",
    "mattel",
    "mba",
    "mckinsey",
    "med",
    "media",
    "meet",
    "melbourne",
    "meme",
    "memorial",
    "men",
    "menu",
    "merckmsd",
    "miami",
    "microsoft",
    "mini",
    "mint",
    "mit",
    "mitsubishi",
    "mlb",
    "mls",
    "mma",
    "mobile",
    "moda",
    "moe",
    "moi",
    "mom",
    "monash",
    "money",
    "monster",
    "mormon",
    "mortgage",
    "moscow",
    "moto",
    "motorcycles",
    "mov",
    "movie",
    "msd",
    "mtn",
    "mtr",
    "music",
    "mutual",
    "nab",
    "nagoya",
    "natura",
    "navy",
    "nba",
    "nec",
    "netbank",
    "netflix",
    "network",
    "neustar",
    "new",
    "news",
    "next",
    "nextdirect",
    "nexus",
    "nfl",
    "ngo",
    "nhk",
    "nico",
    "nike",
    "nikon",
    "ninja",
    "nissan",
    "nissay",
    "nokia",
    "northwesternmutual",
    "norton",
    "now",
    "nowruz",
    "nowtv",
    "nra",
    "nrw",
    "ntt",
    "nyc",
    "obi",
    "observer",
    "office",
    "okinawa",
    "olayan",
    "olayangroup",
    "oldnavy",
    "ollo",
    "omega",
    "one",
    "ong",
    "onl",
    "online",
    "ooo",
    "open",
    "oracle",
    "orange",
    "organic",
    "origins",
    "osaka",
    "otsuka",
    "ott",
    "ovh",
    "page",
    "panasonic",
    "paris",
    "pars",
    "partners",
    "parts",
    "party",
    "passagens",
    "pay",
    "pccw",
    "pet",
    "pfizer",
    "pharmacy",
    "phd",
    "philips",
    "phone",
    "photo",
    "photography",
    "photos",
    "physio",
    "pics",
    "pictet",
    "pictures",
    "pid",
    "pin",
    "ping",
    "pink",
    "pioneer",
    "pizza",
    "place",
    "play",
    "playstation",
    "plumbing",
    "plus",
    "pnc",
    "pohl",
    "poker",
    "politie",
    "porn",
    "pramerica",
    "praxi",
    "press",
    "prime",
    "prod",
    "productions",
    "prof",
    "progressive",
    "promo",
    "properties",
    "property",
    "protection",
    "pru",
    "prudential",
    "pub",
    "pwc",
    "qpon",
    "quebec",
    "quest",
    "racing",
    "radio",
    "read",
    "realestate",
    "realtor",
    "realty",
    "recipes",
    "red",
    "redstone",
    "redumbrella",
    "rehab",
    "reise",
    "reisen",
    "reit",
    "reliance",
    "ren",
    "rent",
    "rentals",
    "repair",
    "report",
    "republican",
    "rest",
    "restaurant",
    "review",
    "reviews",
    "rexroth",
    "rich",
    "richardli",
    "ricoh",
    "ril",
    "rio",
    "rip",
    "rocher",
    "rocks",
    "rodeo",
    "rogers",
    "room",
    "rsvp",
    "rugby",
    "ruhr",
    "run",
    "rwe",
    "ryukyu",
    "saarland",
    "safe",
    "safety",
    "sakura",
    "sale",
    "salon",
    "samsclub",
    "samsung",
    "sandvik",
    "sandvikcoromant",
    "sanofi",
    "sap",
    "sarl",
    "sas",
    "save",
    "saxo",
    "sbi",
    "sbs",
    "sca",
    "scb",
    "schaeffler",
    "schmidt",
    "scholarships",
    "school",
    "schule",
    "schwarz",
    "science",
    "scot",
    "search",
    "seat",
    "secure",
    "security",
    "seek",
    "select",
    "sener",
    "services",
    "ses",
    "seven",
    "sew",
    "sex",
    "sexy",
    "sfr",
    "shangrila",
    "sharp",
    "shaw",
    "shell",
    "shia",
    "shiksha",
    "shoes",
    "shop",
    "shopping",
    "shouji",
    "show",
    "showtime",
    "silk",
    "sina",
    "singles",
    "site",
    "ski",
    "skin",
    "sky",
    "skype",
    "sling",
    "smart",
    "smile",
    "sncf",
    "soccer",
    "social",
    "softbank",
    "software",
    "sohu",
    "solar",
    "solutions",
    "song",
    "sony",
    "soy",
    "spa",
    "space",
    "sport",
    "spot",
    "srl",
    "stada",
    "staples",
    "star",
    "statebank",
    "statefarm",
    "stc",
    "stcgroup",
    "stockholm",
    "storage",
    "store",
    "stream",
    "studio",
    "study",
    "style",
    "sucks",
    "supplies",
    "supply",
    "support",
    "surf",
    "surgery",
    "suzuki",
    "swatch",
    "swiss",
    "sydney",
    "systems",
    "tab",
    "taipei",
    "talk",
    "taobao",
    "target",
    "tatamotors",
    "tatar",
    "tattoo",
    "tax",
    "taxi",
    "tci",
    "tdk",
    "team",
    "tech",
    "technology",
    "temasek",
    "tennis",
    "teva",
    "thd",
    "theater",
    "theatre",
    "tiaa",
    "tickets",
    "tienda",
    "tiffany",
    "tips",
    "tires",
    "tirol",
    "tjmaxx",
    "tjx",
    "tkmaxx",
    "tmall",
    "today",
    "tokyo",
    "tools",
    "top",
    "toray",
    "toshiba",
    "total",
    "tours",
    "town",
    "toyota",
    "toys",
    "trade",
    "trading",
    "training",
    "travel",
    "travelchannel",
    "travelers",
    "travelersinsurance",
    "trust",
    "trv",
    "tube",
    "tui",
    "tunes",
    "tushu",
    "tvs",
    "ubank",
    "ubs",
    "unicom",
    "university",
    "uno",
    "uol",
    "ups",
    "vacations",
    "vana",
    "vanguard",
    "vegas",
    "ventures",
    "verisign",
    "versicherung",
    "vet",
    "viajes",
    "video",
    "vig",
    "viking",
    "villas",
    "vin",
    "vip",
    "virgin",
    "visa",
    "vision",
    "viva",
    "vivo",
    "vlaanderen",
    "vodka",
    "volkswagen",
    "volvo",
    "vote",
    "voting",
    "voto",
    "voyage",
    "vuelos",
    "wales",
    "walmart",
    "walter",
    "wang",
    "wanggou",
    "watch",
    "watches",
    "weather",
    "weatherchannel",
    "webcam",
    "weber",
    "website",
    "wedding",
    "weibo",
    "weir",
    "whoswho",
    "wien",
    "wiki",
    "williamhill",
    "win",
    "windows",
    "wine",
    "winners",
    "wme",
    "wolterskluwer",
    "woodside",
    "work",
    "works",
    "world",
    "wow",
    "wtc",
    "wtf",
    "xbox",
    "xerox",
    "xfinity",
    "xihuan",
    "xin",
    "कॉम",
    "セール",
    "佛山",
    "慈善",
    "集团",
    "在线",
    "点看",
    "คอม",
    "八卦",
    "موقع",
    "公益",
    "公司",
    "香格里拉",
    "网站",
    "移动",
    "我爱你",
    "москва",
    "католик",
    "онлайн",
    "сайт",
    "联通",
    "קום",
    "时尚",
    "微博",
    "淡马锡",
    "ファッション",
    "орг",
    "नेट",
    "ストア",
    "アマゾン",
    "삼성",
    "商标",
    "商店",
    "商城",
    "дети",
    "ポイント",
    "新闻",
    "家電",
    "كوم",
    "中文网",
    "中信",
    "娱乐",
    "谷歌",
    "電訊盈科",
    "购物",
    "クラウド",
    "通販",
    "网店",
    "संगठन",
    "餐厅",
    "网络",
    "ком",
    "亚马逊",
    "诺基亚",
    "食品",
    "飞利浦",
    "手机",
    "ارامكو",
    "العليان",
    "اتصالات",
    "بازار",
    "ابوظبي",
    "كاثوليك",
    "همراه",
    "닷컴",
    "政府",
    "شبكة",
    "بيتك",
    "عرب",
    "机构",
    "组织机构",
    "健康",
    "招聘",
    "рус",
    "大拿",
    "みんな",
    "グーグル",
    "世界",
    "書籍",
    "网址",
    "닷넷",
    "コム",
    "天主教",
    "游戏",
    "vermögensberater",
    "vermögensberatung",
    "企业",
    "信息",
    "嘉里大酒店",
    "嘉里",
    "广东",
    "政务",
    "xyz",
    "yachts",
    "yahoo",
    "yamaxun",
    "yandex",
    "yodobashi",
    "yoga",
    "yokohama",
    "you",
    "youtube",
    "yun",
    "zappos",
    "zara",
    "zero",
    "zip",
    "zone",
    "zuerich",
    "cc.ua",
    "inf.ua",
    "ltd.ua",
    "611.to",
    "graphox.us",
    "*.devcdnaccesso.com",
    "adobeaemcloud.com",
    "*.dev.adobeaemcloud.com",
    "hlx.live",
    "adobeaemcloud.net",
    "hlx.page",
    "hlx3.page",
    "beep.pl",
    "airkitapps.com",
    "airkitapps-au.com",
    "airkitapps.eu",
    "aivencloud.com",
    "barsy.ca",
    "*.compute.estate",
    "*.alces.network",
    "kasserver.com",
    "altervista.org",
    "alwaysdata.net",
    "cloudfront.net",
    "*.compute.amazonaws.com",
    "*.compute-1.amazonaws.com",
    "*.compute.amazonaws.com.cn",
    "us-east-1.amazonaws.com",
    "cn-north-1.eb.amazonaws.com.cn",
    "cn-northwest-1.eb.amazonaws.com.cn",
    "elasticbeanstalk.com",
    "ap-northeast-1.elasticbeanstalk.com",
    "ap-northeast-2.elasticbeanstalk.com",
    "ap-northeast-3.elasticbeanstalk.com",
    "ap-south-1.elasticbeanstalk.com",
    "ap-southeast-1.elasticbeanstalk.com",
    "ap-southeast-2.elasticbeanstalk.com",
    "ca-central-1.elasticbeanstalk.com",
    "eu-central-1.elasticbeanstalk.com",
    "eu-west-1.elasticbeanstalk.com",
    "eu-west-2.elasticbeanstalk.com",
    "eu-west-3.elasticbeanstalk.com",
    "sa-east-1.elasticbeanstalk.com",
    "us-east-1.elasticbeanstalk.com",
    "us-east-2.elasticbeanstalk.com",
    "us-gov-west-1.elasticbeanstalk.com",
    "us-west-1.elasticbeanstalk.com",
    "us-west-2.elasticbeanstalk.com",
    "*.elb.amazonaws.com",
    "*.elb.amazonaws.com.cn",
    "awsglobalaccelerator.com",
    "s3.amazonaws.com",
    "s3-ap-northeast-1.amazonaws.com",
    "s3-ap-northeast-2.amazonaws.com",
    "s3-ap-south-1.amazonaws.com",
    "s3-ap-southeast-1.amazonaws.com",
    "s3-ap-southeast-2.amazonaws.com",
    "s3-ca-central-1.amazonaws.com",
    "s3-eu-central-1.amazonaws.com",
    "s3-eu-west-1.amazonaws.com",
    "s3-eu-west-2.amazonaws.com",
    "s3-eu-west-3.amazonaws.com",
    "s3-external-1.amazonaws.com",
    "s3-fips-us-gov-west-1.amazonaws.com",
    "s3-sa-east-1.amazonaws.com",
    "s3-us-gov-west-1.amazonaws.com",
    "s3-us-east-2.amazonaws.com",
    "s3-us-west-1.amazonaws.com",
    "s3-us-west-2.amazonaws.com",
    "s3.ap-northeast-2.amazonaws.com",
    "s3.ap-south-1.amazonaws.com",
    "s3.cn-north-1.amazonaws.com.cn",
    "s3.ca-central-1.amazonaws.com",
    "s3.eu-central-1.amazonaws.com",
    "s3.eu-west-2.amazonaws.com",
    "s3.eu-west-3.amazonaws.com",
    "s3.us-east-2.amazonaws.com",
    "s3.dualstack.ap-northeast-1.amazonaws.com",
    "s3.dualstack.ap-northeast-2.amazonaws.com",
    "s3.dualstack.ap-south-1.amazonaws.com",
    "s3.dualstack.ap-southeast-1.amazonaws.com",
    "s3.dualstack.ap-southeast-2.amazonaws.com",
    "s3.dualstack.ca-central-1.amazonaws.com",
    "s3.dualstack.eu-central-1.amazonaws.com",
    "s3.dualstack.eu-west-1.amazonaws.com",
    "s3.dualstack.eu-west-2.amazonaws.com",
    "s3.dualstack.eu-west-3.amazonaws.com",
    "s3.dualstack.sa-east-1.amazonaws.com",
    "s3.dualstack.us-east-1.amazonaws.com",
    "s3.dualstack.us-east-2.amazonaws.com",
    "s3-website-us-east-1.amazonaws.com",
    "s3-website-us-west-1.amazonaws.com",
    "s3-website-us-west-2.amazonaws.com",
    "s3-website-ap-northeast-1.amazonaws.com",
    "s3-website-ap-southeast-1.amazonaws.com",
    "s3-website-ap-southeast-2.amazonaws.com",
    "s3-website-eu-west-1.amazonaws.com",
    "s3-website-sa-east-1.amazonaws.com",
    "s3-website.ap-northeast-2.amazonaws.com",
    "s3-website.ap-south-1.amazonaws.com",
    "s3-website.ca-central-1.amazonaws.com",
    "s3-website.eu-central-1.amazonaws.com",
    "s3-website.eu-west-2.amazonaws.com",
    "s3-website.eu-west-3.amazonaws.com",
    "s3-website.us-east-2.amazonaws.com",
    "t3l3p0rt.net",
    "tele.amune.org",
    "apigee.io",
    "siiites.com",
    "appspacehosted.com",
    "appspaceusercontent.com",
    "appudo.net",
    "on-aptible.com",
    "user.aseinet.ne.jp",
    "gv.vc",
    "d.gv.vc",
    "user.party.eus",
    "pimienta.org",
    "poivron.org",
    "potager.org",
    "sweetpepper.org",
    "myasustor.com",
    "cdn.prod.atlassian-dev.net",
    "translated.page",
    "myfritz.net",
    "onavstack.net",
    "*.awdev.ca",
    "*.advisor.ws",
    "ecommerce-shop.pl",
    "b-data.io",
    "backplaneapp.io",
    "balena-devices.com",
    "rs.ba",
    "*.banzai.cloud",
    "app.banzaicloud.io",
    "*.backyards.banzaicloud.io",
    "base.ec",
    "official.ec",
    "buyshop.jp",
    "fashionstore.jp",
    "handcrafted.jp",
    "kawaiishop.jp",
    "supersale.jp",
    "theshop.jp",
    "shopselect.net",
    "base.shop",
    "*.beget.app",
    "betainabox.com",
    "bnr.la",
    "bitbucket.io",
    "blackbaudcdn.net",
    "of.je",
    "bluebite.io",
    "boomla.net",
    "boutir.com",
    "boxfuse.io",
    "square7.ch",
    "bplaced.com",
    "bplaced.de",
    "square7.de",
    "bplaced.net",
    "square7.net",
    "shop.brendly.rs",
    "browsersafetymark.io",
    "uk0.bigv.io",
    "dh.bytemark.co.uk",
    "vm.bytemark.co.uk",
    "cafjs.com",
    "mycd.eu",
    "drr.ac",
    "uwu.ai",
    "carrd.co",
    "crd.co",
    "ju.mp",
    "ae.org",
    "br.com",
    "cn.com",
    "com.de",
    "com.se",
    "de.com",
    "eu.com",
    "gb.net",
    "hu.net",
    "jp.net",
    "jpn.com",
    "mex.com",
    "ru.com",
    "sa.com",
    "se.net",
    "uk.com",
    "uk.net",
    "us.com",
    "za.bz",
    "za.com",
    "ar.com",
    "hu.com",
    "kr.com",
    "no.com",
    "qc.com",
    "uy.com",
    "africa.com",
    "gr.com",
    "in.net",
    "web.in",
    "us.org",
    "co.com",
    "aus.basketball",
    "nz.basketball",
    "radio.am",
    "radio.fm",
    "c.la",
    "certmgr.org",
    "cx.ua",
    "discourse.group",
    "discourse.team",
    "cleverapps.io",
    "clerk.app",
    "clerkstage.app",
    "*.lcl.dev",
    "*.lclstage.dev",
    "*.stg.dev",
    "*.stgstage.dev",
    "clickrising.net",
    "c66.me",
    "cloud66.ws",
    "cloud66.zone",
    "jdevcloud.com",
    "wpdevcloud.com",
    "cloudaccess.host",
    "freesite.host",
    "cloudaccess.net",
    "cloudcontrolled.com",
    "cloudcontrolapp.com",
    "*.cloudera.site",
    "pages.dev",
    "trycloudflare.com",
    "workers.dev",
    "wnext.app",
    "co.ca",
    "*.otap.co",
    "co.cz",
    "c.cdn77.org",
    "cdn77-ssl.net",
    "r.cdn77.net",
    "rsc.cdn77.org",
    "ssl.origin.cdn77-secure.org",
    "cloudns.asia",
    "cloudns.biz",
    "cloudns.club",
    "cloudns.cc",
    "cloudns.eu",
    "cloudns.in",
    "cloudns.info",
    "cloudns.org",
    "cloudns.pro",
    "cloudns.pw",
    "cloudns.us",
    "cnpy.gdn",
    "codeberg.page",
    "co.nl",
    "co.no",
    "webhosting.be",
    "hosting-cluster.nl",
    "ac.ru",
    "edu.ru",
    "gov.ru",
    "int.ru",
    "mil.ru",
    "test.ru",
    "dyn.cosidns.de",
    "dynamisches-dns.de",
    "dnsupdater.de",
    "internet-dns.de",
    "l-o-g-i-n.de",
    "dynamic-dns.info",
    "feste-ip.net",
    "knx-server.net",
    "static-access.net",
    "realm.cz",
    "*.cryptonomic.net",
    "cupcake.is",
    "curv.dev",
    "*.customer-oci.com",
    "*.oci.customer-oci.com",
    "*.ocp.customer-oci.com",
    "*.ocs.customer-oci.com",
    "cyon.link",
    "cyon.site",
    "fnwk.site",
    "folionetwork.site",
    "platform0.app",
    "daplie.me",
    "localhost.daplie.me",
    "dattolocal.com",
    "dattorelay.com",
    "dattoweb.com",
    "mydatto.com",
    "dattolocal.net",
    "mydatto.net",
    "biz.dk",
    "co.dk",
    "firm.dk",
    "reg.dk",
    "store.dk",
    "dyndns.dappnode.io",
    "*.dapps.earth",
    "*.bzz.dapps.earth",
    "builtwithdark.com",
    "demo.datadetect.com",
    "instance.datadetect.com",
    "edgestack.me",
    "ddns5.com",
    "debian.net",
    "deno.dev",
    "deno-staging.dev",
    "dedyn.io",
    "deta.app",
    "deta.dev",
    "*.rss.my.id",
    "*.diher.solutions",
    "discordsays.com",
    "discordsez.com",
    "jozi.biz",
    "dnshome.de",
    "online.th",
    "shop.th",
    "drayddns.com",
    "shoparena.pl",
    "dreamhosters.com",
    "mydrobo.com",
    "drud.io",
    "drud.us",
    "duckdns.org",
    "bip.sh",
    "bitbridge.net",
    "dy.fi",
    "tunk.org",
    "dyndns-at-home.com",
    "dyndns-at-work.com",
    "dyndns-blog.com",
    "dyndns-free.com",
    "dyndns-home.com",
    "dyndns-ip.com",
    "dyndns-mail.com",
    "dyndns-office.com",
    "dyndns-pics.com",
    "dyndns-remote.com",
    "dyndns-server.com",
    "dyndns-web.com",
    "dyndns-wiki.com",
    "dyndns-work.com",
    "dyndns.biz",
    "dyndns.info",
    "dyndns.org",
    "dyndns.tv",
    "at-band-camp.net",
    "ath.cx",
    "barrel-of-knowledge.info",
    "barrell-of-knowledge.info",
    "better-than.tv",
    "blogdns.com",
    "blogdns.net",
    "blogdns.org",
    "blogsite.org",
    "boldlygoingnowhere.org",
    "broke-it.net",
    "buyshouses.net",
    "cechire.com",
    "dnsalias.com",
    "dnsalias.net",
    "dnsalias.org",
    "dnsdojo.com",
    "dnsdojo.net",
    "dnsdojo.org",
    "does-it.net",
    "doesntexist.com",
    "doesntexist.org",
    "dontexist.com",
    "dontexist.net",
    "dontexist.org",
    "doomdns.com",
    "doomdns.org",
    "dvrdns.org",
    "dyn-o-saur.com",
    "dynalias.com",
    "dynalias.net",
    "dynalias.org",
    "dynathome.net",
    "dyndns.ws",
    "endofinternet.net",
    "endofinternet.org",
    "endoftheinternet.org",
    "est-a-la-maison.com",
    "est-a-la-masion.com",
    "est-le-patron.com",
    "est-mon-blogueur.com",
    "for-better.biz",
    "for-more.biz",
    "for-our.info",
    "for-some.biz",
    "for-the.biz",
    "forgot.her.name",
    "forgot.his.name",
    "from-ak.com",
    "from-al.com",
    "from-ar.com",
    "from-az.net",
    "from-ca.com",
    "from-co.net",
    "from-ct.com",
    "from-dc.com",
    "from-de.com",
    "from-fl.com",
    "from-ga.com",
    "from-hi.com",
    "from-ia.com",
    "from-id.com",
    "from-il.com",
    "from-in.com",
    "from-ks.com",
    "from-ky.com",
    "from-la.net",
    "from-ma.com",
    "from-md.com",
    "from-me.org",
    "from-mi.com",
    "from-mn.com",
    "from-mo.com",
    "from-ms.com",
    "from-mt.com",
    "from-nc.com",
    "from-nd.com",
    "from-ne.com",
    "from-nh.com",
    "from-nj.com",
    "from-nm.com",
    "from-nv.com",
    "from-ny.net",
    "from-oh.com",
    "from-ok.com",
    "from-or.com",
    "from-pa.com",
    "from-pr.com",
    "from-ri.com",
    "from-sc.com",
    "from-sd.com",
    "from-tn.com",
    "from-tx.com",
    "from-ut.com",
    "from-va.com",
    "from-vt.com",
    "from-wa.com",
    "from-wi.com",
    "from-wv.com",
    "from-wy.com",
    "ftpaccess.cc",
    "fuettertdasnetz.de",
    "game-host.org",
    "game-server.cc",
    "getmyip.com",
    "gets-it.net",
    "go.dyndns.org",
    "gotdns.com",
    "gotdns.org",
    "groks-the.info",
    "groks-this.info",
    "ham-radio-op.net",
    "here-for-more.info",
    "hobby-site.com",
    "hobby-site.org",
    "home.dyndns.org",
    "homedns.org",
    "homeftp.net",
    "homeftp.org",
    "homeip.net",
    "homelinux.com",
    "homelinux.net",
    "homelinux.org",
    "homeunix.com",
    "homeunix.net",
    "homeunix.org",
    "iamallama.com",
    "in-the-band.net",
    "is-a-anarchist.com",
    "is-a-blogger.com",
    "is-a-bookkeeper.com",
    "is-a-bruinsfan.org",
    "is-a-bulls-fan.com",
    "is-a-candidate.org",
    "is-a-caterer.com",
    "is-a-celticsfan.org",
    "is-a-chef.com",
    "is-a-chef.net",
    "is-a-chef.org",
    "is-a-conservative.com",
    "is-a-cpa.com",
    "is-a-cubicle-slave.com",
    "is-a-democrat.com",
    "is-a-designer.com",
    "is-a-doctor.com",
    "is-a-financialadvisor.com",
    "is-a-geek.com",
    "is-a-geek.net",
    "is-a-geek.org",
    "is-a-green.com",
    "is-a-guru.com",
    "is-a-hard-worker.com",
    "is-a-hunter.com",
    "is-a-knight.org",
    "is-a-landscaper.com",
    "is-a-lawyer.com",
    "is-a-liberal.com",
    "is-a-libertarian.com",
    "is-a-linux-user.org",
    "is-a-llama.com",
    "is-a-musician.com",
    "is-a-nascarfan.com",
    "is-a-nurse.com",
    "is-a-painter.com",
    "is-a-patsfan.org",
    "is-a-personaltrainer.com",
    "is-a-photographer.com",
    "is-a-player.com",
    "is-a-republican.com",
    "is-a-rockstar.com",
    "is-a-socialist.com",
    "is-a-soxfan.org",
    "is-a-student.com",
    "is-a-teacher.com",
    "is-a-techie.com",
    "is-a-therapist.com",
    "is-an-accountant.com",
    "is-an-actor.com",
    "is-an-actress.com",
    "is-an-anarchist.com",
    "is-an-artist.com",
    "is-an-engineer.com",
    "is-an-entertainer.com",
    "is-by.us",
    "is-certified.com",
    "is-found.org",
    "is-gone.com",
    "is-into-anime.com",
    "is-into-cars.com",
    "is-into-cartoons.com",
    "is-into-games.com",
    "is-leet.com",
    "is-lost.org",
    "is-not-certified.com",
    "is-saved.org",
    "is-slick.com",
    "is-uberleet.com",
    "is-very-bad.org",
    "is-very-evil.org",
    "is-very-good.org",
    "is-very-nice.org",
    "is-very-sweet.org",
    "is-with-theband.com",
    "isa-geek.com",
    "isa-geek.net",
    "isa-geek.org",
    "isa-hockeynut.com",
    "issmarterthanyou.com",
    "isteingeek.de",
    "istmein.de",
    "kicks-ass.net",
    "kicks-ass.org",
    "knowsitall.info",
    "land-4-sale.us",
    "lebtimnetz.de",
    "leitungsen.de",
    "likes-pie.com",
    "likescandy.com",
    "merseine.nu",
    "mine.nu",
    "misconfused.org",
    "mypets.ws",
    "myphotos.cc",
    "neat-url.com",
    "office-on-the.net",
    "on-the-web.tv",
    "podzone.net",
    "podzone.org",
    "readmyblog.org",
    "saves-the-whales.com",
    "scrapper-site.net",
    "scrapping.cc",
    "selfip.biz",
    "selfip.com",
    "selfip.info",
    "selfip.net",
    "selfip.org",
    "sells-for-less.com",
    "sells-for-u.com",
    "sells-it.net",
    "sellsyourhome.org",
    "servebbs.com",
    "servebbs.net",
    "servebbs.org",
    "serveftp.net",
    "serveftp.org",
    "servegame.org",
    "shacknet.nu",
    "simple-url.com",
    "space-to-rent.com",
    "stuff-4-sale.org",
    "stuff-4-sale.us",
    "teaches-yoga.com",
    "thruhere.net",
    "traeumtgerade.de",
    "webhop.biz",
    "webhop.info",
    "webhop.net",
    "webhop.org",
    "worse-than.tv",
    "writesthisblog.com",
    "ddnss.de",
    "dyn.ddnss.de",
    "dyndns.ddnss.de",
    "dyndns1.de",
    "dyn-ip24.de",
    "home-webserver.de",
    "dyn.home-webserver.de",
    "myhome-server.de",
    "ddnss.org",
    "definima.net",
    "definima.io",
    "ondigitalocean.app",
    "*.digitaloceanspaces.com",
    "bci.dnstrace.pro",
    "ddnsfree.com",
    "ddnsgeek.com",
    "giize.com",
    "gleeze.com",
    "kozow.com",
    "loseyourip.com",
    "ooguy.com",
    "theworkpc.com",
    "casacam.net",
    "dynu.net",
    "accesscam.org",
    "camdvr.org",
    "freeddns.org",
    "mywire.org",
    "webredirect.org",
    "myddns.rocks",
    "blogsite.xyz",
    "dynv6.net",
    "e4.cz",
    "eero.online",
    "eero-stage.online",
    "elementor.cloud",
    "elementor.cool",
    "en-root.fr",
    "mytuleap.com",
    "tuleap-partners.com",
    "encr.app",
    "encoreapi.com",
    "onred.one",
    "staging.onred.one",
    "eu.encoway.cloud",
    "eu.org",
    "al.eu.org",
    "asso.eu.org",
    "at.eu.org",
    "au.eu.org",
    "be.eu.org",
    "bg.eu.org",
    "ca.eu.org",
    "cd.eu.org",
    "ch.eu.org",
    "cn.eu.org",
    "cy.eu.org",
    "cz.eu.org",
    "de.eu.org",
    "dk.eu.org",
    "edu.eu.org",
    "ee.eu.org",
    "es.eu.org",
    "fi.eu.org",
    "fr.eu.org",
    "gr.eu.org",
    "hr.eu.org",
    "hu.eu.org",
    "ie.eu.org",
    "il.eu.org",
    "in.eu.org",
    "int.eu.org",
    "is.eu.org",
    "it.eu.org",
    "jp.eu.org",
    "kr.eu.org",
    "lt.eu.org",
    "lu.eu.org",
    "lv.eu.org",
    "mc.eu.org",
    "me.eu.org",
    "mk.eu.org",
    "mt.eu.org",
    "my.eu.org",
    "net.eu.org",
    "ng.eu.org",
    "nl.eu.org",
    "no.eu.org",
    "nz.eu.org",
    "paris.eu.org",
    "pl.eu.org",
    "pt.eu.org",
    "q-a.eu.org",
    "ro.eu.org",
    "ru.eu.org",
    "se.eu.org",
    "si.eu.org",
    "sk.eu.org",
    "tr.eu.org",
    "uk.eu.org",
    "us.eu.org",
    "eurodir.ru",
    "eu-1.evennode.com",
    "eu-2.evennode.com",
    "eu-3.evennode.com",
    "eu-4.evennode.com",
    "us-1.evennode.com",
    "us-2.evennode.com",
    "us-3.evennode.com",
    "us-4.evennode.com",
    "twmail.cc",
    "twmail.net",
    "twmail.org",
    "mymailer.com.tw",
    "url.tw",
    "onfabrica.com",
    "apps.fbsbx.com",
    "ru.net",
    "adygeya.ru",
    "bashkiria.ru",
    "bir.ru",
    "cbg.ru",
    "com.ru",
    "dagestan.ru",
    "grozny.ru",
    "kalmykia.ru",
    "kustanai.ru",
    "marine.ru",
    "mordovia.ru",
    "msk.ru",
    "mytis.ru",
    "nalchik.ru",
    "nov.ru",
    "pyatigorsk.ru",
    "spb.ru",
    "vladikavkaz.ru",
    "vladimir.ru",
    "abkhazia.su",
    "adygeya.su",
    "aktyubinsk.su",
    "arkhangelsk.su",
    "armenia.su",
    "ashgabad.su",
    "azerbaijan.su",
    "balashov.su",
    "bashkiria.su",
    "bryansk.su",
    "bukhara.su",
    "chimkent.su",
    "dagestan.su",
    "east-kazakhstan.su",
    "exnet.su",
    "georgia.su",
    "grozny.su",
    "ivanovo.su",
    "jambyl.su",
    "kalmykia.su",
    "kaluga.su",
    "karacol.su",
    "karaganda.su",
    "karelia.su",
    "khakassia.su",
    "krasnodar.su",
    "kurgan.su",
    "kustanai.su",
    "lenug.su",
    "mangyshlak.su",
    "mordovia.su",
    "msk.su",
    "murmansk.su",
    "nalchik.su",
    "navoi.su",
    "north-kazakhstan.su",
    "nov.su",
    "obninsk.su",
    "penza.su",
    "pokrovsk.su",
    "sochi.su",
    "spb.su",
    "tashkent.su",
    "termez.su",
    "togliatti.su",
    "troitsk.su",
    "tselinograd.su",
    "tula.su",
    "tuva.su",
    "vladikavkaz.su",
    "vladimir.su",
    "vologda.su",
    "channelsdvr.net",
    "u.channelsdvr.net",
    "edgecompute.app",
    "fastly-terrarium.com",
    "fastlylb.net",
    "map.fastlylb.net",
    "freetls.fastly.net",
    "map.fastly.net",
    "a.prod.fastly.net",
    "global.prod.fastly.net",
    "a.ssl.fastly.net",
    "b.ssl.fastly.net",
    "global.ssl.fastly.net",
    "fastvps-server.com",
    "fastvps.host",
    "myfast.host",
    "fastvps.site",
    "myfast.space",
    "fedorainfracloud.org",
    "fedorapeople.org",
    "cloud.fedoraproject.org",
    "app.os.fedoraproject.org",
    "app.os.stg.fedoraproject.org",
    "conn.uk",
    "copro.uk",
    "hosp.uk",
    "mydobiss.com",
    "fh-muenster.io",
    "filegear.me",
    "filegear-au.me",
    "filegear-de.me",
    "filegear-gb.me",
    "filegear-ie.me",
    "filegear-jp.me",
    "filegear-sg.me",
    "firebaseapp.com",
    "fireweb.app",
    "flap.id",
    "onflashdrive.app",
    "fldrv.com",
    "fly.dev",
    "edgeapp.net",
    "shw.io",
    "flynnhosting.net",
    "forgeblocks.com",
    "id.forgerock.io",
    "framer.app",
    "framercanvas.com",
    "*.frusky.de",
    "ravpage.co.il",
    "0e.vc",
    "freebox-os.com",
    "freeboxos.com",
    "fbx-os.fr",
    "fbxos.fr",
    "freebox-os.fr",
    "freeboxos.fr",
    "freedesktop.org",
    "freemyip.com",
    "wien.funkfeuer.at",
    "*.futurecms.at",
    "*.ex.futurecms.at",
    "*.in.futurecms.at",
    "futurehosting.at",
    "futuremailing.at",
    "*.ex.ortsinfo.at",
    "*.kunden.ortsinfo.at",
    "*.statics.cloud",
    "independent-commission.uk",
    "independent-inquest.uk",
    "independent-inquiry.uk",
    "independent-panel.uk",
    "independent-review.uk",
    "public-inquiry.uk",
    "royal-commission.uk",
    "campaign.gov.uk",
    "service.gov.uk",
    "api.gov.uk",
    "gehirn.ne.jp",
    "usercontent.jp",
    "gentapps.com",
    "gentlentapis.com",
    "lab.ms",
    "cdn-edges.net",
    "ghost.io",
    "gsj.bz",
    "githubusercontent.com",
    "githubpreview.dev",
    "github.io",
    "gitlab.io",
    "gitapp.si",
    "gitpage.si",
    "glitch.me",
    "nog.community",
    "co.ro",
    "shop.ro",
    "lolipop.io",
    "angry.jp",
    "babyblue.jp",
    "babymilk.jp",
    "backdrop.jp",
    "bambina.jp",
    "bitter.jp",
    "blush.jp",
    "boo.jp",
    "boy.jp",
    "boyfriend.jp",
    "but.jp",
    "candypop.jp",
    "capoo.jp",
    "catfood.jp",
    "cheap.jp",
    "chicappa.jp",
    "chillout.jp",
    "chips.jp",
    "chowder.jp",
    "chu.jp",
    "ciao.jp",
    "cocotte.jp",
    "coolblog.jp",
    "cranky.jp",
    "cutegirl.jp",
    "daa.jp",
    "deca.jp",
    "deci.jp",
    "digick.jp",
    "egoism.jp",
    "fakefur.jp",
    "fem.jp",
    "flier.jp",
    "floppy.jp",
    "fool.jp",
    "frenchkiss.jp",
    "girlfriend.jp",
    "girly.jp",
    "gloomy.jp",
    "gonna.jp",
    "greater.jp",
    "hacca.jp",
    "heavy.jp",
    "her.jp",
    "hiho.jp",
    "hippy.jp",
    "holy.jp",
    "hungry.jp",
    "icurus.jp",
    "itigo.jp",
    "jellybean.jp",
    "kikirara.jp",
    "kill.jp",
    "kilo.jp",
    "kuron.jp",
    "littlestar.jp",
    "lolipopmc.jp",
    "lolitapunk.jp",
    "lomo.jp",
    "lovepop.jp",
    "lovesick.jp",
    "main.jp",
    "mods.jp",
    "mond.jp",
    "mongolian.jp",
    "moo.jp",
    "namaste.jp",
    "nikita.jp",
    "nobushi.jp",
    "noor.jp",
    "oops.jp",
    "parallel.jp",
    "parasite.jp",
    "pecori.jp",
    "peewee.jp",
    "penne.jp",
    "pepper.jp",
    "perma.jp",
    "pigboat.jp",
    "pinoko.jp",
    "punyu.jp",
    "pupu.jp",
    "pussycat.jp",
    "pya.jp",
    "raindrop.jp",
    "readymade.jp",
    "sadist.jp",
    "schoolbus.jp",
    "secret.jp",
    "staba.jp",
    "stripper.jp",
    "sub.jp",
    "sunnyday.jp",
    "thick.jp",
    "tonkotsu.jp",
    "under.jp",
    "upper.jp",
    "velvet.jp",
    "verse.jp",
    "versus.jp",
    "vivian.jp",
    "watson.jp",
    "weblike.jp",
    "whitesnow.jp",
    "zombie.jp",
    "heteml.net",
    "cloudapps.digital",
    "london.cloudapps.digital",
    "pymnt.uk",
    "homeoffice.gov.uk",
    "ro.im",
    "goip.de",
    "run.app",
    "a.run.app",
    "web.app",
    "*.0emm.com",
    "appspot.com",
    "*.r.appspot.com",
    "codespot.com",
    "googleapis.com",
    "googlecode.com",
    "pagespeedmobilizer.com",
    "publishproxy.com",
    "withgoogle.com",
    "withyoutube.com",
    "*.gateway.dev",
    "cloud.goog",
    "translate.goog",
    "*.usercontent.goog",
    "cloudfunctions.net",
    "blogspot.ae",
    "blogspot.al",
    "blogspot.am",
    "blogspot.ba",
    "blogspot.be",
    "blogspot.bg",
    "blogspot.bj",
    "blogspot.ca",
    "blogspot.cf",
    "blogspot.ch",
    "blogspot.cl",
    "blogspot.co.at",
    "blogspot.co.id",
    "blogspot.co.il",
    "blogspot.co.ke",
    "blogspot.co.nz",
    "blogspot.co.uk",
    "blogspot.co.za",
    "blogspot.com",
    "blogspot.com.ar",
    "blogspot.com.au",
    "blogspot.com.br",
    "blogspot.com.by",
    "blogspot.com.co",
    "blogspot.com.cy",
    "blogspot.com.ee",
    "blogspot.com.eg",
    "blogspot.com.es",
    "blogspot.com.mt",
    "blogspot.com.ng",
    "blogspot.com.tr",
    "blogspot.com.uy",
    "blogspot.cv",
    "blogspot.cz",
    "blogspot.de",
    "blogspot.dk",
    "blogspot.fi",
    "blogspot.fr",
    "blogspot.gr",
    "blogspot.hk",
    "blogspot.hr",
    "blogspot.hu",
    "blogspot.ie",
    "blogspot.in",
    "blogspot.is",
    "blogspot.it",
    "blogspot.jp",
    "blogspot.kr",
    "blogspot.li",
    "blogspot.lt",
    "blogspot.lu",
    "blogspot.md",
    "blogspot.mk",
    "blogspot.mr",
    "blogspot.mx",
    "blogspot.my",
    "blogspot.nl",
    "blogspot.no",
    "blogspot.pe",
    "blogspot.pt",
    "blogspot.qa",
    "blogspot.re",
    "blogspot.ro",
    "blogspot.rs",
    "blogspot.ru",
    "blogspot.se",
    "blogspot.sg",
    "blogspot.si",
    "blogspot.sk",
    "blogspot.sn",
    "blogspot.td",
    "blogspot.tw",
    "blogspot.ug",
    "blogspot.vn",
    "goupile.fr",
    "gov.nl",
    "awsmppl.com",
    "günstigbestellen.de",
    "günstigliefern.de",
    "fin.ci",
    "free.hr",
    "caa.li",
    "ua.rs",
    "conf.se",
    "hs.zone",
    "hs.run",
    "hashbang.sh",
    "hasura.app",
    "hasura-app.io",
    "pages.it.hs-heilbronn.de",
    "hepforge.org",
    "herokuapp.com",
    "herokussl.com",
    "ravendb.cloud",
    "myravendb.com",
    "ravendb.community",
    "ravendb.me",
    "development.run",
    "ravendb.run",
    "homesklep.pl",
    "secaas.hk",
    "hoplix.shop",
    "orx.biz",
    "biz.gl",
    "col.ng",
    "firm.ng",
    "gen.ng",
    "ltd.ng",
    "ngo.ng",
    "edu.scot",
    "sch.so",
    "hostyhosting.io",
    "häkkinen.fi",
    "*.moonscale.io",
    "moonscale.net",
    "iki.fi",
    "ibxos.it",
    "iliadboxos.it",
    "impertrixcdn.com",
    "impertrix.com",
    "smushcdn.com",
    "wphostedmail.com",
    "wpmucdn.com",
    "tempurl.host",
    "wpmudev.host",
    "dyn-berlin.de",
    "in-berlin.de",
    "in-brb.de",
    "in-butter.de",
    "in-dsl.de",
    "in-dsl.net",
    "in-dsl.org",
    "in-vpn.de",
    "in-vpn.net",
    "in-vpn.org",
    "biz.at",
    "info.at",
    "info.cx",
    "ac.leg.br",
    "al.leg.br",
    "am.leg.br",
    "ap.leg.br",
    "ba.leg.br",
    "ce.leg.br",
    "df.leg.br",
    "es.leg.br",
    "go.leg.br",
    "ma.leg.br",
    "mg.leg.br",
    "ms.leg.br",
    "mt.leg.br",
    "pa.leg.br",
    "pb.leg.br",
    "pe.leg.br",
    "pi.leg.br",
    "pr.leg.br",
    "rj.leg.br",
    "rn.leg.br",
    "ro.leg.br",
    "rr.leg.br",
    "rs.leg.br",
    "sc.leg.br",
    "se.leg.br",
    "sp.leg.br",
    "to.leg.br",
    "pixolino.com",
    "na4u.ru",
    "iopsys.se",
    "ipifony.net",
    "iservschule.de",
    "mein-iserv.de",
    "schulplattform.de",
    "schulserver.de",
    "test-iserv.de",
    "iserv.dev",
    "iobb.net",
    "mel.cloudlets.com.au",
    "cloud.interhostsolutions.be",
    "users.scale.virtualcloud.com.br",
    "mycloud.by",
    "alp1.ae.flow.ch",
    "appengine.flow.ch",
    "es-1.axarnet.cloud",
    "diadem.cloud",
    "vip.jelastic.cloud",
    "jele.cloud",
    "it1.eur.aruba.jenv-aruba.cloud",
    "it1.jenv-aruba.cloud",
    "keliweb.cloud",
    "cs.keliweb.cloud",
    "oxa.cloud",
    "tn.oxa.cloud",
    "uk.oxa.cloud",
    "primetel.cloud",
    "uk.primetel.cloud",
    "ca.reclaim.cloud",
    "uk.reclaim.cloud",
    "us.reclaim.cloud",
    "ch.trendhosting.cloud",
    "de.trendhosting.cloud",
    "jele.club",
    "amscompute.com",
    "clicketcloud.com",
    "dopaas.com",
    "hidora.com",
    "paas.hosted-by-previder.com",
    "rag-cloud.hosteur.com",
    "rag-cloud-ch.hosteur.com",
    "jcloud.ik-server.com",
    "jcloud-ver-jpc.ik-server.com",
    "demo.jelastic.com",
    "kilatiron.com",
    "paas.massivegrid.com",
    "jed.wafaicloud.com",
    "lon.wafaicloud.com",
    "ryd.wafaicloud.com",
    "j.scaleforce.com.cy",
    "jelastic.dogado.eu",
    "fi.cloudplatform.fi",
    "demo.datacenter.fi",
    "paas.datacenter.fi",
    "jele.host",
    "mircloud.host",
    "paas.beebyte.io",
    "sekd1.beebyteapp.io",
    "jele.io",
    "cloud-fr1.unispace.io",
    "jc.neen.it",
    "cloud.jelastic.open.tim.it",
    "jcloud.kz",
    "upaas.kazteleport.kz",
    "cloudjiffy.net",
    "fra1-de.cloudjiffy.net",
    "west1-us.cloudjiffy.net",
    "jls-sto1.elastx.net",
    "jls-sto2.elastx.net",
    "jls-sto3.elastx.net",
    "faststacks.net",
    "fr-1.paas.massivegrid.net",
    "lon-1.paas.massivegrid.net",
    "lon-2.paas.massivegrid.net",
    "ny-1.paas.massivegrid.net",
    "ny-2.paas.massivegrid.net",
    "sg-1.paas.massivegrid.net",
    "jelastic.saveincloud.net",
    "nordeste-idc.saveincloud.net",
    "j.scaleforce.net",
    "jelastic.tsukaeru.net",
    "sdscloud.pl",
    "unicloud.pl",
    "mircloud.ru",
    "jelastic.regruhosting.ru",
    "enscaled.sg",
    "jele.site",
    "jelastic.team",
    "orangecloud.tn",
    "j.layershift.co.uk",
    "phx.enscaled.us",
    "mircloud.us",
    "myjino.ru",
    "*.hosting.myjino.ru",
    "*.landing.myjino.ru",
    "*.spectrum.myjino.ru",
    "*.vps.myjino.ru",
    "jotelulu.cloud",
    "*.triton.zone",
    "*.cns.joyent.com",
    "js.org",
    "kaas.gg",
    "khplay.nl",
    "ktistory.com",
    "kapsi.fi",
    "keymachine.de",
    "kinghost.net",
    "uni5.net",
    "knightpoint.systems",
    "koobin.events",
    "oya.to",
    "kuleuven.cloud",
    "ezproxy.kuleuven.be",
    "co.krd",
    "edu.krd",
    "krellian.net",
    "webthings.io",
    "git-repos.de",
    "lcube-server.de",
    "svn-repos.de",
    "leadpages.co",
    "lpages.co",
    "lpusercontent.com",
    "lelux.site",
    "co.business",
    "co.education",
    "co.events",
    "co.financial",
    "co.network",
    "co.place",
    "co.technology",
    "app.lmpm.com",
    "linkyard.cloud",
    "linkyard-cloud.ch",
    "members.linode.com",
    "*.nodebalancer.linode.com",
    "*.linodeobjects.com",
    "ip.linodeusercontent.com",
    "we.bs",
    "*.user.localcert.dev",
    "localzone.xyz",
    "loginline.app",
    "loginline.dev",
    "loginline.io",
    "loginline.services",
    "loginline.site",
    "servers.run",
    "lohmus.me",
    "krasnik.pl",
    "leczna.pl",
    "lubartow.pl",
    "lublin.pl",
    "poniatowa.pl",
    "swidnik.pl",
    "glug.org.uk",
    "lug.org.uk",
    "lugs.org.uk",
    "barsy.bg",
    "barsy.co.uk",
    "barsyonline.co.uk",
    "barsycenter.com",
    "barsyonline.com",
    "barsy.club",
    "barsy.de",
    "barsy.eu",
    "barsy.in",
    "barsy.info",
    "barsy.io",
    "barsy.me",
    "barsy.menu",
    "barsy.mobi",
    "barsy.net",
    "barsy.online",
    "barsy.org",
    "barsy.pro",
    "barsy.pub",
    "barsy.ro",
    "barsy.shop",
    "barsy.site",
    "barsy.support",
    "barsy.uk",
    "*.magentosite.cloud",
    "mayfirst.info",
    "mayfirst.org",
    "hb.cldmail.ru",
    "cn.vu",
    "mazeplay.com",
    "mcpe.me",
    "mcdir.me",
    "mcdir.ru",
    "mcpre.ru",
    "vps.mcdir.ru",
    "mediatech.by",
    "mediatech.dev",
    "hra.health",
    "miniserver.com",
    "memset.net",
    "messerli.app",
    "*.cloud.metacentrum.cz",
    "custom.metacentrum.cz",
    "flt.cloud.muni.cz",
    "usr.cloud.muni.cz",
    "meteorapp.com",
    "eu.meteorapp.com",
    "co.pl",
    "*.azurecontainer.io",
    "azurewebsites.net",
    "azure-mobile.net",
    "cloudapp.net",
    "azurestaticapps.net",
    "1.azurestaticapps.net",
    "centralus.azurestaticapps.net",
    "eastasia.azurestaticapps.net",
    "eastus2.azurestaticapps.net",
    "westeurope.azurestaticapps.net",
    "westus2.azurestaticapps.net",
    "csx.cc",
    "mintere.site",
    "forte.id",
    "mozilla-iot.org",
    "bmoattachments.org",
    "net.ru",
    "org.ru",
    "pp.ru",
    "hostedpi.com",
    "customer.mythic-beasts.com",
    "caracal.mythic-beasts.com",
    "fentiger.mythic-beasts.com",
    "lynx.mythic-beasts.com",
    "ocelot.mythic-beasts.com",
    "oncilla.mythic-beasts.com",
    "onza.mythic-beasts.com",
    "sphinx.mythic-beasts.com",
    "vs.mythic-beasts.com",
    "x.mythic-beasts.com",
    "yali.mythic-beasts.com",
    "cust.retrosnub.co.uk",
    "ui.nabu.casa",
    "pony.club",
    "of.fashion",
    "in.london",
    "of.london",
    "from.marketing",
    "with.marketing",
    "for.men",
    "repair.men",
    "and.mom",
    "for.mom",
    "for.one",
    "under.one",
    "for.sale",
    "that.win",
    "from.work",
    "to.work",
    "cloud.nospamproxy.com",
    "netlify.app",
    "4u.com",
    "ngrok.io",
    "nh-serv.co.uk",
    "nfshost.com",
    "*.developer.app",
    "noop.app",
    "*.northflank.app",
    "*.build.run",
    "*.code.run",
    "*.database.run",
    "*.migration.run",
    "noticeable.news",
    "dnsking.ch",
    "mypi.co",
    "n4t.co",
    "001www.com",
    "ddnslive.com",
    "myiphost.com",
    "forumz.info",
    "16-b.it",
    "32-b.it",
    "64-b.it",
    "soundcast.me",
    "tcp4.me",
    "dnsup.net",
    "hicam.net",
    "now-dns.net",
    "ownip.net",
    "vpndns.net",
    "dynserv.org",
    "now-dns.org",
    "x443.pw",
    "now-dns.top",
    "ntdll.top",
    "freeddns.us",
    "crafting.xyz",
    "zapto.xyz",
    "nsupdate.info",
    "nerdpol.ovh",
    "blogsyte.com",
    "brasilia.me",
    "cable-modem.org",
    "ciscofreak.com",
    "collegefan.org",
    "couchpotatofries.org",
    "damnserver.com",
    "ddns.me",
    "ditchyourip.com",
    "dnsfor.me",
    "dnsiskinky.com",
    "dvrcam.info",
    "dynns.com",
    "eating-organic.net",
    "fantasyleague.cc",
    "geekgalaxy.com",
    "golffan.us",
    "health-carereform.com",
    "homesecuritymac.com",
    "homesecuritypc.com",
    "hopto.me",
    "ilovecollege.info",
    "loginto.me",
    "mlbfan.org",
    "mmafan.biz",
    "myactivedirectory.com",
    "mydissent.net",
    "myeffect.net",
    "mymediapc.net",
    "mypsx.net",
    "mysecuritycamera.com",
    "mysecuritycamera.net",
    "mysecuritycamera.org",
    "net-freaks.com",
    "nflfan.org",
    "nhlfan.net",
    "no-ip.ca",
    "no-ip.co.uk",
    "no-ip.net",
    "noip.us",
    "onthewifi.com",
    "pgafan.net",
    "point2this.com",
    "pointto.us",
    "privatizehealthinsurance.net",
    "quicksytes.com",
    "read-books.org",
    "securitytactics.com",
    "serveexchange.com",
    "servehumour.com",
    "servep2p.com",
    "servesarcasm.com",
    "stufftoread.com",
    "ufcfan.org",
    "unusualperson.com",
    "workisboring.com",
    "3utilities.com",
    "bounceme.net",
    "ddns.net",
    "ddnsking.com",
    "gotdns.ch",
    "hopto.org",
    "myftp.biz",
    "myftp.org",
    "myvnc.com",
    "no-ip.biz",
    "no-ip.info",
    "no-ip.org",
    "noip.me",
    "redirectme.net",
    "servebeer.com",
    "serveblog.net",
    "servecounterstrike.com",
    "serveftp.com",
    "servegame.com",
    "servehalflife.com",
    "servehttp.com",
    "serveirc.com",
    "serveminecraft.net",
    "servemp3.com",
    "servepics.com",
    "servequake.com",
    "sytes.net",
    "webhop.me",
    "zapto.org",
    "stage.nodeart.io",
    "pcloud.host",
    "nyc.mn",
    "static.observableusercontent.com",
    "cya.gg",
    "omg.lol",
    "cloudycluster.net",
    "omniwe.site",
    "service.one",
    "nid.io",
    "opensocial.site",
    "opencraft.hosting",
    "orsites.com",
    "operaunite.com",
    "tech.orange",
    "authgear-staging.com",
    "authgearapps.com",
    "skygearapp.com",
    "outsystemscloud.com",
    "*.webpaas.ovh.net",
    "*.hosting.ovh.net",
    "ownprovider.com",
    "own.pm",
    "*.owo.codes",
    "ox.rs",
    "oy.lc",
    "pgfog.com",
    "pagefrontapp.com",
    "pagexl.com",
    "*.paywhirl.com",
    "bar0.net",
    "bar1.net",
    "bar2.net",
    "rdv.to",
    "art.pl",
    "gliwice.pl",
    "krakow.pl",
    "poznan.pl",
    "wroc.pl",
    "zakopane.pl",
    "pantheonsite.io",
    "gotpantheon.com",
    "mypep.link",
    "perspecta.cloud",
    "lk3.ru",
    "on-web.fr",
    "bc.platform.sh",
    "ent.platform.sh",
    "eu.platform.sh",
    "us.platform.sh",
    "*.platformsh.site",
    "*.tst.site",
    "platter-app.com",
    "platter-app.dev",
    "platterp.us",
    "pdns.page",
    "plesk.page",
    "pleskns.com",
    "dyn53.io",
    "onporter.run",
    "co.bn",
    "postman-echo.com",
    "pstmn.io",
    "mock.pstmn.io",
    "httpbin.org",
    "prequalifyme.today",
    "xen.prgmr.com",
    "priv.at",
    "prvcy.page",
    "*.dweb.link",
    "protonet.io",
    "chirurgiens-dentistes-en-france.fr",
    "byen.site",
    "pubtls.org",
    "pythonanywhere.com",
    "eu.pythonanywhere.com",
    "qoto.io",
    "qualifioapp.com",
    "qbuser.com",
    "cloudsite.builders",
    "instances.spawn.cc",
    "instantcloud.cn",
    "ras.ru",
    "qa2.com",
    "qcx.io",
    "*.sys.qcx.io",
    "dev-myqnapcloud.com",
    "alpha-myqnapcloud.com",
    "myqnapcloud.com",
    "*.quipelements.com",
    "vapor.cloud",
    "vaporcloud.io",
    "rackmaze.com",
    "rackmaze.net",
    "g.vbrplsbx.io",
    "*.on-k3s.io",
    "*.on-rancher.cloud",
    "*.on-rio.io",
    "readthedocs.io",
    "rhcloud.com",
    "app.render.com",
    "onrender.com",
    "repl.co",
    "id.repl.co",
    "repl.run",
    "resindevice.io",
    "devices.resinstaging.io",
    "hzc.io",
    "wellbeingzone.eu",
    "wellbeingzone.co.uk",
    "adimo.co.uk",
    "itcouldbewor.se",
    "git-pages.rit.edu",
    "rocky.page",
    "биз.рус",
    "ком.рус",
    "крым.рус",
    "мир.рус",
    "мск.рус",
    "орг.рус",
    "самара.рус",
    "сочи.рус",
    "спб.рус",
    "я.рус",
    "*.builder.code.com",
    "*.dev-builder.code.com",
    "*.stg-builder.code.com",
    "sandcats.io",
    "logoip.de",
    "logoip.com",
    "fr-par-1.baremetal.scw.cloud",
    "fr-par-2.baremetal.scw.cloud",
    "nl-ams-1.baremetal.scw.cloud",
    "fnc.fr-par.scw.cloud",
    "functions.fnc.fr-par.scw.cloud",
    "k8s.fr-par.scw.cloud",
    "nodes.k8s.fr-par.scw.cloud",
    "s3.fr-par.scw.cloud",
    "s3-website.fr-par.scw.cloud",
    "whm.fr-par.scw.cloud",
    "priv.instances.scw.cloud",
    "pub.instances.scw.cloud",
    "k8s.scw.cloud",
    "k8s.nl-ams.scw.cloud",
    "nodes.k8s.nl-ams.scw.cloud",
    "s3.nl-ams.scw.cloud",
    "s3-website.nl-ams.scw.cloud",
    "whm.nl-ams.scw.cloud",
    "k8s.pl-waw.scw.cloud",
    "nodes.k8s.pl-waw.scw.cloud",
    "s3.pl-waw.scw.cloud",
    "s3-website.pl-waw.scw.cloud",
    "scalebook.scw.cloud",
    "smartlabeling.scw.cloud",
    "dedibox.fr",
    "schokokeks.net",
    "gov.scot",
    "service.gov.scot",
    "scrysec.com",
    "firewall-gateway.com",
    "firewall-gateway.de",
    "my-gateway.de",
    "my-router.de",
    "spdns.de",
    "spdns.eu",
    "firewall-gateway.net",
    "my-firewall.org",
    "myfirewall.org",
    "spdns.org",
    "seidat.net",
    "sellfy.store",
    "senseering.net",
    "minisite.ms",
    "magnet.page",
    "biz.ua",
    "co.ua",
    "pp.ua",
    "shiftcrypto.dev",
    "shiftcrypto.io",
    "shiftedit.io",
    "myshopblocks.com",
    "myshopify.com",
    "shopitsite.com",
    "shopware.store",
    "mo-siemens.io",
    "1kapp.com",
    "appchizi.com",
    "applinzi.com",
    "sinaapp.com",
    "vipsinaapp.com",
    "siteleaf.net",
    "bounty-full.com",
    "alpha.bounty-full.com",
    "beta.bounty-full.com",
    "small-web.org",
    "vp4.me",
    "try-snowplow.com",
    "srht.site",
    "stackhero-network.com",
    "musician.io",
    "novecore.site",
    "static.land",
    "dev.static.land",
    "sites.static.land",
    "storebase.store",
    "vps-host.net",
    "atl.jelastic.vps-host.net",
    "njs.jelastic.vps-host.net",
    "ric.jelastic.vps-host.net",
    "playstation-cloud.com",
    "apps.lair.io",
    "*.stolos.io",
    "spacekit.io",
    "customer.speedpartner.de",
    "myspreadshop.at",
    "myspreadshop.com.au",
    "myspreadshop.be",
    "myspreadshop.ca",
    "myspreadshop.ch",
    "myspreadshop.com",
    "myspreadshop.de",
    "myspreadshop.dk",
    "myspreadshop.es",
    "myspreadshop.fi",
    "myspreadshop.fr",
    "myspreadshop.ie",
    "myspreadshop.it",
    "myspreadshop.net",
    "myspreadshop.nl",
    "myspreadshop.no",
    "myspreadshop.pl",
    "myspreadshop.se",
    "myspreadshop.co.uk",
    "api.stdlib.com",
    "storj.farm",
    "utwente.io",
    "soc.srcf.net",
    "user.srcf.net",
    "temp-dns.com",
    "supabase.co",
    "supabase.in",
    "supabase.net",
    "su.paba.se",
    "*.s5y.io",
    "*.sensiosite.cloud",
    "syncloud.it",
    "dscloud.biz",
    "direct.quickconnect.cn",
    "dsmynas.com",
    "familyds.com",
    "diskstation.me",
    "dscloud.me",
    "i234.me",
    "myds.me",
    "synology.me",
    "dscloud.mobi",
    "dsmynas.net",
    "familyds.net",
    "dsmynas.org",
    "familyds.org",
    "vpnplus.to",
    "direct.quickconnect.to",
    "tabitorder.co.il",
    "taifun-dns.de",
    "beta.tailscale.net",
    "ts.net",
    "gda.pl",
    "gdansk.pl",
    "gdynia.pl",
    "med.pl",
    "sopot.pl",
    "site.tb-hosting.com",
    "edugit.io",
    "s3.teckids.org",
    "telebit.app",
    "telebit.io",
    "*.telebit.xyz",
    "gwiddle.co.uk",
    "*.firenet.ch",
    "*.svc.firenet.ch",
    "reservd.com",
    "thingdustdata.com",
    "cust.dev.thingdust.io",
    "cust.disrec.thingdust.io",
    "cust.prod.thingdust.io",
    "cust.testing.thingdust.io",
    "reservd.dev.thingdust.io",
    "reservd.disrec.thingdust.io",
    "reservd.testing.thingdust.io",
    "tickets.io",
    "arvo.network",
    "azimuth.network",
    "tlon.network",
    "torproject.net",
    "pages.torproject.net",
    "bloxcms.com",
    "townnews-staging.com",
    "tbits.me",
    "12hp.at",
    "2ix.at",
    "4lima.at",
    "lima-city.at",
    "12hp.ch",
    "2ix.ch",
    "4lima.ch",
    "lima-city.ch",
    "trafficplex.cloud",
    "de.cool",
    "12hp.de",
    "2ix.de",
    "4lima.de",
    "lima-city.de",
    "1337.pictures",
    "clan.rip",
    "lima-city.rocks",
    "webspace.rocks",
    "lima.zone",
    "*.transurl.be",
    "*.transurl.eu",
    "*.transurl.nl",
    "site.transip.me",
    "tuxfamily.org",
    "dd-dns.de",
    "diskstation.eu",
    "diskstation.org",
    "dray-dns.de",
    "draydns.de",
    "dyn-vpn.de",
    "dynvpn.de",
    "mein-vigor.de",
    "my-vigor.de",
    "my-wan.de",
    "syno-ds.de",
    "synology-diskstation.de",
    "synology-ds.de",
    "typedream.app",
    "pro.typeform.com",
    "uber.space",
    "*.uberspace.de",
    "hk.com",
    "hk.org",
    "ltd.hk",
    "inc.hk",
    "name.pm",
    "sch.tf",
    "biz.wf",
    "sch.wf",
    "org.yt",
    "virtualuser.de",
    "virtual-user.de",
    "upli.io",
    "urown.cloud",
    "dnsupdate.info",
    "lib.de.us",
    "2038.io",
    "vercel.app",
    "vercel.dev",
    "now.sh",
    "router.management",
    "v-info.info",
    "voorloper.cloud",
    "neko.am",
    "nyaa.am",
    "be.ax",
    "cat.ax",
    "es.ax",
    "eu.ax",
    "gg.ax",
    "mc.ax",
    "us.ax",
    "xy.ax",
    "nl.ci",
    "xx.gl",
    "app.gp",
    "blog.gt",
    "de.gt",
    "to.gt",
    "be.gy",
    "cc.hn",
    "blog.kg",
    "io.kg",
    "jp.kg",
    "tv.kg",
    "uk.kg",
    "us.kg",
    "de.ls",
    "at.md",
    "de.md",
    "jp.md",
    "to.md",
    "indie.porn",
    "vxl.sh",
    "ch.tc",
    "me.tc",
    "we.tc",
    "nyan.to",
    "at.vg",
    "blog.vu",
    "dev.vu",
    "me.vu",
    "v.ua",
    "*.vultrobjects.com",
    "wafflecell.com",
    "*.webhare.dev",
    "reserve-online.net",
    "reserve-online.com",
    "bookonline.app",
    "hotelwithflight.com",
    "wedeploy.io",
    "wedeploy.me",
    "wedeploy.sh",
    "remotewd.com",
    "pages.wiardweb.com",
    "wmflabs.org",
    "toolforge.org",
    "wmcloud.org",
    "panel.gg",
    "daemon.panel.gg",
    "messwithdns.com",
    "woltlab-demo.com",
    "myforum.community",
    "community-pro.de",
    "diskussionsbereich.de",
    "community-pro.net",
    "meinforum.net",
    "affinitylottery.org.uk",
    "raffleentry.org.uk",
    "weeklylottery.org.uk",
    "wpenginepowered.com",
    "js.wpenginepowered.com",
    "wixsite.com",
    "editorx.io",
    "half.host",
    "xnbay.com",
    "u2.xnbay.com",
    "u2-local.xnbay.com",
    "cistron.nl",
    "demon.nl",
    "xs4all.space",
    "yandexcloud.net",
    "storage.yandexcloud.net",
    "website.yandexcloud.net",
    "official.academy",
    "yolasite.com",
    "ybo.faith",
    "yombo.me",
    "homelink.one",
    "ybo.party",
    "ybo.review",
    "ybo.science",
    "ybo.trade",
    "ynh.fr",
    "nohost.me",
    "noho.st",
    "za.net",
    "za.org",
    "bss.design",
    "basicserver.io",
    "virtualserver.io",
    "enterprisecloud.nu"
  ];
});

// ../node_modules/psl/index-72f7278d0035e72b3f590dcb594529c4-544c8ad1d62a03099a8d7ec2c4340acd.js
var Punycode, internals, $errorCodes, $parse = function(input) {
  if (typeof input !== "string") {
    throw new TypeError("Domain name must be a string.");
  }
  var domain = input.slice(0).toLowerCase();
  if (domain.charAt(domain.length - 1) === ".") {
    domain = domain.slice(0, domain.length - 1);
  }
  var error = internals.validate(domain);
  if (error) {
    return {
      input,
      error: {
        message: $errorCodes[error],
        code: error
      }
    };
  }
  var parsed = {
    input,
    tld: null,
    sld: null,
    domain: null,
    subdomain: null,
    listed: false
  };
  var domainParts = domain.split(".");
  if (domainParts[domainParts.length - 1] === "local") {
    return parsed;
  }
  var handlePunycode = function() {
    if (!/xn--/.test(domain)) {
      return parsed;
    }
    if (parsed.domain) {
      parsed.domain = Punycode.toASCII(parsed.domain);
    }
    if (parsed.subdomain) {
      parsed.subdomain = Punycode.toASCII(parsed.subdomain);
    }
    return parsed;
  };
  var rule = internals.findRule(domain);
  if (!rule) {
    if (domainParts.length < 2) {
      return parsed;
    }
    parsed.tld = domainParts.pop();
    parsed.sld = domainParts.pop();
    parsed.domain = [parsed.sld, parsed.tld].join(".");
    if (domainParts.length) {
      parsed.subdomain = domainParts.pop();
    }
    return handlePunycode();
  }
  parsed.listed = true;
  var tldParts = rule.suffix.split(".");
  var privateParts = domainParts.slice(0, domainParts.length - tldParts.length);
  if (rule.exception) {
    privateParts.push(tldParts.shift());
  }
  parsed.tld = tldParts.join(".");
  if (!privateParts.length) {
    return handlePunycode();
  }
  if (rule.wildcard) {
    tldParts.unshift(privateParts.pop());
    parsed.tld = tldParts.join(".");
  }
  if (!privateParts.length) {
    return handlePunycode();
  }
  parsed.sld = privateParts.pop();
  parsed.domain = [parsed.sld, parsed.tld].join(".");
  if (privateParts.length) {
    parsed.subdomain = privateParts.join(".");
  }
  return handlePunycode();
};
var init_psl = __esm(() => {
  Punycode = (init_punycode(), __toCommonJS(exports_punycode));
  internals = {};
  internals.rules = require_rules().map(function(rule) {
    return {
      rule,
      suffix: rule.replace(/^(\*\.|\!)/, ""),
      punySuffix: -1,
      wildcard: rule.charAt(0) === "*",
      exception: rule.charAt(0) === "!"
    };
  });
  internals.endsWith = function(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
  };
  internals.findRule = function(domain) {
    var punyDomain = Punycode.toASCII(domain);
    return internals.rules.reduce(function(memo, rule) {
      if (rule.punySuffix === -1) {
        rule.punySuffix = Punycode.toASCII(rule.suffix);
      }
      if (!internals.endsWith(punyDomain, "." + rule.punySuffix) && punyDomain !== rule.punySuffix) {
        return memo;
      }
      return rule;
    }, null);
  };
  $errorCodes = {
    DOMAIN_TOO_SHORT: "Domain name too short.",
    DOMAIN_TOO_LONG: "Domain name too long. It should be no more than 255 chars.",
    LABEL_STARTS_WITH_DASH: "Domain name label can not start with a dash.",
    LABEL_ENDS_WITH_DASH: "Domain name label can not end with a dash.",
    LABEL_TOO_LONG: "Domain name label should be at most 63 chars long.",
    LABEL_TOO_SHORT: "Domain name label should be at least 1 character long.",
    LABEL_INVALID_CHARS: "Domain name label can only contain alphanumeric characters or dashes."
  };
  internals.validate = function(input) {
    var ascii = Punycode.toASCII(input);
    if (ascii.length < 1) {
      return "DOMAIN_TOO_SHORT";
    }
    if (ascii.length > 255) {
      return "DOMAIN_TOO_LONG";
    }
    var labels = ascii.split(".");
    var label;
    for (var i = 0;i < labels.length; ++i) {
      label = labels[i];
      if (!label.length) {
        return "LABEL_TOO_SHORT";
      }
      if (label.length > 63) {
        return "LABEL_TOO_LONG";
      }
      if (label.charAt(0) === "-") {
        return "LABEL_STARTS_WITH_DASH";
      }
      if (label.charAt(label.length - 1) === "-") {
        return "LABEL_ENDS_WITH_DASH";
      }
      if (!/^[a-z0-9\-]+$/.test(label)) {
        return "LABEL_INVALID_CHARS";
      }
    }
  };
});

// ../node_modules/slugify/slugify.js
var require_slugify = __commonJS((exports, module) => {
  (function(name4, root, factory) {
    if (typeof exports === "object") {
      module.exports = factory();
      module.exports["default"] = factory();
    } else if (typeof define === "function" && define.amd) {
      define(factory);
    } else {
      root[name4] = factory();
    }
  })("slugify", exports, function() {
    var charMap = JSON.parse('{"$":"dollar","%":"percent","&":"and","<":"less",">":"greater","|":"or","¢":"cent","£":"pound","¤":"currency","¥":"yen","©":"(c)","ª":"a","®":"(r)","º":"o","À":"A","Á":"A","Â":"A","Ã":"A","Ä":"A","Å":"A","Æ":"AE","Ç":"C","È":"E","É":"E","Ê":"E","Ë":"E","Ì":"I","Í":"I","Î":"I","Ï":"I","Ð":"D","Ñ":"N","Ò":"O","Ó":"O","Ô":"O","Õ":"O","Ö":"O","Ø":"O","Ù":"U","Ú":"U","Û":"U","Ü":"U","Ý":"Y","Þ":"TH","ß":"ss","à":"a","á":"a","â":"a","ã":"a","ä":"a","å":"a","æ":"ae","ç":"c","è":"e","é":"e","ê":"e","ë":"e","ì":"i","í":"i","î":"i","ï":"i","ð":"d","ñ":"n","ò":"o","ó":"o","ô":"o","õ":"o","ö":"o","ø":"o","ù":"u","ú":"u","û":"u","ü":"u","ý":"y","þ":"th","ÿ":"y","Ā":"A","ā":"a","Ă":"A","ă":"a","Ą":"A","ą":"a","Ć":"C","ć":"c","Č":"C","č":"c","Ď":"D","ď":"d","Đ":"DJ","đ":"dj","Ē":"E","ē":"e","Ė":"E","ė":"e","Ę":"e","ę":"e","Ě":"E","ě":"e","Ğ":"G","ğ":"g","Ģ":"G","ģ":"g","Ĩ":"I","ĩ":"i","Ī":"i","ī":"i","Į":"I","į":"i","İ":"I","ı":"i","Ķ":"k","ķ":"k","Ļ":"L","ļ":"l","Ľ":"L","ľ":"l","Ł":"L","ł":"l","Ń":"N","ń":"n","Ņ":"N","ņ":"n","Ň":"N","ň":"n","Ō":"O","ō":"o","Ő":"O","ő":"o","Œ":"OE","œ":"oe","Ŕ":"R","ŕ":"r","Ř":"R","ř":"r","Ś":"S","ś":"s","Ş":"S","ş":"s","Š":"S","š":"s","Ţ":"T","ţ":"t","Ť":"T","ť":"t","Ũ":"U","ũ":"u","Ū":"u","ū":"u","Ů":"U","ů":"u","Ű":"U","ű":"u","Ų":"U","ų":"u","Ŵ":"W","ŵ":"w","Ŷ":"Y","ŷ":"y","Ÿ":"Y","Ź":"Z","ź":"z","Ż":"Z","ż":"z","Ž":"Z","ž":"z","Ə":"E","ƒ":"f","Ơ":"O","ơ":"o","Ư":"U","ư":"u","ǈ":"LJ","ǉ":"lj","ǋ":"NJ","ǌ":"nj","Ș":"S","ș":"s","Ț":"T","ț":"t","ə":"e","˚":"o","Ά":"A","Έ":"E","Ή":"H","Ί":"I","Ό":"O","Ύ":"Y","Ώ":"W","ΐ":"i","Α":"A","Β":"B","Γ":"G","Δ":"D","Ε":"E","Ζ":"Z","Η":"H","Θ":"8","Ι":"I","Κ":"K","Λ":"L","Μ":"M","Ν":"N","Ξ":"3","Ο":"O","Π":"P","Ρ":"R","Σ":"S","Τ":"T","Υ":"Y","Φ":"F","Χ":"X","Ψ":"PS","Ω":"W","Ϊ":"I","Ϋ":"Y","ά":"a","έ":"e","ή":"h","ί":"i","ΰ":"y","α":"a","β":"b","γ":"g","δ":"d","ε":"e","ζ":"z","η":"h","θ":"8","ι":"i","κ":"k","λ":"l","μ":"m","ν":"n","ξ":"3","ο":"o","π":"p","ρ":"r","ς":"s","σ":"s","τ":"t","υ":"y","φ":"f","χ":"x","ψ":"ps","ω":"w","ϊ":"i","ϋ":"y","ό":"o","ύ":"y","ώ":"w","Ё":"Yo","Ђ":"DJ","Є":"Ye","І":"I","Ї":"Yi","Ј":"J","Љ":"LJ","Њ":"NJ","Ћ":"C","Џ":"DZ","А":"A","Б":"B","В":"V","Г":"G","Д":"D","Е":"E","Ж":"Zh","З":"Z","И":"I","Й":"J","К":"K","Л":"L","М":"M","Н":"N","О":"O","П":"P","Р":"R","С":"S","Т":"T","У":"U","Ф":"F","Х":"H","Ц":"C","Ч":"Ch","Ш":"Sh","Щ":"Sh","Ъ":"U","Ы":"Y","Ь":"","Э":"E","Ю":"Yu","Я":"Ya","а":"a","б":"b","в":"v","г":"g","д":"d","е":"e","ж":"zh","з":"z","и":"i","й":"j","к":"k","л":"l","м":"m","н":"n","о":"o","п":"p","р":"r","с":"s","т":"t","у":"u","ф":"f","х":"h","ц":"c","ч":"ch","ш":"sh","щ":"sh","ъ":"u","ы":"y","ь":"","э":"e","ю":"yu","я":"ya","ё":"yo","ђ":"dj","є":"ye","і":"i","ї":"yi","ј":"j","љ":"lj","њ":"nj","ћ":"c","ѝ":"u","џ":"dz","Ґ":"G","ґ":"g","Ғ":"GH","ғ":"gh","Қ":"KH","қ":"kh","Ң":"NG","ң":"ng","Ү":"UE","ү":"ue","Ұ":"U","ұ":"u","Һ":"H","һ":"h","Ә":"AE","ә":"ae","Ө":"OE","ө":"oe","Ա":"A","Բ":"B","Գ":"G","Դ":"D","Ե":"E","Զ":"Z","Է":"E\'","Ը":"Y\'","Թ":"T\'","Ժ":"JH","Ի":"I","Լ":"L","Խ":"X","Ծ":"C\'","Կ":"K","Հ":"H","Ձ":"D\'","Ղ":"GH","Ճ":"TW","Մ":"M","Յ":"Y","Ն":"N","Շ":"SH","Չ":"CH","Պ":"P","Ջ":"J","Ռ":"R\'","Ս":"S","Վ":"V","Տ":"T","Ր":"R","Ց":"C","Փ":"P\'","Ք":"Q\'","Օ":"O\'\'","Ֆ":"F","և":"EV","ء":"a","آ":"aa","أ":"a","ؤ":"u","إ":"i","ئ":"e","ا":"a","ب":"b","ة":"h","ت":"t","ث":"th","ج":"j","ح":"h","خ":"kh","د":"d","ذ":"th","ر":"r","ز":"z","س":"s","ش":"sh","ص":"s","ض":"dh","ط":"t","ظ":"z","ع":"a","غ":"gh","ف":"f","ق":"q","ك":"k","ل":"l","م":"m","ن":"n","ه":"h","و":"w","ى":"a","ي":"y","ً":"an","ٌ":"on","ٍ":"en","َ":"a","ُ":"u","ِ":"e","ْ":"","٠":"0","١":"1","٢":"2","٣":"3","٤":"4","٥":"5","٦":"6","٧":"7","٨":"8","٩":"9","پ":"p","چ":"ch","ژ":"zh","ک":"k","گ":"g","ی":"y","۰":"0","۱":"1","۲":"2","۳":"3","۴":"4","۵":"5","۶":"6","۷":"7","۸":"8","۹":"9","฿":"baht","ა":"a","ბ":"b","გ":"g","დ":"d","ე":"e","ვ":"v","ზ":"z","თ":"t","ი":"i","კ":"k","ლ":"l","მ":"m","ნ":"n","ო":"o","პ":"p","ჟ":"zh","რ":"r","ს":"s","ტ":"t","უ":"u","ფ":"f","ქ":"k","ღ":"gh","ყ":"q","შ":"sh","ჩ":"ch","ც":"ts","ძ":"dz","წ":"ts","ჭ":"ch","ხ":"kh","ჯ":"j","ჰ":"h","Ṣ":"S","ṣ":"s","Ẁ":"W","ẁ":"w","Ẃ":"W","ẃ":"w","Ẅ":"W","ẅ":"w","ẞ":"SS","Ạ":"A","ạ":"a","Ả":"A","ả":"a","Ấ":"A","ấ":"a","Ầ":"A","ầ":"a","Ẩ":"A","ẩ":"a","Ẫ":"A","ẫ":"a","Ậ":"A","ậ":"a","Ắ":"A","ắ":"a","Ằ":"A","ằ":"a","Ẳ":"A","ẳ":"a","Ẵ":"A","ẵ":"a","Ặ":"A","ặ":"a","Ẹ":"E","ẹ":"e","Ẻ":"E","ẻ":"e","Ẽ":"E","ẽ":"e","Ế":"E","ế":"e","Ề":"E","ề":"e","Ể":"E","ể":"e","Ễ":"E","ễ":"e","Ệ":"E","ệ":"e","Ỉ":"I","ỉ":"i","Ị":"I","ị":"i","Ọ":"O","ọ":"o","Ỏ":"O","ỏ":"o","Ố":"O","ố":"o","Ồ":"O","ồ":"o","Ổ":"O","ổ":"o","Ỗ":"O","ỗ":"o","Ộ":"O","ộ":"o","Ớ":"O","ớ":"o","Ờ":"O","ờ":"o","Ở":"O","ở":"o","Ỡ":"O","ỡ":"o","Ợ":"O","ợ":"o","Ụ":"U","ụ":"u","Ủ":"U","ủ":"u","Ứ":"U","ứ":"u","Ừ":"U","ừ":"u","Ử":"U","ử":"u","Ữ":"U","ữ":"u","Ự":"U","ự":"u","Ỳ":"Y","ỳ":"y","Ỵ":"Y","ỵ":"y","Ỷ":"Y","ỷ":"y","Ỹ":"Y","ỹ":"y","–":"-","‘":"\'","’":"\'","“":"\\"","”":"\\"","„":"\\"","†":"+","•":"*","…":"...","₠":"ecu","₢":"cruzeiro","₣":"french franc","₤":"lira","₥":"mill","₦":"naira","₧":"peseta","₨":"rupee","₩":"won","₪":"new shequel","₫":"dong","€":"euro","₭":"kip","₮":"tugrik","₯":"drachma","₰":"penny","₱":"peso","₲":"guarani","₳":"austral","₴":"hryvnia","₵":"cedi","₸":"kazakhstani tenge","₹":"indian rupee","₺":"turkish lira","₽":"russian ruble","₿":"bitcoin","℠":"sm","™":"tm","∂":"d","∆":"delta","∑":"sum","∞":"infinity","♥":"love","元":"yuan","円":"yen","﷼":"rial","ﻵ":"laa","ﻷ":"laa","ﻹ":"lai","ﻻ":"la"}');
    var locales = JSON.parse('{"bg":{"Й":"Y","Ц":"Ts","Щ":"Sht","Ъ":"A","Ь":"Y","й":"y","ц":"ts","щ":"sht","ъ":"a","ь":"y"},"de":{"Ä":"AE","ä":"ae","Ö":"OE","ö":"oe","Ü":"UE","ü":"ue","ß":"ss","%":"prozent","&":"und","|":"oder","∑":"summe","∞":"unendlich","♥":"liebe"},"es":{"%":"por ciento","&":"y","<":"menor que",">":"mayor que","|":"o","¢":"centavos","£":"libras","¤":"moneda","₣":"francos","∑":"suma","∞":"infinito","♥":"amor"},"fr":{"%":"pourcent","&":"et","<":"plus petit",">":"plus grand","|":"ou","¢":"centime","£":"livre","¤":"devise","₣":"franc","∑":"somme","∞":"infini","♥":"amour"},"pt":{"%":"porcento","&":"e","<":"menor",">":"maior","|":"ou","¢":"centavo","∑":"soma","£":"libra","∞":"infinito","♥":"amor"},"uk":{"И":"Y","и":"y","Й":"Y","й":"y","Ц":"Ts","ц":"ts","Х":"Kh","х":"kh","Щ":"Shch","щ":"shch","Г":"H","г":"h"},"vi":{"Đ":"D","đ":"d"},"da":{"Ø":"OE","ø":"oe","Å":"AA","å":"aa","%":"procent","&":"og","|":"eller","$":"dollar","<":"mindre end",">":"større end"},"nb":{"&":"og","Å":"AA","Æ":"AE","Ø":"OE","å":"aa","æ":"ae","ø":"oe"},"it":{"&":"e"},"nl":{"&":"en"},"sv":{"&":"och","Å":"AA","Ä":"AE","Ö":"OE","å":"aa","ä":"ae","ö":"oe"}}');
    function replace(string, options) {
      if (typeof string !== "string") {
        throw new Error("slugify: string argument expected");
      }
      options = typeof options === "string" ? { replacement: options } : options || {};
      var locale = locales[options.locale] || {};
      var replacement = options.replacement === undefined ? "-" : options.replacement;
      var trim = options.trim === undefined ? true : options.trim;
      var slug = string.normalize().split("").reduce(function(result, ch) {
        var appendChar = locale[ch] || charMap[ch] || ch;
        if (appendChar === replacement) {
          appendChar = " ";
        }
        return result + appendChar.replace(options.remove || /[^\w\s$*_+~.()'"!\-:@]+/g, "");
      }, "");
      if (options.strict) {
        slug = slug.replace(/[^A-Za-z0-9\s]/g, "");
      }
      if (trim) {
        slug = slug.trim();
      }
      slug = slug.replace(/\s+/g, replacement);
      if (options.lower) {
        slug = slug.toLowerCase();
      }
      return slug;
    }
    replace.extend = function(customMap) {
      Object.assign(charMap, customMap);
    };
    return replace;
  });
});

// ../config/retailers/name-alternatives.json
var name_alternatives_default;
var init_name_alternatives = __esm(() => {
  name_alternatives_default = {
    academy: ["Academy Sports Outdoor", "Academy Sports"],
    apple: ["Apple Store"],
    burlington: ["Burlington Coat Factory"],
    callawaypreowned: ["Callaway Golf PreOwned"],
    columbia: ["Columbia Sportswear"],
    costco: ["Costco Wholesale"],
    cvs: ["CVS Pharmacy"],
    dsw: ["DSW Designer Shoe Warehouse"],
    eastbay: ["eastbayathleticsportsource"],
    frys: ["Frys Electronics"],
    hammacher: ["Hammacher Schlemmer"],
    heartlandvetsupply: ["heartland veterinary supply"],
    homedepot: ["The Home Depot"],
    lego: ["Lego Store"],
    lowes: ["Lowes Home Improvement"],
    michaels: ["michaels stores"],
    myotcstore: ["myotcstorehealthandbeautyonlineshop"],
    nfm: ["Nebraska Furniture Mart", "NFM"],
    pcrichardandson: ["PC Richard and Son", "P.C. Richard and Son", "PC Richard & Son", "P.C. Richard & Son"],
    rcwilley: ["RC Willey Home Furnishings", "RC Willey"],
    riteaid: ["Rite Aid Pharmacy"],
    sonos: ["sonosaudio"],
    sprouts: ["Sprouts Farmers Market"],
    walgreens: ["Walgreens Pharmacy"],
    walmart: [
      "Walmart Supercenter",
      "Walmart Neighborhood Market",
      "Walmart Express",
      "Walmart 2"
    ]
  };
});

// ../config/retailers/on-subdomains.json
var on_subdomains_default;
var init_on_subdomains = __esm(() => {
  on_subdomains_default = [
    "ebay",
    "myshopify",
    "gap",
    "mattel",
    "ricardobeverlyhills"
  ];
});

// src/prospector/verb-retailer-find.ts
function verbRetailerFind({ searchString, url }) {
  if (!searchString && !url) {
    return;
  }
  if (hasInitializedMap == false) {
    initializeRetailerNameMap();
    hasInitializedMap = true;
  }
  let cacheKey = searchString?.toLowerCase();
  let retailer = retailerSearchCache?.[cacheKey];
  if (retailer) {
    return retailer;
  }
  if (url) {
    const identifierRetailer = getRetailerIdentifierFromURL(url);
    if (identifierRetailer) {
      retailer = nounRetailersCacheGlobal[identifierRetailer];
      if (retailer) {
        if (cacheKey) {
          retailerSearchCache[cacheKey] = retailer;
        }
        return retailer;
      }
    }
  }
  if (searchString) {
    const identifierRetailer = getRetailerIdentifierFromName(searchString);
    if (identifierRetailer) {
      retailer = nounRetailersCacheGlobal[identifierRetailer];
      if (retailer) {
        retailerSearchCache[cacheKey] = retailer;
        return retailer;
      }
    }
    const slugifyOptions = { lower: true, remove: /[*+~.,()'"!:@\/]/g };
    const searchStringSlug = import_slugify.default(searchString, slugifyOptions);
    retailer = nounRetailersCacheGlobal[searchStringSlug];
    if (retailer) {
      retailerSearchCache[cacheKey] = retailer;
      return retailer;
    }
    retailer = searchRetailerByName(searchString);
    if (retailer) {
      retailerSearchCache[cacheKey] = retailer;
      return retailer;
    }
  }
  return;
}
function initializeRetailerNameMap() {
  for (const retailer of nounRetailersCacheRawGlobal) {
    if (retailer.n) {
      for (const n of retailer.n) {
        const lowercasedName = n.toLowerCase();
        retailerNameMap.set(lowercasedName, nounRetailersCacheGlobal[retailer.i]);
        retailerNameMap.set(`${lowercasedName}.com`, nounRetailersCacheGlobal[retailer.i]);
        retailerNameMap.set(`${lowercasedName}.net`, nounRetailersCacheGlobal[retailer.i]);
      }
    }
  }
}
function searchRetailerByName(searchString) {
  const searchStringLower = searchString.toLowerCase();
  return retailerNameMap.get(searchStringLower);
}
function getRetailerIdentifierFromURL(url) {
  if (!url) {
    return;
  }
  let parsed;
  try {
    parsed = new URL(url);
  } catch (e) {
    return;
  }
  if (parsed.hostname === "localhost" || par